package io

import (
	"io"

	"github.com/pelletier/go-toml"
)

func init() {
	registerInputHandler("toml", func() InputHandler { return &TOMLInputHandler{} })
}

// Declare conformance with InputHandler interface.
var _ InputHandler = &TOMLInputHandler{}

// TOMLInputHandler handles parsing TOML data.
type TOMLInputHandler struct{}

// Name implements InputHandler.Name().
func (t *TOMLInputHandler) Name() string {
	return "toml"
}

// Parse implements InputHandler.Parse().
func (t *TOMLInputHandler) Parse(reader io.Reader) (interface{}, error) {
	inputBytes, err := io.ReadAll(reader)
	if err != nil {
		return nil, err
	}

	var parsed interface{}
	err = toml.Unmarshal(inputBytes, &parsed)
	if err != nil {
		return nil, err
	}

	return parsed, nil
}

// SetOption implements InputHandler.SetOption().
func (t *TOMLInputHandler) SetOption(name string, value string) error {
	// The TOML handler does not have any options.
	return nil
}
