#!/bin/sh

# This script is similar to `make viewcoverage` except that it uses the new
# integration test coverage stuff from Go 1.20. Once 1.20 is the earliest
# supported Go compiler, this can be moved into the Makefile.
#
# resources:
#
# * https://go.dev/testing/coverage/
# * https://dustinspecker.com/posts/go-combined-unit-integration-code-coverage/

set -e
set -u
cd "$(dirname "$0")/.."
make clean
rm -rf ./cover
CWD="$(pwd)"
trap "rm -rf $CWD/cover $CWD/cover.out" EXIT
set -x

export TZ=UTC

mkdir -p ./build
go build -cover -o build/rq ./cmd/rq
export GOCOVERDIR="$CWD/cover"
mkdir -p ./cover
sh ./smoketest/smoketest.sh || true
go test -cover ./... -test.gocoverdir="$GOCOVERDIR" -timeout 30s
go tool covdata percent -i ./cover
go tool covdata textfmt -i ./cover -o cover.out
go tool cover -html=cover.out

rm -rf ./cover
