package hybridkubernetesapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/hybridkubernetes/mgmt/2021-04-01-preview/hybridkubernetes"
)

// ConnectedClusterClientAPI contains the set of methods on the ConnectedClusterClient type.
type ConnectedClusterClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, clusterName string, connectedCluster hybridkubernetes.ConnectedCluster) (result hybridkubernetes.ConnectedClusterCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, clusterName string) (result hybridkubernetes.ConnectedClusterDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, clusterName string) (result hybridkubernetes.ConnectedCluster, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result hybridkubernetes.ConnectedClusterListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result hybridkubernetes.ConnectedClusterListIterator, err error)
	ListBySubscription(ctx context.Context) (result hybridkubernetes.ConnectedClusterListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridkubernetes.ConnectedClusterListIterator, err error)
	ListClusterUserCredentials(ctx context.Context, resourceGroupName string, clusterName string, properties hybridkubernetes.ListClusterUserCredentialsProperties) (result hybridkubernetes.CredentialResults, err error)
	Update(ctx context.Context, resourceGroupName string, clusterName string, connectedClusterPatch hybridkubernetes.ConnectedClusterPatch) (result hybridkubernetes.ConnectedClusterUpdateFuture, err error)
}

var _ ConnectedClusterClientAPI = (*hybridkubernetes.ConnectedClusterClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	Get(ctx context.Context) (result hybridkubernetes.OperationListPage, err error)
	GetComplete(ctx context.Context) (result hybridkubernetes.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*hybridkubernetes.OperationsClient)(nil)
