package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepositoryTags invokes the codeup.ListRepositoryTags API synchronously
func (client *Client) ListRepositoryTags(request *ListRepositoryTagsRequest) (response *ListRepositoryTagsResponse, err error) {
	response = CreateListRepositoryTagsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepositoryTagsWithChan invokes the codeup.ListRepositoryTags API asynchronously
func (client *Client) ListRepositoryTagsWithChan(request *ListRepositoryTagsRequest) (<-chan *ListRepositoryTagsResponse, <-chan error) {
	responseChan := make(chan *ListRepositoryTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepositoryTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepositoryTagsWithCallback invokes the codeup.ListRepositoryTags API asynchronously
func (client *Client) ListRepositoryTagsWithCallback(request *ListRepositoryTagsRequest, callback func(response *ListRepositoryTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepositoryTagsResponse
		var err error
		defer close(result)
		response, err = client.ListRepositoryTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepositoryTagsRequest is the request struct for api ListRepositoryTags
type ListRepositoryTagsRequest struct {
	*requests.RoaRequest
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ShowSignature  requests.Boolean `position:"Query" name:"ShowSignature"`
	Sort           string           `position:"Query" name:"Sort"`
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	Search         string           `position:"Query" name:"Search"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Page           requests.Integer `position:"Query" name:"Page"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// ListRepositoryTagsResponse is the response struct for api ListRepositoryTags
type ListRepositoryTagsResponse struct {
	*responses.BaseResponse
	RequestId    string                           `json:"RequestId" xml:"RequestId"`
	ErrorCode    string                           `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool                             `json:"Success" xml:"Success"`
	ErrorMessage string                           `json:"ErrorMessage" xml:"ErrorMessage"`
	Total        int64                            `json:"Total" xml:"Total"`
	Result       []ResultItemInListRepositoryTags `json:"Result" xml:"Result"`
}

// CreateListRepositoryTagsRequest creates a request to invoke ListRepositoryTags API
func CreateListRepositoryTagsRequest() (request *ListRepositoryTagsRequest) {
	request = &ListRepositoryTagsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListRepositoryTags", "/api/v4/projects/[ProjectId]/repository/tags", "", "")
	request.Method = requests.GET
	return
}

// CreateListRepositoryTagsResponse creates a response to parse from ListRepositoryTags response
func CreateListRepositoryTagsResponse() (response *ListRepositoryTagsResponse) {
	response = &ListRepositoryTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
