package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateResourceConfigurationTimeline invokes the config.GetAggregateResourceConfigurationTimeline API synchronously
func (client *Client) GetAggregateResourceConfigurationTimeline(request *GetAggregateResourceConfigurationTimelineRequest) (response *GetAggregateResourceConfigurationTimelineResponse, err error) {
	response = CreateGetAggregateResourceConfigurationTimelineResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateResourceConfigurationTimelineWithChan invokes the config.GetAggregateResourceConfigurationTimeline API asynchronously
func (client *Client) GetAggregateResourceConfigurationTimelineWithChan(request *GetAggregateResourceConfigurationTimelineRequest) (<-chan *GetAggregateResourceConfigurationTimelineResponse, <-chan error) {
	responseChan := make(chan *GetAggregateResourceConfigurationTimelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateResourceConfigurationTimeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateResourceConfigurationTimelineWithCallback invokes the config.GetAggregateResourceConfigurationTimeline API asynchronously
func (client *Client) GetAggregateResourceConfigurationTimelineWithCallback(request *GetAggregateResourceConfigurationTimelineRequest, callback func(response *GetAggregateResourceConfigurationTimelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateResourceConfigurationTimelineResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateResourceConfigurationTimeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateResourceConfigurationTimelineRequest is the request struct for api GetAggregateResourceConfigurationTimeline
type GetAggregateResourceConfigurationTimelineRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AggregatorId    string           `position:"Query" name:"AggregatorId"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	NextToken       string           `position:"Query" name:"NextToken"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
	Region          string           `position:"Query" name:"Region"`
}

// GetAggregateResourceConfigurationTimelineResponse is the response struct for api GetAggregateResourceConfigurationTimeline
type GetAggregateResourceConfigurationTimelineResponse struct {
	*responses.BaseResponse
	RequestId                     string                        `json:"RequestId" xml:"RequestId"`
	ResourceConfigurationTimeline ResourceConfigurationTimeline `json:"ResourceConfigurationTimeline" xml:"ResourceConfigurationTimeline"`
}

// CreateGetAggregateResourceConfigurationTimelineRequest creates a request to invoke GetAggregateResourceConfigurationTimeline API
func CreateGetAggregateResourceConfigurationTimelineRequest() (request *GetAggregateResourceConfigurationTimelineRequest) {
	request = &GetAggregateResourceConfigurationTimelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateResourceConfigurationTimeline", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAggregateResourceConfigurationTimelineResponse creates a response to parse from GetAggregateResourceConfigurationTimeline response
func CreateGetAggregateResourceConfigurationTimelineResponse() (response *GetAggregateResourceConfigurationTimelineResponse) {
	response = &GetAggregateResourceConfigurationTimelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
