package mopen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoPenDeleteGroup invokes the mopen.MoPenDeleteGroup API synchronously
// api document: https://help.aliyun.com/api/mopen/mopendeletegroup.html
func (client *Client) MoPenDeleteGroup(request *MoPenDeleteGroupRequest) (response *MoPenDeleteGroupResponse, err error) {
	response = CreateMoPenDeleteGroupResponse()
	err = client.DoAction(request, response)
	return
}

// MoPenDeleteGroupWithChan invokes the mopen.MoPenDeleteGroup API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopendeletegroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenDeleteGroupWithChan(request *MoPenDeleteGroupRequest) (<-chan *MoPenDeleteGroupResponse, <-chan error) {
	responseChan := make(chan *MoPenDeleteGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoPenDeleteGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoPenDeleteGroupWithCallback invokes the mopen.MoPenDeleteGroup API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopendeletegroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenDeleteGroupWithCallback(request *MoPenDeleteGroupRequest, callback func(response *MoPenDeleteGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoPenDeleteGroupResponse
		var err error
		defer close(result)
		response, err = client.MoPenDeleteGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoPenDeleteGroupRequest is the request struct for api MoPenDeleteGroup
type MoPenDeleteGroupRequest struct {
	*requests.RpcRequest
	GroupId string `position:"Body" name:"GroupId"`
}

// MoPenDeleteGroupResponse is the response struct for api MoPenDeleteGroup
type MoPenDeleteGroupResponse struct {
	*responses.BaseResponse
	Success     bool   `json:"Success" xml:"Success"`
	Code        string `json:"Code" xml:"Code"`
	Message     string `json:"Message" xml:"Message"`
	Description string `json:"Description" xml:"Description"`
}

// CreateMoPenDeleteGroupRequest creates a request to invoke MoPenDeleteGroup API
func CreateMoPenDeleteGroupRequest() (request *MoPenDeleteGroupRequest) {
	request = &MoPenDeleteGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("MoPen", "2018-02-11", "MoPenDeleteGroup", "mopen", "openAPI")
	return
}

// CreateMoPenDeleteGroupResponse creates a response to parse from MoPenDeleteGroup response
func CreateMoPenDeleteGroupResponse() (response *MoPenDeleteGroupResponse) {
	response = &MoPenDeleteGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
