package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSharedReports invokes the quickbi_public.ListSharedReports API synchronously
func (client *Client) ListSharedReports(request *ListSharedReportsRequest) (response *ListSharedReportsResponse, err error) {
	response = CreateListSharedReportsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSharedReportsWithChan invokes the quickbi_public.ListSharedReports API asynchronously
func (client *Client) ListSharedReportsWithChan(request *ListSharedReportsRequest) (<-chan *ListSharedReportsResponse, <-chan error) {
	responseChan := make(chan *ListSharedReportsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSharedReports(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSharedReportsWithCallback invokes the quickbi_public.ListSharedReports API asynchronously
func (client *Client) ListSharedReportsWithCallback(request *ListSharedReportsRequest, callback func(response *ListSharedReportsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSharedReportsResponse
		var err error
		defer close(result)
		response, err = client.ListSharedReports(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSharedReportsRequest is the request struct for api ListSharedReports
type ListSharedReportsRequest struct {
	*requests.RpcRequest
	TreeType    string           `position:"Query" name:"TreeType"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	SignType    string           `position:"Query" name:"SignType"`
	Keyword     string           `position:"Query" name:"Keyword"`
	UserId      string           `position:"Query" name:"UserId"`
}

// ListSharedReportsResponse is the response struct for api ListSharedReports
type ListSharedReportsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListSharedReportsRequest creates a request to invoke ListSharedReports API
func CreateListSharedReportsRequest() (request *ListSharedReportsRequest) {
	request = &ListSharedReportsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-08-09", "ListSharedReports", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSharedReportsResponse creates a response to parse from ListSharedReports response
func CreateListSharedReportsResponse() (response *ListSharedReportsResponse) {
	response = &ListSharedReportsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
