package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAncestors invokes the resourcemanager.ListAncestors API synchronously
func (client *Client) ListAncestors(request *ListAncestorsRequest) (response *ListAncestorsResponse, err error) {
	response = CreateListAncestorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAncestorsWithChan invokes the resourcemanager.ListAncestors API asynchronously
func (client *Client) ListAncestorsWithChan(request *ListAncestorsRequest) (<-chan *ListAncestorsResponse, <-chan error) {
	responseChan := make(chan *ListAncestorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAncestors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAncestorsWithCallback invokes the resourcemanager.ListAncestors API asynchronously
func (client *Client) ListAncestorsWithCallback(request *ListAncestorsRequest, callback func(response *ListAncestorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAncestorsResponse
		var err error
		defer close(result)
		response, err = client.ListAncestors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAncestorsRequest is the request struct for api ListAncestors
type ListAncestorsRequest struct {
	*requests.RpcRequest
	ChildId string `position:"Query" name:"ChildId"`
}

// ListAncestorsResponse is the response struct for api ListAncestors
type ListAncestorsResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Folders   FoldersInListAncestors `json:"Folders" xml:"Folders"`
}

// CreateListAncestorsRequest creates a request to invoke ListAncestors API
func CreateListAncestorsRequest() (request *ListAncestorsRequest) {
	request = &ListAncestorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListAncestors", "", "")
	request.Method = requests.POST
	return
}

// CreateListAncestorsResponse creates a response to parse from ListAncestors response
func CreateListAncestorsResponse() (response *ListAncestorsResponse) {
	response = &ListAncestorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
