package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetImageUrl invokes the unimkt.GetImageUrl API synchronously
func (client *Client) GetImageUrl(request *GetImageUrlRequest) (response *GetImageUrlResponse, err error) {
	response = CreateGetImageUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetImageUrlWithChan invokes the unimkt.GetImageUrl API asynchronously
func (client *Client) GetImageUrlWithChan(request *GetImageUrlRequest) (<-chan *GetImageUrlResponse, <-chan error) {
	responseChan := make(chan *GetImageUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetImageUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetImageUrlWithCallback invokes the unimkt.GetImageUrl API asynchronously
func (client *Client) GetImageUrlWithCallback(request *GetImageUrlRequest, callback func(response *GetImageUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetImageUrlResponse
		var err error
		defer close(result)
		response, err = client.GetImageUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetImageUrlRequest is the request struct for api GetImageUrl
type GetImageUrlRequest struct {
	*requests.RpcRequest
	CommodityId string `position:"Query" name:"CommodityId"`
}

// GetImageUrlResponse is the response struct for api GetImageUrl
type GetImageUrlResponse struct {
	*responses.BaseResponse
	Status      bool   `json:"Status" xml:"Status"`
	Msg         string `json:"Msg" xml:"Msg"`
	ImageUrl    string `json:"ImageUrl" xml:"ImageUrl"`
	ErrorCode   string `json:"ErrorCode" xml:"ErrorCode"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	CreatedTime string `json:"CreatedTime" xml:"CreatedTime"`
	UpdatedTime string `json:"UpdatedTime" xml:"UpdatedTime"`
}

// CreateGetImageUrlRequest creates a request to invoke GetImageUrl API
func CreateGetImageUrlRequest() (request *GetImageUrlRequest) {
	request = &GetImageUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-07", "GetImageUrl", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetImageUrlResponse creates a response to parse from GetImageUrl response
func CreateGetImageUrlResponse() (response *GetImageUrlResponse) {
	response = &GetImageUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
