package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetVodDomainCertificate invokes the vod.SetVodDomainCertificate API synchronously
func (client *Client) SetVodDomainCertificate(request *SetVodDomainCertificateRequest) (response *SetVodDomainCertificateResponse, err error) {
	response = CreateSetVodDomainCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// SetVodDomainCertificateWithChan invokes the vod.SetVodDomainCertificate API asynchronously
func (client *Client) SetVodDomainCertificateWithChan(request *SetVodDomainCertificateRequest) (<-chan *SetVodDomainCertificateResponse, <-chan error) {
	responseChan := make(chan *SetVodDomainCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetVodDomainCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetVodDomainCertificateWithCallback invokes the vod.SetVodDomainCertificate API asynchronously
func (client *Client) SetVodDomainCertificateWithCallback(request *SetVodDomainCertificateRequest, callback func(response *SetVodDomainCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetVodDomainCertificateResponse
		var err error
		defer close(result)
		response, err = client.SetVodDomainCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetVodDomainCertificateRequest is the request struct for api SetVodDomainCertificate
type SetVodDomainCertificateRequest struct {
	*requests.RpcRequest
	SSLProtocol   string           `position:"Query" name:"SSLProtocol"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	SSLPri        string           `position:"Query" name:"SSLPri"`
	CertName      string           `position:"Query" name:"CertName"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SSLPub        string           `position:"Query" name:"SSLPub"`
	Region        string           `position:"Query" name:"Region"`
}

// SetVodDomainCertificateResponse is the response struct for api SetVodDomainCertificate
type SetVodDomainCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetVodDomainCertificateRequest creates a request to invoke SetVodDomainCertificate API
func CreateSetVodDomainCertificateRequest() (request *SetVodDomainCertificateRequest) {
	request = &SetVodDomainCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SetVodDomainCertificate", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetVodDomainCertificateResponse creates a response to parse from SetVodDomainCertificate response
func CreateSetVodDomainCertificateResponse() (response *SetVodDomainCertificateResponse) {
	response = &SetVodDomainCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
