package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsStorageUsageData invokes the vs.DescribeVsStorageUsageData API synchronously
func (client *Client) DescribeVsStorageUsageData(request *DescribeVsStorageUsageDataRequest) (response *DescribeVsStorageUsageDataResponse, err error) {
	response = CreateDescribeVsStorageUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsStorageUsageDataWithChan invokes the vs.DescribeVsStorageUsageData API asynchronously
func (client *Client) DescribeVsStorageUsageDataWithChan(request *DescribeVsStorageUsageDataRequest) (<-chan *DescribeVsStorageUsageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsStorageUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsStorageUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsStorageUsageDataWithCallback invokes the vs.DescribeVsStorageUsageData API asynchronously
func (client *Client) DescribeVsStorageUsageDataWithCallback(request *DescribeVsStorageUsageDataRequest, callback func(response *DescribeVsStorageUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsStorageUsageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsStorageUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsStorageUsageDataRequest is the request struct for api DescribeVsStorageUsageData
type DescribeVsStorageUsageDataRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	SplitBy   string           `position:"Query" name:"SplitBy"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	Bucket    string           `position:"Query" name:"Bucket"`
	Interval  string           `position:"Query" name:"Interval"`
}

// DescribeVsStorageUsageDataResponse is the response struct for api DescribeVsStorageUsageData
type DescribeVsStorageUsageDataResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	StorageUsage StorageUsage `json:"StorageUsage" xml:"StorageUsage"`
}

// CreateDescribeVsStorageUsageDataRequest creates a request to invoke DescribeVsStorageUsageData API
func CreateDescribeVsStorageUsageDataRequest() (request *DescribeVsStorageUsageDataRequest) {
	request = &DescribeVsStorageUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsStorageUsageData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsStorageUsageDataResponse creates a response to parse from DescribeVsStorageUsageData response
func CreateDescribeVsStorageUsageDataResponse() (response *DescribeVsStorageUsageDataResponse) {
	response = &DescribeVsStorageUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
