// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        (unknown)
// source: coinbase/cloud/mpc_keys/v1/mpc_keys.proto

package v1

import (
	v1 "github.com/coinbase/waas-client-library-go/gen/go/coinbase/crypto/types/v1"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The Device resource, which represents a single participant in the MPC protocol.
type Device struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Device.
	// Format: devices/{device_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Device) Reset() {
	*x = Device{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{0}
}

func (x *Device) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A child of a Seed in an HD tree that was produced using hardened derivation,
// as defined in BIP-32. All MPCKeys descend from a HardenedChild.
type HardenedChild struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The derivation path to reach the hardened child from the Seed (i.e., the root
	// of the HD tree). Each integer in the derivation path is interpreted according
	// to BIP-44: m / purpose’ / coin_type’ / account’ / change / address_index.
	DerivationPath []int32 `protobuf:"varint,1,rep,packed,name=derivation_path,json=derivationPath,proto3" json:"derivation_path,omitempty"`
}

func (x *HardenedChild) Reset() {
	*x = HardenedChild{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HardenedChild) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HardenedChild) ProtoMessage() {}

func (x *HardenedChild) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HardenedChild.ProtoReflect.Descriptor instead.
func (*HardenedChild) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{1}
}

func (x *HardenedChild) GetDerivationPath() []int32 {
	if x != nil {
		return x.DerivationPath
	}
	return nil
}

// A byte sequence at the root of a hierarchically deterministic (HD) wallet
// as defined in BIP-32. A DeviceGroup has exactly one Seed.
type Seed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hardened children derived from the Seed. To create an MPCKey,
	// at least one hardened child must be derived.
	HardenedChildren []*HardenedChild `protobuf:"bytes,1,rep,name=hardened_children,json=hardenedChildren,proto3" json:"hardened_children,omitempty"`
	// The metadata to be used to export MPCKeys derived from this Seed. This metadata has to be passed to the
	// WaaS SDK's ExportPrivateKeys to export private keys corresponding to MPCKeys that are derived from this Seed's
	// HardenedChildren.
	MpcKeyExportMetadata []byte `protobuf:"bytes,2,opt,name=mpc_key_export_metadata,json=mpcKeyExportMetadata,proto3" json:"mpc_key_export_metadata,omitempty"`
}

func (x *Seed) Reset() {
	*x = Seed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Seed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Seed) ProtoMessage() {}

func (x *Seed) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Seed.ProtoReflect.Descriptor instead.
func (*Seed) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{2}
}

func (x *Seed) GetHardenedChildren() []*HardenedChild {
	if x != nil {
		return x.HardenedChildren
	}
	return nil
}

func (x *Seed) GetMpcKeyExportMetadata() []byte {
	if x != nil {
		return x.MpcKeyExportMetadata
	}
	return nil
}

// The DeviceGroup resource, which represents a collection of Devices that have access to the
// same set of Seed resources.
type DeviceGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The list of Device resource names associated with this DeviceGroup. On creation,
	// this list must have exactly one Device set.
	// Format: devices/{device_id}
	Devices []string `protobuf:"bytes,2,rep,name=devices,proto3" json:"devices,omitempty"`
	// The Seed that corresponds to the DeviceGroup. On creation, the Seed must
	// have at least one HardenedChild set.
	Seed *Seed `protobuf:"bytes,3,opt,name=seed,proto3" json:"seed,omitempty"`
}

func (x *DeviceGroup) Reset() {
	*x = DeviceGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceGroup) ProtoMessage() {}

func (x *DeviceGroup) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceGroup.ProtoReflect.Descriptor instead.
func (*DeviceGroup) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{3}
}

func (x *DeviceGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeviceGroup) GetDevices() []string {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *DeviceGroup) GetSeed() *Seed {
	if x != nil {
		return x.Seed
	}
	return nil
}

// The MPCOperation resource, which represents a pending MPC operation of a DeviceGroup
// waiting for computation. Poll the ListMPCOperations method for these pending MPCOperations,
// and use the WaaS SDK's ComputeMPCOperation to complete the operation.
// The MPCOperation resource ID is guaranteed to be the same as that of the underlying
// long-running operation.
type MPCOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCOperation.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}/mpcOperations/{mpc_operation_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data that should be passed to the WaaS SDK's computeMPCOperation function
	// to complete the operation.
	MpcData []byte `protobuf:"bytes,2,opt,name=mpc_data,json=mpcData,proto3" json:"mpc_data,omitempty"`
	// Metadata related to the MPC operation.
	//
	// Types that are assignable to Metadata:
	//	*MPCOperation_CreateDeviceGroupMetadata
	//	*MPCOperation_CreateSignatureMetadata
	//	*MPCOperation_PrepareDeviceArchiveMetadata
	//	*MPCOperation_PrepareDeviceBackupMetadata
	//	*MPCOperation_AddDeviceMetadata
	Metadata isMPCOperation_Metadata `protobuf_oneof:"metadata"`
}

func (x *MPCOperation) Reset() {
	*x = MPCOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MPCOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MPCOperation) ProtoMessage() {}

func (x *MPCOperation) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MPCOperation.ProtoReflect.Descriptor instead.
func (*MPCOperation) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{4}
}

func (x *MPCOperation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MPCOperation) GetMpcData() []byte {
	if x != nil {
		return x.MpcData
	}
	return nil
}

func (m *MPCOperation) GetMetadata() isMPCOperation_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *MPCOperation) GetCreateDeviceGroupMetadata() *CreateDeviceGroupMetadata {
	if x, ok := x.GetMetadata().(*MPCOperation_CreateDeviceGroupMetadata); ok {
		return x.CreateDeviceGroupMetadata
	}
	return nil
}

func (x *MPCOperation) GetCreateSignatureMetadata() *CreateSignatureMetadata {
	if x, ok := x.GetMetadata().(*MPCOperation_CreateSignatureMetadata); ok {
		return x.CreateSignatureMetadata
	}
	return nil
}

func (x *MPCOperation) GetPrepareDeviceArchiveMetadata() *PrepareDeviceArchiveMetadata {
	if x, ok := x.GetMetadata().(*MPCOperation_PrepareDeviceArchiveMetadata); ok {
		return x.PrepareDeviceArchiveMetadata
	}
	return nil
}

func (x *MPCOperation) GetPrepareDeviceBackupMetadata() *PrepareDeviceBackupMetadata {
	if x, ok := x.GetMetadata().(*MPCOperation_PrepareDeviceBackupMetadata); ok {
		return x.PrepareDeviceBackupMetadata
	}
	return nil
}

func (x *MPCOperation) GetAddDeviceMetadata() *AddDeviceMetadata {
	if x, ok := x.GetMetadata().(*MPCOperation_AddDeviceMetadata); ok {
		return x.AddDeviceMetadata
	}
	return nil
}

type isMPCOperation_Metadata interface {
	isMPCOperation_Metadata()
}

type MPCOperation_CreateDeviceGroupMetadata struct {
	// Metadata associated with the CreateDeviceGroup long-running operation.
	CreateDeviceGroupMetadata *CreateDeviceGroupMetadata `protobuf:"bytes,3,opt,name=create_device_group_metadata,json=createDeviceGroupMetadata,proto3,oneof"`
}

type MPCOperation_CreateSignatureMetadata struct {
	// Metadata associated with the CreateSignature long-running operation.
	CreateSignatureMetadata *CreateSignatureMetadata `protobuf:"bytes,4,opt,name=create_signature_metadata,json=createSignatureMetadata,proto3,oneof"`
}

type MPCOperation_PrepareDeviceArchiveMetadata struct {
	// Metadata associated with the PrepareDeviceArchive long-running operation.
	PrepareDeviceArchiveMetadata *PrepareDeviceArchiveMetadata `protobuf:"bytes,5,opt,name=prepare_device_archive_metadata,json=prepareDeviceArchiveMetadata,proto3,oneof"`
}

type MPCOperation_PrepareDeviceBackupMetadata struct {
	// Metadata associated with the PrepareDeviceBackup long-running operation.
	PrepareDeviceBackupMetadata *PrepareDeviceBackupMetadata `protobuf:"bytes,6,opt,name=prepare_device_backup_metadata,json=prepareDeviceBackupMetadata,proto3,oneof"`
}

type MPCOperation_AddDeviceMetadata struct {
	// Metadata associated with the AddDevice long-running operation.
	AddDeviceMetadata *AddDeviceMetadata `protobuf:"bytes,7,opt,name=add_device_metadata,json=addDeviceMetadata,proto3,oneof"`
}

func (*MPCOperation_CreateDeviceGroupMetadata) isMPCOperation_Metadata() {}

func (*MPCOperation_CreateSignatureMetadata) isMPCOperation_Metadata() {}

func (*MPCOperation_PrepareDeviceArchiveMetadata) isMPCOperation_Metadata() {}

func (*MPCOperation_PrepareDeviceBackupMetadata) isMPCOperation_Metadata() {}

func (*MPCOperation_AddDeviceMetadata) isMPCOperation_Metadata() {}

// The MPCKey resource. An MPCKey can be used to participate in distributed M-of-N signing
// via the WaaS SDK. An MPCKey is created from a Seed.
type MPCKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCKey.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}/mpcKeys/{mpc_key_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The derivation path to reach this MPCKey from the Seed (i.e., the root
	// of the HD tree). There must be a HardenedChild in the Seed of the parent
	// DeviceGroup which is a prefix of this derivation path.
	// Each integer in the derivation path is interpreted according
	// to BIP-44: m / purpose’ / coin_type’ / account’ / change / address_index.
	DerivationPath []int32 `protobuf:"varint,2,rep,packed,name=derivation_path,json=derivationPath,proto3" json:"derivation_path,omitempty"`
	// The public portion of the MPCKey.
	PublicKey *v1.PublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
}

func (x *MPCKey) Reset() {
	*x = MPCKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MPCKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MPCKey) ProtoMessage() {}

func (x *MPCKey) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MPCKey.ProtoReflect.Descriptor instead.
func (*MPCKey) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{5}
}

func (x *MPCKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MPCKey) GetDerivationPath() []int32 {
	if x != nil {
		return x.DerivationPath
	}
	return nil
}

func (x *MPCKey) GetPublicKey() *v1.PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

// The Signature resource. Signatures can be created with distributed M-of-N signing
// using MPCKeys via the WaaS SDK.
type Signature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Signature.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}/mpcKeys/{mpc_key_id}/signatures/{signature_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The payload to sign with the MPCKey.
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// The payload which has been signed with the MPCKey.
	Signature *v1.Signature `protobuf:"bytes,3,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *Signature) Reset() {
	*x = Signature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signature) ProtoMessage() {}

func (x *Signature) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signature.ProtoReflect.Descriptor instead.
func (*Signature) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{6}
}

func (x *Signature) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Signature) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *Signature) GetSignature() *v1.Signature {
	if x != nil {
		return x.Signature
	}
	return nil
}

// The request message for RegisterDevice.
type RegisterDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data required to register the Device. This should be gotten from the WaaS SDK's
	// getRegistrationData method.
	RegistrationData []byte `protobuf:"bytes,1,opt,name=registration_data,json=registrationData,proto3" json:"registration_data,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *RegisterDeviceRequest) Reset() {
	*x = RegisterDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterDeviceRequest) ProtoMessage() {}

func (x *RegisterDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterDeviceRequest.ProtoReflect.Descriptor instead.
func (*RegisterDeviceRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{7}
}

func (x *RegisterDeviceRequest) GetRegistrationData() []byte {
	if x != nil {
		return x.RegistrationData
	}
	return nil
}

func (x *RegisterDeviceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request message for GetDevice.
type GetDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Device.
	// Format: devices/{device_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeviceRequest) Reset() {
	*x = GetDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceRequest) ProtoMessage() {}

func (x *GetDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{8}
}

func (x *GetDeviceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for CreateDeviceGroup.
type CreateDeviceGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Pool.
	// Format: pools/{pool_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The DeviceGroup to be created. This must contain exactly one registered Device, and
	// the contained Seed must have at least one HardenedChild.
	DeviceGroup *DeviceGroup `protobuf:"bytes,2,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	// Optional: the ID to use for the DeviceGroup, which will become the final component
	// of the DeviceGroup's resource name. If not provided, the server will assign a DeviceGroup ID
	// automatically.
	DeviceGroupId string `protobuf:"bytes,3,opt,name=device_group_id,json=deviceGroupId,proto3" json:"device_group_id,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateDeviceGroupRequest) Reset() {
	*x = CreateDeviceGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeviceGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeviceGroupRequest) ProtoMessage() {}

func (x *CreateDeviceGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeviceGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateDeviceGroupRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{9}
}

func (x *CreateDeviceGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeviceGroupRequest) GetDeviceGroup() *DeviceGroup {
	if x != nil {
		return x.DeviceGroup
	}
	return nil
}

func (x *CreateDeviceGroupRequest) GetDeviceGroupId() string {
	if x != nil {
		return x.DeviceGroupId
	}
	return ""
}

func (x *CreateDeviceGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Metadata associated with the CreateDeviceGroup long-running operation.
type CreateDeviceGroupMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to poll using ListMPCOperations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
}

func (x *CreateDeviceGroupMetadata) Reset() {
	*x = CreateDeviceGroupMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeviceGroupMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeviceGroupMetadata) ProtoMessage() {}

func (x *CreateDeviceGroupMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeviceGroupMetadata.ProtoReflect.Descriptor instead.
func (*CreateDeviceGroupMetadata) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{10}
}

func (x *CreateDeviceGroupMetadata) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

// The request message for GetDeviceGroup.
type GetDeviceGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeviceGroupRequest) Reset() {
	*x = GetDeviceGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeviceGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceGroupRequest) ProtoMessage() {}

func (x *GetDeviceGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceGroupRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceGroupRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{11}
}

func (x *GetDeviceGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for ListMPCOperations.
type ListMPCOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent DeviceGroup.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListMPCOperationsRequest) Reset() {
	*x = ListMPCOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMPCOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMPCOperationsRequest) ProtoMessage() {}

func (x *ListMPCOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMPCOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListMPCOperationsRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{12}
}

func (x *ListMPCOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// The response message for ListMPCOperations.
type ListMPCOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of MPCOperations.
	MpcOperations []*MPCOperation `protobuf:"bytes,1,rep,name=mpc_operations,json=mpcOperations,proto3" json:"mpc_operations,omitempty"`
}

func (x *ListMPCOperationsResponse) Reset() {
	*x = ListMPCOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMPCOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMPCOperationsResponse) ProtoMessage() {}

func (x *ListMPCOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMPCOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListMPCOperationsResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{13}
}

func (x *ListMPCOperationsResponse) GetMpcOperations() []*MPCOperation {
	if x != nil {
		return x.MpcOperations
	}
	return nil
}

// The request message for CreateMPCKey.
type CreateMPCKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent DeviceGroup.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The MPCKey to be created.
	MpcKey *MPCKey `protobuf:"bytes,2,opt,name=mpc_key,json=mpcKey,proto3" json:"mpc_key,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMPCKeyRequest) Reset() {
	*x = CreateMPCKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMPCKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMPCKeyRequest) ProtoMessage() {}

func (x *CreateMPCKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMPCKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateMPCKeyRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{14}
}

func (x *CreateMPCKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMPCKeyRequest) GetMpcKey() *MPCKey {
	if x != nil {
		return x.MpcKey
	}
	return nil
}

func (x *CreateMPCKeyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request message for GetMPCKey.
type GetMPCKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCKey.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}/mpcKeys/{mpc_key_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMPCKeyRequest) Reset() {
	*x = GetMPCKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMPCKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMPCKeyRequest) ProtoMessage() {}

func (x *GetMPCKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMPCKeyRequest.ProtoReflect.Descriptor instead.
func (*GetMPCKeyRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{15}
}

func (x *GetMPCKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for CreateSignature.
type CreateSignatureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent MPCKey.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}/mpcKeys/{mpc_key_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The Signature to be created.
	Signature *Signature `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSignatureRequest) Reset() {
	*x = CreateSignatureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSignatureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSignatureRequest) ProtoMessage() {}

func (x *CreateSignatureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSignatureRequest.ProtoReflect.Descriptor instead.
func (*CreateSignatureRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{16}
}

func (x *CreateSignatureRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSignatureRequest) GetSignature() *Signature {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *CreateSignatureRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Metadata associated with the CreateSignature long-running operation.
type CreateSignatureMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to poll using ListMPCOperations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	// The payload that is about to be signed. Check this value to ensure that the
	// correct payload is being signed.
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *CreateSignatureMetadata) Reset() {
	*x = CreateSignatureMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSignatureMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSignatureMetadata) ProtoMessage() {}

func (x *CreateSignatureMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSignatureMetadata.ProtoReflect.Descriptor instead.
func (*CreateSignatureMetadata) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{17}
}

func (x *CreateSignatureMetadata) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

func (x *CreateSignatureMetadata) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// The request message for PrepareDeviceArchive.
type PrepareDeviceArchiveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup. The prepared archive will include cryptographic materials to export the
	// private keys corresponding to each of the MPCKey under this DeviceGroup.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	// The resource name of the Device that prepares the archive in its local storage.
	// The Device must be part of the DeviceGroup specified above.
	// Format: devices/{device_id}
	Device string `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *PrepareDeviceArchiveRequest) Reset() {
	*x = PrepareDeviceArchiveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareDeviceArchiveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareDeviceArchiveRequest) ProtoMessage() {}

func (x *PrepareDeviceArchiveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareDeviceArchiveRequest.ProtoReflect.Descriptor instead.
func (*PrepareDeviceArchiveRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{18}
}

func (x *PrepareDeviceArchiveRequest) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

func (x *PrepareDeviceArchiveRequest) GetDevice() string {
	if x != nil {
		return x.Device
	}
	return ""
}

func (x *PrepareDeviceArchiveRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Metadata associated with the PrepareDeviceArchive long-running operation.
type PrepareDeviceArchiveMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to poll using ListMPCOperations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
}

func (x *PrepareDeviceArchiveMetadata) Reset() {
	*x = PrepareDeviceArchiveMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareDeviceArchiveMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareDeviceArchiveMetadata) ProtoMessage() {}

func (x *PrepareDeviceArchiveMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareDeviceArchiveMetadata.ProtoReflect.Descriptor instead.
func (*PrepareDeviceArchiveMetadata) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{19}
}

func (x *PrepareDeviceArchiveMetadata) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

// The request message for PrepareDeviceBackup.
type PrepareDeviceBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup. The prepared backup will include cryptographic materials to recover the
	// MPCKeys under this DeviceGroup on a new Device.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	// The resource name of the Device that prepares the backup.
	// The Device must be part of the DeviceGroup specified above.
	// Format: devices/{device_id}
	Device string `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *PrepareDeviceBackupRequest) Reset() {
	*x = PrepareDeviceBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareDeviceBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareDeviceBackupRequest) ProtoMessage() {}

func (x *PrepareDeviceBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareDeviceBackupRequest.ProtoReflect.Descriptor instead.
func (*PrepareDeviceBackupRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{20}
}

func (x *PrepareDeviceBackupRequest) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

func (x *PrepareDeviceBackupRequest) GetDevice() string {
	if x != nil {
		return x.Device
	}
	return ""
}

func (x *PrepareDeviceBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Metadata associated with the PrepareDeviceBackup long-running operation.
type PrepareDeviceBackupMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to poll using ListMPCOperations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
}

func (x *PrepareDeviceBackupMetadata) Reset() {
	*x = PrepareDeviceBackupMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrepareDeviceBackupMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareDeviceBackupMetadata) ProtoMessage() {}

func (x *PrepareDeviceBackupMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareDeviceBackupMetadata.ProtoReflect.Descriptor instead.
func (*PrepareDeviceBackupMetadata) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{21}
}

func (x *PrepareDeviceBackupMetadata) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

// The request message for AddDevice.
type AddDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to which the Device is being added.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	// The resource name of the Device that is being added to the DeviceGroup.
	// The Device must not be part of the DeviceGroup specified above.
	// Format: devices/{device_id}
	Device string `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *AddDeviceRequest) Reset() {
	*x = AddDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddDeviceRequest) ProtoMessage() {}

func (x *AddDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddDeviceRequest.ProtoReflect.Descriptor instead.
func (*AddDeviceRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{22}
}

func (x *AddDeviceRequest) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

func (x *AddDeviceRequest) GetDevice() string {
	if x != nil {
		return x.Device
	}
	return ""
}

func (x *AddDeviceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Metadata associated with the AddDevice long-running operation.
type AddDeviceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to poll using ListMPCOperations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	// The list of Device resource names that can compute the MPCOperation by invoking ComputeAddDeviceMPCOperation on the
	// WaaS SDK.
	// Format: devices/{device_id}
	ParticipatingDevices []string `protobuf:"bytes,2,rep,name=participating_devices,json=participatingDevices,proto3" json:"participating_devices,omitempty"`
}

func (x *AddDeviceMetadata) Reset() {
	*x = AddDeviceMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddDeviceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddDeviceMetadata) ProtoMessage() {}

func (x *AddDeviceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddDeviceMetadata.ProtoReflect.Descriptor instead.
func (*AddDeviceMetadata) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{23}
}

func (x *AddDeviceMetadata) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

func (x *AddDeviceMetadata) GetParticipatingDevices() []string {
	if x != nil {
		return x.ParticipatingDevices
	}
	return nil
}

// The request message for RevokeDevice.
type RevokeDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Device that is being revoked.
	// Format: devices/{device_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RevokeDeviceRequest) Reset() {
	*x = RevokeDeviceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RevokeDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevokeDeviceRequest) ProtoMessage() {}

func (x *RevokeDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevokeDeviceRequest.ProtoReflect.Descriptor instead.
func (*RevokeDeviceRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP(), []int{24}
}

func (x *RevokeDeviceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_coinbase_cloud_mpc_keys_v1_mpc_keys_proto protoreflect.FileDescriptor

var file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDesc = []byte{
	0x0a, 0x29, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x70, 0x63,
	0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f,
	0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x23, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x02, 0x0a,
	0x06, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x7b, 0x92, 0x41, 0x74, 0x2a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x32, 0x3c, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20,
	0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x4a,
	0x2e, 0x22, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x31, 0x35, 0x39, 0x31, 0x30, 0x38,
	0x39, 0x63, 0x2d, 0x32, 0x32, 0x39, 0x64, 0x2d, 0x34, 0x35, 0x37, 0x38, 0x2d, 0x61, 0x62, 0x39,
	0x34, 0x2d, 0x61, 0x33, 0x66, 0x61, 0x33, 0x34, 0x34, 0x32, 0x64, 0x37, 0x37, 0x62, 0x22, 0xe2,
	0x41, 0x01, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x99, 0x01, 0x92, 0x41, 0x5b, 0x0a,
	0x59, 0x2a, 0x06, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x32, 0x4f, 0x54, 0x68, 0x65, 0x20, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x20,
	0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73,
	0x20, 0x61, 0x20, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43,
	0x20, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0xea, 0x41, 0x38, 0x0a, 0x21, 0x61,
	0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x13, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xee, 0x03, 0x0a, 0x0d, 0x48, 0x61, 0x72, 0x64, 0x65, 0x6e,
	0x65, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x12, 0xb4, 0x02, 0x0a, 0x0f, 0x64, 0x65, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x05, 0x42, 0x8a, 0x02, 0x92, 0x41, 0x82, 0x02, 0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xea,
	0x01, 0x54, 0x68, 0x65, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x61, 0x63, 0x68, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x68, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x64,
	0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x20, 0x28,
	0x69, 0x2e, 0x65, 0x2e, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x6f, 0x6f, 0x74, 0x20, 0x6f,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x48, 0x44, 0x20, 0x74, 0x72, 0x65, 0x65, 0x29, 0x2e, 0x45,
	0x61, 0x63, 0x68, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x69, 0x6e, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70, 0x61,
	0x74, 0x68, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65,
	0x64, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x42,
	0x49, 0x50, 0x2d, 0x34, 0x34, 0x3a, 0x20, 0x6d, 0x20, 0x2f, 0x20, 0x70, 0x75, 0x72, 0x70, 0x6f,
	0x73, 0x65, 0xe2, 0x80, 0x99, 0x20, 0x2f, 0x20, 0x63, 0x6f, 0x69, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0xe2, 0x80, 0x99, 0x20, 0x2f, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xe2, 0x80,
	0x99, 0x20, 0x2f, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x2f, 0x20, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x4a, 0x0d, 0x22, 0x5b, 0x34,
	0x34, 0x2c, 0x20, 0x36, 0x30, 0x2c, 0x20, 0x30, 0x5d, 0x22, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x0e,
	0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x3a, 0xa5,
	0x01, 0x92, 0x41, 0xa1, 0x01, 0x0a, 0x9e, 0x01, 0x2a, 0x0d, 0x48, 0x61, 0x72, 0x64, 0x65, 0x6e,
	0x65, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x32, 0x8c, 0x01, 0x41, 0x20, 0x63, 0x68, 0x69, 0x6c,
	0x64, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x53, 0x65, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x61,
	0x6e, 0x20, 0x48, 0x44, 0x20, 0x74, 0x72, 0x65, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x77,
	0x61, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20, 0x75, 0x73, 0x69, 0x6e,
	0x67, 0x20, 0x68, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x61, 0x73, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65,
	0x64, 0x20, 0x69, 0x6e, 0x20, 0x42, 0x49, 0x50, 0x2d, 0x33, 0x32, 0x2e, 0x20, 0x41, 0x6c, 0x6c,
	0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x73, 0x20, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64,
	0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x61, 0x20, 0x48, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64,
	0x43, 0x68, 0x69, 0x6c, 0x64, 0x2e, 0x22, 0xc4, 0x05, 0x0a, 0x04, 0x53, 0x65, 0x65, 0x64, 0x12,
	0xe3, 0x01, 0x0a, 0x11, 0x68, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63,
	0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65,
	0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x42, 0x8a, 0x01, 0x92, 0x41, 0x82, 0x01, 0x2a, 0x10, 0x68,
	0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x32,
	0x6e, 0x54, 0x68, 0x65, 0x20, 0x68, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x20, 0x63, 0x68,
	0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x66,
	0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x2e, 0x20, 0x54, 0x6f,
	0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65,
	0x79, 0x2c, 0x20, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x6e, 0x65, 0x20,
	0x68, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x2e, 0xe2,
	0x41, 0x01, 0x02, 0x52, 0x10, 0x68, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x12, 0xbf, 0x02, 0x0a, 0x17, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x87, 0x02, 0x92, 0x41, 0xff, 0x01, 0x2a, 0x14,
	0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x32, 0xe6, 0x01, 0x54, 0x68, 0x65, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74,
	0x6f, 0x20, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x73,
	0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x53, 0x65, 0x65, 0x64, 0x2e, 0x0a, 0x0a, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x20, 0x68, 0x61, 0x73, 0x20, 0x74, 0x6f, 0x20,
	0x62, 0x65, 0x20, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x57, 0x61, 0x61,
	0x53, 0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x20, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x20, 0x6b, 0x65, 0x79, 0x73,
	0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74,
	0x6f, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x61,
	0x72, 0x65, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x53, 0x65, 0x65, 0x64, 0x27, 0x73, 0x20, 0x48, 0x61, 0x72, 0x64,
	0x65, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x2e, 0xe2, 0x41, 0x01,
	0x03, 0x52, 0x14, 0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x3a, 0x93, 0x01, 0x92, 0x41, 0x8f, 0x01, 0x0a, 0x8c,
	0x01, 0x2a, 0x04, 0x53, 0x65, 0x65, 0x64, 0x32, 0x83, 0x01, 0x41, 0x20, 0x62, 0x79, 0x74, 0x65,
	0x20, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x72, 0x6f, 0x6f, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x68, 0x69, 0x65, 0x72, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x20, 0x28, 0x48, 0x44, 0x29, 0x20, 0x77, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x20, 0x61, 0x73, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x69,
	0x6e, 0x20, 0x42, 0x49, 0x50, 0x2d, 0x33, 0x32, 0x2e, 0x20, 0x41, 0x20, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x68, 0x61, 0x73, 0x20, 0x65, 0x78, 0x61, 0x63,
	0x74, 0x6c, 0x79, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x2e, 0x22, 0x89, 0x07,
	0x0a, 0x0b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0xe1, 0x01,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xcc, 0x01, 0x92,
	0x41, 0xc4, 0x01, 0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x5c, 0x54, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e,
	0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x5e, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32,
	0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39,
	0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d,
	0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36, 0x37,
	0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xf6, 0x01, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0xdb, 0x01, 0x92, 0x41, 0xd3, 0x01, 0x2a, 0x07, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x32, 0x95, 0x01, 0x54, 0x68, 0x65, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f,
	0x66, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74,
	0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x20, 0x4f, 0x6e, 0x20, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6c, 0x69, 0x73, 0x74,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x65, 0x78, 0x61, 0x63, 0x74,
	0x6c, 0x79, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x73, 0x65,
	0x74, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x4a, 0x30, 0x5b, 0x22, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x31, 0x35, 0x39, 0x31, 0x30, 0x38, 0x39, 0x63, 0x2d,
	0x32, 0x32, 0x39, 0x64, 0x2d, 0x34, 0x35, 0x37, 0x38, 0x2d, 0x61, 0x62, 0x39, 0x34, 0x2d, 0x61,
	0x33, 0x66, 0x61, 0x33, 0x34, 0x34, 0x32, 0x64, 0x37, 0x37, 0x62, 0x22, 0x5d, 0xe2, 0x41, 0x01,
	0x02, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0xb2, 0x01, 0x0a, 0x04, 0x73,
	0x65, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x65, 0x64, 0x42, 0x7c, 0x92, 0x41, 0x75,
	0x2a, 0x04, 0x73, 0x65, 0x65, 0x64, 0x32, 0x6d, 0x54, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64,
	0x73, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x2e, 0x20, 0x4f, 0x6e, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x20, 0x6d, 0x75, 0x73, 0x74,
	0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x6f,
	0x6e, 0x65, 0x20, 0x48, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64,
	0x20, 0x73, 0x65, 0x74, 0x2e, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x04, 0x73, 0x65, 0x65, 0x64, 0x3a,
	0xe7, 0x01, 0x92, 0x41, 0x88, 0x01, 0x0a, 0x85, 0x01, 0x2a, 0x0b, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x76, 0x54, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x73, 0x20, 0x61, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x6f, 0x66, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
	0x68, 0x61, 0x76, 0x65, 0x20, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x73, 0x65, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x53,
	0x65, 0x65, 0x64, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0xea, 0x41,
	0x58, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2e, 0x70, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xb6, 0x10, 0x0a, 0x0c, 0x4d, 0x50,
	0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xb7, 0x02, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xa2, 0x02, 0x92, 0x41, 0x9a, 0x02,
	0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x7e, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x91, 0x01, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32,
	0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39,
	0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d,
	0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36, 0x37,
	0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x2f, 0x6d, 0x70, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x31, 0x32, 0x38, 0x38, 0x35, 0x31, 0x35, 0x34, 0x2d, 0x38, 0x64,
	0x36, 0x65, 0x2d, 0x34, 0x30, 0x36, 0x30, 0x2d, 0x38, 0x61, 0x64, 0x65, 0x2d, 0x35, 0x62, 0x32,
	0x62, 0x33, 0x64, 0x39, 0x31, 0x39, 0x33, 0x31, 0x37, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x91, 0x01, 0x0a, 0x08, 0x6d, 0x70, 0x63, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x76, 0x92, 0x41, 0x6f, 0x2a, 0x07, 0x6d, 0x70,
	0x63, 0x44, 0x61, 0x74, 0x61, 0x32, 0x64, 0x44, 0x61, 0x74, 0x61, 0x20, 0x74, 0x68, 0x61, 0x74,
	0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x20, 0x70, 0x61, 0x73, 0x73, 0x65,
	0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44,
	0x4b, 0x27, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0xe2, 0x41, 0x01, 0x03, 0x52,
	0x07, 0x6d, 0x70, 0x63, 0x44, 0x61, 0x74, 0x61, 0x12, 0xe0, 0x01, 0x0a, 0x1c, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x66, 0x92, 0x41, 0x63, 0x2a, 0x19, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0x46, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x2d, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x00,
	0x52, 0x19, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd5, 0x01, 0x0a, 0x19,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x62, 0x92, 0x41, 0x5f, 0x2a, 0x17, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x32, 0x44, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x20, 0x61, 0x73, 0x73,
	0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x2d, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x00, 0x52, 0x17, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xef, 0x01, 0x0a, 0x1f, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x5f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61,
	0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x6c, 0x92, 0x41, 0x69, 0x2a, 0x1c, 0x70, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0x49, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x20, 0x6c, 0x6f,
	0x6e, 0x67, 0x2d, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x00, 0x52, 0x1c, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xea, 0x01, 0x0a, 0x1e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72,
	0x65, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70,
	0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x6a, 0x92, 0x41, 0x67, 0x2a, 0x1b, 0x70, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0x48, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77,
	0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x6c, 0x6f, 0x6e, 0x67,
	0x2d, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x48, 0x00, 0x52, 0x1b, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xb7, 0x01, 0x0a, 0x13, 0x61, 0x64, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x56, 0x92, 0x41, 0x53, 0x2a, 0x11, 0x61, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0x3e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74,
	0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20,
	0x6c, 0x6f, 0x6e, 0x67, 0x2d, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x00, 0x52, 0x11, 0x61, 0x64, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x3a, 0xf7, 0x03, 0x92,
	0x41, 0xf6, 0x02, 0x0a, 0xf3, 0x02, 0x2a, 0x0c, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x32, 0xe2, 0x02, 0x54, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x73, 0x20, 0x61, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x4d, 0x50, 0x43,
	0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x77, 0x61, 0x69, 0x74,
	0x69, 0x6e, 0x67, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x50, 0x6f, 0x6c, 0x6c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65,
	0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x54, 0x68,
	0x65, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x49, 0x44, 0x20, 0x69, 0x73, 0x20, 0x67, 0x75,
	0x61, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
	0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e,
	0x67, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x2d, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0xea, 0x41, 0x7a, 0x0a, 0x27, 0x61, 0x70,
	0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0xde, 0x08, 0x0a, 0x06, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x12, 0x9f, 0x02,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x8a, 0x02, 0x92,
	0x41, 0x82, 0x02, 0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x6c, 0x54, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x8b, 0x01, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34,
	0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65,
	0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31,
	0x2d, 0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36,
	0x37, 0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x2f, 0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f,
	0x64, 0x32, 0x38, 0x62, 0x39, 0x34, 0x36, 0x62, 0x2d, 0x35, 0x33, 0x33, 0x62, 0x2d, 0x34, 0x36,
	0x36, 0x65, 0x2d, 0x62, 0x62, 0x36, 0x31, 0x2d, 0x39, 0x31, 0x64, 0x39, 0x33, 0x38, 0x37, 0x34,
	0x33, 0x38, 0x35, 0x38, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xab, 0x03, 0x0a, 0x0f, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x42, 0x81, 0x03, 0x92, 0x41, 0xf9, 0x02,
	0x2a, 0x0e, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68,
	0x32, 0xd3, 0x02, 0x54, 0x68, 0x65, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x20, 0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x61, 0x63, 0x68, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x20, 0x66, 0x72, 0x6f, 0x6d,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x20, 0x28, 0x69, 0x2e, 0x65, 0x2e, 0x2c,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x6f, 0x6f, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x48, 0x44, 0x20, 0x74, 0x72, 0x65, 0x65, 0x29, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x72, 0x65,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x48, 0x61, 0x72, 0x64, 0x65,
	0x6e, 0x65, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x53, 0x65, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x77,
	0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x61, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x70, 0x61, 0x74, 0x68, 0x2e, 0x20, 0x45, 0x61, 0x63, 0x68, 0x20, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70, 0x61, 0x74, 0x68, 0x20, 0x69, 0x73,
	0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x64, 0x20, 0x61, 0x63, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x42, 0x49, 0x50, 0x2d, 0x34, 0x34,
	0x3a, 0x20, 0x6d, 0x20, 0x2f, 0x20, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0xe2, 0x80, 0x99,
	0x20, 0x2f, 0x20, 0x63, 0x6f, 0x69, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xe2, 0x80, 0x99, 0x20,
	0x2f, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xe2, 0x80, 0x99, 0x20, 0x2f, 0x20, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x2f, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x4a, 0x11, 0x5b, 0x34, 0x34, 0x2c, 0x20, 0x36, 0x30, 0x2c,
	0x20, 0x30, 0x2c, 0x20, 0x30, 0x2c, 0x20, 0x30, 0x5d, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x0e, 0x64,
	0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x79, 0x0a,
	0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x42, 0x35, 0x92, 0x41, 0x2e, 0x2a, 0x09, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x32, 0x21, 0x54, 0x68, 0x65, 0x20, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x20, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x2e, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x09, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x3a, 0x88, 0x02, 0x92, 0x41, 0x99, 0x01, 0x0a,
	0x96, 0x01, 0x2a, 0x06, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x32, 0x8b, 0x01, 0x54, 0x68, 0x65,
	0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x20, 0x41, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x20, 0x63, 0x61, 0x6e, 0x20,
	0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x74, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x64, 0x20, 0x4d, 0x2d, 0x6f, 0x66, 0x2d, 0x4e, 0x20, 0x73, 0x69, 0x67,
	0x6e, 0x69, 0x6e, 0x67, 0x20, 0x76, 0x69, 0x61, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61,
	0x53, 0x20, 0x53, 0x44, 0x4b, 0x2e, 0x20, 0x41, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79,
	0x20, 0x69, 0x73, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d,
	0x20, 0x61, 0x20, 0x53, 0x65, 0x65, 0x64, 0x2e, 0xea, 0x41, 0x68, 0x0a, 0x21, 0x61, 0x70, 0x69,
	0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x12, 0x43,
	0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d,
	0x70, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x7d, 0x22, 0xe6, 0x06, 0x0a, 0x09, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x12, 0xed, 0x02, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0xd8, 0x02, 0x92, 0x41, 0xd0, 0x02, 0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x89, 0x01,
	0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d,
	0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x4b, 0x65,
	0x79, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0xbb, 0x01, 0x22, 0x70, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66,
	0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61,
	0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36,
	0x36, 0x31, 0x2d, 0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35,
	0x39, 0x36, 0x37, 0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x2f, 0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79,
	0x73, 0x2f, 0x64, 0x32, 0x38, 0x62, 0x39, 0x34, 0x36, 0x62, 0x2d, 0x35, 0x33, 0x33, 0x62, 0x2d,
	0x34, 0x36, 0x36, 0x65, 0x2d, 0x62, 0x62, 0x36, 0x31, 0x2d, 0x39, 0x31, 0x64, 0x39, 0x33, 0x38,
	0x37, 0x34, 0x33, 0x38, 0x35, 0x38, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x2f, 0x31, 0x32, 0x39, 0x36, 0x30, 0x62, 0x66, 0x37, 0x2d, 0x66, 0x32, 0x31, 0x35, 0x2d,
	0x34, 0x34, 0x63, 0x66, 0x2d, 0x38, 0x35, 0x38, 0x39, 0x2d, 0x36, 0x62, 0x38, 0x61, 0x30, 0x66,
	0x64, 0x39, 0x63, 0x34, 0x32, 0x64, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x4d, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x42, 0x33, 0x92, 0x41, 0x2c, 0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x24, 0x54,
	0x68, 0x65, 0x20, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x73, 0x69,
	0x67, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b,
	0x65, 0x79, 0x2e, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x89, 0x01, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x46, 0x92, 0x41, 0x3f, 0x2a, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x32, 0x32, 0x54, 0x68, 0x65, 0x20, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x68, 0x61, 0x73,
	0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74,
	0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x2e, 0xe2, 0x41, 0x01,
	0x03, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x3a, 0x8d, 0x02, 0x92,
	0x41, 0x80, 0x01, 0x0a, 0x7e, 0x2a, 0x09, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x32, 0x71, 0x54, 0x68, 0x65, 0x20, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x20, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x64, 0x20, 0x4d, 0x2d, 0x6f, 0x66, 0x2d, 0x4e, 0x20, 0x73, 0x69, 0x67, 0x6e,
	0x69, 0x6e, 0x67, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79,
	0x73, 0x20, 0x76, 0x69, 0x61, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53,
	0x44, 0x4b, 0x2e, 0xea, 0x41, 0x85, 0x01, 0x0a, 0x24, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x5d, 0x70,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70,
	0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0x6f, 0x0a, 0x15,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x31, 0x0a, 0x11, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x04, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x10, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41,
	0x01, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x65, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x3d, 0x92, 0x41, 0x10, 0xca, 0x3e, 0x0d, 0xfa, 0x02, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70, 0x69,
	0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x58, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x40, 0x92, 0x41, 0x0e, 0xca, 0x3e, 0x0b, 0xfa, 0x02, 0x08, 0x70, 0x6f, 0x6f, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x70, 0x69,
	0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x02,
	0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2c, 0x0a,
	0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x0d, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xe2, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc4,
	0x02, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xa0, 0x02, 0x92, 0x41, 0xed, 0x01, 0x2a, 0x0c, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x7d, 0x54, 0x68, 0x65, 0x20,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x0a, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x5e, 0x22, 0x70, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d,
	0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38,
	0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36,
	0x31, 0x2d, 0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39,
	0x36, 0x37, 0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x74, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x47, 0x92, 0x41,
	0x15, 0xca, 0x3e, 0x12, 0xfa, 0x02, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61,
	0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x48, 0x92, 0x41, 0x15, 0xca, 0x3e, 0x12,
	0xfa, 0x02, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61,
	0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x61, 0x70, 0x69, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3a, 0x4c, 0x92, 0x41, 0x49, 0x0a,
	0x47, 0x2a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0x2a, 0x54, 0x68,
	0x65, 0x20, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x22, 0xbb, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0e, 0x6d, 0x70, 0x63, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x70, 0x63, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x4d, 0x92, 0x41, 0x4a, 0x0a, 0x48, 0x2a, 0x19,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0x2b, 0x54, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20,
	0x66, 0x6f, 0x72, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x22, 0xd9, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x42,
	0x92, 0x41, 0x15, 0xca, 0x3e, 0x12, 0xfa, 0x02, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x23, 0x12,
	0x21, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x4b,
	0x65, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x07, 0x6d, 0x70,
	0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63,
	0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x42,
	0x04, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x06, 0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x23, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x65, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0x92, 0x41, 0x10, 0xca, 0x3e, 0x0d, 0xfa, 0x02, 0x0a, 0x6d,
	0x70, 0x63, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43,
	0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x16, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0x92, 0x41, 0x10, 0xca, 0x3e, 0x0d, 0xfa, 0x02, 0x0a, 0x6d,
	0x70, 0x63, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x26,
	0x12, 0x24, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x49,
	0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2,
	0x41, 0x01, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x80,
	0x03, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc4, 0x02, 0x0a, 0x0c, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0xa0, 0x02, 0x92, 0x41, 0xed, 0x01, 0x2a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x7d, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20,
	0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x0a, 0x20, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x5e, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35,
	0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31,
	0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63,
	0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d, 0x34, 0x65,
	0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36, 0x37, 0x31, 0x61,
	0x61, 0x37, 0x37, 0x37, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70,
	0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x1e, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x22, 0x85, 0x02, 0x0a, 0x1b, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x6a, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x47, 0x92, 0x41, 0x15, 0xca, 0x3e, 0x12, 0xfa,
	0x02, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d,
	0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x55, 0x0a,
	0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0x92,
	0x41, 0x10, 0xca, 0x3e, 0x0d, 0xfa, 0x02, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70, 0x69, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe5, 0x02, 0x0a, 0x1c, 0x50, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc4, 0x02, 0x0a, 0x0c, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0xa0, 0x02, 0x92, 0x41, 0xed, 0x01, 0x2a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x7d, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20,
	0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x0a, 0x20, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x5e, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35,
	0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31,
	0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63,
	0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d, 0x34, 0x65,
	0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36, 0x37, 0x31, 0x61,
	0x61, 0x37, 0x37, 0x37, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70,
	0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x22, 0x84, 0x02, 0x0a, 0x1a, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x6a, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x47, 0x92, 0x41, 0x15, 0xca, 0x3e, 0x12, 0xfa, 0x02,
	0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65,
	0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x55, 0x0a, 0x06,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0x92, 0x41,
	0x10, 0xca, 0x3e, 0x0d, 0xfa, 0x02, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe4, 0x02, 0x0a, 0x1b, 0x50, 0x72, 0x65,
	0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc4, 0x02, 0x0a, 0x0c, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0xa0, 0x02, 0x92, 0x41, 0xed, 0x01, 0x2a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x32, 0x7d, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f,
	0x6c, 0x6c, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x0a, 0x20, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x7d, 0x4a, 0x5e, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35,
	0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62,
	0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x33, 0x61,
	0x31, 0x36, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d, 0x34, 0x65, 0x35, 0x61,
	0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d, 0x39, 0x37, 0x35, 0x39, 0x36, 0x37, 0x31, 0x61, 0x61, 0x37,
	0x37, 0x37, 0x22, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e,
	0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22,
	0xfa, 0x01, 0x0a, 0x10, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x6a, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x47, 0x92, 0x41, 0x15, 0xca,
	0x3e, 0x12, 0xfa, 0x02, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69,
	0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x55, 0x0a, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3d, 0x92, 0x41, 0x10, 0xca, 0x3e, 0x0d, 0xfa, 0x02, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x70,
	0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xef, 0x04, 0x0a,
	0x11, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xc4, 0x02, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xa0, 0x02, 0x92, 0x41, 0xed, 0x01,
	0x2a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x7d,
	0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d,
	0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x75, 0x73, 0x69,
	0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x0a, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x5e, 0x22,
	0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35, 0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35,
	0x32, 0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31, 0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36,
	0x35, 0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63, 0x39, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x33, 0x61, 0x31, 0x36, 0x38, 0x61, 0x35, 0x34,
	0x2d, 0x36, 0x36, 0x36, 0x31, 0x2d, 0x34, 0x65, 0x35, 0x61, 0x2d, 0x38, 0x62, 0x63, 0x35, 0x2d,
	0x39, 0x37, 0x35, 0x39, 0x36, 0x37, 0x31, 0x61, 0x61, 0x37, 0x37, 0x37, 0x22, 0xe2, 0x41, 0x01,
	0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x92, 0x02, 0x0a, 0x15, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0xdc, 0x01, 0x92, 0x41, 0xd4, 0x01,
	0x2a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x32, 0x96, 0x01, 0x54, 0x68, 0x65, 0x20,
	0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x20, 0x74, 0x68,
	0x61, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x62, 0x79, 0x20, 0x69, 0x6e, 0x76, 0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x50, 0x43, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x3a, 0x20, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x7d, 0x4a, 0x30, 0x5b, 0x22, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x31, 0x35,
	0x39, 0x31, 0x30, 0x38, 0x39, 0x63, 0x2d, 0x32, 0x32, 0x39, 0x64, 0x2d, 0x34, 0x35, 0x37, 0x38,
	0x2d, 0x61, 0x62, 0x39, 0x34, 0x2d, 0x61, 0x33, 0x66, 0x61, 0x33, 0x34, 0x34, 0x32, 0x64, 0x37,
	0x37, 0x62, 0x22, 0x5d, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x68,
	0x0a, 0x13, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x3d, 0x92, 0x41, 0x10, 0xca, 0x3e, 0x0d, 0xfa, 0x02, 0x0a, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x9d, 0x45, 0x0a, 0x0d, 0x4d, 0x50, 0x43,
	0x4b, 0x65, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8d, 0x02, 0x0a, 0x0e, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x31, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x22, 0xa3, 0x01, 0x92, 0x41, 0x6e, 0x12, 0x0e, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x1a, 0x5c, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x20, 0x61, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x20, 0x41, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20,
	0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x69, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65,
	0x20, 0x61, 0x64, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x20, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0xda, 0x41, 0x11, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x18, 0x3a, 0x01, 0x2a, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x3a, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x12, 0xb6, 0x01, 0x0a, 0x09, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2c, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x22, 0x57, 0x92, 0x41, 0x31, 0x12,
	0x09, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x1a, 0x24, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x73, 0x20, 0x61, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x62,
	0x79, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2e,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x16, 0x12, 0x14, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x06, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x34, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd7,
	0x05, 0x92, 0x41, 0xcb, 0x04, 0x12, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x1a, 0xb5, 0x04, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x73, 0x20, 0x61, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x65,
	0x78, 0x61, 0x63, 0x74, 0x6c, 0x79, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74,
	0x20, 0x6f, 0x6e, 0x65, 0x20, 0x48, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x2e, 0x0a, 0x0a, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2c, 0x20, 0x75, 0x73, 0x65, 0x20, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20,
	0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x0a, 0x20, 0x4e, 0x6f, 0x74,
	0x65, 0x3a, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x73, 0x79,
	0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f, 0x75, 0x73, 0x2c, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6d, 0x61, 0x79,
	0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f,
	0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x20, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x20, 0x54, 0x6f, 0x20, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x20, 0x70, 0x6f,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x61, 0x66, 0x74,
	0x65, 0x72, 0x20, 0x69, 0x74, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20,
	0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e,
	0xca, 0x41, 0x28, 0x0a, 0x0b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x23, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x2c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x3a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xdc, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63,
	0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27,
	0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x6e, 0x92, 0x41, 0x3b, 0x12, 0x0e, 0x47, 0x65,
	0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x1a, 0x29, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x73, 0x20, 0x61, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x62, 0x79, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa9, 0x03, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa6, 0x02, 0x92, 0x41, 0xe0,
	0x01, 0x12, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xca, 0x01, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x20,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x73, 0x73, 0x6f,
	0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x0a, 0x0a, 0x20, 0x55, 0x73, 0x65, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x50, 0x49, 0x20, 0x69, 0x6e, 0x20, 0x63, 0x6f, 0x6d, 0x62,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33,
	0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xdf, 0x02, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50,
	0x43, 0x4b, 0x65, 0x79, 0x12, 0x2f, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x22, 0xf9, 0x01, 0x92, 0x41, 0xa8, 0x01,
	0x12, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x1a, 0x97,
	0x01, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x4b,
	0x65, 0x79, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62,
	0x65, 0x20, 0x61, 0x20, 0x48, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x69, 0x6c,
	0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73,
	0x20, 0x61, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70, 0x61, 0x74, 0x68,
	0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x2e, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a,
	0x07, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x70,
	0x63, 0x4b, 0x65, 0x79, 0x73, 0x12, 0xce, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43,
	0x4b, 0x65, 0x79, 0x12, 0x2c, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x22, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x50, 0x43, 0x4b, 0x65, 0x79, 0x22, 0x6f, 0x92, 0x41, 0x32, 0x12, 0x09, 0x47, 0x65, 0x74, 0x4d,
	0x50, 0x43, 0x4b, 0x65, 0x79, 0x1a, 0x25, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x73,
	0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x20, 0x62, 0x79, 0x20, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2e, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x70, 0x63, 0x4b,
	0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc3, 0x05, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x32, 0x2e, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f,
	0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdc, 0x04,
	0x92, 0x41, 0xd3, 0x03, 0x12, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x1a, 0xbf, 0x03, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x73, 0x20,
	0x61, 0x20, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x75, 0x73, 0x69, 0x6e,
	0x67, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x2e, 0x0a, 0x0a, 0x20, 0x41,
	0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x2c, 0x20, 0x75, 0x73, 0x65, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c,
	0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b,
	0x27, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x0a, 0x0a, 0x20, 0x4e, 0x6f, 0x74, 0x65, 0x3a, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73,
	0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
	0x66, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x20, 0x69, 0x73, 0x20, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f, 0x75, 0x73,
	0x2c, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x61,
	0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x20, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x61, 0x66, 0x74,
	0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e,
	0x20, 0x54, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x63, 0x6f, 0x6e, 0x74,
	0x69, 0x6e, 0x75, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x65,
	0x76, 0x65, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x69, 0x74, 0x20, 0x72, 0x65, 0x74,
	0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44,
	0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0xca, 0x41, 0x24, 0x0a, 0x09, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x70, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0xb7, 0x09, 0x0a,
	0x14, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0x37, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc6, 0x08,
	0x92, 0x41, 0xb5, 0x07, 0x12, 0x14, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x1a, 0x9c, 0x07, 0x50, 0x72, 0x65,
	0x70, 0x61, 0x72, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x20, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x69, 0x76,
	0x65, 0x6e, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x54, 0x68, 0x65,
	0x20, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x73, 0x20, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20,
	0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x63,
	0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x73, 0x2c, 0x20, 0x77, 0x68,
	0x69, 0x63, 0x68, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x69, 0x76,
	0x65, 0x6e, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x61,
	0x73, 0x20, 0x74, 0x68, 0x65, 0x69, 0x72, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2e, 0x0a,
	0x0a, 0x20, 0x54, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x65, 0x20,
	0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65,
	0x64, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x20,
	0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x2e, 0x20,
	0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x2c, 0x20, 0x75, 0x73, 0x65, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c,
	0x6c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x20, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61,
	0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x0a, 0x20, 0x4f, 0x6e, 0x63, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x20, 0x74, 0x6f, 0x20, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x20, 0x6b, 0x65, 0x79, 0x73, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x65, 0x61, 0x63, 0x68, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x73, 0x20, 0x75, 0x6e, 0x64, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x2e, 0x0a, 0x0a, 0x20, 0x4e, 0x6f, 0x74, 0x65, 0x3a, 0x20, 0x62, 0x65, 0x63, 0x61,
	0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x6f, 0x66, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f,
	0x75, 0x73, 0x2c, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x20, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x20, 0x54, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x63, 0x6f,
	0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x20, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x69, 0x74, 0x20, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0xca, 0x41, 0x2b, 0x0a, 0x0b, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1c, 0x50, 0x72, 0x65, 0x70, 0x61,
	0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0xfb, 0x0a, 0x0a, 0x13, 0x50, 0x72, 0x65, 0x70, 0x61,
	0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x36,
	0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70,
	0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x0a, 0x92, 0x41, 0xfd, 0x08, 0x12, 0x13, 0x50, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x1a, 0xe5, 0x08, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x73, 0x20, 0x61, 0x20, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x69, 0x76,
	0x65, 0x6e, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x54, 0x68, 0x65,
	0x20, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73,
	0x20, 0x63, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65,
	0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x20, 0x4d, 0x50, 0x43,
	0x4b, 0x65, 0x79, 0x73, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x68, 0x61, 0x76, 0x65,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x69, 0x72, 0x20,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x20, 0x6f, 0x6e, 0x20, 0x61, 0x20, 0x6e, 0x65, 0x77,
	0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x54, 0x68, 0x65, 0x20, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20,
	0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20,
	0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x70, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x2e, 0x20, 0x0a, 0x0a, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72,
	0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x52, 0x50,
	0x43, 0x2c, 0x20, 0x75, 0x73, 0x65, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c,
	0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x20, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53,
	0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x50,
	0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x0a, 0x0a, 0x20, 0x4f, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x20, 0x57, 0x61,
	0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x20, 0x74, 0x6f, 0x20, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x62, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x20, 0x0a, 0x0a, 0x20, 0x57, 0x65, 0x20, 0x72, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x20, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x20, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x6c, 0x79, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x20,
	0x6f, 0x66, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x2e, 0x20,
	0x0a, 0x0a, 0x20, 0x49, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x6c,
	0x6f, 0x73, 0x65, 0x73, 0x20, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74,
	0x68, 0x65, 0x69, 0x72, 0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x77, 0x61, 0x6e, 0x74, 0x73, 0x20, 0x74,
	0x6f, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79,
	0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x6f, 0x6e, 0x20, 0x61, 0x20,
	0x6e, 0x65, 0x77, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x20, 0x75, 0x73, 0x65, 0x20,
	0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x52, 0x50, 0x43, 0x20, 0x6f, 0x6e,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x0a, 0x0a, 0x20, 0x4e, 0x6f, 0x74, 0x65, 0x3a, 0x20, 0x62, 0x65, 0x63, 0x61,
	0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x6f, 0x66, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f,
	0x75, 0x73, 0x2c, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x20, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x20, 0x54, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x63, 0x6f,
	0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x20, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x69, 0x74, 0x20, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0xca, 0x41, 0x2a, 0x0a, 0x0b, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1b, 0x50, 0x72, 0x65, 0x70, 0x61,
	0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x12, 0xcd, 0x0a, 0x0a, 0x09, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x2c, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xf2, 0x09, 0x92, 0x41, 0xf7, 0x08, 0x12, 0x09, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x1a, 0xe9, 0x08, 0x41, 0x64, 0x64, 0x73, 0x20, 0x61, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x20, 0x0a, 0x0a,
	0x50, 0x72, 0x69, 0x6f, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x50,
	0x49, 0x20, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x2c, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x75, 0x73,
	0x69, 0x6e, 0x67, 0x20, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x20, 0x52, 0x50, 0x43, 0x2e, 0x20, 0x0a, 0x0a, 0x20, 0x54, 0x68, 0x65, 0x20, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74,
	0x68, 0x20, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x52, 0x50, 0x43, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x0a, 0x0a, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x52, 0x50, 0x43, 0x2c, 0x20,
	0x75, 0x73, 0x65, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x20, 0x66, 0x6f,
	0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x41, 0x64,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57,
	0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x27, 0x73, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x64, 0x20, 0x6f, 0x6e, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x2c, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x68,
	0x61, 0x76, 0x65, 0x20, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x6d, 0x61, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x20, 0x74,
	0x6f, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x20, 0x20, 0x0a,
	0x0a, 0x4f, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x73, 0x20, 0x6f, 0x6e,
	0x20, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2c, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20,
	0x62, 0x65, 0x20, 0x61, 0x64, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x20, 0x61, 0x73, 0x20, 0x61, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x61, 0x6c, 0x6c, 0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x77, 0x69,
	0x6c, 0x6c, 0x20, 0x73, 0x74, 0x61, 0x79, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x2e, 0x20, 0x20, 0x0a, 0x0a, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65,
	0x20, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x52, 0x50,
	0x43, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x20, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x72,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x0a, 0x0a, 0x20, 0x4e, 0x6f, 0x74, 0x65, 0x3a, 0x20,
	0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x69, 0x73, 0x20, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x68,
	0x72, 0x6f, 0x6e, 0x6f, 0x75, 0x73, 0x2c, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x72, 0x65,
	0x74, 0x75, 0x72, 0x6e, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44,
	0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x20, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65,
	0x6c, 0x79, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x20, 0x54, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
	0x69, 0x74, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0xca, 0x41, 0x20,
	0x0a, 0x0b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x41,
	0x64, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x13, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01, 0x2a, 0x22,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xb8, 0x05, 0x0a, 0x0c, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2f, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xde,
	0x04, 0x92, 0x41, 0xb7, 0x04, 0x12, 0x0c, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x1a, 0xa6, 0x04, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x73, 0x20, 0x61, 0x20,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x0a, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x61, 0x6c, 0x6c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
	0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x61, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x2e,
	0x0a, 0x20, 0x4f, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x20, 0x69, 0x73, 0x20, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x2c, 0x20, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x6d, 0x61, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20, 0x70, 0x68,
	0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x61, 0x72,
	0x65, 0x20, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x2c, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x63, 0x61,
	0x6e, 0x20, 0x6e, 0x6f, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x4d,
	0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x20, 0x69, 0x74, 0x20, 0x77, 0x61, 0x73, 0x20, 0x61, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f,
	0x66, 0x2e, 0x20, 0x55, 0x73, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x50, 0x49, 0x20,
	0x69, 0x6e, 0x20, 0x73, 0x63, 0x65, 0x6e, 0x61, 0x72, 0x69, 0x6f, 0x73, 0x20, 0x73, 0x75, 0x63,
	0x68, 0x20, 0x61, 0x73, 0x20, 0x6c, 0x6f, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2c,
	0x20, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x20,
	0x6e, 0x65, 0x77, 0x20, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x2c, 0x20, 0x65, 0x74, 0x63, 0x2e, 0x0a, 0x20, 0x45, 0x6e, 0x73, 0x75, 0x72,
	0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x20, 0x69, 0x73, 0x20, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
	0x6c, 0x6c, 0x79, 0x20, 0x61, 0x64, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x79, 0x6f, 0x75,
	0x72, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x20, 0x75,
	0x73, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x64, 0x64, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x20, 0x52, 0x50, 0x43, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x69, 0x6e,
	0x76, 0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x52, 0x65, 0x76, 0x6f, 0x6b,
	0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x52, 0x50, 0x43, 0x2e, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x16, 0x3a, 0x01, 0x2a, 0x22, 0x11, 0x2f, 0x76,
	0x31, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x3a, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x1a,
	0xb6, 0x07, 0x92, 0x41, 0x87, 0x07, 0x12, 0x84, 0x07, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x73, 0x20,
	0x41, 0x50, 0x49, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x20, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x2d, 0x70, 0x61, 0x72, 0x74, 0x79, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x28, 0x4d, 0x50, 0x43, 0x29, 0x2e, 0x20, 0x49, 0x74, 0x20, 0x73, 0x68, 0x6f,
	0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69,
	0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x6a, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69,
	0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2d, 0x73, 0x69,
	0x64, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x2e, 0x20, 0x54, 0x68, 0x65,
	0x20, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x4b,
	0x65, 0x79, 0x73, 0x20, 0x61, 0x72, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20,
	0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x6e, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x6c, 0x79,
	0x69, 0x6e, 0x67, 0x20, 0x68, 0x69, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68, 0x69, 0x63, 0x61, 0x6c,
	0x6c, 0x79, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x20, 0x28, 0x48, 0x44, 0x29, 0x20, 0x54, 0x72, 0x65, 0x65, 0x2c, 0x20, 0x66, 0x6f, 0x6c, 0x6c,
	0x6f, 0x77, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x42, 0x49, 0x50, 0x2d, 0x33, 0x32, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x42, 0x49, 0x50, 0x2d, 0x34, 0x34, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x66, 0x6c, 0x6f, 0x77, 0x20, 0x69, 0x73, 0x20,
	0x61, 0x73, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x3a, 0x0a, 0x20, 0x31, 0x2e, 0x20,
	0x43, 0x61, 0x6c, 0x6c, 0x20, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x0a, 0x20, 0x32, 0x2e, 0x20, 0x43, 0x61, 0x6c, 0x6c, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x77, 0x69, 0x74, 0x68,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x61, 0x73, 0x20, 0x69, 0x74, 0x73, 0x20, 0x73, 0x6f,
	0x6c, 0x65, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x61, 0x74,
	0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x48, 0x61, 0x72, 0x64, 0x65,
	0x6e, 0x65, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x20, 0x73, 0x65, 0x74, 0x20, 0x6f, 0x6e, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x53, 0x65, 0x65, 0x64, 0x2e, 0x0a, 0x20, 0x33, 0x2e, 0x20, 0x50, 0x6f,
	0x6c, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x77,
	0x69, 0x74, 0x68, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61,
	0x53, 0x20, 0x53, 0x44, 0x4b, 0x2e, 0x0a, 0x20, 0x34, 0x2e, 0x20, 0x43, 0x61, 0x6c, 0x6c, 0x20,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x2c, 0x20, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x20, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x20, 0x64, 0x65, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70, 0x61, 0x74, 0x68, 0x2e, 0x0a, 0x20, 0x35,
	0x2e, 0x20, 0x43, 0x61, 0x6c, 0x6c, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2c, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x79, 0x69,
	0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x4d,
	0x50, 0x43, 0x4b, 0x65, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x2e, 0x0a, 0x20, 0x36, 0x2e, 0x20, 0x50, 0x6f, 0x6c, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x2e, 0xca, 0x41, 0x28,
	0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x77, 0x61, 0x61, 0x73, 0x2f,
	0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x42, 0xb6, 0x01, 0x5a, 0x4c, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2f, 0x77, 0x61, 0x61, 0x73, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2d, 0x6c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x2d, 0x67, 0x6f, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x70,
	0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x76, 0x31, 0x92, 0x41, 0x65, 0x12, 0x12, 0x0a, 0x0b,
	0x4d, 0x50, 0x43, 0x4b, 0x65, 0x79, 0x73, 0x20, 0x41, 0x50, 0x49, 0x32, 0x03, 0x31, 0x2e, 0x30,
	0x1a, 0x28, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x77, 0x61, 0x61,
	0x73, 0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2a, 0x01, 0x02, 0x32, 0x10, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x3a,
	0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6a, 0x73, 0x6f,
	0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescOnce sync.Once
	file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescData = file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDesc
)

func file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescGZIP() []byte {
	file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescOnce.Do(func() {
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescData = protoimpl.X.CompressGZIP(file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescData)
	})
	return file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDescData
}

var file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_goTypes = []interface{}{
	(*Device)(nil),                       // 0: coinbase.cloud.mpc_keys.v1.Device
	(*HardenedChild)(nil),                // 1: coinbase.cloud.mpc_keys.v1.HardenedChild
	(*Seed)(nil),                         // 2: coinbase.cloud.mpc_keys.v1.Seed
	(*DeviceGroup)(nil),                  // 3: coinbase.cloud.mpc_keys.v1.DeviceGroup
	(*MPCOperation)(nil),                 // 4: coinbase.cloud.mpc_keys.v1.MPCOperation
	(*MPCKey)(nil),                       // 5: coinbase.cloud.mpc_keys.v1.MPCKey
	(*Signature)(nil),                    // 6: coinbase.cloud.mpc_keys.v1.Signature
	(*RegisterDeviceRequest)(nil),        // 7: coinbase.cloud.mpc_keys.v1.RegisterDeviceRequest
	(*GetDeviceRequest)(nil),             // 8: coinbase.cloud.mpc_keys.v1.GetDeviceRequest
	(*CreateDeviceGroupRequest)(nil),     // 9: coinbase.cloud.mpc_keys.v1.CreateDeviceGroupRequest
	(*CreateDeviceGroupMetadata)(nil),    // 10: coinbase.cloud.mpc_keys.v1.CreateDeviceGroupMetadata
	(*GetDeviceGroupRequest)(nil),        // 11: coinbase.cloud.mpc_keys.v1.GetDeviceGroupRequest
	(*ListMPCOperationsRequest)(nil),     // 12: coinbase.cloud.mpc_keys.v1.ListMPCOperationsRequest
	(*ListMPCOperationsResponse)(nil),    // 13: coinbase.cloud.mpc_keys.v1.ListMPCOperationsResponse
	(*CreateMPCKeyRequest)(nil),          // 14: coinbase.cloud.mpc_keys.v1.CreateMPCKeyRequest
	(*GetMPCKeyRequest)(nil),             // 15: coinbase.cloud.mpc_keys.v1.GetMPCKeyRequest
	(*CreateSignatureRequest)(nil),       // 16: coinbase.cloud.mpc_keys.v1.CreateSignatureRequest
	(*CreateSignatureMetadata)(nil),      // 17: coinbase.cloud.mpc_keys.v1.CreateSignatureMetadata
	(*PrepareDeviceArchiveRequest)(nil),  // 18: coinbase.cloud.mpc_keys.v1.PrepareDeviceArchiveRequest
	(*PrepareDeviceArchiveMetadata)(nil), // 19: coinbase.cloud.mpc_keys.v1.PrepareDeviceArchiveMetadata
	(*PrepareDeviceBackupRequest)(nil),   // 20: coinbase.cloud.mpc_keys.v1.PrepareDeviceBackupRequest
	(*PrepareDeviceBackupMetadata)(nil),  // 21: coinbase.cloud.mpc_keys.v1.PrepareDeviceBackupMetadata
	(*AddDeviceRequest)(nil),             // 22: coinbase.cloud.mpc_keys.v1.AddDeviceRequest
	(*AddDeviceMetadata)(nil),            // 23: coinbase.cloud.mpc_keys.v1.AddDeviceMetadata
	(*RevokeDeviceRequest)(nil),          // 24: coinbase.cloud.mpc_keys.v1.RevokeDeviceRequest
	(*v1.PublicKey)(nil),                 // 25: coinbase.crypto.types.v1.PublicKey
	(*v1.Signature)(nil),                 // 26: coinbase.crypto.types.v1.Signature
	(*longrunning.Operation)(nil),        // 27: google.longrunning.Operation
	(*emptypb.Empty)(nil),                // 28: google.protobuf.Empty
}
var file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_depIdxs = []int32{
	1,  // 0: coinbase.cloud.mpc_keys.v1.Seed.hardened_children:type_name -> coinbase.cloud.mpc_keys.v1.HardenedChild
	2,  // 1: coinbase.cloud.mpc_keys.v1.DeviceGroup.seed:type_name -> coinbase.cloud.mpc_keys.v1.Seed
	10, // 2: coinbase.cloud.mpc_keys.v1.MPCOperation.create_device_group_metadata:type_name -> coinbase.cloud.mpc_keys.v1.CreateDeviceGroupMetadata
	17, // 3: coinbase.cloud.mpc_keys.v1.MPCOperation.create_signature_metadata:type_name -> coinbase.cloud.mpc_keys.v1.CreateSignatureMetadata
	19, // 4: coinbase.cloud.mpc_keys.v1.MPCOperation.prepare_device_archive_metadata:type_name -> coinbase.cloud.mpc_keys.v1.PrepareDeviceArchiveMetadata
	21, // 5: coinbase.cloud.mpc_keys.v1.MPCOperation.prepare_device_backup_metadata:type_name -> coinbase.cloud.mpc_keys.v1.PrepareDeviceBackupMetadata
	23, // 6: coinbase.cloud.mpc_keys.v1.MPCOperation.add_device_metadata:type_name -> coinbase.cloud.mpc_keys.v1.AddDeviceMetadata
	25, // 7: coinbase.cloud.mpc_keys.v1.MPCKey.public_key:type_name -> coinbase.crypto.types.v1.PublicKey
	26, // 8: coinbase.cloud.mpc_keys.v1.Signature.signature:type_name -> coinbase.crypto.types.v1.Signature
	3,  // 9: coinbase.cloud.mpc_keys.v1.CreateDeviceGroupRequest.device_group:type_name -> coinbase.cloud.mpc_keys.v1.DeviceGroup
	4,  // 10: coinbase.cloud.mpc_keys.v1.ListMPCOperationsResponse.mpc_operations:type_name -> coinbase.cloud.mpc_keys.v1.MPCOperation
	5,  // 11: coinbase.cloud.mpc_keys.v1.CreateMPCKeyRequest.mpc_key:type_name -> coinbase.cloud.mpc_keys.v1.MPCKey
	6,  // 12: coinbase.cloud.mpc_keys.v1.CreateSignatureRequest.signature:type_name -> coinbase.cloud.mpc_keys.v1.Signature
	7,  // 13: coinbase.cloud.mpc_keys.v1.MPCKeyService.RegisterDevice:input_type -> coinbase.cloud.mpc_keys.v1.RegisterDeviceRequest
	8,  // 14: coinbase.cloud.mpc_keys.v1.MPCKeyService.GetDevice:input_type -> coinbase.cloud.mpc_keys.v1.GetDeviceRequest
	9,  // 15: coinbase.cloud.mpc_keys.v1.MPCKeyService.CreateDeviceGroup:input_type -> coinbase.cloud.mpc_keys.v1.CreateDeviceGroupRequest
	11, // 16: coinbase.cloud.mpc_keys.v1.MPCKeyService.GetDeviceGroup:input_type -> coinbase.cloud.mpc_keys.v1.GetDeviceGroupRequest
	12, // 17: coinbase.cloud.mpc_keys.v1.MPCKeyService.ListMPCOperations:input_type -> coinbase.cloud.mpc_keys.v1.ListMPCOperationsRequest
	14, // 18: coinbase.cloud.mpc_keys.v1.MPCKeyService.CreateMPCKey:input_type -> coinbase.cloud.mpc_keys.v1.CreateMPCKeyRequest
	15, // 19: coinbase.cloud.mpc_keys.v1.MPCKeyService.GetMPCKey:input_type -> coinbase.cloud.mpc_keys.v1.GetMPCKeyRequest
	16, // 20: coinbase.cloud.mpc_keys.v1.MPCKeyService.CreateSignature:input_type -> coinbase.cloud.mpc_keys.v1.CreateSignatureRequest
	18, // 21: coinbase.cloud.mpc_keys.v1.MPCKeyService.PrepareDeviceArchive:input_type -> coinbase.cloud.mpc_keys.v1.PrepareDeviceArchiveRequest
	20, // 22: coinbase.cloud.mpc_keys.v1.MPCKeyService.PrepareDeviceBackup:input_type -> coinbase.cloud.mpc_keys.v1.PrepareDeviceBackupRequest
	22, // 23: coinbase.cloud.mpc_keys.v1.MPCKeyService.AddDevice:input_type -> coinbase.cloud.mpc_keys.v1.AddDeviceRequest
	24, // 24: coinbase.cloud.mpc_keys.v1.MPCKeyService.RevokeDevice:input_type -> coinbase.cloud.mpc_keys.v1.RevokeDeviceRequest
	0,  // 25: coinbase.cloud.mpc_keys.v1.MPCKeyService.RegisterDevice:output_type -> coinbase.cloud.mpc_keys.v1.Device
	0,  // 26: coinbase.cloud.mpc_keys.v1.MPCKeyService.GetDevice:output_type -> coinbase.cloud.mpc_keys.v1.Device
	27, // 27: coinbase.cloud.mpc_keys.v1.MPCKeyService.CreateDeviceGroup:output_type -> google.longrunning.Operation
	3,  // 28: coinbase.cloud.mpc_keys.v1.MPCKeyService.GetDeviceGroup:output_type -> coinbase.cloud.mpc_keys.v1.DeviceGroup
	13, // 29: coinbase.cloud.mpc_keys.v1.MPCKeyService.ListMPCOperations:output_type -> coinbase.cloud.mpc_keys.v1.ListMPCOperationsResponse
	5,  // 30: coinbase.cloud.mpc_keys.v1.MPCKeyService.CreateMPCKey:output_type -> coinbase.cloud.mpc_keys.v1.MPCKey
	5,  // 31: coinbase.cloud.mpc_keys.v1.MPCKeyService.GetMPCKey:output_type -> coinbase.cloud.mpc_keys.v1.MPCKey
	27, // 32: coinbase.cloud.mpc_keys.v1.MPCKeyService.CreateSignature:output_type -> google.longrunning.Operation
	27, // 33: coinbase.cloud.mpc_keys.v1.MPCKeyService.PrepareDeviceArchive:output_type -> google.longrunning.Operation
	27, // 34: coinbase.cloud.mpc_keys.v1.MPCKeyService.PrepareDeviceBackup:output_type -> google.longrunning.Operation
	27, // 35: coinbase.cloud.mpc_keys.v1.MPCKeyService.AddDevice:output_type -> google.longrunning.Operation
	28, // 36: coinbase.cloud.mpc_keys.v1.MPCKeyService.RevokeDevice:output_type -> google.protobuf.Empty
	25, // [25:37] is the sub-list for method output_type
	13, // [13:25] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_init() }
func file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_init() {
	if File_coinbase_cloud_mpc_keys_v1_mpc_keys_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Device); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HardenedChild); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Seed); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MPCOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MPCKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Signature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDeviceGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDeviceGroupMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeviceGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMPCOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMPCOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMPCKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMPCKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSignatureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSignatureMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareDeviceArchiveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareDeviceArchiveMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareDeviceBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrepareDeviceBackupMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddDeviceMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RevokeDeviceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*MPCOperation_CreateDeviceGroupMetadata)(nil),
		(*MPCOperation_CreateSignatureMetadata)(nil),
		(*MPCOperation_PrepareDeviceArchiveMetadata)(nil),
		(*MPCOperation_PrepareDeviceBackupMetadata)(nil),
		(*MPCOperation_AddDeviceMetadata)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_goTypes,
		DependencyIndexes: file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_depIdxs,
		MessageInfos:      file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_msgTypes,
	}.Build()
	File_coinbase_cloud_mpc_keys_v1_mpc_keys_proto = out.File
	file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_rawDesc = nil
	file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_goTypes = nil
	file_coinbase_cloud_mpc_keys_v1_mpc_keys_proto_depIdxs = nil
}
