/*
 * Decompiled with CFR 0.152.
 */
package org.webpki.jcs;

import java.io.IOException;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;

class JsonDecoder {
    static final char LEFT_CURLY_BRACKET = '{';
    static final char RIGHT_CURLY_BRACKET = '}';
    static final char DOUBLE_QUOTE = '\"';
    static final char COLON_CHARACTER = ':';
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char COMMA_CHARACTER = ',';
    static final char BACK_SLASH = '\\';
    static final Pattern BOOLEAN_PATTERN = Pattern.compile("true|false");
    static final Pattern NUMBER_PATTERN = Pattern.compile("-?[0-9]+(\\.[0-9]+)?([eE][-+]?[0-9]+)?");
    int index;
    int maxLength;
    String jsonData;
    Object root;

    JsonDecoder(String jsonString) throws IOException {
        this.jsonData = jsonString;
        this.maxLength = this.jsonData.length();
        if (this.testNextNonWhiteSpaceChar() == '[') {
            this.scan();
            this.root = this.parseArray();
        } else {
            this.scanFor('{');
            this.root = this.parseObject();
        }
        while (this.index < this.maxLength) {
            if (this.isWhiteSpace(this.jsonData.charAt(this.index++))) continue;
            throw new IOException("Improperly terminated JSON object");
        }
    }

    Object parseElement() throws IOException {
        switch (this.scan()) {
            case '{': {
                return this.parseObject();
            }
            case '\"': {
                return this.parseQuotedString();
            }
            case '[': {
                return this.parseArray();
            }
        }
        return this.parseSimpleType();
    }

    Object parseObject() throws IOException {
        TreeMap<String, Object> dict = new TreeMap<String, Object>();
        boolean next = false;
        while (this.testNextNonWhiteSpaceChar() != '}') {
            if (next) {
                this.scanFor(',');
            }
            next = true;
            this.scanFor('\"');
            String name = this.parseQuotedString();
            this.scanFor(':');
            if (dict.put(name, this.parseElement()) == null) continue;
            throw new IOException("Duplicate property: " + name);
        }
        this.scan();
        return dict;
    }

    Object parseArray() throws IOException {
        Vector<Object> array = new Vector<Object>();
        boolean next = false;
        while (this.testNextNonWhiteSpaceChar() != ']') {
            if (next) {
                this.scanFor(',');
            } else {
                next = true;
            }
            array.add(this.parseElement());
        }
        this.scan();
        return array;
    }

    Object parseSimpleType() throws IOException {
        char c;
        --this.index;
        StringBuilder tempBuffer = new StringBuilder();
        while ((c = this.testNextNonWhiteSpaceChar()) != ',' && c != ']' && c != '}' && !this.isWhiteSpace(c = this.nextChar())) {
            tempBuffer.append(c);
        }
        String token = tempBuffer.toString();
        if (token.length() == 0) {
            throw new IOException("Missing argument");
        }
        if (NUMBER_PATTERN.matcher(token).matches()) {
            return Double.valueOf(token);
        }
        if (BOOLEAN_PATTERN.matcher(token).matches()) {
            return new Boolean(token);
        }
        if (token.equals("null")) {
            return null;
        }
        throw new IOException("Unrecognized or malformed JSON token: " + token);
    }

    String parseQuotedString() throws IOException {
        StringBuilder result = new StringBuilder();
        while (true) {
            char c;
            if ((c = this.nextChar()) < ' ') {
                throw new IOException(c == '\n' ? "Unterminated string literal" : "Unescaped control character: 0x" + Integer.toString(c, 16));
            }
            if (c == '\"') break;
            if (c == '\\') {
                c = this.nextChar();
                switch (c) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'u': {
                        c = '\u0000';
                        for (int i = 0; i < 4; ++i) {
                            c = (char)((c << 4) + this.getHexChar());
                        }
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported escape:" + c);
                    }
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    char getHexChar() throws IOException {
        char c = this.nextChar();
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (char)(c - 48);
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (char)(c - 97 + 10);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (char)(c - 65 + 10);
            }
        }
        throw new IOException("Bad hex in \\u escape: " + c);
    }

    char testNextNonWhiteSpaceChar() throws IOException {
        int save = this.index;
        char c = this.scan();
        this.index = save;
        return c;
    }

    void scanFor(char expected) throws IOException {
        char c = this.scan();
        if (c != expected) {
            throw new IOException("Expected '" + expected + "' but got '" + c + "'");
        }
    }

    char nextChar() throws IOException {
        if (this.index < this.maxLength) {
            return this.jsonData.charAt(this.index++);
        }
        throw new IOException("Unexpected EOF reached");
    }

    boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    char scan() throws IOException {
        char c;
        while (this.isWhiteSpace(c = this.nextChar())) {
        }
        return c;
    }
}

