// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

Storage

*/

// StorageSerializedStorageKey ...
type StorageSerializedStorageKey string

// StorageStorageType Enum of possible storage types.
type StorageStorageType string

const (
	// StorageStorageTypeAppcache enum const.
	StorageStorageTypeAppcache StorageStorageType = "appcache"

	// StorageStorageTypeCookies enum const.
	StorageStorageTypeCookies StorageStorageType = "cookies"

	// StorageStorageTypeFileSystems enum const.
	StorageStorageTypeFileSystems StorageStorageType = "file_systems"

	// StorageStorageTypeIndexeddb enum const.
	StorageStorageTypeIndexeddb StorageStorageType = "indexeddb"

	// StorageStorageTypeLocalStorage enum const.
	StorageStorageTypeLocalStorage StorageStorageType = "local_storage"

	// StorageStorageTypeShaderCache enum const.
	StorageStorageTypeShaderCache StorageStorageType = "shader_cache"

	// StorageStorageTypeWebsql enum const.
	StorageStorageTypeWebsql StorageStorageType = "websql"

	// StorageStorageTypeServiceWorkers enum const.
	StorageStorageTypeServiceWorkers StorageStorageType = "service_workers"

	// StorageStorageTypeCacheStorage enum const.
	StorageStorageTypeCacheStorage StorageStorageType = "cache_storage"

	// StorageStorageTypeInterestGroups enum const.
	StorageStorageTypeInterestGroups StorageStorageType = "interest_groups"

	// StorageStorageTypeSharedStorage enum const.
	StorageStorageTypeSharedStorage StorageStorageType = "shared_storage"

	// StorageStorageTypeStorageBuckets enum const.
	StorageStorageTypeStorageBuckets StorageStorageType = "storage_buckets"

	// StorageStorageTypeAll enum const.
	StorageStorageTypeAll StorageStorageType = "all"

	// StorageStorageTypeOther enum const.
	StorageStorageTypeOther StorageStorageType = "other"
)

// StorageUsageForType Usage for a storage type.
type StorageUsageForType struct {
	// StorageType Name of storage type.
	StorageType StorageStorageType `json:"storageType"`

	// Usage Storage usage (bytes).
	Usage float64 `json:"usage"`
}

// StorageTrustTokens (experimental) Pair of issuer origin and number of available (signed, but not used) Trust
// Tokens from that issuer.
type StorageTrustTokens struct {
	// IssuerOrigin ...
	IssuerOrigin string `json:"issuerOrigin"`

	// Count ...
	Count float64 `json:"count"`
}

// StorageInterestGroupAuctionID Protected audience interest group auction identifier.
type StorageInterestGroupAuctionID string

// StorageInterestGroupAccessType Enum of interest group access types.
type StorageInterestGroupAccessType string

const (
	// StorageInterestGroupAccessTypeJoin enum const.
	StorageInterestGroupAccessTypeJoin StorageInterestGroupAccessType = "join"

	// StorageInterestGroupAccessTypeLeave enum const.
	StorageInterestGroupAccessTypeLeave StorageInterestGroupAccessType = "leave"

	// StorageInterestGroupAccessTypeUpdate enum const.
	StorageInterestGroupAccessTypeUpdate StorageInterestGroupAccessType = "update"

	// StorageInterestGroupAccessTypeLoaded enum const.
	StorageInterestGroupAccessTypeLoaded StorageInterestGroupAccessType = "loaded"

	// StorageInterestGroupAccessTypeBid enum const.
	StorageInterestGroupAccessTypeBid StorageInterestGroupAccessType = "bid"

	// StorageInterestGroupAccessTypeWin enum const.
	StorageInterestGroupAccessTypeWin StorageInterestGroupAccessType = "win"

	// StorageInterestGroupAccessTypeAdditionalBid enum const.
	StorageInterestGroupAccessTypeAdditionalBid StorageInterestGroupAccessType = "additionalBid"

	// StorageInterestGroupAccessTypeAdditionalBidWin enum const.
	StorageInterestGroupAccessTypeAdditionalBidWin StorageInterestGroupAccessType = "additionalBidWin"

	// StorageInterestGroupAccessTypeTopLevelBid enum const.
	StorageInterestGroupAccessTypeTopLevelBid StorageInterestGroupAccessType = "topLevelBid"

	// StorageInterestGroupAccessTypeTopLevelAdditionalBid enum const.
	StorageInterestGroupAccessTypeTopLevelAdditionalBid StorageInterestGroupAccessType = "topLevelAdditionalBid"

	// StorageInterestGroupAccessTypeClear enum const.
	StorageInterestGroupAccessTypeClear StorageInterestGroupAccessType = "clear"
)

// StorageInterestGroupAuctionEventType Enum of auction events.
type StorageInterestGroupAuctionEventType string

const (
	// StorageInterestGroupAuctionEventTypeStarted enum const.
	StorageInterestGroupAuctionEventTypeStarted StorageInterestGroupAuctionEventType = "started"

	// StorageInterestGroupAuctionEventTypeConfigResolved enum const.
	StorageInterestGroupAuctionEventTypeConfigResolved StorageInterestGroupAuctionEventType = "configResolved"
)

// StorageInterestGroupAuctionFetchType Enum of network fetches auctions can do.
type StorageInterestGroupAuctionFetchType string

const (
	// StorageInterestGroupAuctionFetchTypeBidderJs enum const.
	StorageInterestGroupAuctionFetchTypeBidderJs StorageInterestGroupAuctionFetchType = "bidderJs"

	// StorageInterestGroupAuctionFetchTypeBidderWasm enum const.
	StorageInterestGroupAuctionFetchTypeBidderWasm StorageInterestGroupAuctionFetchType = "bidderWasm"

	// StorageInterestGroupAuctionFetchTypeSellerJs enum const.
	StorageInterestGroupAuctionFetchTypeSellerJs StorageInterestGroupAuctionFetchType = "sellerJs"

	// StorageInterestGroupAuctionFetchTypeBidderTrustedSignals enum const.
	StorageInterestGroupAuctionFetchTypeBidderTrustedSignals StorageInterestGroupAuctionFetchType = "bidderTrustedSignals"

	// StorageInterestGroupAuctionFetchTypeSellerTrustedSignals enum const.
	StorageInterestGroupAuctionFetchTypeSellerTrustedSignals StorageInterestGroupAuctionFetchType = "sellerTrustedSignals"
)

// StorageSharedStorageAccessType Enum of shared storage access types.
type StorageSharedStorageAccessType string

const (
	// StorageSharedStorageAccessTypeDocumentAddModule enum const.
	StorageSharedStorageAccessTypeDocumentAddModule StorageSharedStorageAccessType = "documentAddModule"

	// StorageSharedStorageAccessTypeDocumentSelectURL enum const.
	StorageSharedStorageAccessTypeDocumentSelectURL StorageSharedStorageAccessType = "documentSelectURL"

	// StorageSharedStorageAccessTypeDocumentRun enum const.
	StorageSharedStorageAccessTypeDocumentRun StorageSharedStorageAccessType = "documentRun"

	// StorageSharedStorageAccessTypeDocumentSet enum const.
	StorageSharedStorageAccessTypeDocumentSet StorageSharedStorageAccessType = "documentSet"

	// StorageSharedStorageAccessTypeDocumentAppend enum const.
	StorageSharedStorageAccessTypeDocumentAppend StorageSharedStorageAccessType = "documentAppend"

	// StorageSharedStorageAccessTypeDocumentDelete enum const.
	StorageSharedStorageAccessTypeDocumentDelete StorageSharedStorageAccessType = "documentDelete"

	// StorageSharedStorageAccessTypeDocumentClear enum const.
	StorageSharedStorageAccessTypeDocumentClear StorageSharedStorageAccessType = "documentClear"

	// StorageSharedStorageAccessTypeDocumentGet enum const.
	StorageSharedStorageAccessTypeDocumentGet StorageSharedStorageAccessType = "documentGet"

	// StorageSharedStorageAccessTypeWorkletSet enum const.
	StorageSharedStorageAccessTypeWorkletSet StorageSharedStorageAccessType = "workletSet"

	// StorageSharedStorageAccessTypeWorkletAppend enum const.
	StorageSharedStorageAccessTypeWorkletAppend StorageSharedStorageAccessType = "workletAppend"

	// StorageSharedStorageAccessTypeWorkletDelete enum const.
	StorageSharedStorageAccessTypeWorkletDelete StorageSharedStorageAccessType = "workletDelete"

	// StorageSharedStorageAccessTypeWorkletClear enum const.
	StorageSharedStorageAccessTypeWorkletClear StorageSharedStorageAccessType = "workletClear"

	// StorageSharedStorageAccessTypeWorkletGet enum const.
	StorageSharedStorageAccessTypeWorkletGet StorageSharedStorageAccessType = "workletGet"

	// StorageSharedStorageAccessTypeWorkletKeys enum const.
	StorageSharedStorageAccessTypeWorkletKeys StorageSharedStorageAccessType = "workletKeys"

	// StorageSharedStorageAccessTypeWorkletEntries enum const.
	StorageSharedStorageAccessTypeWorkletEntries StorageSharedStorageAccessType = "workletEntries"

	// StorageSharedStorageAccessTypeWorkletLength enum const.
	StorageSharedStorageAccessTypeWorkletLength StorageSharedStorageAccessType = "workletLength"

	// StorageSharedStorageAccessTypeWorkletRemainingBudget enum const.
	StorageSharedStorageAccessTypeWorkletRemainingBudget StorageSharedStorageAccessType = "workletRemainingBudget"

	// StorageSharedStorageAccessTypeHeaderSet enum const.
	StorageSharedStorageAccessTypeHeaderSet StorageSharedStorageAccessType = "headerSet"

	// StorageSharedStorageAccessTypeHeaderAppend enum const.
	StorageSharedStorageAccessTypeHeaderAppend StorageSharedStorageAccessType = "headerAppend"

	// StorageSharedStorageAccessTypeHeaderDelete enum const.
	StorageSharedStorageAccessTypeHeaderDelete StorageSharedStorageAccessType = "headerDelete"

	// StorageSharedStorageAccessTypeHeaderClear enum const.
	StorageSharedStorageAccessTypeHeaderClear StorageSharedStorageAccessType = "headerClear"
)

// StorageSharedStorageEntry Struct for a single key-value pair in an origin's shared storage.
type StorageSharedStorageEntry struct {
	// Key ...
	Key string `json:"key"`

	// Value ...
	Value string `json:"value"`
}

// StorageSharedStorageMetadata Details for an origin's shared storage.
type StorageSharedStorageMetadata struct {
	// CreationTime Time when the origin's shared storage was last created.
	CreationTime TimeSinceEpoch `json:"creationTime"`

	// Length Number of key-value pairs stored in origin's shared storage.
	Length int `json:"length"`

	// RemainingBudget Current amount of bits of entropy remaining in the navigation budget.
	RemainingBudget float64 `json:"remainingBudget"`

	// BytesUsed Total number of bytes stored as key-value pairs in origin's shared
	// storage.
	BytesUsed int `json:"bytesUsed"`
}

// StorageSharedStorageReportingMetadata Pair of reporting metadata details for a candidate URL for `selectURL()`.
type StorageSharedStorageReportingMetadata struct {
	// EventType ...
	EventType string `json:"eventType"`

	// ReportingURL ...
	ReportingURL string `json:"reportingUrl"`
}

// StorageSharedStorageURLWithMetadata Bundles a candidate URL with its reporting metadata.
type StorageSharedStorageURLWithMetadata struct {
	// URL Spec of candidate URL.
	URL string `json:"url"`

	// ReportingMetadata Any associated reporting metadata.
	ReportingMetadata []*StorageSharedStorageReportingMetadata `json:"reportingMetadata"`
}

// StorageSharedStorageAccessParams Bundles the parameters for shared storage access events whose
// presence/absence can vary according to SharedStorageAccessType.
type StorageSharedStorageAccessParams struct {
	// ScriptSourceURL (optional) Spec of the module script URL.
	// Present only for SharedStorageAccessType.documentAddModule.
	ScriptSourceURL string `json:"scriptSourceUrl,omitempty"`

	// OperationName (optional) Name of the registered operation to be run.
	// Present only for SharedStorageAccessType.documentRun and
	// SharedStorageAccessType.documentSelectURL.
	OperationName string `json:"operationName,omitempty"`

	// SerializedData (optional) The operation's serialized data in bytes (converted to a string).
	// Present only for SharedStorageAccessType.documentRun and
	// SharedStorageAccessType.documentSelectURL.
	SerializedData string `json:"serializedData,omitempty"`

	// UrlsWithMetadata (optional) Array of candidate URLs' specs, along with any associated metadata.
	// Present only for SharedStorageAccessType.documentSelectURL.
	UrlsWithMetadata []*StorageSharedStorageURLWithMetadata `json:"urlsWithMetadata,omitempty"`

	// Key (optional) Key for a specific entry in an origin's shared storage.
	// Present only for SharedStorageAccessType.documentSet,
	// SharedStorageAccessType.documentAppend,
	// SharedStorageAccessType.documentDelete,
	// SharedStorageAccessType.workletSet,
	// SharedStorageAccessType.workletAppend,
	// SharedStorageAccessType.workletDelete,
	// SharedStorageAccessType.workletGet,
	// SharedStorageAccessType.headerSet,
	// SharedStorageAccessType.headerAppend, and
	// SharedStorageAccessType.headerDelete.
	Key string `json:"key,omitempty"`

	// Value (optional) Value for a specific entry in an origin's shared storage.
	// Present only for SharedStorageAccessType.documentSet,
	// SharedStorageAccessType.documentAppend,
	// SharedStorageAccessType.workletSet,
	// SharedStorageAccessType.workletAppend,
	// SharedStorageAccessType.headerSet, and
	// SharedStorageAccessType.headerAppend.
	Value string `json:"value,omitempty"`

	// IgnoreIfPresent (optional) Whether or not to set an entry for a key if that key is already present.
	// Present only for SharedStorageAccessType.documentSet,
	// SharedStorageAccessType.workletSet, and
	// SharedStorageAccessType.headerSet.
	IgnoreIfPresent bool `json:"ignoreIfPresent,omitempty"`
}

// StorageStorageBucketsDurability ...
type StorageStorageBucketsDurability string

const (
	// StorageStorageBucketsDurabilityRelaxed enum const.
	StorageStorageBucketsDurabilityRelaxed StorageStorageBucketsDurability = "relaxed"

	// StorageStorageBucketsDurabilityStrict enum const.
	StorageStorageBucketsDurabilityStrict StorageStorageBucketsDurability = "strict"
)

// StorageStorageBucket ...
type StorageStorageBucket struct {
	// StorageKey ...
	StorageKey StorageSerializedStorageKey `json:"storageKey"`

	// Name (optional) If not specified, it is the default bucket of the storageKey.
	Name string `json:"name,omitempty"`
}

// StorageStorageBucketInfo ...
type StorageStorageBucketInfo struct {
	// Bucket ...
	Bucket *StorageStorageBucket `json:"bucket"`

	// ID ...
	ID string `json:"id"`

	// Expiration ...
	Expiration TimeSinceEpoch `json:"expiration"`

	// Quota Storage quota (bytes).
	Quota float64 `json:"quota"`

	// Persistent ...
	Persistent bool `json:"persistent"`

	// Durability ...
	Durability StorageStorageBucketsDurability `json:"durability"`
}

// StorageAttributionReportingSourceType (experimental) ...
type StorageAttributionReportingSourceType string

const (
	// StorageAttributionReportingSourceTypeNavigation enum const.
	StorageAttributionReportingSourceTypeNavigation StorageAttributionReportingSourceType = "navigation"

	// StorageAttributionReportingSourceTypeEvent enum const.
	StorageAttributionReportingSourceTypeEvent StorageAttributionReportingSourceType = "event"
)

// StorageUnsignedInt64AsBase10 (experimental) ...
type StorageUnsignedInt64AsBase10 string

// StorageUnsignedInt128AsBase16 (experimental) ...
type StorageUnsignedInt128AsBase16 string

// StorageSignedInt64AsBase10 (experimental) ...
type StorageSignedInt64AsBase10 string

// StorageAttributionReportingFilterDataEntry (experimental) ...
type StorageAttributionReportingFilterDataEntry struct {
	// Key ...
	Key string `json:"key"`

	// Values ...
	Values []string `json:"values"`
}

// StorageAttributionReportingFilterConfig (experimental) ...
type StorageAttributionReportingFilterConfig struct {
	// FilterValues ...
	FilterValues []*StorageAttributionReportingFilterDataEntry `json:"filterValues"`

	// LookbackWindow (optional) duration in seconds
	LookbackWindow *int `json:"lookbackWindow,omitempty"`
}

// StorageAttributionReportingFilterPair (experimental) ...
type StorageAttributionReportingFilterPair struct {
	// Filters ...
	Filters []*StorageAttributionReportingFilterConfig `json:"filters"`

	// NotFilters ...
	NotFilters []*StorageAttributionReportingFilterConfig `json:"notFilters"`
}

// StorageAttributionReportingAggregationKeysEntry (experimental) ...
type StorageAttributionReportingAggregationKeysEntry struct {
	// Key ...
	Key string `json:"key"`

	// Value ...
	Value StorageUnsignedInt128AsBase16 `json:"value"`
}

// StorageAttributionReportingEventReportWindows (experimental) ...
type StorageAttributionReportingEventReportWindows struct {
	// Start duration in seconds
	Start int `json:"start"`

	// Ends duration in seconds
	Ends []int `json:"ends"`
}

// StorageAttributionReportingTriggerSpec (experimental) ...
type StorageAttributionReportingTriggerSpec struct {
	// TriggerData number instead of integer because not all uint32 can be represented by
	// int
	TriggerData []float64 `json:"triggerData"`

	// EventReportWindows ...
	EventReportWindows *StorageAttributionReportingEventReportWindows `json:"eventReportWindows"`
}

// StorageAttributionReportingTriggerDataMatching (experimental) ...
type StorageAttributionReportingTriggerDataMatching string

const (
	// StorageAttributionReportingTriggerDataMatchingExact enum const.
	StorageAttributionReportingTriggerDataMatchingExact StorageAttributionReportingTriggerDataMatching = "exact"

	// StorageAttributionReportingTriggerDataMatchingModulus enum const.
	StorageAttributionReportingTriggerDataMatchingModulus StorageAttributionReportingTriggerDataMatching = "modulus"
)

// StorageAttributionReportingSourceRegistration (experimental) ...
type StorageAttributionReportingSourceRegistration struct {
	// Time ...
	Time TimeSinceEpoch `json:"time"`

	// Expiry duration in seconds
	Expiry int `json:"expiry"`

	// TriggerSpecs ...
	TriggerSpecs []*StorageAttributionReportingTriggerSpec `json:"triggerSpecs"`

	// AggregatableReportWindow duration in seconds
	AggregatableReportWindow int `json:"aggregatableReportWindow"`

	// Type ...
	Type StorageAttributionReportingSourceType `json:"type"`

	// SourceOrigin ...
	SourceOrigin string `json:"sourceOrigin"`

	// ReportingOrigin ...
	ReportingOrigin string `json:"reportingOrigin"`

	// DestinationSites ...
	DestinationSites []string `json:"destinationSites"`

	// EventID ...
	EventID StorageUnsignedInt64AsBase10 `json:"eventId"`

	// Priority ...
	Priority StorageSignedInt64AsBase10 `json:"priority"`

	// FilterData ...
	FilterData []*StorageAttributionReportingFilterDataEntry `json:"filterData"`

	// AggregationKeys ...
	AggregationKeys []*StorageAttributionReportingAggregationKeysEntry `json:"aggregationKeys"`

	// DebugKey (optional) ...
	DebugKey StorageUnsignedInt64AsBase10 `json:"debugKey,omitempty"`

	// TriggerDataMatching ...
	TriggerDataMatching StorageAttributionReportingTriggerDataMatching `json:"triggerDataMatching"`
}

// StorageAttributionReportingSourceRegistrationResult (experimental) ...
type StorageAttributionReportingSourceRegistrationResult string

const (
	// StorageAttributionReportingSourceRegistrationResultSuccess enum const.
	StorageAttributionReportingSourceRegistrationResultSuccess StorageAttributionReportingSourceRegistrationResult = "success"

	// StorageAttributionReportingSourceRegistrationResultInternalError enum const.
	StorageAttributionReportingSourceRegistrationResultInternalError StorageAttributionReportingSourceRegistrationResult = "internalError"

	// StorageAttributionReportingSourceRegistrationResultInsufficientSourceCapacity enum const.
	StorageAttributionReportingSourceRegistrationResultInsufficientSourceCapacity StorageAttributionReportingSourceRegistrationResult = "insufficientSourceCapacity"

	// StorageAttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity enum const.
	StorageAttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity StorageAttributionReportingSourceRegistrationResult = "insufficientUniqueDestinationCapacity"

	// StorageAttributionReportingSourceRegistrationResultExcessiveReportingOrigins enum const.
	StorageAttributionReportingSourceRegistrationResultExcessiveReportingOrigins StorageAttributionReportingSourceRegistrationResult = "excessiveReportingOrigins"

	// StorageAttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy enum const.
	StorageAttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy StorageAttributionReportingSourceRegistrationResult = "prohibitedByBrowserPolicy"

	// StorageAttributionReportingSourceRegistrationResultSuccessNoised enum const.
	StorageAttributionReportingSourceRegistrationResultSuccessNoised StorageAttributionReportingSourceRegistrationResult = "successNoised"

	// StorageAttributionReportingSourceRegistrationResultDestinationReportingLimitReached enum const.
	StorageAttributionReportingSourceRegistrationResultDestinationReportingLimitReached StorageAttributionReportingSourceRegistrationResult = "destinationReportingLimitReached"

	// StorageAttributionReportingSourceRegistrationResultDestinationGlobalLimitReached enum const.
	StorageAttributionReportingSourceRegistrationResultDestinationGlobalLimitReached StorageAttributionReportingSourceRegistrationResult = "destinationGlobalLimitReached"

	// StorageAttributionReportingSourceRegistrationResultDestinationBothLimitsReached enum const.
	StorageAttributionReportingSourceRegistrationResultDestinationBothLimitsReached StorageAttributionReportingSourceRegistrationResult = "destinationBothLimitsReached"

	// StorageAttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached enum const.
	StorageAttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached StorageAttributionReportingSourceRegistrationResult = "reportingOriginsPerSiteLimitReached"

	// StorageAttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity enum const.
	StorageAttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity StorageAttributionReportingSourceRegistrationResult = "exceedsMaxChannelCapacity"

	// StorageAttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality enum const.
	StorageAttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality StorageAttributionReportingSourceRegistrationResult = "exceedsMaxTriggerStateCardinality"
)

// StorageAttributionReportingSourceRegistrationTimeConfig (experimental) ...
type StorageAttributionReportingSourceRegistrationTimeConfig string

const (
	// StorageAttributionReportingSourceRegistrationTimeConfigInclude enum const.
	StorageAttributionReportingSourceRegistrationTimeConfigInclude StorageAttributionReportingSourceRegistrationTimeConfig = "include"

	// StorageAttributionReportingSourceRegistrationTimeConfigExclude enum const.
	StorageAttributionReportingSourceRegistrationTimeConfigExclude StorageAttributionReportingSourceRegistrationTimeConfig = "exclude"
)

// StorageAttributionReportingAggregatableValueDictEntry (experimental) ...
type StorageAttributionReportingAggregatableValueDictEntry struct {
	// Key ...
	Key string `json:"key"`

	// Value number instead of integer because not all uint32 can be represented by
	// int
	Value float64 `json:"value"`
}

// StorageAttributionReportingAggregatableValueEntry (experimental) ...
type StorageAttributionReportingAggregatableValueEntry struct {
	// Values ...
	Values []*StorageAttributionReportingAggregatableValueDictEntry `json:"values"`

	// Filters ...
	Filters *StorageAttributionReportingFilterPair `json:"filters"`
}

// StorageAttributionReportingEventTriggerData (experimental) ...
type StorageAttributionReportingEventTriggerData struct {
	// Data ...
	Data StorageUnsignedInt64AsBase10 `json:"data"`

	// Priority ...
	Priority StorageSignedInt64AsBase10 `json:"priority"`

	// DedupKey (optional) ...
	DedupKey StorageUnsignedInt64AsBase10 `json:"dedupKey,omitempty"`

	// Filters ...
	Filters *StorageAttributionReportingFilterPair `json:"filters"`
}

// StorageAttributionReportingAggregatableTriggerData (experimental) ...
type StorageAttributionReportingAggregatableTriggerData struct {
	// KeyPiece ...
	KeyPiece StorageUnsignedInt128AsBase16 `json:"keyPiece"`

	// SourceKeys ...
	SourceKeys []string `json:"sourceKeys"`

	// Filters ...
	Filters *StorageAttributionReportingFilterPair `json:"filters"`
}

// StorageAttributionReportingAggregatableDedupKey (experimental) ...
type StorageAttributionReportingAggregatableDedupKey struct {
	// DedupKey (optional) ...
	DedupKey StorageUnsignedInt64AsBase10 `json:"dedupKey,omitempty"`

	// Filters ...
	Filters *StorageAttributionReportingFilterPair `json:"filters"`
}

// StorageAttributionReportingTriggerRegistration (experimental) ...
type StorageAttributionReportingTriggerRegistration struct {
	// Filters ...
	Filters *StorageAttributionReportingFilterPair `json:"filters"`

	// DebugKey (optional) ...
	DebugKey StorageUnsignedInt64AsBase10 `json:"debugKey,omitempty"`

	// AggregatableDedupKeys ...
	AggregatableDedupKeys []*StorageAttributionReportingAggregatableDedupKey `json:"aggregatableDedupKeys"`

	// EventTriggerData ...
	EventTriggerData []*StorageAttributionReportingEventTriggerData `json:"eventTriggerData"`

	// AggregatableTriggerData ...
	AggregatableTriggerData []*StorageAttributionReportingAggregatableTriggerData `json:"aggregatableTriggerData"`

	// AggregatableValues ...
	AggregatableValues []*StorageAttributionReportingAggregatableValueEntry `json:"aggregatableValues"`

	// DebugReporting ...
	DebugReporting bool `json:"debugReporting"`

	// AggregationCoordinatorOrigin (optional) ...
	AggregationCoordinatorOrigin string `json:"aggregationCoordinatorOrigin,omitempty"`

	// SourceRegistrationTimeConfig ...
	SourceRegistrationTimeConfig StorageAttributionReportingSourceRegistrationTimeConfig `json:"sourceRegistrationTimeConfig"`

	// TriggerContextID (optional) ...
	TriggerContextID string `json:"triggerContextId,omitempty"`
}

// StorageAttributionReportingEventLevelResult (experimental) ...
type StorageAttributionReportingEventLevelResult string

const (
	// StorageAttributionReportingEventLevelResultSuccess enum const.
	StorageAttributionReportingEventLevelResultSuccess StorageAttributionReportingEventLevelResult = "success"

	// StorageAttributionReportingEventLevelResultSuccessDroppedLowerPriority enum const.
	StorageAttributionReportingEventLevelResultSuccessDroppedLowerPriority StorageAttributionReportingEventLevelResult = "successDroppedLowerPriority"

	// StorageAttributionReportingEventLevelResultInternalError enum const.
	StorageAttributionReportingEventLevelResultInternalError StorageAttributionReportingEventLevelResult = "internalError"

	// StorageAttributionReportingEventLevelResultNoCapacityForAttributionDestination enum const.
	StorageAttributionReportingEventLevelResultNoCapacityForAttributionDestination StorageAttributionReportingEventLevelResult = "noCapacityForAttributionDestination"

	// StorageAttributionReportingEventLevelResultNoMatchingSources enum const.
	StorageAttributionReportingEventLevelResultNoMatchingSources StorageAttributionReportingEventLevelResult = "noMatchingSources"

	// StorageAttributionReportingEventLevelResultDeduplicated enum const.
	StorageAttributionReportingEventLevelResultDeduplicated StorageAttributionReportingEventLevelResult = "deduplicated"

	// StorageAttributionReportingEventLevelResultExcessiveAttributions enum const.
	StorageAttributionReportingEventLevelResultExcessiveAttributions StorageAttributionReportingEventLevelResult = "excessiveAttributions"

	// StorageAttributionReportingEventLevelResultPriorityTooLow enum const.
	StorageAttributionReportingEventLevelResultPriorityTooLow StorageAttributionReportingEventLevelResult = "priorityTooLow"

	// StorageAttributionReportingEventLevelResultNeverAttributedSource enum const.
	StorageAttributionReportingEventLevelResultNeverAttributedSource StorageAttributionReportingEventLevelResult = "neverAttributedSource"

	// StorageAttributionReportingEventLevelResultExcessiveReportingOrigins enum const.
	StorageAttributionReportingEventLevelResultExcessiveReportingOrigins StorageAttributionReportingEventLevelResult = "excessiveReportingOrigins"

	// StorageAttributionReportingEventLevelResultNoMatchingSourceFilterData enum const.
	StorageAttributionReportingEventLevelResultNoMatchingSourceFilterData StorageAttributionReportingEventLevelResult = "noMatchingSourceFilterData"

	// StorageAttributionReportingEventLevelResultProhibitedByBrowserPolicy enum const.
	StorageAttributionReportingEventLevelResultProhibitedByBrowserPolicy StorageAttributionReportingEventLevelResult = "prohibitedByBrowserPolicy"

	// StorageAttributionReportingEventLevelResultNoMatchingConfigurations enum const.
	StorageAttributionReportingEventLevelResultNoMatchingConfigurations StorageAttributionReportingEventLevelResult = "noMatchingConfigurations"

	// StorageAttributionReportingEventLevelResultExcessiveReports enum const.
	StorageAttributionReportingEventLevelResultExcessiveReports StorageAttributionReportingEventLevelResult = "excessiveReports"

	// StorageAttributionReportingEventLevelResultFalselyAttributedSource enum const.
	StorageAttributionReportingEventLevelResultFalselyAttributedSource StorageAttributionReportingEventLevelResult = "falselyAttributedSource"

	// StorageAttributionReportingEventLevelResultReportWindowPassed enum const.
	StorageAttributionReportingEventLevelResultReportWindowPassed StorageAttributionReportingEventLevelResult = "reportWindowPassed"

	// StorageAttributionReportingEventLevelResultNotRegistered enum const.
	StorageAttributionReportingEventLevelResultNotRegistered StorageAttributionReportingEventLevelResult = "notRegistered"

	// StorageAttributionReportingEventLevelResultReportWindowNotStarted enum const.
	StorageAttributionReportingEventLevelResultReportWindowNotStarted StorageAttributionReportingEventLevelResult = "reportWindowNotStarted"

	// StorageAttributionReportingEventLevelResultNoMatchingTriggerData enum const.
	StorageAttributionReportingEventLevelResultNoMatchingTriggerData StorageAttributionReportingEventLevelResult = "noMatchingTriggerData"
)

// StorageAttributionReportingAggregatableResult (experimental) ...
type StorageAttributionReportingAggregatableResult string

const (
	// StorageAttributionReportingAggregatableResultSuccess enum const.
	StorageAttributionReportingAggregatableResultSuccess StorageAttributionReportingAggregatableResult = "success"

	// StorageAttributionReportingAggregatableResultInternalError enum const.
	StorageAttributionReportingAggregatableResultInternalError StorageAttributionReportingAggregatableResult = "internalError"

	// StorageAttributionReportingAggregatableResultNoCapacityForAttributionDestination enum const.
	StorageAttributionReportingAggregatableResultNoCapacityForAttributionDestination StorageAttributionReportingAggregatableResult = "noCapacityForAttributionDestination"

	// StorageAttributionReportingAggregatableResultNoMatchingSources enum const.
	StorageAttributionReportingAggregatableResultNoMatchingSources StorageAttributionReportingAggregatableResult = "noMatchingSources"

	// StorageAttributionReportingAggregatableResultExcessiveAttributions enum const.
	StorageAttributionReportingAggregatableResultExcessiveAttributions StorageAttributionReportingAggregatableResult = "excessiveAttributions"

	// StorageAttributionReportingAggregatableResultExcessiveReportingOrigins enum const.
	StorageAttributionReportingAggregatableResultExcessiveReportingOrigins StorageAttributionReportingAggregatableResult = "excessiveReportingOrigins"

	// StorageAttributionReportingAggregatableResultNoHistograms enum const.
	StorageAttributionReportingAggregatableResultNoHistograms StorageAttributionReportingAggregatableResult = "noHistograms"

	// StorageAttributionReportingAggregatableResultInsufficientBudget enum const.
	StorageAttributionReportingAggregatableResultInsufficientBudget StorageAttributionReportingAggregatableResult = "insufficientBudget"

	// StorageAttributionReportingAggregatableResultNoMatchingSourceFilterData enum const.
	StorageAttributionReportingAggregatableResultNoMatchingSourceFilterData StorageAttributionReportingAggregatableResult = "noMatchingSourceFilterData"

	// StorageAttributionReportingAggregatableResultNotRegistered enum const.
	StorageAttributionReportingAggregatableResultNotRegistered StorageAttributionReportingAggregatableResult = "notRegistered"

	// StorageAttributionReportingAggregatableResultProhibitedByBrowserPolicy enum const.
	StorageAttributionReportingAggregatableResultProhibitedByBrowserPolicy StorageAttributionReportingAggregatableResult = "prohibitedByBrowserPolicy"

	// StorageAttributionReportingAggregatableResultDeduplicated enum const.
	StorageAttributionReportingAggregatableResultDeduplicated StorageAttributionReportingAggregatableResult = "deduplicated"

	// StorageAttributionReportingAggregatableResultReportWindowPassed enum const.
	StorageAttributionReportingAggregatableResultReportWindowPassed StorageAttributionReportingAggregatableResult = "reportWindowPassed"

	// StorageAttributionReportingAggregatableResultExcessiveReports enum const.
	StorageAttributionReportingAggregatableResultExcessiveReports StorageAttributionReportingAggregatableResult = "excessiveReports"
)

// StorageRelatedWebsiteSet (experimental) A single Related Website Set object.
type StorageRelatedWebsiteSet struct {
	// PrimarySites The primary site of this set, along with the ccTLDs if there is any.
	PrimarySites []string `json:"primarySites"`

	// AssociatedSites The associated sites of this set, along with the ccTLDs if there is any.
	AssociatedSites []string `json:"associatedSites"`

	// ServiceSites The service sites of this set, along with the ccTLDs if there is any.
	ServiceSites []string `json:"serviceSites"`
}

// StorageGetStorageKeyForFrame Returns a storage key given a frame id.
type StorageGetStorageKeyForFrame struct {
	// FrameID ...
	FrameID PageFrameID `json:"frameId"`
}

// ProtoReq name.
func (m StorageGetStorageKeyForFrame) ProtoReq() string { return "Storage.getStorageKeyForFrame" }

// Call the request.
func (m StorageGetStorageKeyForFrame) Call(c Client) (*StorageGetStorageKeyForFrameResult, error) {
	var res StorageGetStorageKeyForFrameResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetStorageKeyForFrameResult ...
type StorageGetStorageKeyForFrameResult struct {
	// StorageKey ...
	StorageKey StorageSerializedStorageKey `json:"storageKey"`
}

// StorageClearDataForOrigin Clears storage for origin.
type StorageClearDataForOrigin struct {
	// Origin Security origin.
	Origin string `json:"origin"`

	// StorageTypes Comma separated list of StorageType to clear.
	StorageTypes string `json:"storageTypes"`
}

// ProtoReq name.
func (m StorageClearDataForOrigin) ProtoReq() string { return "Storage.clearDataForOrigin" }

// Call sends the request.
func (m StorageClearDataForOrigin) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageClearDataForStorageKey Clears storage for storage key.
type StorageClearDataForStorageKey struct {
	// StorageKey Storage key.
	StorageKey string `json:"storageKey"`

	// StorageTypes Comma separated list of StorageType to clear.
	StorageTypes string `json:"storageTypes"`
}

// ProtoReq name.
func (m StorageClearDataForStorageKey) ProtoReq() string { return "Storage.clearDataForStorageKey" }

// Call sends the request.
func (m StorageClearDataForStorageKey) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageGetCookies Returns all browser cookies.
type StorageGetCookies struct {
	// BrowserContextID (optional) Browser context to use when called on the browser endpoint.
	BrowserContextID BrowserBrowserContextID `json:"browserContextId,omitempty"`
}

// ProtoReq name.
func (m StorageGetCookies) ProtoReq() string { return "Storage.getCookies" }

// Call the request.
func (m StorageGetCookies) Call(c Client) (*StorageGetCookiesResult, error) {
	var res StorageGetCookiesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetCookiesResult ...
type StorageGetCookiesResult struct {
	// Cookies Array of cookie objects.
	Cookies []*NetworkCookie `json:"cookies"`
}

// StorageSetCookies Sets given cookies.
type StorageSetCookies struct {
	// Cookies to be set.
	Cookies []*NetworkCookieParam `json:"cookies"`

	// BrowserContextID (optional) Browser context to use when called on the browser endpoint.
	BrowserContextID BrowserBrowserContextID `json:"browserContextId,omitempty"`
}

// ProtoReq name.
func (m StorageSetCookies) ProtoReq() string { return "Storage.setCookies" }

// Call sends the request.
func (m StorageSetCookies) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageClearCookies Clears cookies.
type StorageClearCookies struct {
	// BrowserContextID (optional) Browser context to use when called on the browser endpoint.
	BrowserContextID BrowserBrowserContextID `json:"browserContextId,omitempty"`
}

// ProtoReq name.
func (m StorageClearCookies) ProtoReq() string { return "Storage.clearCookies" }

// Call sends the request.
func (m StorageClearCookies) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageGetUsageAndQuota Returns usage and quota in bytes.
type StorageGetUsageAndQuota struct {
	// Origin Security origin.
	Origin string `json:"origin"`
}

// ProtoReq name.
func (m StorageGetUsageAndQuota) ProtoReq() string { return "Storage.getUsageAndQuota" }

// Call the request.
func (m StorageGetUsageAndQuota) Call(c Client) (*StorageGetUsageAndQuotaResult, error) {
	var res StorageGetUsageAndQuotaResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetUsageAndQuotaResult ...
type StorageGetUsageAndQuotaResult struct {
	// Usage Storage usage (bytes).
	Usage float64 `json:"usage"`

	// Quota Storage quota (bytes).
	Quota float64 `json:"quota"`

	// OverrideActive Whether or not the origin has an active storage quota override
	OverrideActive bool `json:"overrideActive"`

	// UsageBreakdown Storage usage per type (bytes).
	UsageBreakdown []*StorageUsageForType `json:"usageBreakdown"`
}

// StorageOverrideQuotaForOrigin (experimental) Override quota for the specified origin.
type StorageOverrideQuotaForOrigin struct {
	// Origin Security origin.
	Origin string `json:"origin"`

	// QuotaSize (optional) The quota size (in bytes) to override the original quota with.
	// If this is called multiple times, the overridden quota will be equal to
	// the quotaSize provided in the final call. If this is called without
	// specifying a quotaSize, the quota will be reset to the default value for
	// the specified origin. If this is called multiple times with different
	// origins, the override will be maintained for each origin until it is
	// disabled (called without a quotaSize).
	QuotaSize *float64 `json:"quotaSize,omitempty"`
}

// ProtoReq name.
func (m StorageOverrideQuotaForOrigin) ProtoReq() string { return "Storage.overrideQuotaForOrigin" }

// Call sends the request.
func (m StorageOverrideQuotaForOrigin) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageTrackCacheStorageForOrigin Registers origin to be notified when an update occurs to its cache storage list.
type StorageTrackCacheStorageForOrigin struct {
	// Origin Security origin.
	Origin string `json:"origin"`
}

// ProtoReq name.
func (m StorageTrackCacheStorageForOrigin) ProtoReq() string {
	return "Storage.trackCacheStorageForOrigin"
}

// Call sends the request.
func (m StorageTrackCacheStorageForOrigin) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageTrackCacheStorageForStorageKey Registers storage key to be notified when an update occurs to its cache storage list.
type StorageTrackCacheStorageForStorageKey struct {
	// StorageKey Storage key.
	StorageKey string `json:"storageKey"`
}

// ProtoReq name.
func (m StorageTrackCacheStorageForStorageKey) ProtoReq() string {
	return "Storage.trackCacheStorageForStorageKey"
}

// Call sends the request.
func (m StorageTrackCacheStorageForStorageKey) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageTrackIndexedDBForOrigin Registers origin to be notified when an update occurs to its IndexedDB.
type StorageTrackIndexedDBForOrigin struct {
	// Origin Security origin.
	Origin string `json:"origin"`
}

// ProtoReq name.
func (m StorageTrackIndexedDBForOrigin) ProtoReq() string { return "Storage.trackIndexedDBForOrigin" }

// Call sends the request.
func (m StorageTrackIndexedDBForOrigin) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageTrackIndexedDBForStorageKey Registers storage key to be notified when an update occurs to its IndexedDB.
type StorageTrackIndexedDBForStorageKey struct {
	// StorageKey Storage key.
	StorageKey string `json:"storageKey"`
}

// ProtoReq name.
func (m StorageTrackIndexedDBForStorageKey) ProtoReq() string {
	return "Storage.trackIndexedDBForStorageKey"
}

// Call sends the request.
func (m StorageTrackIndexedDBForStorageKey) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageUntrackCacheStorageForOrigin Unregisters origin from receiving notifications for cache storage.
type StorageUntrackCacheStorageForOrigin struct {
	// Origin Security origin.
	Origin string `json:"origin"`
}

// ProtoReq name.
func (m StorageUntrackCacheStorageForOrigin) ProtoReq() string {
	return "Storage.untrackCacheStorageForOrigin"
}

// Call sends the request.
func (m StorageUntrackCacheStorageForOrigin) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageUntrackCacheStorageForStorageKey Unregisters storage key from receiving notifications for cache storage.
type StorageUntrackCacheStorageForStorageKey struct {
	// StorageKey Storage key.
	StorageKey string `json:"storageKey"`
}

// ProtoReq name.
func (m StorageUntrackCacheStorageForStorageKey) ProtoReq() string {
	return "Storage.untrackCacheStorageForStorageKey"
}

// Call sends the request.
func (m StorageUntrackCacheStorageForStorageKey) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageUntrackIndexedDBForOrigin Unregisters origin from receiving notifications for IndexedDB.
type StorageUntrackIndexedDBForOrigin struct {
	// Origin Security origin.
	Origin string `json:"origin"`
}

// ProtoReq name.
func (m StorageUntrackIndexedDBForOrigin) ProtoReq() string {
	return "Storage.untrackIndexedDBForOrigin"
}

// Call sends the request.
func (m StorageUntrackIndexedDBForOrigin) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageUntrackIndexedDBForStorageKey Unregisters storage key from receiving notifications for IndexedDB.
type StorageUntrackIndexedDBForStorageKey struct {
	// StorageKey Storage key.
	StorageKey string `json:"storageKey"`
}

// ProtoReq name.
func (m StorageUntrackIndexedDBForStorageKey) ProtoReq() string {
	return "Storage.untrackIndexedDBForStorageKey"
}

// Call sends the request.
func (m StorageUntrackIndexedDBForStorageKey) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageGetTrustTokens (experimental) Returns the number of stored Trust Tokens per issuer for the
// current browsing context.
type StorageGetTrustTokens struct{}

// ProtoReq name.
func (m StorageGetTrustTokens) ProtoReq() string { return "Storage.getTrustTokens" }

// Call the request.
func (m StorageGetTrustTokens) Call(c Client) (*StorageGetTrustTokensResult, error) {
	var res StorageGetTrustTokensResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetTrustTokensResult (experimental) ...
type StorageGetTrustTokensResult struct {
	// Tokens ...
	Tokens []*StorageTrustTokens `json:"tokens"`
}

// StorageClearTrustTokens (experimental) Removes all Trust Tokens issued by the provided issuerOrigin.
// Leaves other stored data, including the issuer's Redemption Records, intact.
type StorageClearTrustTokens struct {
	// IssuerOrigin ...
	IssuerOrigin string `json:"issuerOrigin"`
}

// ProtoReq name.
func (m StorageClearTrustTokens) ProtoReq() string { return "Storage.clearTrustTokens" }

// Call the request.
func (m StorageClearTrustTokens) Call(c Client) (*StorageClearTrustTokensResult, error) {
	var res StorageClearTrustTokensResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageClearTrustTokensResult (experimental) ...
type StorageClearTrustTokensResult struct {
	// DidDeleteTokens True if any tokens were deleted, false otherwise.
	DidDeleteTokens bool `json:"didDeleteTokens"`
}

// StorageGetInterestGroupDetails (experimental) Gets details for a named interest group.
type StorageGetInterestGroupDetails struct {
	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`

	// Name ...
	Name string `json:"name"`
}

// ProtoReq name.
func (m StorageGetInterestGroupDetails) ProtoReq() string { return "Storage.getInterestGroupDetails" }

// Call the request.
func (m StorageGetInterestGroupDetails) Call(c Client) (*StorageGetInterestGroupDetailsResult, error) {
	var res StorageGetInterestGroupDetailsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetInterestGroupDetailsResult (experimental) ...
type StorageGetInterestGroupDetailsResult struct {
	// Details This largely corresponds to:
	// https://wicg.github.io/turtledove/#dictdef-generatebidinterestgroup
	// but has absolute expirationTime instead of relative lifetimeMs and
	// also adds joiningOrigin.
	Details map[string]gson.JSON `json:"details"`
}

// StorageSetInterestGroupTracking (experimental) Enables/Disables issuing of interestGroupAccessed events.
type StorageSetInterestGroupTracking struct {
	// Enable ...
	Enable bool `json:"enable"`
}

// ProtoReq name.
func (m StorageSetInterestGroupTracking) ProtoReq() string { return "Storage.setInterestGroupTracking" }

// Call sends the request.
func (m StorageSetInterestGroupTracking) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageSetInterestGroupAuctionTracking (experimental) Enables/Disables issuing of interestGroupAuctionEventOccurred and
// interestGroupAuctionNetworkRequestCreated.
type StorageSetInterestGroupAuctionTracking struct {
	// Enable ...
	Enable bool `json:"enable"`
}

// ProtoReq name.
func (m StorageSetInterestGroupAuctionTracking) ProtoReq() string {
	return "Storage.setInterestGroupAuctionTracking"
}

// Call sends the request.
func (m StorageSetInterestGroupAuctionTracking) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageGetSharedStorageMetadata (experimental) Gets metadata for an origin's shared storage.
type StorageGetSharedStorageMetadata struct {
	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`
}

// ProtoReq name.
func (m StorageGetSharedStorageMetadata) ProtoReq() string { return "Storage.getSharedStorageMetadata" }

// Call the request.
func (m StorageGetSharedStorageMetadata) Call(c Client) (*StorageGetSharedStorageMetadataResult, error) {
	var res StorageGetSharedStorageMetadataResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetSharedStorageMetadataResult (experimental) ...
type StorageGetSharedStorageMetadataResult struct {
	// Metadata ...
	Metadata *StorageSharedStorageMetadata `json:"metadata"`
}

// StorageGetSharedStorageEntries (experimental) Gets the entries in an given origin's shared storage.
type StorageGetSharedStorageEntries struct {
	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`
}

// ProtoReq name.
func (m StorageGetSharedStorageEntries) ProtoReq() string { return "Storage.getSharedStorageEntries" }

// Call the request.
func (m StorageGetSharedStorageEntries) Call(c Client) (*StorageGetSharedStorageEntriesResult, error) {
	var res StorageGetSharedStorageEntriesResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetSharedStorageEntriesResult (experimental) ...
type StorageGetSharedStorageEntriesResult struct {
	// Entries ...
	Entries []*StorageSharedStorageEntry `json:"entries"`
}

// StorageSetSharedStorageEntry (experimental) Sets entry with `key` and `value` for a given origin's shared storage.
type StorageSetSharedStorageEntry struct {
	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`

	// Key ...
	Key string `json:"key"`

	// Value ...
	Value string `json:"value"`

	// IgnoreIfPresent (optional) If `ignoreIfPresent` is included and true, then only sets the entry if
	// `key` doesn't already exist.
	IgnoreIfPresent bool `json:"ignoreIfPresent,omitempty"`
}

// ProtoReq name.
func (m StorageSetSharedStorageEntry) ProtoReq() string { return "Storage.setSharedStorageEntry" }

// Call sends the request.
func (m StorageSetSharedStorageEntry) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageDeleteSharedStorageEntry (experimental) Deletes entry for `key` (if it exists) for a given origin's shared storage.
type StorageDeleteSharedStorageEntry struct {
	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`

	// Key ...
	Key string `json:"key"`
}

// ProtoReq name.
func (m StorageDeleteSharedStorageEntry) ProtoReq() string { return "Storage.deleteSharedStorageEntry" }

// Call sends the request.
func (m StorageDeleteSharedStorageEntry) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageClearSharedStorageEntries (experimental) Clears all entries for a given origin's shared storage.
type StorageClearSharedStorageEntries struct {
	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`
}

// ProtoReq name.
func (m StorageClearSharedStorageEntries) ProtoReq() string {
	return "Storage.clearSharedStorageEntries"
}

// Call sends the request.
func (m StorageClearSharedStorageEntries) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageResetSharedStorageBudget (experimental) Resets the budget for `ownerOrigin` by clearing all budget withdrawals.
type StorageResetSharedStorageBudget struct {
	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`
}

// ProtoReq name.
func (m StorageResetSharedStorageBudget) ProtoReq() string { return "Storage.resetSharedStorageBudget" }

// Call sends the request.
func (m StorageResetSharedStorageBudget) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageSetSharedStorageTracking (experimental) Enables/disables issuing of sharedStorageAccessed events.
type StorageSetSharedStorageTracking struct {
	// Enable ...
	Enable bool `json:"enable"`
}

// ProtoReq name.
func (m StorageSetSharedStorageTracking) ProtoReq() string { return "Storage.setSharedStorageTracking" }

// Call sends the request.
func (m StorageSetSharedStorageTracking) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageSetStorageBucketTracking (experimental) Set tracking for a storage key's buckets.
type StorageSetStorageBucketTracking struct {
	// StorageKey ...
	StorageKey string `json:"storageKey"`

	// Enable ...
	Enable bool `json:"enable"`
}

// ProtoReq name.
func (m StorageSetStorageBucketTracking) ProtoReq() string { return "Storage.setStorageBucketTracking" }

// Call sends the request.
func (m StorageSetStorageBucketTracking) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageDeleteStorageBucket (experimental) Deletes the Storage Bucket with the given storage key and bucket name.
type StorageDeleteStorageBucket struct {
	// Bucket ...
	Bucket *StorageStorageBucket `json:"bucket"`
}

// ProtoReq name.
func (m StorageDeleteStorageBucket) ProtoReq() string { return "Storage.deleteStorageBucket" }

// Call sends the request.
func (m StorageDeleteStorageBucket) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageRunBounceTrackingMitigations (experimental) Deletes state for sites identified as potential bounce trackers, immediately.
type StorageRunBounceTrackingMitigations struct{}

// ProtoReq name.
func (m StorageRunBounceTrackingMitigations) ProtoReq() string {
	return "Storage.runBounceTrackingMitigations"
}

// Call the request.
func (m StorageRunBounceTrackingMitigations) Call(c Client) (*StorageRunBounceTrackingMitigationsResult, error) {
	var res StorageRunBounceTrackingMitigationsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageRunBounceTrackingMitigationsResult (experimental) ...
type StorageRunBounceTrackingMitigationsResult struct {
	// DeletedSites ...
	DeletedSites []string `json:"deletedSites"`
}

// StorageSetAttributionReportingLocalTestingMode (experimental) https://wicg.github.io/attribution-reporting-api/
type StorageSetAttributionReportingLocalTestingMode struct {
	// Enabled If enabled, noise is suppressed and reports are sent immediately.
	Enabled bool `json:"enabled"`
}

// ProtoReq name.
func (m StorageSetAttributionReportingLocalTestingMode) ProtoReq() string {
	return "Storage.setAttributionReportingLocalTestingMode"
}

// Call sends the request.
func (m StorageSetAttributionReportingLocalTestingMode) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageSetAttributionReportingTracking (experimental) Enables/disables issuing of Attribution Reporting events.
type StorageSetAttributionReportingTracking struct {
	// Enable ...
	Enable bool `json:"enable"`
}

// ProtoReq name.
func (m StorageSetAttributionReportingTracking) ProtoReq() string {
	return "Storage.setAttributionReportingTracking"
}

// Call sends the request.
func (m StorageSetAttributionReportingTracking) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// StorageSendPendingAttributionReports (experimental) Sends all pending Attribution Reports immediately, regardless of their
// scheduled report time.
type StorageSendPendingAttributionReports struct{}

// ProtoReq name.
func (m StorageSendPendingAttributionReports) ProtoReq() string {
	return "Storage.sendPendingAttributionReports"
}

// Call the request.
func (m StorageSendPendingAttributionReports) Call(c Client) (*StorageSendPendingAttributionReportsResult, error) {
	var res StorageSendPendingAttributionReportsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageSendPendingAttributionReportsResult (experimental) ...
type StorageSendPendingAttributionReportsResult struct {
	// NumSent The number of reports that were sent.
	NumSent int `json:"numSent"`
}

// StorageGetRelatedWebsiteSets (experimental) Returns the effective Related Website Sets in use by this profile for the browser
// session. The effective Related Website Sets will not change during a browser session.
type StorageGetRelatedWebsiteSets struct{}

// ProtoReq name.
func (m StorageGetRelatedWebsiteSets) ProtoReq() string { return "Storage.getRelatedWebsiteSets" }

// Call the request.
func (m StorageGetRelatedWebsiteSets) Call(c Client) (*StorageGetRelatedWebsiteSetsResult, error) {
	var res StorageGetRelatedWebsiteSetsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// StorageGetRelatedWebsiteSetsResult (experimental) ...
type StorageGetRelatedWebsiteSetsResult struct {
	// Sets ...
	Sets []*StorageRelatedWebsiteSet `json:"sets"`
}

// StorageCacheStorageContentUpdated A cache's contents have been modified.
type StorageCacheStorageContentUpdated struct {
	// Origin to update.
	Origin string `json:"origin"`

	// StorageKey Storage key to update.
	StorageKey string `json:"storageKey"`

	// BucketID Storage bucket to update.
	BucketID string `json:"bucketId"`

	// CacheName Name of cache in origin.
	CacheName string `json:"cacheName"`
}

// ProtoEvent name.
func (evt StorageCacheStorageContentUpdated) ProtoEvent() string {
	return "Storage.cacheStorageContentUpdated"
}

// StorageCacheStorageListUpdated A cache has been added/deleted.
type StorageCacheStorageListUpdated struct {
	// Origin to update.
	Origin string `json:"origin"`

	// StorageKey Storage key to update.
	StorageKey string `json:"storageKey"`

	// BucketID Storage bucket to update.
	BucketID string `json:"bucketId"`
}

// ProtoEvent name.
func (evt StorageCacheStorageListUpdated) ProtoEvent() string {
	return "Storage.cacheStorageListUpdated"
}

// StorageIndexedDBContentUpdated The origin's IndexedDB object store has been modified.
type StorageIndexedDBContentUpdated struct {
	// Origin to update.
	Origin string `json:"origin"`

	// StorageKey Storage key to update.
	StorageKey string `json:"storageKey"`

	// BucketID Storage bucket to update.
	BucketID string `json:"bucketId"`

	// DatabaseName Database to update.
	DatabaseName string `json:"databaseName"`

	// ObjectStoreName ObjectStore to update.
	ObjectStoreName string `json:"objectStoreName"`
}

// ProtoEvent name.
func (evt StorageIndexedDBContentUpdated) ProtoEvent() string {
	return "Storage.indexedDBContentUpdated"
}

// StorageIndexedDBListUpdated The origin's IndexedDB database list has been modified.
type StorageIndexedDBListUpdated struct {
	// Origin to update.
	Origin string `json:"origin"`

	// StorageKey Storage key to update.
	StorageKey string `json:"storageKey"`

	// BucketID Storage bucket to update.
	BucketID string `json:"bucketId"`
}

// ProtoEvent name.
func (evt StorageIndexedDBListUpdated) ProtoEvent() string {
	return "Storage.indexedDBListUpdated"
}

// StorageInterestGroupAccessed One of the interest groups was accessed. Note that these events are global
// to all targets sharing an interest group store.
type StorageInterestGroupAccessed struct {
	// AccessTime ...
	AccessTime TimeSinceEpoch `json:"accessTime"`

	// Type ...
	Type StorageInterestGroupAccessType `json:"type"`

	// OwnerOrigin ...
	OwnerOrigin string `json:"ownerOrigin"`

	// Name ...
	Name string `json:"name"`

	// ComponentSellerOrigin (optional) For topLevelBid/topLevelAdditionalBid, and when appropriate,
	// win and additionalBidWin
	ComponentSellerOrigin string `json:"componentSellerOrigin,omitempty"`

	// Bid (optional) For bid or somethingBid event, if done locally and not on a server.
	Bid *float64 `json:"bid,omitempty"`

	// BidCurrency (optional) ...
	BidCurrency string `json:"bidCurrency,omitempty"`

	// UniqueAuctionID (optional) For non-global events --- links to interestGroupAuctionEvent
	UniqueAuctionID StorageInterestGroupAuctionID `json:"uniqueAuctionId,omitempty"`
}

// ProtoEvent name.
func (evt StorageInterestGroupAccessed) ProtoEvent() string {
	return "Storage.interestGroupAccessed"
}

// StorageInterestGroupAuctionEventOccurred An auction involving interest groups is taking place. These events are
// target-specific.
type StorageInterestGroupAuctionEventOccurred struct {
	// EventTime ...
	EventTime TimeSinceEpoch `json:"eventTime"`

	// Type ...
	Type StorageInterestGroupAuctionEventType `json:"type"`

	// UniqueAuctionID ...
	UniqueAuctionID StorageInterestGroupAuctionID `json:"uniqueAuctionId"`

	// ParentAuctionID (optional) Set for child auctions.
	ParentAuctionID StorageInterestGroupAuctionID `json:"parentAuctionId,omitempty"`

	// AuctionConfig (optional) Set for started and configResolved
	AuctionConfig map[string]gson.JSON `json:"auctionConfig,omitempty"`
}

// ProtoEvent name.
func (evt StorageInterestGroupAuctionEventOccurred) ProtoEvent() string {
	return "Storage.interestGroupAuctionEventOccurred"
}

// StorageInterestGroupAuctionNetworkRequestCreated Specifies which auctions a particular network fetch may be related to, and
// in what role. Note that it is not ordered with respect to
// Network.requestWillBeSent (but will happen before loadingFinished
// loadingFailed).
type StorageInterestGroupAuctionNetworkRequestCreated struct {
	// Type ...
	Type StorageInterestGroupAuctionFetchType `json:"type"`

	// RequestID ...
	RequestID NetworkRequestID `json:"requestId"`

	// Auctions This is the set of the auctions using the worklet that issued this
	// request.  In the case of trusted signals, it's possible that only some of
	// them actually care about the keys being queried.
	Auctions []StorageInterestGroupAuctionID `json:"auctions"`
}

// ProtoEvent name.
func (evt StorageInterestGroupAuctionNetworkRequestCreated) ProtoEvent() string {
	return "Storage.interestGroupAuctionNetworkRequestCreated"
}

// StorageSharedStorageAccessed Shared storage was accessed by the associated page.
// The following parameters are included in all events.
type StorageSharedStorageAccessed struct {
	// AccessTime Time of the access.
	AccessTime TimeSinceEpoch `json:"accessTime"`

	// Type Enum value indicating the Shared Storage API method invoked.
	Type StorageSharedStorageAccessType `json:"type"`

	// MainFrameID DevTools Frame Token for the primary frame tree's root.
	MainFrameID PageFrameID `json:"mainFrameId"`

	// OwnerOrigin Serialized origin for the context that invoked the Shared Storage API.
	OwnerOrigin string `json:"ownerOrigin"`

	// Params The sub-parameters wrapped by `params` are all optional and their
	// presence/absence depends on `type`.
	Params *StorageSharedStorageAccessParams `json:"params"`
}

// ProtoEvent name.
func (evt StorageSharedStorageAccessed) ProtoEvent() string {
	return "Storage.sharedStorageAccessed"
}

// StorageStorageBucketCreatedOrUpdated ...
type StorageStorageBucketCreatedOrUpdated struct {
	// BucketInfo ...
	BucketInfo *StorageStorageBucketInfo `json:"bucketInfo"`
}

// ProtoEvent name.
func (evt StorageStorageBucketCreatedOrUpdated) ProtoEvent() string {
	return "Storage.storageBucketCreatedOrUpdated"
}

// StorageStorageBucketDeleted ...
type StorageStorageBucketDeleted struct {
	// BucketID ...
	BucketID string `json:"bucketId"`
}

// ProtoEvent name.
func (evt StorageStorageBucketDeleted) ProtoEvent() string {
	return "Storage.storageBucketDeleted"
}

// StorageAttributionReportingSourceRegistered (experimental) ...
type StorageAttributionReportingSourceRegistered struct {
	// Registration ...
	Registration *StorageAttributionReportingSourceRegistration `json:"registration"`

	// Result ...
	Result StorageAttributionReportingSourceRegistrationResult `json:"result"`
}

// ProtoEvent name.
func (evt StorageAttributionReportingSourceRegistered) ProtoEvent() string {
	return "Storage.attributionReportingSourceRegistered"
}

// StorageAttributionReportingTriggerRegistered (experimental) ...
type StorageAttributionReportingTriggerRegistered struct {
	// Registration ...
	Registration *StorageAttributionReportingTriggerRegistration `json:"registration"`

	// EventLevel ...
	EventLevel StorageAttributionReportingEventLevelResult `json:"eventLevel"`

	// Aggregatable ...
	Aggregatable StorageAttributionReportingAggregatableResult `json:"aggregatable"`
}

// ProtoEvent name.
func (evt StorageAttributionReportingTriggerRegistered) ProtoEvent() string {
	return "Storage.attributionReportingTriggerRegistered"
}
