// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// RemoveTeamRoleReader is a Reader for the RemoveTeamRole structure.
type RemoveTeamRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RemoveTeamRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRemoveTeamRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRemoveTeamRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRemoveTeamRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRemoveTeamRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRemoveTeamRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /access-control/teams/{teamId}/roles/{roleUID}] removeTeamRole", response, response.Code())
	}
}

// NewRemoveTeamRoleOK creates a RemoveTeamRoleOK with default headers values
func NewRemoveTeamRoleOK() *RemoveTeamRoleOK {
	return &RemoveTeamRoleOK{}
}

/*
RemoveTeamRoleOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type RemoveTeamRoleOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this remove team role Ok response has a 2xx status code
func (o *RemoveTeamRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this remove team role Ok response has a 3xx status code
func (o *RemoveTeamRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove team role Ok response has a 4xx status code
func (o *RemoveTeamRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this remove team role Ok response has a 5xx status code
func (o *RemoveTeamRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this remove team role Ok response a status code equal to that given
func (o *RemoveTeamRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the remove team role Ok response
func (o *RemoveTeamRoleOK) Code() int {
	return 200
}

func (o *RemoveTeamRoleOK) Error() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleOk  %+v", 200, o.Payload)
}

func (o *RemoveTeamRoleOK) String() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleOk  %+v", 200, o.Payload)
}

func (o *RemoveTeamRoleOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *RemoveTeamRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveTeamRoleBadRequest creates a RemoveTeamRoleBadRequest with default headers values
func NewRemoveTeamRoleBadRequest() *RemoveTeamRoleBadRequest {
	return &RemoveTeamRoleBadRequest{}
}

/*
RemoveTeamRoleBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type RemoveTeamRoleBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove team role bad request response has a 2xx status code
func (o *RemoveTeamRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove team role bad request response has a 3xx status code
func (o *RemoveTeamRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove team role bad request response has a 4xx status code
func (o *RemoveTeamRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this remove team role bad request response has a 5xx status code
func (o *RemoveTeamRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this remove team role bad request response a status code equal to that given
func (o *RemoveTeamRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the remove team role bad request response
func (o *RemoveTeamRoleBadRequest) Code() int {
	return 400
}

func (o *RemoveTeamRoleBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleBadRequest  %+v", 400, o.Payload)
}

func (o *RemoveTeamRoleBadRequest) String() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleBadRequest  %+v", 400, o.Payload)
}

func (o *RemoveTeamRoleBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveTeamRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveTeamRoleForbidden creates a RemoveTeamRoleForbidden with default headers values
func NewRemoveTeamRoleForbidden() *RemoveTeamRoleForbidden {
	return &RemoveTeamRoleForbidden{}
}

/*
RemoveTeamRoleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type RemoveTeamRoleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove team role forbidden response has a 2xx status code
func (o *RemoveTeamRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove team role forbidden response has a 3xx status code
func (o *RemoveTeamRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove team role forbidden response has a 4xx status code
func (o *RemoveTeamRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this remove team role forbidden response has a 5xx status code
func (o *RemoveTeamRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this remove team role forbidden response a status code equal to that given
func (o *RemoveTeamRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the remove team role forbidden response
func (o *RemoveTeamRoleForbidden) Code() int {
	return 403
}

func (o *RemoveTeamRoleForbidden) Error() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleForbidden  %+v", 403, o.Payload)
}

func (o *RemoveTeamRoleForbidden) String() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleForbidden  %+v", 403, o.Payload)
}

func (o *RemoveTeamRoleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveTeamRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveTeamRoleNotFound creates a RemoveTeamRoleNotFound with default headers values
func NewRemoveTeamRoleNotFound() *RemoveTeamRoleNotFound {
	return &RemoveTeamRoleNotFound{}
}

/*
RemoveTeamRoleNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type RemoveTeamRoleNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove team role not found response has a 2xx status code
func (o *RemoveTeamRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove team role not found response has a 3xx status code
func (o *RemoveTeamRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove team role not found response has a 4xx status code
func (o *RemoveTeamRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this remove team role not found response has a 5xx status code
func (o *RemoveTeamRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this remove team role not found response a status code equal to that given
func (o *RemoveTeamRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the remove team role not found response
func (o *RemoveTeamRoleNotFound) Code() int {
	return 404
}

func (o *RemoveTeamRoleNotFound) Error() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleNotFound  %+v", 404, o.Payload)
}

func (o *RemoveTeamRoleNotFound) String() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleNotFound  %+v", 404, o.Payload)
}

func (o *RemoveTeamRoleNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveTeamRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRemoveTeamRoleInternalServerError creates a RemoveTeamRoleInternalServerError with default headers values
func NewRemoveTeamRoleInternalServerError() *RemoveTeamRoleInternalServerError {
	return &RemoveTeamRoleInternalServerError{}
}

/*
RemoveTeamRoleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type RemoveTeamRoleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this remove team role internal server error response has a 2xx status code
func (o *RemoveTeamRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this remove team role internal server error response has a 3xx status code
func (o *RemoveTeamRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this remove team role internal server error response has a 4xx status code
func (o *RemoveTeamRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this remove team role internal server error response has a 5xx status code
func (o *RemoveTeamRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this remove team role internal server error response a status code equal to that given
func (o *RemoveTeamRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the remove team role internal server error response
func (o *RemoveTeamRoleInternalServerError) Code() int {
	return 500
}

func (o *RemoveTeamRoleInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *RemoveTeamRoleInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /access-control/teams/{teamId}/roles/{roleUID}][%d] removeTeamRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *RemoveTeamRoleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *RemoveTeamRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
