// Code generated by go-swagger; DO NOT EDIT.

package dashboard_versions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetDashboardVersionsByUIDParams creates a new GetDashboardVersionsByUIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetDashboardVersionsByUIDParams() *GetDashboardVersionsByUIDParams {
	return &GetDashboardVersionsByUIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetDashboardVersionsByUIDParamsWithTimeout creates a new GetDashboardVersionsByUIDParams object
// with the ability to set a timeout on a request.
func NewGetDashboardVersionsByUIDParamsWithTimeout(timeout time.Duration) *GetDashboardVersionsByUIDParams {
	return &GetDashboardVersionsByUIDParams{
		timeout: timeout,
	}
}

// NewGetDashboardVersionsByUIDParamsWithContext creates a new GetDashboardVersionsByUIDParams object
// with the ability to set a context for a request.
func NewGetDashboardVersionsByUIDParamsWithContext(ctx context.Context) *GetDashboardVersionsByUIDParams {
	return &GetDashboardVersionsByUIDParams{
		Context: ctx,
	}
}

// NewGetDashboardVersionsByUIDParamsWithHTTPClient creates a new GetDashboardVersionsByUIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetDashboardVersionsByUIDParamsWithHTTPClient(client *http.Client) *GetDashboardVersionsByUIDParams {
	return &GetDashboardVersionsByUIDParams{
		HTTPClient: client,
	}
}

/*
GetDashboardVersionsByUIDParams contains all the parameters to send to the API endpoint

	for the get dashboard versions by UID operation.

	Typically these are written to a http.Request.
*/
type GetDashboardVersionsByUIDParams struct {

	/* Limit.

	   Maximum number of results to return

	   Format: int64
	*/
	Limit *int64

	/* Start.

	   Version to start from when returning queries

	   Format: int64
	*/
	Start *int64

	// UID.
	UID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get dashboard versions by UID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDashboardVersionsByUIDParams) WithDefaults() *GetDashboardVersionsByUIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get dashboard versions by UID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDashboardVersionsByUIDParams) SetDefaults() {
	var (
		limitDefault = int64(0)

		startDefault = int64(0)
	)

	val := GetDashboardVersionsByUIDParams{
		Limit: &limitDefault,
		Start: &startDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) WithTimeout(timeout time.Duration) *GetDashboardVersionsByUIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) WithContext(ctx context.Context) *GetDashboardVersionsByUIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) WithHTTPClient(client *http.Client) *GetDashboardVersionsByUIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) WithLimit(limit *int64) *GetDashboardVersionsByUIDParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithStart adds the start to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) WithStart(start *int64) *GetDashboardVersionsByUIDParams {
	o.SetStart(start)
	return o
}

// SetStart adds the start to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) SetStart(start *int64) {
	o.Start = start
}

// WithUID adds the uid to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) WithUID(uid string) *GetDashboardVersionsByUIDParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the get dashboard versions by UID params
func (o *GetDashboardVersionsByUIDParams) SetUID(uid string) {
	o.UID = uid
}

// WriteToRequest writes these params to a swagger request
func (o *GetDashboardVersionsByUIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Start != nil {

		// query param start
		var qrStart int64

		if o.Start != nil {
			qrStart = *o.Start
		}
		qStart := swag.FormatInt64(qrStart)
		if qStart != "" {

			if err := r.SetQueryParam("start", qStart); err != nil {
				return err
			}
		}
	}

	// path param uid
	if err := r.SetPathParam("uid", o.UID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
