// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataSourcePermissionRuleDTO data source permission rule DTO
//
// swagger:model DataSourcePermissionRuleDTO
type DataSourcePermissionRuleDTO struct {

	// built in role
	BuiltInRole string `json:"builtInRole,omitempty"`

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"created,omitempty"`

	// datasource Id
	DatasourceID int64 `json:"datasourceId,omitempty"`

	// id
	ID int64 `json:"id,omitempty"`

	// is managed
	IsManaged bool `json:"isManaged,omitempty"`

	// permission
	Permission DsPermissionType `json:"permission,omitempty"`

	// permission name
	PermissionName string `json:"permissionName,omitempty"`

	// team
	Team string `json:"team,omitempty"`

	// team avatar Url
	TeamAvatarURL string `json:"teamAvatarUrl,omitempty"`

	// team email
	TeamEmail string `json:"teamEmail,omitempty"`

	// team Id
	TeamID int64 `json:"teamId,omitempty"`

	// updated
	// Format: date-time
	Updated strfmt.DateTime `json:"updated,omitempty"`

	// user avatar Url
	UserAvatarURL string `json:"userAvatarUrl,omitempty"`

	// user email
	UserEmail string `json:"userEmail,omitempty"`

	// user Id
	UserID int64 `json:"userId,omitempty"`

	// user login
	UserLogin string `json:"userLogin,omitempty"`
}

// Validate validates this data source permission rule DTO
func (m *DataSourcePermissionRuleDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSourcePermissionRuleDTO) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("created", "body", "date-time", m.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataSourcePermissionRuleDTO) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	if err := m.Permission.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("permission")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("permission")
		}
		return err
	}

	return nil
}

func (m *DataSourcePermissionRuleDTO) validateUpdated(formats strfmt.Registry) error {
	if swag.IsZero(m.Updated) { // not required
		return nil
	}

	if err := validate.FormatOf("updated", "body", "date-time", m.Updated.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data source permission rule DTO based on the context it is used
func (m *DataSourcePermissionRuleDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePermission(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataSourcePermissionRuleDTO) contextValidatePermission(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	if err := m.Permission.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("permission")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("permission")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataSourcePermissionRuleDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataSourcePermissionRuleDTO) UnmarshalBinary(b []byte) error {
	var res DataSourcePermissionRuleDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
