// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TeamMemberDTO team member DTO
//
// swagger:model TeamMemberDTO
type TeamMemberDTO struct {

	// auth module
	AuthModule string `json:"auth_module,omitempty"`

	// avatar Url
	AvatarURL string `json:"avatarUrl,omitempty"`

	// email
	Email string `json:"email,omitempty"`

	// labels
	Labels []string `json:"labels"`

	// login
	Login string `json:"login,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// org Id
	OrgID int64 `json:"orgId,omitempty"`

	// permission
	Permission PermissionType `json:"permission,omitempty"`

	// team Id
	TeamID int64 `json:"teamId,omitempty"`

	// team UID
	TeamUID string `json:"teamUID,omitempty"`

	// user Id
	UserID int64 `json:"userId,omitempty"`
}

// Validate validates this team member DTO
func (m *TeamMemberDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TeamMemberDTO) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	if err := m.Permission.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("permission")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("permission")
		}
		return err
	}

	return nil
}

// ContextValidate validate this team member DTO based on the context it is used
func (m *TeamMemberDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePermission(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TeamMemberDTO) contextValidatePermission(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	if err := m.Permission.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("permission")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("permission")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TeamMemberDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TeamMemberDTO) UnmarshalBinary(b []byte) error {
	var res TeamMemberDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
