// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// RegisterLinkedClusterReader is a Reader for the RegisterLinkedCluster structure.
type RegisterLinkedClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RegisterLinkedClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRegisterLinkedClusterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRegisterLinkedClusterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRegisterLinkedClusterOK creates a RegisterLinkedClusterOK with default headers values
func NewRegisterLinkedClusterOK() *RegisterLinkedClusterOK {
	return &RegisterLinkedClusterOK{}
}

/*
RegisterLinkedClusterOK describes a response with status code 200, with default header values.

A successful response.
*/
type RegisterLinkedClusterOK struct {
	Payload *models.HashicorpCloudVault20201125RegisterLinkedClusterResponse
}

// IsSuccess returns true when this register linked cluster o k response has a 2xx status code
func (o *RegisterLinkedClusterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this register linked cluster o k response has a 3xx status code
func (o *RegisterLinkedClusterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this register linked cluster o k response has a 4xx status code
func (o *RegisterLinkedClusterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this register linked cluster o k response has a 5xx status code
func (o *RegisterLinkedClusterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this register linked cluster o k response a status code equal to that given
func (o *RegisterLinkedClusterOK) IsCode(code int) bool {
	return code == 200
}

func (o *RegisterLinkedClusterOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/register][%d] registerLinkedClusterOK  %+v", 200, o.Payload)
}

func (o *RegisterLinkedClusterOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/register][%d] registerLinkedClusterOK  %+v", 200, o.Payload)
}

func (o *RegisterLinkedClusterOK) GetPayload() *models.HashicorpCloudVault20201125RegisterLinkedClusterResponse {
	return o.Payload
}

func (o *RegisterLinkedClusterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125RegisterLinkedClusterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRegisterLinkedClusterDefault creates a RegisterLinkedClusterDefault with default headers values
func NewRegisterLinkedClusterDefault(code int) *RegisterLinkedClusterDefault {
	return &RegisterLinkedClusterDefault{
		_statusCode: code,
	}
}

/*
RegisterLinkedClusterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type RegisterLinkedClusterDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the register linked cluster default response
func (o *RegisterLinkedClusterDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this register linked cluster default response has a 2xx status code
func (o *RegisterLinkedClusterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this register linked cluster default response has a 3xx status code
func (o *RegisterLinkedClusterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this register linked cluster default response has a 4xx status code
func (o *RegisterLinkedClusterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this register linked cluster default response has a 5xx status code
func (o *RegisterLinkedClusterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this register linked cluster default response a status code equal to that given
func (o *RegisterLinkedClusterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *RegisterLinkedClusterDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/register][%d] RegisterLinkedCluster default  %+v", o._statusCode, o.Payload)
}

func (o *RegisterLinkedClusterDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/register][%d] RegisterLinkedCluster default  %+v", o._statusCode, o.Payload)
}

func (o *RegisterLinkedClusterDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *RegisterLinkedClusterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
