// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: filter.gen.go.tmpl

package arrowutil

import (
	"fmt"

	"github.com/apache/arrow/go/arrow/array"
	"github.com/apache/arrow/go/arrow/bitutil"
	"github.com/apache/arrow/go/arrow/memory"
)

func Filter(arr array.Interface, bitset []byte, mem memory.Allocator) array.Interface {
	switch arr := arr.(type) {

	case *array.Int64:
		return FilterInt64s(arr, bitset, mem)

	case *array.Uint64:
		return FilterUint64s(arr, bitset, mem)

	case *array.Float64:
		return FilterFloat64s(arr, bitset, mem)

	case *array.Boolean:
		return FilterBooleans(arr, bitset, mem)

	case *array.Binary:
		return FilterStrings(arr, bitset, mem)

	default:
		panic(fmt.Errorf("unsupported array data type: %s", arr.DataType()))
	}
}

func FilterInt64s(arr *array.Int64, bitset []byte, mem memory.Allocator) *array.Int64 {
	n := bitutil.CountSetBits(bitset, 0, len(bitset))
	b := NewInt64Builder(mem)
	b.Resize(n)
	for i := 0; i < len(bitset); i++ {
		if bitutil.BitIsSet(bitset, i) {
			if arr.IsValid(i) {
				b.Append(arr.Value(i))
			} else {
				b.AppendNull()
			}
		}
	}
	return b.NewInt64Array()
}

func FilterUint64s(arr *array.Uint64, bitset []byte, mem memory.Allocator) *array.Uint64 {
	n := bitutil.CountSetBits(bitset, 0, len(bitset))
	b := NewUint64Builder(mem)
	b.Resize(n)
	for i := 0; i < len(bitset); i++ {
		if bitutil.BitIsSet(bitset, i) {
			if arr.IsValid(i) {
				b.Append(arr.Value(i))
			} else {
				b.AppendNull()
			}
		}
	}
	return b.NewUint64Array()
}

func FilterFloat64s(arr *array.Float64, bitset []byte, mem memory.Allocator) *array.Float64 {
	n := bitutil.CountSetBits(bitset, 0, len(bitset))
	b := NewFloat64Builder(mem)
	b.Resize(n)
	for i := 0; i < len(bitset); i++ {
		if bitutil.BitIsSet(bitset, i) {
			if arr.IsValid(i) {
				b.Append(arr.Value(i))
			} else {
				b.AppendNull()
			}
		}
	}
	return b.NewFloat64Array()
}

func FilterBooleans(arr *array.Boolean, bitset []byte, mem memory.Allocator) *array.Boolean {
	n := bitutil.CountSetBits(bitset, 0, len(bitset))
	b := NewBooleanBuilder(mem)
	b.Resize(n)
	for i := 0; i < len(bitset); i++ {
		if bitutil.BitIsSet(bitset, i) {
			if arr.IsValid(i) {
				b.Append(arr.Value(i))
			} else {
				b.AppendNull()
			}
		}
	}
	return b.NewBooleanArray()
}

func FilterStrings(arr *array.Binary, bitset []byte, mem memory.Allocator) *array.Binary {
	n := bitutil.CountSetBits(bitset, 0, len(bitset))
	b := NewStringBuilder(mem)
	b.Resize(n)
	for i := 0; i < len(bitset); i++ {
		if bitutil.BitIsSet(bitset, i) {
			if arr.IsValid(i) {
				b.AppendString(arr.ValueString(i))
			} else {
				b.AppendNull()
			}
		}
	}
	return b.NewBinaryArray()
}
