// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Zipkin's v2 api currently includes a POST endpoint that can receive spans.\n",
    "title": "Zipkin API",
    "version": "1.0.0"
  },
  "host": "localhost:9411",
  "basePath": "/api/v2",
  "paths": {
    "/dependencies": {
      "get": {
        "description": "Returns service links derived from spans.\n",
        "parameters": [
          {
            "type": "integer",
            "format": "int64",
            "description": "only return links from spans where ` + "`" + `Span.timestamp` + "`" + `  are at or before\nthis time in epoch milliseconds.\n",
            "name": "endTs",
            "in": "query",
            "required": true
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "only return links where all Span.timestamp are at or after\n(` + "`" + `endTs - * lookback` + "`" + `) in milliseconds. Defaults to ` + "`" + `endTs` + "`" + `, limited\nto a system parameter ` + "`" + `QUERY_LOOKBACK` + "`" + `\n",
            "name": "lookback",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "type": "array",
              "title": "ListOfDependencyLinks",
              "items": {
                "$ref": "#/definitions/DependencyLink"
              }
            }
          }
        }
      }
    },
    "/services": {
      "get": {
        "description": "Returns a list of all service names associated with span endpoints.\n",
        "responses": {
          "200": {
            "description": "Succes",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad Request Error"
          }
        }
      }
    },
    "/spans": {
      "get": {
        "description": "Get all the span names recorded by a particular service",
        "parameters": [
          {
            "type": "string",
            "description": "Ex favstar (required) - Lower-case label of a node in the service\ngraph. The /services endpoint enumerates possible input values.\n",
            "name": "serviceName",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad Request Error"
          }
        }
      },
      "post": {
        "description": "Uploads a list of spans encoded per content-type, for example json.\n",
        "consumes": [
          "application/json"
        ],
        "parameters": [
          {
            "description": "A list of spans that belong to any trace.",
            "name": "spans",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ListOfSpans"
            }
          }
        ],
        "responses": {
          "202": {
            "description": "Accepted"
          }
        }
      }
    },
    "/trace/{traceId}": {
      "get": {
        "parameters": [
          {
            "maxLength": 32,
            "minLength": 16,
            "pattern": "[a-z0-9]{16,32}",
            "type": "string",
            "description": "Trace identifier, set on all spans within it.\n\nEncoded as 16 or 32 lowercase hex characters corresponding to 64 or 128 bits.\nFor example, a 128bit trace ID looks like 4e441824ec2b6a44ffdc9bb9a6453df3\n",
            "name": "traceId",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "$ref": "#/definitions/Trace"
            }
          },
          "404": {
            "description": "` + "`" + `traceId` + "`" + ` not found"
          }
        }
      }
    },
    "/traces": {
      "get": {
        "description": "Invoking this request retrieves traces matching the below filters.\n\nResults should be filtered against endTs, subject to limit and\nlookback. For example, if endTs is 10:20 today, limit is 10, and\nlookback is 7 days, traces returned should be those nearest to 10:20\ntoday, not 10:20 a week ago.\n\nTime units of endTs and lookback are milliseconds as opposed to\nmicroseconds, the grain of Span.timestamp. Milliseconds is a more\nfamiliar and supported granularity for query, index and windowing\nfunctions\n",
        "parameters": [
          {
            "type": "string",
            "description": "Ex favstar (required) - Lower-case label of a node in the service\ngraph. The /services endpoint enumerates possible input values.\n",
            "name": "serviceName",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Ex get - name of a span in a trace.\nOnly return traces that contains spans with this name.\n",
            "name": "spanName",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Ex. ` + "`" + `http.uri=/foo and retried` + "`" + ` - If key/value (has an ` + "`" + `=` + "`" + `),\nconstrains against Span.tags entres. If just a word, constrains\nagainst Span.annotations[].value or Span.tags[].key. Any values are\nAND against eachother. This means a span in the trace must match\nall of these.\n",
            "name": "annotationQuery",
            "in": "query"
          },
          {
            "type": "integer",
            "description": "Ex. 100000 (for 100ms). Only return traces whose ` + "`" + `Span.duration` + "`" + ` is\ngreater than or equal to minDuration microseconds.\n",
            "name": "minDuration",
            "in": "query"
          },
          {
            "type": "integer",
            "description": "Only return traces whose Span.duration is less than or equal to\n` + "`" + `maxDuration` + "`" + ` microseconds. Only valid with minDuration.\n",
            "name": "maxDuration",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "Only return traces where all Span.timestamp are at or before this\ntime in epoch milliseconds. Defaults to current time.\n",
            "name": "endTs",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "Only return traces where all  Span.timestamp are at or after (endTs\n- * lookback) in milliseconds. Defaults to endTs, limited to a\nsystem parameter QUERY_LOOKBACK\n",
            "name": "lookback",
            "in": "query"
          },
          {
            "type": "integer",
            "default": 10,
            "description": "Maximum number of traces to return. Defaults to 10\n",
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "$ref": "#/definitions/ListOfTraces"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "Annotation": {
      "description": "Associates an event that explains latency with a timestamp.\nUnlike log statements, annotations are often codes. Ex. \"ws\" for WireSend\n\nZipkin v1 core annotations such as \"cs\" and \"sr\" have been replaced with\nSpan.Kind, which interprets timestamp and duration.\n",
      "type": "object",
      "title": "Annotation",
      "properties": {
        "timestamp": {
          "description": "Epoch **microseconds** of this event.\n\nFor example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC\n\nThis value should be set directly by instrumentation, using the most precise\nvalue possible. For example, gettimeofday or multiplying epoch millis by 1000.\n",
          "type": "integer"
        },
        "value": {
          "description": "Usually a short tag indicating an event, like \"error\"\n\nWhile possible to add larger data, such as garbage collection details, low\ncardinality event names both keep the size of spans down and also are easy\nto search against.\n",
          "type": "string"
        }
      }
    },
    "DependencyLink": {
      "type": "object",
      "title": "DependencyLink",
      "properties": {
        "callCount": {
          "type": "integer"
        },
        "child": {
          "type": "string"
        },
        "errorCount": {
          "type": "integer"
        },
        "parent": {
          "type": "string"
        }
      }
    },
    "Endpoint": {
      "description": "The network context of a node in the service graph",
      "type": "object",
      "title": "Endpoint",
      "properties": {
        "ipv4": {
          "description": "The text representation of the primary IPv4 address associated with this\na connection. Ex. 192.168.99.100 Absent if unknown.\n",
          "type": "string",
          "format": "ipv4"
        },
        "ipv6": {
          "description": "The text representation of the primary IPv6 address associated with this\na connection. Ex. 2001:db8::c001 Absent if unknown.\n\nPrefer using the ipv4 field for mapped addresses.\n",
          "type": "string",
          "format": "ipv6"
        },
        "port": {
          "description": "Depending on context, this could be a listen port or the client-side of a\nsocket. Absent if unknown\n",
          "type": "integer"
        },
        "serviceName": {
          "description": "Lower-case label of this node in the service graph, such as \"favstar\". Leave\nabsent if unknown.\n\nThis is a primary label for trace lookup and aggregation, so it should be\nintuitive and consistent. Many use a name from service discovery.\n",
          "type": "string"
        }
      }
    },
    "ListOfSpans": {
      "description": "A list of spans with possibly different trace ids, in no particular order",
      "type": "array",
      "title": "ListOfSpans",
      "items": {
        "$ref": "#/definitions/Span"
      }
    },
    "ListOfTraces": {
      "type": "array",
      "title": "ListOfTraces",
      "items": {
        "$ref": "#/definitions/Trace"
      }
    },
    "Span": {
      "type": "object",
      "title": "Span",
      "required": [
        "traceId",
        "id"
      ],
      "properties": {
        "annotations": {
          "description": "Associates events that explain latency with the time they happened.",
          "type": "array",
          "uniqueItems": true,
          "items": {
            "$ref": "#/definitions/Annotation"
          }
        },
        "debug": {
          "description": "True is a request to store this span even if it overrides sampling policy.\n\nThis is true when the ` + "`" + `X-B3-Flags` + "`" + ` header has a value of 1.\n",
          "type": "boolean"
        },
        "duration": {
          "description": "Duration in **microseconds** of the critical path, if known. Durations of less\nthan one are rounded up. Duration of children can be longer than their parents\ndue to asynchronous operations.\n\nFor example 150 milliseconds is 150000 microseconds.\n",
          "type": "integer",
          "format": "int64",
          "minimum": 1
        },
        "id": {
          "description": "Unique 64bit identifier for this operation within the trace.\n\nEncoded as 16 lowercase hex characters. For example ffdc9bb9a6453df3\n",
          "type": "string",
          "maxLength": 16,
          "minLength": 16,
          "pattern": "[a-z0-9]{16}"
        },
        "kind": {
          "description": "When present, clarifies timestamp, duration and remoteEndpoint. When\nabsent, the span is local or incomplete. Unlike client and server,\nthere is no direct critical path latency relationship between producer\nand consumer spans.\n\n* ` + "`" + `CLIENT` + "`" + `\n  * timestamp - The moment a request was sent (formerly \"cs\")\n  * duration - When present indicates when a response was received (formerly \"cr\")\n  * remoteEndpoint - Represents the server. Leave serviceName absent if unknown.\n* ` + "`" + `SERVER` + "`" + `\n  * timestamp - The moment a request was received (formerly \"sr\")\n  * duration - When present indicates when a response was sent (formerly \"ss\")\n  * remoteEndpoint - Represents the client. Leave serviceName absent if unknown.\n* ` + "`" + `PRODUCER` + "`" + `\n  * timestamp - The moment a message was sent to a destination (formerly \"ms\")\n  * duration - When present represents delay sending the message, such as batching.\n  * remoteEndpoint - Represents the broker. Leave serviceName absent if unknown.\n* ` + "`" + `CONSUMER` + "`" + `\n  * timestamp - The moment a message was received from an origin (formerly \"mr\")\n  * duration - When present represents delay consuming the message, such as from backlog.\n  * remoteEndpoint - Represents the broker. Leave serviceName absent if unknown.\n",
          "type": "string",
          "enum": [
            "CLIENT",
            "SERVER",
            "PRODUCER",
            "CONSUMER"
          ]
        },
        "localEndpoint": {
          "description": "The host that recorded this span, primarily for query by service name.\n\nInstrumentation should always record this. Usually, absent implies late data.\nThe IP address corresponding to this is usually the site local or advertised\nservice address. When present, the port indicates the listen port.\n",
          "$ref": "#/definitions/Endpoint"
        },
        "name": {
          "description": "The logical operation this span represents in lowercase (e.g. rpc method).\nLeave absent if unknown.\n\nAs these are lookup labels, take care to ensure names are low cardinality.\nFor example, do not embed variables into the name.\n",
          "type": "string"
        },
        "parentId": {
          "description": "The parent span ID or absent if this the root span in a trace.",
          "type": "string",
          "maxLength": 16,
          "minLength": 16,
          "pattern": "[a-z0-9]{16}"
        },
        "remoteEndpoint": {
          "description": "When an RPC (or messaging) span, indicates the other side of the connection.\n",
          "$ref": "#/definitions/Endpoint"
        },
        "shared": {
          "description": "True if we are contributing to a span started by another tracer (ex on a different host).",
          "type": "boolean"
        },
        "tags": {
          "description": "Tags give your span context for search, viewing and analysis.",
          "$ref": "#/definitions/Tags"
        },
        "timestamp": {
          "description": "Epoch **microseconds** of the start of this span, possibly absent if incomplete.\n\nFor example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC\n\nThis value should be set directly by instrumentation, using the most precise\nvalue possible. For example, gettimeofday or multiplying epoch millis by 1000.\n\nThere are three known edge-cases where this could be reported absent.\n * A span was allocated but never started (ex not yet received a timestamp)\n * The span's start event was lost\n * Data about a completed span (ex tags) were sent after the fact\n",
          "type": "integer",
          "format": "int64"
        },
        "traceId": {
          "description": "Randomly generated, unique identifier for a trace, set on all spans within it.\n\nEncoded as 16 or 32 lowercase hex characters corresponding to 64 or 128 bits.\nFor example, a 128bit trace ID looks like 4e441824ec2b6a44ffdc9bb9a6453df3\n",
          "type": "string",
          "maxLength": 32,
          "minLength": 16,
          "pattern": "[a-z0-9]{16,32}"
        }
      }
    },
    "Tags": {
      "description": "Adds context to a span, for search, viewing and analysis.\n\nFor example, a key \"your_app.version\" would let you lookup traces by version.\nA tag \"sql.query\" isn't searchable, but it can help in debugging when viewing\na trace.\n",
      "type": "object",
      "title": "Tags",
      "additionalProperties": {
        "type": "string"
      }
    },
    "Trace": {
      "description": "List of spans who have the same trace ID.",
      "type": "array",
      "title": "Trace",
      "items": {
        "$ref": "#/definitions/Span"
      }
    }
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Zipkin's v2 api currently includes a POST endpoint that can receive spans.\n",
    "title": "Zipkin API",
    "version": "1.0.0"
  },
  "host": "localhost:9411",
  "basePath": "/api/v2",
  "paths": {
    "/dependencies": {
      "get": {
        "description": "Returns service links derived from spans.\n",
        "parameters": [
          {
            "type": "integer",
            "format": "int64",
            "description": "only return links from spans where ` + "`" + `Span.timestamp` + "`" + `  are at or before\nthis time in epoch milliseconds.\n",
            "name": "endTs",
            "in": "query",
            "required": true
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "only return links where all Span.timestamp are at or after\n(` + "`" + `endTs - * lookback` + "`" + `) in milliseconds. Defaults to ` + "`" + `endTs` + "`" + `, limited\nto a system parameter ` + "`" + `QUERY_LOOKBACK` + "`" + `\n",
            "name": "lookback",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "type": "array",
              "title": "ListOfDependencyLinks",
              "items": {
                "$ref": "#/definitions/DependencyLink"
              }
            }
          }
        }
      }
    },
    "/services": {
      "get": {
        "description": "Returns a list of all service names associated with span endpoints.\n",
        "responses": {
          "200": {
            "description": "Succes",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad Request Error"
          }
        }
      }
    },
    "/spans": {
      "get": {
        "description": "Get all the span names recorded by a particular service",
        "parameters": [
          {
            "type": "string",
            "description": "Ex favstar (required) - Lower-case label of a node in the service\ngraph. The /services endpoint enumerates possible input values.\n",
            "name": "serviceName",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad Request Error"
          }
        }
      },
      "post": {
        "description": "Uploads a list of spans encoded per content-type, for example json.\n",
        "consumes": [
          "application/json"
        ],
        "parameters": [
          {
            "description": "A list of spans that belong to any trace.",
            "name": "spans",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ListOfSpans"
            }
          }
        ],
        "responses": {
          "202": {
            "description": "Accepted"
          }
        }
      }
    },
    "/trace/{traceId}": {
      "get": {
        "parameters": [
          {
            "maxLength": 32,
            "minLength": 16,
            "pattern": "[a-z0-9]{16,32}",
            "type": "string",
            "description": "Trace identifier, set on all spans within it.\n\nEncoded as 16 or 32 lowercase hex characters corresponding to 64 or 128 bits.\nFor example, a 128bit trace ID looks like 4e441824ec2b6a44ffdc9bb9a6453df3\n",
            "name": "traceId",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "$ref": "#/definitions/Trace"
            }
          },
          "404": {
            "description": "` + "`" + `traceId` + "`" + ` not found"
          }
        }
      }
    },
    "/traces": {
      "get": {
        "description": "Invoking this request retrieves traces matching the below filters.\n\nResults should be filtered against endTs, subject to limit and\nlookback. For example, if endTs is 10:20 today, limit is 10, and\nlookback is 7 days, traces returned should be those nearest to 10:20\ntoday, not 10:20 a week ago.\n\nTime units of endTs and lookback are milliseconds as opposed to\nmicroseconds, the grain of Span.timestamp. Milliseconds is a more\nfamiliar and supported granularity for query, index and windowing\nfunctions\n",
        "parameters": [
          {
            "type": "string",
            "description": "Ex favstar (required) - Lower-case label of a node in the service\ngraph. The /services endpoint enumerates possible input values.\n",
            "name": "serviceName",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Ex get - name of a span in a trace.\nOnly return traces that contains spans with this name.\n",
            "name": "spanName",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Ex. ` + "`" + `http.uri=/foo and retried` + "`" + ` - If key/value (has an ` + "`" + `=` + "`" + `),\nconstrains against Span.tags entres. If just a word, constrains\nagainst Span.annotations[].value or Span.tags[].key. Any values are\nAND against eachother. This means a span in the trace must match\nall of these.\n",
            "name": "annotationQuery",
            "in": "query"
          },
          {
            "type": "integer",
            "description": "Ex. 100000 (for 100ms). Only return traces whose ` + "`" + `Span.duration` + "`" + ` is\ngreater than or equal to minDuration microseconds.\n",
            "name": "minDuration",
            "in": "query"
          },
          {
            "type": "integer",
            "description": "Only return traces whose Span.duration is less than or equal to\n` + "`" + `maxDuration` + "`" + ` microseconds. Only valid with minDuration.\n",
            "name": "maxDuration",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "Only return traces where all Span.timestamp are at or before this\ntime in epoch milliseconds. Defaults to current time.\n",
            "name": "endTs",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "Only return traces where all  Span.timestamp are at or after (endTs\n- * lookback) in milliseconds. Defaults to endTs, limited to a\nsystem parameter QUERY_LOOKBACK\n",
            "name": "lookback",
            "in": "query"
          },
          {
            "type": "integer",
            "default": 10,
            "description": "Maximum number of traces to return. Defaults to 10\n",
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "OK",
            "schema": {
              "$ref": "#/definitions/ListOfTraces"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "Annotation": {
      "description": "Associates an event that explains latency with a timestamp.\nUnlike log statements, annotations are often codes. Ex. \"ws\" for WireSend\n\nZipkin v1 core annotations such as \"cs\" and \"sr\" have been replaced with\nSpan.Kind, which interprets timestamp and duration.\n",
      "type": "object",
      "title": "Annotation",
      "properties": {
        "timestamp": {
          "description": "Epoch **microseconds** of this event.\n\nFor example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC\n\nThis value should be set directly by instrumentation, using the most precise\nvalue possible. For example, gettimeofday or multiplying epoch millis by 1000.\n",
          "type": "integer"
        },
        "value": {
          "description": "Usually a short tag indicating an event, like \"error\"\n\nWhile possible to add larger data, such as garbage collection details, low\ncardinality event names both keep the size of spans down and also are easy\nto search against.\n",
          "type": "string"
        }
      }
    },
    "DependencyLink": {
      "type": "object",
      "title": "DependencyLink",
      "properties": {
        "callCount": {
          "type": "integer"
        },
        "child": {
          "type": "string"
        },
        "errorCount": {
          "type": "integer"
        },
        "parent": {
          "type": "string"
        }
      }
    },
    "Endpoint": {
      "description": "The network context of a node in the service graph",
      "type": "object",
      "title": "Endpoint",
      "properties": {
        "ipv4": {
          "description": "The text representation of the primary IPv4 address associated with this\na connection. Ex. 192.168.99.100 Absent if unknown.\n",
          "type": "string",
          "format": "ipv4"
        },
        "ipv6": {
          "description": "The text representation of the primary IPv6 address associated with this\na connection. Ex. 2001:db8::c001 Absent if unknown.\n\nPrefer using the ipv4 field for mapped addresses.\n",
          "type": "string",
          "format": "ipv6"
        },
        "port": {
          "description": "Depending on context, this could be a listen port or the client-side of a\nsocket. Absent if unknown\n",
          "type": "integer"
        },
        "serviceName": {
          "description": "Lower-case label of this node in the service graph, such as \"favstar\". Leave\nabsent if unknown.\n\nThis is a primary label for trace lookup and aggregation, so it should be\nintuitive and consistent. Many use a name from service discovery.\n",
          "type": "string"
        }
      }
    },
    "ListOfSpans": {
      "description": "A list of spans with possibly different trace ids, in no particular order",
      "type": "array",
      "title": "ListOfSpans",
      "items": {
        "$ref": "#/definitions/Span"
      }
    },
    "ListOfTraces": {
      "type": "array",
      "title": "ListOfTraces",
      "items": {
        "$ref": "#/definitions/Trace"
      }
    },
    "Span": {
      "type": "object",
      "title": "Span",
      "required": [
        "traceId",
        "id"
      ],
      "properties": {
        "annotations": {
          "description": "Associates events that explain latency with the time they happened.",
          "type": "array",
          "uniqueItems": true,
          "items": {
            "$ref": "#/definitions/Annotation"
          }
        },
        "debug": {
          "description": "True is a request to store this span even if it overrides sampling policy.\n\nThis is true when the ` + "`" + `X-B3-Flags` + "`" + ` header has a value of 1.\n",
          "type": "boolean"
        },
        "duration": {
          "description": "Duration in **microseconds** of the critical path, if known. Durations of less\nthan one are rounded up. Duration of children can be longer than their parents\ndue to asynchronous operations.\n\nFor example 150 milliseconds is 150000 microseconds.\n",
          "type": "integer",
          "format": "int64",
          "minimum": 1
        },
        "id": {
          "description": "Unique 64bit identifier for this operation within the trace.\n\nEncoded as 16 lowercase hex characters. For example ffdc9bb9a6453df3\n",
          "type": "string",
          "maxLength": 16,
          "minLength": 16,
          "pattern": "[a-z0-9]{16}"
        },
        "kind": {
          "description": "When present, clarifies timestamp, duration and remoteEndpoint. When\nabsent, the span is local or incomplete. Unlike client and server,\nthere is no direct critical path latency relationship between producer\nand consumer spans.\n\n* ` + "`" + `CLIENT` + "`" + `\n  * timestamp - The moment a request was sent (formerly \"cs\")\n  * duration - When present indicates when a response was received (formerly \"cr\")\n  * remoteEndpoint - Represents the server. Leave serviceName absent if unknown.\n* ` + "`" + `SERVER` + "`" + `\n  * timestamp - The moment a request was received (formerly \"sr\")\n  * duration - When present indicates when a response was sent (formerly \"ss\")\n  * remoteEndpoint - Represents the client. Leave serviceName absent if unknown.\n* ` + "`" + `PRODUCER` + "`" + `\n  * timestamp - The moment a message was sent to a destination (formerly \"ms\")\n  * duration - When present represents delay sending the message, such as batching.\n  * remoteEndpoint - Represents the broker. Leave serviceName absent if unknown.\n* ` + "`" + `CONSUMER` + "`" + `\n  * timestamp - The moment a message was received from an origin (formerly \"mr\")\n  * duration - When present represents delay consuming the message, such as from backlog.\n  * remoteEndpoint - Represents the broker. Leave serviceName absent if unknown.\n",
          "type": "string",
          "enum": [
            "CLIENT",
            "SERVER",
            "PRODUCER",
            "CONSUMER"
          ]
        },
        "localEndpoint": {
          "description": "The host that recorded this span, primarily for query by service name.\n\nInstrumentation should always record this. Usually, absent implies late data.\nThe IP address corresponding to this is usually the site local or advertised\nservice address. When present, the port indicates the listen port.\n",
          "$ref": "#/definitions/Endpoint"
        },
        "name": {
          "description": "The logical operation this span represents in lowercase (e.g. rpc method).\nLeave absent if unknown.\n\nAs these are lookup labels, take care to ensure names are low cardinality.\nFor example, do not embed variables into the name.\n",
          "type": "string"
        },
        "parentId": {
          "description": "The parent span ID or absent if this the root span in a trace.",
          "type": "string",
          "maxLength": 16,
          "minLength": 16,
          "pattern": "[a-z0-9]{16}"
        },
        "remoteEndpoint": {
          "description": "When an RPC (or messaging) span, indicates the other side of the connection.\n",
          "$ref": "#/definitions/Endpoint"
        },
        "shared": {
          "description": "True if we are contributing to a span started by another tracer (ex on a different host).",
          "type": "boolean"
        },
        "tags": {
          "description": "Tags give your span context for search, viewing and analysis.",
          "$ref": "#/definitions/Tags"
        },
        "timestamp": {
          "description": "Epoch **microseconds** of the start of this span, possibly absent if incomplete.\n\nFor example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC\n\nThis value should be set directly by instrumentation, using the most precise\nvalue possible. For example, gettimeofday or multiplying epoch millis by 1000.\n\nThere are three known edge-cases where this could be reported absent.\n * A span was allocated but never started (ex not yet received a timestamp)\n * The span's start event was lost\n * Data about a completed span (ex tags) were sent after the fact\n",
          "type": "integer",
          "format": "int64"
        },
        "traceId": {
          "description": "Randomly generated, unique identifier for a trace, set on all spans within it.\n\nEncoded as 16 or 32 lowercase hex characters corresponding to 64 or 128 bits.\nFor example, a 128bit trace ID looks like 4e441824ec2b6a44ffdc9bb9a6453df3\n",
          "type": "string",
          "maxLength": 32,
          "minLength": 16,
          "pattern": "[a-z0-9]{16,32}"
        }
      }
    },
    "Tags": {
      "description": "Adds context to a span, for search, viewing and analysis.\n\nFor example, a key \"your_app.version\" would let you lookup traces by version.\nA tag \"sql.query\" isn't searchable, but it can help in debugging when viewing\na trace.\n",
      "type": "object",
      "title": "Tags",
      "additionalProperties": {
        "type": "string"
      }
    },
    "Trace": {
      "description": "List of spans who have the same trace ID.",
      "type": "array",
      "title": "Trace",
      "items": {
        "$ref": "#/definitions/Span"
      }
    }
  }
}`))
}
