// Code generated by NodeGenerator. DO NOT EDIT.

// Package node is a generated by the generator.
package node

import (
	"sync/atomic"
	"unsafe"
)

// BW is a cache entry that provide the following features:
//
// 1. Base
//
// 2. Weight
type BW[K comparable, V any] struct {
	key       K
	value     V
	prev      *BW[K, V]
	next      *BW[K, V]
	weight    uint32
	state     atomic.Uint32
	queueType uint8
}

// NewBW creates a new BW.
func NewBW[K comparable, V any](key K, value V, expiresAt, refreshableAt int64, weight uint32) Node[K, V] {
	n := &BW[K, V]{
		key:    key,
		value:  value,
		weight: weight,
	}
	n.state.Store(aliveState)

	return n
}

// CastPointerToBW casts a pointer to BW.
func CastPointerToBW[K comparable, V any](ptr unsafe.Pointer) Node[K, V] {
	return (*BW[K, V])(ptr)
}

func (n *BW[K, V]) Key() K {
	return n.key
}

func (n *BW[K, V]) Value() V {
	return n.value
}

func (n *BW[K, V]) AsPointer() unsafe.Pointer {
	return unsafe.Pointer(n)
}

func (n *BW[K, V]) Prev() Node[K, V] {
	return n.prev
}

func (n *BW[K, V]) SetPrev(v Node[K, V]) {
	if v == nil {
		n.prev = nil
		return
	}
	n.prev = (*BW[K, V])(v.AsPointer())
}

func (n *BW[K, V]) Next() Node[K, V] {
	return n.next
}

func (n *BW[K, V]) SetNext(v Node[K, V]) {
	if v == nil {
		n.next = nil
		return
	}
	n.next = (*BW[K, V])(v.AsPointer())
}

func (n *BW[K, V]) PrevExp() Node[K, V] {
	panic("not implemented")
}

func (n *BW[K, V]) SetPrevExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BW[K, V]) NextExp() Node[K, V] {
	panic("not implemented")
}

func (n *BW[K, V]) SetNextExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BW[K, V]) HasExpired(now int64) bool {
	return false
}

func (n *BW[K, V]) ExpiresAt() int64 {
	panic("not implemented")
}

func (n *BW[K, V]) CASExpiresAt(old, new int64) bool {
	panic("not implemented")
}

func (n *BW[K, V]) SetExpiresAt(new int64) {
	panic("not implemented")
}

func (n *BW[K, V]) RefreshableAt() int64 {
	panic("not implemented")
}

func (n *BW[K, V]) CASRefreshableAt(old, new int64) bool {
	panic("not implemented")
}

func (n *BW[K, V]) SetRefreshableAt(new int64) {
	panic("not implemented")
}

func (n *BW[K, V]) IsFresh(now int64) bool {
	return true
}

func (n *BW[K, V]) Weight() uint32 {
	return n.weight
}

func (n *BW[K, V]) IsAlive() bool {
	return n.state.Load() == aliveState
}

func (n *BW[K, V]) IsRetired() bool {
	return n.state.Load() == retiredState
}

func (n *BW[K, V]) Retire() {
	n.state.Store(retiredState)
}

func (n *BW[K, V]) IsDead() bool {
	return n.state.Load() == deadState
}

func (n *BW[K, V]) Die() {
	n.state.Store(deadState)
}

func (n *BW[K, V]) GetQueueType() uint8 {
	return n.queueType
}

func (n *BW[K, V]) SetQueueType(queueType uint8) {
	n.queueType = queueType
}

func (n *BW[K, V]) InWindow() bool {
	return n.GetQueueType() == InWindowQueue
}

func (n *BW[K, V]) MakeWindow() {
	n.SetQueueType(InWindowQueue)
}

func (n *BW[K, V]) InMainProbation() bool {
	return n.GetQueueType() == InMainProbationQueue
}

func (n *BW[K, V]) MakeMainProbation() {
	n.SetQueueType(InMainProbationQueue)
}

func (n *BW[K, V]) InMainProtected() bool {
	return n.GetQueueType() == InMainProtectedQueue
}

func (n *BW[K, V]) MakeMainProtected() {
	n.SetQueueType(InMainProtectedQueue)
}
