// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Identity and Access Management Service API
//
// APIs for managing users, groups, compartments, and policies.
//

package identity

import (
	"github.com/oracle/oci-go-sdk/v32/common"
)

// CreateTagDefaultDetails The representation of CreateTagDefaultDetails
type CreateTagDefaultDetails struct {

	// The OCID of the compartment. The tag default will be applied to all new resources created in this compartment.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The OCID of the tag definition. The tag default will always assign a default value for this tag definition.
	TagDefinitionId *string `mandatory:"true" json:"tagDefinitionId"`

	// The default value for the tag definition. This will be applied to all new resources created in the compartment.
	Value *string `mandatory:"true" json:"value"`

	// If you specify that a value is required, a value is set during resource creation (either by
	// the user creating the resource or another tag defualt). If no value is set, resource
	// creation is blocked.
	// * If the `isRequired` flag is set to "true", the value is set during resource creation.
	// * If the `isRequired` flag is set to "false", the value you enter is set during resource creation.
	// Example: `false`
	IsRequired *bool `mandatory:"false" json:"isRequired"`
}

func (m CreateTagDefaultDetails) String() string {
	return common.PointerString(m)
}
