// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostAgentScanLevelEnum Enum with underlying type: string
type HostAgentScanLevelEnum string

// Set of constants representing the allowable values for HostAgentScanLevelEnum
const (
	HostAgentScanLevelNone     HostAgentScanLevelEnum = "NONE"
	HostAgentScanLevelStandard HostAgentScanLevelEnum = "STANDARD"
)

var mappingHostAgentScanLevelEnum = map[string]HostAgentScanLevelEnum{
	"NONE":     HostAgentScanLevelNone,
	"STANDARD": HostAgentScanLevelStandard,
}

var mappingHostAgentScanLevelEnumLowerCase = map[string]HostAgentScanLevelEnum{
	"none":     HostAgentScanLevelNone,
	"standard": HostAgentScanLevelStandard,
}

// GetHostAgentScanLevelEnumValues Enumerates the set of values for HostAgentScanLevelEnum
func GetHostAgentScanLevelEnumValues() []HostAgentScanLevelEnum {
	values := make([]HostAgentScanLevelEnum, 0)
	for _, v := range mappingHostAgentScanLevelEnum {
		values = append(values, v)
	}
	return values
}

// GetHostAgentScanLevelEnumStringValues Enumerates the set of values in String for HostAgentScanLevelEnum
func GetHostAgentScanLevelEnumStringValues() []string {
	return []string{
		"NONE",
		"STANDARD",
	}
}

// GetMappingHostAgentScanLevelEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostAgentScanLevelEnum(val string) (HostAgentScanLevelEnum, bool) {
	enum, ok := mappingHostAgentScanLevelEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
