// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostScanTargetsRequest wrapper for the ListHostScanTargets operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostScanTargets.go.html to see an example of how to use ListHostScanTargetsRequest.
type ListHostScanTargetsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources whose lifecycleState matches the given lifecycleState.
	LifecycleState ListHostScanTargetsLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostScanTargetsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.
	SortBy ListHostScanTargetsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostScanTargetsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostScanTargetsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostScanTargetsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostScanTargetsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostScanTargetsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostScanTargetsLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetListHostScanTargetsLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostScanTargetsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostScanTargetsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostScanTargetsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostScanTargetsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostScanTargetsResponse wrapper for the ListHostScanTargets operation
type ListHostScanTargetsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostScanTargetSummaryCollection instances
	HostScanTargetSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostScanTargetsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostScanTargetsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostScanTargetsLifecycleStateEnum Enum with underlying type: string
type ListHostScanTargetsLifecycleStateEnum string

// Set of constants representing the allowable values for ListHostScanTargetsLifecycleStateEnum
const (
	ListHostScanTargetsLifecycleStateCreating ListHostScanTargetsLifecycleStateEnum = "CREATING"
	ListHostScanTargetsLifecycleStateUpdating ListHostScanTargetsLifecycleStateEnum = "UPDATING"
	ListHostScanTargetsLifecycleStateActive   ListHostScanTargetsLifecycleStateEnum = "ACTIVE"
	ListHostScanTargetsLifecycleStateDeleting ListHostScanTargetsLifecycleStateEnum = "DELETING"
	ListHostScanTargetsLifecycleStateDeleted  ListHostScanTargetsLifecycleStateEnum = "DELETED"
	ListHostScanTargetsLifecycleStateFailed   ListHostScanTargetsLifecycleStateEnum = "FAILED"
)

var mappingListHostScanTargetsLifecycleStateEnum = map[string]ListHostScanTargetsLifecycleStateEnum{
	"CREATING": ListHostScanTargetsLifecycleStateCreating,
	"UPDATING": ListHostScanTargetsLifecycleStateUpdating,
	"ACTIVE":   ListHostScanTargetsLifecycleStateActive,
	"DELETING": ListHostScanTargetsLifecycleStateDeleting,
	"DELETED":  ListHostScanTargetsLifecycleStateDeleted,
	"FAILED":   ListHostScanTargetsLifecycleStateFailed,
}

var mappingListHostScanTargetsLifecycleStateEnumLowerCase = map[string]ListHostScanTargetsLifecycleStateEnum{
	"creating": ListHostScanTargetsLifecycleStateCreating,
	"updating": ListHostScanTargetsLifecycleStateUpdating,
	"active":   ListHostScanTargetsLifecycleStateActive,
	"deleting": ListHostScanTargetsLifecycleStateDeleting,
	"deleted":  ListHostScanTargetsLifecycleStateDeleted,
	"failed":   ListHostScanTargetsLifecycleStateFailed,
}

// GetListHostScanTargetsLifecycleStateEnumValues Enumerates the set of values for ListHostScanTargetsLifecycleStateEnum
func GetListHostScanTargetsLifecycleStateEnumValues() []ListHostScanTargetsLifecycleStateEnum {
	values := make([]ListHostScanTargetsLifecycleStateEnum, 0)
	for _, v := range mappingListHostScanTargetsLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanTargetsLifecycleStateEnumStringValues Enumerates the set of values in String for ListHostScanTargetsLifecycleStateEnum
func GetListHostScanTargetsLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"UPDATING",
		"ACTIVE",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingListHostScanTargetsLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanTargetsLifecycleStateEnum(val string) (ListHostScanTargetsLifecycleStateEnum, bool) {
	enum, ok := mappingListHostScanTargetsLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostScanTargetsSortOrderEnum Enum with underlying type: string
type ListHostScanTargetsSortOrderEnum string

// Set of constants representing the allowable values for ListHostScanTargetsSortOrderEnum
const (
	ListHostScanTargetsSortOrderAsc  ListHostScanTargetsSortOrderEnum = "ASC"
	ListHostScanTargetsSortOrderDesc ListHostScanTargetsSortOrderEnum = "DESC"
)

var mappingListHostScanTargetsSortOrderEnum = map[string]ListHostScanTargetsSortOrderEnum{
	"ASC":  ListHostScanTargetsSortOrderAsc,
	"DESC": ListHostScanTargetsSortOrderDesc,
}

var mappingListHostScanTargetsSortOrderEnumLowerCase = map[string]ListHostScanTargetsSortOrderEnum{
	"asc":  ListHostScanTargetsSortOrderAsc,
	"desc": ListHostScanTargetsSortOrderDesc,
}

// GetListHostScanTargetsSortOrderEnumValues Enumerates the set of values for ListHostScanTargetsSortOrderEnum
func GetListHostScanTargetsSortOrderEnumValues() []ListHostScanTargetsSortOrderEnum {
	values := make([]ListHostScanTargetsSortOrderEnum, 0)
	for _, v := range mappingListHostScanTargetsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanTargetsSortOrderEnumStringValues Enumerates the set of values in String for ListHostScanTargetsSortOrderEnum
func GetListHostScanTargetsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostScanTargetsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanTargetsSortOrderEnum(val string) (ListHostScanTargetsSortOrderEnum, bool) {
	enum, ok := mappingListHostScanTargetsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostScanTargetsSortByEnum Enum with underlying type: string
type ListHostScanTargetsSortByEnum string

// Set of constants representing the allowable values for ListHostScanTargetsSortByEnum
const (
	ListHostScanTargetsSortByTimecreated ListHostScanTargetsSortByEnum = "timeCreated"
	ListHostScanTargetsSortByDisplayname ListHostScanTargetsSortByEnum = "displayName"
)

var mappingListHostScanTargetsSortByEnum = map[string]ListHostScanTargetsSortByEnum{
	"timeCreated": ListHostScanTargetsSortByTimecreated,
	"displayName": ListHostScanTargetsSortByDisplayname,
}

var mappingListHostScanTargetsSortByEnumLowerCase = map[string]ListHostScanTargetsSortByEnum{
	"timecreated": ListHostScanTargetsSortByTimecreated,
	"displayname": ListHostScanTargetsSortByDisplayname,
}

// GetListHostScanTargetsSortByEnumValues Enumerates the set of values for ListHostScanTargetsSortByEnum
func GetListHostScanTargetsSortByEnumValues() []ListHostScanTargetsSortByEnum {
	values := make([]ListHostScanTargetsSortByEnum, 0)
	for _, v := range mappingListHostScanTargetsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanTargetsSortByEnumStringValues Enumerates the set of values in String for ListHostScanTargetsSortByEnum
func GetListHostScanTargetsSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListHostScanTargetsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanTargetsSortByEnum(val string) (ListHostScanTargetsSortByEnum, bool) {
	enum, ok := mappingListHostScanTargetsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
