// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Oracle Cloud Migrations API
//
// A description of the Oracle Cloud Migrations API.
//

package cloudmigrations

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// MigrationAssetSummary Summary of the migration asset.
type MigrationAssetSummary struct {

	// The asset ID generated by the mirgration service. It is used in the migration service pipeline.
	Id *string `mandatory:"true" json:"id"`

	// The type of asset referenced for an inventory.
	Type *string `mandatory:"true" json:"type"`

	// The current state of the migration asset.
	LifecycleState MigrationAssetLifecycleStateEnum `mandatory:"true" json:"lifecycleState"`

	// The time when the migration asset was created. An RFC3339 formatted datetime string.
	TimeCreated *common.SDKTime `mandatory:"true" json:"timeCreated"`

	// OCID of the associated migration.
	MigrationId *string `mandatory:"true" json:"migrationId"`

	// A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// Compartment identifier
	CompartmentId *string `mandatory:"false" json:"compartmentId"`

	// A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
	LifecycleDetails *string `mandatory:"false" json:"lifecycleDetails"`

	// The time when the migration asset was updated. An RFC3339 formatted datetime string.
	TimeUpdated *common.SDKTime `mandatory:"false" json:"timeUpdated"`

	// Key-value pair representing disk's ID that is mapped to the OCIDs of replicated/hydration server volume snapshots.
	// Example: `{"bar-key": "value"}`
	Snapshots map[string]HydratedVolume `mandatory:"false" json:"snapshots"`

	// The parent snapshot of the mgration asset to be used by the replication task.
	ParentSnapshot *string `mandatory:"false" json:"parentSnapshot"`

	// The snapshot information.
	SnapshotInfo *string `mandatory:"false" json:"snapshotInfo"`

	// Key-value pair representing asset metadata keys and values scoped to a namespace.
	// Example: `{"bar-key": "value"}`
	SourceAssetData map[string]interface{} `mandatory:"false" json:"sourceAssetData"`

	// List of notifications.
	Notifications []MigrationAssetSummaryNotificationsEnum `mandatory:"false" json:"notifications,omitempty"`

	// OCID that is referenced to an asset, for an inventory.
	SourceAssetId *string `mandatory:"false" json:"sourceAssetId"`

	// List of migration assets that depend on this asset.
	DependedOnBy []string `mandatory:"false" json:"dependedOnBy"`

	// List of migration assets that depend on this asset.
	DependsOn []string `mandatory:"false" json:"dependsOn"`

	// Replication schedule identifier
	ReplicationScheduleId *string `mandatory:"false" json:"replicationScheduleId"`

	// Tenancy Identifier
	TenancyId *string `mandatory:"false" json:"tenancyId"`
}

func (m MigrationAssetSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m MigrationAssetSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingMigrationAssetLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetMigrationAssetLifecycleStateEnumStringValues(), ",")))
	}

	for _, val := range m.Notifications {
		if _, ok := GetMappingMigrationAssetSummaryNotificationsEnum(string(val)); !ok && val != "" {
			errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Notifications: %s. Supported values are: %s.", val, strings.Join(GetMigrationAssetSummaryNotificationsEnumStringValues(), ",")))
		}
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MigrationAssetSummaryNotificationsEnum Enum with underlying type: string
type MigrationAssetSummaryNotificationsEnum string

// Set of constants representing the allowable values for MigrationAssetSummaryNotificationsEnum
const (
	MigrationAssetSummaryNotificationsOutOfDate     MigrationAssetSummaryNotificationsEnum = "OUT_OF_DATE"
	MigrationAssetSummaryNotificationsSourceRemoved MigrationAssetSummaryNotificationsEnum = "SOURCE_REMOVED"
)

var mappingMigrationAssetSummaryNotificationsEnum = map[string]MigrationAssetSummaryNotificationsEnum{
	"OUT_OF_DATE":    MigrationAssetSummaryNotificationsOutOfDate,
	"SOURCE_REMOVED": MigrationAssetSummaryNotificationsSourceRemoved,
}

var mappingMigrationAssetSummaryNotificationsEnumLowerCase = map[string]MigrationAssetSummaryNotificationsEnum{
	"out_of_date":    MigrationAssetSummaryNotificationsOutOfDate,
	"source_removed": MigrationAssetSummaryNotificationsSourceRemoved,
}

// GetMigrationAssetSummaryNotificationsEnumValues Enumerates the set of values for MigrationAssetSummaryNotificationsEnum
func GetMigrationAssetSummaryNotificationsEnumValues() []MigrationAssetSummaryNotificationsEnum {
	values := make([]MigrationAssetSummaryNotificationsEnum, 0)
	for _, v := range mappingMigrationAssetSummaryNotificationsEnum {
		values = append(values, v)
	}
	return values
}

// GetMigrationAssetSummaryNotificationsEnumStringValues Enumerates the set of values in String for MigrationAssetSummaryNotificationsEnum
func GetMigrationAssetSummaryNotificationsEnumStringValues() []string {
	return []string{
		"OUT_OF_DATE",
		"SOURCE_REMOVED",
	}
}

// GetMappingMigrationAssetSummaryNotificationsEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingMigrationAssetSummaryNotificationsEnum(val string) (MigrationAssetSummaryNotificationsEnum, bool) {
	enum, ok := mappingMigrationAssetSummaryNotificationsEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
