# Getting Started with go-exploit

This guide will help you get started with `go-exploit`, a Go package that assists developers in defining the following four stages of exploitation:

1. Target validation
2. [Version checking](https://github.com/vulncheck-oss/go-exploit/blob/main/docs/version-checking.md)
3. Exploitation
4. [Command and control](https://github.com/vulncheck-oss/go-exploit/blob/main/docs/c2.md)

## Exploit Skeleton

An exploit is structured as follows:

```go
package main

import (
	"github.com/vulncheck-oss/go-exploit"
	"github.com/vulncheck-oss/go-exploit/c2"
	"github.com/vulncheck-oss/go-exploit/config"
)

type MyExploit struct{}

func (sploit MyExploit) ValidateTarget(conf *config.Config) bool {
	return false
}

func (sploit MyExploit) CheckVersion(conf *config.Config) exploit.VersionCheckType {
	return exploit.NotImplemented
}

func (sploit MyExploit) RunExploit(conf *config.Config) bool {
	return true
}

func main() {
	supportedC2 := []c2.Impl{
		c2.SimpleShellServer,
		c2.SimpleShellClient,
	}
	conf := config.NewRemoteExploit(
		config.ImplementedFeatures{AssetDetection: false, VersionScanning: false, Exploitation: false},
		config.CodeExecution, supportedC2, "Vendor", []string{"Product"},
		[]string{"cpe:2.3:a:vendor:product"}, "CVE-2024-1270", "HTTP", 8080)
	
	sploit := MyExploit{}
	exploit.RunProgram(sploit, conf)
}
```

The above code demonstrates the four stages of exploitation that `go-exploit` cares about:

1. `ValidateTarget()` is called to verify if the target is correct.
2. `CheckVersion()` is called to perform a version check on the target.
3. `RunExploit` is called to exploit the target.
4. `main` sets up the possible command and control (C2) methods (e.g., `c2.SimpleShellServer`), defines the type of exploit (`config.CodeExecution`), and passes execution to `go-exploit` using `exploit.RunProgram`.

## Makefile

To compile the skeleton, you can use a `Makefile`. Here's a simple one:

```
all: format compile

format:
	go fmt

compile:
	go build

clean:
	go clean
```

## Compiling

To compile the skeleton, follow these steps:

1. Initialize the exploit's `go.mod`, download/validate the most recent `go-exploit`, and create `go.sum`.

```sh
go mod init github.com/username/example;
GO111MODULE=on go mod tidy;
make;
```

## Conclusion

This guide should provide you with enough information to get started with `go-exploit`. For more details on exploit types, [command and control (C2)](https://github.com/vulncheck-oss/go-exploit/blob/main/docs/c2.md), and [version checking](https://github.com/vulncheck-oss/go-exploit/blob/main/docs/version-checking.md)), please refer to the [additional documentation](https://github.com/vulncheck-oss/go-exploit/tree/main/docs).

