//line sql.y:18
package sqlparser

import __yyfmt__ "fmt"

//line sql.y:18
func setParseTree(yylex interface{}, stmt Statement) {
	yylex.(*Tokenizer).ParseTree = stmt
}

func setAllowComments(yylex interface{}, allow bool) {
	yylex.(*Tokenizer).AllowComments = allow
}

func setDDL(yylex interface{}, ddl *DDL) {
	yylex.(*Tokenizer).partialDDL = ddl
}

func incNesting(yylex interface{}) bool {
	yylex.(*Tokenizer).nesting++
	if yylex.(*Tokenizer).nesting == 200 {
		return true
	}
	return false
}

func decNesting(yylex interface{}) {
	yylex.(*Tokenizer).nesting--
}

// forceEOF forces the lexer to end prematurely. Not all SQL statements
// are supported by the Parser, thus calling forceEOF will make the lexer
// return EOF early.
func forceEOF(yylex interface{}) {
	yylex.(*Tokenizer).ForceEOF = true
}

//line sql.y:53
type yySymType struct {
	yys               int
	empty             struct{}
	statement         Statement
	selStmt           SelectStatement
	ddl               *DDL
	ins               *Insert
	byt               byte
	bytes             []byte
	bytes2            [][]byte
	str               string
	strs              []string
	selectExprs       SelectExprs
	selectExpr        SelectExpr
	columns           Columns
	partitions        Partitions
	colName           *ColName
	tableExprs        TableExprs
	tableExpr         TableExpr
	joinCondition     JoinCondition
	tableName         TableName
	tableNames        TableNames
	indexHints        *IndexHints
	expr              Expr
	exprs             Exprs
	boolVal           BoolVal
	colTuple          ColTuple
	values            Values
	valTuple          ValTuple
	subquery          *Subquery
	whens             []*When
	when              *When
	orderBy           OrderBy
	order             *Order
	limit             *Limit
	updateExprs       UpdateExprs
	setExprs          SetExprs
	updateExpr        *UpdateExpr
	setExpr           *SetExpr
	colIdent          ColIdent
	tableIdent        TableIdent
	convertType       *ConvertType
	aliasedTableName  *AliasedTableExpr
	TableSpec         *TableSpec
	columnType        ColumnType
	colKeyOpt         ColumnKeyOption
	optVal            *SQLVal
	LengthScaleOption LengthScaleOption
	columnDefinition  *ColumnDefinition
	indexDefinition   *IndexDefinition
	indexInfo         *IndexInfo
	indexOption       *IndexOption
	indexOptions      []*IndexOption
	indexColumn       *IndexColumn
	indexColumns      []*IndexColumn
	partDefs          []*PartitionDefinition
	partDef           *PartitionDefinition
	partSpec          *PartitionSpec
	vindexParam       VindexParam
	vindexParams      []VindexParam
	showFilter        *ShowFilter
}

const LEX_ERROR = 57346
const UNION = 57347
const SELECT = 57348
const STREAM = 57349
const INSERT = 57350
const UPDATE = 57351
const DELETE = 57352
const FROM = 57353
const WHERE = 57354
const GROUP = 57355
const HAVING = 57356
const ORDER = 57357
const BY = 57358
const LIMIT = 57359
const OFFSET = 57360
const FOR = 57361
const ALL = 57362
const DISTINCT = 57363
const AS = 57364
const EXISTS = 57365
const ASC = 57366
const DESC = 57367
const INTO = 57368
const DUPLICATE = 57369
const KEY = 57370
const DEFAULT = 57371
const SET = 57372
const LOCK = 57373
const KEYS = 57374
const VALUES = 57375
const LAST_INSERT_ID = 57376
const NEXT = 57377
const VALUE = 57378
const SHARE = 57379
const MODE = 57380
const SQL_NO_CACHE = 57381
const SQL_CACHE = 57382
const JOIN = 57383
const STRAIGHT_JOIN = 57384
const LEFT = 57385
const RIGHT = 57386
const INNER = 57387
const OUTER = 57388
const CROSS = 57389
const NATURAL = 57390
const USE = 57391
const FORCE = 57392
const ON = 57393
const USING = 57394
const ID = 57395
const HEX = 57396
const STRING = 57397
const INTEGRAL = 57398
const FLOAT = 57399
const HEXNUM = 57400
const VALUE_ARG = 57401
const LIST_ARG = 57402
const COMMENT = 57403
const COMMENT_KEYWORD = 57404
const BIT_LITERAL = 57405
const NULL = 57406
const TRUE = 57407
const FALSE = 57408
const OR = 57409
const AND = 57410
const NOT = 57411
const BETWEEN = 57412
const CASE = 57413
const WHEN = 57414
const THEN = 57415
const ELSE = 57416
const END = 57417
const LE = 57418
const GE = 57419
const NE = 57420
const NULL_SAFE_EQUAL = 57421
const IS = 57422
const LIKE = 57423
const REGEXP = 57424
const IN = 57425
const SHIFT_LEFT = 57426
const SHIFT_RIGHT = 57427
const DIV = 57428
const MOD = 57429
const UNARY = 57430
const COLLATE = 57431
const BINARY = 57432
const UNDERSCORE_BINARY = 57433
const INTERVAL = 57434
const JSON_EXTRACT_OP = 57435
const JSON_UNQUOTE_EXTRACT_OP = 57436
const CREATE = 57437
const ALTER = 57438
const DROP = 57439
const RENAME = 57440
const ANALYZE = 57441
const ADD = 57442
const SCHEMA = 57443
const TABLE = 57444
const INDEX = 57445
const VIEW = 57446
const TO = 57447
const IGNORE = 57448
const IF = 57449
const UNIQUE = 57450
const PRIMARY = 57451
const COLUMN = 57452
const CONSTRAINT = 57453
const SPATIAL = 57454
const FULLTEXT = 57455
const FOREIGN = 57456
const KEY_BLOCK_SIZE = 57457
const SHOW = 57458
const DESCRIBE = 57459
const EXPLAIN = 57460
const DATE = 57461
const ESCAPE = 57462
const REPAIR = 57463
const OPTIMIZE = 57464
const TRUNCATE = 57465
const MAXVALUE = 57466
const PARTITION = 57467
const REORGANIZE = 57468
const LESS = 57469
const THAN = 57470
const PROCEDURE = 57471
const TRIGGER = 57472
const VINDEX = 57473
const VINDEXES = 57474
const STATUS = 57475
const VARIABLES = 57476
const BEGIN = 57477
const START = 57478
const TRANSACTION = 57479
const COMMIT = 57480
const ROLLBACK = 57481
const BIT = 57482
const TINYINT = 57483
const SMALLINT = 57484
const MEDIUMINT = 57485
const INT = 57486
const INTEGER = 57487
const BIGINT = 57488
const INTNUM = 57489
const REAL = 57490
const DOUBLE = 57491
const FLOAT_TYPE = 57492
const DECIMAL = 57493
const NUMERIC = 57494
const TIME = 57495
const TIMESTAMP = 57496
const DATETIME = 57497
const YEAR = 57498
const CHAR = 57499
const VARCHAR = 57500
const BOOL = 57501
const CHARACTER = 57502
const VARBINARY = 57503
const NCHAR = 57504
const TEXT = 57505
const TINYTEXT = 57506
const MEDIUMTEXT = 57507
const LONGTEXT = 57508
const BLOB = 57509
const TINYBLOB = 57510
const MEDIUMBLOB = 57511
const LONGBLOB = 57512
const JSON = 57513
const ENUM = 57514
const GEOMETRY = 57515
const POINT = 57516
const LINESTRING = 57517
const POLYGON = 57518
const GEOMETRYCOLLECTION = 57519
const MULTIPOINT = 57520
const MULTILINESTRING = 57521
const MULTIPOLYGON = 57522
const NULLX = 57523
const AUTO_INCREMENT = 57524
const APPROXNUM = 57525
const SIGNED = 57526
const UNSIGNED = 57527
const ZEROFILL = 57528
const DATABASES = 57529
const TABLES = 57530
const VITESS_KEYSPACES = 57531
const VITESS_SHARDS = 57532
const VITESS_TABLETS = 57533
const VSCHEMA_TABLES = 57534
const EXTENDED = 57535
const FULL = 57536
const PROCESSLIST = 57537
const NAMES = 57538
const CHARSET = 57539
const GLOBAL = 57540
const SESSION = 57541
const ISOLATION = 57542
const LEVEL = 57543
const READ = 57544
const WRITE = 57545
const ONLY = 57546
const REPEATABLE = 57547
const COMMITTED = 57548
const UNCOMMITTED = 57549
const SERIALIZABLE = 57550
const CURRENT_TIMESTAMP = 57551
const DATABASE = 57552
const CURRENT_DATE = 57553
const CURRENT_TIME = 57554
const LOCALTIME = 57555
const LOCALTIMESTAMP = 57556
const UTC_DATE = 57557
const UTC_TIME = 57558
const UTC_TIMESTAMP = 57559
const REPLACE = 57560
const CONVERT = 57561
const CAST = 57562
const SUBSTR = 57563
const SUBSTRING = 57564
const GROUP_CONCAT = 57565
const SEPARATOR = 57566
const MATCH = 57567
const AGAINST = 57568
const BOOLEAN = 57569
const LANGUAGE = 57570
const WITH = 57571
const QUERY = 57572
const EXPANSION = 57573
const UNUSED = 57574

var yyToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"LEX_ERROR",
	"UNION",
	"SELECT",
	"STREAM",
	"INSERT",
	"UPDATE",
	"DELETE",
	"FROM",
	"WHERE",
	"GROUP",
	"HAVING",
	"ORDER",
	"BY",
	"LIMIT",
	"OFFSET",
	"FOR",
	"ALL",
	"DISTINCT",
	"AS",
	"EXISTS",
	"ASC",
	"DESC",
	"INTO",
	"DUPLICATE",
	"KEY",
	"DEFAULT",
	"SET",
	"LOCK",
	"KEYS",
	"VALUES",
	"LAST_INSERT_ID",
	"NEXT",
	"VALUE",
	"SHARE",
	"MODE",
	"SQL_NO_CACHE",
	"SQL_CACHE",
	"JOIN",
	"STRAIGHT_JOIN",
	"LEFT",
	"RIGHT",
	"INNER",
	"OUTER",
	"CROSS",
	"NATURAL",
	"USE",
	"FORCE",
	"ON",
	"USING",
	"'('",
	"','",
	"')'",
	"ID",
	"HEX",
	"STRING",
	"INTEGRAL",
	"FLOAT",
	"HEXNUM",
	"VALUE_ARG",
	"LIST_ARG",
	"COMMENT",
	"COMMENT_KEYWORD",
	"BIT_LITERAL",
	"NULL",
	"TRUE",
	"FALSE",
	"OR",
	"AND",
	"NOT",
	"'!'",
	"BETWEEN",
	"CASE",
	"WHEN",
	"THEN",
	"ELSE",
	"END",
	"'='",
	"'<'",
	"'>'",
	"LE",
	"GE",
	"NE",
	"NULL_SAFE_EQUAL",
	"IS",
	"LIKE",
	"REGEXP",
	"IN",
	"'|'",
	"'&'",
	"SHIFT_LEFT",
	"SHIFT_RIGHT",
	"'+'",
	"'-'",
	"'*'",
	"'/'",
	"DIV",
	"'%'",
	"MOD",
	"'^'",
	"'~'",
	"UNARY",
	"COLLATE",
	"BINARY",
	"UNDERSCORE_BINARY",
	"INTERVAL",
	"'.'",
	"JSON_EXTRACT_OP",
	"JSON_UNQUOTE_EXTRACT_OP",
	"CREATE",
	"ALTER",
	"DROP",
	"RENAME",
	"ANALYZE",
	"ADD",
	"SCHEMA",
	"TABLE",
	"INDEX",
	"VIEW",
	"TO",
	"IGNORE",
	"IF",
	"UNIQUE",
	"PRIMARY",
	"COLUMN",
	"CONSTRAINT",
	"SPATIAL",
	"FULLTEXT",
	"FOREIGN",
	"KEY_BLOCK_SIZE",
	"SHOW",
	"DESCRIBE",
	"EXPLAIN",
	"DATE",
	"ESCAPE",
	"REPAIR",
	"OPTIMIZE",
	"TRUNCATE",
	"MAXVALUE",
	"PARTITION",
	"REORGANIZE",
	"LESS",
	"THAN",
	"PROCEDURE",
	"TRIGGER",
	"VINDEX",
	"VINDEXES",
	"STATUS",
	"VARIABLES",
	"BEGIN",
	"START",
	"TRANSACTION",
	"COMMIT",
	"ROLLBACK",
	"BIT",
	"TINYINT",
	"SMALLINT",
	"MEDIUMINT",
	"INT",
	"INTEGER",
	"BIGINT",
	"INTNUM",
	"REAL",
	"DOUBLE",
	"FLOAT_TYPE",
	"DECIMAL",
	"NUMERIC",
	"TIME",
	"TIMESTAMP",
	"DATETIME",
	"YEAR",
	"CHAR",
	"VARCHAR",
	"BOOL",
	"CHARACTER",
	"VARBINARY",
	"NCHAR",
	"TEXT",
	"TINYTEXT",
	"MEDIUMTEXT",
	"LONGTEXT",
	"BLOB",
	"TINYBLOB",
	"MEDIUMBLOB",
	"LONGBLOB",
	"JSON",
	"ENUM",
	"GEOMETRY",
	"POINT",
	"LINESTRING",
	"POLYGON",
	"GEOMETRYCOLLECTION",
	"MULTIPOINT",
	"MULTILINESTRING",
	"MULTIPOLYGON",
	"NULLX",
	"AUTO_INCREMENT",
	"APPROXNUM",
	"SIGNED",
	"UNSIGNED",
	"ZEROFILL",
	"DATABASES",
	"TABLES",
	"VITESS_KEYSPACES",
	"VITESS_SHARDS",
	"VITESS_TABLETS",
	"VSCHEMA_TABLES",
	"EXTENDED",
	"FULL",
	"PROCESSLIST",
	"NAMES",
	"CHARSET",
	"GLOBAL",
	"SESSION",
	"ISOLATION",
	"LEVEL",
	"READ",
	"WRITE",
	"ONLY",
	"REPEATABLE",
	"COMMITTED",
	"UNCOMMITTED",
	"SERIALIZABLE",
	"CURRENT_TIMESTAMP",
	"DATABASE",
	"CURRENT_DATE",
	"CURRENT_TIME",
	"LOCALTIME",
	"LOCALTIMESTAMP",
	"UTC_DATE",
	"UTC_TIME",
	"UTC_TIMESTAMP",
	"REPLACE",
	"CONVERT",
	"CAST",
	"SUBSTR",
	"SUBSTRING",
	"GROUP_CONCAT",
	"SEPARATOR",
	"MATCH",
	"AGAINST",
	"BOOLEAN",
	"LANGUAGE",
	"WITH",
	"QUERY",
	"EXPANSION",
	"UNUSED",
	"';'",
}
var yyStatenames = [...]string{}

const yyEofCode = 1
const yyErrCode = 2
const yyInitialStackSize = 16

//line yacctab:1
var yyExca = [...]int{
	-1, 1,
	1, -1,
	-2, 0,
	-1, 3,
	5, 27,
	-2, 4,
	-1, 36,
	150, 263,
	151, 263,
	-2, 253,
	-1, 238,
	109, 587,
	-2, 583,
	-1, 239,
	109, 588,
	-2, 584,
	-1, 308,
	80, 746,
	-2, 58,
	-1, 309,
	80, 707,
	-2, 59,
	-1, 314,
	80, 691,
	-2, 549,
	-1, 316,
	80, 728,
	-2, 551,
	-1, 575,
	52, 41,
	54, 41,
	-2, 43,
	-1, 708,
	109, 590,
	-2, 586,
	-1, 912,
	5, 28,
	-2, 395,
	-1, 937,
	5, 27,
	-2, 524,
	-1, 1161,
	5, 28,
	-2, 525,
	-1, 1205,
	5, 27,
	-2, 527,
	-1, 1267,
	5, 28,
	-2, 528,
}

const yyPrivate = 57344

const yyLast = 10949

var yyAct = [...]int{

	269, 47, 770, 854, 1258, 522, 646, 1069, 1216, 1097,
	810, 1070, 268, 521, 3, 243, 1167, 834, 998, 788,
	806, 217, 569, 1066, 809, 53, 848, 771, 956, 1043,
	743, 567, 313, 904, 989, 945, 211, 410, 585, 710,
	455, 940, 733, 1001, 820, 740, 461, 584, 47, 844,
	307, 556, 571, 767, 294, 759, 222, 467, 475, 886,
	241, 216, 299, 226, 52, 304, 1287, 1277, 1285, 1265,
	302, 1283, 855, 442, 1276, 1061, 1155, 414, 435, 1225,
	212, 213, 214, 215, 295, 871, 1103, 1104, 1105, 1091,
	230, 1092, 1093, 293, 1108, 1106, 586, 1264, 587, 870,
	181, 177, 178, 179, 57, 536, 1240, 488, 487, 497,
	498, 490, 491, 492, 493, 494, 495, 496, 489, 964,
	801, 499, 963, 802, 803, 965, 875, 245, 450, 59,
	60, 61, 62, 63, 980, 869, 827, 310, 675, 1179,
	423, 437, 1194, 439, 835, 676, 1144, 1142, 210, 1284,
	232, 446, 447, 1282, 1259, 1022, 768, 424, 417, 1217,
	1044, 1223, 174, 175, 175, 822, 654, 239, 436, 438,
	420, 645, 1219, 822, 789, 791, 955, 954, 953, 412,
	189, 176, 1245, 866, 863, 864, 1164, 862, 1030, 298,
	1046, 511, 512, 974, 441, 441, 441, 441, 76, 441,
	920, 1019, 186, 898, 682, 186, 441, 1021, 479, 180,
	430, 1112, 873, 876, 489, 807, 822, 499, 499, 881,
	679, 1026, 1048, 47, 1052, 742, 1047, 472, 1045, 186,
	186, 76, 1009, 1050, 474, 186, 464, 76, 508, 1218,
	1250, 510, 1049, 474, 411, 1122, 463, 868, 790, 434,
	473, 472, 943, 588, 1107, 1051, 1053, 821, 1224, 1222,
	1007, 1113, 1241, 835, 828, 821, 1063, 474, 520, 867,
	524, 525, 526, 527, 528, 529, 530, 531, 532, 760,
	535, 537, 537, 537, 537, 537, 537, 537, 537, 545,
	546, 547, 548, 1263, 760, 649, 927, 1025, 882, 1020,
	568, 1018, 685, 686, 1253, 978, 872, 469, 821, 416,
	1009, 717, 236, 819, 817, 1269, 1185, 818, 1184, 874,
	426, 427, 428, 453, 1008, 715, 716, 714, 465, 1013,
	1010, 1003, 1004, 1011, 1006, 1005, 993, 50, 1007, 992,
	824, 916, 186, 915, 186, 825, 1012, 713, 473, 472,
	186, 981, 1015, 700, 702, 703, 917, 186, 701, 473,
	472, 76, 76, 76, 76, 474, 76, 173, 509, 458,
	462, 582, 576, 76, 1270, 1251, 474, 473, 472, 310,
	1201, 418, 419, 734, 1065, 735, 480, 538, 539, 540,
	541, 542, 543, 544, 474, 895, 896, 897, 1182, 1130,
	76, 990, 1008, 1248, 473, 472, 1100, 1013, 1010, 1003,
	1004, 1011, 1006, 1005, 441, 1273, 454, 1209, 1256, 454,
	523, 474, 441, 1099, 1012, 1209, 454, 298, 292, 534,
	1002, 1209, 1210, 441, 441, 441, 441, 441, 441, 441,
	441, 1176, 1175, 1088, 454, 1163, 454, 441, 441, 487,
	497, 498, 490, 491, 492, 493, 494, 495, 496, 489,
	186, 1229, 499, 663, 1119, 1118, 267, 186, 186, 186,
	1115, 1116, 1228, 76, 1115, 1114, 1151, 454, 1109, 76,
	910, 454, 50, 975, 966, 687, 857, 553, 454, 941,
	661, 745, 454, 21, 736, 711, 660, 74, 497, 498,
	490, 491, 492, 493, 494, 495, 496, 489, 659, 650,
	499, 47, 708, 488, 487, 497, 498, 490, 491, 492,
	493, 494, 495, 496, 489, 524, 648, 499, 643, 689,
	312, 595, 594, 942, 432, 704, 415, 425, 747, 706,
	411, 1067, 579, 681, 941, 752, 755, 54, 745, 221,
	23, 761, 1159, 707, 299, 299, 299, 299, 299, 513,
	514, 515, 516, 517, 518, 519, 23, 553, 772, 568,
	1121, 792, 737, 738, 935, 553, 942, 936, 299, 680,
	1117, 76, 747, 580, 967, 578, 910, 186, 186, 76,
	757, 186, 764, 1204, 186, 473, 472, 50, 186, 23,
	76, 76, 76, 76, 76, 76, 76, 76, 773, 796,
	712, 776, 474, 50, 76, 76, 785, 552, 941, 186,
	795, 1033, 578, 697, 698, 793, 836, 837, 838, 794,
	922, 799, 798, 814, 76, 800, 910, 919, 186, 774,
	775, 553, 777, 581, 76, 683, 50, 1189, 829, 441,
	849, 441, 1082, 223, 970, 310, 946, 947, 647, 441,
	312, 312, 312, 312, 910, 312, 845, 840, 811, 850,
	839, 65, 312, 921, 852, 523, 1102, 952, 750, 751,
	918, 298, 298, 298, 298, 298, 1067, 76, 994, 846,
	847, 558, 561, 562, 563, 559, 298, 560, 564, 477,
	50, 946, 947, 949, 657, 298, 451, 695, 899, 492,
	493, 494, 495, 496, 489, 708, 951, 499, 186, 779,
	778, 186, 186, 186, 186, 186, 782, 711, 888, 780,
	887, 783, 883, 186, 781, 784, 186, 562, 563, 805,
	186, 227, 228, 1281, 1275, 186, 186, 1029, 1280, 76,
	468, 748, 749, 893, 900, 892, 707, 756, 456, 1157,
	985, 593, 76, 433, 466, 977, 1255, 1190, 938, 939,
	457, 763, 312, 765, 766, 1254, 1202, 971, 590, 859,
	656, 937, 258, 257, 260, 261, 262, 263, 688, 566,
	468, 259, 264, 218, 709, 1234, 299, 718, 719, 720,
	721, 722, 723, 724, 725, 726, 727, 728, 729, 730,
	731, 732, 950, 186, 926, 219, 76, 54, 76, 1233,
	968, 891, 186, 224, 225, 186, 76, 959, 1192, 890,
	942, 884, 885, 470, 462, 1242, 958, 1180, 960, 961,
	678, 56, 712, 58, 577, 744, 746, 51, 982, 983,
	1, 856, 997, 865, 441, 984, 1257, 986, 987, 988,
	1215, 762, 1096, 972, 973, 816, 808, 409, 830, 831,
	832, 833, 64, 1249, 815, 991, 1221, 1178, 823, 441,
	312, 979, 826, 811, 841, 842, 843, 1101, 312, 1252,
	976, 787, 600, 598, 599, 597, 911, 602, 1000, 312,
	312, 312, 312, 312, 312, 312, 312, 1014, 601, 596,
	197, 928, 305, 312, 312, 558, 561, 562, 563, 559,
	894, 560, 564, 298, 565, 589, 851, 471, 66, 999,
	1017, 1016, 861, 691, 1024, 1037, 674, 1072, 1068, 47,
	880, 1042, 449, 477, 199, 1036, 312, 1055, 507, 1071,
	1062, 772, 1073, 708, 1084, 1085, 1086, 772, 889, 1054,
	76, 962, 311, 186, 1074, 684, 1077, 909, 1076, 1078,
	460, 1232, 1035, 1191, 925, 533, 758, 76, 244, 699,
	1095, 256, 253, 924, 1089, 255, 739, 254, 690, 934,
	481, 242, 1094, 234, 1058, 297, 753, 753, 549, 557,
	555, 1090, 753, 1110, 1111, 490, 491, 492, 493, 494,
	495, 496, 489, 554, 948, 499, 944, 296, 1032, 753,
	76, 76, 1154, 76, 1239, 694, 25, 55, 901, 902,
	903, 229, 19, 18, 299, 17, 20, 16, 1123, 15,
	14, 811, 29, 811, 13, 12, 76, 11, 312, 186,
	186, 1125, 10, 9, 1128, 8, 7, 186, 6, 5,
	907, 312, 1153, 4, 908, 1133, 76, 220, 22, 2,
	0, 912, 913, 914, 1132, 1140, 0, 0, 1064, 0,
	923, 0, 0, 0, 0, 929, 0, 930, 931, 932,
	933, 0, 1158, 1079, 1080, 0, 0, 1081, 0, 1166,
	1083, 1169, 1170, 1171, 1035, 968, 76, 76, 0, 0,
	1172, 1174, 0, 0, 0, 312, 0, 312, 0, 0,
	0, 441, 0, 0, 0, 312, 0, 0, 0, 0,
	0, 0, 1181, 1188, 1183, 76, 0, 76, 76, 0,
	1187, 0, 0, 0, 0, 0, 0, 0, 0, 312,
	0, 0, 0, 0, 0, 0, 1193, 0, 0, 0,
	1072, 298, 186, 1206, 0, 0, 0, 0, 811, 0,
	76, 1203, 1071, 0, 0, 0, 1205, 1131, 0, 0,
	0, 0, 0, 76, 186, 0, 1220, 0, 0, 0,
	76, 1231, 1214, 0, 0, 999, 811, 0, 76, 0,
	0, 186, 1226, 0, 1227, 1072, 1230, 47, 0, 0,
	0, 0, 1243, 0, 0, 0, 1156, 1071, 1039, 1040,
	1244, 0, 0, 523, 1247, 0, 0, 0, 0, 0,
	0, 1056, 1057, 1041, 1059, 1060, 0, 0, 0, 459,
	1261, 0, 0, 0, 0, 1266, 0, 440, 0, 0,
	76, 0, 76, 76, 76, 186, 76, 0, 772, 957,
	0, 0, 76, 1271, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 184, 1278, 312, 209, 1279, 0,
	1087, 0, 0, 0, 0, 1286, 0, 0, 76, 76,
	76, 0, 0, 300, 0, 0, 0, 0, 0, 233,
	0, 184, 184, 0, 0, 0, 0, 184, 0, 1137,
	1138, 0, 1139, 0, 0, 1141, 0, 1143, 0, 995,
	312, 0, 312, 0, 0, 0, 0, 0, 183, 0,
	0, 76, 76, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 76, 312, 0, 0, 0, 0,
	0, 1135, 0, 0, 0, 0, 303, 76, 0, 0,
	1134, 413, 0, 1177, 0, 312, 0, 1136, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 76, 1145, 1146,
	1147, 0, 0, 1150, 1260, 523, 0, 312, 0, 0,
	0, 0, 0, 0, 0, 0, 1160, 1161, 1162, 195,
	1165, 0, 753, 0, 0, 1075, 957, 0, 753, 0,
	0, 0, 0, 76, 184, 0, 184, 0, 0, 0,
	0, 0, 184, 205, 0, 0, 0, 76, 0, 184,
	0, 0, 0, 0, 312, 0, 312, 1098, 0, 0,
	0, 0, 443, 444, 445, 0, 448, 0, 0, 0,
	0, 0, 0, 452, 0, 0, 0, 0, 0, 0,
	0, 1195, 1196, 0, 1197, 1198, 1199, 0, 421, 1124,
	422, 0, 0, 190, 0, 0, 429, 0, 1200, 192,
	0, 0, 1126, 431, 0, 0, 198, 194, 0, 1129,
	0, 0, 0, 1211, 1212, 1213, 0, 312, 0, 0,
	488, 487, 497, 498, 490, 491, 492, 493, 494, 495,
	496, 489, 0, 196, 499, 0, 200, 0, 0, 1235,
	1236, 1237, 1238, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 184, 0, 0, 0, 0, 0, 0, 184,
	573, 184, 0, 0, 191, 0, 905, 0, 0, 1168,
	0, 1168, 1168, 1168, 0, 1173, 0, 0, 0, 0,
	0, 312, 0, 1262, 454, 0, 0, 0, 1267, 0,
	0, 193, 1152, 201, 202, 203, 204, 208, 1148, 454,
	0, 1272, 207, 206, 0, 0, 551, 312, 312, 312,
	0, 0, 0, 0, 0, 575, 0, 0, 0, 1288,
	488, 487, 497, 498, 490, 491, 492, 493, 494, 495,
	496, 489, 1290, 1291, 499, 488, 487, 497, 498, 490,
	491, 492, 493, 494, 495, 496, 489, 0, 0, 499,
	1207, 1208, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1098, 488, 487, 497, 498, 490, 491,
	492, 493, 494, 495, 496, 489, 1168, 0, 499, 184,
	184, 644, 0, 184, 0, 0, 184, 0, 0, 653,
	662, 0, 0, 0, 0, 0, 1246, 1038, 0, 0,
	664, 665, 666, 667, 668, 669, 670, 671, 0, 0,
	0, 184, 0, 0, 672, 673, 0, 488, 487, 497,
	498, 490, 491, 492, 493, 494, 495, 496, 489, 753,
	184, 499, 1268, 651, 652, 0, 0, 655, 0, 662,
	658, 0, 0, 0, 0, 0, 1274, 0, 0, 23,
	24, 48, 26, 27, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 677, 0, 1149, 42, 0,
	0, 0, 0, 28, 0, 0, 0, 0, 0, 0,
	233, 0, 0, 0, 696, 233, 233, 0, 0, 754,
	754, 233, 37, 0, 0, 754, 50, 0, 0, 0,
	0, 0, 0, 0, 0, 233, 233, 233, 233, 0,
	184, 0, 754, 184, 184, 184, 184, 184, 0, 0,
	0, 0, 0, 0, 0, 786, 0, 0, 184, 0,
	0, 0, 573, 0, 0, 0, 0, 184, 184, 488,
	487, 497, 498, 490, 491, 492, 493, 494, 495, 496,
	489, 0, 0, 499, 0, 30, 31, 33, 32, 35,
	0, 0, 0, 0, 769, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 36, 43, 44, 0,
	0, 45, 46, 34, 0, 0, 0, 0, 0, 0,
	0, 0, 797, 0, 0, 38, 39, 0, 40, 41,
	0, 0, 0, 0, 0, 184, 617, 0, 0, 0,
	0, 483, 0, 486, 184, 0, 858, 184, 860, 500,
	501, 502, 503, 504, 505, 506, 879, 484, 485, 482,
	488, 487, 497, 498, 490, 491, 492, 493, 494, 495,
	496, 489, 662, 0, 499, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 233, 0, 0, 0, 0, 853,
	0, 0, 0, 906, 0, 0, 0, 0, 877, 0,
	0, 878, 0, 0, 0, 0, 0, 0, 49, 0,
	0, 0, 605, 488, 487, 497, 498, 490, 491, 492,
	493, 494, 495, 496, 489, 0, 0, 499, 0, 0,
	0, 233, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 618, 0, 0, 0, 0, 233, 488, 487,
	497, 498, 490, 491, 492, 493, 494, 495, 496, 489,
	0, 0, 499, 631, 632, 633, 634, 635, 636, 637,
	0, 638, 639, 640, 641, 642, 619, 620, 621, 622,
	603, 604, 0, 0, 606, 184, 607, 608, 609, 610,
	611, 612, 613, 614, 615, 616, 623, 624, 625, 626,
	627, 628, 629, 630, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 996, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1027, 1028, 0, 0, 0, 1023, 0, 0, 184,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 233,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	233, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	662, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 754, 0, 0, 0, 0,
	0, 754, 0, 1031, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 184, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 184, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 184, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1120, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1127, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 573, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1186, 0,
	0, 398, 388, 0, 360, 400, 338, 352, 408, 353,
	354, 381, 324, 368, 125, 350, 0, 341, 319, 347,
	320, 339, 362, 93, 365, 337, 390, 371, 107, 406,
	109, 376, 0, 142, 118, 0, 0, 364, 392, 366,
	386, 359, 382, 329, 375, 401, 351, 379, 402, 0,
	0, 0, 75, 0, 812, 813, 0, 0, 0, 0,
	0, 86, 0, 378, 397, 349, 380, 318, 377, 0,
	322, 325, 407, 395, 344, 345, 969, 0, 0, 0,
	0, 0, 0, 363, 367, 383, 357, 0, 0, 0,
	0, 0, 0, 0, 0, 342, 0, 374, 0, 0,
	0, 326, 323, 0, 361, 0, 0, 0, 328, 0,
	343, 384, 754, 317, 387, 393, 358, 187, 396, 356,
	355, 399, 131, 0, 0, 145, 98, 97, 106, 391,
	340, 348, 89, 346, 137, 127, 157, 373, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	155, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 84, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 321, 0, 143, 159, 172,
	336, 394, 165, 166, 167, 168, 0, 0, 0, 122,
	85, 101, 140, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 332, 335, 330, 331, 369, 370, 403, 404,
	405, 385, 327, 0, 333, 334, 0, 389, 372, 77,
	0, 108, 169, 133, 95, 160, 398, 388, 0, 360,
	400, 338, 352, 408, 353, 354, 381, 324, 368, 125,
	350, 0, 341, 319, 347, 320, 339, 362, 93, 365,
	337, 390, 371, 107, 406, 109, 376, 0, 142, 118,
	0, 0, 364, 392, 366, 386, 359, 382, 329, 375,
	401, 351, 379, 402, 0, 0, 0, 75, 0, 812,
	813, 0, 0, 0, 0, 0, 86, 0, 378, 397,
	349, 380, 318, 377, 0, 322, 325, 407, 395, 344,
	345, 0, 0, 0, 0, 0, 0, 0, 363, 367,
	383, 357, 0, 0, 0, 0, 0, 0, 0, 0,
	342, 0, 374, 0, 0, 0, 326, 323, 0, 361,
	0, 0, 0, 328, 0, 343, 384, 0, 317, 387,
	393, 358, 187, 396, 356, 355, 399, 131, 0, 0,
	145, 98, 97, 106, 391, 340, 348, 89, 346, 137,
	127, 157, 373, 128, 136, 110, 149, 132, 156, 188,
	164, 147, 163, 78, 146, 155, 87, 139, 80, 153,
	144, 116, 102, 103, 79, 0, 135, 92, 96, 91,
	124, 150, 151, 90, 171, 83, 162, 82, 84, 161,
	123, 148, 154, 117, 114, 81, 152, 115, 113, 105,
	94, 99, 129, 112, 130, 100, 120, 119, 121, 0,
	321, 0, 143, 159, 172, 336, 394, 165, 166, 167,
	168, 0, 0, 0, 122, 85, 101, 140, 104, 111,
	134, 170, 126, 138, 88, 158, 141, 332, 335, 330,
	331, 369, 370, 403, 404, 405, 385, 327, 0, 333,
	334, 0, 389, 372, 77, 0, 108, 169, 133, 95,
	160, 398, 388, 0, 360, 400, 338, 352, 408, 353,
	354, 381, 324, 368, 125, 350, 0, 341, 319, 347,
	320, 339, 362, 93, 365, 337, 390, 371, 107, 406,
	109, 376, 0, 142, 118, 0, 0, 364, 392, 366,
	386, 359, 382, 329, 375, 401, 351, 379, 402, 50,
	0, 0, 75, 0, 0, 0, 0, 0, 0, 0,
	0, 86, 0, 378, 397, 349, 380, 318, 377, 0,
	322, 325, 407, 395, 344, 345, 0, 0, 0, 0,
	0, 0, 0, 363, 367, 383, 357, 0, 0, 0,
	0, 0, 0, 0, 0, 342, 0, 374, 0, 0,
	0, 326, 323, 0, 361, 0, 0, 0, 328, 0,
	343, 384, 0, 317, 387, 393, 358, 187, 396, 356,
	355, 399, 131, 0, 0, 145, 98, 97, 106, 391,
	340, 348, 89, 346, 137, 127, 157, 373, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	155, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 84, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 321, 0, 143, 159, 172,
	336, 394, 165, 166, 167, 168, 0, 0, 0, 122,
	85, 101, 140, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 332, 335, 330, 331, 369, 370, 403, 404,
	405, 385, 327, 0, 333, 334, 0, 389, 372, 77,
	0, 108, 169, 133, 95, 160, 398, 388, 0, 360,
	400, 338, 352, 408, 353, 354, 381, 324, 368, 125,
	350, 0, 341, 319, 347, 320, 339, 362, 93, 365,
	337, 390, 371, 107, 406, 109, 376, 0, 142, 118,
	0, 0, 364, 392, 366, 386, 359, 382, 329, 375,
	401, 351, 379, 402, 0, 0, 0, 75, 0, 0,
	0, 0, 0, 0, 0, 0, 86, 0, 378, 397,
	349, 380, 318, 377, 0, 322, 325, 407, 395, 344,
	345, 0, 0, 0, 0, 0, 0, 0, 363, 367,
	383, 357, 0, 0, 0, 0, 0, 0, 1034, 0,
	342, 0, 374, 0, 0, 0, 326, 323, 0, 361,
	0, 0, 0, 328, 0, 343, 384, 0, 317, 387,
	393, 358, 187, 396, 356, 355, 399, 131, 0, 0,
	145, 98, 97, 106, 391, 340, 348, 89, 346, 137,
	127, 157, 373, 128, 136, 110, 149, 132, 156, 188,
	164, 147, 163, 78, 146, 155, 87, 139, 80, 153,
	144, 116, 102, 103, 79, 0, 135, 92, 96, 91,
	124, 150, 151, 90, 171, 83, 162, 82, 84, 161,
	123, 148, 154, 117, 114, 81, 152, 115, 113, 105,
	94, 99, 129, 112, 130, 100, 120, 119, 121, 0,
	321, 0, 143, 159, 172, 336, 394, 165, 166, 167,
	168, 0, 0, 0, 122, 85, 101, 140, 104, 111,
	134, 170, 126, 138, 88, 158, 141, 332, 335, 330,
	331, 369, 370, 403, 404, 405, 385, 327, 0, 333,
	334, 0, 389, 372, 77, 0, 108, 169, 133, 95,
	160, 398, 388, 0, 360, 400, 338, 352, 408, 353,
	354, 381, 324, 368, 125, 350, 0, 341, 319, 347,
	320, 339, 362, 93, 365, 337, 390, 371, 107, 406,
	109, 376, 0, 142, 118, 0, 0, 364, 392, 366,
	386, 359, 382, 329, 375, 401, 351, 379, 402, 0,
	0, 0, 238, 0, 0, 0, 0, 0, 0, 0,
	0, 86, 0, 378, 397, 349, 380, 318, 377, 0,
	322, 325, 407, 395, 344, 345, 0, 0, 0, 0,
	0, 0, 0, 363, 367, 383, 357, 0, 0, 0,
	0, 0, 0, 705, 0, 342, 0, 374, 0, 0,
	0, 326, 323, 0, 361, 0, 0, 0, 328, 0,
	343, 384, 0, 317, 387, 393, 358, 187, 396, 356,
	355, 399, 131, 0, 0, 145, 98, 97, 106, 391,
	340, 348, 89, 346, 137, 127, 157, 373, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	155, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 84, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 321, 0, 143, 159, 172,
	336, 394, 165, 166, 167, 168, 0, 0, 0, 122,
	85, 101, 140, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 332, 335, 330, 331, 369, 370, 403, 404,
	405, 385, 327, 0, 333, 334, 0, 389, 372, 77,
	0, 108, 169, 133, 95, 160, 398, 388, 0, 360,
	400, 338, 352, 408, 353, 354, 381, 324, 368, 125,
	350, 0, 341, 319, 347, 320, 339, 362, 93, 365,
	337, 390, 371, 107, 406, 109, 376, 0, 142, 118,
	0, 0, 364, 392, 366, 386, 359, 382, 329, 375,
	401, 351, 379, 402, 0, 0, 0, 75, 0, 0,
	0, 0, 0, 0, 0, 0, 86, 0, 378, 397,
	349, 380, 318, 377, 0, 322, 325, 407, 395, 344,
	345, 0, 0, 0, 0, 0, 0, 0, 363, 367,
	383, 357, 0, 0, 0, 0, 0, 0, 0, 0,
	342, 0, 374, 0, 0, 0, 326, 323, 0, 361,
	0, 0, 0, 328, 0, 343, 384, 0, 317, 387,
	393, 358, 187, 396, 356, 355, 399, 131, 0, 0,
	145, 98, 97, 106, 391, 340, 348, 89, 346, 137,
	127, 157, 373, 128, 136, 110, 149, 132, 156, 188,
	164, 147, 163, 78, 146, 155, 87, 139, 80, 153,
	144, 116, 102, 103, 79, 0, 135, 92, 96, 91,
	124, 150, 151, 90, 171, 83, 162, 82, 84, 161,
	123, 148, 154, 117, 114, 81, 152, 115, 113, 105,
	94, 99, 129, 112, 130, 100, 120, 119, 121, 0,
	321, 0, 143, 159, 172, 336, 394, 165, 166, 167,
	168, 0, 0, 0, 122, 85, 101, 140, 104, 111,
	134, 170, 126, 138, 88, 158, 141, 332, 335, 330,
	331, 369, 370, 403, 404, 405, 385, 327, 0, 333,
	334, 0, 389, 372, 77, 0, 108, 169, 133, 95,
	160, 398, 388, 0, 360, 400, 338, 352, 408, 353,
	354, 381, 324, 368, 125, 350, 0, 341, 319, 347,
	320, 339, 362, 93, 365, 337, 390, 371, 107, 406,
	109, 376, 0, 142, 118, 0, 0, 364, 392, 366,
	386, 359, 382, 329, 375, 401, 351, 379, 402, 0,
	0, 0, 238, 0, 0, 0, 0, 0, 0, 0,
	0, 86, 0, 378, 397, 349, 380, 318, 377, 0,
	322, 325, 407, 395, 344, 345, 0, 0, 0, 0,
	0, 0, 0, 363, 367, 383, 357, 0, 0, 0,
	0, 0, 0, 0, 0, 342, 0, 374, 0, 0,
	0, 326, 323, 0, 361, 0, 0, 0, 328, 0,
	343, 384, 0, 317, 387, 393, 358, 187, 396, 356,
	355, 399, 131, 0, 0, 145, 98, 97, 106, 391,
	340, 348, 89, 346, 137, 127, 157, 373, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	155, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 84, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 321, 0, 143, 159, 172,
	336, 394, 165, 166, 167, 168, 0, 0, 0, 122,
	85, 101, 140, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 332, 335, 330, 331, 369, 370, 403, 404,
	405, 385, 327, 0, 333, 334, 0, 389, 372, 77,
	0, 108, 169, 133, 95, 160, 398, 388, 0, 360,
	400, 338, 352, 408, 353, 354, 381, 324, 368, 125,
	350, 0, 341, 319, 347, 320, 339, 362, 93, 365,
	337, 390, 371, 107, 406, 109, 376, 0, 142, 118,
	0, 0, 364, 392, 366, 386, 359, 382, 329, 375,
	401, 351, 379, 402, 0, 0, 0, 75, 0, 0,
	0, 0, 0, 0, 0, 0, 86, 0, 378, 397,
	349, 380, 318, 377, 0, 322, 325, 407, 395, 344,
	345, 0, 0, 0, 0, 0, 0, 0, 363, 367,
	383, 357, 0, 0, 0, 0, 0, 0, 0, 0,
	342, 0, 374, 0, 0, 0, 326, 323, 0, 361,
	0, 0, 0, 328, 0, 343, 384, 0, 317, 387,
	393, 358, 187, 396, 356, 355, 399, 131, 0, 0,
	145, 98, 97, 106, 391, 340, 348, 89, 346, 137,
	127, 157, 373, 128, 136, 110, 149, 132, 156, 188,
	164, 147, 163, 78, 146, 155, 87, 139, 80, 153,
	144, 116, 102, 103, 79, 0, 135, 92, 96, 91,
	124, 150, 151, 90, 171, 83, 162, 82, 315, 161,
	123, 148, 154, 117, 114, 81, 152, 115, 113, 105,
	94, 99, 129, 112, 130, 100, 120, 119, 121, 0,
	321, 0, 143, 159, 172, 336, 394, 165, 166, 167,
	168, 0, 0, 0, 316, 314, 101, 140, 104, 111,
	134, 170, 126, 138, 88, 158, 141, 332, 335, 330,
	331, 369, 370, 403, 404, 405, 385, 327, 0, 333,
	334, 0, 389, 372, 77, 0, 108, 169, 133, 95,
	160, 398, 388, 0, 360, 400, 338, 352, 408, 353,
	354, 381, 324, 368, 125, 350, 0, 341, 319, 347,
	320, 339, 362, 93, 365, 337, 390, 371, 107, 406,
	109, 376, 0, 142, 118, 0, 0, 364, 392, 366,
	386, 359, 382, 329, 375, 401, 351, 379, 402, 0,
	0, 0, 185, 0, 0, 0, 0, 0, 0, 0,
	0, 86, 0, 378, 397, 349, 380, 318, 377, 0,
	322, 325, 407, 395, 344, 345, 0, 0, 0, 0,
	0, 0, 0, 363, 367, 383, 357, 0, 0, 0,
	0, 0, 0, 0, 0, 342, 0, 374, 0, 0,
	0, 326, 323, 0, 361, 0, 0, 0, 328, 0,
	343, 384, 0, 317, 387, 393, 358, 187, 396, 356,
	355, 399, 131, 0, 0, 145, 98, 97, 106, 391,
	340, 348, 89, 346, 137, 127, 157, 373, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	155, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 84, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 321, 0, 143, 159, 172,
	336, 394, 165, 166, 167, 168, 0, 0, 0, 122,
	85, 101, 140, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 332, 335, 330, 331, 369, 370, 403, 404,
	405, 385, 327, 0, 333, 334, 0, 389, 372, 77,
	0, 108, 169, 133, 95, 160, 398, 388, 0, 360,
	400, 338, 352, 408, 353, 354, 381, 324, 368, 125,
	350, 0, 341, 319, 347, 320, 339, 362, 93, 365,
	337, 390, 371, 107, 406, 109, 376, 0, 142, 118,
	0, 0, 364, 392, 366, 386, 359, 382, 329, 375,
	401, 351, 379, 402, 0, 0, 0, 75, 0, 0,
	0, 0, 0, 0, 0, 0, 86, 0, 378, 397,
	349, 380, 318, 377, 0, 322, 325, 407, 395, 344,
	345, 0, 0, 0, 0, 0, 0, 0, 363, 367,
	383, 357, 0, 0, 0, 0, 0, 0, 0, 0,
	342, 0, 374, 0, 0, 0, 326, 323, 0, 361,
	0, 0, 0, 328, 0, 343, 384, 0, 317, 387,
	393, 358, 187, 396, 356, 355, 399, 131, 0, 0,
	145, 98, 97, 106, 391, 340, 348, 89, 346, 137,
	127, 157, 373, 128, 136, 110, 149, 132, 156, 188,
	164, 147, 163, 78, 146, 583, 87, 139, 80, 153,
	144, 116, 102, 103, 79, 0, 135, 92, 96, 91,
	124, 150, 151, 90, 171, 83, 162, 82, 315, 161,
	123, 148, 154, 117, 114, 81, 152, 115, 113, 105,
	94, 99, 129, 112, 130, 100, 120, 119, 121, 0,
	321, 0, 143, 159, 172, 336, 394, 165, 166, 167,
	168, 0, 0, 0, 316, 314, 101, 140, 104, 111,
	134, 170, 126, 138, 88, 158, 141, 332, 335, 330,
	331, 369, 370, 403, 404, 405, 385, 327, 0, 333,
	334, 0, 389, 372, 77, 0, 108, 169, 133, 95,
	160, 398, 388, 0, 360, 400, 338, 352, 408, 353,
	354, 381, 324, 368, 125, 350, 0, 341, 319, 347,
	320, 339, 362, 93, 365, 337, 390, 371, 107, 406,
	109, 376, 0, 142, 118, 0, 0, 364, 392, 366,
	386, 359, 382, 329, 375, 401, 351, 379, 402, 0,
	0, 0, 75, 0, 0, 0, 0, 0, 0, 0,
	0, 86, 0, 378, 397, 349, 380, 318, 377, 0,
	322, 325, 407, 395, 344, 345, 0, 0, 0, 0,
	0, 0, 0, 363, 367, 383, 357, 0, 0, 0,
	0, 0, 0, 0, 0, 342, 0, 374, 0, 0,
	0, 326, 323, 0, 361, 0, 0, 0, 328, 0,
	343, 384, 0, 317, 387, 393, 358, 187, 396, 356,
	355, 399, 131, 0, 0, 145, 98, 97, 106, 391,
	340, 348, 89, 346, 137, 127, 157, 373, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	306, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 315, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 321, 0, 143, 159, 172,
	336, 394, 165, 166, 167, 168, 0, 0, 0, 316,
	314, 309, 308, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 332, 335, 330, 331, 369, 370, 403, 404,
	405, 385, 327, 0, 333, 334, 0, 389, 372, 77,
	0, 108, 169, 133, 95, 160, 125, 0, 0, 741,
	0, 240, 0, 0, 0, 93, 0, 237, 0, 0,
	107, 279, 109, 0, 0, 142, 118, 0, 0, 0,
	0, 270, 271, 0, 0, 0, 0, 0, 0, 0,
	0, 50, 0, 0, 238, 258, 257, 260, 261, 262,
	263, 0, 0, 86, 259, 264, 265, 266, 0, 0,
	235, 251, 0, 278, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 248, 249, 231, 0, 0, 0, 290,
	0, 250, 0, 0, 246, 247, 252, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 187,
	0, 0, 288, 0, 131, 0, 0, 145, 98, 97,
	106, 0, 0, 0, 89, 0, 137, 127, 157, 0,
	128, 136, 110, 149, 132, 156, 188, 164, 147, 163,
	78, 146, 155, 87, 139, 80, 153, 144, 116, 102,
	103, 79, 0, 135, 92, 96, 91, 124, 150, 151,
	90, 171, 83, 162, 82, 84, 161, 123, 148, 154,
	117, 114, 81, 152, 115, 113, 105, 94, 99, 129,
	112, 130, 100, 120, 119, 121, 0, 0, 0, 143,
	159, 172, 0, 0, 165, 166, 167, 168, 0, 0,
	0, 122, 85, 101, 140, 104, 111, 134, 170, 126,
	138, 88, 158, 141, 280, 289, 286, 287, 284, 285,
	283, 282, 281, 291, 272, 273, 274, 275, 277, 0,
	276, 77, 0, 108, 169, 133, 95, 160, 125, 0,
	0, 0, 0, 240, 0, 0, 0, 93, 0, 237,
	0, 0, 107, 279, 109, 0, 0, 142, 118, 0,
	0, 0, 0, 270, 271, 0, 0, 0, 0, 0,
	0, 0, 0, 50, 0, 454, 238, 258, 257, 260,
	261, 262, 263, 0, 0, 86, 259, 264, 265, 266,
	0, 0, 235, 251, 0, 278, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 248, 249, 0, 0, 0,
	0, 290, 0, 250, 0, 0, 246, 247, 252, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 187, 0, 0, 288, 0, 131, 0, 0, 145,
	98, 97, 106, 0, 0, 0, 89, 0, 137, 127,
	157, 0, 128, 136, 110, 149, 132, 156, 188, 164,
	147, 163, 78, 146, 155, 87, 139, 80, 153, 144,
	116, 102, 103, 79, 0, 135, 92, 96, 91, 124,
	150, 151, 90, 171, 83, 162, 82, 84, 161, 123,
	148, 154, 117, 114, 81, 152, 115, 113, 105, 94,
	99, 129, 112, 130, 100, 120, 119, 121, 0, 0,
	0, 143, 159, 172, 0, 0, 165, 166, 167, 168,
	0, 0, 0, 122, 85, 101, 140, 104, 111, 134,
	170, 126, 138, 88, 158, 141, 280, 289, 286, 287,
	284, 285, 283, 282, 281, 291, 272, 273, 274, 275,
	277, 0, 276, 77, 0, 108, 169, 133, 95, 160,
	125, 0, 0, 0, 0, 240, 0, 0, 0, 93,
	0, 237, 0, 0, 107, 279, 109, 0, 0, 142,
	118, 0, 0, 0, 0, 270, 271, 0, 0, 0,
	0, 0, 0, 0, 0, 50, 0, 0, 238, 258,
	257, 260, 261, 262, 263, 0, 0, 86, 259, 264,
	265, 266, 0, 0, 235, 251, 0, 278, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 248, 249, 231,
	0, 0, 0, 290, 0, 250, 0, 0, 246, 247,
	252, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 187, 0, 0, 288, 0, 131, 0,
	0, 145, 98, 97, 106, 0, 0, 0, 89, 0,
	137, 127, 157, 0, 128, 136, 110, 149, 132, 156,
	188, 164, 147, 163, 78, 146, 155, 87, 139, 80,
	153, 144, 116, 102, 103, 79, 0, 135, 92, 96,
	91, 124, 150, 151, 90, 171, 83, 162, 82, 84,
	161, 123, 148, 154, 117, 114, 81, 152, 115, 113,
	105, 94, 99, 129, 112, 130, 100, 120, 119, 121,
	0, 0, 0, 143, 159, 172, 0, 0, 165, 166,
	167, 168, 0, 0, 0, 122, 85, 101, 140, 104,
	111, 134, 170, 126, 138, 88, 158, 141, 280, 289,
	286, 287, 284, 285, 283, 282, 281, 291, 272, 273,
	274, 275, 277, 0, 276, 77, 0, 108, 169, 133,
	95, 160, 125, 0, 0, 0, 0, 240, 0, 0,
	0, 93, 0, 237, 0, 0, 107, 279, 109, 0,
	0, 142, 118, 0, 0, 0, 0, 270, 271, 0,
	0, 0, 0, 0, 0, 804, 0, 50, 0, 0,
	238, 258, 257, 260, 261, 262, 263, 0, 0, 86,
	259, 264, 265, 266, 0, 0, 235, 251, 0, 278,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 248,
	249, 0, 0, 0, 0, 290, 0, 250, 0, 0,
	246, 247, 252, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 187, 0, 0, 288, 0,
	131, 0, 0, 145, 98, 97, 106, 0, 0, 0,
	89, 0, 137, 127, 157, 0, 128, 136, 110, 149,
	132, 156, 188, 164, 147, 163, 78, 146, 155, 87,
	139, 80, 153, 144, 116, 102, 103, 79, 0, 135,
	92, 96, 91, 124, 150, 151, 90, 171, 83, 162,
	82, 84, 161, 123, 148, 154, 117, 114, 81, 152,
	115, 113, 105, 94, 99, 129, 112, 130, 100, 120,
	119, 121, 0, 0, 0, 143, 159, 172, 0, 0,
	165, 166, 167, 168, 0, 0, 0, 122, 85, 101,
	140, 104, 111, 134, 170, 126, 138, 88, 158, 141,
	280, 289, 286, 287, 284, 285, 283, 282, 281, 291,
	272, 273, 274, 275, 277, 23, 276, 77, 0, 108,
	169, 133, 95, 160, 0, 0, 0, 125, 0, 0,
	0, 0, 240, 0, 0, 0, 93, 0, 237, 0,
	0, 107, 279, 109, 0, 0, 142, 118, 0, 0,
	0, 0, 270, 271, 0, 0, 0, 0, 0, 0,
	0, 0, 50, 0, 0, 238, 258, 257, 260, 261,
	262, 263, 0, 0, 86, 259, 264, 265, 266, 0,
	0, 235, 251, 0, 278, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 248, 249, 0, 0, 0, 0,
	290, 0, 250, 0, 0, 246, 247, 252, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	187, 0, 0, 288, 0, 131, 0, 0, 145, 98,
	97, 106, 0, 0, 0, 89, 0, 137, 127, 157,
	0, 128, 136, 110, 149, 132, 156, 188, 164, 147,
	163, 78, 146, 155, 87, 139, 80, 153, 144, 116,
	102, 103, 79, 0, 135, 92, 96, 91, 124, 150,
	151, 90, 171, 83, 162, 82, 84, 161, 123, 148,
	154, 117, 114, 81, 152, 115, 113, 105, 94, 99,
	129, 112, 130, 100, 120, 119, 121, 0, 0, 0,
	143, 159, 172, 0, 0, 165, 166, 167, 168, 0,
	0, 0, 122, 85, 101, 140, 104, 111, 134, 170,
	126, 138, 88, 158, 141, 280, 289, 286, 287, 284,
	285, 283, 282, 281, 291, 272, 273, 274, 275, 277,
	0, 276, 77, 0, 108, 169, 133, 95, 160, 125,
	0, 0, 0, 0, 240, 0, 0, 0, 93, 0,
	237, 0, 0, 107, 279, 109, 0, 0, 142, 118,
	0, 0, 0, 0, 270, 271, 0, 0, 0, 0,
	0, 0, 0, 0, 50, 0, 0, 238, 258, 257,
	260, 261, 262, 263, 0, 0, 86, 259, 264, 265,
	266, 0, 0, 235, 251, 0, 278, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 248, 249, 0, 0,
	0, 0, 290, 0, 250, 0, 0, 246, 247, 252,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 187, 0, 0, 288, 0, 131, 0, 0,
	145, 98, 97, 106, 0, 0, 0, 89, 0, 137,
	127, 157, 0, 128, 136, 110, 149, 132, 156, 188,
	164, 147, 163, 78, 146, 155, 87, 139, 80, 153,
	144, 116, 102, 103, 79, 0, 135, 92, 96, 91,
	124, 150, 151, 90, 171, 83, 162, 82, 84, 161,
	123, 148, 154, 117, 114, 81, 152, 115, 113, 105,
	94, 99, 129, 112, 130, 100, 120, 119, 121, 0,
	0, 0, 143, 159, 172, 0, 0, 165, 166, 167,
	168, 0, 0, 0, 122, 85, 101, 140, 104, 111,
	134, 170, 126, 138, 88, 158, 141, 280, 289, 286,
	287, 284, 285, 283, 282, 281, 291, 272, 273, 274,
	275, 277, 125, 276, 77, 0, 108, 169, 133, 95,
	160, 93, 0, 0, 0, 0, 107, 279, 109, 0,
	0, 142, 118, 0, 0, 0, 0, 270, 271, 0,
	0, 0, 0, 0, 0, 0, 0, 50, 0, 0,
	238, 258, 257, 260, 261, 262, 263, 0, 0, 86,
	259, 264, 265, 266, 0, 0, 0, 251, 0, 278,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 248,
	249, 0, 0, 0, 0, 290, 0, 250, 0, 0,
	246, 247, 252, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 187, 0, 0, 288, 0,
	131, 0, 0, 145, 98, 97, 106, 0, 0, 0,
	89, 0, 137, 127, 157, 1289, 128, 136, 110, 149,
	132, 156, 188, 164, 147, 163, 78, 146, 155, 87,
	139, 80, 153, 144, 116, 102, 103, 79, 0, 135,
	92, 96, 91, 124, 150, 151, 90, 171, 83, 162,
	82, 84, 161, 123, 148, 154, 117, 114, 81, 152,
	115, 113, 105, 94, 99, 129, 112, 130, 100, 120,
	119, 121, 0, 0, 0, 143, 159, 172, 0, 0,
	165, 166, 167, 168, 0, 0, 0, 122, 85, 101,
	140, 104, 111, 134, 170, 126, 138, 88, 158, 141,
	280, 289, 286, 287, 284, 285, 283, 282, 281, 291,
	272, 273, 274, 275, 277, 125, 276, 77, 0, 108,
	169, 133, 95, 160, 93, 0, 0, 0, 0, 107,
	279, 109, 0, 0, 142, 118, 0, 0, 0, 0,
	270, 271, 0, 0, 0, 0, 0, 0, 0, 0,
	50, 0, 0, 238, 258, 257, 260, 261, 262, 263,
	0, 0, 86, 259, 264, 265, 266, 0, 0, 0,
	251, 0, 278, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 248, 249, 0, 0, 0, 0, 290, 0,
	250, 0, 0, 246, 247, 252, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 187, 0,
	0, 288, 0, 131, 0, 0, 145, 98, 97, 106,
	0, 0, 0, 89, 0, 137, 127, 157, 0, 128,
	136, 110, 149, 132, 156, 188, 164, 147, 163, 78,
	146, 155, 87, 139, 80, 153, 144, 116, 102, 103,
	79, 0, 135, 92, 96, 91, 124, 150, 151, 90,
	171, 83, 162, 82, 84, 161, 123, 148, 154, 117,
	114, 81, 152, 115, 113, 105, 94, 99, 129, 112,
	130, 100, 120, 119, 121, 0, 0, 0, 143, 159,
	172, 0, 0, 165, 166, 167, 168, 0, 0, 0,
	122, 85, 101, 140, 104, 111, 134, 170, 126, 138,
	88, 158, 141, 280, 289, 286, 287, 284, 285, 283,
	282, 281, 291, 272, 273, 274, 275, 277, 125, 276,
	77, 0, 108, 169, 133, 95, 160, 93, 0, 0,
	0, 0, 107, 0, 109, 0, 0, 142, 118, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 75, 0, 0, 0,
	0, 0, 0, 0, 0, 86, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 488, 487, 497, 498, 490, 491, 492, 493, 494,
	495, 496, 489, 0, 0, 499, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 187, 0, 0, 0, 0, 131, 0, 0, 145,
	98, 97, 106, 0, 0, 0, 89, 0, 137, 127,
	157, 0, 128, 136, 110, 149, 132, 156, 188, 164,
	147, 163, 78, 146, 155, 87, 139, 80, 153, 144,
	116, 102, 103, 79, 0, 135, 92, 96, 91, 124,
	150, 151, 90, 171, 83, 162, 82, 84, 161, 123,
	148, 154, 117, 114, 81, 152, 115, 113, 105, 94,
	99, 129, 112, 130, 100, 120, 119, 121, 0, 0,
	0, 143, 159, 172, 0, 0, 165, 166, 167, 168,
	0, 0, 0, 122, 85, 101, 140, 104, 111, 134,
	170, 126, 138, 88, 158, 141, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 77, 0, 108, 169, 133, 95, 160,
	125, 0, 0, 0, 476, 0, 0, 0, 0, 93,
	0, 0, 0, 0, 107, 0, 109, 0, 0, 142,
	118, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 75, 0,
	478, 0, 0, 0, 0, 0, 0, 86, 0, 0,
	0, 0, 473, 472, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 474,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 187, 0, 0, 0, 0, 131, 0,
	0, 145, 98, 97, 106, 0, 0, 0, 89, 0,
	137, 127, 157, 0, 128, 136, 110, 149, 132, 156,
	188, 164, 147, 163, 78, 146, 155, 87, 139, 80,
	153, 144, 116, 102, 103, 79, 0, 135, 92, 96,
	91, 124, 150, 151, 90, 171, 83, 162, 82, 84,
	161, 123, 148, 154, 117, 114, 81, 152, 115, 113,
	105, 94, 99, 129, 112, 130, 100, 120, 119, 121,
	0, 0, 0, 143, 159, 172, 0, 0, 165, 166,
	167, 168, 0, 0, 0, 122, 85, 101, 140, 104,
	111, 134, 170, 126, 138, 88, 158, 141, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 125, 0, 77, 0, 108, 169, 133,
	95, 160, 93, 0, 0, 0, 0, 107, 0, 109,
	0, 0, 142, 118, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 75, 0, 0, 0, 0, 0, 0, 0, 0,
	86, 0, 0, 0, 0, 68, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 71, 72, 0, 67, 0, 0, 0,
	73, 131, 0, 0, 145, 98, 97, 106, 0, 0,
	0, 89, 0, 137, 127, 157, 0, 128, 136, 110,
	149, 132, 156, 69, 164, 147, 163, 78, 146, 155,
	87, 139, 80, 153, 144, 116, 102, 103, 79, 0,
	135, 92, 96, 91, 124, 150, 151, 90, 171, 83,
	162, 82, 84, 161, 123, 148, 154, 117, 114, 81,
	152, 115, 113, 105, 94, 99, 129, 112, 130, 100,
	120, 119, 121, 0, 0, 0, 143, 159, 172, 0,
	0, 165, 166, 167, 168, 0, 0, 0, 122, 85,
	101, 140, 104, 111, 134, 170, 126, 138, 88, 158,
	141, 0, 70, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 77, 0,
	108, 169, 133, 95, 160, 125, 0, 0, 0, 572,
	0, 0, 0, 0, 93, 0, 0, 0, 0, 107,
	0, 109, 0, 0, 142, 118, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 185, 0, 574, 0, 0, 0, 0,
	0, 0, 86, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 187, 0,
	0, 0, 0, 131, 0, 0, 145, 98, 97, 106,
	0, 0, 0, 89, 0, 137, 127, 157, 0, 128,
	136, 110, 149, 132, 156, 188, 164, 147, 163, 78,
	146, 155, 87, 139, 80, 153, 144, 116, 102, 103,
	79, 0, 135, 92, 96, 91, 124, 150, 151, 90,
	171, 83, 162, 82, 84, 161, 123, 148, 154, 117,
	114, 81, 152, 115, 113, 105, 94, 99, 129, 112,
	130, 100, 120, 119, 121, 0, 0, 0, 143, 159,
	172, 0, 0, 165, 166, 167, 168, 0, 0, 0,
	122, 85, 101, 140, 104, 111, 134, 170, 126, 138,
	88, 158, 141, 0, 0, 0, 23, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 125, 0,
	77, 0, 108, 169, 133, 95, 160, 93, 0, 0,
	0, 0, 107, 0, 109, 0, 0, 142, 118, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 50, 0, 0, 75, 0, 0, 0,
	0, 0, 0, 0, 0, 86, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 187, 0, 0, 0, 0, 131, 0, 0, 145,
	98, 97, 106, 0, 0, 0, 89, 0, 137, 127,
	157, 0, 128, 136, 110, 149, 132, 156, 188, 164,
	147, 163, 78, 146, 155, 87, 139, 80, 153, 144,
	116, 102, 103, 79, 0, 135, 92, 96, 91, 124,
	150, 151, 90, 171, 83, 162, 82, 84, 161, 123,
	148, 154, 117, 114, 81, 152, 115, 113, 105, 94,
	99, 129, 112, 130, 100, 120, 119, 121, 0, 0,
	0, 143, 159, 172, 0, 0, 165, 166, 167, 168,
	0, 0, 0, 122, 85, 101, 140, 104, 111, 134,
	170, 126, 138, 88, 158, 141, 0, 0, 0, 23,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 125, 0, 77, 0, 108, 169, 133, 95, 160,
	93, 0, 0, 0, 0, 107, 0, 109, 0, 0,
	142, 118, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 50, 0, 0, 185,
	0, 0, 0, 0, 0, 0, 0, 0, 86, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 187, 0, 0, 0, 0, 131,
	0, 0, 145, 98, 97, 106, 0, 0, 0, 89,
	0, 137, 127, 157, 0, 128, 136, 110, 149, 132,
	156, 188, 164, 147, 163, 78, 146, 155, 87, 139,
	80, 153, 144, 116, 102, 103, 79, 0, 135, 92,
	96, 91, 124, 150, 151, 90, 171, 83, 162, 82,
	84, 161, 123, 148, 154, 117, 114, 81, 152, 115,
	113, 105, 94, 99, 129, 112, 130, 100, 120, 119,
	121, 0, 0, 0, 143, 159, 172, 0, 0, 165,
	166, 167, 168, 0, 0, 0, 122, 85, 101, 140,
	104, 111, 134, 170, 126, 138, 88, 158, 141, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 125, 0, 77, 0, 108, 169,
	133, 95, 160, 93, 0, 0, 0, 0, 107, 0,
	109, 0, 0, 142, 118, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 75, 0, 0, 692, 0, 0, 693, 0,
	0, 86, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 187, 0, 0,
	0, 0, 131, 0, 0, 145, 98, 97, 106, 0,
	0, 0, 89, 0, 137, 127, 157, 0, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	155, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 84, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 0, 0, 143, 159, 172,
	0, 0, 165, 166, 167, 168, 0, 0, 0, 122,
	85, 101, 140, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 125, 0, 77,
	0, 108, 169, 133, 95, 160, 93, 0, 592, 0,
	0, 107, 0, 109, 0, 0, 142, 118, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 75, 0, 591, 0, 0,
	0, 0, 0, 0, 86, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	187, 0, 0, 0, 0, 131, 0, 0, 145, 98,
	97, 106, 0, 0, 0, 89, 0, 137, 127, 157,
	0, 128, 136, 110, 149, 132, 156, 188, 164, 147,
	163, 78, 146, 155, 87, 139, 80, 153, 144, 116,
	102, 103, 79, 0, 135, 92, 96, 91, 124, 150,
	151, 90, 171, 83, 162, 82, 84, 161, 123, 148,
	154, 117, 114, 81, 152, 115, 113, 105, 94, 99,
	129, 112, 130, 100, 120, 119, 121, 0, 0, 0,
	143, 159, 172, 0, 0, 165, 166, 167, 168, 0,
	0, 0, 122, 85, 101, 140, 104, 111, 134, 170,
	126, 138, 88, 158, 141, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 77, 0, 108, 169, 133, 95, 160, 125,
	0, 0, 0, 572, 0, 0, 0, 0, 93, 0,
	0, 0, 0, 107, 0, 109, 0, 0, 142, 118,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 185, 0, 574,
	0, 0, 0, 0, 0, 0, 86, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 187, 0, 0, 0, 0, 131, 0, 0,
	145, 98, 97, 106, 0, 0, 0, 89, 0, 137,
	127, 157, 0, 570, 136, 110, 149, 132, 156, 188,
	164, 147, 163, 78, 146, 155, 87, 139, 80, 153,
	144, 116, 102, 103, 79, 0, 135, 92, 96, 91,
	124, 150, 151, 90, 171, 83, 162, 82, 84, 161,
	123, 148, 154, 117, 114, 81, 152, 115, 113, 105,
	94, 99, 129, 112, 130, 100, 120, 119, 121, 0,
	0, 0, 143, 159, 172, 0, 0, 165, 166, 167,
	168, 0, 0, 0, 122, 85, 101, 140, 104, 111,
	134, 170, 126, 138, 88, 158, 141, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 125, 0, 77, 0, 108, 169, 133, 95,
	160, 93, 0, 0, 0, 0, 107, 0, 109, 0,
	0, 142, 118, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 50, 0, 0,
	185, 0, 0, 0, 0, 0, 0, 0, 0, 86,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 187, 0, 0, 0, 0,
	131, 0, 0, 145, 98, 97, 106, 0, 0, 0,
	89, 0, 137, 127, 157, 0, 128, 136, 110, 149,
	132, 156, 188, 164, 147, 163, 78, 146, 155, 87,
	139, 80, 153, 144, 116, 102, 103, 79, 0, 135,
	92, 96, 91, 124, 150, 151, 90, 171, 83, 162,
	82, 84, 161, 123, 148, 154, 117, 114, 81, 152,
	115, 113, 105, 94, 99, 129, 112, 130, 100, 120,
	119, 121, 0, 0, 0, 143, 159, 172, 0, 0,
	165, 166, 167, 168, 0, 0, 0, 122, 85, 101,
	140, 104, 111, 134, 170, 126, 138, 88, 158, 141,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 125, 0, 77, 0, 108,
	169, 133, 95, 160, 93, 0, 0, 0, 0, 107,
	0, 109, 0, 0, 142, 118, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 185, 0, 574, 0, 0, 0, 0,
	0, 0, 86, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 187, 0,
	0, 0, 0, 131, 0, 0, 145, 98, 97, 106,
	0, 0, 0, 89, 0, 137, 127, 157, 0, 128,
	136, 110, 149, 132, 156, 188, 164, 147, 163, 78,
	146, 155, 87, 139, 80, 153, 144, 116, 102, 103,
	79, 0, 135, 92, 96, 91, 124, 150, 151, 90,
	171, 83, 162, 82, 84, 161, 123, 148, 154, 117,
	114, 81, 152, 115, 113, 105, 94, 99, 129, 112,
	130, 100, 120, 119, 121, 0, 0, 0, 143, 159,
	172, 0, 0, 165, 166, 167, 168, 0, 0, 0,
	122, 85, 101, 140, 104, 111, 134, 170, 126, 138,
	88, 158, 141, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 125, 0,
	77, 0, 108, 169, 133, 95, 160, 93, 0, 0,
	0, 0, 107, 0, 109, 0, 0, 142, 118, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 75, 0, 478, 0,
	0, 0, 0, 0, 0, 86, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 187, 0, 0, 0, 0, 131, 0, 0, 145,
	98, 97, 106, 0, 0, 0, 89, 0, 137, 127,
	157, 0, 128, 136, 110, 149, 132, 156, 188, 164,
	147, 163, 78, 146, 155, 87, 139, 80, 153, 144,
	116, 102, 103, 79, 0, 135, 92, 96, 91, 124,
	150, 151, 90, 171, 83, 162, 82, 84, 161, 123,
	148, 154, 117, 114, 81, 152, 115, 113, 105, 94,
	99, 129, 112, 130, 100, 120, 119, 121, 0, 0,
	0, 143, 159, 172, 0, 0, 165, 166, 167, 168,
	0, 0, 0, 122, 85, 101, 140, 104, 111, 134,
	170, 126, 138, 88, 158, 141, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 125, 77, 0, 108, 169, 133, 95, 160,
	550, 93, 0, 0, 0, 0, 107, 0, 109, 0,
	0, 142, 118, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	185, 0, 0, 0, 0, 0, 0, 0, 0, 86,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 187, 0, 0, 0, 0,
	131, 0, 0, 145, 98, 97, 106, 0, 0, 0,
	89, 0, 137, 127, 157, 0, 128, 136, 110, 149,
	132, 156, 188, 164, 147, 163, 78, 146, 155, 87,
	139, 80, 153, 144, 116, 102, 103, 79, 0, 135,
	92, 96, 91, 124, 150, 151, 90, 171, 83, 162,
	82, 84, 161, 123, 148, 154, 117, 114, 81, 152,
	115, 113, 105, 94, 99, 129, 112, 130, 100, 120,
	119, 121, 0, 0, 0, 143, 159, 172, 0, 0,
	165, 166, 167, 168, 0, 0, 0, 122, 85, 101,
	140, 104, 111, 134, 170, 126, 138, 88, 158, 141,
	0, 0, 0, 0, 0, 0, 0, 0, 301, 0,
	0, 0, 0, 0, 0, 125, 0, 77, 0, 108,
	169, 133, 95, 160, 93, 0, 0, 0, 0, 107,
	0, 109, 0, 0, 142, 118, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 185, 0, 0, 0, 0, 0, 0,
	0, 0, 86, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 187, 0,
	0, 0, 0, 131, 0, 0, 145, 98, 97, 106,
	0, 0, 0, 89, 0, 137, 127, 157, 0, 128,
	136, 110, 149, 132, 156, 188, 164, 147, 163, 78,
	146, 155, 87, 139, 80, 153, 144, 116, 102, 103,
	79, 0, 135, 92, 96, 91, 124, 150, 151, 90,
	171, 83, 162, 82, 84, 161, 123, 148, 154, 117,
	114, 81, 152, 115, 113, 105, 94, 99, 129, 112,
	130, 100, 120, 119, 121, 0, 0, 0, 143, 159,
	172, 0, 0, 165, 166, 167, 168, 0, 0, 0,
	122, 85, 101, 140, 104, 111, 134, 170, 126, 138,
	88, 158, 141, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 125, 0,
	77, 0, 108, 169, 133, 95, 160, 93, 0, 0,
	0, 0, 107, 0, 109, 0, 0, 142, 118, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 185, 0, 0, 0,
	0, 0, 0, 0, 0, 86, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 182,
	0, 187, 0, 0, 0, 0, 131, 0, 0, 145,
	98, 97, 106, 0, 0, 0, 89, 0, 137, 127,
	157, 0, 128, 136, 110, 149, 132, 156, 188, 164,
	147, 163, 78, 146, 155, 87, 139, 80, 153, 144,
	116, 102, 103, 79, 0, 135, 92, 96, 91, 124,
	150, 151, 90, 171, 83, 162, 82, 84, 161, 123,
	148, 154, 117, 114, 81, 152, 115, 113, 105, 94,
	99, 129, 112, 130, 100, 120, 119, 121, 0, 0,
	0, 143, 159, 172, 0, 0, 165, 166, 167, 168,
	0, 0, 0, 122, 85, 101, 140, 104, 111, 134,
	170, 126, 138, 88, 158, 141, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 125, 0, 77, 0, 108, 169, 133, 95, 160,
	93, 0, 0, 0, 0, 107, 0, 109, 0, 0,
	142, 118, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 75,
	0, 0, 0, 0, 0, 0, 0, 0, 86, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 187, 0, 0, 0, 0, 131,
	0, 0, 145, 98, 97, 106, 0, 0, 0, 89,
	0, 137, 127, 157, 0, 128, 136, 110, 149, 132,
	156, 188, 164, 147, 163, 78, 146, 155, 87, 139,
	80, 153, 144, 116, 102, 103, 79, 0, 135, 92,
	96, 91, 124, 150, 151, 90, 171, 83, 162, 82,
	84, 161, 123, 148, 154, 117, 114, 81, 152, 115,
	113, 105, 94, 99, 129, 112, 130, 100, 120, 119,
	121, 0, 0, 0, 143, 159, 172, 0, 0, 165,
	166, 167, 168, 0, 0, 0, 122, 85, 101, 140,
	104, 111, 134, 170, 126, 138, 88, 158, 141, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 125, 0, 77, 0, 108, 169,
	133, 95, 160, 93, 0, 0, 0, 0, 107, 0,
	109, 0, 0, 142, 118, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 238, 0, 0, 0, 0, 0, 0, 0,
	0, 86, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 187, 0, 0,
	0, 0, 131, 0, 0, 145, 98, 97, 106, 0,
	0, 0, 89, 0, 137, 127, 157, 0, 128, 136,
	110, 149, 132, 156, 188, 164, 147, 163, 78, 146,
	155, 87, 139, 80, 153, 144, 116, 102, 103, 79,
	0, 135, 92, 96, 91, 124, 150, 151, 90, 171,
	83, 162, 82, 84, 161, 123, 148, 154, 117, 114,
	81, 152, 115, 113, 105, 94, 99, 129, 112, 130,
	100, 120, 119, 121, 0, 0, 0, 143, 159, 172,
	0, 0, 165, 166, 167, 168, 0, 0, 0, 122,
	85, 101, 140, 104, 111, 134, 170, 126, 138, 88,
	158, 141, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 125, 0, 77,
	0, 108, 169, 133, 95, 160, 93, 0, 0, 0,
	0, 107, 0, 109, 0, 0, 142, 118, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 185, 0, 0, 0, 0,
	0, 0, 0, 0, 86, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	187, 0, 0, 0, 0, 131, 0, 0, 145, 98,
	97, 106, 0, 0, 0, 89, 0, 137, 127, 157,
	0, 128, 136, 110, 149, 132, 156, 188, 164, 147,
	163, 78, 146, 155, 87, 139, 80, 153, 144, 116,
	102, 103, 79, 0, 135, 92, 96, 91, 124, 150,
	151, 90, 171, 83, 162, 82, 84, 161, 123, 148,
	154, 117, 114, 81, 152, 115, 113, 105, 94, 99,
	129, 112, 130, 100, 120, 119, 121, 0, 0, 0,
	143, 159, 172, 0, 0, 165, 166, 167, 168, 0,
	0, 0, 122, 85, 101, 140, 104, 111, 134, 170,
	126, 138, 88, 158, 141, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 77, 0, 108, 169, 133, 95, 160,
}
var yyPact = [...]int{

	1723, -1000, -186, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 802, 836, -1000, -1000, -1000, -1000, -1000, -1000, 618,
	7335, 41, 62, -18, 10030, 61, 1367, 10699, -1000, -6,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 593, -1000, -1000,
	-1000, -1000, -1000, 776, 799, 647, 803, 702, -1000, 5512,
	40, 8914, 9807, 4816, -1000, 484, 59, 10699, -158, 10253,
	34, 34, 34, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 51, 10699, -1000, 10699, 33, 481, 33,
	33, 33, 10699, -1000, 101, -1000, -1000, -1000, -1000, 10699,
	478, 733, 22, 2856, 2856, 2856, 2856, 1, 2856, -83,
	655, -1000, -1000, -1000, -1000, 2856, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 364, 739, 6211, 6211,
	802, -1000, 593, -1000, -1000, -1000, 729, -1000, -1000, 243,
	822, -1000, 7112, 99, -1000, 6211, 1819, 429, -1000, -1000,
	429, -1000, -1000, 81, -1000, -1000, 6657, 6657, 6657, 6657,
	6657, 6657, 6657, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 429, -1000, 5979,
	429, 429, 429, 429, 429, 429, 429, 429, 6211, 429,
	429, 429, 429, 429, 429, 429, 429, 429, 429, 429,
	429, 429, 9584, 587, 874, -1000, -1000, -1000, 767, 8013,
	8691, 10699, 531, -1000, 589, 4571, -121, -1000, -1000, -1000,
	173, 8459, -1000, -1000, -1000, 731, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 477,
	-1000, 1856, 472, 2856, 50, 606, 470, 223, 453, 10699,
	10699, 2856, 44, 10699, 757, 653, 10699, 452, 440, -1000,
	4326, -1000, 2856, 2856, 2856, 2856, 2856, 2856, 2856, 2856,
	-1000, -1000, -1000, -1000, -1000, -1000, 2856, 2856, -1000, -67,
	-1000, 10699, -1000, -1000, -1000, -1000, 831, 130, 525, 95,
	591, -1000, 278, 776, 364, 702, 8236, 665, -1000, -1000,
	10699, -1000, 6211, 6211, 286, -1000, 9360, -1000, -1000, 3346,
	147, 6657, 284, 237, 6657, 6657, 6657, 6657, 6657, 6657,
	6657, 6657, 6657, 6657, 6657, 6657, 6657, 6657, 6657, 327,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 438, -1000,
	593, 725, 725, 113, 113, 113, 113, 113, 113, 6880,
	5048, 364, 437, 180, 5979, 5512, 5512, 6211, 6211, 10476,
	10476, 5512, 769, 203, 180, 10476, -1000, 364, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 5512, 5512, 5512, 5512, 14,
	10699, -1000, 10476, 8914, 8914, 8914, 8914, 8914, -1000, 679,
	678, -1000, 688, 685, 694, 10699, -1000, 433, 8013, 125,
	429, -1000, 9137, -1000, -1000, 14, 568, 8914, 10699, -1000,
	-1000, 4081, 589, -121, 581, -1000, -98, -97, 5744, 110,
	-1000, -1000, -1000, -1000, 2611, 188, 273, -66, -1000, -1000,
	-1000, 595, -1000, 595, 595, 595, 595, -33, -33, -33,
	-33, -1000, -1000, -1000, -1000, -1000, 617, 614, -1000, 595,
	595, 595, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 613, 613,
	613, 597, 597, 622, -1000, 10699, -174, 430, 2856, 756,
	2856, -1000, 70, -1000, 10699, -1000, -1000, 10699, 2856, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 208, -1000, -1000, -1000, -1000, 695,
	6211, 6211, 3836, 6211, -1000, -1000, -1000, 739, -1000, 769,
	810, -1000, 722, 720, 5512, -1000, -1000, 147, 156, -1000,
	-1000, 328, -1000, -1000, -1000, -1000, 94, 429, -1000, 1907,
	-1000, -1000, -1000, -1000, 284, 6657, 6657, 6657, 1409, 1907,
	1872, 405, 357, 113, 612, 612, 112, 112, 112, 112,
	112, 910, 910, -1000, -1000, -1000, 364, -1000, -1000, -1000,
	364, 5512, 582, -1000, -1000, 6211, -1000, 364, 426, 426,
	289, 334, 626, -1000, 91, 619, 426, 5512, 218, -1000,
	6211, 364, -1000, 426, 364, 426, 426, 544, 429, -1000,
	564, -1000, 172, 874, 605, 652, 650, -1000, -1000, -1000,
	-1000, 675, -1000, 636, -1000, -1000, -1000, -1000, -1000, 58,
	57, 56, 10253, -1000, 818, 8914, 521, -1000, -1000, 581,
	-121, -100, -1000, -1000, -1000, 180, -1000, 428, 530, 2366,
	-1000, -1000, -1000, -1000, -1000, -1000, 601, 749, 145, 137,
	427, -1000, -1000, 736, -1000, 238, -69, -1000, -1000, 292,
	-33, -33, -1000, -1000, 110, 730, 110, 110, 110, 343,
	343, -1000, -1000, -1000, -1000, 280, -1000, -1000, -1000, 277,
	-1000, 637, 10253, 2856, -1000, 3591, -1000, -1000, -1000, -1000,
	-1000, -1000, 282, 204, 179, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 13, -1000, 2856, -1000,
	209, 10699, 10699, 709, 180, 180, 79, -1000, -1000, 10699,
	-1000, -1000, -1000, -1000, 610, -1000, -1000, -1000, 3101, 5512,
	-1000, 1409, 1907, 1606, -1000, 6657, 6657, -1000, -1000, 426,
	5512, 180, -1000, -1000, -1000, 54, 327, 54, 6657, 6657,
	3836, 6657, 6657, -168, 532, 187, -1000, 6211, 307, -1000,
	-1000, -1000, -1000, -1000, 635, 10476, 429, -1000, 7790, 10253,
	802, 10476, 6211, 6211, -1000, -1000, 6211, 599, -1000, 6211,
	-1000, -1000, -1000, 429, 429, 429, 389, -1000, 802, 521,
	-1000, -1000, -1000, -130, -132, -1000, -1000, 2611, -1000, 2611,
	10253, -1000, 367, 350, -1000, -1000, 625, 28, -1000, -1000,
	-1000, 423, 110, 110, -1000, 155, -1000, -1000, -1000, 420,
	-1000, 416, 526, 410, 10699, -1000, -1000, 516, -1000, 165,
	-1000, -1000, 10253, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 10253, 10699, -1000, -1000, -1000,
	-1000, -1000, 10253, -1000, -1000, 341, 6211, -1000, -1000, -1000,
	3591, -1000, 818, 8914, -1000, -1000, 364, -1000, 6657, 1907,
	1907, -1000, -1000, 364, 595, 595, -1000, 595, 597, -1000,
	595, -15, 595, -16, 364, 364, 1524, 1728, -1000, 422,
	1553, 429, -165, -1000, 180, 6211, -1000, 732, 490, 498,
	-1000, -1000, 5280, 364, 391, 77, 389, 776, -1000, 180,
	180, 180, 10253, 180, 10253, 10253, 10253, 7567, 10253, 776,
	-1000, -1000, -1000, -1000, 2366, -1000, 387, -1000, 595, -1000,
	-1000, -60, 828, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -33, 340, -33, 259, -1000, 257,
	2856, 3591, 2611, -1000, 594, -1000, -1000, -1000, -1000, 741,
	-1000, 180, 815, 513, -1000, 1907, -1000, -1000, 86, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 6657, 6657,
	-1000, 6657, 6657, 6657, 364, 322, 180, 748, -1000, 429,
	-1000, -1000, 560, 10253, 10253, -1000, -1000, 377, -1000, 371,
	371, 371, 125, -1000, -1000, 107, 10253, -1000, 133, -1000,
	-147, 110, -1000, 110, 417, 406, -1000, -1000, -1000, 10253,
	429, 805, 779, -1000, -1000, 1509, 1509, 1509, 1509, 16,
	-1000, -1000, 826, -1000, 429, -1000, 593, 73, -1000, 10253,
	-1000, -1000, -1000, -1000, -1000, 107, -1000, 347, 160, 317,
	-1000, 239, 747, -1000, 738, -1000, -1000, -1000, -1000, -1000,
	363, 12, -1000, 6211, 6211, -1000, -1000, -1000, -1000, 364,
	49, -178, 10476, 498, 364, 10253, -1000, -1000, -1000, 256,
	-1000, -1000, -1000, 316, -1000, -1000, 606, 361, -1000, 10253,
	180, 494, -1000, 706, -171, -181, 435, -1000, -1000, -1000,
	-1000, -174, -1000, 12, 715, -1000, 705, -1000, -1000, -1000,
	9, -175, 4, -179, 429, -182, 6434, -1000, 1509, 364,
	-1000, -1000,
}
var yyPgo = [...]int{

	0, 1069, 13, 493, 1068, 1067, 1063, 1059, 1058, 1056,
	1055, 1053, 1052, 1047, 1045, 1044, 1042, 1040, 1039, 1037,
	1036, 1035, 1033, 1032, 104, 1031, 1027, 1026, 57, 1025,
	63, 1024, 1022, 33, 225, 45, 30, 150, 1018, 31,
	54, 84, 1017, 35, 1016, 1014, 70, 1013, 51, 1000,
	999, 1293, 998, 995, 19, 41, 993, 991, 990, 989,
	60, 312, 988, 987, 985, 982, 981, 979, 39, 5,
	7, 12, 11, 978, 127, 15, 976, 55, 975, 974,
	973, 971, 25, 970, 46, 965, 21, 40, 964, 16,
	53, 28, 23, 2, 65, 47, 962, 27, 50, 38,
	961, 958, 367, 948, 944, 942, 940, 936, 934, 140,
	309, 932, 931, 930, 928, 32, 167, 466, 73, 58,
	927, 926, 925, 1239, 59, 52, 22, 924, 36, 1247,
	42, 912, 910, 29, 909, 908, 897, 895, 894, 893,
	892, 264, 890, 889, 887, 17, 20, 882, 881, 49,
	26, 878, 877, 876, 34, 37, 874, 44, 873, 872,
	867, 866, 24, 10, 865, 9, 862, 8, 860, 856,
	4, 853, 18, 852, 3, 851, 6, 43, 850, 847,
	0, 323, 844, 843, 105,
}
var yyR1 = [...]int{

	0, 178, 179, 179, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 6, 3, 4, 4, 5,
	5, 7, 7, 27, 27, 8, 9, 9, 9, 182,
	182, 46, 46, 90, 90, 10, 10, 10, 10, 95,
	95, 99, 99, 99, 100, 100, 100, 100, 131, 131,
	11, 11, 11, 11, 11, 11, 11, 176, 176, 175,
	174, 174, 173, 173, 172, 16, 159, 160, 160, 160,
	155, 134, 134, 134, 134, 137, 137, 135, 135, 135,
	135, 135, 135, 135, 136, 136, 136, 136, 136, 138,
	138, 138, 138, 138, 139, 139, 139, 139, 139, 139,
	139, 139, 139, 139, 139, 139, 139, 139, 139, 140,
	140, 140, 140, 140, 140, 140, 140, 154, 154, 141,
	141, 149, 149, 150, 150, 150, 147, 147, 148, 148,
	151, 151, 151, 142, 142, 142, 142, 142, 142, 142,
	144, 144, 152, 152, 145, 145, 145, 146, 146, 153,
	153, 153, 153, 153, 143, 143, 156, 156, 168, 168,
	167, 167, 167, 158, 158, 164, 164, 164, 164, 164,
	157, 157, 166, 166, 165, 161, 161, 161, 162, 162,
	162, 163, 163, 163, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 177, 177, 177, 177, 177, 177, 177,
	177, 177, 177, 177, 171, 169, 169, 170, 170, 13,
	14, 14, 14, 14, 14, 15, 15, 17, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
	18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
	18, 107, 107, 104, 104, 105, 105, 106, 106, 106,
	108, 108, 108, 132, 132, 132, 19, 19, 21, 21,
	22, 23, 20, 20, 20, 20, 20, 183, 24, 25,
	25, 26, 26, 26, 30, 30, 30, 28, 28, 29,
	29, 35, 35, 34, 34, 36, 36, 36, 36, 120,
	120, 120, 119, 119, 38, 38, 39, 39, 40, 40,
	41, 41, 41, 53, 53, 89, 89, 91, 91, 42,
	42, 42, 42, 43, 43, 44, 44, 45, 45, 127,
	127, 126, 126, 126, 125, 125, 47, 47, 47, 49,
	48, 48, 48, 48, 50, 50, 52, 52, 51, 51,
	54, 54, 54, 54, 55, 55, 37, 37, 37, 37,
	37, 37, 37, 103, 103, 57, 57, 56, 56, 56,
	56, 56, 56, 56, 56, 56, 56, 67, 67, 67,
	67, 67, 67, 58, 58, 58, 58, 58, 58, 58,
	33, 33, 68, 68, 68, 74, 69, 69, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 61,
	61, 61, 61, 61, 61, 61, 61, 61, 61, 65,
	65, 65, 63, 63, 63, 63, 63, 63, 63, 63,
	63, 63, 63, 63, 63, 63, 63, 64, 64, 64,
	64, 64, 64, 64, 64, 184, 184, 66, 66, 66,
	66, 31, 31, 31, 31, 31, 130, 130, 133, 133,
	133, 133, 133, 133, 133, 133, 133, 133, 133, 133,
	133, 78, 78, 32, 32, 76, 76, 77, 79, 79,
	75, 75, 75, 60, 60, 60, 60, 60, 60, 60,
	60, 62, 62, 62, 80, 80, 81, 81, 82, 82,
	83, 83, 84, 85, 85, 85, 86, 86, 86, 86,
	87, 87, 87, 59, 59, 59, 59, 59, 59, 88,
	88, 88, 88, 92, 92, 70, 70, 72, 72, 71,
	73, 93, 93, 97, 94, 94, 98, 98, 98, 96,
	96, 96, 122, 122, 122, 101, 101, 109, 109, 110,
	110, 102, 102, 111, 111, 111, 111, 111, 111, 111,
	111, 111, 111, 112, 112, 112, 113, 113, 114, 114,
	114, 121, 121, 117, 117, 118, 118, 123, 123, 124,
	124, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 115, 115, 115, 115, 115, 115, 115,
	115, 115, 115, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 116, 116, 116, 116, 116, 116, 116, 116, 116,
	116, 180, 181, 128, 129, 129, 129,
}
var yyR2 = [...]int{

	0, 2, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 4, 6, 7, 5, 10, 1, 3, 1,
	3, 7, 8, 1, 1, 8, 8, 7, 6, 1,
	1, 1, 3, 0, 4, 3, 4, 5, 4, 1,
	3, 3, 2, 2, 2, 2, 2, 1, 1, 1,
	2, 8, 4, 6, 5, 5, 5, 0, 2, 1,
	0, 2, 1, 3, 3, 4, 4, 1, 3, 3,
	8, 3, 1, 1, 1, 2, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2, 2, 1,
	2, 2, 2, 1, 4, 4, 2, 2, 3, 3,
	3, 3, 1, 1, 1, 1, 1, 6, 6, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 3, 0,
	3, 0, 5, 0, 3, 5, 0, 1, 0, 1,
	0, 1, 2, 0, 2, 2, 2, 2, 2, 2,
	0, 3, 0, 1, 0, 3, 3, 0, 2, 0,
	2, 1, 2, 1, 0, 2, 5, 4, 1, 2,
	2, 3, 2, 0, 1, 2, 3, 3, 2, 2,
	1, 1, 1, 3, 2, 0, 1, 3, 1, 2,
	3, 1, 1, 1, 6, 7, 7, 12, 7, 7,
	7, 4, 5, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 7, 1, 3, 8, 8, 5,
	4, 6, 5, 4, 4, 3, 2, 3, 4, 4,
	4, 4, 4, 4, 4, 4, 3, 3, 3, 3,
	4, 3, 6, 4, 2, 4, 2, 2, 2, 2,
	3, 1, 1, 0, 1, 0, 1, 0, 2, 2,
	0, 2, 2, 0, 1, 1, 2, 1, 1, 2,
	1, 1, 2, 2, 2, 2, 2, 0, 2, 0,
	2, 1, 2, 2, 0, 1, 1, 0, 1, 0,
	1, 0, 1, 1, 3, 1, 2, 3, 5, 0,
	1, 2, 1, 1, 0, 2, 1, 3, 1, 1,
	1, 3, 3, 3, 7, 1, 3, 1, 3, 4,
	4, 4, 3, 2, 4, 0, 1, 0, 2, 0,
	1, 0, 1, 2, 1, 1, 1, 2, 2, 1,
	2, 3, 2, 3, 2, 2, 2, 1, 1, 3,
	0, 5, 5, 5, 0, 2, 1, 3, 3, 2,
	3, 1, 2, 0, 3, 1, 1, 3, 3, 4,
	4, 5, 3, 4, 5, 6, 2, 1, 2, 1,
	2, 1, 2, 1, 1, 1, 1, 1, 1, 1,
	0, 2, 1, 1, 1, 3, 1, 3, 1, 1,
	1, 1, 1, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 2, 2,
	2, 2, 2, 2, 3, 1, 1, 1, 1, 4,
	5, 6, 4, 4, 6, 6, 6, 6, 8, 8,
	6, 8, 8, 9, 7, 5, 4, 2, 2, 2,
	2, 2, 2, 2, 2, 0, 2, 4, 4, 4,
	4, 0, 3, 4, 7, 3, 1, 1, 2, 3,
	3, 1, 2, 2, 1, 2, 1, 2, 2, 1,
	2, 0, 1, 0, 2, 1, 2, 4, 0, 2,
	1, 3, 5, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 0, 3, 0, 2, 0, 3,
	1, 3, 2, 0, 1, 1, 0, 2, 4, 4,
	0, 2, 4, 2, 1, 3, 5, 4, 6, 1,
	3, 3, 5, 0, 5, 1, 3, 1, 2, 3,
	1, 1, 3, 3, 1, 3, 3, 3, 3, 1,
	2, 1, 1, 1, 1, 1, 1, 0, 2, 0,
	3, 0, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 0, 1, 1, 1, 1, 0, 1,
	1, 0, 2, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 0, 0, 1, 1,
}
var yyChk = [...]int{

	-1000, -178, -1, -2, -6, -7, -8, -9, -10, -11,
	-12, -13, -14, -15, -17, -18, -19, -21, -22, -23,
	-20, -3, -4, 6, 7, -27, 9, 10, 30, -16,
	112, 113, 115, 114, 140, 116, 133, 49, 152, 153,
	155, 156, 25, 134, 135, 138, 139, -180, 8, 235,
	53, -179, 250, -82, 15, -26, 5, -24, -183, -24,
	-24, -24, -24, -24, -159, 53, -114, 121, 70, 148,
	227, 118, 119, 125, -117, 56, -116, 243, 152, 163,
	157, 184, 176, 174, 177, 214, 65, 155, 223, 136,
	172, 168, 166, 27, 189, 248, 167, 131, 130, 190,
	194, 215, 161, 162, 217, 188, 132, 32, 245, 34,
	144, 218, 192, 187, 183, 186, 160, 182, 38, 196,
	195, 197, 213, 179, 169, 18, 221, 139, 142, 191,
	193, 126, 146, 247, 219, 165, 143, 138, 222, 156,
	216, 225, 37, 201, 159, 129, 153, 150, 180, 145,
	170, 171, 185, 158, 181, 154, 147, 140, 224, 202,
	249, 178, 175, 151, 149, 206, 207, 208, 209, 246,
	220, 173, 203, -102, 121, 123, 119, 119, 120, 121,
	227, 118, 119, -51, -123, 56, -116, 121, 148, 119,
	106, 177, 112, 204, 120, 32, 146, -132, 119, -104,
	149, 206, 207, 208, 209, 56, 216, 215, 210, -123,
	154, -128, -128, -128, -128, -128, -2, -86, 17, 16,
	-5, -3, -180, 6, 20, 21, -30, 39, 40, -25,
	-36, 97, -37, -123, -56, 72, -61, 29, 56, -116,
	23, -60, -57, -75, -73, -74, 106, 107, 95, 96,
	103, 73, 108, -65, -63, -64, -66, 58, 57, 66,
	59, 60, 61, 62, 67, 68, 69, -117, -71, -180,
	43, 44, 236, 237, 238, 239, 242, 240, 75, 33,
	226, 234, 233, 232, 230, 231, 228, 229, 124, 227,
	101, 235, -102, -39, -40, -41, -42, -53, -74, -180,
	-51, 11, -46, -51, -94, -131, 154, -98, 216, 215,
	-118, -96, -117, -115, 214, 177, 213, 117, 71, 22,
	24, 199, 74, 106, 16, 75, 105, 236, 112, 47,
	228, 229, 226, 238, 239, 227, 204, 29, 10, 25,
	134, 21, 99, 114, 78, 79, 137, 23, 135, 69,
	19, 50, 11, 13, 14, 124, 123, 90, 120, 45,
	8, 108, 26, 87, 41, 28, 43, 88, 17, 230,
	231, 31, 242, 141, 101, 48, 35, 72, 67, 51,
	70, 15, 46, 89, 115, 235, 44, 118, 6, 241,
	30, 133, 42, 119, 205, 77, 122, 68, 5, 125,
	9, 49, 52, 232, 233, 234, 33, 76, 12, -160,
	-155, 56, 120, -51, 235, -117, -110, 124, -110, -110,
	119, -51, -51, -109, 124, 56, -109, -109, -109, -51,
	109, -51, 56, 30, 227, 56, 146, 119, 147, 121,
	-129, -180, -118, -129, -129, -129, 150, 151, -129, -105,
	211, 51, -129, -181, 55, -87, 19, 31, -37, -123,
	-83, -84, -37, -82, -2, -24, 35, -28, 21, 64,
	11, -120, 71, 70, 87, -119, 22, -117, 58, 109,
	-37, -58, 90, 72, 88, 89, 74, 92, 91, 102,
	95, 96, 97, 98, 99, 100, 101, 93, 94, 105,
	80, 81, 82, 83, 84, 85, 86, -103, -180, -74,
	-180, 110, 111, -61, -61, -61, -61, -61, -61, -61,
	-180, -2, -69, -37, -180, -180, -180, -180, -180, -180,
	-180, -180, -180, -78, -37, -180, -184, -180, -184, -184,
	-184, -184, -184, -184, -184, -180, -180, -180, -180, -52,
	26, -51, 30, 54, -47, -49, -48, -50, 41, 45,
	47, 42, 43, 44, 48, -127, 22, -39, -180, -126,
	142, -125, 22, -123, 58, -51, -46, -182, 54, 11,
	52, 54, -94, 154, -95, -99, 217, 219, 80, -122,
	-117, 58, 29, 30, 55, 54, -134, -137, -139, -138,
	-140, -135, -136, 174, 175, 106, 178, 180, 181, 182,
	183, 184, 185, 186, 187, 188, 189, 30, 136, 170,
	171, 172, 173, 190, 191, 192, 193, 194, 195, 196,
	197, 157, 158, 159, 160, 161, 162, 163, 165, 166,
	167, 168, 169, 56, -129, 121, -176, 52, 56, 72,
	56, -51, -51, -129, 122, -51, 23, 51, -51, 56,
	56, -124, -123, -115, -129, -129, -129, -129, -129, -129,
	-129, -129, -129, -129, -107, 205, 212, -51, 9, 90,
	54, 18, 109, 54, -85, 24, 25, -86, -181, -30,
	-62, -117, 59, 62, -29, 42, -51, -37, -37, -67,
	67, 72, 68, 69, -119, 97, -124, -118, -115, -61,
	-68, -71, -74, 63, 90, 88, 89, 74, -61, -61,
	-61, -61, -61, -61, -61, -61, -61, -61, -61, -61,
	-61, -61, -61, -130, 56, 58, 56, -60, -60, -117,
	-35, 21, -34, -36, -181, 54, -181, -2, -34, -34,
	-37, -37, -75, -117, -123, -75, -34, -28, -76, -77,
	76, -75, -181, -34, -35, -34, -34, -90, 142, -51,
	-93, -97, -75, -40, -41, -41, -40, -41, 41, 41,
	41, 46, 41, 46, 41, -48, -123, -181, -54, 49,
	123, 50, -180, -125, -90, 52, -39, -51, -98, -95,
	54, 218, 220, 221, 51, -37, -146, 105, -161, -162,
	-163, -118, 58, 59, -155, -156, -164, 126, 129, 125,
	-157, 120, 28, -151, 67, 72, -147, 202, -141, 53,
	-141, -141, -141, -141, -145, 177, -145, -145, -145, 53,
	53, -141, -141, -141, -149, 53, -149, -149, -150, 53,
	-150, -121, 52, -51, -174, 246, -175, 56, -129, 23,
	-129, -111, 117, 114, 115, -171, 113, 199, 177, 65,
	29, 15, 236, 142, 249, 56, 143, -51, -51, -129,
	-106, 11, 90, 37, -37, -37, -124, -84, -87, -101,
	19, 11, 33, 33, -34, 67, 68, 69, 109, -180,
	-68, -61, -61, -61, -33, 137, 71, -181, -181, -34,
	54, -37, -181, -181, -181, 54, 52, 22, 54, 11,
	109, 54, 11, -181, -34, -79, -77, 78, -37, -181,
	-181, -181, -181, -181, -59, 30, 33, -2, -180, -180,
	-55, 54, 12, 80, -44, -43, 51, 52, -45, 51,
	-43, 41, 41, 120, 120, 120, -91, -117, -55, -39,
	-55, -99, -100, 222, 219, 225, 56, 54, -163, 80,
	53, 28, -157, -157, 56, 56, -142, 29, 67, -148,
	203, 59, -145, -145, -146, 30, -146, -146, -146, -154,
	58, -154, 59, 59, 51, -117, -129, -173, -172, -118,
	-128, -177, 148, 127, 128, 131, 130, 56, 120, 28,
	126, 129, 142, 125, -177, 148, -112, -113, 122, 22,
	120, 28, 142, -129, -108, 88, 12, -123, -123, 38,
	109, -51, -38, 11, 97, -118, -35, -33, 71, -61,
	-61, -181, -36, -133, 106, 174, 136, 172, 168, 188,
	179, 201, 170, 202, -130, -133, -61, -61, -118, -61,
	-61, 243, -82, 79, -37, 77, -92, 51, -93, -70,
	-72, -71, -180, -2, -88, -117, -91, -82, -97, -37,
	-37, -37, 53, -37, -180, -180, -180, -181, 54, -82,
	-55, 219, 223, 224, -162, -163, -166, -165, -117, 56,
	56, -144, 51, 58, 59, 60, 67, 226, 66, 55,
	-146, -146, 56, 106, 55, 54, 55, 54, 55, 54,
	-51, 54, 80, -128, -117, -128, -117, -51, -128, -117,
	58, -37, -55, -39, -181, -61, -181, -141, -141, -141,
	-150, -141, 162, -141, 162, -181, -181, -181, 54, 19,
	-181, 54, 19, -180, -32, 241, -37, 27, -92, 54,
	-181, -181, -181, 54, 109, -181, -86, -89, -117, -89,
	-89, -89, -126, -117, -86, 55, 54, -141, -152, 199,
	9, -145, 58, -145, 59, 59, -129, -172, -163, 53,
	26, -80, 13, -145, 56, -61, -61, -61, -61, -61,
	-181, 58, 28, -72, 33, -2, -180, -117, -117, 54,
	55, -181, -181, -181, -54, -168, -167, 52, 132, 65,
	-165, -153, 126, 28, 125, 226, -146, -146, 55, 55,
	-89, -180, -81, 14, 16, -181, -181, -181, -181, -31,
	90, 246, 9, -70, -2, 109, -117, -167, 56, -158,
	80, 58, -143, 65, 28, 28, 55, -169, -170, 142,
	-37, -69, -181, 244, 48, 247, -93, -181, -117, 59,
	58, -176, -181, 54, -117, 38, 245, 248, -174, -170,
	33, 38, 144, 246, 145, 247, -180, 248, -61, 141,
	-181, -181,
}
var yyDef = [...]int{

	0, -2, 2, -2, 5, 6, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
	21, 508, 0, 277, 277, 277, 277, 277, 277, 0,
	578, 561, 0, 0, 0, 0, -2, 267, 268, 0,
	270, 271, 783, 783, 783, 783, 783, 0, 33, 34,
	781, 1, 3, 516, 0, 0, 281, 284, 279, 0,
	561, 0, 0, 0, 60, 0, 0, 770, 0, 771,
	559, 559, 559, 579, 580, 583, 584, 683, 684, 685,
	686, 687, 688, 689, 690, 691, 692, 693, 694, 695,
	696, 697, 698, 699, 700, 701, 702, 703, 704, 705,
	706, 707, 708, 709, 710, 711, 712, 713, 714, 715,
	716, 717, 718, 719, 720, 721, 722, 723, 724, 725,
	726, 727, 728, 729, 730, 731, 732, 733, 734, 735,
	736, 737, 738, 739, 740, 741, 742, 743, 744, 745,
	746, 747, 748, 749, 750, 751, 752, 753, 754, 755,
	756, 757, 758, 759, 760, 761, 762, 763, 764, 765,
	766, 767, 768, 769, 772, 773, 774, 775, 776, 777,
	778, 779, 780, 0, 0, 562, 0, 557, 0, 557,
	557, 557, 0, 226, 348, 587, 588, 770, 771, 0,
	0, 0, 0, 784, 784, 784, 784, 0, 784, 255,
	244, 246, 247, 248, 249, 784, 264, 265, 254, 266,
	269, 272, 273, 274, 275, 276, 27, 520, 0, 0,
	508, 29, 0, 277, 282, 283, 287, 285, 286, 278,
	0, 295, 299, 0, 356, 0, 361, 363, -2, -2,
	0, 398, 399, 400, 401, 402, 0, 0, 0, 0,
	0, 0, 0, 425, 426, 427, 428, 493, 494, 495,
	496, 497, 498, 499, 500, 365, 366, 490, 540, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 481, 0,
	455, 455, 455, 455, 455, 455, 455, 455, 0, 0,
	0, 0, 0, 0, 306, 308, 309, 310, 329, 0,
	331, 0, 0, 41, 45, 0, 761, 544, -2, -2,
	0, 0, 585, 586, -2, 690, -2, 591, 592, 593,
	594, 595, 596, 597, 598, 599, 600, 601, 602, 603,
	604, 605, 606, 607, 608, 609, 610, 611, 612, 613,
	614, 615, 616, 617, 618, 619, 620, 621, 622, 623,
	624, 625, 626, 627, 628, 629, 630, 631, 632, 633,
	634, 635, 636, 637, 638, 639, 640, 641, 642, 643,
	644, 645, 646, 647, 648, 649, 650, 651, 652, 653,
	654, 655, 656, 657, 658, 659, 660, 661, 662, 663,
	664, 665, 666, 667, 668, 669, 670, 671, 672, 673,
	674, 675, 676, 677, 678, 679, 680, 681, 682, 0,
	77, 0, 0, 784, 0, 67, 0, 0, 0, 0,
	0, 784, 0, 0, 0, 0, 0, 0, 0, 225,
	0, 227, 784, 784, 784, 784, 784, 784, 784, 784,
	236, 785, 786, 237, 238, 239, 784, 784, 241, 0,
	256, 0, 250, 28, 782, 22, 0, 0, 517, 0,
	509, 510, 513, 516, 27, 284, 0, 289, 288, 280,
	0, 296, 0, 0, 0, 300, 0, 302, 303, 0,
	359, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	383, 384, 385, 386, 387, 388, 389, 362, 0, 376,
	0, 0, 0, 418, 419, 420, 421, 422, 423, 0,
	291, 27, 0, 396, 0, 0, 0, 0, 0, 0,
	0, 0, 287, 0, 482, 0, 447, 0, 448, 449,
	450, 451, 452, 453, 454, 0, 291, 0, 0, 43,
	0, 347, 0, 0, 0, 0, 0, 0, 336, 0,
	0, 339, 0, 0, 0, 0, 330, 0, 0, 350,
	734, 332, 0, 334, 335, -2, 0, 0, 0, 39,
	40, 0, 46, 761, 48, 49, 0, 0, 0, 157,
	552, 553, 554, 550, 185, 0, 140, 136, 82, 83,
	84, 129, 86, 129, 129, 129, 129, 154, 154, 154,
	154, 112, 113, 114, 115, 116, 0, 0, 99, 129,
	129, 129, 103, 119, 120, 121, 122, 123, 124, 125,
	126, 87, 88, 89, 90, 91, 92, 93, 131, 131,
	131, 133, 133, 581, 62, 0, 70, 0, 784, 0,
	784, 75, 0, 201, 0, 220, 558, 0, 784, 223,
	224, 349, 589, 590, 228, 229, 230, 231, 232, 233,
	234, 235, 240, 243, 257, 251, 252, 245, 521, 0,
	0, 0, 0, 0, 512, 514, 515, 520, 30, 287,
	0, 501, 0, 0, 0, 290, 25, 357, 358, 360,
	377, 0, 379, 381, 301, 297, 0, 491, -2, 367,
	368, 392, 393, 394, 0, 0, 0, 0, 390, 372,
	0, 403, 404, 405, 406, 407, 408, 409, 410, 411,
	412, 413, 414, 417, 466, 467, 0, 415, 416, 424,
	0, 0, 292, 293, 395, 0, 539, 27, 0, 0,
	0, 0, 0, 490, 0, 0, 0, 0, 488, 485,
	0, 0, 456, 0, 0, 0, 0, 0, 0, 346,
	354, 541, 0, 307, 325, 327, 0, 322, 337, 338,
	340, 0, 342, 0, 344, 345, 311, 312, 313, 0,
	0, 0, 0, 333, 354, 0, 354, 42, 545, 47,
	0, 0, 52, 53, 546, 547, 548, 0, 76, 186,
	188, 191, 192, 193, 78, 79, 0, 0, 0, 0,
	0, 180, 181, 143, 141, 0, 138, 137, 85, 0,
	154, 154, 106, 107, 157, 0, 157, 157, 157, 0,
	0, 100, 101, 102, 94, 0, 95, 96, 97, 0,
	98, 0, 0, 784, 64, 0, 68, 69, 65, 560,
	66, 783, 0, 0, 573, 202, 563, 564, 565, 566,
	567, 568, 569, 570, 571, 572, 0, 219, 784, 222,
	260, 0, 0, 0, 518, 519, 0, 511, 23, 0,
	555, 556, 502, 503, 304, 378, 380, 382, 0, 291,
	369, 390, 373, 0, 370, 0, 0, 364, 429, 0,
	0, 397, -2, 432, 433, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 508, 0, 486, 0, 0, 446,
	457, 458, 459, 460, 533, 0, 0, -2, 0, 0,
	508, 0, 0, 0, 319, 326, 0, 0, 320, 0,
	321, 341, 343, 0, 0, 0, 0, 317, 508, 354,
	38, 50, 51, 0, 0, 57, 158, 0, 189, 0,
	0, 175, 0, 0, 178, 179, 150, 0, 142, 81,
	139, 0, 157, 157, 108, 0, 109, 110, 111, 0,
	127, 0, 0, 0, 0, 582, 63, 71, 72, 0,
	194, 783, 0, 203, 204, 205, 206, 207, 208, 209,
	210, 211, 212, 213, 783, 0, 0, 783, 574, 575,
	576, 577, 0, 221, 242, 0, 0, 258, 259, 522,
	0, 24, 354, 0, 298, 492, 0, 371, 0, 391,
	374, 430, 294, 0, 129, 129, 471, 129, 133, 474,
	129, 476, 129, 479, 0, 0, 0, 0, 491, 0,
	0, 0, 483, 445, 489, 0, 31, 0, 533, 523,
	535, 537, 0, 27, 0, 529, 0, 516, 542, 355,
	543, 323, 0, 328, 0, 0, 0, 331, 0, 516,
	37, 54, 55, 56, 187, 190, 0, 182, 129, 176,
	177, 152, 0, 144, 145, 146, 147, 148, 149, 130,
	104, 105, 155, 156, 154, 0, 154, 0, 134, 0,
	784, 0, 0, 195, 0, 196, 198, 199, 200, 0,
	261, 262, 504, 305, 431, 375, 434, 468, 154, 472,
	473, 475, 477, 478, 480, 436, 435, 437, 0, 0,
	440, 0, 0, 0, 0, 0, 487, 0, 32, 0,
	538, -2, 0, 0, 0, 44, 35, 0, 315, 0,
	0, 0, 350, 318, 36, 167, 0, 184, 159, 153,
	0, 157, 128, 157, 0, 0, 61, 73, 74, 0,
	0, 506, 0, 469, 470, 0, 0, 0, 0, 461,
	444, 484, 0, 536, 0, -2, 0, 531, 530, 0,
	324, 351, 352, 353, 314, 166, 168, 0, 173, 0,
	183, 164, 0, 161, 163, 151, 117, 118, 132, 135,
	0, 0, 26, 0, 0, 438, 439, 441, 442, 0,
	0, 0, 0, 526, 27, 0, 316, 169, 170, 0,
	174, 172, 80, 0, 160, 162, 67, 0, 215, 0,
	507, 505, 443, 0, 0, 0, 534, -2, 532, 171,
	165, 70, 214, 0, 0, 462, 0, 465, 197, 216,
	0, 463, 0, 0, 0, 0, 0, 464, 0, 0,
	217, 218,
}
var yyTok1 = [...]int{

	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 73, 3, 3, 3, 100, 92, 3,
	53, 55, 97, 95, 54, 96, 109, 98, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 250,
	81, 80, 82, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 102, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 91, 3, 103,
}
var yyTok2 = [...]int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 74, 75,
	76, 77, 78, 79, 83, 84, 85, 86, 87, 88,
	89, 90, 93, 94, 99, 101, 104, 105, 106, 107,
	108, 110, 111, 112, 113, 114, 115, 116, 117, 118,
	119, 120, 121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
	149, 150, 151, 152, 153, 154, 155, 156, 157, 158,
	159, 160, 161, 162, 163, 164, 165, 166, 167, 168,
	169, 170, 171, 172, 173, 174, 175, 176, 177, 178,
	179, 180, 181, 182, 183, 184, 185, 186, 187, 188,
	189, 190, 191, 192, 193, 194, 195, 196, 197, 198,
	199, 200, 201, 202, 203, 204, 205, 206, 207, 208,
	209, 210, 211, 212, 213, 214, 215, 216, 217, 218,
	219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
	229, 230, 231, 232, 233, 234, 235, 236, 237, 238,
	239, 240, 241, 242, 243, 244, 245, 246, 247, 248,
	249,
}
var yyTok3 = [...]int{
	0,
}

var yyErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	yyDebug        = 0
	yyErrorVerbose = false
)

type yyLexer interface {
	Lex(lval *yySymType) int
	Error(s string)
}

type yyParser interface {
	Parse(yyLexer) int
	Lookahead() int
}

type yyParserImpl struct {
	lval  yySymType
	stack [yyInitialStackSize]yySymType
	char  int
}

func (p *yyParserImpl) Lookahead() int {
	return p.char
}

func yyNewParser() yyParser {
	return &yyParserImpl{}
}

const yyFlag = -1000

func yyTokname(c int) string {
	if c >= 1 && c-1 < len(yyToknames) {
		if yyToknames[c-1] != "" {
			return yyToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yyStatname(s int) string {
	if s >= 0 && s < len(yyStatenames) {
		if yyStatenames[s] != "" {
			return yyStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yyErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !yyErrorVerbose {
		return "syntax error"
	}

	for _, e := range yyErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + yyTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := yyPact[state]
	for tok := TOKSTART; tok-1 < len(yyToknames); tok++ {
		if n := base + tok; n >= 0 && n < yyLast && yyChk[yyAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if yyDef[state] == -2 {
		i := 0
		for yyExca[i] != -1 || yyExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; yyExca[i] >= 0; i += 2 {
			tok := yyExca[i]
			if tok < TOKSTART || yyExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if yyExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += yyTokname(tok)
	}
	return res
}

func yylex1(lex yyLexer, lval *yySymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = yyTok1[0]
		goto out
	}
	if char < len(yyTok1) {
		token = yyTok1[char]
		goto out
	}
	if char >= yyPrivate {
		if char < yyPrivate+len(yyTok2) {
			token = yyTok2[char-yyPrivate]
			goto out
		}
	}
	for i := 0; i < len(yyTok3); i += 2 {
		token = yyTok3[i+0]
		if token == char {
			token = yyTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = yyTok2[1] /* unknown char */
	}
	if yyDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yyTokname(token), uint(char))
	}
	return char, token
}

func yyParse(yylex yyLexer) int {
	return yyNewParser().Parse(yylex)
}

func (yyrcvr *yyParserImpl) Parse(yylex yyLexer) int {
	var yyn int
	var yyVAL yySymType
	var yyDollar []yySymType
	_ = yyDollar // silence set and not used
	yyS := yyrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yystate := 0
	yyrcvr.char = -1
	yytoken := -1 // yyrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		yystate = -1
		yyrcvr.char = -1
		yytoken = -1
	}()
	yyp := -1
	goto yystack

ret0:
	return 0

ret1:
	return 1

yystack:
	/* put a state and value onto the stack */
	if yyDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yyTokname(yytoken), yyStatname(yystate))
	}

	yyp++
	if yyp >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyS[yyp] = yyVAL
	yyS[yyp].yys = yystate

yynewstate:
	yyn = yyPact[yystate]
	if yyn <= yyFlag {
		goto yydefault /* simple state */
	}
	if yyrcvr.char < 0 {
		yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
	}
	yyn += yytoken
	if yyn < 0 || yyn >= yyLast {
		goto yydefault
	}
	yyn = yyAct[yyn]
	if yyChk[yyn] == yytoken { /* valid shift */
		yyrcvr.char = -1
		yytoken = -1
		yyVAL = yyrcvr.lval
		yystate = yyn
		if Errflag > 0 {
			Errflag--
		}
		goto yystack
	}

yydefault:
	/* default state action */
	yyn = yyDef[yystate]
	if yyn == -2 {
		if yyrcvr.char < 0 {
			yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yyExca[xi+0] == -1 && yyExca[xi+1] == yystate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yyn = yyExca[xi+0]
			if yyn < 0 || yyn == yytoken {
				break
			}
		}
		yyn = yyExca[xi+1]
		if yyn < 0 {
			goto ret0
		}
	}
	if yyn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yylex.Error(yyErrorMessage(yystate, yytoken))
			Nerrs++
			if yyDebug >= 1 {
				__yyfmt__.Printf("%s", yyStatname(yystate))
				__yyfmt__.Printf(" saw %s\n", yyTokname(yytoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yyp >= 0 {
				yyn = yyPact[yyS[yyp].yys] + yyErrCode
				if yyn >= 0 && yyn < yyLast {
					yystate = yyAct[yyn] /* simulate a shift of "error" */
					if yyChk[yystate] == yyErrCode {
						goto yystack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yyDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yyS[yyp].yys)
				}
				yyp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yyDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yyTokname(yytoken))
			}
			if yytoken == yyEofCode {
				goto ret1
			}
			yyrcvr.char = -1
			yytoken = -1
			goto yynewstate /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if yyDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yyn, yyStatname(yystate))
	}

	yynt := yyn
	yypt := yyp
	_ = yypt // guard against "declared and not used"

	yyp -= yyR2[yyn]
	// yyp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if yyp+1 >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyVAL = yyS[yyp+1]

	/* consult goto table to find next state */
	yyn = yyR1[yyn]
	yyg := yyPgo[yyn]
	yyj := yyg + yyS[yyp].yys + 1

	if yyj >= yyLast {
		yystate = yyAct[yyg]
	} else {
		yystate = yyAct[yyj]
		if yyChk[yystate] != -yyn {
			yystate = yyAct[yyg]
		}
	}
	// dummy call; replaced with literal code
	switch yynt {

	case 1:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:302
		{
			setParseTree(yylex, yyDollar[1].statement)
		}
	case 2:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:307
		{
		}
	case 3:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:308
		{
		}
	case 4:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:312
		{
			yyVAL.statement = yyDollar[1].selStmt
		}
	case 22:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:335
		{
			sel := yyDollar[1].selStmt.(*Select)
			sel.OrderBy = yyDollar[2].orderBy
			sel.Limit = yyDollar[3].limit
			sel.Lock = yyDollar[4].str
			yyVAL.selStmt = sel
		}
	case 23:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:343
		{
			yyVAL.selStmt = &Union{Type: yyDollar[2].str, Left: yyDollar[1].selStmt, Right: yyDollar[3].selStmt, OrderBy: yyDollar[4].orderBy, Limit: yyDollar[5].limit, Lock: yyDollar[6].str}
		}
	case 24:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:347
		{
			yyVAL.selStmt = &Select{Comments: Comments(yyDollar[2].bytes2), Cache: yyDollar[3].str, SelectExprs: SelectExprs{Nextval{Expr: yyDollar[5].expr}}, From: TableExprs{&AliasedTableExpr{Expr: yyDollar[7].tableName}}}
		}
	case 25:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:353
		{
			yyVAL.statement = &Stream{Comments: Comments(yyDollar[2].bytes2), SelectExpr: yyDollar[3].selectExpr, Table: yyDollar[5].tableName}
		}
	case 26:
		yyDollar = yyS[yypt-10 : yypt+1]
		//line sql.y:360
		{
			yyVAL.selStmt = &Select{Comments: Comments(yyDollar[2].bytes2), Cache: yyDollar[3].str, Distinct: yyDollar[4].str, Hints: yyDollar[5].str, SelectExprs: yyDollar[6].selectExprs, From: yyDollar[7].tableExprs, Where: NewWhere(WhereStr, yyDollar[8].expr), GroupBy: GroupBy(yyDollar[9].exprs), Having: NewWhere(HavingStr, yyDollar[10].expr)}
		}
	case 27:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:366
		{
			yyVAL.selStmt = yyDollar[1].selStmt
		}
	case 28:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:370
		{
			yyVAL.selStmt = &ParenSelect{Select: yyDollar[2].selStmt}
		}
	case 29:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:376
		{
			yyVAL.selStmt = yyDollar[1].selStmt
		}
	case 30:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:380
		{
			yyVAL.selStmt = &ParenSelect{Select: yyDollar[2].selStmt}
		}
	case 31:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:387
		{
			// insert_data returns a *Insert pre-filled with Columns & Values
			ins := yyDollar[6].ins
			ins.Action = yyDollar[1].str
			ins.Comments = yyDollar[2].bytes2
			ins.Ignore = yyDollar[3].str
			ins.Table = yyDollar[4].tableName
			ins.Partitions = yyDollar[5].partitions
			ins.OnDup = OnDup(yyDollar[7].updateExprs)
			yyVAL.statement = ins
		}
	case 32:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:399
		{
			cols := make(Columns, 0, len(yyDollar[7].updateExprs))
			vals := make(ValTuple, 0, len(yyDollar[8].updateExprs))
			for _, updateList := range yyDollar[7].updateExprs {
				cols = append(cols, updateList.Name.Name)
				vals = append(vals, updateList.Expr)
			}
			yyVAL.statement = &Insert{Action: yyDollar[1].str, Comments: Comments(yyDollar[2].bytes2), Ignore: yyDollar[3].str, Table: yyDollar[4].tableName, Partitions: yyDollar[5].partitions, Columns: cols, Rows: Values{vals}, OnDup: OnDup(yyDollar[8].updateExprs)}
		}
	case 33:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:411
		{
			yyVAL.str = InsertStr
		}
	case 34:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:415
		{
			yyVAL.str = ReplaceStr
		}
	case 35:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:421
		{
			yyVAL.statement = &Update{Comments: Comments(yyDollar[2].bytes2), TableExprs: yyDollar[3].tableExprs, Exprs: yyDollar[5].updateExprs, Where: NewWhere(WhereStr, yyDollar[6].expr), OrderBy: yyDollar[7].orderBy, Limit: yyDollar[8].limit}
		}
	case 36:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:427
		{
			yyVAL.statement = &Delete{Comments: Comments(yyDollar[2].bytes2), TableExprs: TableExprs{&AliasedTableExpr{Expr: yyDollar[4].tableName}}, Partitions: yyDollar[5].partitions, Where: NewWhere(WhereStr, yyDollar[6].expr), OrderBy: yyDollar[7].orderBy, Limit: yyDollar[8].limit}
		}
	case 37:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:431
		{
			yyVAL.statement = &Delete{Comments: Comments(yyDollar[2].bytes2), Targets: yyDollar[4].tableNames, TableExprs: yyDollar[6].tableExprs, Where: NewWhere(WhereStr, yyDollar[7].expr)}
		}
	case 38:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:435
		{
			yyVAL.statement = &Delete{Comments: Comments(yyDollar[2].bytes2), Targets: yyDollar[3].tableNames, TableExprs: yyDollar[5].tableExprs, Where: NewWhere(WhereStr, yyDollar[6].expr)}
		}
	case 39:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:440
		{
		}
	case 40:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:441
		{
		}
	case 41:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:445
		{
			yyVAL.tableNames = TableNames{yyDollar[1].tableName}
		}
	case 42:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:449
		{
			yyVAL.tableNames = append(yyVAL.tableNames, yyDollar[3].tableName)
		}
	case 43:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:454
		{
			yyVAL.partitions = nil
		}
	case 44:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:458
		{
			yyVAL.partitions = yyDollar[3].partitions
		}
	case 45:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:464
		{
			yyVAL.statement = &Set{Comments: Comments(yyDollar[2].bytes2), Exprs: yyDollar[3].setExprs}
		}
	case 46:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:468
		{
			yyVAL.statement = &Set{Comments: Comments(yyDollar[2].bytes2), Scope: yyDollar[3].str, Exprs: yyDollar[4].setExprs}
		}
	case 47:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:472
		{
			yyVAL.statement = &Set{Comments: Comments(yyDollar[2].bytes2), Scope: yyDollar[3].str, Exprs: yyDollar[5].setExprs}
		}
	case 48:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:476
		{
			yyVAL.statement = &Set{Comments: Comments(yyDollar[2].bytes2), Exprs: yyDollar[4].setExprs}
		}
	case 49:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:482
		{
			yyVAL.setExprs = SetExprs{yyDollar[1].setExpr}
		}
	case 50:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:486
		{
			yyVAL.setExprs = append(yyVAL.setExprs, yyDollar[3].setExpr)
		}
	case 51:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:492
		{
			yyVAL.setExpr = yyDollar[3].setExpr
		}
	case 52:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:496
		{
			yyVAL.setExpr = &SetExpr{Name: NewColIdent("tx_read_only"), Expr: NewIntVal([]byte("0"))}
		}
	case 53:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:500
		{
			yyVAL.setExpr = &SetExpr{Name: NewColIdent("tx_read_only"), Expr: NewIntVal([]byte("1"))}
		}
	case 54:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:506
		{
			yyVAL.setExpr = &SetExpr{Name: NewColIdent("tx_isolation"), Expr: NewStrVal([]byte("repeatable read"))}
		}
	case 55:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:510
		{
			yyVAL.setExpr = &SetExpr{Name: NewColIdent("tx_isolation"), Expr: NewStrVal([]byte("read committed"))}
		}
	case 56:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:514
		{
			yyVAL.setExpr = &SetExpr{Name: NewColIdent("tx_isolation"), Expr: NewStrVal([]byte("read uncommitted"))}
		}
	case 57:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:518
		{
			yyVAL.setExpr = &SetExpr{Name: NewColIdent("tx_isolation"), Expr: NewStrVal([]byte("serializable"))}
		}
	case 58:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:524
		{
			yyVAL.str = SessionStr
		}
	case 59:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:528
		{
			yyVAL.str = GlobalStr
		}
	case 60:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:534
		{
			yyDollar[1].ddl.TableSpec = yyDollar[2].TableSpec
			yyVAL.statement = yyDollar[1].ddl
		}
	case 61:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:539
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[7].tableName, NewName: yyDollar[7].tableName}
		}
	case 62:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:544
		{
			yyVAL.statement = &DDL{Action: CreateStr, NewName: yyDollar[3].tableName.ToViewName()}
		}
	case 63:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:548
		{
			yyVAL.statement = &DDL{Action: CreateStr, NewName: yyDollar[5].tableName.ToViewName()}
		}
	case 64:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:552
		{
			yyVAL.statement = &DDL{Action: CreateVindexStr, VindexSpec: &VindexSpec{
				Name:   yyDollar[3].colIdent,
				Type:   yyDollar[4].colIdent,
				Params: yyDollar[5].vindexParams,
			}}
		}
	case 65:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:560
		{
			yyVAL.statement = &DBDDL{Action: CreateStr, DBName: string(yyDollar[4].bytes)}
		}
	case 66:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:564
		{
			yyVAL.statement = &DBDDL{Action: CreateStr, DBName: string(yyDollar[4].bytes)}
		}
	case 67:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:569
		{
			yyVAL.colIdent = NewColIdent("")
		}
	case 68:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:573
		{
			yyVAL.colIdent = yyDollar[2].colIdent
		}
	case 69:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:579
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 70:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:584
		{
			var v []VindexParam
			yyVAL.vindexParams = v
		}
	case 71:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:589
		{
			yyVAL.vindexParams = yyDollar[2].vindexParams
		}
	case 72:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:595
		{
			yyVAL.vindexParams = make([]VindexParam, 0, 4)
			yyVAL.vindexParams = append(yyVAL.vindexParams, yyDollar[1].vindexParam)
		}
	case 73:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:600
		{
			yyVAL.vindexParams = append(yyVAL.vindexParams, yyDollar[3].vindexParam)
		}
	case 74:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:606
		{
			yyVAL.vindexParam = VindexParam{Key: yyDollar[1].colIdent, Val: yyDollar[3].str}
		}
	case 75:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:612
		{
			yyVAL.ddl = &DDL{Action: CreateStr, NewName: yyDollar[4].tableName}
			setDDL(yylex, yyVAL.ddl)
		}
	case 76:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:619
		{
			yyVAL.TableSpec = yyDollar[2].TableSpec
			yyVAL.TableSpec.Options = yyDollar[4].str
		}
	case 77:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:626
		{
			yyVAL.TableSpec = &TableSpec{}
			yyVAL.TableSpec.AddColumn(yyDollar[1].columnDefinition)
		}
	case 78:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:631
		{
			yyVAL.TableSpec.AddColumn(yyDollar[3].columnDefinition)
		}
	case 79:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:635
		{
			yyVAL.TableSpec.AddIndex(yyDollar[3].indexDefinition)
		}
	case 80:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:641
		{
			yyDollar[2].columnType.NotNull = yyDollar[3].boolVal
			yyDollar[2].columnType.Default = yyDollar[4].optVal
			yyDollar[2].columnType.OnUpdate = yyDollar[5].optVal
			yyDollar[2].columnType.Autoincrement = yyDollar[6].boolVal
			yyDollar[2].columnType.KeyOpt = yyDollar[7].colKeyOpt
			yyDollar[2].columnType.Comment = yyDollar[8].optVal
			yyVAL.columnDefinition = &ColumnDefinition{Name: NewColIdent(string(yyDollar[1].bytes)), Type: yyDollar[2].columnType}
		}
	case 81:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:652
		{
			yyVAL.columnType = yyDollar[1].columnType
			yyVAL.columnType.Unsigned = yyDollar[2].boolVal
			yyVAL.columnType.Zerofill = yyDollar[3].boolVal
		}
	case 85:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:663
		{
			yyVAL.columnType = yyDollar[1].columnType
			yyVAL.columnType.Length = yyDollar[2].optVal
		}
	case 86:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:668
		{
			yyVAL.columnType = yyDollar[1].columnType
		}
	case 87:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:674
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 88:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:678
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 89:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:682
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 90:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:686
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 91:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:690
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 92:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:694
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 93:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:698
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 94:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:704
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
			yyVAL.columnType.Length = yyDollar[2].LengthScaleOption.Length
			yyVAL.columnType.Scale = yyDollar[2].LengthScaleOption.Scale
		}
	case 95:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:710
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
			yyVAL.columnType.Length = yyDollar[2].LengthScaleOption.Length
			yyVAL.columnType.Scale = yyDollar[2].LengthScaleOption.Scale
		}
	case 96:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:716
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
			yyVAL.columnType.Length = yyDollar[2].LengthScaleOption.Length
			yyVAL.columnType.Scale = yyDollar[2].LengthScaleOption.Scale
		}
	case 97:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:722
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
			yyVAL.columnType.Length = yyDollar[2].LengthScaleOption.Length
			yyVAL.columnType.Scale = yyDollar[2].LengthScaleOption.Scale
		}
	case 98:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:728
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
			yyVAL.columnType.Length = yyDollar[2].LengthScaleOption.Length
			yyVAL.columnType.Scale = yyDollar[2].LengthScaleOption.Scale
		}
	case 99:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:736
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 100:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:740
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 101:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:744
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 102:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:748
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 103:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:752
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 104:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:758
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal, Charset: yyDollar[3].str, Collate: yyDollar[4].str}
		}
	case 105:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:762
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal, Charset: yyDollar[3].str, Collate: yyDollar[4].str}
		}
	case 106:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:766
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 107:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:770
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 108:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:774
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Charset: yyDollar[2].str, Collate: yyDollar[3].str}
		}
	case 109:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:778
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Charset: yyDollar[2].str, Collate: yyDollar[3].str}
		}
	case 110:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:782
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Charset: yyDollar[2].str, Collate: yyDollar[3].str}
		}
	case 111:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:786
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), Charset: yyDollar[2].str, Collate: yyDollar[3].str}
		}
	case 112:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:790
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 113:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:794
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 114:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:798
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 115:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:802
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 116:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:806
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 117:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:810
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), EnumValues: yyDollar[3].strs, Charset: yyDollar[5].str, Collate: yyDollar[6].str}
		}
	case 118:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:815
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes), EnumValues: yyDollar[3].strs, Charset: yyDollar[5].str, Collate: yyDollar[6].str}
		}
	case 119:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:821
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 120:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:825
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 121:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:829
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 122:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:833
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 123:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:837
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 124:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:841
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 125:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:845
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 126:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:849
		{
			yyVAL.columnType = ColumnType{Type: string(yyDollar[1].bytes)}
		}
	case 127:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:855
		{
			yyVAL.strs = make([]string, 0, 4)
			yyVAL.strs = append(yyVAL.strs, "'"+string(yyDollar[1].bytes)+"'")
		}
	case 128:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:860
		{
			yyVAL.strs = append(yyDollar[1].strs, "'"+string(yyDollar[3].bytes)+"'")
		}
	case 129:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:865
		{
			yyVAL.optVal = nil
		}
	case 130:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:869
		{
			yyVAL.optVal = NewIntVal(yyDollar[2].bytes)
		}
	case 131:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:874
		{
			yyVAL.LengthScaleOption = LengthScaleOption{}
		}
	case 132:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:878
		{
			yyVAL.LengthScaleOption = LengthScaleOption{
				Length: NewIntVal(yyDollar[2].bytes),
				Scale:  NewIntVal(yyDollar[4].bytes),
			}
		}
	case 133:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:886
		{
			yyVAL.LengthScaleOption = LengthScaleOption{}
		}
	case 134:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:890
		{
			yyVAL.LengthScaleOption = LengthScaleOption{
				Length: NewIntVal(yyDollar[2].bytes),
			}
		}
	case 135:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:896
		{
			yyVAL.LengthScaleOption = LengthScaleOption{
				Length: NewIntVal(yyDollar[2].bytes),
				Scale:  NewIntVal(yyDollar[4].bytes),
			}
		}
	case 136:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:904
		{
			yyVAL.boolVal = BoolVal(false)
		}
	case 137:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:908
		{
			yyVAL.boolVal = BoolVal(true)
		}
	case 138:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:913
		{
			yyVAL.boolVal = BoolVal(false)
		}
	case 139:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:917
		{
			yyVAL.boolVal = BoolVal(true)
		}
	case 140:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:923
		{
			yyVAL.boolVal = BoolVal(false)
		}
	case 141:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:927
		{
			yyVAL.boolVal = BoolVal(false)
		}
	case 142:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:931
		{
			yyVAL.boolVal = BoolVal(true)
		}
	case 143:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:936
		{
			yyVAL.optVal = nil
		}
	case 144:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:940
		{
			yyVAL.optVal = NewStrVal(yyDollar[2].bytes)
		}
	case 145:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:944
		{
			yyVAL.optVal = NewIntVal(yyDollar[2].bytes)
		}
	case 146:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:948
		{
			yyVAL.optVal = NewFloatVal(yyDollar[2].bytes)
		}
	case 147:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:952
		{
			yyVAL.optVal = NewValArg(yyDollar[2].bytes)
		}
	case 148:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:956
		{
			yyVAL.optVal = NewValArg(yyDollar[2].bytes)
		}
	case 149:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:960
		{
			yyVAL.optVal = NewBitVal(yyDollar[2].bytes)
		}
	case 150:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:965
		{
			yyVAL.optVal = nil
		}
	case 151:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:969
		{
			yyVAL.optVal = NewValArg(yyDollar[3].bytes)
		}
	case 152:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:974
		{
			yyVAL.boolVal = BoolVal(false)
		}
	case 153:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:978
		{
			yyVAL.boolVal = BoolVal(true)
		}
	case 154:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:983
		{
			yyVAL.str = ""
		}
	case 155:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:987
		{
			yyVAL.str = string(yyDollar[3].bytes)
		}
	case 156:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:991
		{
			yyVAL.str = string(yyDollar[3].bytes)
		}
	case 157:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:996
		{
			yyVAL.str = ""
		}
	case 158:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1000
		{
			yyVAL.str = string(yyDollar[2].bytes)
		}
	case 159:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1005
		{
			yyVAL.colKeyOpt = colKeyNone
		}
	case 160:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1009
		{
			yyVAL.colKeyOpt = colKeyPrimary
		}
	case 161:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1013
		{
			yyVAL.colKeyOpt = colKey
		}
	case 162:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1017
		{
			yyVAL.colKeyOpt = colKeyUniqueKey
		}
	case 163:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1021
		{
			yyVAL.colKeyOpt = colKeyUnique
		}
	case 164:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1026
		{
			yyVAL.optVal = nil
		}
	case 165:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1030
		{
			yyVAL.optVal = NewStrVal(yyDollar[2].bytes)
		}
	case 166:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1036
		{
			yyVAL.indexDefinition = &IndexDefinition{Info: yyDollar[1].indexInfo, Columns: yyDollar[3].indexColumns, Options: yyDollar[5].indexOptions}
		}
	case 167:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1040
		{
			yyVAL.indexDefinition = &IndexDefinition{Info: yyDollar[1].indexInfo, Columns: yyDollar[3].indexColumns}
		}
	case 168:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1046
		{
			yyVAL.indexOptions = []*IndexOption{yyDollar[1].indexOption}
		}
	case 169:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1050
		{
			yyVAL.indexOptions = append(yyVAL.indexOptions, yyDollar[2].indexOption)
		}
	case 170:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1056
		{
			yyVAL.indexOption = &IndexOption{Name: string(yyDollar[1].bytes), Using: string(yyDollar[2].bytes)}
		}
	case 171:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1060
		{
			// should not be string
			yyVAL.indexOption = &IndexOption{Name: string(yyDollar[1].bytes), Value: NewIntVal(yyDollar[3].bytes)}
		}
	case 172:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1065
		{
			yyVAL.indexOption = &IndexOption{Name: string(yyDollar[1].bytes), Value: NewStrVal(yyDollar[2].bytes)}
		}
	case 173:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1071
		{
			yyVAL.str = ""
		}
	case 174:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1075
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 175:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1081
		{
			yyVAL.indexInfo = &IndexInfo{Type: string(yyDollar[1].bytes) + " " + string(yyDollar[2].bytes), Name: NewColIdent("PRIMARY"), Primary: true, Unique: true}
		}
	case 176:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1085
		{
			yyVAL.indexInfo = &IndexInfo{Type: string(yyDollar[1].bytes) + " " + string(yyDollar[2].str), Name: NewColIdent(string(yyDollar[3].bytes)), Spatial: true, Unique: false}
		}
	case 177:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1089
		{
			yyVAL.indexInfo = &IndexInfo{Type: string(yyDollar[1].bytes) + " " + string(yyDollar[2].str), Name: NewColIdent(string(yyDollar[3].bytes)), Unique: true}
		}
	case 178:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1093
		{
			yyVAL.indexInfo = &IndexInfo{Type: string(yyDollar[1].bytes), Name: NewColIdent(string(yyDollar[2].bytes)), Unique: true}
		}
	case 179:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1097
		{
			yyVAL.indexInfo = &IndexInfo{Type: string(yyDollar[1].str), Name: NewColIdent(string(yyDollar[2].bytes)), Unique: false}
		}
	case 180:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1103
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 181:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1107
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 182:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1113
		{
			yyVAL.indexColumns = []*IndexColumn{yyDollar[1].indexColumn}
		}
	case 183:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1117
		{
			yyVAL.indexColumns = append(yyVAL.indexColumns, yyDollar[3].indexColumn)
		}
	case 184:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1123
		{
			yyVAL.indexColumn = &IndexColumn{Column: yyDollar[1].colIdent, Length: yyDollar[2].optVal}
		}
	case 185:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1128
		{
			yyVAL.str = ""
		}
	case 186:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1132
		{
			yyVAL.str = " " + string(yyDollar[1].str)
		}
	case 187:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1136
		{
			yyVAL.str = string(yyDollar[1].str) + ", " + string(yyDollar[3].str)
		}
	case 188:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1144
		{
			yyVAL.str = yyDollar[1].str
		}
	case 189:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1148
		{
			yyVAL.str = yyDollar[1].str + " " + yyDollar[2].str
		}
	case 190:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1152
		{
			yyVAL.str = yyDollar[1].str + "=" + yyDollar[3].str
		}
	case 191:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1158
		{
			yyVAL.str = yyDollar[1].colIdent.String()
		}
	case 192:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1162
		{
			yyVAL.str = "'" + string(yyDollar[1].bytes) + "'"
		}
	case 193:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1166
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 194:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:1172
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[4].tableName, NewName: yyDollar[4].tableName}
		}
	case 195:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:1176
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[4].tableName, NewName: yyDollar[4].tableName}
		}
	case 196:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:1180
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[4].tableName, NewName: yyDollar[4].tableName}
		}
	case 197:
		yyDollar = yyS[yypt-12 : yypt+1]
		//line sql.y:1184
		{
			yyVAL.statement = &DDL{
				Action: AddColVindexStr,
				Table:  yyDollar[4].tableName,
				VindexSpec: &VindexSpec{
					Name:   yyDollar[7].colIdent,
					Type:   yyDollar[11].colIdent,
					Params: yyDollar[12].vindexParams,
				},
				VindexCols: yyDollar[9].columns,
			}
		}
	case 198:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:1197
		{
			yyVAL.statement = &DDL{
				Action: DropColVindexStr,
				Table:  yyDollar[4].tableName,
				VindexSpec: &VindexSpec{
					Name: yyDollar[7].colIdent,
				},
			}
		}
	case 199:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:1207
		{
			// Change this to a rename statement
			yyVAL.statement = &DDL{Action: RenameStr, Table: yyDollar[4].tableName, NewName: yyDollar[7].tableName}
		}
	case 200:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:1212
		{
			// Rename an index can just be an alter
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[4].tableName, NewName: yyDollar[4].tableName}
		}
	case 201:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1217
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[3].tableName.ToViewName(), NewName: yyDollar[3].tableName.ToViewName()}
		}
	case 202:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1221
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[4].tableName, PartitionSpec: yyDollar[5].partSpec}
		}
	case 214:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:1240
		{
			yyVAL.partSpec = &PartitionSpec{Action: ReorganizeStr, Name: yyDollar[3].colIdent, Definitions: yyDollar[6].partDefs}
		}
	case 215:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1246
		{
			yyVAL.partDefs = []*PartitionDefinition{yyDollar[1].partDef}
		}
	case 216:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1250
		{
			yyVAL.partDefs = append(yyDollar[1].partDefs, yyDollar[3].partDef)
		}
	case 217:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:1256
		{
			yyVAL.partDef = &PartitionDefinition{Name: yyDollar[2].colIdent, Limit: yyDollar[7].expr}
		}
	case 218:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:1260
		{
			yyVAL.partDef = &PartitionDefinition{Name: yyDollar[2].colIdent, Maxvalue: true}
		}
	case 219:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1266
		{
			yyVAL.statement = &DDL{Action: RenameStr, Table: yyDollar[3].tableName, NewName: yyDollar[5].tableName}
		}
	case 220:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1272
		{
			var exists bool
			if yyDollar[3].byt != 0 {
				exists = true
			}
			yyVAL.statement = &DDL{Action: DropStr, Table: yyDollar[4].tableName, IfExists: exists}
		}
	case 221:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:1280
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[5].tableName, NewName: yyDollar[5].tableName}
		}
	case 222:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1285
		{
			var exists bool
			if yyDollar[3].byt != 0 {
				exists = true
			}
			yyVAL.statement = &DDL{Action: DropStr, Table: yyDollar[4].tableName.ToViewName(), IfExists: exists}
		}
	case 223:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1293
		{
			yyVAL.statement = &DBDDL{Action: DropStr, DBName: string(yyDollar[4].bytes)}
		}
	case 224:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1297
		{
			yyVAL.statement = &DBDDL{Action: DropStr, DBName: string(yyDollar[4].bytes)}
		}
	case 225:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1303
		{
			yyVAL.statement = &DDL{Action: TruncateStr, Table: yyDollar[3].tableName}
		}
	case 226:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1307
		{
			yyVAL.statement = &DDL{Action: TruncateStr, Table: yyDollar[2].tableName}
		}
	case 227:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1312
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[3].tableName, NewName: yyDollar[3].tableName}
		}
	case 228:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1318
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 229:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1322
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 230:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1326
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 231:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1331
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 232:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1335
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 233:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1339
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 234:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1343
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 235:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1347
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes) + " " + string(yyDollar[3].bytes)}
		}
	case 236:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1351
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 237:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1355
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 238:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1359
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 239:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1363
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 240:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1367
		{
			yyVAL.statement = &Show{Scope: yyDollar[2].str, Type: string(yyDollar[3].bytes)}
		}
	case 241:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1371
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 242:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:1375
		{
			// this is ugly, but I couldn't find a better way for now
			if yyDollar[4].str == "processlist" {
				yyVAL.statement = &Show{Type: yyDollar[4].str}
			} else {
				showTablesOpt := &ShowTablesOpt{Extended: yyDollar[2].str, Full: yyDollar[3].str, DbName: yyDollar[5].str, Filter: yyDollar[6].showFilter}
				yyVAL.statement = &Show{Type: yyDollar[4].str, ShowTablesOpt: showTablesOpt}
			}
		}
	case 243:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1385
		{
			yyVAL.statement = &Show{Scope: yyDollar[2].str, Type: string(yyDollar[3].bytes)}
		}
	case 244:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1389
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 245:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1393
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes), OnTable: yyDollar[4].tableName}
		}
	case 246:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1397
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 247:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1401
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 248:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1405
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 249:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1409
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 250:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1419
		{
			yyVAL.statement = &Show{Type: string(yyDollar[2].bytes)}
		}
	case 251:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1425
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 252:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1429
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 253:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1435
		{
			yyVAL.str = ""
		}
	case 254:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1439
		{
			yyVAL.str = "extended "
		}
	case 255:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1445
		{
			yyVAL.str = ""
		}
	case 256:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1449
		{
			yyVAL.str = "full "
		}
	case 257:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1455
		{
			yyVAL.str = ""
		}
	case 258:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1459
		{
			yyVAL.str = yyDollar[2].tableIdent.v
		}
	case 259:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1463
		{
			yyVAL.str = yyDollar[2].tableIdent.v
		}
	case 260:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1469
		{
			yyVAL.showFilter = nil
		}
	case 261:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1473
		{
			yyVAL.showFilter = &ShowFilter{Like: string(yyDollar[2].bytes)}
		}
	case 262:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1477
		{
			yyVAL.showFilter = &ShowFilter{Filter: yyDollar[2].expr}
		}
	case 263:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1483
		{
			yyVAL.str = ""
		}
	case 264:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1487
		{
			yyVAL.str = SessionStr
		}
	case 265:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1491
		{
			yyVAL.str = GlobalStr
		}
	case 266:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1497
		{
			yyVAL.statement = &Use{DBName: yyDollar[2].tableIdent}
		}
	case 267:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1501
		{
			yyVAL.statement = &Use{DBName: TableIdent{v: ""}}
		}
	case 268:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1507
		{
			yyVAL.statement = &Begin{}
		}
	case 269:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1511
		{
			yyVAL.statement = &Begin{}
		}
	case 270:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1517
		{
			yyVAL.statement = &Commit{}
		}
	case 271:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1523
		{
			yyVAL.statement = &Rollback{}
		}
	case 272:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1529
		{
			yyVAL.statement = &OtherRead{}
		}
	case 273:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1533
		{
			yyVAL.statement = &OtherRead{}
		}
	case 274:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1537
		{
			yyVAL.statement = &OtherRead{}
		}
	case 275:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1541
		{
			yyVAL.statement = &OtherAdmin{}
		}
	case 276:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1545
		{
			yyVAL.statement = &OtherAdmin{}
		}
	case 277:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1550
		{
			setAllowComments(yylex, true)
		}
	case 278:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1554
		{
			yyVAL.bytes2 = yyDollar[2].bytes2
			setAllowComments(yylex, false)
		}
	case 279:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1560
		{
			yyVAL.bytes2 = nil
		}
	case 280:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1564
		{
			yyVAL.bytes2 = append(yyDollar[1].bytes2, yyDollar[2].bytes)
		}
	case 281:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1570
		{
			yyVAL.str = UnionStr
		}
	case 282:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1574
		{
			yyVAL.str = UnionAllStr
		}
	case 283:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1578
		{
			yyVAL.str = UnionDistinctStr
		}
	case 284:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1583
		{
			yyVAL.str = ""
		}
	case 285:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1587
		{
			yyVAL.str = SQLNoCacheStr
		}
	case 286:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1591
		{
			yyVAL.str = SQLCacheStr
		}
	case 287:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1596
		{
			yyVAL.str = ""
		}
	case 288:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1600
		{
			yyVAL.str = DistinctStr
		}
	case 289:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1605
		{
			yyVAL.str = ""
		}
	case 290:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1609
		{
			yyVAL.str = StraightJoinHint
		}
	case 291:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1614
		{
			yyVAL.selectExprs = nil
		}
	case 292:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1618
		{
			yyVAL.selectExprs = yyDollar[1].selectExprs
		}
	case 293:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1624
		{
			yyVAL.selectExprs = SelectExprs{yyDollar[1].selectExpr}
		}
	case 294:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1628
		{
			yyVAL.selectExprs = append(yyVAL.selectExprs, yyDollar[3].selectExpr)
		}
	case 295:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1634
		{
			yyVAL.selectExpr = &StarExpr{}
		}
	case 296:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1638
		{
			yyVAL.selectExpr = &AliasedExpr{Expr: yyDollar[1].expr, As: yyDollar[2].colIdent}
		}
	case 297:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1642
		{
			yyVAL.selectExpr = &StarExpr{TableName: TableName{Name: yyDollar[1].tableIdent}}
		}
	case 298:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1646
		{
			yyVAL.selectExpr = &StarExpr{TableName: TableName{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].tableIdent}}
		}
	case 299:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1651
		{
			yyVAL.colIdent = ColIdent{}
		}
	case 300:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1655
		{
			yyVAL.colIdent = yyDollar[1].colIdent
		}
	case 301:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1659
		{
			yyVAL.colIdent = yyDollar[2].colIdent
		}
	case 303:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1666
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 304:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1671
		{
			yyVAL.tableExprs = TableExprs{&AliasedTableExpr{Expr: TableName{Name: NewTableIdent("dual")}}}
		}
	case 305:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1675
		{
			yyVAL.tableExprs = yyDollar[2].tableExprs
		}
	case 306:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1681
		{
			yyVAL.tableExprs = TableExprs{yyDollar[1].tableExpr}
		}
	case 307:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1685
		{
			yyVAL.tableExprs = append(yyVAL.tableExprs, yyDollar[3].tableExpr)
		}
	case 310:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1695
		{
			yyVAL.tableExpr = yyDollar[1].aliasedTableName
		}
	case 311:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1699
		{
			yyVAL.tableExpr = &AliasedTableExpr{Expr: yyDollar[1].subquery, As: yyDollar[3].tableIdent}
		}
	case 312:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1703
		{
			yyVAL.tableExpr = &ParenTableExpr{Exprs: yyDollar[2].tableExprs}
		}
	case 313:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1709
		{
			yyVAL.aliasedTableName = &AliasedTableExpr{Expr: yyDollar[1].tableName, As: yyDollar[2].tableIdent, Hints: yyDollar[3].indexHints}
		}
	case 314:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:1713
		{
			yyVAL.aliasedTableName = &AliasedTableExpr{Expr: yyDollar[1].tableName, Partitions: yyDollar[4].partitions, As: yyDollar[6].tableIdent, Hints: yyDollar[7].indexHints}
		}
	case 315:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1719
		{
			yyVAL.columns = Columns{yyDollar[1].colIdent}
		}
	case 316:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1723
		{
			yyVAL.columns = append(yyVAL.columns, yyDollar[3].colIdent)
		}
	case 317:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1729
		{
			yyVAL.partitions = Partitions{yyDollar[1].colIdent}
		}
	case 318:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1733
		{
			yyVAL.partitions = append(yyVAL.partitions, yyDollar[3].colIdent)
		}
	case 319:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1746
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr, Condition: yyDollar[4].joinCondition}
		}
	case 320:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1750
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr, Condition: yyDollar[4].joinCondition}
		}
	case 321:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1754
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr, Condition: yyDollar[4].joinCondition}
		}
	case 322:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1758
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr}
		}
	case 323:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1764
		{
			yyVAL.joinCondition = JoinCondition{On: yyDollar[2].expr}
		}
	case 324:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1766
		{
			yyVAL.joinCondition = JoinCondition{Using: yyDollar[3].columns}
		}
	case 325:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1770
		{
			yyVAL.joinCondition = JoinCondition{}
		}
	case 326:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1772
		{
			yyVAL.joinCondition = yyDollar[1].joinCondition
		}
	case 327:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1776
		{
			yyVAL.joinCondition = JoinCondition{}
		}
	case 328:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1778
		{
			yyVAL.joinCondition = JoinCondition{On: yyDollar[2].expr}
		}
	case 329:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1781
		{
			yyVAL.empty = struct{}{}
		}
	case 330:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1783
		{
			yyVAL.empty = struct{}{}
		}
	case 331:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1786
		{
			yyVAL.tableIdent = NewTableIdent("")
		}
	case 332:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1790
		{
			yyVAL.tableIdent = yyDollar[1].tableIdent
		}
	case 333:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1794
		{
			yyVAL.tableIdent = yyDollar[2].tableIdent
		}
	case 335:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1801
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 336:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1807
		{
			yyVAL.str = JoinStr
		}
	case 337:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1811
		{
			yyVAL.str = JoinStr
		}
	case 338:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1815
		{
			yyVAL.str = JoinStr
		}
	case 339:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1821
		{
			yyVAL.str = StraightJoinStr
		}
	case 340:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1827
		{
			yyVAL.str = LeftJoinStr
		}
	case 341:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1831
		{
			yyVAL.str = LeftJoinStr
		}
	case 342:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1835
		{
			yyVAL.str = RightJoinStr
		}
	case 343:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1839
		{
			yyVAL.str = RightJoinStr
		}
	case 344:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1845
		{
			yyVAL.str = NaturalJoinStr
		}
	case 345:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1849
		{
			if yyDollar[2].str == LeftJoinStr {
				yyVAL.str = NaturalLeftJoinStr
			} else {
				yyVAL.str = NaturalRightJoinStr
			}
		}
	case 346:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1859
		{
			yyVAL.tableName = yyDollar[2].tableName
		}
	case 347:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1863
		{
			yyVAL.tableName = yyDollar[1].tableName
		}
	case 348:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1869
		{
			yyVAL.tableName = TableName{Name: yyDollar[1].tableIdent}
		}
	case 349:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1873
		{
			yyVAL.tableName = TableName{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].tableIdent}
		}
	case 350:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1878
		{
			yyVAL.indexHints = nil
		}
	case 351:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1882
		{
			yyVAL.indexHints = &IndexHints{Type: UseStr, Indexes: yyDollar[4].columns}
		}
	case 352:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1886
		{
			yyVAL.indexHints = &IndexHints{Type: IgnoreStr, Indexes: yyDollar[4].columns}
		}
	case 353:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1890
		{
			yyVAL.indexHints = &IndexHints{Type: ForceStr, Indexes: yyDollar[4].columns}
		}
	case 354:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1895
		{
			yyVAL.expr = nil
		}
	case 355:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1899
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 356:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1905
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 357:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1909
		{
			yyVAL.expr = &AndExpr{Left: yyDollar[1].expr, Right: yyDollar[3].expr}
		}
	case 358:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1913
		{
			yyVAL.expr = &OrExpr{Left: yyDollar[1].expr, Right: yyDollar[3].expr}
		}
	case 359:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1917
		{
			yyVAL.expr = &NotExpr{Expr: yyDollar[2].expr}
		}
	case 360:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1921
		{
			yyVAL.expr = &IsExpr{Operator: yyDollar[3].str, Expr: yyDollar[1].expr}
		}
	case 361:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1925
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 362:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1929
		{
			yyVAL.expr = &Default{ColName: yyDollar[2].str}
		}
	case 363:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:1935
		{
			yyVAL.str = ""
		}
	case 364:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1939
		{
			yyVAL.str = string(yyDollar[2].bytes)
		}
	case 365:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1945
		{
			yyVAL.boolVal = BoolVal(true)
		}
	case 366:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1949
		{
			yyVAL.boolVal = BoolVal(false)
		}
	case 367:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1955
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: yyDollar[2].str, Right: yyDollar[3].expr}
		}
	case 368:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1959
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: InStr, Right: yyDollar[3].colTuple}
		}
	case 369:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1963
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: NotInStr, Right: yyDollar[4].colTuple}
		}
	case 370:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1967
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: LikeStr, Right: yyDollar[3].expr, Escape: yyDollar[4].expr}
		}
	case 371:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1971
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: NotLikeStr, Right: yyDollar[4].expr, Escape: yyDollar[5].expr}
		}
	case 372:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:1975
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: RegexpStr, Right: yyDollar[3].expr}
		}
	case 373:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:1979
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: NotRegexpStr, Right: yyDollar[4].expr}
		}
	case 374:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:1983
		{
			yyVAL.expr = &RangeCond{Left: yyDollar[1].expr, Operator: BetweenStr, From: yyDollar[3].expr, To: yyDollar[5].expr}
		}
	case 375:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:1987
		{
			yyVAL.expr = &RangeCond{Left: yyDollar[1].expr, Operator: NotBetweenStr, From: yyDollar[4].expr, To: yyDollar[6].expr}
		}
	case 376:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:1991
		{
			yyVAL.expr = &ExistsExpr{Subquery: yyDollar[2].subquery}
		}
	case 377:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:1997
		{
			yyVAL.str = IsNullStr
		}
	case 378:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2001
		{
			yyVAL.str = IsNotNullStr
		}
	case 379:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2005
		{
			yyVAL.str = IsTrueStr
		}
	case 380:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2009
		{
			yyVAL.str = IsNotTrueStr
		}
	case 381:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2013
		{
			yyVAL.str = IsFalseStr
		}
	case 382:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2017
		{
			yyVAL.str = IsNotFalseStr
		}
	case 383:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2023
		{
			yyVAL.str = EqualStr
		}
	case 384:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2027
		{
			yyVAL.str = LessThanStr
		}
	case 385:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2031
		{
			yyVAL.str = GreaterThanStr
		}
	case 386:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2035
		{
			yyVAL.str = LessEqualStr
		}
	case 387:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2039
		{
			yyVAL.str = GreaterEqualStr
		}
	case 388:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2043
		{
			yyVAL.str = NotEqualStr
		}
	case 389:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2047
		{
			yyVAL.str = NullSafeEqualStr
		}
	case 390:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2052
		{
			yyVAL.expr = nil
		}
	case 391:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2056
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 392:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2062
		{
			yyVAL.colTuple = yyDollar[1].valTuple
		}
	case 393:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2066
		{
			yyVAL.colTuple = yyDollar[1].subquery
		}
	case 394:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2070
		{
			yyVAL.colTuple = ListArg(yyDollar[1].bytes)
		}
	case 395:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2076
		{
			yyVAL.subquery = &Subquery{yyDollar[2].selStmt}
		}
	case 396:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2082
		{
			yyVAL.exprs = Exprs{yyDollar[1].expr}
		}
	case 397:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2086
		{
			yyVAL.exprs = append(yyDollar[1].exprs, yyDollar[3].expr)
		}
	case 398:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2092
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 399:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2096
		{
			yyVAL.expr = yyDollar[1].boolVal
		}
	case 400:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2100
		{
			yyVAL.expr = yyDollar[1].colName
		}
	case 401:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2104
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 402:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2108
		{
			yyVAL.expr = yyDollar[1].subquery
		}
	case 403:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2112
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: BitAndStr, Right: yyDollar[3].expr}
		}
	case 404:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2116
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: BitOrStr, Right: yyDollar[3].expr}
		}
	case 405:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2120
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: BitXorStr, Right: yyDollar[3].expr}
		}
	case 406:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2124
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: PlusStr, Right: yyDollar[3].expr}
		}
	case 407:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2128
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: MinusStr, Right: yyDollar[3].expr}
		}
	case 408:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2132
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: MultStr, Right: yyDollar[3].expr}
		}
	case 409:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2136
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: DivStr, Right: yyDollar[3].expr}
		}
	case 410:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2140
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: IntDivStr, Right: yyDollar[3].expr}
		}
	case 411:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2144
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ModStr, Right: yyDollar[3].expr}
		}
	case 412:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2148
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ModStr, Right: yyDollar[3].expr}
		}
	case 413:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2152
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ShiftLeftStr, Right: yyDollar[3].expr}
		}
	case 414:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2156
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ShiftRightStr, Right: yyDollar[3].expr}
		}
	case 415:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2160
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].colName, Operator: JSONExtractOp, Right: yyDollar[3].expr}
		}
	case 416:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2164
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].colName, Operator: JSONUnquoteExtractOp, Right: yyDollar[3].expr}
		}
	case 417:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2168
		{
			yyVAL.expr = &CollateExpr{Expr: yyDollar[1].expr, Charset: yyDollar[3].str}
		}
	case 418:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2172
		{
			yyVAL.expr = &UnaryExpr{Operator: BinaryStr, Expr: yyDollar[2].expr}
		}
	case 419:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2176
		{
			yyVAL.expr = &UnaryExpr{Operator: UBinaryStr, Expr: yyDollar[2].expr}
		}
	case 420:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2180
		{
			if num, ok := yyDollar[2].expr.(*SQLVal); ok && num.Type == IntVal {
				yyVAL.expr = num
			} else {
				yyVAL.expr = &UnaryExpr{Operator: UPlusStr, Expr: yyDollar[2].expr}
			}
		}
	case 421:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2188
		{
			if num, ok := yyDollar[2].expr.(*SQLVal); ok && num.Type == IntVal {
				// Handle double negative
				if num.Val[0] == '-' {
					num.Val = num.Val[1:]
					yyVAL.expr = num
				} else {
					yyVAL.expr = NewIntVal(append([]byte("-"), num.Val...))
				}
			} else {
				yyVAL.expr = &UnaryExpr{Operator: UMinusStr, Expr: yyDollar[2].expr}
			}
		}
	case 422:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2202
		{
			yyVAL.expr = &UnaryExpr{Operator: TildaStr, Expr: yyDollar[2].expr}
		}
	case 423:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2206
		{
			yyVAL.expr = &UnaryExpr{Operator: BangStr, Expr: yyDollar[2].expr}
		}
	case 424:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2210
		{
			// This rule prevents the usage of INTERVAL
			// as a function. If support is needed for that,
			// we'll need to revisit this. The solution
			// will be non-trivial because of grammar conflicts.
			yyVAL.expr = &IntervalExpr{Expr: yyDollar[2].expr, Unit: yyDollar[3].colIdent.String()}
		}
	case 429:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2228
		{
			yyVAL.expr = &FuncExpr{Name: yyDollar[1].colIdent, Exprs: yyDollar[3].selectExprs}
		}
	case 430:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:2232
		{
			yyVAL.expr = &FuncExpr{Name: yyDollar[1].colIdent, Distinct: true, Exprs: yyDollar[4].selectExprs}
		}
	case 431:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:2236
		{
			yyVAL.expr = &FuncExpr{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].colIdent, Exprs: yyDollar[5].selectExprs}
		}
	case 432:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2246
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("left"), Exprs: yyDollar[3].selectExprs}
		}
	case 433:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2250
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("right"), Exprs: yyDollar[3].selectExprs}
		}
	case 434:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:2254
		{
			yyVAL.expr = &ConvertExpr{Expr: yyDollar[3].expr, Type: yyDollar[5].convertType}
		}
	case 435:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:2258
		{
			yyVAL.expr = &ConvertExpr{Expr: yyDollar[3].expr, Type: yyDollar[5].convertType}
		}
	case 436:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:2262
		{
			yyVAL.expr = &ConvertUsingExpr{Expr: yyDollar[3].expr, Type: yyDollar[5].str}
		}
	case 437:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:2266
		{
			yyVAL.expr = &SubstrExpr{Name: yyDollar[3].colName, From: yyDollar[5].expr, To: nil}
		}
	case 438:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:2270
		{
			yyVAL.expr = &SubstrExpr{Name: yyDollar[3].colName, From: yyDollar[5].expr, To: yyDollar[7].expr}
		}
	case 439:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:2274
		{
			yyVAL.expr = &SubstrExpr{Name: yyDollar[3].colName, From: yyDollar[5].expr, To: yyDollar[7].expr}
		}
	case 440:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:2278
		{
			yyVAL.expr = &SubstrExpr{Name: yyDollar[3].colName, From: yyDollar[5].expr, To: nil}
		}
	case 441:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:2282
		{
			yyVAL.expr = &SubstrExpr{Name: yyDollar[3].colName, From: yyDollar[5].expr, To: yyDollar[7].expr}
		}
	case 442:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line sql.y:2286
		{
			yyVAL.expr = &SubstrExpr{Name: yyDollar[3].colName, From: yyDollar[5].expr, To: yyDollar[7].expr}
		}
	case 443:
		yyDollar = yyS[yypt-9 : yypt+1]
		//line sql.y:2290
		{
			yyVAL.expr = &MatchExpr{Columns: yyDollar[3].selectExprs, Expr: yyDollar[7].expr, Option: yyDollar[8].str}
		}
	case 444:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:2294
		{
			yyVAL.expr = &GroupConcatExpr{Distinct: yyDollar[3].str, Exprs: yyDollar[4].selectExprs, OrderBy: yyDollar[5].orderBy, Separator: yyDollar[6].str}
		}
	case 445:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:2298
		{
			yyVAL.expr = &CaseExpr{Expr: yyDollar[2].expr, Whens: yyDollar[3].whens, Else: yyDollar[4].expr}
		}
	case 446:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2302
		{
			yyVAL.expr = &ValuesFuncExpr{Name: yyDollar[3].colName}
		}
	case 447:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2312
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("current_timestamp")}
		}
	case 448:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2316
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("utc_timestamp")}
		}
	case 449:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2320
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("utc_time")}
		}
	case 450:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2324
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("utc_date")}
		}
	case 451:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2329
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("localtime")}
		}
	case 452:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2334
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("localtimestamp")}
		}
	case 453:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2339
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("current_date")}
		}
	case 454:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2344
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("current_time")}
		}
	case 457:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2358
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("if"), Exprs: yyDollar[3].selectExprs}
		}
	case 458:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2362
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("database"), Exprs: yyDollar[3].selectExprs}
		}
	case 459:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2366
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("mod"), Exprs: yyDollar[3].selectExprs}
		}
	case 460:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2370
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("replace"), Exprs: yyDollar[3].selectExprs}
		}
	case 461:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2376
		{
			yyVAL.str = ""
		}
	case 462:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2380
		{
			yyVAL.str = BooleanModeStr
		}
	case 463:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2384
		{
			yyVAL.str = NaturalLanguageModeStr
		}
	case 464:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line sql.y:2388
		{
			yyVAL.str = NaturalLanguageModeWithQueryExpansionStr
		}
	case 465:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2392
		{
			yyVAL.str = QueryExpansionStr
		}
	case 466:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2398
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 467:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2402
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 468:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2408
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 469:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2412
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal, Charset: yyDollar[3].str, Operator: CharacterSetStr}
		}
	case 470:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2416
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal, Charset: string(yyDollar[3].bytes)}
		}
	case 471:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2420
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes)}
		}
	case 472:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2424
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 473:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2428
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes)}
			yyVAL.convertType.Length = yyDollar[2].LengthScaleOption.Length
			yyVAL.convertType.Scale = yyDollar[2].LengthScaleOption.Scale
		}
	case 474:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2434
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes)}
		}
	case 475:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2438
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 476:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2442
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes)}
		}
	case 477:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2446
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes)}
		}
	case 478:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2450
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes), Length: yyDollar[2].optVal}
		}
	case 479:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2454
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes)}
		}
	case 480:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2458
		{
			yyVAL.convertType = &ConvertType{Type: string(yyDollar[1].bytes)}
		}
	case 481:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2463
		{
			yyVAL.expr = nil
		}
	case 482:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2467
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 483:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2472
		{
			yyVAL.str = string("")
		}
	case 484:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2476
		{
			yyVAL.str = " separator '" + string(yyDollar[2].bytes) + "'"
		}
	case 485:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2482
		{
			yyVAL.whens = []*When{yyDollar[1].when}
		}
	case 486:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2486
		{
			yyVAL.whens = append(yyDollar[1].whens, yyDollar[2].when)
		}
	case 487:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2492
		{
			yyVAL.when = &When{Cond: yyDollar[2].expr, Val: yyDollar[4].expr}
		}
	case 488:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2497
		{
			yyVAL.expr = nil
		}
	case 489:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2501
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 490:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2507
		{
			yyVAL.colName = &ColName{Name: yyDollar[1].colIdent}
		}
	case 491:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2511
		{
			yyVAL.colName = &ColName{Qualifier: TableName{Name: yyDollar[1].tableIdent}, Name: yyDollar[3].colIdent}
		}
	case 492:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:2515
		{
			yyVAL.colName = &ColName{Qualifier: TableName{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].tableIdent}, Name: yyDollar[5].colIdent}
		}
	case 493:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2521
		{
			yyVAL.expr = NewStrVal(yyDollar[1].bytes)
		}
	case 494:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2525
		{
			yyVAL.expr = NewHexVal(yyDollar[1].bytes)
		}
	case 495:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2529
		{
			yyVAL.expr = NewBitVal(yyDollar[1].bytes)
		}
	case 496:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2533
		{
			yyVAL.expr = NewIntVal(yyDollar[1].bytes)
		}
	case 497:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2537
		{
			yyVAL.expr = NewFloatVal(yyDollar[1].bytes)
		}
	case 498:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2541
		{
			yyVAL.expr = NewHexNum(yyDollar[1].bytes)
		}
	case 499:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2545
		{
			yyVAL.expr = NewValArg(yyDollar[1].bytes)
		}
	case 500:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2549
		{
			yyVAL.expr = &NullVal{}
		}
	case 501:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2555
		{
			// TODO(sougou): Deprecate this construct.
			if yyDollar[1].colIdent.Lowered() != "value" {
				yylex.Error("expecting value after next")
				return 1
			}
			yyVAL.expr = NewIntVal([]byte("1"))
		}
	case 502:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2564
		{
			yyVAL.expr = NewIntVal(yyDollar[1].bytes)
		}
	case 503:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2568
		{
			yyVAL.expr = NewValArg(yyDollar[1].bytes)
		}
	case 504:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2573
		{
			yyVAL.exprs = nil
		}
	case 505:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2577
		{
			yyVAL.exprs = yyDollar[3].exprs
		}
	case 506:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2582
		{
			yyVAL.expr = nil
		}
	case 507:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2586
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 508:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2591
		{
			yyVAL.orderBy = nil
		}
	case 509:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2595
		{
			yyVAL.orderBy = yyDollar[3].orderBy
		}
	case 510:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2601
		{
			yyVAL.orderBy = OrderBy{yyDollar[1].order}
		}
	case 511:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2605
		{
			yyVAL.orderBy = append(yyDollar[1].orderBy, yyDollar[3].order)
		}
	case 512:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2611
		{
			yyVAL.order = &Order{Expr: yyDollar[1].expr, Direction: yyDollar[2].str}
		}
	case 513:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2616
		{
			yyVAL.str = AscScr
		}
	case 514:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2620
		{
			yyVAL.str = AscScr
		}
	case 515:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2624
		{
			yyVAL.str = DescScr
		}
	case 516:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2629
		{
			yyVAL.limit = nil
		}
	case 517:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2633
		{
			yyVAL.limit = &Limit{Rowcount: yyDollar[2].expr}
		}
	case 518:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2637
		{
			yyVAL.limit = &Limit{Offset: yyDollar[2].expr, Rowcount: yyDollar[4].expr}
		}
	case 519:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2641
		{
			yyVAL.limit = &Limit{Offset: yyDollar[4].expr, Rowcount: yyDollar[2].expr}
		}
	case 520:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2646
		{
			yyVAL.str = ""
		}
	case 521:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2650
		{
			yyVAL.str = ForUpdateStr
		}
	case 522:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2654
		{
			yyVAL.str = ShareModeStr
		}
	case 523:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2667
		{
			yyVAL.ins = &Insert{Rows: yyDollar[2].values}
		}
	case 524:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2671
		{
			yyVAL.ins = &Insert{Rows: yyDollar[1].selStmt}
		}
	case 525:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2675
		{
			// Drop the redundant parenthesis.
			yyVAL.ins = &Insert{Rows: yyDollar[2].selStmt}
		}
	case 526:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:2680
		{
			yyVAL.ins = &Insert{Columns: yyDollar[2].columns, Rows: yyDollar[5].values}
		}
	case 527:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line sql.y:2684
		{
			yyVAL.ins = &Insert{Columns: yyDollar[2].columns, Rows: yyDollar[4].selStmt}
		}
	case 528:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line sql.y:2688
		{
			// Drop the redundant parenthesis.
			yyVAL.ins = &Insert{Columns: yyDollar[2].columns, Rows: yyDollar[5].selStmt}
		}
	case 529:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2695
		{
			yyVAL.columns = Columns{yyDollar[1].colIdent}
		}
	case 530:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2699
		{
			yyVAL.columns = Columns{yyDollar[3].colIdent}
		}
	case 531:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2703
		{
			yyVAL.columns = append(yyVAL.columns, yyDollar[3].colIdent)
		}
	case 532:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:2707
		{
			yyVAL.columns = append(yyVAL.columns, yyDollar[5].colIdent)
		}
	case 533:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2712
		{
			yyVAL.updateExprs = nil
		}
	case 534:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line sql.y:2716
		{
			yyVAL.updateExprs = yyDollar[5].updateExprs
		}
	case 535:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2722
		{
			yyVAL.values = Values{yyDollar[1].valTuple}
		}
	case 536:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2726
		{
			yyVAL.values = append(yyDollar[1].values, yyDollar[3].valTuple)
		}
	case 537:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2732
		{
			yyVAL.valTuple = yyDollar[1].valTuple
		}
	case 538:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2736
		{
			yyVAL.valTuple = ValTuple{}
		}
	case 539:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2742
		{
			yyVAL.valTuple = ValTuple(yyDollar[2].exprs)
		}
	case 540:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2748
		{
			if len(yyDollar[1].valTuple) == 1 {
				yyVAL.expr = &ParenExpr{yyDollar[1].valTuple[0]}
			} else {
				yyVAL.expr = yyDollar[1].valTuple
			}
		}
	case 541:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2758
		{
			yyVAL.updateExprs = UpdateExprs{yyDollar[1].updateExpr}
		}
	case 542:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2762
		{
			yyVAL.updateExprs = append(yyDollar[1].updateExprs, yyDollar[3].updateExpr)
		}
	case 543:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2768
		{
			yyVAL.updateExpr = &UpdateExpr{Name: yyDollar[1].colName, Expr: yyDollar[3].expr}
		}
	case 544:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2774
		{
			yyVAL.setExprs = SetExprs{yyDollar[1].setExpr}
		}
	case 545:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2778
		{
			yyVAL.setExprs = append(yyDollar[1].setExprs, yyDollar[3].setExpr)
		}
	case 546:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2784
		{
			yyVAL.setExpr = &SetExpr{Name: yyDollar[1].colIdent, Expr: NewStrVal([]byte("on"))}
		}
	case 547:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2788
		{
			yyVAL.setExpr = &SetExpr{Name: yyDollar[1].colIdent, Expr: yyDollar[3].expr}
		}
	case 548:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2792
		{
			yyVAL.setExpr = &SetExpr{Name: NewColIdent(string(yyDollar[1].bytes)), Expr: yyDollar[2].expr}
		}
	case 550:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2799
		{
			yyVAL.bytes = []byte("charset")
		}
	case 552:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2806
		{
			yyVAL.expr = NewStrVal([]byte(yyDollar[1].colIdent.String()))
		}
	case 553:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2810
		{
			yyVAL.expr = NewStrVal(yyDollar[1].bytes)
		}
	case 554:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2814
		{
			yyVAL.expr = &Default{}
		}
	case 557:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2823
		{
			yyVAL.byt = 0
		}
	case 558:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2825
		{
			yyVAL.byt = 1
		}
	case 559:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2828
		{
			yyVAL.empty = struct{}{}
		}
	case 560:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line sql.y:2830
		{
			yyVAL.empty = struct{}{}
		}
	case 561:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2833
		{
			yyVAL.str = ""
		}
	case 562:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2835
		{
			yyVAL.str = IgnoreStr
		}
	case 563:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2839
		{
			yyVAL.empty = struct{}{}
		}
	case 564:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2841
		{
			yyVAL.empty = struct{}{}
		}
	case 565:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2843
		{
			yyVAL.empty = struct{}{}
		}
	case 566:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2845
		{
			yyVAL.empty = struct{}{}
		}
	case 567:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2847
		{
			yyVAL.empty = struct{}{}
		}
	case 568:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2849
		{
			yyVAL.empty = struct{}{}
		}
	case 569:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2851
		{
			yyVAL.empty = struct{}{}
		}
	case 570:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2853
		{
			yyVAL.empty = struct{}{}
		}
	case 571:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2855
		{
			yyVAL.empty = struct{}{}
		}
	case 572:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2857
		{
			yyVAL.empty = struct{}{}
		}
	case 573:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2860
		{
			yyVAL.empty = struct{}{}
		}
	case 574:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2862
		{
			yyVAL.empty = struct{}{}
		}
	case 575:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2864
		{
			yyVAL.empty = struct{}{}
		}
	case 576:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2868
		{
			yyVAL.empty = struct{}{}
		}
	case 577:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2870
		{
			yyVAL.empty = struct{}{}
		}
	case 578:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2873
		{
			yyVAL.empty = struct{}{}
		}
	case 579:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2875
		{
			yyVAL.empty = struct{}{}
		}
	case 580:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2877
		{
			yyVAL.empty = struct{}{}
		}
	case 581:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:2880
		{
			yyVAL.colIdent = ColIdent{}
		}
	case 582:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line sql.y:2882
		{
			yyVAL.colIdent = yyDollar[2].colIdent
		}
	case 583:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2886
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 584:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2890
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 586:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2897
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 587:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2903
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 588:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2907
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 590:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:2914
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 781:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:3130
		{
			if incNesting(yylex) {
				yylex.Error("max nesting level reached")
				return 1
			}
		}
	case 782:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:3139
		{
			decNesting(yylex)
		}
	case 783:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:3144
		{
			forceEOF(yylex)
		}
	case 784:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line sql.y:3149
		{
			forceEOF(yylex)
		}
	case 785:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:3153
		{
			forceEOF(yylex)
		}
	case 786:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line sql.y:3157
		{
			forceEOF(yylex)
		}
	}
	goto yystack /* stack new state and value */
}
