// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package identitytoolkit provides access to the Identity Toolkit API.
//
// For product documentation, see: https://cloud.google.com/identity-platform
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/identitytoolkit/v1"
//	...
//	ctx := context.Background()
//	identitytoolkitService, err := identitytoolkit.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	identitytoolkitService, err := identitytoolkit.NewService(ctx, option.WithScopes(identitytoolkit.FirebaseScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	identitytoolkitService, err := identitytoolkit.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	identitytoolkitService, err := identitytoolkit.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package identitytoolkit // import "google.golang.org/api/identitytoolkit/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "identitytoolkit:v1"
const apiName = "identitytoolkit"
const apiVersion = "v1"
const basePath = "https://identitytoolkit.googleapis.com/"
const basePathTemplate = "https://identitytoolkit.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://identitytoolkit.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View and administer all your Firebase data and settings
	FirebaseScope = "https://www.googleapis.com/auth/firebase"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/firebase",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Accounts = NewAccountsService(s)
	s.Projects = NewProjectsService(s)
	s.V1 = NewV1Service(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService

	Projects *ProjectsService

	V1 *V1Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	return rs
}

type AccountsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Accounts_ = NewProjectsAccountsService(s)
	rs.Tenants = NewProjectsTenantsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Accounts_ *ProjectsAccountsService

	Tenants *ProjectsTenantsService
}

func NewProjectsAccountsService(s *Service) *ProjectsAccountsService {
	rs := &ProjectsAccountsService{s: s}
	return rs
}

type ProjectsAccountsService struct {
	s *Service
}

func NewProjectsTenantsService(s *Service) *ProjectsTenantsService {
	rs := &ProjectsTenantsService{s: s}
	rs.Accounts_ = NewProjectsTenantsAccountsService(s)
	return rs
}

type ProjectsTenantsService struct {
	s *Service

	Accounts_ *ProjectsTenantsAccountsService
}

func NewProjectsTenantsAccountsService(s *Service) *ProjectsTenantsAccountsService {
	rs := &ProjectsTenantsAccountsService{s: s}
	return rs
}

type ProjectsTenantsAccountsService struct {
	s *Service
}

func NewV1Service(s *Service) *V1Service {
	rs := &V1Service{s: s}
	return rs
}

type V1Service struct {
	s *Service
}

// GoogleCloudIdentitytoolkitV1Argon2Parameters: The parameters for Argon2
// hashing algorithm.
type GoogleCloudIdentitytoolkitV1Argon2Parameters struct {
	// AssociatedData: The additional associated data, if provided, is appended to
	// the hash value to provide an additional layer of security. A base64-encoded
	// string if specified via JSON.
	AssociatedData string `json:"associatedData,omitempty"`
	// HashLengthBytes: Required. The desired hash length in bytes. Minimum is 4
	// and maximum is 1024.
	HashLengthBytes int64 `json:"hashLengthBytes,omitempty"`
	// HashType: Required. Must not be HASH_TYPE_UNSPECIFIED.
	//
	// Possible values:
	//   "HASH_TYPE_UNSPECIFIED" - The hash type is not specified.
	//   "ARGON2_D" - An Argon2 variant, Argon2d.
	//   "ARGON2_ID" - An Argon2 variant, Argonid. Recommended.
	//   "ARGON2_I" - An Argon2 variant, Argon2i.
	HashType string `json:"hashType,omitempty"`
	// Iterations: Required. The number of iterations to perform. Minimum is 1,
	// maximum is 16.
	Iterations int64 `json:"iterations,omitempty"`
	// MemoryCostKib: Required. The memory cost in kibibytes. Maximum is 32768.
	MemoryCostKib int64 `json:"memoryCostKib,omitempty"`
	// Parallelism: Required. The degree of parallelism, also called threads or
	// lanes. Minimum is 1, maximum is 16.
	Parallelism int64 `json:"parallelism,omitempty"`
	// Version: The version of the Argon2 algorithm. This defaults to VERSION_13 if
	// not specified.
	//
	// Possible values:
	//   "VERSION_UNSPECIFIED" - The version is not specified.
	//   "VERSION_10" - The previous version, 0x10.
	//   "VERSION_13" - The current version, 0x13. The default value for version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssociatedData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssociatedData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1Argon2Parameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1Argon2Parameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1AutoRetrievalInfo: The information required to
// auto-retrieve an SMS.
type GoogleCloudIdentitytoolkitV1AutoRetrievalInfo struct {
	// AppSignatureHash: The Android app's signature hash for Google Play Service's
	// SMS Retriever API.
	AppSignatureHash string `json:"appSignatureHash,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppSignatureHash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppSignatureHash") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1AutoRetrievalInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1AutoRetrievalInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest: Request message for
// BatchDeleteAccounts.
type GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest struct {
	// Force: Whether to force deleting accounts that are not in disabled state. If
	// false, only disabled accounts will be deleted, and accounts that are not
	// disabled will be added to the `errors`.
	Force bool `json:"force,omitempty"`
	// LocalIds: Required. List of user IDs to be deleted.
	LocalIds []string `json:"localIds,omitempty"`
	// TenantId: If the accounts belong to an Identity Platform tenant, the ID of
	// the tenant. If the accounts belong to a default Identity Platform project,
	// the field is not needed.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Force") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Force") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse: Response message to
// BatchDeleteAccounts.
type GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse struct {
	// Errors: Detailed error info for accounts that cannot be deleted.
	Errors []*GoogleCloudIdentitytoolkitV1BatchDeleteErrorInfo `json:"errors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1BatchDeleteErrorInfo: Error info for account
// failed to be deleted.
type GoogleCloudIdentitytoolkitV1BatchDeleteErrorInfo struct {
	// Index: The index of the errored item in the original local_ids field.
	Index int64 `json:"index,omitempty"`
	// LocalId: The corresponding user ID.
	LocalId string `json:"localId,omitempty"`
	// Message: Detailed error message.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Index") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Index") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1BatchDeleteErrorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1BatchDeleteErrorInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1CreateAuthUriRequest: Request message for
// CreateAuthUri.
type GoogleCloudIdentitytoolkitV1CreateAuthUriRequest struct {
	AppId string `json:"appId,omitempty"`
	// AuthFlowType: Used for the Google provider. The type of the authentication
	// flow to be used. If present, this should be `CODE_FLOW` to specify the
	// authorization code flow. Otherwise, the default ID Token flow will be used.
	AuthFlowType string `json:"authFlowType,omitempty"`
	// Context: An opaque string used to maintain contextual information between
	// the authentication request and the callback from the IdP.
	Context string `json:"context,omitempty"`
	// ContinueUri: A valid URL for the IdP to redirect the user back to. The URL
	// cannot contain fragments or the reserved `state` query parameter.
	ContinueUri string `json:"continueUri,omitempty"`
	// CustomParameter: Additional customized query parameters to be added to the
	// authorization URI. The following parameters are reserved and cannot be
	// added: `client_id`, `response_type`, `scope`, `redirect_uri`, `state`. For
	// the Microsoft provider, the Azure AD tenant to sign-in to can be specified
	// in the `tenant` custom parameter.
	CustomParameter map[string]string `json:"customParameter,omitempty"`
	// HostedDomain: Used for the Google provider. The G Suite hosted domain of the
	// user in order to restrict sign-in to users at that domain.
	HostedDomain string `json:"hostedDomain,omitempty"`
	// Identifier: The email identifier of the user account to fetch associated
	// providers for. At least one of the fields `identifier` and `provider_id`
	// must be set. The length of the email address should be less than 256
	// characters and in the format of `name@domain.tld`. The email address should
	// also match the RFC 822 (https://tools.ietf.org/html/rfc822) addr-spec
	// production.
	Identifier       string `json:"identifier,omitempty"`
	OauthConsumerKey string `json:"oauthConsumerKey,omitempty"`
	// OauthScope: Additional space-delimited OAuth 2.0 scopes specifying the scope
	// of the authentication request with the IdP. Used for OAuth 2.0 IdPs. For the
	// Google provider, the authorization code flow will be used if this field is
	// set.
	OauthScope  string `json:"oauthScope,omitempty"`
	OpenidRealm string `json:"openidRealm,omitempty"`
	OtaApp      string `json:"otaApp,omitempty"`
	// ProviderId: The provider ID of the IdP for the user to sign in with. This
	// should be a provider ID enabled for sign-in, which is either from the list
	// of default supported IdPs
	// (https://cloud.google.com/identity-platform/docs/reference/rest/v2/defaultSupportedIdps/list),
	// or of the format `oidc.*` or `saml.*`. Some examples are `google.com`,
	// `facebook.com`, `oidc.testapp`, and `saml.testapp`. At least one of the
	// fields `identifier` and `provider_id` must be set.
	ProviderId string `json:"providerId,omitempty"`
	// SessionId: A session ID that can be verified against in SignInWithIdp to
	// prevent session fixation attacks. If absent, a random string will be
	// generated and returned as the session ID.
	SessionId string `json:"sessionId,omitempty"`
	// TenantId: The ID of the Identity Platform tenant to create an authorization
	// URI or lookup an email identifier for. If not set, the operation will be
	// performed in the default Identity Platform instance in the project.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1CreateAuthUriRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1CreateAuthUriRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1CreateAuthUriResponse: Response message for
// CreateAuthUri.
type GoogleCloudIdentitytoolkitV1CreateAuthUriResponse struct {
	AllProviders []string `json:"allProviders,omitempty"`
	// AuthUri: The authorization URI for the requested provider. Present only when
	// a provider ID is set in the request.
	AuthUri string `json:"authUri,omitempty"`
	// CaptchaRequired: Whether a CAPTCHA is needed because there have been too
	// many failed login attempts by the user. Present only when a registered email
	// identifier is set in the request.
	CaptchaRequired bool `json:"captchaRequired,omitempty"`
	// ForExistingProvider: Whether the user has previously signed in with the
	// provider ID in the request. Present only when a registered email identifier
	// is set in the request.
	ForExistingProvider bool   `json:"forExistingProvider,omitempty"`
	Kind                string `json:"kind,omitempty"`
	// ProviderId: The provider ID from the request, if provided.
	ProviderId string `json:"providerId,omitempty"`
	// Registered: Whether the email identifier represents an existing account.
	// Present only when an email identifier is set in the request.
	Registered bool `json:"registered,omitempty"`
	// SessionId: The session ID from the request, or a random string generated by
	// CreateAuthUri if absent. It is used to prevent session fixation attacks.
	SessionId string `json:"sessionId,omitempty"`
	// SigninMethods: The list of sign-in methods that the user has previously
	// used. Each element is one of `password`, `emailLink`, or the provider ID of
	// an IdP. Present only when a registered email identifier is set in the
	// request. If email enumeration protection
	// (https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection)
	// is enabled, this method returns an empty list.
	SigninMethods []string `json:"signinMethods,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllProviders") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllProviders") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1CreateAuthUriResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1CreateAuthUriResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest: Request message for
// CreateSessionCookie.
type GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest struct {
	// IdToken: Required. A valid Identity Platform ID token.
	IdToken string `json:"idToken,omitempty"`
	// TenantId: The tenant ID of the Identity Platform tenant the account belongs
	// to.
	TenantId string `json:"tenantId,omitempty"`
	// ValidDuration: The number of seconds until the session cookie expires.
	// Specify a duration in seconds, between five minutes and fourteen days,
	// inclusively.
	ValidDuration int64 `json:"validDuration,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "IdToken") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse: Response message
// for CreateSessionCookie.
type GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse struct {
	// SessionCookie: The session cookie that has been created from the Identity
	// Platform ID token specified in the request. It is in the form of a JSON Web
	// Token (JWT). Always present.
	SessionCookie string `json:"sessionCookie,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SessionCookie") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SessionCookie") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1DeleteAccountRequest: Request message for
// DeleteAccount.
type GoogleCloudIdentitytoolkitV1DeleteAccountRequest struct {
	DelegatedProjectNumber int64 `json:"delegatedProjectNumber,omitempty,string"`
	// IdToken: The Identity Platform ID token of the account to delete. Require to
	// be specified for requests from end users that lack Google OAuth 2.0
	// credential. Authenticated requests bearing a Google OAuth2 credential with
	// proper permissions may pass local_id to specify the account to delete
	// alternatively.
	IdToken string `json:"idToken,omitempty"`
	// LocalId: The ID of user account to delete. Specifying this field requires a
	// Google OAuth 2.0 credential with proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control). Requests
	// from users lacking the credential should pass an ID token instead.
	LocalId string `json:"localId,omitempty"`
	// TargetProjectId: The ID of the project which the account belongs to. Should
	// only be specified in authenticated requests that specify local_id of an
	// account.
	TargetProjectId string `json:"targetProjectId,omitempty"`
	// TenantId: The ID of the tenant that the account belongs to, if applicable.
	// Only require to be specified for authenticated requests bearing a Google
	// OAuth 2.0 credential that specify local_id of an account that belongs to an
	// Identity Platform tenant.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DelegatedProjectNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DelegatedProjectNumber") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1DeleteAccountRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1DeleteAccountRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1DeleteAccountResponse: Response message for
// DeleteAccount.
type GoogleCloudIdentitytoolkitV1DeleteAccountResponse struct {
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1DeleteAccountResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1DeleteAccountResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1DownloadAccountResponse: Response message for
// DownloadAccount.
type GoogleCloudIdentitytoolkitV1DownloadAccountResponse struct {
	Kind string `json:"kind,omitempty"`
	// NextPageToken: If there are more accounts to be downloaded, a token that can
	// be passed back to DownloadAccount to get more accounts. Otherwise, this is
	// blank.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Users: All accounts belonging to the project/tenant limited by max_results
	// in the request.
	Users []*GoogleCloudIdentitytoolkitV1UserInfo `json:"users,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1DownloadAccountResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1DownloadAccountResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1EmailInfo: Information about email MFA.
type GoogleCloudIdentitytoolkitV1EmailInfo struct {
	// EmailAddress: Email address that a MFA verification should be sent to.
	EmailAddress string `json:"emailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmailAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmailAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1EmailInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1EmailInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1EmailTemplate: Email template
type GoogleCloudIdentitytoolkitV1EmailTemplate struct {
	// Body: Email body
	Body string `json:"body,omitempty"`
	// Customized: Whether the body or subject of the email is customized.
	Customized bool `json:"customized,omitempty"`
	// Disabled: Whether the template is disabled. If true, a default template will
	// be used.
	Disabled bool `json:"disabled,omitempty"`
	// Format: Email body format
	//
	// Possible values:
	//   "EMAIL_BODY_FORMAT_UNSPECIFIED" - Default value. Do not use.
	//   "PLAINTEXT" - Email body is in plain text format.
	//   "HTML" - Email body is in HTML format.
	Format string `json:"format,omitempty"`
	// From: From address of the email
	From string `json:"from,omitempty"`
	// FromDisplayName: From display name
	FromDisplayName string `json:"fromDisplayName,omitempty"`
	// FromLocalPart: Local part of From address
	FromLocalPart string `json:"fromLocalPart,omitempty"`
	// Locale: Value is in III language code format (e.g. "zh-CN", "es"). Both '-'
	// and '_' separators are accepted.
	Locale string `json:"locale,omitempty"`
	// ReplyTo: Reply-to address
	ReplyTo string `json:"replyTo,omitempty"`
	// Subject: Subject of the email
	Subject string `json:"subject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Body") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Body") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1EmailTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1EmailTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1ErrorInfo: Error information explaining why an
// account cannot be uploaded. batch upload.
type GoogleCloudIdentitytoolkitV1ErrorInfo struct {
	// Index: The index of the item, range is [0, request.size - 1]
	Index int64 `json:"index,omitempty"`
	// Message: Detailed error message
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Index") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Index") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1ErrorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1ErrorInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1FederatedUserIdentifier: Federated user
// identifier at an Identity Provider.
type GoogleCloudIdentitytoolkitV1FederatedUserIdentifier struct {
	// ProviderId: The ID of supported identity providers. This should be a
	// provider ID enabled for sign-in, which is either from the list of default
	// supported IdPs
	// (https://cloud.google.com/identity-platform/docs/reference/rest/v2/defaultSupportedIdps/list),
	// or of the format `oidc.*` or `saml.*`. Some examples are `google.com`,
	// `facebook.com`, `oidc.testapp`, and `saml.testapp`.
	ProviderId string `json:"providerId,omitempty"`
	// RawId: The user ID of the account at the third-party Identity Provider
	// specified by `provider_id`.
	RawId string `json:"rawId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProviderId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProviderId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1FederatedUserIdentifier) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1FederatedUserIdentifier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1GetAccountInfoRequest: Request message for
// GetAccountInfo.
type GoogleCloudIdentitytoolkitV1GetAccountInfoRequest struct {
	DelegatedProjectNumber int64 `json:"delegatedProjectNumber,omitempty,string"`
	// Email: The email address of one or more accounts to fetch. The length of
	// email should be less than 256 characters and in the format of
	// `name@domain.tld`. The email should also match the RFC 822
	// (https://tools.ietf.org/html/rfc822) addr-spec production. Should only be
	// specified by authenticated requests from a developer.
	Email           []string                                               `json:"email,omitempty"`
	FederatedUserId []*GoogleCloudIdentitytoolkitV1FederatedUserIdentifier `json:"federatedUserId,omitempty"`
	// IdToken: The Identity Platform ID token of the account to fetch. Require to
	// be specified for requests from end users.
	IdToken string `json:"idToken,omitempty"`
	// InitialEmail: The initial email of one or more accounts to fetch. The length
	// of email should be less than 256 characters and in the format of
	// `name@domain.tld`. The email should also match the RFC 822
	// (https://tools.ietf.org/html/rfc822) addr-spec production. Should only be
	// specified by authenticated requests from a developer.
	InitialEmail []string `json:"initialEmail,omitempty"`
	// LocalId: The ID of one or more accounts to fetch. Should only be specified
	// by authenticated requests bearing a Google OAuth 2.0 credential with proper
	// permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	LocalId []string `json:"localId,omitempty"`
	// PhoneNumber: The phone number of one or more accounts to fetch. Should only
	// be specified by authenticated requests from a developer and should be in
	// E.164 format, for example, +15555555555.
	PhoneNumber []string `json:"phoneNumber,omitempty"`
	// TargetProjectId: The ID of the Google Cloud project that the account or the
	// Identity Platform tenant specified by `tenant_id` belongs to. Should only be
	// specified by authenticated requests bearing a Google OAuth 2.0 credential
	// with proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	TargetProjectId string `json:"targetProjectId,omitempty"`
	// TenantId: The ID of the tenant that the account belongs to. Should only be
	// specified by authenticated requests from a developer.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DelegatedProjectNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DelegatedProjectNumber") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1GetAccountInfoRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1GetAccountInfoRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1GetAccountInfoResponse: Response message for
// GetAccountInfo.
type GoogleCloudIdentitytoolkitV1GetAccountInfoResponse struct {
	Kind string `json:"kind,omitempty"`
	// Users: The information of specific user account(s) matching the parameters
	// in the request.
	Users []*GoogleCloudIdentitytoolkitV1UserInfo `json:"users,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1GetAccountInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1GetAccountInfoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1GetOobCodeRequest: Request message for
// GetOobCode.
type GoogleCloudIdentitytoolkitV1GetOobCodeRequest struct {
	// AndroidInstallApp: If an associated android app can handle the OOB code,
	// whether or not to install the android app on the device where the link is
	// opened if the app is not already installed.
	AndroidInstallApp bool `json:"androidInstallApp,omitempty"`
	// AndroidMinimumVersion: If an associated android app can handle the OOB code,
	// the minimum version of the app. If the version on the device is lower than
	// this version then the user is taken to Google Play Store to upgrade the app.
	AndroidMinimumVersion string `json:"androidMinimumVersion,omitempty"`
	// AndroidPackageName: If an associated android app can handle the OOB code,
	// the Android package name of the android app that will handle the callback
	// when this OOB code is used. This will allow the correct app to open if it is
	// already installed, or allow Google Play Store to open to the correct app if
	// it is not yet installed.
	AndroidPackageName string `json:"androidPackageName,omitempty"`
	// CanHandleCodeInApp: When set to true, the OOB code link will be be sent as a
	// Universal Link or an Android App Link and will be opened by the
	// corresponding app if installed. If not set, or set to false, the OOB code
	// will be sent to the web widget first and then on continue will redirect to
	// the app if installed.
	CanHandleCodeInApp bool `json:"canHandleCodeInApp,omitempty"`
	// CaptchaResp: For a PASSWORD_RESET request, a reCaptcha response is required
	// when the system detects possible abuse activity. In those cases, this is the
	// response from the reCaptcha challenge used to verify the caller.
	CaptchaResp string `json:"captchaResp,omitempty"`
	Challenge   string `json:"challenge,omitempty"`
	// ClientType: The client type: web, Android or iOS. Required when reCAPTCHA
	// Enterprise protection is enabled.
	//
	// Possible values:
	//   "CLIENT_TYPE_UNSPECIFIED" - Client type is not specified.
	//   "CLIENT_TYPE_WEB" - Client type is web.
	//   "CLIENT_TYPE_ANDROID" - Client type is android.
	//   "CLIENT_TYPE_IOS" - Client type is ios.
	ClientType string `json:"clientType,omitempty"`
	// ContinueUrl: The Url to continue after user clicks the link sent in email.
	// This is the url that will allow the web widget to handle the OOB code.
	ContinueUrl string `json:"continueUrl,omitempty"`
	// DynamicLinkDomain: In order to ensure that the url used can be easily opened
	// up in iOS or android, we create a Firebase Dynamic Link
	// (https://firebase.google.com/docs/dynamic-links). Most Identity Platform
	// projects will only have one Dynamic Link domain enabled, and can leave this
	// field blank. This field contains a specified Dynamic Link domain for
	// projects that have multiple enabled.
	DynamicLinkDomain string `json:"dynamicLinkDomain,omitempty"`
	// Email: The account's email address to send the OOB code to, and generally
	// the email address of the account that needs to be updated. Required for
	// PASSWORD_RESET, EMAIL_SIGNIN, and VERIFY_EMAIL. Only required for
	// VERIFY_AND_CHANGE_EMAIL requests when return_oob_link is set to true. In
	// this case, it is the original email of the user.
	Email string `json:"email,omitempty"`
	// IOSAppStoreId: If an associated iOS app can handle the OOB code, the App
	// Store id of this app. This will allow App Store to open to the correct app
	// if the app is not yet installed.
	IOSAppStoreId string `json:"iOSAppStoreId,omitempty"`
	// IOSBundleId: If an associated iOS app can handle the OOB code, the iOS
	// bundle id of this app. This will allow the correct app to open if it is
	// already installed.
	IOSBundleId string `json:"iOSBundleId,omitempty"`
	// IdToken: An ID token for the account. It is required for
	// VERIFY_AND_CHANGE_EMAIL and VERIFY_EMAIL requests unless return_oob_link is
	// set to true.
	IdToken string `json:"idToken,omitempty"`
	// LinkDomain: Optional. In order to ensure that the url used can be easily
	// opened in iOS or Android, we create a Hosting link '/__/auth/links'. This
	// optional field contains the domain to use when constructing a Hosting link.
	// If not set, '.firebaseapp.com' domain will be used.
	LinkDomain string `json:"linkDomain,omitempty"`
	// NewEmail: The email address the account is being updated to. Required only
	// for VERIFY_AND_CHANGE_EMAIL requests.
	NewEmail string `json:"newEmail,omitempty"`
	// RecaptchaVersion: The reCAPTCHA version of the reCAPTCHA token in the
	// captcha_response.
	//
	// Possible values:
	//   "RECAPTCHA_VERSION_UNSPECIFIED" - The reCAPTCHA version is not specified.
	//   "RECAPTCHA_ENTERPRISE" - The reCAPTCHA enterprise.
	RecaptchaVersion string `json:"recaptchaVersion,omitempty"`
	// RequestType: Required. The type of out-of-band (OOB) code to send. Depending
	// on this value, other fields in this request will be required and/or have
	// different meanings. There are 4 different OOB codes that can be sent: *
	// PASSWORD_RESET * EMAIL_SIGNIN * VERIFY_EMAIL * VERIFY_AND_CHANGE_EMAIL
	//
	// Possible values:
	//   "OOB_REQ_TYPE_UNSPECIFIED" - Oob code type is not specified.
	//   "PASSWORD_RESET" - reset password
	//   "OLD_EMAIL_AGREE"
	//   "NEW_EMAIL_ACCEPT"
	//   "VERIFY_EMAIL" - verify the account's email address by sending an email
	//   "RECOVER_EMAIL"
	//   "EMAIL_SIGNIN" - sign in with email only
	//   "VERIFY_AND_CHANGE_EMAIL" - This flow sends an email to the specified new
	// email, and when applied by clicking the link in the email changes the
	// account's email to the new email. Used when the account must have verified
	// email at all times, such as MFA accounts.
	//   "REVERT_SECOND_FACTOR_ADDITION"
	RequestType string `json:"requestType,omitempty"`
	// ReturnOobLink: Whether the confirmation link containing the OOB code should
	// be returned in the response (no email is sent). Used when a developer wants
	// to construct the email template and send it on their own. By default this is
	// false; to specify this field, and to set it to true, it requires a Google
	// OAuth 2.0 credential with proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control)
	ReturnOobLink bool `json:"returnOobLink,omitempty"`
	// TargetProjectId: The Project ID of the Identity Platform project which the
	// account belongs to. To specify this field, it requires a Google OAuth 2.0
	// credential with proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	TargetProjectId string `json:"targetProjectId,omitempty"`
	// TenantId: The tenant ID of the Identity Platform tenant the account belongs
	// to.
	TenantId string `json:"tenantId,omitempty"`
	// UserIp: The IP address of the caller. Required only for PASSWORD_RESET
	// requests.
	UserIp string `json:"userIp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AndroidInstallApp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AndroidInstallApp") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1GetOobCodeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1GetOobCodeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1GetOobCodeResponse: Response message for
// GetOobCode.
type GoogleCloudIdentitytoolkitV1GetOobCodeResponse struct {
	// Email: If return_oob_link is false in the request, the email address the
	// verification was sent to.
	Email string `json:"email,omitempty"`
	Kind  string `json:"kind,omitempty"`
	// OobCode: If return_oob_link is true in the request, the OOB code to send.
	OobCode string `json:"oobCode,omitempty"`
	// OobLink: If return_oob_link is true in the request, the OOB link to be sent
	// to the user. This returns the constructed link including Firebase Dynamic
	// Link (https://firebase.google.com/docs/dynamic-links) related parameters.
	OobLink string `json:"oobLink,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1GetOobCodeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1GetOobCodeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1GetProjectConfigResponse: Response message for
// GetProjectConfig.
type GoogleCloudIdentitytoolkitV1GetProjectConfigResponse struct {
	// AllowPasswordUser: Whether to allow password account sign up. This field is
	// only returned for authenticated calls from a developer.
	AllowPasswordUser bool `json:"allowPasswordUser,omitempty"`
	// ApiKey: Google Cloud API key. This field is only returned for authenticated
	// calls from a developer.
	ApiKey string `json:"apiKey,omitempty"`
	// AuthorizedDomains: Authorized domains for widget redirect.
	AuthorizedDomains []string `json:"authorizedDomains,omitempty"`
	// ChangeEmailTemplate: Email template for change email. This field is only
	// returned for authenticated calls from a developer.
	ChangeEmailTemplate *GoogleCloudIdentitytoolkitV1EmailTemplate `json:"changeEmailTemplate,omitempty"`
	// DynamicLinksDomain: The Firebase Dynamic Links domain used to construct
	// links for redirects to native apps.
	DynamicLinksDomain string `json:"dynamicLinksDomain,omitempty"`
	// EnableAnonymousUser: Whether anonymous user is enabled. This field is only
	// returned for authenticated calls from a developer.
	EnableAnonymousUser bool `json:"enableAnonymousUser,omitempty"`
	// IdpConfig: OAuth2 provider config. This field is only returned for
	// authenticated calls from a developer.
	IdpConfig []*GoogleCloudIdentitytoolkitV1IdpConfig `json:"idpConfig,omitempty"`
	// LegacyResetPasswordTemplate: Reset password email template for legacy
	// Firebase V1 app. This field is only returned for authenticated calls from a
	// developer.
	LegacyResetPasswordTemplate *GoogleCloudIdentitytoolkitV1EmailTemplate `json:"legacyResetPasswordTemplate,omitempty"`
	// ProjectId: The project id of the retrieved configuration.
	ProjectId string `json:"projectId,omitempty"`
	// ResetPasswordTemplate: Email template for reset password. This field is only
	// returned for authenticated calls from a developer.
	ResetPasswordTemplate *GoogleCloudIdentitytoolkitV1EmailTemplate `json:"resetPasswordTemplate,omitempty"`
	// RevertSecondFactorAdditionTemplate: Email template for reverting second
	// factor additions. This field is only returned for authenticated calls from a
	// developer.
	RevertSecondFactorAdditionTemplate *GoogleCloudIdentitytoolkitV1EmailTemplate `json:"revertSecondFactorAdditionTemplate,omitempty"`
	// UseEmailSending: Whether to use email sending. This field is only returned
	// for authenticated calls from a developer.
	UseEmailSending bool `json:"useEmailSending,omitempty"`
	// VerifyEmailTemplate: Email template for verify email. This field is only
	// returned for authenticated calls from a developer.
	VerifyEmailTemplate *GoogleCloudIdentitytoolkitV1EmailTemplate `json:"verifyEmailTemplate,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowPasswordUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPasswordUser") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1GetProjectConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1GetProjectConfigResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1GetRecaptchaParamResponse: Response message for
// GetRecaptchaParam.
type GoogleCloudIdentitytoolkitV1GetRecaptchaParamResponse struct {
	Kind string `json:"kind,omitempty"`
	// ProducerProjectNumber: The producer project number used to generate PIA
	// tokens
	ProducerProjectNumber string `json:"producerProjectNumber,omitempty"`
	// RecaptchaSiteKey: The reCAPTCHA v2 site key used to invoke the reCAPTCHA
	// service. Always present.
	RecaptchaSiteKey string `json:"recaptchaSiteKey,omitempty"`
	RecaptchaStoken  string `json:"recaptchaStoken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1GetRecaptchaParamResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1GetRecaptchaParamResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1GetSessionCookiePublicKeysResponse: Response
// message for GetSessionCookiePublicKeys.
type GoogleCloudIdentitytoolkitV1GetSessionCookiePublicKeysResponse struct {
	// Keys: Public keys of the session cookie signer, formatted as JSON Web Keys
	// (JWK) (https://tools.ietf.org/html/rfc7517).
	Keys []*GoogleCloudIdentitytoolkitV1OpenIdConnectKey `json:"keys,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Keys") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Keys") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1GetSessionCookiePublicKeysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1GetSessionCookiePublicKeysResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1IdpConfig: Config of an identity provider.
type GoogleCloudIdentitytoolkitV1IdpConfig struct {
	// ClientId: OAuth2 client ID.
	ClientId string `json:"clientId,omitempty"`
	// Enabled: True if allows the user to sign in with the provider.
	Enabled bool `json:"enabled,omitempty"`
	// ExperimentPercent: Percent of users who will be prompted/redirected
	// federated login for this IdP
	ExperimentPercent int64 `json:"experimentPercent,omitempty"`
	// Possible values:
	//   "PROVIDER_UNSPECIFIED"
	//   "MSLIVE" - Microsoft Live as identity provider.
	//   "GOOGLE" - Google as identity provider.
	//   "FACEBOOK" - Facebook as identity provider.
	//   "PAYPAL" - PayPal as identity provider.
	//   "TWITTER" - Twitter as identity provider.
	//   "YAHOO" - Yahoo as identity provider.
	//   "AOL" - AOL as identity provider.
	//   "GITHUB" - GitHub as identity provider.
	//   "GOOGLE_PLAY_GAMES" - Google Play Games as identity provider.
	//   "LINKEDIN" - LinkedIn as identity provider.
	//   "IOS_GAME_CENTER" - iOS Game Center as identity provider.
	Provider string `json:"provider,omitempty"`
	// Secret: OAuth2 client secret.
	Secret string `json:"secret,omitempty"`
	// WhitelistedAudiences: Whitelisted client IDs for audience check.
	WhitelistedAudiences []string `json:"whitelistedAudiences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1IdpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1IdpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1IssueSamlResponseRequest: Request message for
// IssueSamlResponse.
type GoogleCloudIdentitytoolkitV1IssueSamlResponseRequest struct {
	// IdToken: The Identity Platform ID token. It will be verified and then
	// converted to a new SAMLResponse.
	IdToken string `json:"idToken,omitempty"`
	// RpId: Relying Party identifier, which is the audience of issued
	// SAMLResponse.
	RpId string `json:"rpId,omitempty"`
	// SamlAppEntityId: SAML app entity id specified in Google Admin Console for
	// each app. If developers want to redirect to a third-party app rather than a
	// G Suite app, they'll probably they need this. When it's used, we'll return a
	// RelayState. This includes a SAMLRequest, which can be used to trigger a
	// SP-initiated SAML flow to redirect to the real app.
	SamlAppEntityId string `json:"samlAppEntityId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdToken") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1IssueSamlResponseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1IssueSamlResponseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1IssueSamlResponseResponse: Response for
// IssueSamlResponse request.
type GoogleCloudIdentitytoolkitV1IssueSamlResponseResponse struct {
	// AcsEndpoint: The ACS endpoint which consumes the returned SAMLResponse.
	AcsEndpoint string `json:"acsEndpoint,omitempty"`
	// Email: Email of the user.
	Email string `json:"email,omitempty"`
	// FirstName: First name of the user.
	FirstName string `json:"firstName,omitempty"`
	// IsNewUser: Whether the logged in user was created by this request.
	IsNewUser bool `json:"isNewUser,omitempty"`
	// LastName: Last name of the user.
	LastName string `json:"lastName,omitempty"`
	// RelayState: Generated RelayState.
	RelayState string `json:"relayState,omitempty"`
	// SamlResponse: Signed SAMLResponse created for the Relying Party.
	SamlResponse string `json:"samlResponse,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AcsEndpoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcsEndpoint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1IssueSamlResponseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1IssueSamlResponseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1MfaEnrollment: Information on which multi-factor
// authentication (MFA) providers are enabled for an account.
type GoogleCloudIdentitytoolkitV1MfaEnrollment struct {
	// DisplayName: Display name for this mfa option e.g. "corp cell phone".
	DisplayName string `json:"displayName,omitempty"`
	// EmailInfo: Contains information specific to email MFA.
	EmailInfo *GoogleCloudIdentitytoolkitV1EmailInfo `json:"emailInfo,omitempty"`
	// EnrolledAt: Timestamp when the account enrolled this second factor.
	EnrolledAt string `json:"enrolledAt,omitempty"`
	// MfaEnrollmentId: ID of this MFA option.
	MfaEnrollmentId string `json:"mfaEnrollmentId,omitempty"`
	// PhoneInfo: Normally this will show the phone number associated with this
	// enrollment. In some situations, such as after a first factor sign in, it
	// will only show the obfuscated version of the associated phone number.
	PhoneInfo string `json:"phoneInfo,omitempty"`
	// TotpInfo: Contains information specific to TOTP MFA.
	TotpInfo *GoogleCloudIdentitytoolkitV1TotpInfo `json:"totpInfo,omitempty"`
	// UnobfuscatedPhoneInfo: Output only. Unobfuscated phone_info.
	UnobfuscatedPhoneInfo string `json:"unobfuscatedPhoneInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1MfaEnrollment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1MfaEnrollment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudIdentitytoolkitV1MfaFactor struct {
	// DisplayName: Display name for this mfa option e.g. "corp cell phone".
	DisplayName string `json:"displayName,omitempty"`
	// PhoneInfo: Phone number to receive OTP for MFA.
	PhoneInfo string `json:"phoneInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1MfaFactor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1MfaFactor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1MfaInfo: Multi-factor authentication related
// information.
type GoogleCloudIdentitytoolkitV1MfaInfo struct {
	// Enrollments: The second factors the user has enrolled.
	Enrollments []*GoogleCloudIdentitytoolkitV1MfaEnrollment `json:"enrollments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enrollments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enrollments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1MfaInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1MfaInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1OpenIdConnectKey: Represents a public key of the
// session cookie signer, formatted as a JSON Web Key (JWK)
// (https://tools.ietf.org/html/rfc7517).
type GoogleCloudIdentitytoolkitV1OpenIdConnectKey struct {
	// Alg: Signature algorithm.
	Alg string `json:"alg,omitempty"`
	// E: Exponent for the RSA public key, it is represented as the base64url
	// encoding of the value's big endian representation.
	E string `json:"e,omitempty"`
	// Kid: Unique string to identify this key.
	Kid string `json:"kid,omitempty"`
	// Kty: Key type.
	Kty string `json:"kty,omitempty"`
	// N: Modulus for the RSA public key, it is represented as the base64url
	// encoding of the value's big endian representation.
	N string `json:"n,omitempty"`
	// Use: Key use.
	Use string `json:"use,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alg") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alg") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1OpenIdConnectKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1OpenIdConnectKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1ProviderUserInfo: Information about the user as
// provided by various Identity Providers.
type GoogleCloudIdentitytoolkitV1ProviderUserInfo struct {
	// DisplayName: The user's display name at the Identity Provider.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The user's email address at the Identity Provider.
	Email string `json:"email,omitempty"`
	// FederatedId: The user's identifier at the Identity Provider.
	FederatedId string `json:"federatedId,omitempty"`
	// PhoneNumber: The user's phone number at the Identity Provider.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PhotoUrl: The user's profile photo URL at the Identity Provider.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// ProviderId: The ID of the Identity Provider.
	ProviderId string `json:"providerId,omitempty"`
	// RawId: The user's raw identifier directly returned from Identity Provider.
	RawId string `json:"rawId,omitempty"`
	// ScreenName: The user's screen_name at Twitter or login name at GitHub.
	ScreenName string `json:"screenName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1ProviderUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1ProviderUserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1QueryUserInfoRequest: Request message for
// QueryUserInfo.
type GoogleCloudIdentitytoolkitV1QueryUserInfoRequest struct {
	Expression []*GoogleCloudIdentitytoolkitV1SqlExpression `json:"expression,omitempty"`
	// Limit: The maximum number of accounts to return with an upper limit of
	// __500__. Defaults to _500_. Only valid when `return_user_info` is set to
	// `true`.
	Limit int64 `json:"limit,omitempty,string"`
	// Offset: The number of accounts to skip from the beginning of matching
	// records. Only valid when `return_user_info` is set to `true`.
	Offset int64 `json:"offset,omitempty,string"`
	// Possible values:
	//   "ORDER_UNSPECIFIED" - Order is not specified.
	//   "ASC" - Sort on ascending order.
	//   "DESC" - Sort on descending order.
	Order string `json:"order,omitempty"`
	// ReturnUserInfo: If `true`, this request will return the accounts matching
	// the query. If `false`, only the __count__ of accounts matching the query
	// will be returned. Defaults to `true`.
	ReturnUserInfo bool `json:"returnUserInfo,omitempty"`
	// Possible values:
	//   "SORT_BY_FIELD_UNSPECIFIED" - Sort field is not specified.
	//   "USER_ID" - Sort result by userId.
	//   "NAME" - Sort result by name.
	//   "CREATED_AT" - Sort result by createdAt.
	//   "LAST_LOGIN_AT" - Sort result by lastLoginAt.
	//   "USER_EMAIL" - Sort result by userEmail.
	SortBy string `json:"sortBy,omitempty"`
	// TenantId: The ID of the tenant to which the result is scoped.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Expression") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Expression") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1QueryUserInfoRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1QueryUserInfoRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1QueryUserInfoResponse: Response message for
// QueryUserInfo.
type GoogleCloudIdentitytoolkitV1QueryUserInfoResponse struct {
	// RecordsCount: If `return_user_info` in the request is true, this is the
	// number of returned accounts in this message. Otherwise, this is the total
	// number of accounts matching the query.
	RecordsCount int64 `json:"recordsCount,omitempty,string"`
	// UserInfo: If `return_user_info` in the request is true, this is the accounts
	// matching the query.
	UserInfo []*GoogleCloudIdentitytoolkitV1UserInfo `json:"userInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RecordsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecordsCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1QueryUserInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1QueryUserInfoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1ResetPasswordRequest: Request message for
// ResetPassword.
type GoogleCloudIdentitytoolkitV1ResetPasswordRequest struct {
	// Email: Optional. The email of the account to be modified. Specify this and
	// the old password in order to change an account's password without using an
	// out-of-band code.
	Email string `json:"email,omitempty"`
	// NewPassword: The new password to be set for this account. Specifying this
	// field will result in a change to the account and consume the out-of-band
	// code if one was specified and it was of type PASSWORD_RESET.
	NewPassword string `json:"newPassword,omitempty"`
	// OldPassword: The current password of the account to be modified. Specify
	// this and email to change an account's password without using an out-of-band
	// code.
	OldPassword string `json:"oldPassword,omitempty"`
	// OobCode: An out-of-band (OOB) code generated by GetOobCode request. Specify
	// only this parameter (or only this parameter and a tenant ID) to get the
	// out-of-band code's type in the response without mutating the account's
	// state. Only a PASSWORD_RESET out-of-band code can be consumed via this
	// method.
	OobCode string `json:"oobCode,omitempty"`
	// TenantId: Optional. The tenant ID of the Identity Platform tenant the
	// account belongs to.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1ResetPasswordRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1ResetPasswordRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1ResetPasswordResponse: Response message for
// ResetPassword.
type GoogleCloudIdentitytoolkitV1ResetPasswordResponse struct {
	// Email: The email associated with the out-of-band code that was used.
	Email    string                                     `json:"email,omitempty"`
	Kind     string                                     `json:"kind,omitempty"`
	MfaInfo  *GoogleCloudIdentitytoolkitV1MfaEnrollment `json:"mfaInfo,omitempty"`
	NewEmail string                                     `json:"newEmail,omitempty"`
	// Possible values:
	//   "OOB_REQ_TYPE_UNSPECIFIED" - Oob code type is not specified.
	//   "PASSWORD_RESET" - reset password
	//   "OLD_EMAIL_AGREE"
	//   "NEW_EMAIL_ACCEPT"
	//   "VERIFY_EMAIL" - verify the account's email address by sending an email
	//   "RECOVER_EMAIL"
	//   "EMAIL_SIGNIN" - sign in with email only
	//   "VERIFY_AND_CHANGE_EMAIL" - This flow sends an email to the specified new
	// email, and when applied by clicking the link in the email changes the
	// account's email to the new email. Used when the account must have verified
	// email at all times, such as MFA accounts.
	//   "REVERT_SECOND_FACTOR_ADDITION"
	RequestType string `json:"requestType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1ResetPasswordResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1ResetPasswordResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SendVerificationCodeRequest: Request message for
// SendVerificationCode. 'captcha_response' is required when reCAPTCHA
// enterprise is enabled, or otherwise at least one of (`ios_receipt` and
// `ios_secret`), `recaptcha_token`, or `safety_net_token` must be specified to
// verify the verification code is being sent on behalf of a real app and not
// an emulator.
type GoogleCloudIdentitytoolkitV1SendVerificationCodeRequest struct {
	// AutoRetrievalInfo: Android only. Used by Google Play Services to identify
	// the app for auto-retrieval.
	AutoRetrievalInfo *GoogleCloudIdentitytoolkitV1AutoRetrievalInfo `json:"autoRetrievalInfo,omitempty"`
	// CaptchaResponse: Optional. The reCAPTCHA Enterprise token provided by the
	// reCAPTCHA client-side integration. Required when reCAPTCHA enterprise is
	// enabled.
	CaptchaResponse string `json:"captchaResponse,omitempty"`
	// ClientType: Optional. The client type, web, android or ios. Required when
	// reCAPTCHA Enterprise is enabled.
	//
	// Possible values:
	//   "CLIENT_TYPE_UNSPECIFIED" - Client type is not specified.
	//   "CLIENT_TYPE_WEB" - Client type is web.
	//   "CLIENT_TYPE_ANDROID" - Client type is android.
	//   "CLIENT_TYPE_IOS" - Client type is ios.
	ClientType string `json:"clientType,omitempty"`
	// IosReceipt: Receipt of successful iOS app token validation. At least one of
	// (`ios_receipt` and `ios_secret`), `recaptcha_token`, or `safety_net_token`
	// must be specified to verify the verification code is being sent on behalf of
	// a real app and not an emulator, if 'captcha_response' is not used (reCAPTCHA
	// enterprise is not enabled). This should come from the response of
	// verifyIosClient. If present, the caller should also provide the
	// `ios_secret`, as well as a bundle ID in the `x-ios-bundle-identifier`
	// header, which must match the bundle ID from the verifyIosClient request.
	IosReceipt string `json:"iosReceipt,omitempty"`
	// IosSecret: Secret delivered to iOS app as a push notification. Should be
	// passed with an `ios_receipt` as well as the `x-ios-bundle-identifier`
	// header.
	IosSecret string `json:"iosSecret,omitempty"`
	// PhoneNumber: The phone number to send the verification code to in E.164
	// format.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PlayIntegrityToken: Android only. Used to assert application identity in
	// place of a recaptcha token (and safety_net_token). At least one of
	// (`ios_receipt` and `ios_secret`), `recaptcha_token`, , or
	// `play_integrity_token` must be specified to verify the verification code is
	// being sent on behalf of a real app and not an emulator, if
	// 'captcha_response' is not used (reCAPTCHA enterprise is not enabled). A Play
	// Integrity Token can be generated via the PlayIntegrity API
	// (https://developer.android.com/google/play/integrity) with applying SHA256
	// to the `phone_number` field as the nonce.
	PlayIntegrityToken string `json:"playIntegrityToken,omitempty"`
	// RecaptchaToken: Recaptcha token for app verification. At least one of
	// (`ios_receipt` and `ios_secret`), `recaptcha_token`, or `safety_net_token`
	// must be specified to verify the verification code is being sent on behalf of
	// a real app and not an emulator, if 'captcha_response' is not used (reCAPTCHA
	// enterprise is not enabled). The recaptcha should be generated by calling
	// getRecaptchaParams and the recaptcha token will be generated on user
	// completion of the recaptcha challenge.
	RecaptchaToken string `json:"recaptchaToken,omitempty"`
	// RecaptchaVersion: Optional. The reCAPTCHA version of the reCAPTCHA token in
	// the captcha_response. Required when reCAPTCHA Enterprise is enabled.
	//
	// Possible values:
	//   "RECAPTCHA_VERSION_UNSPECIFIED" - The reCAPTCHA version is not specified.
	//   "RECAPTCHA_ENTERPRISE" - The reCAPTCHA enterprise.
	RecaptchaVersion string `json:"recaptchaVersion,omitempty"`
	// SafetyNetToken: Android only. Used to assert application identity in place
	// of a recaptcha token. At least one of (`ios_receipt` and `ios_secret`),
	// `recaptcha_token`, or `safety_net_token` must be specified to verify the
	// verification code is being sent on behalf of a real app and not an emulator,
	// if 'captcha_response' is not used (reCAPTCHA enterprise is not enabled). A
	// SafetyNet Token can be generated via the SafetyNet Android Attestation API
	// (https://developer.android.com/training/safetynet/attestation.html), with
	// the Base64 encoding of the `phone_number` field as the nonce.
	SafetyNetToken string `json:"safetyNetToken,omitempty"`
	// TenantId: Tenant ID of the Identity Platform tenant the user is signing in
	// to.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoRetrievalInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoRetrievalInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SendVerificationCodeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SendVerificationCodeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SendVerificationCodeResponse: Response message
// for SendVerificationCode.
type GoogleCloudIdentitytoolkitV1SendVerificationCodeResponse struct {
	// SessionInfo: Encrypted session information. This can be used in
	// signInWithPhoneNumber to authenticate the phone number.
	SessionInfo string `json:"sessionInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SessionInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SessionInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SendVerificationCodeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SendVerificationCodeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SetAccountInfoRequest: Request message for
// SetAccountInfo.
type GoogleCloudIdentitytoolkitV1SetAccountInfoRequest struct {
	CaptchaChallenge string `json:"captchaChallenge,omitempty"`
	// CaptchaResponse: The response from reCaptcha challenge. This is required
	// when the system detects possible abuse activities.
	CaptchaResponse string `json:"captchaResponse,omitempty"`
	// CreatedAt: The timestamp in milliseconds when the account was created.
	CreatedAt int64 `json:"createdAt,omitempty,string"`
	// CustomAttributes: JSON formatted custom attributes to be stored in the
	// Identity Platform ID token. Specifying this field requires a Google OAuth
	// 2.0 credential with proper [permissions]
	// (https://cloud.google.com/identity-platform/docs/access-control).
	CustomAttributes       string `json:"customAttributes,omitempty"`
	DelegatedProjectNumber int64  `json:"delegatedProjectNumber,omitempty,string"`
	// Possible values:
	//   "USER_ATTRIBUTE_NAME_UNSPECIFIED" - User attribute name is not specified.
	//   "EMAIL" - User attribute key name is email.
	//   "DISPLAY_NAME" - User attribute key name is displayName.
	//   "PROVIDER" - User attribute key name is provider.
	//   "PHOTO_URL" - User attribute key name is photoURL.
	//   "PASSWORD" - User attribute key name is password.
	//   "RAW_USER_INFO" - User attribute key name is rawUserInfo.
	DeleteAttribute []string `json:"deleteAttribute,omitempty"`
	// DeleteProvider: The Identity Providers to unlink from the user's account.
	DeleteProvider []string `json:"deleteProvider,omitempty"`
	// DisableUser: If true, marks the account as disabled, meaning the user will
	// no longer be able to sign-in.
	DisableUser bool `json:"disableUser,omitempty"`
	// DisplayName: The user's new display name to be updated in the account's
	// attributes. The length of the display name must be less than or equal to 256
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The user's new email to be updated in the account's attributes. The
	// length of email should be less than 256 characters and in the format of
	// `name@domain.tld`. The email should also match the RFC 822
	// (https://tools.ietf.org/html/rfc822) addr-spec production. If email
	// enumeration protection
	// (https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection)
	// is enabled, the email cannot be changed by the user without verifying the
	// email first, but it can be changed by an administrator.
	Email string `json:"email,omitempty"`
	// EmailVerified: Whether the user's email has been verified. Specifying this
	// field requires a Google OAuth 2.0 credential with proper [permissions]
	// (https://cloud.google.com/identity-platform/docs/access-control).
	EmailVerified bool `json:"emailVerified,omitempty"`
	// IdToken: A valid Identity Platform ID token. Required when attempting to
	// change user-related information.
	IdToken    string `json:"idToken,omitempty"`
	InstanceId string `json:"instanceId,omitempty"`
	// LastLoginAt: The timestamp in milliseconds when the account last logged in.
	LastLoginAt int64 `json:"lastLoginAt,omitempty,string"`
	// LinkProviderUserInfo: The provider to be linked to the user's account.
	// Specifying this field requires a Google OAuth 2.0 credential with proper
	// [permissions]
	// (https://cloud.google.com/identity-platform/docs/access-control).
	LinkProviderUserInfo *GoogleCloudIdentitytoolkitV1ProviderUserInfo `json:"linkProviderUserInfo,omitempty"`
	// LocalId: The ID of the user. Specifying this field requires a Google OAuth
	// 2.0 credential with proper [permissions]
	// (https://cloud.google.com/identity-platform/docs/access-control). For
	// requests from end-users, an ID token should be passed instead.
	LocalId string `json:"localId,omitempty"`
	// Mfa: The multi-factor authentication related information to be set on the
	// user's account. This will overwrite any previous multi-factor related
	// information on the account. Specifying this field requires a Google OAuth
	// 2.0 credential with proper [permissions]
	// (https://cloud.google.com/identity-platform/docs/access-control).
	Mfa *GoogleCloudIdentitytoolkitV1MfaInfo `json:"mfa,omitempty"`
	// OobCode: The out-of-band code to be applied on the user's account. The
	// following out-of-band code types are supported: * VERIFY_EMAIL *
	// RECOVER_EMAIL * REVERT_SECOND_FACTOR_ADDITION * VERIFY_AND_CHANGE_EMAIL
	OobCode string `json:"oobCode,omitempty"`
	// Password: The user's new password to be updated in the account's attributes.
	// The password must be at least 6 characters long.
	Password string `json:"password,omitempty"`
	// PhoneNumber: The phone number to be updated in the account's attributes.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PhotoUrl: The user's new photo URL for the account's profile photo to be
	// updated in the account's attributes. The length of the URL must be less than
	// or equal to 2048 characters.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// Provider: The Identity Providers that the account should be associated with.
	Provider []string `json:"provider,omitempty"`
	// ReturnSecureToken: Whether or not to return an ID and refresh token. Should
	// always be true.
	ReturnSecureToken bool `json:"returnSecureToken,omitempty"`
	// TargetProjectId: The project ID for the project that the account belongs to.
	// Specifying this field requires Google OAuth 2.0 credential with proper
	// [permissions]
	// (https://cloud.google.com/identity-platform/docs/access-control). Requests
	// from end users should pass an Identity Platform ID token instead.
	TargetProjectId string `json:"targetProjectId,omitempty"`
	// TenantId: The tenant ID of the Identity Platform tenant that the account
	// belongs to. Requests from end users should pass an Identity Platform ID
	// token rather than setting this field.
	TenantId string `json:"tenantId,omitempty"`
	// UpgradeToFederatedLogin: Whether the account should be restricted to only
	// using federated login.
	UpgradeToFederatedLogin bool `json:"upgradeToFederatedLogin,omitempty"`
	// ValidSince: Specifies the minimum timestamp in seconds for an Identity
	// Platform ID token to be considered valid.
	ValidSince int64 `json:"validSince,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CaptchaChallenge") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaptchaChallenge") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SetAccountInfoRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SetAccountInfoRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SetAccountInfoResponse: Response message for
// SetAccountInfo
type GoogleCloudIdentitytoolkitV1SetAccountInfoResponse struct {
	// DisplayName: The account's display name.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The account's email address.
	Email string `json:"email,omitempty"`
	// EmailVerified: Whether the account's email has been verified.
	EmailVerified bool `json:"emailVerified,omitempty"`
	// ExpiresIn: The number of seconds until the Identity Platform ID token
	// expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// IdToken: An Identity Platform ID token for the account. This is used for
	// legacy user sign up.
	IdToken string `json:"idToken,omitempty"`
	Kind    string `json:"kind,omitempty"`
	// LocalId: The ID of the authenticated user.
	LocalId string `json:"localId,omitempty"`
	// NewEmail: The new email that has been set on the user's account attributes.
	NewEmail string `json:"newEmail,omitempty"`
	// PasswordHash: Deprecated. No actual password hash is currently returned.
	PasswordHash string `json:"passwordHash,omitempty"`
	// PhotoUrl: The user's photo URL for the account's profile photo.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// ProviderUserInfo: The linked Identity Providers on the account.
	ProviderUserInfo []*GoogleCloudIdentitytoolkitV1ProviderUserInfo `json:"providerUserInfo,omitempty"`
	// RefreshToken: A refresh token for the account. This is used for legacy user
	// sign up.
	RefreshToken string `json:"refreshToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SetAccountInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SetAccountInfoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithCustomTokenRequest: Request message
// for SignInWithCustomToken.
type GoogleCloudIdentitytoolkitV1SignInWithCustomTokenRequest struct {
	DelegatedProjectNumber int64  `json:"delegatedProjectNumber,omitempty,string"`
	InstanceId             string `json:"instanceId,omitempty"`
	// ReturnSecureToken: Should always be true.
	ReturnSecureToken bool `json:"returnSecureToken,omitempty"`
	// TenantId: The ID of the Identity Platform tenant the user is signing in to.
	// If present, the ID should match the tenant_id in the token.
	TenantId string `json:"tenantId,omitempty"`
	// Token: Required. The custom Auth token asserted by the developer. The token
	// should be a JSON Web Token (JWT) (https://tools.ietf.org/html/rfc7519) that
	// includes the claims listed in the API reference
	// (https://cloud.google.com/identity-platform/docs/reference/rest/client/)
	// under the "Custom Token Claims" section.
	Token string `json:"token,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DelegatedProjectNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DelegatedProjectNumber") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithCustomTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithCustomTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithCustomTokenResponse: Response message
// for SignInWithCustomToken.
type GoogleCloudIdentitytoolkitV1SignInWithCustomTokenResponse struct {
	// ExpiresIn: The number of seconds until the ID token expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// IdToken: An Identity Platform ID token for the authenticated user.
	IdToken string `json:"idToken,omitempty"`
	// IsNewUser: Whether the authenticated user was created by this request.
	IsNewUser bool   `json:"isNewUser,omitempty"`
	Kind      string `json:"kind,omitempty"`
	// RefreshToken: An Identity Platform refresh token for the authenticated user.
	RefreshToken string `json:"refreshToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExpiresIn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpiresIn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithCustomTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithCustomTokenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithEmailLinkRequest: Request message for
// SignInWithEmailLink
type GoogleCloudIdentitytoolkitV1SignInWithEmailLinkRequest struct {
	// Email: Required. The email address the sign-in link was sent to. The length
	// of email should be less than 256 characters and in the format of
	// `name@domain.tld`. The email should also match the RFC 822
	// (https://tools.ietf.org/html/rfc822) addr-spec production.
	Email string `json:"email,omitempty"`
	// IdToken: A valid ID token for an Identity Platform account. If passed, this
	// request will link the email address to the user represented by this ID token
	// and enable sign-in with email link on the account for the future.
	IdToken string `json:"idToken,omitempty"`
	// OobCode: Required. The out-of-band code from the email link.
	OobCode string `json:"oobCode,omitempty"`
	// TenantId: The ID of the Identity Platform tenant the user is signing in to.
	// If not set, the user will sign in to the default Identity Platform project.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithEmailLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithEmailLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithEmailLinkResponse: Response message
// for SignInWithEmailLink.
type GoogleCloudIdentitytoolkitV1SignInWithEmailLinkResponse struct {
	// Email: The email the user signed in with. Always present in the response.
	Email string `json:"email,omitempty"`
	// ExpiresIn: The number of seconds until the ID token expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// IdToken: An Identity Platform ID token for the authenticated user.
	IdToken string `json:"idToken,omitempty"`
	// IsNewUser: Whether the authenticated user was created by this request.
	IsNewUser bool   `json:"isNewUser,omitempty"`
	Kind      string `json:"kind,omitempty"`
	// LocalId: The ID of the authenticated user. Always present in the response.
	LocalId string `json:"localId,omitempty"`
	// MfaInfo: Info on which multi-factor authentication providers are enabled.
	// Present if the user needs to complete the sign-in using multi-factor
	// authentication.
	MfaInfo []*GoogleCloudIdentitytoolkitV1MfaEnrollment `json:"mfaInfo,omitempty"`
	// MfaPendingCredential: An opaque string that functions as proof that the user
	// has successfully passed the first factor check.
	MfaPendingCredential string `json:"mfaPendingCredential,omitempty"`
	// RefreshToken: Refresh token for the authenticated user.
	RefreshToken string `json:"refreshToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithEmailLinkResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithEmailLinkResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithGameCenterRequest: Request message for
// SignInWithGameCenter
type GoogleCloudIdentitytoolkitV1SignInWithGameCenterRequest struct {
	// DisplayName: The user's Game Center display name.
	DisplayName string `json:"displayName,omitempty"`
	// GamePlayerId: The user's Game Center game player ID. A unique identifier for
	// a player of the game.
	// https://developer.apple.com/documentation/gamekit/gkplayer/3113960-gameplayerid
	GamePlayerId string `json:"gamePlayerId,omitempty"`
	// IdToken: A valid ID token for an Identity Platform account. If present, this
	// request will link the Game Center player ID to the account represented by
	// this ID token.
	IdToken string `json:"idToken,omitempty"`
	// PlayerId: Required. The user's Game Center player ID. Deprecated by Apple.
	// Pass `playerID` along with `gamePlayerID` and `teamPlayerID` to initiate the
	// migration of a user's Game Center player ID to `gamePlayerID`.
	PlayerId string `json:"playerId,omitempty"`
	// PublicKeyUrl: Required. The URL to fetch the Apple public key in order to
	// verify the given signature is signed by Apple.
	PublicKeyUrl string `json:"publicKeyUrl,omitempty"`
	// Salt: Required. A random string used to generate the given signature.
	Salt string `json:"salt,omitempty"`
	// Signature: Required. The verification signature data generated by Apple.
	Signature string `json:"signature,omitempty"`
	// TeamPlayerId: The user's Game Center team player ID. A unique identifier for
	// a player of all the games that you distribute using your developer account.
	// https://developer.apple.com/documentation/gamekit/gkplayer/3174857-teamplayerid
	TeamPlayerId string `json:"teamPlayerId,omitempty"`
	// TenantId: The ID of the Identity Platform tenant the user is signing in to.
	TenantId string `json:"tenantId,omitempty"`
	// Timestamp: Required. The time when the signature was created by Apple, in
	// milliseconds since the epoch.
	Timestamp int64 `json:"timestamp,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithGameCenterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithGameCenterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithGameCenterResponse: Response message
// for SignInWithGameCenter
type GoogleCloudIdentitytoolkitV1SignInWithGameCenterResponse struct {
	// DisplayName: Display name of the authenticated user.
	DisplayName string `json:"displayName,omitempty"`
	// ExpiresIn: The number of seconds until the ID token expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// GamePlayerId: The user's Game Center game player ID. A unique identifier for
	// a player of the game.
	// https://developer.apple.com/documentation/gamekit/gkplayer/3113960-gameplayerid
	GamePlayerId string `json:"gamePlayerId,omitempty"`
	// IdToken: An Identity Platform ID token for the authenticated user.
	IdToken string `json:"idToken,omitempty"`
	// IsNewUser: Whether the logged in user was created by this request.
	IsNewUser bool `json:"isNewUser,omitempty"`
	// LocalId: The ID of the authenticated user. Always present in the response.
	LocalId string `json:"localId,omitempty"`
	// PlayerId: The user's Game Center player ID. Pass `playerID` along with
	// `gamePlayerID` and `teamPlayerID` to initiate the migration of a user's Game
	// Center player ID to `gamePlayerID`.
	PlayerId string `json:"playerId,omitempty"`
	// RefreshToken: An Identity Platform refresh token for the authenticated user.
	RefreshToken string `json:"refreshToken,omitempty"`
	// TeamPlayerId: The user's Game Center team player ID. A unique identifier for
	// a player of all the games that you distribute using your developer account.
	// https://developer.apple.com/documentation/gamekit/gkplayer/3174857-teamplayerid
	TeamPlayerId string `json:"teamPlayerId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithGameCenterResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithGameCenterResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithIdpRequest: Request message for
// SignInWithIdp.
type GoogleCloudIdentitytoolkitV1SignInWithIdpRequest struct {
	AutoCreate             bool  `json:"autoCreate,omitempty"`
	DelegatedProjectNumber int64 `json:"delegatedProjectNumber,omitempty,string"`
	// IdToken: A valid Identity Platform ID token. If passed, the user's account
	// at the IdP will be linked to the account represented by this ID token.
	IdToken        string `json:"idToken,omitempty"`
	PendingIdToken string `json:"pendingIdToken,omitempty"`
	// PendingToken: An opaque string from a previous SignInWithIdp response. If
	// set, it can be used to repeat the sign-in operation from the previous
	// SignInWithIdp operation. This may be present if the user needs to confirm
	// their account information as part of a previous federated login attempt, or
	// perform account linking.
	PendingToken string `json:"pendingToken,omitempty"`
	// PostBody: If the user is signing in with an authorization response obtained
	// via a previous CreateAuthUri authorization request, this is the body of the
	// HTTP POST callback from the IdP, if present. Otherwise, if the user is
	// signing in with a manually provided IdP credential, this should be a
	// URL-encoded form that contains the credential (e.g. an ID token or access
	// token for OAuth 2.0 IdPs) and the provider ID of the IdP that issued the
	// credential. For example, if the user is signing in to the Google provider
	// using a Google ID token, this should be set to
	// id_token`=[GOOGLE_ID_TOKEN]&providerId=google.com`, where
	// `[GOOGLE_ID_TOKEN]` should be replaced with the Google ID token. If the user
	// is signing in to the Facebook provider using a Facebook authentication
	// token, this should be set to
	// id_token`=[FACEBOOK_AUTHENTICATION_TOKEN]&providerId=facebook. com&nonce=
	// [NONCE]`, where `[FACEBOOK_AUTHENTICATION_TOKEN]` should be replaced with
	// the Facebook authentication token. Nonce is required for validating the
	// token. The request will fail if no nonce is provided. If the user is signing
	// in to the Facebook provider using a Facebook access token, this should be
	// set to access_token`=[FACEBOOK_ACCESS_TOKEN]&providerId=facebook. com`,
	// where `[FACEBOOK_ACCESS_TOKEN]` should be replaced with the Facebook access
	// token. If the user is signing in to the Twitter provider using a Twitter
	// OAuth 1.0 credential, this should be set to
	// access_token`=[TWITTER_ACCESS_TOKEN]&oauth_token_secret=
	// [TWITTER_TOKEN_SECRET]&providerId=twitter.com`, where
	// `[TWITTER_ACCESS_TOKEN]` and `[TWITTER_TOKEN_SECRET]` should be replaced
	// with the Twitter OAuth access token and Twitter OAuth token secret
	// respectively.
	PostBody string `json:"postBody,omitempty"`
	// RequestUri: Required. The URL to which the IdP redirects the user back. This
	// can be set to `http://localhost` if the user is signing in with a manually
	// provided IdP credential.
	RequestUri string `json:"requestUri,omitempty"`
	// ReturnIdpCredential: Whether or not to return OAuth credentials from the IdP
	// on the following errors: `FEDERATED_USER_ID_ALREADY_LINKED` and
	// `EMAIL_EXISTS`.
	ReturnIdpCredential bool `json:"returnIdpCredential,omitempty"`
	// ReturnRefreshToken: Whether or not to return the OAuth refresh token from
	// the IdP, if available.
	ReturnRefreshToken bool `json:"returnRefreshToken,omitempty"`
	// ReturnSecureToken: Should always be true.
	ReturnSecureToken bool `json:"returnSecureToken,omitempty"`
	// SessionId: The session ID returned from a previous CreateAuthUri call. This
	// field is verified against that session ID to prevent session fixation
	// attacks. Required if the user is signing in with an authorization response
	// from a previous CreateAuthUri authorization request.
	SessionId string `json:"sessionId,omitempty"`
	// TenantId: The ID of the Identity Platform tenant the user is signing in to.
	// If not set, the user will sign in to the default Identity Platform project.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoCreate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoCreate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithIdpRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithIdpRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithIdpResponse: Response message for
// SignInWithIdp.
type GoogleCloudIdentitytoolkitV1SignInWithIdpResponse struct {
	// Context: The opaque string set in CreateAuthUri that is used to maintain
	// contextual information between the authentication request and the callback
	// from the IdP.
	Context string `json:"context,omitempty"`
	// DateOfBirth: The date of birth for the user's account at the IdP.
	DateOfBirth string `json:"dateOfBirth,omitempty"`
	// DisplayName: The display name for the user's account at the IdP.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The email address of the user's account at the IdP.
	Email string `json:"email,omitempty"`
	// EmailRecycled: Whether or not there is an existing Identity Platform user
	// account with the same email address but linked to a different account at the
	// same IdP. Only present if the "One account per email address" setting is
	// enabled and the email address at the IdP is verified.
	EmailRecycled bool `json:"emailRecycled,omitempty"`
	// EmailVerified: Whether the user account's email address is verified.
	EmailVerified bool `json:"emailVerified,omitempty"`
	// ErrorMessage: The error message returned if `return_idp_credential` is set
	// to `true` and either the `FEDERATED_USER_ID_ALREADY_LINKED` or
	// `EMAIL_EXISTS` error is encountered. This field's value is either
	// `FEDERATED_USER_ID_ALREADY_LINKED` or `EMAIL_EXISTS`.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ExpiresIn: The number of seconds until the Identity Platform ID token
	// expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// FederatedId: The user's account ID at the IdP. Always present in the
	// response.
	FederatedId string `json:"federatedId,omitempty"`
	// FirstName: The first name for the user's account at the IdP.
	FirstName string `json:"firstName,omitempty"`
	// FullName: The full name for the user's account at the IdP.
	FullName string `json:"fullName,omitempty"`
	// IdToken: An Identity Platform ID token for the authenticated user.
	IdToken    string `json:"idToken,omitempty"`
	InputEmail string `json:"inputEmail,omitempty"`
	// IsNewUser: Whether or not a new Identity Platform account was created for
	// the authenticated user.
	IsNewUser bool   `json:"isNewUser,omitempty"`
	Kind      string `json:"kind,omitempty"`
	// Language: The language preference for the user's account at the IdP.
	Language string `json:"language,omitempty"`
	// LastName: The last name for the user's account at the IdP.
	LastName string `json:"lastName,omitempty"`
	// LocalId: The ID of the authenticated Identity Platform user. Always present
	// in the response.
	LocalId string `json:"localId,omitempty"`
	// MfaInfo: Info on which multi-factor authentication providers are enabled for
	// the account. Present if the user needs to complete the sign-in using
	// multi-factor authentication.
	MfaInfo []*GoogleCloudIdentitytoolkitV1MfaEnrollment `json:"mfaInfo,omitempty"`
	// MfaPendingCredential: An opaque string that functions as proof that the user
	// has successfully passed the first factor authentication.
	MfaPendingCredential string `json:"mfaPendingCredential,omitempty"`
	// NeedConfirmation: Whether or not there is an existing Identity Platform user
	// account with the same email address as the current account signed in at the
	// IdP, and the account's email address is not verified at the IdP. The user
	// will need to sign in to the existing Identity Platform account and then link
	// the current credential from the IdP to it. Only present if the "One account
	// per email address" setting is enabled.
	NeedConfirmation bool `json:"needConfirmation,omitempty"`
	NeedEmail        bool `json:"needEmail,omitempty"`
	// NickName: The nickname for the user's account at the IdP.
	NickName string `json:"nickName,omitempty"`
	// OauthAccessToken: The OAuth access token from the IdP, if available.
	OauthAccessToken string `json:"oauthAccessToken,omitempty"`
	// OauthAuthorizationCode: The OAuth 2.0 authorization code, if available. Only
	// present for the Google provider.
	OauthAuthorizationCode string `json:"oauthAuthorizationCode,omitempty"`
	// OauthExpireIn: The number of seconds until the OAuth access token from the
	// IdP expires.
	OauthExpireIn int64 `json:"oauthExpireIn,omitempty"`
	// OauthIdToken: The OpenID Connect ID token from the IdP, if available.
	OauthIdToken string `json:"oauthIdToken,omitempty"`
	// OauthRefreshToken: The OAuth 2.0 refresh token from the IdP, if available
	// and `return_refresh_token` is set to `true`.
	OauthRefreshToken string `json:"oauthRefreshToken,omitempty"`
	// OauthTokenSecret: The OAuth 1.0 token secret from the IdP, if available.
	// Only present for the Twitter provider.
	OauthTokenSecret string `json:"oauthTokenSecret,omitempty"`
	// OriginalEmail: The main (top-level) email address of the user's Identity
	// Platform account, if different from the email address at the IdP. Only
	// present if the "One account per email address" setting is enabled.
	OriginalEmail string `json:"originalEmail,omitempty"`
	// PendingToken: An opaque string that can be used as a credential from the IdP
	// the user is signing into. The pending token obtained here can be set in a
	// future SignInWithIdp request to sign the same user in with the IdP again.
	PendingToken string `json:"pendingToken,omitempty"`
	// PhotoUrl: The URL of the user's profile picture at the IdP.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// ProviderId: The provider ID of the IdP that the user is signing in to.
	// Always present in the response.
	ProviderId string `json:"providerId,omitempty"`
	// RawUserInfo: The stringified JSON response containing all the data
	// corresponding to the user's account at the IdP.
	RawUserInfo string `json:"rawUserInfo,omitempty"`
	// RefreshToken: An Identity Platform refresh token for the authenticated user.
	RefreshToken string `json:"refreshToken,omitempty"`
	// ScreenName: The screen name for the user's account at the Twitter IdP or the
	// login name for the user's account at the GitHub IdP.
	ScreenName string `json:"screenName,omitempty"`
	// TenantId: The value of the `tenant_id` field in the request.
	TenantId string `json:"tenantId,omitempty"`
	// TimeZone: The time zone for the user's account at the IdP.
	TimeZone string `json:"timeZone,omitempty"`
	// VerifiedProvider: A list of provider IDs that the user can sign in to in
	// order to resolve a `need_confirmation` error. Only present if
	// `need_confirmation` is set to `true`.
	VerifiedProvider []string `json:"verifiedProvider,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithIdpResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithIdpResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithPasswordRequest: Request message for
// SignInWithPassword.
type GoogleCloudIdentitytoolkitV1SignInWithPasswordRequest struct {
	CaptchaChallenge string `json:"captchaChallenge,omitempty"`
	// CaptchaResponse: The reCAPTCHA token provided by the reCAPTCHA client-side
	// integration. reCAPTCHA Enterprise uses it for risk assessment. Required when
	// reCAPTCHA Enterprise is enabled.
	CaptchaResponse string `json:"captchaResponse,omitempty"`
	// ClientType: The client type, web, android or ios. Required when reCAPTCHA
	// Enterprise is enabled.
	//
	// Possible values:
	//   "CLIENT_TYPE_UNSPECIFIED" - Client type is not specified.
	//   "CLIENT_TYPE_WEB" - Client type is web.
	//   "CLIENT_TYPE_ANDROID" - Client type is android.
	//   "CLIENT_TYPE_IOS" - Client type is ios.
	ClientType             string `json:"clientType,omitempty"`
	DelegatedProjectNumber int64  `json:"delegatedProjectNumber,omitempty,string"`
	// Email: Required. The email the user is signing in with. The length of email
	// should be less than 256 characters and in the format of `name@domain.tld`.
	// The email should also match the RFC 822 (https://tools.ietf.org/html/rfc822)
	// addr-spec production.
	Email      string `json:"email,omitempty"`
	IdToken    string `json:"idToken,omitempty"`
	InstanceId string `json:"instanceId,omitempty"`
	// Password: Required. The password the user provides to sign in to the
	// account.
	Password       string `json:"password,omitempty"`
	PendingIdToken string `json:"pendingIdToken,omitempty"`
	// RecaptchaVersion: The reCAPTCHA version of the reCAPTCHA token in the
	// captcha_response.
	//
	// Possible values:
	//   "RECAPTCHA_VERSION_UNSPECIFIED" - The reCAPTCHA version is not specified.
	//   "RECAPTCHA_ENTERPRISE" - The reCAPTCHA enterprise.
	RecaptchaVersion string `json:"recaptchaVersion,omitempty"`
	// ReturnSecureToken: Should always be true.
	ReturnSecureToken bool `json:"returnSecureToken,omitempty"`
	// TenantId: The ID of the Identity Platform tenant the user is signing in to.
	// If not set, the user will sign in to the default Identity Platform instance
	// in the project.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaptchaChallenge") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaptchaChallenge") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithPasswordRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithPasswordRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithPasswordResponse: Response message for
// SignInWithPassword.
type GoogleCloudIdentitytoolkitV1SignInWithPasswordResponse struct {
	// DisplayName: The user's display name stored in the account's attributes.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The email of the authenticated user. Always present in the response.
	Email string `json:"email,omitempty"`
	// ExpiresIn: The number of seconds until the Identity Platform ID token
	// expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// IdToken: An Identity Platform ID token for the authenticated user.
	IdToken string `json:"idToken,omitempty"`
	Kind    string `json:"kind,omitempty"`
	// LocalId: The ID of the authenticated user. Always present in the response.
	LocalId string `json:"localId,omitempty"`
	// MfaInfo: Info on which multi-factor authentication providers are enabled for
	// the account. Present if the user needs to complete the sign-in using
	// multi-factor authentication.
	MfaInfo []*GoogleCloudIdentitytoolkitV1MfaEnrollment `json:"mfaInfo,omitempty"`
	// MfaPendingCredential: An opaque string that functions as proof that the user
	// has successfully passed the first factor authentication.
	MfaPendingCredential string `json:"mfaPendingCredential,omitempty"`
	// OauthAccessToken: The OAuth2 access token.
	OauthAccessToken       string `json:"oauthAccessToken,omitempty"`
	OauthAuthorizationCode string `json:"oauthAuthorizationCode,omitempty"`
	// OauthExpireIn: The access token expiration time in seconds.
	OauthExpireIn int64 `json:"oauthExpireIn,omitempty"`
	// ProfilePicture: The user's profile picture stored in the account's
	// attributes.
	ProfilePicture string `json:"profilePicture,omitempty"`
	// RefreshToken: An Identity Platform refresh token for the authenticated user.
	RefreshToken string `json:"refreshToken,omitempty"`
	// Registered: Whether the email is for an existing account. Always true.
	Registered bool `json:"registered,omitempty"`
	// UserNotifications: Warning notifications for the user.
	UserNotifications []*GoogleCloudIdentitytoolkitV1UserNotification `json:"userNotifications,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithPasswordResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithPasswordResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberRequest: Request message
// for SignInWithPhoneNumber.
type GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberRequest struct {
	// Code: User-entered verification code from an SMS sent to the user's phone.
	Code string `json:"code,omitempty"`
	// IdToken: A valid ID token for an Identity Platform account. If passed, this
	// request will link the phone number to the user represented by this ID token
	// if the phone number is not in use, or will reauthenticate the user if the
	// phone number is already linked to the user.
	IdToken string `json:"idToken,omitempty"`
	// Possible values:
	//   "VERIFY_OP_UNSPECIFIED" - Operation is not specified.
	//   "SIGN_UP_OR_IN" - Verify operation is to sign up/sign in.
	//   "REAUTH" - Verify operation is to reauth.
	//   "UPDATE" - Verify operation is to update.
	//   "LINK" - Verify operation is to link.
	Operation string `json:"operation,omitempty"`
	// PhoneNumber: The user's phone number to sign in with. This is necessary in
	// the case of uing a temporary proof, in which case it must match the phone
	// number that was authenticated in the request that generated the temporary
	// proof. This field is ignored if a session info is passed.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// SessionInfo: Encrypted session information from the response of
	// sendVerificationCode. In the case of authenticating with an SMS code this
	// must be specified, but in the case of using a temporary proof it can be
	// unspecified.
	SessionInfo string `json:"sessionInfo,omitempty"`
	// TemporaryProof: A proof of the phone number verification, provided from a
	// previous signInWithPhoneNumber request. If this is passed, the caller must
	// also pass in the phone_number field the phone number that was verified in
	// the previous request.
	TemporaryProof string `json:"temporaryProof,omitempty"`
	// TenantId: The ID of the Identity Platform tenant the user is signing in to.
	// If not set, the user will sign in to the default Identity Platform project.
	TenantId string `json:"tenantId,omitempty"`
	// VerificationProof: Do not use.
	VerificationProof string `json:"verificationProof,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberResponse: Response message
// for SignInWithPhoneNumber.
type GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberResponse struct {
	// ExpiresIn: The number of seconds until the ID token expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// IdToken: Identity Platform ID token for the authenticated user.
	IdToken string `json:"idToken,omitempty"`
	// IsNewUser: Whether the authenticated user was created by this request.
	IsNewUser bool `json:"isNewUser,omitempty"`
	// LocalId: The id of the authenticated user. Present in the case of a
	// successful authentication. In the case when the phone could be verified but
	// the account operation could not be performed, a temporary proof will be
	// returned instead.
	LocalId string `json:"localId,omitempty"`
	// PhoneNumber: Phone number of the authenticated user. Always present in the
	// response.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// RefreshToken: Refresh token for the authenticated user.
	RefreshToken string `json:"refreshToken,omitempty"`
	// TemporaryProof: A proof of the phone number verification, provided if a
	// phone authentication is successful but the user operation fails. This
	// happens when the request tries to link a phone number to a user with an ID
	// token or reauthenticate with an ID token but the phone number is linked to a
	// different user.
	TemporaryProof string `json:"temporaryProof,omitempty"`
	// TemporaryProofExpiresIn: The number of seconds until the temporary proof
	// expires.
	TemporaryProofExpiresIn int64 `json:"temporaryProofExpiresIn,omitempty,string"`
	// VerificationProof: Do not use.
	VerificationProof string `json:"verificationProof,omitempty"`
	// VerificationProofExpiresIn: Do not use.
	VerificationProofExpiresIn int64 `json:"verificationProofExpiresIn,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExpiresIn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpiresIn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignUpRequest: Request message for SignUp.
type GoogleCloudIdentitytoolkitV1SignUpRequest struct {
	CaptchaChallenge string `json:"captchaChallenge,omitempty"`
	// CaptchaResponse: The reCAPTCHA token provided by the reCAPTCHA client-side
	// integration. reCAPTCHA Enterprise uses it for assessment. Required when
	// reCAPTCHA enterprise is enabled.
	CaptchaResponse string `json:"captchaResponse,omitempty"`
	// ClientType: The client type: web, Android or iOS. Required when enabling
	// reCAPTCHA enterprise protection.
	//
	// Possible values:
	//   "CLIENT_TYPE_UNSPECIFIED" - Client type is not specified.
	//   "CLIENT_TYPE_WEB" - Client type is web.
	//   "CLIENT_TYPE_ANDROID" - Client type is android.
	//   "CLIENT_TYPE_IOS" - Client type is ios.
	ClientType string `json:"clientType,omitempty"`
	// Disabled: Whether the user will be disabled upon creation. Disabled accounts
	// are inaccessible except for requests bearing a Google OAuth2 credential with
	// proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: The display name of the user to be created.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The email to assign to the created user. The length of the email
	// should be less than 256 characters and in the format of `name@domain.tld`.
	// The email should also match the RFC 822 (https://tools.ietf.org/html/rfc822)
	// addr-spec production. An anonymous user will be created if not provided.
	Email string `json:"email,omitempty"`
	// EmailVerified: Whether the user's email is verified. Specifying this field
	// requires a Google OAuth 2.0 credential with the proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	EmailVerified bool `json:"emailVerified,omitempty"`
	// IdToken: A valid ID token for an Identity Platform user. If set, this
	// request will link the authentication credential to the user represented by
	// this ID token. For a non-admin request, both the `email` and `password`
	// fields must be set. For an admin request, `local_id` must not be set.
	IdToken    string `json:"idToken,omitempty"`
	InstanceId string `json:"instanceId,omitempty"`
	// LocalId: The ID of the user to create. The ID must be unique within the
	// project that the user is being created under. Specifying this field requires
	// a Google OAuth 2.0 credential with the proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	LocalId string `json:"localId,omitempty"`
	// MfaInfo: The multi-factor authentication providers for the user to create.
	MfaInfo []*GoogleCloudIdentitytoolkitV1MfaFactor `json:"mfaInfo,omitempty"`
	// Password: The password to assign to the created user. The password must be
	// be at least 6 characters long. If set, the `email` field must also be set.
	Password string `json:"password,omitempty"`
	// PhoneNumber: The phone number of the user to create. Specifying this field
	// requires a Google OAuth 2.0 credential with the proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PhotoUrl: The profile photo url of the user to create.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// RecaptchaVersion: The reCAPTCHA version of the reCAPTCHA token in the
	// captcha_response.
	//
	// Possible values:
	//   "RECAPTCHA_VERSION_UNSPECIFIED" - The reCAPTCHA version is not specified.
	//   "RECAPTCHA_ENTERPRISE" - The reCAPTCHA enterprise.
	RecaptchaVersion string `json:"recaptchaVersion,omitempty"`
	// TargetProjectId: The project ID of the project which the user should belong
	// to. Specifying this field requires a Google OAuth 2.0 credential with the
	// proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control). If this is
	// not set, the target project is inferred from the scope associated to the
	// Bearer access token.
	TargetProjectId string `json:"targetProjectId,omitempty"`
	// TenantId: The ID of the Identity Platform tenant to create a user under. If
	// not set, the user will be created under the default Identity Platform
	// project.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaptchaChallenge") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaptchaChallenge") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignUpRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignUpRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SignUpResponse: Response message for SignUp.
type GoogleCloudIdentitytoolkitV1SignUpResponse struct {
	// DisplayName: The created user's display name.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The created user's email.
	Email string `json:"email,omitempty"`
	// ExpiresIn: The number of seconds until the ID token expires.
	ExpiresIn int64 `json:"expiresIn,omitempty,string"`
	// IdToken: An Identity Platform ID token for the created user. This field is
	// only set for non-admin requests.
	IdToken string `json:"idToken,omitempty"`
	Kind    string `json:"kind,omitempty"`
	// LocalId: The ID of the created user. Always present in the response.
	LocalId string `json:"localId,omitempty"`
	// RefreshToken: An Identity Platform refresh token for the created user. This
	// field is only set for non-admin requests.
	RefreshToken string `json:"refreshToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SignUpResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SignUpResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1SqlExpression: Query conditions used to filter
// results.
type GoogleCloudIdentitytoolkitV1SqlExpression struct {
	// Email: A case insensitive string that the account's email should match. Only
	// one of `email`, `phone_number`, or `user_id` should be specified in a
	// SqlExpression. If more than one is specified, only the first (in that order)
	// will be applied.
	Email string `json:"email,omitempty"`
	// PhoneNumber: A string that the account's phone number should match. Only one
	// of `email`, `phone_number`, or `user_id` should be specified in a
	// SqlExpression. If more than one is specified, only the first (in that order)
	// will be applied.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// UserId: A string that the account's local ID should match. Only one of
	// `email`, `phone_number`, or `user_id` should be specified in a SqlExpression
	// If more than one is specified, only the first (in that order) will be
	// applied.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1SqlExpression) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1SqlExpression
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1TotpInfo: Information about TOTP MFA.
type GoogleCloudIdentitytoolkitV1TotpInfo struct {
}

// GoogleCloudIdentitytoolkitV1UploadAccountRequest: Request message for
// UploadAccount.
type GoogleCloudIdentitytoolkitV1UploadAccountRequest struct {
	// AllowOverwrite: Whether to overwrite an existing account in Identity
	// Platform with a matching `local_id` in the request. If true, the existing
	// account will be overwritten. If false, an error will be returned.
	AllowOverwrite bool `json:"allowOverwrite,omitempty"`
	// Argon2Parameters: The parameters for Argon2 hashing algorithm.
	Argon2Parameters *GoogleCloudIdentitytoolkitV1Argon2Parameters `json:"argon2Parameters,omitempty"`
	// BlockSize: The block size parameter used by the STANDARD_SCRYPT hashing
	// function. This parameter, along with parallelization and cpu_mem_cost help
	// tune the resources needed to hash a password, and should be tuned as
	// processor speeds and memory technologies advance.
	BlockSize int64 `json:"blockSize,omitempty"`
	// CpuMemCost: The CPU memory cost parameter to be used by the STANDARD_SCRYPT
	// hashing function. This parameter, along with block_size and cpu_mem_cost
	// help tune the resources needed to hash a password, and should be tuned as
	// processor speeds and memory technologies advance.
	CpuMemCost             int64 `json:"cpuMemCost,omitempty"`
	DelegatedProjectNumber int64 `json:"delegatedProjectNumber,omitempty,string"`
	// DkLen: The desired key length for the STANDARD_SCRYPT hashing function. Must
	// be at least 1.
	DkLen int64 `json:"dkLen,omitempty"`
	// HashAlgorithm: Required. The hashing function used to hash the account
	// passwords. Must be one of the following: * HMAC_SHA256 * HMAC_SHA1 *
	// HMAC_MD5 * SCRYPT * PBKDF_SHA1 * MD5 * HMAC_SHA512 * SHA1 * BCRYPT *
	// PBKDF2_SHA256 * SHA256 * SHA512 * STANDARD_SCRYPT * ARGON2
	HashAlgorithm string `json:"hashAlgorithm,omitempty"`
	// MemoryCost: Memory cost for hash calculation. Only required when the hashing
	// function is SCRYPT.
	MemoryCost int64 `json:"memoryCost,omitempty"`
	// Parallelization: The parallelization cost parameter to be used by the
	// STANDARD_SCRYPT hashing function. This parameter, along with block_size and
	// cpu_mem_cost help tune the resources needed to hash a password, and should
	// be tuned as processor speeds and memory technologies advance.
	Parallelization int64 `json:"parallelization,omitempty"`
	// Possible values:
	//   "UNSPECIFIED_ORDER" - The order is not specified.
	//   "SALT_AND_PASSWORD" - The order is salt first, and then password.
	//   "PASSWORD_AND_SALT" - The order is password first, and then salt.
	PasswordHashOrder string `json:"passwordHashOrder,omitempty"`
	// Rounds: The number of rounds used for hash calculation. Only required for
	// the following hashing functions: * MD5 * SHA1 * SHA256 * SHA512 * PBKDF_SHA1
	// * PBKDF2_SHA256 * SCRYPT
	Rounds int64 `json:"rounds,omitempty"`
	// SaltSeparator: One or more bytes to be inserted between the salt and plain
	// text password. For stronger security, this should be a single non-printable
	// character.
	SaltSeparator string `json:"saltSeparator,omitempty"`
	// SanityCheck: If true, the service will do the following list of checks
	// before an account is uploaded: * Duplicate emails * Duplicate federated IDs
	// * Federated ID provider validation If the duplication exists within the list
	// of accounts to be uploaded, it will prevent the entire list from being
	// uploaded. If the email or federated ID is a duplicate of a user already
	// within the project/tenant, the account will not be uploaded, but the rest of
	// the accounts will be unaffected. If false, these checks will be skipped.
	SanityCheck bool `json:"sanityCheck,omitempty"`
	// SignerKey: The signer key used to hash the password. Required for the
	// following hashing functions: * SCRYPT, * HMAC_MD5, * HMAC_SHA1, *
	// HMAC_SHA256, * HMAC_SHA512
	SignerKey string `json:"signerKey,omitempty"`
	// TenantId: The ID of the Identity Platform tenant the account belongs to.
	TenantId string `json:"tenantId,omitempty"`
	// Users: A list of accounts to upload. `local_id` is required for each user;
	// everything else is optional.
	Users []*GoogleCloudIdentitytoolkitV1UserInfo `json:"users,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowOverwrite") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowOverwrite") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1UploadAccountRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1UploadAccountRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1UploadAccountResponse: Response message for
// UploadAccount.
type GoogleCloudIdentitytoolkitV1UploadAccountResponse struct {
	// Error: Detailed error info for accounts that cannot be uploaded.
	Error []*GoogleCloudIdentitytoolkitV1ErrorInfo `json:"error,omitempty"`
	Kind  string                                   `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1UploadAccountResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1UploadAccountResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1UserInfo: An Identity Platform account's
// information.
type GoogleCloudIdentitytoolkitV1UserInfo struct {
	// CreatedAt: The time, in milliseconds from epoch, when the account was
	// created.
	CreatedAt int64 `json:"createdAt,omitempty,string"`
	// CustomAttributes: Custom claims to be added to any ID tokens minted for the
	// account. Should be at most 1,000 characters in length and in valid JSON
	// format.
	CustomAttributes string `json:"customAttributes,omitempty"`
	// CustomAuth: Output only. Whether this account has been authenticated using
	// SignInWithCustomToken.
	CustomAuth bool `json:"customAuth,omitempty"`
	// DateOfBirth: Output only. The date of birth set for the account. This
	// account attribute is not used by Identity Platform. It is available for
	// informational purposes only.
	DateOfBirth string `json:"dateOfBirth,omitempty"`
	// Disabled: Whether the account is disabled. Disabled accounts are
	// inaccessible except for requests bearing a Google OAuth2 credential with
	// proper permissions.
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: The display name of the account. This account attribute is not
	// used by Identity Platform. It is available for informational purposes only.
	DisplayName string `json:"displayName,omitempty"`
	// Email: The account's email address. The length of the email should be less
	// than 256 characters and in the format of `name@domain.tld`. The email should
	// also match the RFC 822 (https://tools.ietf.org/html/rfc822) addr-spec.
	Email string `json:"email,omitempty"`
	// EmailLinkSignin: Output only. Whether the account can authenticate with
	// email link.
	EmailLinkSignin bool `json:"emailLinkSignin,omitempty"`
	// EmailVerified: Whether the account's email address has been verified.
	EmailVerified bool `json:"emailVerified,omitempty"`
	// InitialEmail: The first email address associated with this account. The
	// account's initial email cannot be changed once set and is used to recover
	// access to this account if lost via the RECOVER_EMAIL flow in GetOobCode.
	// Should match the RFC 822 (https://tools.ietf.org/html/rfc822) addr-spec.
	InitialEmail string `json:"initialEmail,omitempty"`
	// Language: Output only. The language preference of the account. This account
	// attribute is not used by Identity Platform. It is available for
	// informational purposes only.
	Language string `json:"language,omitempty"`
	// LastLoginAt: The last time, in milliseconds from epoch, this account was
	// logged into.
	LastLoginAt int64 `json:"lastLoginAt,omitempty,string"`
	// LastRefreshAt: Timestamp when an ID token was last minted for this account.
	LastRefreshAt string `json:"lastRefreshAt,omitempty"`
	// LocalId: Immutable. The unique ID of the account.
	LocalId string `json:"localId,omitempty"`
	// MfaInfo: Information on which multi-factor authentication providers are
	// enabled for this account.
	MfaInfo []*GoogleCloudIdentitytoolkitV1MfaEnrollment `json:"mfaInfo,omitempty"`
	// PasswordHash: The account's hashed password. Only accessible by requests
	// bearing a Google OAuth2 credential with proper permissions
	// (https://cloud.google.com/identity-platform/docs/access-control).
	PasswordHash string `json:"passwordHash,omitempty"`
	// PasswordUpdatedAt: The timestamp, in milliseconds from the epoch of
	// 1970-01-01T00:00:00Z, when the account's password was last updated.
	PasswordUpdatedAt float64 `json:"passwordUpdatedAt,omitempty"`
	// PhoneNumber: The account's phone number.
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// PhotoUrl: The URL of the account's profile photo. This account attribute is
	// not used by Identity Platform. It is available for informational purposes
	// only.
	PhotoUrl string `json:"photoUrl,omitempty"`
	// ProviderUserInfo: Information about the user as provided by various Identity
	// Providers.
	ProviderUserInfo []*GoogleCloudIdentitytoolkitV1ProviderUserInfo `json:"providerUserInfo,omitempty"`
	// RawPassword: Input only. Plain text password used to update a account's
	// password. This field is only ever used as input in a request. Identity
	// Platform uses cryptographically secure hashing when managing passwords and
	// will never store or transmit a user's password in plain text.
	RawPassword string `json:"rawPassword,omitempty"`
	// Salt: The account's password salt. Only accessible by requests bearing a
	// Google OAuth2 credential with proper permissions.
	Salt string `json:"salt,omitempty"`
	// ScreenName: Output only. This account's screen name at Twitter or login name
	// at GitHub.
	ScreenName string `json:"screenName,omitempty"`
	// TenantId: ID of the tenant this account belongs to. Only set if this account
	// belongs to a tenant.
	TenantId string `json:"tenantId,omitempty"`
	// TimeZone: Output only. The time zone preference of the account. This account
	// attribute is not used by Identity Platform. It is available for
	// informational purposes only.
	TimeZone string `json:"timeZone,omitempty"`
	// ValidSince: Oldest timestamp, in seconds since epoch, that an ID token
	// should be considered valid. All ID tokens issued before this time are
	// considered invalid.
	ValidSince int64 `json:"validSince,omitempty,string"`
	// Version: The version of the account's password. Only accessible by requests
	// bearing a Google OAuth2 credential with proper permissions.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreatedAt") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreatedAt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1UserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudIdentitytoolkitV1UserInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudIdentitytoolkitV1UserInfo
	var s1 struct {
		PasswordUpdatedAt gensupport.JSONFloat64 `json:"passwordUpdatedAt"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PasswordUpdatedAt = float64(s1.PasswordUpdatedAt)
	return nil
}

// GoogleCloudIdentitytoolkitV1UserNotification: Warning notifications for the
// user.
type GoogleCloudIdentitytoolkitV1UserNotification struct {
	// NotificationCode: Warning notification enum. Can be used for localization.
	//
	// Possible values:
	//   "NOTIFICATION_CODE_UNSPECIFIED" - No notification specified.
	//   "MISSING_LOWERCASE_CHARACTER" - Password missing lowercase character.
	//   "MISSING_UPPERCASE_CHARACTER" - Password missing uppercase character.
	//   "MISSING_NUMERIC_CHARACTER" - Password missing numeric character.
	//   "MISSING_NON_ALPHANUMERIC_CHARACTER" - Password missing non alphanumeric
	// character.
	//   "MINIMUM_PASSWORD_LENGTH" - Password less than minimum required length.
	//   "MAXIMUM_PASSWORD_LENGTH" - Password greater than maximum required length.
	NotificationCode string `json:"notificationCode,omitempty"`
	// NotificationMessage: Warning notification string. Can be used as fallback.
	NotificationMessage string `json:"notificationMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotificationCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotificationCode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1UserNotification) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1UserNotification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1VerifyIosClientRequest: Request message for
// VerifyIosClient
type GoogleCloudIdentitytoolkitV1VerifyIosClientRequest struct {
	// AppToken: A device token that the iOS client gets after registering to APNs
	// (Apple Push Notification service).
	AppToken string `json:"appToken,omitempty"`
	// IsSandbox: Whether the app token is in the iOS sandbox. If false, the app
	// token is in the production environment.
	IsSandbox bool `json:"isSandbox,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1VerifyIosClientRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1VerifyIosClientRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudIdentitytoolkitV1VerifyIosClientResponse: Response message for
// VerifyIosClient.
type GoogleCloudIdentitytoolkitV1VerifyIosClientResponse struct {
	// Receipt: Receipt of successful app token validation.
	Receipt string `json:"receipt,omitempty"`
	// SuggestedTimeout: Suggested time that the client should wait in seconds for
	// delivery of the push notification.
	SuggestedTimeout int64 `json:"suggestedTimeout,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Receipt") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Receipt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudIdentitytoolkitV1VerifyIosClientResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudIdentitytoolkitV1VerifyIosClientResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsCreateAuthUriCall struct {
	s                                                *Service
	googlecloudidentitytoolkitv1createauthurirequest *GoogleCloudIdentitytoolkitV1CreateAuthUriRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// CreateAuthUri: If an email identifier is specified, checks and returns if
// any user account is registered with the email. If there is a registered
// account, fetches all providers associated with the account's email. If the
// provider ID of an Identity Provider (IdP) is specified, creates an
// authorization URI for the IdP. The user can be directed to this URI to sign
// in with the IdP. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
func (r *AccountsService) CreateAuthUri(googlecloudidentitytoolkitv1createauthurirequest *GoogleCloudIdentitytoolkitV1CreateAuthUriRequest) *AccountsCreateAuthUriCall {
	c := &AccountsCreateAuthUriCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1createauthurirequest = googlecloudidentitytoolkitv1createauthurirequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsCreateAuthUriCall) Fields(s ...googleapi.Field) *AccountsCreateAuthUriCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsCreateAuthUriCall) Context(ctx context.Context) *AccountsCreateAuthUriCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsCreateAuthUriCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsCreateAuthUriCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1createauthurirequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:createAuthUri")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.createAuthUri", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.createAuthUri" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1CreateAuthUriResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsCreateAuthUriCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1CreateAuthUriResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1CreateAuthUriResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.createAuthUri", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsDeleteCall struct {
	s                                                *Service
	googlecloudidentitytoolkitv1deleteaccountrequest *GoogleCloudIdentitytoolkitV1DeleteAccountRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Delete: Deletes a user's account.
func (r *AccountsService) Delete(googlecloudidentitytoolkitv1deleteaccountrequest *GoogleCloudIdentitytoolkitV1DeleteAccountRequest) *AccountsDeleteCall {
	c := &AccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1deleteaccountrequest = googlecloudidentitytoolkitv1deleteaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsDeleteCall) Fields(s ...googleapi.Field) *AccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsDeleteCall) Context(ctx context.Context) *AccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1deleteaccountrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:delete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.delete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1DeleteAccountResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1DeleteAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1DeleteAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsIssueSamlResponseCall struct {
	s                                                    *Service
	googlecloudidentitytoolkitv1issuesamlresponserequest *GoogleCloudIdentitytoolkitV1IssueSamlResponseRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// IssueSamlResponse: Experimental
func (r *AccountsService) IssueSamlResponse(googlecloudidentitytoolkitv1issuesamlresponserequest *GoogleCloudIdentitytoolkitV1IssueSamlResponseRequest) *AccountsIssueSamlResponseCall {
	c := &AccountsIssueSamlResponseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1issuesamlresponserequest = googlecloudidentitytoolkitv1issuesamlresponserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsIssueSamlResponseCall) Fields(s ...googleapi.Field) *AccountsIssueSamlResponseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsIssueSamlResponseCall) Context(ctx context.Context) *AccountsIssueSamlResponseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsIssueSamlResponseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsIssueSamlResponseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1issuesamlresponserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:issueSamlResponse")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.issueSamlResponse", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.issueSamlResponse" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1IssueSamlResponseResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsIssueSamlResponseCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1IssueSamlResponseResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1IssueSamlResponseResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.issueSamlResponse", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsLookupCall struct {
	s                                                 *Service
	googlecloudidentitytoolkitv1getaccountinforequest *GoogleCloudIdentitytoolkitV1GetAccountInfoRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Lookup: Gets account information for all matched accounts. For an end user
// request, retrieves the account of the end user. For an admin request with
// Google OAuth 2.0 credential, retrieves one or multiple account(s) with
// matching criteria.
func (r *AccountsService) Lookup(googlecloudidentitytoolkitv1getaccountinforequest *GoogleCloudIdentitytoolkitV1GetAccountInfoRequest) *AccountsLookupCall {
	c := &AccountsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1getaccountinforequest = googlecloudidentitytoolkitv1getaccountinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsLookupCall) Fields(s ...googleapi.Field) *AccountsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsLookupCall) Context(ctx context.Context) *AccountsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1getaccountinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.lookup", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetAccountInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsLookupCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetAccountInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetAccountInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.lookup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsResetPasswordCall struct {
	s                                                *Service
	googlecloudidentitytoolkitv1resetpasswordrequest *GoogleCloudIdentitytoolkitV1ResetPasswordRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// ResetPassword: Resets the password of an account either using an out-of-band
// code generated by sendOobCode or by specifying the email and password of the
// account to be modified. Can also check the purpose of an out-of-band code
// without consuming it.
func (r *AccountsService) ResetPassword(googlecloudidentitytoolkitv1resetpasswordrequest *GoogleCloudIdentitytoolkitV1ResetPasswordRequest) *AccountsResetPasswordCall {
	c := &AccountsResetPasswordCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1resetpasswordrequest = googlecloudidentitytoolkitv1resetpasswordrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsResetPasswordCall) Fields(s ...googleapi.Field) *AccountsResetPasswordCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsResetPasswordCall) Context(ctx context.Context) *AccountsResetPasswordCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsResetPasswordCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsResetPasswordCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1resetpasswordrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:resetPassword")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.resetPassword", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.resetPassword" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1ResetPasswordResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsResetPasswordCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1ResetPasswordResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1ResetPasswordResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.resetPassword", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSendOobCodeCall struct {
	s                                             *Service
	googlecloudidentitytoolkitv1getoobcoderequest *GoogleCloudIdentitytoolkitV1GetOobCodeRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// SendOobCode: Sends an out-of-band confirmation code for an account. Requests
// from a authenticated request can optionally return a link including the OOB
// code instead of sending it.
func (r *AccountsService) SendOobCode(googlecloudidentitytoolkitv1getoobcoderequest *GoogleCloudIdentitytoolkitV1GetOobCodeRequest) *AccountsSendOobCodeCall {
	c := &AccountsSendOobCodeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1getoobcoderequest = googlecloudidentitytoolkitv1getoobcoderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSendOobCodeCall) Fields(s ...googleapi.Field) *AccountsSendOobCodeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSendOobCodeCall) Context(ctx context.Context) *AccountsSendOobCodeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSendOobCodeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSendOobCodeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1getoobcoderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:sendOobCode")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.sendOobCode", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.sendOobCode" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetOobCodeResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsSendOobCodeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetOobCodeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetOobCodeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.sendOobCode", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSendVerificationCodeCall struct {
	s                                                       *Service
	googlecloudidentitytoolkitv1sendverificationcoderequest *GoogleCloudIdentitytoolkitV1SendVerificationCodeRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// SendVerificationCode: Sends a SMS verification code for phone number
// sign-in. To localize the text of the SMS sent to the user, set the HTTP
// header `X-Firebase-Locale` to the language code that corresponds with the
// user's locale. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
func (r *AccountsService) SendVerificationCode(googlecloudidentitytoolkitv1sendverificationcoderequest *GoogleCloudIdentitytoolkitV1SendVerificationCodeRequest) *AccountsSendVerificationCodeCall {
	c := &AccountsSendVerificationCodeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1sendverificationcoderequest = googlecloudidentitytoolkitv1sendverificationcoderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSendVerificationCodeCall) Fields(s ...googleapi.Field) *AccountsSendVerificationCodeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSendVerificationCodeCall) Context(ctx context.Context) *AccountsSendVerificationCodeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSendVerificationCodeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSendVerificationCodeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1sendverificationcoderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:sendVerificationCode")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.sendVerificationCode", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.sendVerificationCode" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SendVerificationCodeResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsSendVerificationCodeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SendVerificationCodeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SendVerificationCodeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.sendVerificationCode", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSignInWithCustomTokenCall struct {
	s                                                        *Service
	googlecloudidentitytoolkitv1signinwithcustomtokenrequest *GoogleCloudIdentitytoolkitV1SignInWithCustomTokenRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// SignInWithCustomToken: Signs in or signs up a user by exchanging a custom
// Auth token. Upon a successful sign-in or sign-up, a new Identity Platform ID
// token and refresh token are issued for the user. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
func (r *AccountsService) SignInWithCustomToken(googlecloudidentitytoolkitv1signinwithcustomtokenrequest *GoogleCloudIdentitytoolkitV1SignInWithCustomTokenRequest) *AccountsSignInWithCustomTokenCall {
	c := &AccountsSignInWithCustomTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1signinwithcustomtokenrequest = googlecloudidentitytoolkitv1signinwithcustomtokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSignInWithCustomTokenCall) Fields(s ...googleapi.Field) *AccountsSignInWithCustomTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSignInWithCustomTokenCall) Context(ctx context.Context) *AccountsSignInWithCustomTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSignInWithCustomTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSignInWithCustomTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signinwithcustomtokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:signInWithCustomToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithCustomToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.signInWithCustomToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignInWithCustomTokenResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsSignInWithCustomTokenCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignInWithCustomTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignInWithCustomTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithCustomToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSignInWithEmailLinkCall struct {
	s                                                      *Service
	googlecloudidentitytoolkitv1signinwithemaillinkrequest *GoogleCloudIdentitytoolkitV1SignInWithEmailLinkRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// SignInWithEmailLink: Signs in or signs up a user with a out-of-band code
// from an email link. If a user does not exist with the given email address, a
// user record will be created. If the sign-in succeeds, an Identity Platform
// ID and refresh token are issued for the authenticated user. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
func (r *AccountsService) SignInWithEmailLink(googlecloudidentitytoolkitv1signinwithemaillinkrequest *GoogleCloudIdentitytoolkitV1SignInWithEmailLinkRequest) *AccountsSignInWithEmailLinkCall {
	c := &AccountsSignInWithEmailLinkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1signinwithemaillinkrequest = googlecloudidentitytoolkitv1signinwithemaillinkrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSignInWithEmailLinkCall) Fields(s ...googleapi.Field) *AccountsSignInWithEmailLinkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSignInWithEmailLinkCall) Context(ctx context.Context) *AccountsSignInWithEmailLinkCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSignInWithEmailLinkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSignInWithEmailLinkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signinwithemaillinkrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:signInWithEmailLink")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithEmailLink", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.signInWithEmailLink" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignInWithEmailLinkResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsSignInWithEmailLinkCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignInWithEmailLinkResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignInWithEmailLinkResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithEmailLink", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSignInWithGameCenterCall struct {
	s                                                       *Service
	googlecloudidentitytoolkitv1signinwithgamecenterrequest *GoogleCloudIdentitytoolkitV1SignInWithGameCenterRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// SignInWithGameCenter: Signs in or signs up a user with iOS Game Center
// credentials. If the sign-in succeeds, a new Identity Platform ID token and
// refresh token are issued for the authenticated user. The bundle ID is
// required in the request header as `x-ios-bundle-identifier`. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project. Apple has deprecated
// the `playerID` field
// (https://developer.apple.com/documentation/gamekit/gkplayer/1521127-playerid/).
// The Apple platform Firebase SDK will use `gamePlayerID` and `teamPlayerID`
// from version 10.5.0 and onwards. Upgrading to SDK version 10.5.0 or later
// updates existing integrations that use `playerID` to instead use
// `gamePlayerID` and `teamPlayerID`. When making calls to
// `signInWithGameCenter`, you must include `playerID` along with the new
// fields `gamePlayerID` and `teamPlayerID` to successfully identify all
// existing users. Upgrading existing Game Center sign in integrations to SDK
// version 10.5.0 or later is irreversible.
func (r *AccountsService) SignInWithGameCenter(googlecloudidentitytoolkitv1signinwithgamecenterrequest *GoogleCloudIdentitytoolkitV1SignInWithGameCenterRequest) *AccountsSignInWithGameCenterCall {
	c := &AccountsSignInWithGameCenterCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1signinwithgamecenterrequest = googlecloudidentitytoolkitv1signinwithgamecenterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSignInWithGameCenterCall) Fields(s ...googleapi.Field) *AccountsSignInWithGameCenterCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSignInWithGameCenterCall) Context(ctx context.Context) *AccountsSignInWithGameCenterCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSignInWithGameCenterCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSignInWithGameCenterCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signinwithgamecenterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:signInWithGameCenter")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithGameCenter", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.signInWithGameCenter" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignInWithGameCenterResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsSignInWithGameCenterCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignInWithGameCenterResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignInWithGameCenterResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithGameCenter", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSignInWithIdpCall struct {
	s                                                *Service
	googlecloudidentitytoolkitv1signinwithidprequest *GoogleCloudIdentitytoolkitV1SignInWithIdpRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// SignInWithIdp: Signs in or signs up a user using credentials from an
// Identity Provider (IdP). This is done by manually providing an IdP
// credential, or by providing the authorization response obtained via the
// authorization request from CreateAuthUri. If the sign-in succeeds, a new
// Identity Platform ID token and refresh token are issued for the
// authenticated user. A new Identity Platform user account will be created if
// the user has not previously signed in to the IdP with the same account. In
// addition, when the "One account per email address" setting is enabled, there
// should not be an existing Identity Platform user account with the same email
// address for a new user account to be created. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
func (r *AccountsService) SignInWithIdp(googlecloudidentitytoolkitv1signinwithidprequest *GoogleCloudIdentitytoolkitV1SignInWithIdpRequest) *AccountsSignInWithIdpCall {
	c := &AccountsSignInWithIdpCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1signinwithidprequest = googlecloudidentitytoolkitv1signinwithidprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSignInWithIdpCall) Fields(s ...googleapi.Field) *AccountsSignInWithIdpCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSignInWithIdpCall) Context(ctx context.Context) *AccountsSignInWithIdpCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSignInWithIdpCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSignInWithIdpCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signinwithidprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:signInWithIdp")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithIdp", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.signInWithIdp" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignInWithIdpResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsSignInWithIdpCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignInWithIdpResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignInWithIdpResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithIdp", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSignInWithPasswordCall struct {
	s                                                     *Service
	googlecloudidentitytoolkitv1signinwithpasswordrequest *GoogleCloudIdentitytoolkitV1SignInWithPasswordRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// SignInWithPassword: Signs in a user with email and password. If the sign-in
// succeeds, a new Identity Platform ID token and refresh token are issued for
// the authenticated user. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
func (r *AccountsService) SignInWithPassword(googlecloudidentitytoolkitv1signinwithpasswordrequest *GoogleCloudIdentitytoolkitV1SignInWithPasswordRequest) *AccountsSignInWithPasswordCall {
	c := &AccountsSignInWithPasswordCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1signinwithpasswordrequest = googlecloudidentitytoolkitv1signinwithpasswordrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSignInWithPasswordCall) Fields(s ...googleapi.Field) *AccountsSignInWithPasswordCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSignInWithPasswordCall) Context(ctx context.Context) *AccountsSignInWithPasswordCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSignInWithPasswordCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSignInWithPasswordCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signinwithpasswordrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:signInWithPassword")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithPassword", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.signInWithPassword" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignInWithPasswordResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsSignInWithPasswordCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignInWithPasswordResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignInWithPasswordResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithPassword", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSignInWithPhoneNumberCall struct {
	s                                                        *Service
	googlecloudidentitytoolkitv1signinwithphonenumberrequest *GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// SignInWithPhoneNumber: Completes a phone number authentication attempt. If a
// user already exists with the given phone number, an ID token is minted for
// that user. Otherwise, a new user is created and associated with the phone
// number. This method may also be used to link a phone number to an existing
// user. To localize the text of the SMS sent to the user, set the HTTP header
// `X-Firebase-Locale` to the language code that corresponds with the user's
// locale. An API key (https://cloud.google.com/docs/authentication/api-keys)
// is required in the request in order to identify the Google Cloud project.
func (r *AccountsService) SignInWithPhoneNumber(googlecloudidentitytoolkitv1signinwithphonenumberrequest *GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberRequest) *AccountsSignInWithPhoneNumberCall {
	c := &AccountsSignInWithPhoneNumberCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1signinwithphonenumberrequest = googlecloudidentitytoolkitv1signinwithphonenumberrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSignInWithPhoneNumberCall) Fields(s ...googleapi.Field) *AccountsSignInWithPhoneNumberCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSignInWithPhoneNumberCall) Context(ctx context.Context) *AccountsSignInWithPhoneNumberCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSignInWithPhoneNumberCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSignInWithPhoneNumberCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signinwithphonenumberrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:signInWithPhoneNumber")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithPhoneNumber", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.signInWithPhoneNumber" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsSignInWithPhoneNumberCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignInWithPhoneNumberResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signInWithPhoneNumber", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsSignUpCall struct {
	s                                         *Service
	googlecloudidentitytoolkitv1signuprequest *GoogleCloudIdentitytoolkitV1SignUpRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// SignUp: Signs up a new email and password user or anonymous user, or
// upgrades an anonymous user to email and password. For an admin request with
// a Google OAuth 2.0 credential with the proper permissions
// (https://cloud.google.com/identity-platform/docs/access-control), creates a
// new anonymous, email and password, or phone number user. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
func (r *AccountsService) SignUp(googlecloudidentitytoolkitv1signuprequest *GoogleCloudIdentitytoolkitV1SignUpRequest) *AccountsSignUpCall {
	c := &AccountsSignUpCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1signuprequest = googlecloudidentitytoolkitv1signuprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsSignUpCall) Fields(s ...googleapi.Field) *AccountsSignUpCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsSignUpCall) Context(ctx context.Context) *AccountsSignUpCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsSignUpCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSignUpCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signuprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:signUp")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signUp", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.signUp" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignUpResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsSignUpCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignUpResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignUpResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.signUp", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsUpdateCall struct {
	s                                                 *Service
	googlecloudidentitytoolkitv1setaccountinforequest *GoogleCloudIdentitytoolkitV1SetAccountInfoRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Update: Updates account-related information for the specified user by
// setting specific fields or applying action codes. Requests from
// administrators and end users are supported.
func (r *AccountsService) Update(googlecloudidentitytoolkitv1setaccountinforequest *GoogleCloudIdentitytoolkitV1SetAccountInfoRequest) *AccountsUpdateCall {
	c := &AccountsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1setaccountinforequest = googlecloudidentitytoolkitv1setaccountinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsUpdateCall) Fields(s ...googleapi.Field) *AccountsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsUpdateCall) Context(ctx context.Context) *AccountsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1setaccountinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:update")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SetAccountInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SetAccountInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SetAccountInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type AccountsVerifyIosClientCall struct {
	s                                                  *Service
	googlecloudidentitytoolkitv1verifyiosclientrequest *GoogleCloudIdentitytoolkitV1VerifyIosClientRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// VerifyIosClient: Verifies an iOS client is a real iOS device. If the request
// is valid, a receipt will be sent in the response and a secret will be sent
// via Apple Push Notification Service. The client should send both of them
// back to certain Identity Platform APIs in a later call (for example,
// /accounts:sendVerificationCode), in order to verify the client. The bundle
// ID is required in the request header as `x-ios-bundle-identifier`. An API
// key (https://cloud.google.com/docs/authentication/api-keys) is required in
// the request in order to identify the Google Cloud project.
func (r *AccountsService) VerifyIosClient(googlecloudidentitytoolkitv1verifyiosclientrequest *GoogleCloudIdentitytoolkitV1VerifyIosClientRequest) *AccountsVerifyIosClientCall {
	c := &AccountsVerifyIosClientCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudidentitytoolkitv1verifyiosclientrequest = googlecloudidentitytoolkitv1verifyiosclientrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsVerifyIosClientCall) Fields(s ...googleapi.Field) *AccountsVerifyIosClientCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsVerifyIosClientCall) Context(ctx context.Context) *AccountsVerifyIosClientCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsVerifyIosClientCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsVerifyIosClientCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1verifyiosclientrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/accounts:verifyIosClient")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.verifyIosClient", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.accounts.verifyIosClient" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1VerifyIosClientResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AccountsVerifyIosClientCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1VerifyIosClientResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1VerifyIosClientResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.accounts.verifyIosClient", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsCall struct {
	s                                         *Service
	targetProjectId                           string
	googlecloudidentitytoolkitv1signuprequest *GoogleCloudIdentitytoolkitV1SignUpRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Accounts: Signs up a new email and password user or anonymous user, or
// upgrades an anonymous user to email and password. For an admin request with
// a Google OAuth 2.0 credential with the proper permissions
// (https://cloud.google.com/identity-platform/docs/access-control), creates a
// new anonymous, email and password, or phone number user. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
//
//   - targetProjectId: The project ID of the project which the user should
//     belong to. Specifying this field requires a Google OAuth 2.0 credential
//     with the proper permissions
//     (https://cloud.google.com/identity-platform/docs/access-control). If this
//     is not set, the target project is inferred from the scope associated to
//     the Bearer access token.
func (r *ProjectsService) Accounts(targetProjectId string, googlecloudidentitytoolkitv1signuprequest *GoogleCloudIdentitytoolkitV1SignUpRequest) *ProjectsAccountsCall {
	c := &ProjectsAccountsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1signuprequest = googlecloudidentitytoolkitv1signuprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsCall) Fields(s ...googleapi.Field) *ProjectsAccountsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsCall) Context(ctx context.Context) *ProjectsAccountsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signuprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignUpResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignUpResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignUpResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsCreateSessionCookieCall struct {
	s                                                      *Service
	targetProjectId                                        string
	googlecloudidentitytoolkitv1createsessioncookierequest *GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// CreateSessionCookie: Creates a session cookie for the given Identity
// Platform ID token. The session cookie is used by the client to preserve the
// user's login state.
//
// - targetProjectId: The ID of the project that the account belongs to.
func (r *ProjectsService) CreateSessionCookie(targetProjectId string, googlecloudidentitytoolkitv1createsessioncookierequest *GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest) *ProjectsCreateSessionCookieCall {
	c := &ProjectsCreateSessionCookieCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1createsessioncookierequest = googlecloudidentitytoolkitv1createsessioncookierequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsCreateSessionCookieCall) Fields(s ...googleapi.Field) *ProjectsCreateSessionCookieCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsCreateSessionCookieCall) Context(ctx context.Context) *ProjectsCreateSessionCookieCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsCreateSessionCookieCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsCreateSessionCookieCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1createsessioncookierequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}:createSessionCookie")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.createSessionCookie", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.createSessionCookie" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsCreateSessionCookieCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.createSessionCookie", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsQueryAccountsCall struct {
	s                                                *Service
	targetProjectId                                  string
	googlecloudidentitytoolkitv1queryuserinforequest *GoogleCloudIdentitytoolkitV1QueryUserInfoRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// QueryAccounts: Looks up user accounts within a project or a tenant based on
// conditions in the request.
//
// - targetProjectId: The ID of the project to which the result is scoped.
func (r *ProjectsService) QueryAccounts(targetProjectId string, googlecloudidentitytoolkitv1queryuserinforequest *GoogleCloudIdentitytoolkitV1QueryUserInfoRequest) *ProjectsQueryAccountsCall {
	c := &ProjectsQueryAccountsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1queryuserinforequest = googlecloudidentitytoolkitv1queryuserinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsQueryAccountsCall) Fields(s ...googleapi.Field) *ProjectsQueryAccountsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsQueryAccountsCall) Context(ctx context.Context) *ProjectsQueryAccountsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsQueryAccountsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsQueryAccountsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1queryuserinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}:queryAccounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.queryAccounts", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.queryAccounts" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1QueryUserInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsQueryAccountsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1QueryUserInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1QueryUserInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.queryAccounts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsBatchCreateCall struct {
	s                                                *Service
	targetProjectId                                  string
	googlecloudidentitytoolkitv1uploadaccountrequest *GoogleCloudIdentitytoolkitV1UploadAccountRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// BatchCreate: Uploads multiple accounts into the Google Cloud project. If
// there is a problem uploading one or more of the accounts, the rest will be
// uploaded, and a list of the errors will be returned. To use this method
// requires a Google OAuth 2.0 credential with proper permissions
// (https://cloud.google.com/identity-platform/docs/access-control).
//
//   - targetProjectId: The Project ID of the Identity Platform project which the
//     account belongs to.
func (r *ProjectsAccountsService) BatchCreate(targetProjectId string, googlecloudidentitytoolkitv1uploadaccountrequest *GoogleCloudIdentitytoolkitV1UploadAccountRequest) *ProjectsAccountsBatchCreateCall {
	c := &ProjectsAccountsBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1uploadaccountrequest = googlecloudidentitytoolkitv1uploadaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsBatchCreateCall) Fields(s ...googleapi.Field) *ProjectsAccountsBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsBatchCreateCall) Context(ctx context.Context) *ProjectsAccountsBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1uploadaccountrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.batchCreate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.batchCreate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1UploadAccountResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1UploadAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1UploadAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.batchCreate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsBatchDeleteCall struct {
	s                                                      *Service
	targetProjectId                                        string
	googlecloudidentitytoolkitv1batchdeleteaccountsrequest *GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchDelete: Batch deletes multiple accounts. For accounts that fail to be
// deleted, error info is contained in the response. The method ignores
// accounts that do not exist or are duplicated in the request. This method
// requires a Google OAuth 2.0 credential with proper [permissions]
// (https://cloud.google.com/identity-platform/docs/access-control).
//
//   - targetProjectId: If `tenant_id` is specified, the ID of the Google Cloud
//     project that the Identity Platform tenant belongs to. Otherwise, the ID of
//     the Google Cloud project that accounts belong to.
func (r *ProjectsAccountsService) BatchDelete(targetProjectId string, googlecloudidentitytoolkitv1batchdeleteaccountsrequest *GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest) *ProjectsAccountsBatchDeleteCall {
	c := &ProjectsAccountsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1batchdeleteaccountsrequest = googlecloudidentitytoolkitv1batchdeleteaccountsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsBatchDeleteCall) Fields(s ...googleapi.Field) *ProjectsAccountsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsBatchDeleteCall) Context(ctx context.Context) *ProjectsAccountsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1batchdeleteaccountsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsBatchGetCall struct {
	s               *Service
	targetProjectId string
	urlParams_      gensupport.URLParams
	ifNoneMatch_    string
	ctx_            context.Context
	header_         http.Header
}

// BatchGet: Download account information for all accounts on the project in a
// paginated manner. To use this method requires a Google OAuth 2.0 credential
// with proper permissions
// (https://cloud.google.com/identity-platform/docs/access-control)..
// Furthermore, additional permissions are needed to get password hash,
// password salt, and password version from accounts; otherwise these fields
// are redacted.
//
//   - targetProjectId: If `tenant_id` is specified, the ID of the Google Cloud
//     project that the Identity Platform tenant belongs to. Otherwise, the ID of
//     the Google Cloud project that the accounts belong to.
func (r *ProjectsAccountsService) BatchGet(targetProjectId string) *ProjectsAccountsBatchGetCall {
	c := &ProjectsAccountsBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	return c
}

// DelegatedProjectNumber sets the optional parameter "delegatedProjectNumber":
func (c *ProjectsAccountsBatchGetCall) DelegatedProjectNumber(delegatedProjectNumber int64) *ProjectsAccountsBatchGetCall {
	c.urlParams_.Set("delegatedProjectNumber", fmt.Sprint(delegatedProjectNumber))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results to return. Must be at least 1 and no greater than 1000. By default,
// it is 20.
func (c *ProjectsAccountsBatchGetCall) MaxResults(maxResults int64) *ProjectsAccountsBatchGetCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// NextPageToken sets the optional parameter "nextPageToken": The pagination
// token from the response of a previous request.
func (c *ProjectsAccountsBatchGetCall) NextPageToken(nextPageToken string) *ProjectsAccountsBatchGetCall {
	c.urlParams_.Set("nextPageToken", nextPageToken)
	return c
}

// TenantId sets the optional parameter "tenantId": The ID of the Identity
// Platform tenant the accounts belongs to. If not specified, accounts on the
// Identity Platform project are returned.
func (c *ProjectsAccountsBatchGetCall) TenantId(tenantId string) *ProjectsAccountsBatchGetCall {
	c.urlParams_.Set("tenantId", tenantId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsBatchGetCall) Fields(s ...googleapi.Field) *ProjectsAccountsBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAccountsBatchGetCall) IfNoneMatch(entityTag string) *ProjectsAccountsBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsBatchGetCall) Context(ctx context.Context) *ProjectsAccountsBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1DownloadAccountResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1DownloadAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1DownloadAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAccountsBatchGetCall) Pages(ctx context.Context, f func(*GoogleCloudIdentitytoolkitV1DownloadAccountResponse) error) error {
	c.ctx_ = ctx
	defer c.NextPageToken(c.urlParams_.Get("nextPageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.NextPageToken(x.NextPageToken)
	}
}

type ProjectsAccountsDeleteCall struct {
	s                                                *Service
	targetProjectId                                  string
	googlecloudidentitytoolkitv1deleteaccountrequest *GoogleCloudIdentitytoolkitV1DeleteAccountRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Delete: Deletes a user's account.
//
//   - targetProjectId: The ID of the project which the account belongs to.
//     Should only be specified in authenticated requests that specify local_id
//     of an account.
func (r *ProjectsAccountsService) Delete(targetProjectId string, googlecloudidentitytoolkitv1deleteaccountrequest *GoogleCloudIdentitytoolkitV1DeleteAccountRequest) *ProjectsAccountsDeleteCall {
	c := &ProjectsAccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1deleteaccountrequest = googlecloudidentitytoolkitv1deleteaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsDeleteCall) Fields(s ...googleapi.Field) *ProjectsAccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsDeleteCall) Context(ctx context.Context) *ProjectsAccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1deleteaccountrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:delete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.delete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1DeleteAccountResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1DeleteAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1DeleteAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsLookupCall struct {
	s                                                 *Service
	targetProjectId                                   string
	googlecloudidentitytoolkitv1getaccountinforequest *GoogleCloudIdentitytoolkitV1GetAccountInfoRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Lookup: Gets account information for all matched accounts. For an end user
// request, retrieves the account of the end user. For an admin request with
// Google OAuth 2.0 credential, retrieves one or multiple account(s) with
// matching criteria.
//
//   - targetProjectId: The ID of the Google Cloud project that the account or
//     the Identity Platform tenant specified by `tenant_id` belongs to. Should
//     only be specified by authenticated requests bearing a Google OAuth 2.0
//     credential with proper permissions
//     (https://cloud.google.com/identity-platform/docs/access-control).
func (r *ProjectsAccountsService) Lookup(targetProjectId string, googlecloudidentitytoolkitv1getaccountinforequest *GoogleCloudIdentitytoolkitV1GetAccountInfoRequest) *ProjectsAccountsLookupCall {
	c := &ProjectsAccountsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1getaccountinforequest = googlecloudidentitytoolkitv1getaccountinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsLookupCall) Fields(s ...googleapi.Field) *ProjectsAccountsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsLookupCall) Context(ctx context.Context) *ProjectsAccountsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1getaccountinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.lookup", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetAccountInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsLookupCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetAccountInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetAccountInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.lookup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsQueryCall struct {
	s                                                *Service
	targetProjectId                                  string
	googlecloudidentitytoolkitv1queryuserinforequest *GoogleCloudIdentitytoolkitV1QueryUserInfoRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Query: Looks up user accounts within a project or a tenant based on
// conditions in the request.
//
// - targetProjectId: The ID of the project to which the result is scoped.
func (r *ProjectsAccountsService) Query(targetProjectId string, googlecloudidentitytoolkitv1queryuserinforequest *GoogleCloudIdentitytoolkitV1QueryUserInfoRequest) *ProjectsAccountsQueryCall {
	c := &ProjectsAccountsQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1queryuserinforequest = googlecloudidentitytoolkitv1queryuserinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsQueryCall) Fields(s ...googleapi.Field) *ProjectsAccountsQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsQueryCall) Context(ctx context.Context) *ProjectsAccountsQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1queryuserinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.query", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1QueryUserInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1QueryUserInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1QueryUserInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.query", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsSendOobCodeCall struct {
	s                                             *Service
	targetProjectId                               string
	googlecloudidentitytoolkitv1getoobcoderequest *GoogleCloudIdentitytoolkitV1GetOobCodeRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// SendOobCode: Sends an out-of-band confirmation code for an account. Requests
// from a authenticated request can optionally return a link including the OOB
// code instead of sending it.
//
//   - targetProjectId: The Project ID of the Identity Platform project which the
//     account belongs to. To specify this field, it requires a Google OAuth 2.0
//     credential with proper permissions
//     (https://cloud.google.com/identity-platform/docs/access-control).
func (r *ProjectsAccountsService) SendOobCode(targetProjectId string, googlecloudidentitytoolkitv1getoobcoderequest *GoogleCloudIdentitytoolkitV1GetOobCodeRequest) *ProjectsAccountsSendOobCodeCall {
	c := &ProjectsAccountsSendOobCodeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1getoobcoderequest = googlecloudidentitytoolkitv1getoobcoderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsSendOobCodeCall) Fields(s ...googleapi.Field) *ProjectsAccountsSendOobCodeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsSendOobCodeCall) Context(ctx context.Context) *ProjectsAccountsSendOobCodeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsSendOobCodeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsSendOobCodeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1getoobcoderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:sendOobCode")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.sendOobCode", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.sendOobCode" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetOobCodeResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsSendOobCodeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetOobCodeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetOobCodeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.sendOobCode", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAccountsUpdateCall struct {
	s                                                 *Service
	targetProjectId                                   string
	googlecloudidentitytoolkitv1setaccountinforequest *GoogleCloudIdentitytoolkitV1SetAccountInfoRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Update: Updates account-related information for the specified user by
// setting specific fields or applying action codes. Requests from
// administrators and end users are supported.
//
//   - targetProjectId: The project ID for the project that the account belongs
//     to. Specifying this field requires Google OAuth 2.0 credential with proper
//     [permissions]
//     (https://cloud.google.com/identity-platform/docs/access-control). Requests
//     from end users should pass an Identity Platform ID token instead.
func (r *ProjectsAccountsService) Update(targetProjectId string, googlecloudidentitytoolkitv1setaccountinforequest *GoogleCloudIdentitytoolkitV1SetAccountInfoRequest) *ProjectsAccountsUpdateCall {
	c := &ProjectsAccountsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.googlecloudidentitytoolkitv1setaccountinforequest = googlecloudidentitytoolkitv1setaccountinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAccountsUpdateCall) Fields(s ...googleapi.Field) *ProjectsAccountsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAccountsUpdateCall) Context(ctx context.Context) *ProjectsAccountsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAccountsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAccountsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1setaccountinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/accounts:update")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.accounts.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SetAccountInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAccountsUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SetAccountInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SetAccountInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.accounts.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsCall struct {
	s                                         *Service
	targetProjectId                           string
	tenantId                                  string
	googlecloudidentitytoolkitv1signuprequest *GoogleCloudIdentitytoolkitV1SignUpRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Accounts: Signs up a new email and password user or anonymous user, or
// upgrades an anonymous user to email and password. For an admin request with
// a Google OAuth 2.0 credential with the proper permissions
// (https://cloud.google.com/identity-platform/docs/access-control), creates a
// new anonymous, email and password, or phone number user. An API key
// (https://cloud.google.com/docs/authentication/api-keys) is required in the
// request in order to identify the Google Cloud project.
//
//   - targetProjectId: The project ID of the project which the user should
//     belong to. Specifying this field requires a Google OAuth 2.0 credential
//     with the proper permissions
//     (https://cloud.google.com/identity-platform/docs/access-control). If this
//     is not set, the target project is inferred from the scope associated to
//     the Bearer access token.
//   - tenantId: The ID of the Identity Platform tenant to create a user under.
//     If not set, the user will be created under the default Identity Platform
//     project.
func (r *ProjectsTenantsService) Accounts(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1signuprequest *GoogleCloudIdentitytoolkitV1SignUpRequest) *ProjectsTenantsAccountsCall {
	c := &ProjectsTenantsAccountsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1signuprequest = googlecloudidentitytoolkitv1signuprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsCall) Context(ctx context.Context) *ProjectsTenantsAccountsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1signuprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SignUpResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SignUpResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SignUpResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsCreateSessionCookieCall struct {
	s                                                      *Service
	targetProjectId                                        string
	tenantId                                               string
	googlecloudidentitytoolkitv1createsessioncookierequest *GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// CreateSessionCookie: Creates a session cookie for the given Identity
// Platform ID token. The session cookie is used by the client to preserve the
// user's login state.
//
//   - targetProjectId: The ID of the project that the account belongs to.
//   - tenantId: The tenant ID of the Identity Platform tenant the account
//     belongs to.
func (r *ProjectsTenantsService) CreateSessionCookie(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1createsessioncookierequest *GoogleCloudIdentitytoolkitV1CreateSessionCookieRequest) *ProjectsTenantsCreateSessionCookieCall {
	c := &ProjectsTenantsCreateSessionCookieCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1createsessioncookierequest = googlecloudidentitytoolkitv1createsessioncookierequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsCreateSessionCookieCall) Fields(s ...googleapi.Field) *ProjectsTenantsCreateSessionCookieCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsCreateSessionCookieCall) Context(ctx context.Context) *ProjectsTenantsCreateSessionCookieCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsCreateSessionCookieCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsCreateSessionCookieCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1createsessioncookierequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}:createSessionCookie")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.createSessionCookie", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.createSessionCookie" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsCreateSessionCookieCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1CreateSessionCookieResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.createSessionCookie", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsBatchCreateCall struct {
	s                                                *Service
	targetProjectId                                  string
	tenantId                                         string
	googlecloudidentitytoolkitv1uploadaccountrequest *GoogleCloudIdentitytoolkitV1UploadAccountRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// BatchCreate: Uploads multiple accounts into the Google Cloud project. If
// there is a problem uploading one or more of the accounts, the rest will be
// uploaded, and a list of the errors will be returned. To use this method
// requires a Google OAuth 2.0 credential with proper permissions
// (https://cloud.google.com/identity-platform/docs/access-control).
//
//   - targetProjectId: The Project ID of the Identity Platform project which the
//     account belongs to.
//   - tenantId: The ID of the Identity Platform tenant the account belongs to.
func (r *ProjectsTenantsAccountsService) BatchCreate(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1uploadaccountrequest *GoogleCloudIdentitytoolkitV1UploadAccountRequest) *ProjectsTenantsAccountsBatchCreateCall {
	c := &ProjectsTenantsAccountsBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1uploadaccountrequest = googlecloudidentitytoolkitv1uploadaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsBatchCreateCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsBatchCreateCall) Context(ctx context.Context) *ProjectsTenantsAccountsBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1uploadaccountrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.batchCreate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.batchCreate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1UploadAccountResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1UploadAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1UploadAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.batchCreate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsBatchDeleteCall struct {
	s                                                      *Service
	targetProjectId                                        string
	tenantId                                               string
	googlecloudidentitytoolkitv1batchdeleteaccountsrequest *GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchDelete: Batch deletes multiple accounts. For accounts that fail to be
// deleted, error info is contained in the response. The method ignores
// accounts that do not exist or are duplicated in the request. This method
// requires a Google OAuth 2.0 credential with proper [permissions]
// (https://cloud.google.com/identity-platform/docs/access-control).
//
//   - targetProjectId: If `tenant_id` is specified, the ID of the Google Cloud
//     project that the Identity Platform tenant belongs to. Otherwise, the ID of
//     the Google Cloud project that accounts belong to.
//   - tenantId: If the accounts belong to an Identity Platform tenant, the ID of
//     the tenant. If the accounts belong to a default Identity Platform project,
//     the field is not needed.
func (r *ProjectsTenantsAccountsService) BatchDelete(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1batchdeleteaccountsrequest *GoogleCloudIdentitytoolkitV1BatchDeleteAccountsRequest) *ProjectsTenantsAccountsBatchDeleteCall {
	c := &ProjectsTenantsAccountsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1batchdeleteaccountsrequest = googlecloudidentitytoolkitv1batchdeleteaccountsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsBatchDeleteCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsBatchDeleteCall) Context(ctx context.Context) *ProjectsTenantsAccountsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1batchdeleteaccountsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1BatchDeleteAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsBatchGetCall struct {
	s               *Service
	targetProjectId string
	tenantId        string
	urlParams_      gensupport.URLParams
	ifNoneMatch_    string
	ctx_            context.Context
	header_         http.Header
}

// BatchGet: Download account information for all accounts on the project in a
// paginated manner. To use this method requires a Google OAuth 2.0 credential
// with proper permissions
// (https://cloud.google.com/identity-platform/docs/access-control)..
// Furthermore, additional permissions are needed to get password hash,
// password salt, and password version from accounts; otherwise these fields
// are redacted.
//
//   - targetProjectId: If `tenant_id` is specified, the ID of the Google Cloud
//     project that the Identity Platform tenant belongs to. Otherwise, the ID of
//     the Google Cloud project that the accounts belong to.
//   - tenantId: The ID of the Identity Platform tenant the accounts belongs to.
//     If not specified, accounts on the Identity Platform project are returned.
func (r *ProjectsTenantsAccountsService) BatchGet(targetProjectId string, tenantId string) *ProjectsTenantsAccountsBatchGetCall {
	c := &ProjectsTenantsAccountsBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	return c
}

// DelegatedProjectNumber sets the optional parameter "delegatedProjectNumber":
func (c *ProjectsTenantsAccountsBatchGetCall) DelegatedProjectNumber(delegatedProjectNumber int64) *ProjectsTenantsAccountsBatchGetCall {
	c.urlParams_.Set("delegatedProjectNumber", fmt.Sprint(delegatedProjectNumber))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results to return. Must be at least 1 and no greater than 1000. By default,
// it is 20.
func (c *ProjectsTenantsAccountsBatchGetCall) MaxResults(maxResults int64) *ProjectsTenantsAccountsBatchGetCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// NextPageToken sets the optional parameter "nextPageToken": The pagination
// token from the response of a previous request.
func (c *ProjectsTenantsAccountsBatchGetCall) NextPageToken(nextPageToken string) *ProjectsTenantsAccountsBatchGetCall {
	c.urlParams_.Set("nextPageToken", nextPageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsBatchGetCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsTenantsAccountsBatchGetCall) IfNoneMatch(entityTag string) *ProjectsTenantsAccountsBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsBatchGetCall) Context(ctx context.Context) *ProjectsTenantsAccountsBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.batchGet", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.batchGet" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1DownloadAccountResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1DownloadAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1DownloadAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.batchGet", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsTenantsAccountsBatchGetCall) Pages(ctx context.Context, f func(*GoogleCloudIdentitytoolkitV1DownloadAccountResponse) error) error {
	c.ctx_ = ctx
	defer c.NextPageToken(c.urlParams_.Get("nextPageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.NextPageToken(x.NextPageToken)
	}
}

type ProjectsTenantsAccountsDeleteCall struct {
	s                                                *Service
	targetProjectId                                  string
	tenantId                                         string
	googlecloudidentitytoolkitv1deleteaccountrequest *GoogleCloudIdentitytoolkitV1DeleteAccountRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Delete: Deletes a user's account.
//
//   - targetProjectId: The ID of the project which the account belongs to.
//     Should only be specified in authenticated requests that specify local_id
//     of an account.
//   - tenantId: The ID of the tenant that the account belongs to, if applicable.
//     Only require to be specified for authenticated requests bearing a Google
//     OAuth 2.0 credential that specify local_id of an account that belongs to
//     an Identity Platform tenant.
func (r *ProjectsTenantsAccountsService) Delete(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1deleteaccountrequest *GoogleCloudIdentitytoolkitV1DeleteAccountRequest) *ProjectsTenantsAccountsDeleteCall {
	c := &ProjectsTenantsAccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1deleteaccountrequest = googlecloudidentitytoolkitv1deleteaccountrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsDeleteCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsDeleteCall) Context(ctx context.Context) *ProjectsTenantsAccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1deleteaccountrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:delete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.delete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1DeleteAccountResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1DeleteAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1DeleteAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsLookupCall struct {
	s                                                 *Service
	targetProjectId                                   string
	tenantId                                          string
	googlecloudidentitytoolkitv1getaccountinforequest *GoogleCloudIdentitytoolkitV1GetAccountInfoRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Lookup: Gets account information for all matched accounts. For an end user
// request, retrieves the account of the end user. For an admin request with
// Google OAuth 2.0 credential, retrieves one or multiple account(s) with
// matching criteria.
//
//   - targetProjectId: The ID of the Google Cloud project that the account or
//     the Identity Platform tenant specified by `tenant_id` belongs to. Should
//     only be specified by authenticated requests bearing a Google OAuth 2.0
//     credential with proper permissions
//     (https://cloud.google.com/identity-platform/docs/access-control).
//   - tenantId: The ID of the tenant that the account belongs to. Should only be
//     specified by authenticated requests from a developer.
func (r *ProjectsTenantsAccountsService) Lookup(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1getaccountinforequest *GoogleCloudIdentitytoolkitV1GetAccountInfoRequest) *ProjectsTenantsAccountsLookupCall {
	c := &ProjectsTenantsAccountsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1getaccountinforequest = googlecloudidentitytoolkitv1getaccountinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsLookupCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsLookupCall) Context(ctx context.Context) *ProjectsTenantsAccountsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1getaccountinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.lookup", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetAccountInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsLookupCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetAccountInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetAccountInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.lookup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsQueryCall struct {
	s                                                *Service
	targetProjectId                                  string
	tenantId                                         string
	googlecloudidentitytoolkitv1queryuserinforequest *GoogleCloudIdentitytoolkitV1QueryUserInfoRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Query: Looks up user accounts within a project or a tenant based on
// conditions in the request.
//
// - targetProjectId: The ID of the project to which the result is scoped.
// - tenantId: The ID of the tenant to which the result is scoped.
func (r *ProjectsTenantsAccountsService) Query(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1queryuserinforequest *GoogleCloudIdentitytoolkitV1QueryUserInfoRequest) *ProjectsTenantsAccountsQueryCall {
	c := &ProjectsTenantsAccountsQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1queryuserinforequest = googlecloudidentitytoolkitv1queryuserinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsQueryCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsQueryCall) Context(ctx context.Context) *ProjectsTenantsAccountsQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1queryuserinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.query", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1QueryUserInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1QueryUserInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1QueryUserInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.query", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsSendOobCodeCall struct {
	s                                             *Service
	targetProjectId                               string
	tenantId                                      string
	googlecloudidentitytoolkitv1getoobcoderequest *GoogleCloudIdentitytoolkitV1GetOobCodeRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// SendOobCode: Sends an out-of-band confirmation code for an account. Requests
// from a authenticated request can optionally return a link including the OOB
// code instead of sending it.
//
//   - targetProjectId: The Project ID of the Identity Platform project which the
//     account belongs to. To specify this field, it requires a Google OAuth 2.0
//     credential with proper permissions
//     (https://cloud.google.com/identity-platform/docs/access-control).
//   - tenantId: The tenant ID of the Identity Platform tenant the account
//     belongs to.
func (r *ProjectsTenantsAccountsService) SendOobCode(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1getoobcoderequest *GoogleCloudIdentitytoolkitV1GetOobCodeRequest) *ProjectsTenantsAccountsSendOobCodeCall {
	c := &ProjectsTenantsAccountsSendOobCodeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1getoobcoderequest = googlecloudidentitytoolkitv1getoobcoderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsSendOobCodeCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsSendOobCodeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsSendOobCodeCall) Context(ctx context.Context) *ProjectsTenantsAccountsSendOobCodeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsSendOobCodeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsSendOobCodeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1getoobcoderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:sendOobCode")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.sendOobCode", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.sendOobCode" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetOobCodeResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsSendOobCodeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetOobCodeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetOobCodeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.sendOobCode", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTenantsAccountsUpdateCall struct {
	s                                                 *Service
	targetProjectId                                   string
	tenantId                                          string
	googlecloudidentitytoolkitv1setaccountinforequest *GoogleCloudIdentitytoolkitV1SetAccountInfoRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Update: Updates account-related information for the specified user by
// setting specific fields or applying action codes. Requests from
// administrators and end users are supported.
//
//   - targetProjectId: The project ID for the project that the account belongs
//     to. Specifying this field requires Google OAuth 2.0 credential with proper
//     [permissions]
//     (https://cloud.google.com/identity-platform/docs/access-control). Requests
//     from end users should pass an Identity Platform ID token instead.
//   - tenantId: The tenant ID of the Identity Platform tenant that the account
//     belongs to. Requests from end users should pass an Identity Platform ID
//     token rather than setting this field.
func (r *ProjectsTenantsAccountsService) Update(targetProjectId string, tenantId string, googlecloudidentitytoolkitv1setaccountinforequest *GoogleCloudIdentitytoolkitV1SetAccountInfoRequest) *ProjectsTenantsAccountsUpdateCall {
	c := &ProjectsTenantsAccountsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.targetProjectId = targetProjectId
	c.tenantId = tenantId
	c.googlecloudidentitytoolkitv1setaccountinforequest = googlecloudidentitytoolkitv1setaccountinforequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTenantsAccountsUpdateCall) Fields(s ...googleapi.Field) *ProjectsTenantsAccountsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTenantsAccountsUpdateCall) Context(ctx context.Context) *ProjectsTenantsAccountsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTenantsAccountsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTenantsAccountsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudidentitytoolkitv1setaccountinforequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{+targetProjectId}/tenants/{+tenantId}/accounts:update")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"targetProjectId": c.targetProjectId,
		"tenantId":        c.tenantId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.projects.tenants.accounts.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1SetAccountInfoResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTenantsAccountsUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1SetAccountInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1SetAccountInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.projects.tenants.accounts.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type V1GetProjectsCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetProjects: Gets a project's public Identity Toolkit configuration.
// (Legacy) This method also supports authenticated calls from a developer to
// retrieve non-public configuration.
func (r *V1Service) GetProjects() *V1GetProjectsCall {
	c := &V1GetProjectsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// AndroidPackageName sets the optional parameter "androidPackageName": Android
// package name to check against the real android package name. If this field
// is provided, and sha1_cert_hash is not provided, the action will throw an
// error if this does not match the real android package name.
func (c *V1GetProjectsCall) AndroidPackageName(androidPackageName string) *V1GetProjectsCall {
	c.urlParams_.Set("androidPackageName", androidPackageName)
	return c
}

// ClientId sets the optional parameter "clientId": The RP OAuth client ID. If
// set, a check will be performed to ensure that the OAuth client is valid for
// the retrieved project and the request rejected with a client error if not
// valid.
func (c *V1GetProjectsCall) ClientId(clientId string) *V1GetProjectsCall {
	c.urlParams_.Set("clientId", clientId)
	return c
}

// DelegatedProjectNumber sets the optional parameter "delegatedProjectNumber":
// Project Number of the delegated project request. This field should only be
// used as part of the Firebase V1 migration.
func (c *V1GetProjectsCall) DelegatedProjectNumber(delegatedProjectNumber int64) *V1GetProjectsCall {
	c.urlParams_.Set("delegatedProjectNumber", fmt.Sprint(delegatedProjectNumber))
	return c
}

// FirebaseAppId sets the optional parameter "firebaseAppId": The Firebase app
// ID, for applications that use Firebase. This can be found in the Firebase
// console for your project. If set, a check will be performed to ensure that
// the app ID is valid for the retrieved project. If not valid, the request
// will be rejected with a client error.
func (c *V1GetProjectsCall) FirebaseAppId(firebaseAppId string) *V1GetProjectsCall {
	c.urlParams_.Set("firebaseAppId", firebaseAppId)
	return c
}

// IosBundleId sets the optional parameter "iosBundleId": iOS bundle id to
// check against the real ios bundle id. If this field is provided, the action
// will throw an error if this does not match the real iOS bundle id.
func (c *V1GetProjectsCall) IosBundleId(iosBundleId string) *V1GetProjectsCall {
	c.urlParams_.Set("iosBundleId", iosBundleId)
	return c
}

// ProjectNumber sets the optional parameter "projectNumber": Project number of
// the configuration to retrieve. This field is deprecated and should not be
// used by new integrations.
func (c *V1GetProjectsCall) ProjectNumber(projectNumber int64) *V1GetProjectsCall {
	c.urlParams_.Set("projectNumber", fmt.Sprint(projectNumber))
	return c
}

// ReturnDynamicLink sets the optional parameter "returnDynamicLink": Whether
// dynamic link should be returned.
func (c *V1GetProjectsCall) ReturnDynamicLink(returnDynamicLink bool) *V1GetProjectsCall {
	c.urlParams_.Set("returnDynamicLink", fmt.Sprint(returnDynamicLink))
	return c
}

// Sha1Cert sets the optional parameter "sha1Cert": SHA-1 Android application
// cert hash. If set, a check will be performed to ensure that the cert hash is
// valid for the retrieved project and android_package_name.
func (c *V1GetProjectsCall) Sha1Cert(sha1Cert string) *V1GetProjectsCall {
	c.urlParams_.Set("sha1Cert", sha1Cert)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *V1GetProjectsCall) Fields(s ...googleapi.Field) *V1GetProjectsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *V1GetProjectsCall) IfNoneMatch(entityTag string) *V1GetProjectsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *V1GetProjectsCall) Context(ctx context.Context) *V1GetProjectsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *V1GetProjectsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1GetProjectsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.getProjects", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.getProjects" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetProjectConfigResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *V1GetProjectsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetProjectConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetProjectConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.getProjects", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type V1GetPublicKeysCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetPublicKeys: Retrieves public keys of the legacy Identity Toolkit token
// signer to enable third parties to verify the legacy ID token. For now the
// X509 pem cert is the only format supported.
func (r *V1Service) GetPublicKeys() *V1GetPublicKeysCall {
	c := &V1GetPublicKeysCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *V1GetPublicKeysCall) Fields(s ...googleapi.Field) *V1GetPublicKeysCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *V1GetPublicKeysCall) IfNoneMatch(entityTag string) *V1GetPublicKeysCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *V1GetPublicKeysCall) Context(ctx context.Context) *V1GetPublicKeysCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *V1GetPublicKeysCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1GetPublicKeysCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/publicKeys")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.getPublicKeys", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.getPublicKeys" call.
func (c *V1GetPublicKeysCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.getPublicKeys", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type V1GetRecaptchaParamsCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetRecaptchaParams: Gets parameters needed for generating a reCAPTCHA
// challenge.
func (r *V1Service) GetRecaptchaParams() *V1GetRecaptchaParamsCall {
	c := &V1GetRecaptchaParamsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *V1GetRecaptchaParamsCall) Fields(s ...googleapi.Field) *V1GetRecaptchaParamsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *V1GetRecaptchaParamsCall) IfNoneMatch(entityTag string) *V1GetRecaptchaParamsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *V1GetRecaptchaParamsCall) Context(ctx context.Context) *V1GetRecaptchaParamsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *V1GetRecaptchaParamsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1GetRecaptchaParamsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/recaptchaParams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.getRecaptchaParams", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.getRecaptchaParams" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetRecaptchaParamResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *V1GetRecaptchaParamsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetRecaptchaParamResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetRecaptchaParamResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.getRecaptchaParams", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type V1GetSessionCookiePublicKeysCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSessionCookiePublicKeys: Retrieves the set of public keys of the session
// cookie JSON Web Token (JWT) signer that can be used to validate the session
// cookie created through createSessionCookie.
func (r *V1Service) GetSessionCookiePublicKeys() *V1GetSessionCookiePublicKeysCall {
	c := &V1GetSessionCookiePublicKeysCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *V1GetSessionCookiePublicKeysCall) Fields(s ...googleapi.Field) *V1GetSessionCookiePublicKeysCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *V1GetSessionCookiePublicKeysCall) IfNoneMatch(entityTag string) *V1GetSessionCookiePublicKeysCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *V1GetSessionCookiePublicKeysCall) Context(ctx context.Context) *V1GetSessionCookiePublicKeysCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *V1GetSessionCookiePublicKeysCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1GetSessionCookiePublicKeysCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/sessionCookiePublicKeys")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "identitytoolkit.getSessionCookiePublicKeys", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "identitytoolkit.getSessionCookiePublicKeys" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudIdentitytoolkitV1GetSessionCookiePublicKeysResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *V1GetSessionCookiePublicKeysCall) Do(opts ...googleapi.CallOption) (*GoogleCloudIdentitytoolkitV1GetSessionCookiePublicKeysResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudIdentitytoolkitV1GetSessionCookiePublicKeysResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "identitytoolkit.getSessionCookiePublicKeys", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
