// Copyright (c) 2014 The mathutil Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// "Static" data

package mathutil // import "modernc.org/mathutil"

var (
	// Set bits count in a byte
	popcnt = [256]byte{
		0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, // 0
		1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, // 1
		1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, // 2
		2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, // 3
		1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, // 4
		2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, // 5
		2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, // 6
		3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, // 7
		1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, // 8
		2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, // 9
		2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, // 10
		3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, // 11
		2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, // 12
		3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, // 13
		3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, // 14
		4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, // 15
	}

	// Highest set bit index in a byte
	log2 = [256]int{
		-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, // 0

		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, // 1

		5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, // 2
		5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, // 3

		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, // 4
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, // 5
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, // 6
		6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, // 7

		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 8
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 9
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 10
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 11
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 12
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 13
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 14
		7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, // 15
	}

	// "Predivisors": 2-53
	liars = [3660]uint32{
		31621, 42799, 49141, 49981, 65077, 65281, 80581, 83333, 88357, 90751,
		104653, 130561, 164737, 188057, 194221, 196093, 215749, 219781, 220729, 253241,
		256999, 271951, 280601, 282133, 357761, 390937, 458989, 486737, 489997, 514447,
		580337, 587861, 611701, 647089, 653333, 657901, 665281, 665333, 688213, 710533,
		721801, 722261, 738541, 741751, 742813, 745889, 769757, 818201, 838861, 873181,
		877099, 916327, 976873, 983401, 1016801, 1018921, 1053761, 1064053, 1073021, 1082401,
		1109461, 1132657, 1145257, 1168513, 1194649, 1207361, 1251949, 1252697, 1302451, 1325843,
		1357441, 1373653, 1397419, 1441091, 1493857, 1507963, 1509709, 1530787, 1584133, 1678541,
		1690501, 1730977, 1735841, 1811573, 1876393, 1969417, 1987021, 2004403, 2081713, 2163001,
		2181961, 2205967, 2261953, 2264369, 2269093, 2284453, 2304167, 2387797, 2487941, 2510569,
		2670361, 2746477, 2748023, 2757241, 2811271, 2909197, 2944261, 2976487, 3048841, 3090091,
		3116107, 3125281, 3225601, 3363121, 3375041, 3400013, 3413533, 3429037, 3539101, 3542533,
		3567481, 3568661, 3605429, 3656449, 3763801, 3828001, 3898129, 3911197, 3985921, 4072729,
		4181921, 4188889, 4209661, 4360621, 4469471, 4480477, 4513841, 4835209, 4863127, 4869313,
		4877641, 4922413, 5016191, 5044033, 5095177, 5173169, 5173601, 5176153, 5256091, 5271841,
		5284333, 5351537, 5489641, 5590621, 5672041, 5919187, 6027193, 6118141, 6140161, 6159301,
		6189121, 6226193, 6233977, 6236257, 6278533, 6334351, 6368689, 6386993, 6631549, 6658669,
		6779137, 6787327, 6836233, 6952037, 6955541, 6998881, 7017193, 7232321, 7306261, 7306561,
		7429117, 7462001, 7674967, 7725901, 7759937, 7820201, 7883731, 8036033, 8095447, 8239477,
		8384513, 8534233, 8725753, 8727391, 8902741, 9006401, 9056501, 9073513, 9131401, 9345541,
		9371251, 9439201, 9480461, 9533701, 9564169, 9567673, 9588151, 9591661, 9729301, 9774181,
		9863461, 10024561, 10084177, 10323769, 10331141, 10386241, 10425511, 10610063, 10700761, 10712857,
		10763653, 10974881, 11081459, 11115037, 11335501, 11541307, 11585293, 11592397, 11777599, 12032021,
		12096613, 12263131, 12322133, 12327121, 12599233, 12854437, 13057787, 13338371, 13446253, 13500313,
		13635289, 13694761, 13747361, 13773061, 14026897, 14154337, 14179537, 14324473, 14469841, 14671801,
		14676481, 14709241, 14794081, 14796289, 14865121, 15101893, 15139199, 15162941, 15188557, 15220951,
		15247621, 15479777, 15525241, 15603391, 15621409, 15700301, 15802681, 15976747, 15978007, 16070429,
		16132321, 16149169, 16153633, 16324001, 16349477, 16360381, 16705021, 16773121, 16822081, 16843009,
		16853077, 16879501, 16973393, 17098369, 17116837, 17134043, 17208601, 17236801, 17327773, 17375249,
		17405537, 17585969, 17870561, 18067501, 18073817, 18366937, 18443701, 18454921, 18535177, 18653353,
		18740971, 19328653, 19384289, 19404139, 19471033, 19607561, 20261251, 20417311, 20647621, 20968501,
		21042001, 21303343, 21306157, 21359521, 21397381, 21400481, 21623659, 21654533, 22075579, 22087477,
		22369621, 22591301, 22669501, 22711873, 22849481, 22953673, 23247901, 23382529, 23464033, 23577497,
		23634181, 23734901, 23828017, 23872213, 23963869, 24214051, 24356377, 25080101, 25150501, 25276421,
		25326001, 25457833, 25629913, 25696133, 25768261, 25909453, 26280073, 26377921, 26821601, 26840269,
		26877421, 26886817, 27108397, 27118601, 27219697, 27271151, 27279409, 27331921, 27380831, 27392041,
		27409541, 27491237, 27509653, 27664033, 27798461, 27808463, 28325881, 28527049, 28572961, 29111881,
		29214541, 29581501, 30022129, 30090817, 30185569, 30219757, 30295141, 30338593, 30388753, 30418957,
		30576151, 30662497, 30740417, 30881551, 30894307, 31040833, 31166803, 31436123, 31735621, 31759121,
		32091781, 32095057, 32168117, 32285041, 32497921, 32676481, 33146717, 33298337, 33600533, 33627301,
		33704101, 33872593, 34003061, 34043101, 34124641, 34540801, 34856167, 34944001, 35576599, 35703361,
		35820937, 35851037, 36291193, 36307981, 36861901, 36919681, 36974341, 37109467, 37376509, 37439201,
		37964809, 37988497, 38010307, 38046817, 38118763, 38210323, 39465091, 39512773, 39655153, 39684157,
		40165093, 40238797, 40315441, 40361197, 40629601, 40782589, 40827473, 40987201, 41121433, 41568101,
		41604109, 41642681, 41662297, 41840809, 42009217, 42485119, 42623017, 42984589, 43224397, 43363601,
		43661257, 44070841, 44314129, 44465221, 44482901, 45100177, 45175201, 45219329, 45414433, 45819541,
		45879941, 46094401, 46325029, 46386589, 46469809, 46517857, 46679761, 46860001, 47220367, 47903701,
		47918581, 48064021, 48191653, 48269761, 48316969, 48400753, 48448661, 48551161, 48563089, 49075417,
		49303801, 49411801, 49459801, 50155733, 50201089, 50443201, 50523661, 51030601, 51129781, 51302353,
		51500521, 52072021, 52119289, 52204237, 53283169, 53399449, 53656021, 53675623, 53695721, 53711113,
		54029741, 54449431, 55109401, 55176097, 55318957, 55729957, 56052361, 56420033, 56479897, 56810137,
		57762433, 58003213, 58422409, 58449847, 58509977, 58679941, 58755877, 59631211, 59840537, 59913157,
		59953741, 60155201, 60352921, 60547831, 60566431, 60581401, 60696661, 60738257, 60957361, 61201009,
		61219789, 61377109, 61832377, 62756641, 63001801, 63002501, 63065281, 63167743, 63318169, 63328469,
		63346999, 63388033, 64148717, 64605041, 64735897, 65144501, 65254393, 65301013, 65350801, 65359477,
		66096253, 67194401, 67642513, 67928221, 68102641, 68154001, 68165761, 68512867, 68621701, 68839597,
		69030901, 69128641, 69176647, 69228967, 69231061, 69485281, 69612061, 69885649, 70149631, 70463489,
		70593931, 70728121, 71079661, 71734417, 72498253, 72543547, 73562833, 73645001, 74411131, 74927161,
		75140137, 75565873, 76725091, 76745101, 77533123, 77648941, 77812153, 77817979, 78939089, 79398901,
		79411201, 79417801, 79464533, 79786523, 80142761, 80146909, 80375707, 80556337, 80687881, 80891009,
		81433591, 81954133, 82273201, 82506439, 82870517, 82929001, 83083001, 83103329, 83204801, 84164033,
		84350561, 84421081, 84487457, 84998503, 85328717, 85519337, 85823401, 86027329, 86438857, 86530621,
		86999837, 87499651, 87694261, 88256449, 88368853, 88661861, 89308771, 89784581, 90270613, 90278161,
		90341197, 90665789, 90698401, 91433281, 91659283, 92438581, 92625121, 93431521, 93541537, 93571633,
		93643201, 93677761, 93926197, 94316401, 94502701, 95451361, 95452781, 96135601, 96618397, 96791881,
		96888641, 96895441, 96904081, 96925921, 97255801, 97496449, 97796953, 97863529, 97924217, 99036001,
		99115297, 99486889, 99789673, 99898801, 100463443, 100618933, 100943201, 101152133, 101218921, 101270251,
		101276579, 101649241, 102004421, 102678031, 102690677, 102690901, 103301633, 104078857, 104524421, 104988673,
		105305443, 105919633, 106485121, 106622353, 106743073, 107360641, 107543333, 108596953, 109231229, 109437751,
		109541461, 109879837, 110135821, 110139499, 110312773, 110413333, 110717861, 111370141, 111654401, 112032001,
		112402981, 112828801, 113589601, 113605201, 113730481, 113892589, 114305441, 114329881, 114701341, 114842677,
		114910489, 115039081, 115174681, 115497901, 115804501, 115873801, 116090081, 116321617, 116617289, 116682721,
		116696161, 116998669, 117987841, 118466401, 118901521, 119092801, 119204809, 119261113, 119327041, 119558011,
		119743537, 119940853, 120296677, 120517021, 120838609, 121062001, 121374241, 121472359, 121609489, 122166307,
		122396737, 122941981, 123481777, 123671671, 123877081, 123987793, 124145473, 124630273, 124818601, 125284141,
		125686241, 125848577, 126132553, 127050067, 128079409, 128124151, 128396921, 128468957, 128665319, 128987429,
		129205781, 129256273, 129357061, 129461617, 129524669, 130556329, 130693393, 130944133, 131023201, 131567929,
		131938561, 132332201, 132338881, 132440521, 132575071, 133216381, 133302781, 133467517, 133800661, 134696801,
		134767153, 134868029, 135263269, 135296053, 135308881, 135945853, 135969401, 136043641, 136661201, 136722433,
		137415821, 137763037, 138030721, 138403981, 138828821, 139295701, 139487041, 140197051, 142525333, 142922413,
		143106133, 143168581, 145348529, 146156617, 146272901, 146659801, 146843929, 146884393, 147028001, 147287141,
		148109473, 148171769, 148910653, 149389633, 150379693, 150960239, 150988753, 151533377, 151589881, 152716537,
		152922001, 152991841, 153369061, 153589801, 153754873, 153928133, 154287451, 154513633, 154944533, 155203361,
		156114061, 156532799, 157069189, 157368661, 157405249, 157725829, 158068153, 158192317, 158397247, 158496911,
		158544401, 158895281, 160348189, 160378861, 160491329, 160587841, 160672201, 160730389, 161184013, 161216021,
		161289649, 161304001, 161423377, 162026869, 162067441, 162690481, 162771337, 162776041, 163442551, 163954561,
		164111281, 165061909, 165224321, 165938653, 166082309, 166339057, 166406561, 166827943, 167579497, 167582377,
		167692141, 167881121, 168566501, 169655641, 170640961, 170782921, 170856533, 171454321, 172116181, 172436713,
		172947529, 173401621, 174479729, 176030977, 176597821, 176609441, 176977921, 177167233, 177254533, 177693521,
		177927641, 177951973, 178837201, 178956971, 179083601, 179285137, 179820257, 180115489, 180497633, 180703451,
		181285001, 181285537, 181542601, 181647497, 182383111, 183677341, 184411567, 185653333, 186183469, 186393481,
		186983521, 187050529, 187667969, 187761241, 188516329, 188985961, 189714193, 189738361, 189941761, 190212181,
		190382161, 190913297, 191233813, 191648161, 191981609, 192346153, 192857761, 193330237, 193638337, 193949641,
		194556451, 196035001, 196049701, 196231393, 198982759, 199674721, 200143351, 200753281, 201261061, 202130197,
		202156813, 202538857, 203505697, 204280501, 204582457, 204766381, 205057561, 206304961, 206453509, 206504033,
		206529737, 207008569, 207030541, 207132481, 207477001, 207618781, 208051201, 208969223, 209246701, 209404369,
		209990881, 210592873, 210842113, 213035761, 214038533, 214110541, 214852609, 214858717, 215436241, 216821881,
		217123069, 217875571, 218603617, 218642029, 218947121, 219621781, 220531501, 220883521, 221368153, 221415781,
		221884001, 222010721, 222630193, 223449463, 223625851, 223782263, 224074369, 224136013, 224769241, 224957893,
		225853633, 226359547, 226450297, 227132641, 227444101, 227475481, 228652201, 228842209, 228988033, 229589413,
		230357761, 231383461, 231405701, 231927781, 232114433, 232460821, 232771501, 233110081, 234869009, 235426913,
		235928071, 237791143, 238001653, 238833421, 240068041, 240371713, 240694513, 240785047, 241505377, 242067841,
		242650717, 242860069, 243583201, 243955141, 244883981, 245006623, 245950561, 246099317, 246282511, 246434761,
		246658441, 247318957, 247321301, 247416101, 249582481, 250436033, 250958401, 250988173, 251528401, 251663837,
		251855893, 252853921, 253610281, 253893397, 255416897, 256831433, 257590661, 258020473, 258043229, 258234401,
		258944401, 259763093, 259765747, 260156101, 260518801, 260736341, 260963389, 261186001, 261703417, 262979501,
		263428181, 264269449, 264384469, 265020001, 265584133, 265735969, 265836161, 266790481, 266925601, 270525737,
		271272569, 271763467, 271826629, 271950829, 273361789, 273480637, 274701913, 274810241, 274919401, 275283401,
		275619961, 276018913, 276131137, 276542401, 276638321, 277787141, 278943061, 279377281, 280885153, 282253141,
		282471853, 282769771, 283900961, 284166877, 284301751, 284736091, 284834299, 285820501, 286316801, 287160301,
		287449091, 287715121, 288099001, 288117721, 288735277, 290643601, 290706781, 290953921, 291088513, 291461633,
		292153681, 292290181, 292433321, 292902481, 293346637, 293847721, 293938261, 295419097, 295743017, 297624961,
		297798961, 298212601, 299367877, 299736181, 301413001, 302635351, 304080001, 307629401, 307694323, 307972801,
		308483209, 309666361, 310474249, 310978027, 311177213, 311411629, 311655829, 311671361, 312408113, 312614021,
		314184487, 315034513, 315351521, 317137969, 317365933, 317641171, 317796119, 319053281, 319374577, 319440769,
		319726177, 320326003, 321324589, 321850849, 322469701, 322941881, 324477697, 325028089, 325352101, 325546873,
		326266051, 326405713, 326469137, 326628721, 326694301, 326695141, 327073601, 327093409, 327398009, 328302901,
		329153653, 329769721, 330198331, 330759617, 331658081, 331934989, 337135501, 337420679, 337665901, 337783981,
		338125537, 338458807, 338914369, 339195097, 339492169, 339794641, 341958121, 341994131, 343017529, 343052833,
		344201441, 344255551, 344776301, 346080391, 348989101, 349752913, 350031973, 350244577, 351058753, 351177769,
		352802803, 352932337, 353815801, 353932801, 354062809, 356604421, 356836819, 357348601, 357872971, 358416577,
		359394751, 359727073, 360145633, 360375181, 360787771, 361307521, 361312337, 362569201, 363170837, 363430637,
		364550761, 365077373, 365231401, 366487201, 366532321, 366652201, 367559501, 367632301, 368016949, 368476501,
		369667561, 371011801, 371611153, 372167101, 373012777, 373533617, 373669453, 373906513, 374346361, 374988661,
		376957153, 377192353, 377334497, 377458849, 377806687, 377869031, 378792649, 379732501, 380137633, 382304161,
		384100001, 385175113, 385319089, 387072661, 388695301, 390609941, 390612221, 391014937, 392679737, 393611653,
		394723177, 396864469, 399156661, 399302581, 399647221, 400385701, 400557109, 401100881, 403095967, 403293313,
		405739681, 405782623, 407737201, 407889161, 409302001, 409458241, 410613809, 410680357, 411618241, 411851389,
		412836689, 413138881, 413429801, 413778817, 414216461, 414368641, 415200361, 415204501, 415476343, 416964241,
		417767201, 417779909, 418044563, 418226581, 418616161, 418617281, 418667401, 419184481, 420607441, 421942951,
		422429041, 422928101, 423384001, 423465001, 424175761, 424411501, 424431541, 425967301, 426174101, 426219649,
		426770437, 426783811, 427294141, 428180191, 428758201, 429135841, 429509837, 430046857, 430381921, 430646401,
		430733701, 432227449, 434042801, 435016187, 435358657, 435993301, 436465501, 437247841, 437462101, 437597101,
		437866087, 439309261, 441354497, 441650591, 441758461, 442050577, 442181291, 442543553, 444660421, 445429693,
		446414621, 446619617, 449501761, 450807481, 450866021, 450872573, 452990401, 453366029, 453967739, 454745773,
		455198563, 457274161, 457320533, 459785089, 460251733, 460585861, 461151121, 461272267, 461329601, 462587329,
		462639409, 462701513, 464012033, 464955857, 465505633, 466290949, 466758181, 467100937, 468410113, 468950021,
		470120257, 470268137, 470644021, 471535373, 471664513, 472814413, 473581057, 474892741, 474970501, 474983881,
		475723849, 478614067, 479962009, 480668347, 481153501, 481239361, 482488393, 482824669, 482921297, 483006889,
		483029821, 483945601, 484200289, 486063001, 486902929, 487896601, 488104681, 488169289, 488585521, 488656981,
		489994201, 490950461, 491738801, 493108481, 494288677, 495909871, 496109729, 496560349, 497148599, 497285713,
		498662561, 498706651, 498905189, 500747293, 501172241, 501472333, 502686713, 504870241, 505473263, 505532773,
		505798213, 506349421, 507142567, 507323521, 508606771, 509302873, 509551201, 510925609, 511098521, 511215521,
		511611673, 512330281, 514738981, 516045197, 516259657, 516764063, 517662001, 518216201, 518548801, 521501473,
		522390109, 522758233, 523756711, 526067821, 526359289, 526686889, 528013333, 528043753, 528220117, 530630701,
		531095029, 531681281, 532126801, 532758241, 532800133, 533429881, 534782293, 535252867, 535428577, 535517581,
		536003333, 536114197, 536342419, 536870911, 540207097, 540621181, 540654409, 540680141, 542497201, 542536457,
		544861633, 545550433, 545622401, 546102481, 546117301, 546322201, 548080513, 548989561, 549308761, 550132741,
		550230409, 550635373, 550853137, 551313001, 552573793, 553027201, 554487121, 554599051, 554964001, 555321007,
		555465601, 556001377, 556069849, 556095433, 556114609, 557165209, 558235109, 558900821, 558977761, 561448487,
		562367821, 563298061, 563947141, 564298489, 564689381, 565664761, 565707061, 567358513, 567596401, 568902001,
		568967221, 569332177, 569495809, 570941881, 572123521, 572228929, 572430769, 572567353, 572936869, 573817861,
		573862021, 574998841, 575326033, 576724219, 577210181, 577352641, 577613261, 579606301, 579956653, 581618143,
		582389641, 582799951, 585261637, 586706821, 587343541, 588049001, 591242653, 591822001, 592467451, 592468777,
		593682169, 593728489, 595405201, 595590841, 597537361, 597717121, 599135767, 599945293, 600893921, 601606487,
		602379181, 604584221, 605454917, 605961049, 606872449, 607148653, 607750681, 608421637, 608917753, 609361567,
		609813781, 611097401, 611374453, 611770513, 611812321, 611817421, 612006253, 613849601, 614742241, 615361183,
		615760133, 615895897, 616280897, 617087701, 619239457, 619365121, 619480601, 620169409, 620544961, 620755537,
		621769669, 622137601, 623735953, 624303241, 624732421, 625060801, 625482001, 626717471, 627886657, 628868467,
		629134081, 630496621, 630622753, 630811513, 631767943, 631974613, 633289807, 635155291, 635291077, 635319361,
		636287653, 636337073, 636936697, 638502913, 638837761, 639305921, 639807781, 640650931, 640977373, 643036321,
		643316461, 643552909, 644004817, 644453633, 644457551, 644731357, 644900257, 645556481, 648056449, 648328801,
		651011329, 651064681, 651151801, 651514753, 652469641, 653235841, 653260633, 655264369, 657732349, 659526601,
		659846021, 660095641, 660754117, 661122881, 661207177, 662134201, 663760681, 665462081, 668498321, 670976641,
		670987021, 671716921, 672103001, 672108193, 673778827, 675260477, 676359391, 678481693, 680983817, 681019921,
		681124207, 681303241, 682528687, 683316001, 683362681, 684350833, 686059921, 687741401, 689537441, 690035713,
		690562601, 691131349, 692535637, 693456521, 694116893, 696042901, 696321949, 696998251, 697821857, 698192041,
		698819711, 702683101, 705303457, 705351583, 706728377, 707691601, 709409993, 710382401, 710617861, 710721001,
		714490481, 717096641, 717653129, 717831211, 720767521, 722955773, 724160251, 724969087, 725508241, 731276521,
		732805681, 734166217, 736668013, 739444021, 739576801, 740988151, 741182401, 741214237, 742017181, 742550401,
		744500641, 745493761, 745745461, 746331041, 747406801, 748638001, 749172821, 749640161, 750632137, 751226401,
		751705597, 752186593, 753233717, 753574537, 753594001, 754020361, 754874257, 756205633, 756271909, 756980137,
		758581651, 758687581, 758901701, 759252367, 759266621, 759638881, 762699649, 763907741, 764033999, 764240611,
		765378241, 766303693, 766823797, 770201221, 770909107, 770937931, 771043201, 771337891, 772495777, 773131927,
		773807401, 775368901, 775896181, 776443769, 777218989, 781471001, 782823281, 784450393, 784777393, 784783477,
		784966297, 787085857, 787209277, 788046901, 788931361, 789082001, 790453049, 791118043, 792144161, 792145729,
		794201333, 794399041, 794937601, 795064909, 796072003, 796200901, 796560703, 797418997, 797834017, 799162561,
		799630753, 799898833, 799916101, 801093011, 801227269, 801866647, 804978721, 805505957, 805771501, 807115753,
		807218413, 808214161, 809790881, 810023881, 810455101, 811110301, 811478533, 811607777, 811730923, 815430533,
		815796413, 816024161, 816215401, 816549121, 817832329, 818401321, 819466201, 819743233, 822018961, 822531841,
		824389441, 826004467, 829512001, 830664451, 831933901, 832048447, 832127489, 832169857, 833610751, 837766217,
		839268139, 839280691, 839908217, 840749761, 841217653, 841660961, 842785841, 842824981, 842960981, 843161887,
		844545271, 845376533, 846961321, 848090377, 848755969, 849548671, 852432769, 854094781, 854868257, 855734401,
		857100421, 857902861, 858687103, 859096477, 860334301, 862082677, 862678081, 863196181, 863609113, 863984881,
		865242841, 867022747, 867110501, 867638201, 868088341, 868111597, 868691401, 870985223, 871157233, 871195561,
		871908481, 876850801, 877542481, 878492941, 878940833, 879995689, 880870513, 880922657, 883276549, 884304037,
		884952001, 886180429, 887795221, 888868441, 892740853, 893692819, 894264337, 896901461, 897087361, 897283213,
		899019353, 900736411, 901848301, 902566501, 903108821, 903390643, 905040953, 907378669, 907670501, 907711561,
		908005249, 910202509, 910867481, 911484421, 914348737, 914906539, 920375821, 920696653, 921858631, 922845241,
		923437213, 926756881, 927106561, 927877001, 929159941, 930530701, 932148253, 933729421, 935794081, 936421141,
		937675393, 938376181, 939947009, 940123801, 941056273, 941734657, 943271569, 944832533, 946034057, 946787377,
		947878081, 949317217, 949697233, 952893881, 954924013, 957600541, 957631249, 958131157, 958735681, 960269377,
		960946321, 962442001, 962489557, 962523169, 964412837, 965501857, 967266451, 967287751, 967790401, 968283247,
		968413217, 968751241, 969528337, 970586713, 971975071, 974113601, 974471243, 974774401, 975576281, 976396961,
		977483449, 979363153, 980056507, 980725201, 981484561, 983456377, 984133441, 984252001, 985052881, 985075681,
		987842101, 994133479, 995586373, 995650921, 997836841, 998489017, 998590601, 998596741, 998724481, 999828727,
		1002261781, 1003062061, 1005402133, 1005833971, 1006800829, 1008777001, 1008839999, 1009025263, 1009140161, 1011319501,
		1011333061, 1011570457, 1011909271, 1012438391, 1013833153, 1015339441, 1015626151, 1017748057, 1020515761, 1021281301,
		1022336611, 1024041853, 1024123501, 1024605121, 1025035129, 1026738161, 1027744453, 1028494429, 1034252929, 1034958601,
		1040234231, 1049584313, 1050102901, 1050535501, 1054999441, 1055009117, 1056121453, 1057426651, 1063212481, 1065508321,
		1065602281, 1066972301, 1069388497, 1070639389, 1070941987, 1071512749, 1071643249, 1072898711, 1073159281, 1073288581,
		1073484823, 1075100041, 1077133397, 1078467589, 1081798061, 1082472553, 1084241341, 1084444481, 1090858081, 1093150081,
		1093352833, 1093526353, 1094042321, 1097416321, 1098743563, 1100624857, 1101623381, 1101673501, 1102573501, 1102750013,
		1104194521, 1105038871, 1106529761, 1106580817, 1106595493, 1107138961, 1108135381, 1109304913, 1110582947, 1111205873,
		1111939201, 1112671603, 1114277221, 1116379301, 1117202557, 1117785881, 1117828001, 1117890019, 1119412321, 1120076281,
		1120981021, 1121176981, 1123406047, 1123625501, 1123727617, 1124396521, 1125038377, 1127040769, 1130933429, 1134367777,
		1138289041, 1138607233, 1139137057, 1140573601, 1142466151, 1147434289, 1148578201, 1150229761, 1151670001, 1153164097,
		1153440289, 1154343961, 1154691409, 1154987209, 1155939709, 1156761911, 1156993373, 1157839381, 1159421509, 1160844821,
		1163098249, 1163227759, 1164218641, 1165717129, 1166475601, 1166598217, 1168221121, 1168256953, 1168492417, 1173229201,
		1173545533, 1174300093, 1180970407, 1181566219, 1183338241, 1184554801, 1186325981, 1187235193, 1191153937, 1191216133,
		1192314817, 1192412033, 1192903531, 1193229577, 1193557093, 1195524181, 1196852273, 1198650961, 1198880261, 1200456577,
		1200778753, 1202142061, 1204205449, 1205606533, 1205772499, 1209998077, 1210393801, 1210562701, 1210653541, 1213619761,
		1217181061, 1217823517, 1217924159, 1219816261, 1219858921, 1220114377, 1221127013, 1222861271, 1223531677, 1223941657,
		1225128829, 1226230297, 1226855293, 1227220801, 1229491063, 1229751667, 1230446653, 1231362793, 1232445677, 1234125721,
		1234646533, 1235188597, 1235864033, 1236313501, 1236442421, 1238825569, 1242171349, 1242858317, 1249166881, 1249785941,
		1250656621, 1252236421, 1254277909, 1255665613, 1257102001, 1258903981, 1260332137, 1263293281, 1264145401, 1265477791,
		1266003461, 1266273793, 1266425101, 1267345081, 1269295201, 1269835201, 1270193401, 1270489621, 1270667353, 1272558739,
		1272866167, 1282447477, 1282568741, 1285636801, 1286298133, 1286298263, 1296613501, 1297443913, 1299072721, 1299784141,
		1299963601, 1301509249, 1301926081, 1302745481, 1306836001, 1307004641, 1307520469, 1307823661, 1308758533, 1308998741,
		1309723213, 1309983901, 1310329567, 1311255661, 1311616153, 1312332001, 1312573123, 1313396221, 1315858381, 1316169541,
		1318126321, 1318717531, 1319978701, 1319992181, 1320793813, 1321058213, 1323668917, 1325172421, 1325329297, 1328256247,
		1329174601, 1329431689, 1331973329, 1341010577, 1341926401, 1343575381, 1344597577, 1344975721, 1345514101, 1345523401,
		1347387361, 1348964401, 1350685001, 1351126261, 1352453257, 1353051517, 1356241321, 1356328121, 1357459183, 1362463807,
		1362515701, 1362742561, 1365662917, 1366587661, 1366608377, 1368769681, 1371908137, 1372681861, 1375322101, 1376799577,
		1378646179, 1379464633, 1382453333, 1383283129, 1385656829, 1386705433, 1388972353, 1389353941, 1389975149, 1391890033,
		1393851553, 1394640941, 1394746081, 1394942473, 1397357851, 1398883201, 1400859847, 1401840833, 1404008369, 1404253369,
		1406826241, 1406851249, 1409372779, 1413803197, 1414154827, 1414529533, 1415969101, 1417986901, 1421475031, 1424503849,
		1425860101, 1426319563, 1426534201, 1427771089, 1428966001, 1432354901, 1435091377, 1438648993, 1440231941, 1440922891,
		1441139641, 1441678411, 1442945689, 1443388481, 1443742273, 1446298309, 1446434677, 1446818651, 1448921633, 1451635201,
		1454282449, 1454445413, 1456527461, 1457378449, 1461307717, 1463065501, 1463178817, 1463992661, 1464568381, 1465908193,
		1465945417, 1468540477, 1468824787, 1469059481, 1469960377, 1470080501, 1470650851, 1471628401, 1472221921, 1473580001,
		1477289941, 1481626513, 1482274513, 1482876673, 1483873861, 1483918801, 1485061471, 1486564301, 1493114149, 1495190699,
		1497221281, 1497965713, 1499971457, 1499989177, 1500142001, 1501165097, 1502171117, 1502403121, 1503240559, 1503705601,
		1504139521, 1504832033, 1507746241, 1509156013, 1510870241, 1511558533, 1515175087, 1515785041, 1517039371, 1518014689,
		1518290707, 1520190341, 1521221473, 1522302121, 1526732803, 1529648231, 1529819971, 1530495289, 1532419099, 1532569681,
		1532755369, 1533343261, 1534063081, 1535020133, 1536112001, 1536251047, 1536883357, 1537433899, 1537641691, 1538012449,
		1539583921, 1539804001, 1540454761, 1540550413, 1541047813, 1541849761, 1541955409, 1544145121, 1545019813, 1545177581,
		1546106773, 1546340401, 1546508057, 1547140841, 1547543161, 1547712601, 1550924873, 1554270481, 1557118081, 1560312001,
		1560620041, 1561800833, 1565893201, 1566594551, 1567830241, 1568916311, 1574362441, 1574601601, 1577983489, 1578009401,
		1580449201, 1581576641, 1581714481, 1582783777, 1583230241, 1583658649, 1586436193, 1587650401, 1590394313, 1593706201,
		1595647351, 1595887921, 1598197201, 1602517949, 1603765021, 1603810561, 1603994701, 1609916491, 1609935913, 1612121473,
		1614508267, 1617795181, 1617921667, 1619447741, 1620646177, 1627103521, 1627898401, 1628692201, 1630062253, 1630307617,
		1631314609, 1632286673, 1632513601, 1633044241, 1636185601, 1637434657, 1637436457, 1637930893, 1638294661, 1639351981,
		1639846391, 1641971701, 1642814653, 1644637051, 1645413001, 1647225529, 1648076041, 1649430889, 1650265549, 1650682153,
		1654940509, 1655660761, 1656229921, 1656280033, 1656917377, 1659009601, 1661202113, 1668037621, 1668926629, 1669893661,
		1671603667, 1671714241, 1672125131, 1674091141, 1674658133, 1675978193, 1678274581, 1679130641, 1680901381, 1683174533,
		1685433413, 1686001861, 1687248001, 1691745821, 1692605041, 1694128129, 1695158921, 1696893101, 1698707377, 1699279441,
		1700250049, 1709909293, 1710753001, 1712392321, 1714322377, 1716160321, 1716714793, 1716774481, 1718013133, 1718088301,
		1719197621, 1721061497, 1721986313, 1722007169, 1722685777, 1725675451, 1726372441, 1731048937, 1731995497, 1732924001,
		1734059291, 1734285601, 1735071913, 1736481601, 1738687469, 1740214841, 1742288881, 1742815621, 1743166441, 1744605097,
		1746692641, 1746721681, 1749124829, 1750412161, 1754818561, 1757148121, 1760014561, 1766984389, 1767234613, 1769091241,
		1769267761, 1770236893, 1771303801, 1772267281, 1773582977, 1776439261, 1776820033, 1779649381, 1779892577, 1784306273,
		1784638309, 1785843547, 1786005521, 1787934881, 1790023861, 1791426787, 1792442737, 1792588813, 1794814103, 1801558201,
		1801774081, 1802510669, 1803768091, 1804906517, 1805947313, 1809888967, 1816408273, 1817067169, 1819829749, 1820306953,
		1821514633, 1828682101, 1828887061, 1831258601, 1835114401, 1837156049, 1837599769, 1839568981, 1841034961, 1841099261,
		1841479501, 1844028961, 1846171781, 1847811673, 1849964117, 1850233897, 1850598961, 1852496761, 1853926777, 1854084649,
		1854940231, 1856689453, 1857221281, 1858098497, 1858197961, 1860373241, 1861026133, 1861880689, 1862880401, 1866409861,
		1867906721, 1868682241, 1871987041, 1872937057, 1873177693, 1874634721, 1874849929, 1878691753, 1879111697, 1879623157,
		1879775501, 1883509633, 1883785681, 1885915841, 1894909141, 1894955311, 1897700113, 1899081757, 1899525601, 1900687381,
		1903447841, 1904658913, 1905958891, 1908088001, 1909566073, 1910134309, 1911197947, 1912950241, 1914303841, 1915391521,
		1916987593, 1917397637, 1920301951, 1921309633, 1922092567, 1922687293, 1923224689, 1923311317, 1923845801, 1924201501,
		1925042737, 1928903971, 1929862849, 1930403333, 1930447501, 1930534453, 1930915169, 1934350351, 1938264241, 1940048881,
		1943951041, 1944125633, 1945042181, 1950987193, 1952513369, 1952968753, 1957705177, 1959659857, 1960708261, 1963149553,
		1965007601, 1968002149, 1970065681, 1974474049, 1977257441, 1982123893, 1982826961, 1988071801, 1988713189, 1988835713,
		1988965861, 1989192277, 1991063449, 1995784961, 1995830761, 1996231189, 1996339649, 1997844157, 1998780001, 1999053601,
		1999111801, 1999743661, 2004299641, 2007646961, 2013554869, 2013834961, 2016481477, 2017021333, 2017509601, 2019564769,
		2021392369, 2021884343, 2027675701, 2028279793, 2028631361, 2028812399, 2029830409, 2030600833, 2036224321, 2043173273,
		2049293401, 2050617713, 2052149221, 2054711381, 2055634561, 2057267941, 2057835781, 2058072041, 2059739221, 2062612033,
		2068867841, 2070739441, 2072624761, 2076192007, 2081039297, 2081551753, 2082146617, 2083034113, 2083997441, 2085453649,
		2085882661, 2086645009, 2093300401, 2095627153, 2096046457, 2097317377, 2100292841, 2101470541, 2101744837, 2104994449,
		2106147457, 2107148761, 2114643217, 2115769633, 2115986557, 2116483027, 2116541221, 2117031263, 2117555641, 2118621097,
		2120096161, 2123601751, 2124078653, 2124691213, 2127197489, 2128104001, 2129304997, 2130134533, 2131004737, 2131811501,
		2140699681, 2140771609, 2141340833, 2144961253, 2147418113, 2147429509, 2152627801, 2154446641, 2155416251, 2156151313,
		2164282177, 2168431201, 2170282969, 2172155819, 2173499329, 2173540951, 2173579801, 2175126601, 2175406201, 2175646177,
		2177374321, 2177645557, 2178082901, 2178939221, 2180221201, 2182281601, 2182802689, 2185362233, 2187717761, 2193980881,
		2199617701, 2200115713, 2201924341, 2202101761, 2202205897, 2203649197, 2203856497, 2206095589, 2210578759, 2213431729,
		2216960929, 2217879901, 2219072017, 2224252801, 2229468697, 2231332357, 2233031701, 2240507821, 2241880033, 2241982009,
		2244932281, 2245519981, 2246762899, 2248354153, 2251732033, 2254314241, 2254757077, 2256197761, 2256748777, 2256751837,
		2262861901, 2269307587, 2274584089, 2283289681, 2284416181, 2289251669, 2289624793, 2290316377, 2290910257, 2291205461,
		2292068143, 2295209281, 2296995121, 2299190401, 2300628601, 2300795353, 2301745249, 2304120001, 2308966661, 2309241601,
		2309405617, 2311558021, 2311575001, 2315137261, 2320527613, 2323147201, 2324867399, 2329584217, 2330569541, 2331181621,
		2335341601, 2338157597, 2338728001, 2340460487, 2345907961, 2347597981, 2352371251, 2354453561, 2355230749, 2355320101,
		2355622721, 2355649921, 2355735089, 2358534361, 2360261989, 2370771181, 2370928337, 2371350101, 2372976563, 2374232977,
		2375415841, 2377166401, 2378309041, 2381782597, 2382678101, 2383164577, 2385574201, 2389072321, 2389544977, 2393708761,
		2394311233, 2398393661, 2404912501, 2411128441, 2412172153, 2412675721, 2413973071, 2422296241, 2423401681, 2425249601,
		2428648967, 2428870753, 2428986913, 2429407961, 2430697513, 2431136401, 2431144801, 2432761633, 2432860273, 2433791593,
		2434964321, 2434974433, 2435091221, 2436691321, 2437907779, 2438778413, 2442050353, 2442454561, 2443708961, 2444950561,
		2448039497, 2448374689, 2453473049, 2454285751, 2456536681, 2457846161, 2463713281, 2471205361, 2473120961, 2473189441,
		2473823353, 2474308069, 2474676949, 2476283239, 2477814193, 2478643907, 2480147521, 2480343553, 2482435981, 2482682131,
		2484408301, 2486017249, 2488420801, 2488591117, 2492480233, 2494660033, 2494984321, 2495834329, 2499327041, 2501012599,
		2501771329, 2502525637, 2504008609, 2506529257, 2506733189, 2507121037, 2508178843, 2513230891, 2516684801, 2519297089,
		2525070241, 2526566041, 2528291341, 2529410281, 2529827821, 2529854713, 2530351561, 2532630787, 2533465661, 2533797017,
		2535516173, 2537105761, 2539406281, 2539736257, 2540469901, 2541660367, 2542479481, 2544590161, 2545934077, 2548051801,
		2550139253, 2550780277, 2551365769, 2552418761, 2553272929, 2555391481, 2561945401, 2564536201, 2565186137, 2570087521,
		2571180247, 2575060949, 2575737361, 2577345541, 2582092189, 2582246701, 2582952769, 2583322381, 2584460701, 2588054401,
		2588582089, 2590663681, 2593065721, 2595276353, 2597289241, 2597294701, 2598933481, 2600611861, 2602343521, 2602378721,
		2604465013, 2604803701, 2611122229, 2611461529, 2613382201, 2614688801, 2616180821, 2617563031, 2621080741, 2621977627,
		2622993661, 2624549929, 2625903601, 2626783921, 2627284987, 2630643401, 2632605049, 2634284801, 2634804481, 2634820813,
		2638067881, 2639099233, 2642159809, 2642582251, 2646751249, 2646790033, 2648662777, 2649907201, 2650820329, 2651507713,
		2654716321, 2656494271, 2658630913, 2658696301, 2659265701, 2668095181, 2668469431, 2670972949, 2672605657, 2672651521,
		2676053333, 2677147201, 2677821121, 2678785621, 2681041843, 2682823681, 2683742491, 2684284441, 2687655169, 2688124001,
		2689427281, 2690408533, 2690867401, 2693739751, 2695115473, 2700818017, 2700891839, 2701878941, 2704957909, 2706863833,
		2707661501, 2716157989, 2716275007, 2717428033, 2719319513, 2721666817, 2721721939, 2723859001, 2725357249, 2733156029,
		2736316301, 2738184697, 2740336561, 2744329909, 2746021741, 2753333227, 2753538001, 2759392633, 2765323397, 2766006253,
		2767672189, 2769080161, 2769602333, 2774295577, 2777887297, 2778304273, 2779477741, 2781117721, 2781226477, 2786028337,
		2787998641, 2789218909, 2800352011, 2805762961, 2809635901, 2812672981, 2814748201, 2823570433, 2824256377, 2824804693,
		2824854913, 2828205397, 2832384133, 2832743713, 2837697773, 2837917633, 2840634109, 2840871041, 2841190381, 2847894377,
		2848466281, 2848722131, 2855046421, 2855071801, 2855512909, 2862066481, 2865483601, 2866005139, 2866527841, 2870377309,
		2871536561, 2872527733, 2872948321, 2874382853, 2877769501, 2881429741, 2882370481, 2885594497, 2887955533, 2890316801,
		2890414873, 2892426029, 2894667781, 2895004927, 2899294889, 2903776129, 2915953633, 2916247819, 2918295451, 2920691161,
		2923042141, 2924158001, 2929062533, 2929106753, 2930831641, 2931708097, 2932327549, 2936227603, 2936958181, 2941174897,
		2941343633, 2944555681, 2944677961, 2945208001, 2945549881, 2951136343, 2956724317, 2957320351, 2965700233, 2967053953,
		2968206601, 2974506841, 2975377429, 2976930001, 2978766341, 2980689601, 2986025677, 2987414977, 2990152901, 2993462713,
		2993495041, 2994098281, 2994415201, 2998202353, 2998919873, 3000688381, 3001561441, 3002647829, 3004443679, 3009628301,
		3011421841, 3014101261, 3015502181, 3016957381, 3017444761, 3018147217, 3018576689, 3019916461, 3025350343, 3026575553,
		3028586471, 3030393901, 3033332641, 3034402681, 3034817209, 3035375047, 3036079729, 3037295801, 3037781251, 3038880473,
		3039681457, 3041984353, 3042630533, 3048159841, 3050190163, 3056100623, 3056160929, 3057886591, 3058670677, 3059397793,
		3063685633, 3065998717, 3076505209, 3077122133, 3079496551, 3082054697, 3082068013, 3083053387, 3083537689, 3083884651,
		3088408429, 3089013313, 3091019777, 3094763851, 3099670657, 3103800701, 3112974481, 3114125071, 3115667521, 3120445697,
		3122287981, 3129914881, 3133899409, 3135040133, 3143282221, 3145410761, 3150972917, 3156599161, 3156643141, 3157579861,
		3163106953, 3166504273, 3167442721, 3170262409, 3172658653, 3175204531, 3175255717, 3178375201, 3181356263, 3181391641,
		3182606857, 3182655361, 3182891401, 3185472001, 3187035113, 3187421077, 3187939921, 3196397821, 3196431829, 3197565001,
		3197632441, 3197911001, 3197911741, 3199164901, 3205663921, 3207297773, 3208902491, 3212465437, 3215031751, 3217412881,
		3219808411, 3221580281, 3222693421, 3224143441, 3225081473, 3227082823, 3227209057, 3229131137, 3233558021, 3237992101,
		3242533897, 3248236309, 3250348417, 3250700737, 3252148621, 3257334541, 3258647809, 3258892801, 3261114601, 3263097641,
		3263568901, 3263626957, 3264820001, 3265122451, 3267417677, 3268506541, 3268841941, 3270933121, 3271999249, 3272030401,
		3272702497, 3274264033, 3275671969, 3276075709, 3277047649, 3278640289, 3280067129, 3282974857, 3287174129, 3288757249,
		3295362727, 3296403601, 3299246833, 3302322241, 3304307341, 3305829073, 3306686659, 3306957593, 3310858777, 3312489577,
		3312536569, 3313196881, 3315139717, 3320669437, 3323308501, 3323590463, 3323829169, 3328354801, 3332800021, 3334350781,
		3340214413, 3342005633, 3344191241, 3346172189, 3347908801, 3349218881, 3350993969, 3352091557, 3355382857, 3355953001,
		3357417181, 3359737921, 3360511981, 3369139201, 3371024521, 3371452921, 3371693063, 3372667121, 3373086601, 3381052177,
		3381901921, 3385842877, 3386603221, 3387014401, 3387487351, 3389030261, 3395091311, 3399205591, 3399890413, 3402234749,
		3407609221, 3407772817, 3407952169, 3408135121, 3409339393, 3411250081, 3411574801, 3411829693, 3412575097, 3415379701,
		3415832137, 3417522841, 3420143941, 3421845001, 3423222757, 3423580481, 3427050673, 3428133103, 3429457921, 3429982081,
		3430804297, 3432695921, 3432997537, 3433458073, 3434575327, 3435973837, 3440195713, 3443704261, 3449768513, 3450717901,
		3453900913, 3458257741, 3461861761, 3463907761, 3464236901, 3466158361, 3470716657, 3474335437, 3480174001, 3482161261,
		3485747521, 3489958697, 3491763493, 3492178873, 3492883081, 3493262761, 3497607433, 3504132113, 3512030497, 3512291021,
		3512369857, 3513604657, 3516565057, 3519318721, 3524086333, 3525088961, 3529119361, 3529864391, 3532687201, 3533662129,
		3533856913, 3538213381, 3542303047, 3543203333, 3548378341, 3549286001, 3549988261, 3552158521, 3553567057, 3557646401,
		3562963973, 3563340457, 3566428301, 3574891757, 3582711841, 3583249921, 3583604161, 3584800801, 3586833253, 3587553971,
		3589937261, 3590409439, 3593276353, 3594110081, 3596491907, 3596815169, 3598772761, 3602006101, 3605151241, 3611571121,
		3612298321, 3612825221, 3614770573, 3616574081, 3620631169, 3628526287, 3630596257, 3631828481, 3632452741, 3635993089,
		3649116277, 3649965281, 3650158849, 3651572609, 3656355841, 3658730893, 3662387977, 3662503093, 3663084541, 3668926801,
		3669587533, 3672754633, 3677180797, 3679657997, 3682471321, 3685647701, 3685775741, 3692307161, 3695628133, 3697278427,
		3700801861, 3705582073, 3705623281, 3708123301, 3708905341, 3709626961, 3712887289, 3713287801, 3713448769, 3718226401,
		3721486081, 3723410161, 3723699373, 3725016749, 3727828501, 3729097633, 3733761739, 3736293461, 3745192001, 3746101189,
		3749383681, 3751554581, 3751782737, 3754680403, 3756668401, 3759781369, 3760622689, 3760896133, 3762110881, 3767640601,
		3773061337, 3774337201, 3784123501, 3787491457, 3798040471, 3798626833, 3799111681, 3800084401, 3805699501, 3807112123,
		3807308269, 3807749821, 3809018947, 3813919453, 3817561777, 3817706621, 3821233121, 3827035237, 3832807681, 3833208961,
		3842941741, 3846174151, 3846532801, 3847106803, 3850058689, 3852800033, 3863326897, 3865604023, 3867183937, 3874471147,
		3874523017, 3875096893, 3875965417, 3886515361, 3886643801, 3887423437, 3887635753, 3891892421, 3891919417, 3894053311,
		3896079281, 3897241129, 3897869201, 3898906129, 3900327241, 3903711841, 3905533721, 3905876501, 3907577521, 3907752241,
		3912174421, 3914880337, 3914923211, 3915467341, 3915604421, 3915921241, 3918227437, 3922321561, 3926912669, 3929293061,
		3934940833, 3935864017, 3936123601, 3945165841, 3947233201, 3947383201, 3953408801, 3953949421, 3955572001, 3958597301,
		3958930441, 3959578801, 3960728641, 3962037061, 3966350203, 3967343161, 3971095301, 3973556837, 3979485931, 3982017601,
		3987528793, 3987960913, 3991124341, 3992697997, 3997536427, 4005660961, 4007365741, 4011996871, 4015548769, 4017684529,
		4018283501, 4020144133, 4026822577, 4027012021, 4027518961, 4028465873, 4028771849, 4031223841, 4034969401, 4034993269,
		4035498409, 4036395581, 4042538497, 4044601751, 4044884689, 4048493983, 4053267217, 4054039841, 4057195309, 4058433931,
		4059776533, 4060942381, 4061009971, 4064633821, 4067039461, 4067887501, 4068671881, 4071644893, 4075241633, 4075721921,
		4076009857, 4079665633, 4079682361, 4083376067, 4085074909, 4088147617, 4088838913, 4092929149, 4098258707, 4099180801,
		4100934241, 4103745689, 4105691393, 4108970251, 4109461709, 4109711581, 4110320663, 4113013141, 4115891893, 4117058221,
		4117447441, 4121286907, 4127050621, 4129914673, 4133928761, 4135847101, 4136916001, 4137262541, 4138838401, 4139015987,
		4150174393, 4155375349, 4157008813, 4162880401, 4166032873, 4183664101, 4185636781, 4186561633, 4187360341, 4191864013,
		4192060699, 4195843037, 4196323561, 4204344601, 4206006229, 4206295433, 4212105409, 4215885697, 4218900001, 4220122321,
		4232966251, 4234224601, 4237212061, 4243744201, 4244022301, 4244663651, 4247990917, 4250920459, 4251904273, 4255695013,
		4257003353, 4261352869, 4271267333, 4275011401, 4277526901, 4278305651, 4282867213, 4285148981, 4293088801, 4294901761,
	}

	primes16 = [65536]byte{
		2, 1, 1, 2, 1, 2, 1, 4, 3, 2, // 0-9
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 10-19
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 20-29
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 30-39
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 40-49
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 50-59
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 60-69
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 70-79
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 80-89
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 90-99
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 100-109
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 110-119
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 120-129
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 130-139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 140-149
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 150-159
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 160-169
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 170-179
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 180-189
		1, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 190-199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 200-209
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 210-219
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 220-229
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 230-239
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 240-249
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 250-259
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 260-269
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 270-279
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 280-289
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 290-299
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 300-309
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 310-319
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 320-329
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 330-339
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 340-349
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 350-359
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 360-369
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 370-379
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 380-389
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 390-399
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 400-409
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 410-419
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 420-429
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 430-439
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 440-449
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 450-459
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 460-469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 470-479
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 480-489
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 490-499
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 500-509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 510-519
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 520-529
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 530-539
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 540-549
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 550-559
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 560-569
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 570-579
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 580-589
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 590-599
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 600-609
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 610-619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 620-629
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 630-639
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 640-649
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 650-659
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 660-669
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 670-679
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 680-689
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 690-699
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 700-709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 710-719
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 720-729
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 730-739
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 740-749
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 750-759
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 760-769
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 770-779
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 780-789
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 790-799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 800-809
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 810-819
		1, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 820-829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 830-839
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 840-849
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 850-859
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 860-869
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 870-879
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 880-889
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 890-899
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 900-909
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 910-919
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 920-929
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 930-939
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 940-949
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 950-959
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 960-969
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 970-979
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 980-989
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 990-999
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 1000-1009
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 1010-1019
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1020-1029
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 1030-1039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 1040-1049
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1050-1059
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 1060-1069
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 1070-1079
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 1080-1089
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 1090-1099
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 1100-1109
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1110-1119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 1120-1129
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 1130-1139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1140-1149
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 1150-1159
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 1160-1169
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1170-1179
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1180-1189
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 1190-1199
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 1200-1209
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 1210-1219
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 1220-1229
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 1230-1239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 1240-1249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 1250-1259
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 1260-1269
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 1270-1279
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 1280-1289
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 1290-1299
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 1300-1309
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 1310-1319
		1, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 1320-1329
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 1330-1339
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 1340-1349
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1350-1359
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1360-1369
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 1370-1379
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 1380-1389
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 1390-1399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 1400-1409
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 1410-1419
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 1420-1429
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 1430-1439
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 1440-1449
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 1450-1459
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1460-1469
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1470-1479
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 1480-1489
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 1490-1499
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1500-1509
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 1510-1519
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 1520-1529
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 1530-1539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 1540-1549
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 1550-1559
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 1560-1569
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 1570-1579
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 1580-1589
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 1590-1599
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 1600-1609
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 1610-1619
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 1620-1629
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 1630-1639
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 1640-1649
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1650-1659
		3, 2, 1, 4, 3, 2, 1, 2, 1, 24, // 1660-1669
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 1670-1679
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 1680-1689
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 1690-1699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 1700-1709
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1710-1719
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 1720-1729
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 1730-1739
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1740-1749
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 1750-1759
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 1760-1769
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1770-1779
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 1780-1789
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1790-1799
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1800-1809
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 1810-1819
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 1820-1829
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 1830-1839
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 1840-1849
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1850-1859
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 1860-1869
		1, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 1870-1879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 1880-1889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1890-1899
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1900-1909
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 1910-1919
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 1920-1929
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 1930-1939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 1940-1949
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 1950-1959
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 1960-1969
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 1970-1979
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 1980-1989
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 1990-1999
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 2000-2009
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 2010-2019
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 2020-2029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 2030-2039
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 2040-2049
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 2050-2059
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 2060-2069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2070-2079
		1, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 2080-2089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 2090-2099
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2100-2109
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 2110-2119
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 2120-2129
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2130-2139
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 2140-2149
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 2150-2159
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 2160-2169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 2170-2179
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 2180-2189
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 2190-2199
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 2200-2209
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 2210-2219
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 2220-2229
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 2230-2239
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 2240-2249
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 2250-2259
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 2260-2269
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 2270-2279
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 2280-2289
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 2290-2299
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 2300-2309
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 2310-2319
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 2320-2329
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 2330-2339
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2340-2349
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 2350-2359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2360-2369
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2370-2379
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 2380-2389
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 2390-2399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2400-2409
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 2410-2419
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 2420-2429
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2430-2439
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 2440-2449
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 2450-2459
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 2460-2469
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 2470-2479
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 2480-2489
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 2490-2499
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 2500-2509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2510-2519
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2520-2529
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 2530-2539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 2540-2549
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 2550-2559
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 2560-2569
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 2570-2579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2580-2589
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 2590-2599
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 2600-2609
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2610-2619
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 2620-2629
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 2630-2639
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 2640-2649
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 2650-2659
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 2660-2669
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 2670-2679
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 2680-2689
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 2690-2699
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2700-2709
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 2710-2719
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 2720-2729
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 2730-2739
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 2740-2749
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 2750-2759
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 2760-2769
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 2770-2779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 2780-2789
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2790-2799
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 2800-2809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 2810-2819
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 2820-2829
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 2830-2839
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 2840-2849
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 2850-2859
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 2860-2869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 2870-2879
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 2880-2889
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 2890-2899
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 2900-2909
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 2910-2919
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 2920-2929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 2930-2939
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 2940-2949
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 2950-2959
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 2960-2969
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 2970-2979
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 2980-2989
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 2990-2999
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3000-3009
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 3010-3019
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 3020-3029
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3030-3039
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 3040-3049
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3050-3059
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 3060-3069
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 3070-3079
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 3080-3089
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 3090-3099
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 3100-3109
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 3110-3119
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 3120-3129
		7, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 3130-3139
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 3140-3149
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 3150-3159
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 3160-3169
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3170-3179
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3180-3189
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 3190-3199
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 3200-3209
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3210-3219
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 3220-3229
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 3230-3239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3240-3249
		1, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 3250-3259
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3260-3269
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 3270-3279
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 3280-3289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 3290-3299
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 3300-3309
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 3310-3319
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 3320-3329
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 3330-3339
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 3340-3349
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 3350-3359
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3360-3369
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 3370-3379
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 3380-3389
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 3390-3399
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 3400-3409
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 3410-3419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 3420-3429
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 3430-3439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 3440-3449
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3450-3459
		1, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 3460-3469
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 3470-3479
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3480-3489
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 3490-3499
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3500-3509
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 3510-3519
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 3520-3529
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 3530-3539
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 3540-3549
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 3550-3559
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3560-3569
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3570-3579
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 3580-3589
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 3590-3599
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 3600-3609
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 3610-3619
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 3620-3629
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 3630-3639
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 3640-3649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 3650-3659
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3660-3669
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 3670-3679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3680-3689
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3690-3699
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 3700-3709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 3710-3719
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 3720-3729
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 3730-3739
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 3740-3749
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3750-3759
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 3760-3769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 3770-3779
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 3780-3789
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 3790-3799
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 3800-3809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3810-3819
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 3820-3829
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 3830-3839
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3840-3849
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 3850-3859
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 3860-3869
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3870-3879
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 3880-3889
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 3890-3899
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 3900-3909
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 3910-3919
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 3920-3929
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 3930-3939
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 3940-3949
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 3950-3959
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 3960-3969
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 3970-3979
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 3980-3989
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 3990-3999
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 4000-4009
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 4010-4019
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 4020-4029
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 4030-4039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 4040-4049
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 4050-4059
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 4060-4069
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 4070-4079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4080-4089
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 4090-4099
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4100-4109
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 4110-4119
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 4120-4129
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 4130-4139
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 4140-4149
		3, 2, 1, 4, 3, 2, 1, 2, 1, 18, // 4150-4159
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 4160-4169
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 4170-4179
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 4180-4189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4190-4199
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4200-4209
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 4210-4219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 4220-4229
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4230-4239
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 4240-4249
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 4250-4259
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4260-4269
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 4270-4279
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 4280-4289
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 4290-4299
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 4300-4309
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 4310-4319
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 4320-4329
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 4330-4339
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 4340-4349
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 4350-4359
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 4360-4369
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 4370-4379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4380-4389
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 4390-4399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 4400-4409
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4410-4419
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 4420-4429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4430-4439
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 4440-4449
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 4450-4459
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 4460-4469
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4470-4479
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 4480-4489
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 4490-4499
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 4500-4509
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 4510-4519
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 4520-4529
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 4530-4539
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 4540-4549
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4550-4559
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 4560-4569
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 4570-4579
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 4580-4589
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 4590-4599
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 4600-4609
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4610-4619
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 4620-4629
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 4630-4639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 4640-4649
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 4650-4659
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 4660-4669
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 4670-4679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4680-4689
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 4690-4699
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 4700-4709
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4710-4719
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 4720-4729
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 4730-4739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4740-4749
		1, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 4750-4759
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 4760-4769
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 4770-4779
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 4780-4789
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 4790-4799
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 4800-4809
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 4810-4819
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4820-4829
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 4830-4839
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 4840-4849
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4850-4859
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4860-4869
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 4870-4879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 4880-4889
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 4890-4899
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 4900-4909
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 4910-4919
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 4920-4929
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 4930-4939
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 4940-4949
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 4950-4959
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 4960-4969
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 4970-4979
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 4980-4989
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 4990-4999
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 5000-5009
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5010-5019
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 5020-5029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 5030-5039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5040-5049
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 5050-5059
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5060-5069
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5070-5079
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 5080-5089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 5090-5099
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5100-5109
		3, 2, 1, 6, 5, 4, 3, 2, 1, 28, // 5110-5119
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 5120-5129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5130-5139
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5140-5149
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 5150-5159
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5160-5169
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 5170-5179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 5180-5189
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 5190-5199
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 5200-5209
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5210-5219
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5220-5229
		1, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 5230-5239
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 5240-5249
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5250-5259
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 5260-5269
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 5270-5279
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5280-5289
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5290-5299
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 5300-5309
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 5310-5319
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 5320-5329
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 5330-5339
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5340-5349
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 5350-5359
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 5360-5369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5370-5379
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5380-5389
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 5390-5399
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5400-5409
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 5410-5419
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5420-5429
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5430-5439
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 5440-5449
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 5450-5459
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5460-5469
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 5470-5479
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 5480-5489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5490-5499
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 5500-5509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 5510-5519
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5520-5529
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 5530-5539
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5540-5549
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5550-5559
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 5560-5569
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 5570-5579
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5580-5589
		1, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 5590-5599
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 5600-5609
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 5610-5619
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 5620-5629
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 5630-5639
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5640-5649
		1, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 5650-5659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 5660-5669
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 5670-5679
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 5680-5689
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 5690-5699
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5700-5709
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 5710-5719
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5720-5729
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5730-5739
		1, 2, 1, 6, 5, 4, 3, 2, 1, 30, // 5740-5749
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 5750-5759
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 5760-5769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 5770-5779
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 5780-5789
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5790-5799
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5800-5809
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 5810-5819
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 5820-5829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 5830-5839
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 5840-5849
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 5850-5859
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 5860-5869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 5870-5879
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5880-5889
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 5890-5899
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 5900-5909
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 5910-5919
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 5920-5929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 5930-5939
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 5940-5949
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 5950-5959
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 5960-5969
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 5970-5979
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 5980-5989
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 5990-5999
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 6000-6009
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 6010-6019
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 6020-6029
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6030-6039
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 6040-6049
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 6050-6059
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6060-6069
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 6070-6079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 6080-6089
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6090-6099
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 6100-6109
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 6110-6119
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6120-6129
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 6130-6139
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 6140-6149
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 6150-6159
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 6160-6169
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 6170-6179
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 6180-6189
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 6190-6199
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 6200-6209
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 6210-6219
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 6220-6229
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 6230-6239
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 6240-6249
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6250-6259
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 6260-6269
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 6270-6279
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 6280-6289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 6290-6299
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6300-6309
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6310-6319
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 6320-6329
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6330-6339
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 6340-6349
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 6350-6359
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6360-6369
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 6370-6379
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 6380-6389
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 6390-6399
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 6400-6409
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6410-6419
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 6420-6429
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 6430-6439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 6440-6449
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 6450-6459
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 6460-6469
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 6470-6479
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6480-6489
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 6490-6499
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 6500-6509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6510-6519
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 6520-6529
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 6530-6539
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 6540-6549
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 6550-6559
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 6560-6569
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 6570-6579
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 6580-6589
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 6590-6599
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 6600-6609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 6610-6619
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 6620-6629
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 6630-6639
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 6640-6649
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 6650-6659
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 6660-6669
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 6670-6679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 6680-6689
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6690-6699
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 6700-6709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 6710-6719
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 6720-6729
		3, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 6730-6739
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 6740-6749
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6750-6759
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 6760-6769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 6770-6779
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 6780-6789
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 6790-6799
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 6800-6809
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 6810-6819
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 6820-6829
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 6830-6839
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 6840-6849
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6850-6859
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 6860-6869
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 6870-6879
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 6880-6889
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 6890-6899
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 6900-6909
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 6910-6919
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 6920-6929
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 6930-6939
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 6940-6949
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 6950-6959
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 6960-6969
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 6970-6979
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 6980-6989
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 6990-6999
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7000-7009
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 7010-7019
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 7020-7029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 7030-7039
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 7040-7049
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 7050-7059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 7060-7069
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 7070-7079
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 7080-7089
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7090-7099
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 7100-7109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7110-7119
		1, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 7120-7129
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 7130-7139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7140-7149
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 7150-7159
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 7160-7169
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 7170-7179
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 7180-7189
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 7190-7199
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 7200-7209
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 7210-7219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 7220-7229
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 7230-7239
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 7240-7249
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 7250-7259
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 7260-7269
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7270-7279
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 7280-7289
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 7290-7299
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 7300-7309
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7310-7319
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7320-7329
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 7330-7339
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 7340-7349
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 7350-7359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 7360-7369
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 7370-7379
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7380-7389
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 7390-7399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7400-7409
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 7410-7419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7420-7429
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 7430-7439
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7440-7449
		1, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 7450-7459
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 7460-7469
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 7470-7479
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 7480-7489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 7490-7499
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 7500-7509
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 7510-7519
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 7520-7529
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 7530-7539
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 7540-7549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 7550-7559
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7560-7569
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 7570-7579
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 7580-7589
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7590-7599
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 7600-7609
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7610-7619
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 7620-7629
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 7630-7639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 7640-7649
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 7650-7659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 7660-7669
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 7670-7679
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 7680-7689
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 7690-7699
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 7700-7709
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 7710-7719
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 7720-7729
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7730-7739
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7740-7749
		3, 2, 1, 4, 3, 2, 1, 2, 1, 30, // 7750-7759
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 7760-7769
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 7770-7779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 7780-7789
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 7790-7799
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 7800-7809
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 7810-7819
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 7820-7829
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7830-7839
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7840-7849
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 7850-7859
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 7860-7869
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 7870-7879
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 7880-7889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 7890-7899
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 7900-7909
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 7910-7919
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 7920-7929
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 7930-7939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 7940-7949
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7950-7959
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 7960-7969
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 7970-7979
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 7980-7989
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 7990-7999
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 8000-8009
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 8010-8019
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 8020-8029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 8030-8039
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8040-8049
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 8050-8059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 8060-8069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8070-8079
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 8080-8089
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 8090-8099
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8100-8109
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 8110-8119
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 8120-8129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 8130-8139
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 8140-8149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8150-8159
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 8160-8169
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 8170-8179
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8180-8189
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 8190-8199
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 8200-8209
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 8210-8219
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8220-8229
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 8230-8239
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 8240-8249
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8250-8259
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 8260-8269
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 8270-8279
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 8280-8289
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 8290-8299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8300-8309
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 8310-8319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 8320-8329
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 8330-8339
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8340-8349
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 8350-8359
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 8360-8369
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 8370-8379
		7, 6, 5, 4, 3, 2, 1, 2, 1, 30, // 8380-8389
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 8390-8399
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 8400-8409
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 8410-8419
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 8420-8429
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8430-8439
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 8440-8449
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8450-8459
		1, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 8460-8469
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 8470-8479
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 8480-8489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8490-8499
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8500-8509
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 8510-8519
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 8520-8529
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 8530-8539
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 8540-8549
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8550-8559
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 8560-8569
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 8570-8579
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 8580-8589
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 8590-8599
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 8600-8609
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8610-8619
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 8620-8629
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8630-8639
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 8640-8649
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8650-8659
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 8660-8669
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 8670-8679
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 8680-8689
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 8690-8699
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 8700-8709
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 8710-8719
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8720-8729
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 8730-8739
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 8740-8749
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 8750-8759
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 8760-8769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 8770-8779
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 8780-8789
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8790-8799
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 8800-8809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 8810-8819
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8820-8829
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 8830-8839
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 8840-8849
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8850-8859
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 8860-8869
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 8870-8879
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 8880-8889
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 8890-8899
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 8900-8909
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8910-8919
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 8920-8929
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 8930-8939
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 8940-8949
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 8950-8959
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 8960-8969
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 8970-8979
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 8980-8989
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 8990-8999
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 9000-9009
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 9010-9019
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 9020-9029
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9030-9039
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 9040-9049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 9050-9059
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 9060-9069
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 9070-9079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9080-9089
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9090-9099
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 9100-9109
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9110-9119
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 9120-9129
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 9130-9139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9140-9149
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 9150-9159
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9160-9169
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 9170-9179
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 9180-9189
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 9190-9199
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 9200-9209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9210-9219
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 9220-9229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 9230-9239
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9240-9249
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 9250-9259
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9260-9269
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 9270-9279
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 9280-9289
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 9290-9299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9300-9309
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 9310-9319
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 9320-9329
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 9330-9339
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 9340-9349
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 9350-9359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9360-9369
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 9370-9379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9380-9389
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 9390-9399
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 9400-9409
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 9410-9419
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9420-9429
		1, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 9430-9439
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 9440-9449
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9450-9459
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 9460-9469
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 9470-9479
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9480-9489
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 9490-9499
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9500-9509
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9510-9519
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9520-9529
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 9530-9539
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 9540-9549
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 9550-9559
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 9560-9569
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9570-9579
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 9580-9589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9590-9599
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9600-9609
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 9610-9619
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 9620-9629
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9630-9639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 9640-9649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9650-9659
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9660-9669
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 9670-9679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 9680-9689
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 9690-9699
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 9700-9709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 9710-9719
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9720-9729
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 9730-9739
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 9740-9749
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9750-9759
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 9760-9769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9770-9779
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 9780-9789
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9790-9799
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 9800-9809
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 9810-9819
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 9820-9829
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 9830-9839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9840-9849
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 9850-9859
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9860-9869
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9870-9879
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 9880-9889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9890-9899
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 9900-9909
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 9910-9919
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 9920-9929
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 9930-9939
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 9940-9949
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9950-9959
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 9960-9969
		3, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 9970-9979
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 9980-9989
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 9990-9999
		7, 6, 5, 4, 3, 2, 1, 2, 1, 28, // 10000-10009
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 10010-10019
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 10020-10029
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 10030-10039
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 10040-10049
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10050-10059
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 10060-10069
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 10070-10079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10080-10089
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 10090-10099
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 10100-10109
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 10110-10119
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10120-10129
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 10130-10139
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10140-10149
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 10150-10159
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 10160-10169
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 10170-10179
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10180-10189
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 10190-10199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10200-10209
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10210-10219
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 10220-10229
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10230-10239
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 10240-10249
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 10250-10259
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 10260-10269
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 10270-10279
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 10280-10289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10290-10299
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 10300-10309
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 10310-10319
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10320-10329
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 10330-10339
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 10340-10349
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 10350-10359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 10360-10369
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 10370-10379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10380-10389
		1, 8, 7, 6, 5, 4, 3, 2, 1, 28, // 10390-10399
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 10400-10409
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 10410-10419
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 10420-10429
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 10430-10439
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10440-10449
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 10450-10459
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 10460-10469
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 10470-10479
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 10480-10489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 10490-10499
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10500-10509
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 10510-10519
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 10520-10529
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 10530-10539
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 10540-10549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 10550-10559
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 10560-10569
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 10570-10579
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 10580-10589
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 10590-10599
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 10600-10609
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 10610-10619
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 10620-10629
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 10630-10639
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10640-10649
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 10650-10659
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 10660-10669
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 10670-10679
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 10680-10689
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 10690-10699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 10700-10709
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10710-10719
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 10720-10729
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 10730-10739
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10740-10749
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 10750-10759
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10760-10769
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10770-10779
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 10780-10789
		9, 8, 7, 6, 5, 4, 3, 2, 1, 32, // 10790-10799
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 10800-10809
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 10810-10819
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 10820-10829
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 10830-10839
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 10840-10849
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 10850-10859
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 10860-10869
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10870-10879
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 10880-10889
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10890-10899
		3, 2, 1, 6, 5, 4, 3, 2, 1, 28, // 10900-10909
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 10910-10919
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 10920-10929
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 10930-10939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 10940-10949
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 10950-10959
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 10960-10969
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 10970-10979
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 10980-10989
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 10990-10999
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 11000-11009
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11010-11019
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 11020-11029
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11030-11039
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 11040-11049
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 11050-11059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 11060-11069
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11070-11079
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 11080-11089
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 11090-11099
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11100-11109
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 11110-11119
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11120-11129
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 11130-11139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 11140-11149
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 11150-11159
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11160-11169
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 11170-11179
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11180-11189
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 11190-11199
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11200-11209
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 11210-11219
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 11220-11229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 11230-11239
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 11240-11249
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 11250-11259
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11260-11269
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 11270-11279
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 11280-11289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 11290-11299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11300-11309
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 11310-11319
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 11320-11329
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 11330-11339
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11340-11349
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 11350-11359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 11360-11369
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11370-11379
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 11380-11389
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 11390-11399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11400-11409
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11410-11419
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 11420-11429
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 11430-11439
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 11440-11449
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11450-11459
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 11460-11469
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11470-11479
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 11480-11489
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 11490-11499
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 11500-11509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 11510-11519
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 11520-11529
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 11530-11539
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 11540-11549
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 11550-11559
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 11560-11569
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 11570-11579
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 11580-11589
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 11590-11599
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11600-11609
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 11610-11619
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11620-11629
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 11630-11639
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11640-11649
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 11650-11659
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11660-11669
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 11670-11679
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 11680-11689
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 11690-11699
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11700-11709
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 11710-11719
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11720-11729
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11730-11739
		3, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 11740-11749
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 11750-11759
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11760-11769
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 11770-11779
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 11780-11789
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11790-11799
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 11800-11809
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 11810-11819
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 11820-11829
		1, 2, 1, 6, 5, 4, 3, 2, 1, 24, // 11830-11839
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 11840-11849
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11850-11859
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 11860-11869
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11870-11879
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 11880-11889
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 11890-11899
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 11900-11909
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11910-11919
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 11920-11929
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 11930-11939
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 11940-11949
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 11950-11959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 11960-11969
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 11970-11979
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 11980-11989
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 11990-11999
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12000-12009
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 12010-12019
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 12020-12029
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12030-12039
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 12040-12049
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 12050-12059
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12060-12069
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 12070-12079
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 12080-12089
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12090-12099
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 12100-12109
		3, 2, 1, 6, 5, 4, 3, 2, 1, 24, // 12110-12119
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 12120-12129
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12130-12139
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 12140-12149
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12150-12159
		1, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 12160-12169
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 12170-12179
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 12180-12189
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12190-12199
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 12200-12209
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 12210-12219
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 12220-12229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 12230-12239
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12240-12249
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 12250-12259
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 12260-12269
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12270-12279
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 12280-12289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12290-12299
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 12300-12309
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12310-12319
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 12320-12329
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12330-12339
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 12340-12349
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 12350-12359
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12360-12369
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 12370-12379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12380-12389
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12390-12399
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 12400-12409
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 12410-12419
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12420-12429
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 12430-12439
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12440-12449
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 12450-12459
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12460-12469
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 12470-12479
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12480-12489
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12490-12499
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 12500-12509
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 12510-12519
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 12520-12529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 12530-12539
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12540-12549
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 12550-12559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 12560-12569
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12570-12579
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 12580-12589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12590-12599
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12600-12609
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 12610-12619
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 12620-12629
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12630-12639
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12640-12649
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 12650-12659
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12660-12669
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 12670-12679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 12680-12689
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12690-12699
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 12700-12709
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 12710-12719
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 12720-12729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 12730-12739
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 12740-12749
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12750-12759
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 12760-12769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12770-12779
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12780-12789
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 12790-12799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 12800-12809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12810-12819
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 12820-12829
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12830-12839
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12840-12849
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 12850-12859
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 12860-12869
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 12870-12879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 12880-12889
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 12890-12899
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 12900-12909
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 12910-12919
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 12920-12929
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12930-12939
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 12940-12949
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 12950-12959
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 12960-12969
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 12970-12979
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 12980-12989
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 12990-12999
		1, 2, 1, 4, 3, 2, 1, 2, 1, 24, // 13000-13009
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 13010-13019
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13020-13029
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 13030-13039
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 13040-13049
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13050-13059
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 13060-13069
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 13070-13079
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13080-13089
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 13090-13099
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 13100-13109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13110-13119
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 13120-13129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 13130-13139
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 13140-13149
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 13150-13159
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 13160-13169
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 13170-13179
		3, 2, 1, 4, 3, 2, 1, 30, 29, 28, // 13180-13189
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 13190-13199
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 13200-13209
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 13210-13219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 13220-13229
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13230-13239
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 13240-13249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 13250-13259
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 13260-13269
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 13270-13279
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13280-13289
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 13290-13299
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 13300-13309
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 13310-13319
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 13320-13329
		1, 6, 5, 4, 3, 2, 1, 2, 1, 28, // 13330-13339
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 13340-13349
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 13350-13359
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 13360-13369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13370-13379
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 13380-13389
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 13390-13399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13400-13409
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 13410-13419
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 13420-13429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13430-13439
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13440-13449
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 13450-13459
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 13460-13469
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 13470-13479
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 13480-13489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 13490-13499
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13500-13509
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 13510-13519
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 13520-13529
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 13530-13539
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13540-13549
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 13550-13559
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 13560-13569
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 13570-13579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13580-13589
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 13590-13599
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13600-13609
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 13610-13619
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 13620-13629
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 13630-13639
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 13640-13649
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 13650-13659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 13660-13669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 13670-13679
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 13680-13689
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 13690-13699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 13700-13709
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13710-13719
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 13720-13729
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 13730-13739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13740-13749
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 13750-13759
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 13760-13769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13770-13779
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 13780-13789
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 13790-13799
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 13800-13809
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 13810-13819
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 13820-13829
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13830-13839
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 13840-13849
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 13850-13859
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13860-13869
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 13870-13879
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 13880-13889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13890-13899
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 13900-13909
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 13910-13919
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 13920-13929
		1, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 13930-13939
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 13940-13949
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 13950-13959
		3, 2, 1, 4, 3, 2, 1, 30, 29, 28, // 13960-13969
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 13970-13979
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 13980-13989
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 13990-13999
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 14000-14009
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 14010-14019
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 14020-14029
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 14030-14039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14040-14049
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 14050-14059
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14060-14069
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14070-14079
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 14080-14089
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 14090-14099
		7, 6, 5, 4, 3, 2, 1, 36, 35, 34, // 14100-14109
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 14110-14119
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 14120-14129
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14130-14139
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 14140-14149
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 14150-14159
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14160-14169
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 14170-14179
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 14180-14189
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 14190-14199
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 14200-14209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14210-14219
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 14220-14229
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14230-14239
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 14240-14249
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 14250-14259
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 14260-14269
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14270-14279
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14280-14289
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 14290-14299
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 14300-14309
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14310-14319
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 14320-14329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14330-14339
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 14340-14349
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 14350-14359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 14360-14369
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 14370-14379
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 14380-14389
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14390-14399
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 14400-14409
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 14410-14419
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 14420-14429
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 14430-14439
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 14440-14449
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14450-14459
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 14460-14469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 14470-14479
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 14480-14489
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14490-14499
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 14500-14509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 14510-14519
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14520-14529
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 14530-14539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 14540-14549
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 14550-14559
		1, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 14560-14569
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 14570-14579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14580-14589
		1, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 14590-14599
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 14600-14609
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 14610-14619
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 14620-14629
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 14630-14639
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14640-14649
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 14650-14659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 14660-14669
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14670-14679
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 14680-14689
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 14690-14699
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14700-14709
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 14710-14719
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 14720-14729
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 14730-14739
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 14740-14749
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 14750-14759
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 14760-14769
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 14770-14779
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 14780-14789
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 14790-14799
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14800-14809
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 14810-14819
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 14820-14829
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14830-14839
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 14840-14849
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 14850-14859
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 14860-14869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 14870-14879
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 14880-14889
		1, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 14890-14899
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 14900-14909
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14910-14919
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 14920-14929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 14930-14939
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 14940-14949
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 14950-14959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 14960-14969
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 14970-14979
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 14980-14989
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 14990-14999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 15000-15009
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 15010-15019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15020-15029
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 15030-15039
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 15040-15049
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 15050-15059
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 15060-15069
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 15070-15079
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 15080-15089
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15090-15099
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 15100-15109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15110-15119
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15120-15129
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 15130-15139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 15140-15149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15150-15159
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 15160-15169
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 15170-15179
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15180-15189
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 15190-15199
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 15200-15209
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 15210-15219
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15220-15229
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 15230-15239
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 15240-15249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 15250-15259
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 15260-15269
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 15270-15279
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 15280-15289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 15290-15299
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15300-15309
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 15310-15319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 15320-15329
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 15330-15339
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 15340-15349
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 15350-15359
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 15360-15369
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 15370-15379
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 15380-15389
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15390-15399
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 15400-15409
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 15410-15419
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 15420-15429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 15430-15439
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 15440-15449
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15450-15459
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15460-15469
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 15470-15479
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 15480-15489
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 15490-15499
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15500-15509
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 15510-15519
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 15520-15529
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15530-15539
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15540-15549
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 15550-15559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 15560-15569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15570-15579
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 15580-15589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15590-15599
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 15600-15609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 15610-15619
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 15620-15629
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15630-15639
		1, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 15640-15649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15650-15659
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 15660-15669
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 15670-15679
		3, 2, 1, 44, 43, 42, 41, 40, 39, 38, // 15680-15689
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 15690-15699
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 15700-15709
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 15710-15719
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 15720-15729
		1, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 15730-15739
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 15740-15749
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15750-15759
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15760-15769
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 15770-15779
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 15780-15789
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15790-15799
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 15800-15809
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15810-15819
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 15820-15829
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 15830-15839
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 15840-15849
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 15850-15859
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 15860-15869
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 15870-15879
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 15880-15889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15890-15899
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 15900-15909
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 15910-15919
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 15920-15929
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 15930-15939
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 15940-15949
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 15950-15959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15960-15969
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 15970-15979
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15980-15989
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 15990-15999
		1, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 16000-16009
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 16010-16019
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16020-16029
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 16030-16039
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 16040-16049
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 16050-16059
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 16060-16069
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 16070-16079
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 16080-16089
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16090-16099
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 16100-16109
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 16110-16119
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 16120-16129
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 16130-16139
		1, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 16140-16149
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 16150-16159
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 16160-16169
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16170-16179
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 16180-16189
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 16190-16199
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 16200-16209
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16210-16219
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 16220-16229
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 16230-16239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 16240-16249
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 16250-16259
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16260-16269
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 16270-16279
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 16280-16289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16290-16299
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 16300-16309
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 16310-16319
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16320-16329
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 16330-16339
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 16340-16349
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16350-16359
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 16360-16369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16370-16379
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 16380-16389
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 16390-16399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16400-16409
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 16410-16419
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16420-16429
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 16430-16439
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 16440-16449
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 16450-16459
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 16460-16469
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 16470-16479
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16480-16489
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 16490-16499
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 16500-16509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 16510-16519
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 16520-16529
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 16530-16539
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16540-16549
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 16550-16559
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16560-16569
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 16570-16579
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 16580-16589
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16590-16599
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 16600-16609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 16610-16619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16620-16629
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 16630-16639
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 16640-16649
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 16650-16659
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16660-16669
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 16670-16679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16680-16689
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 16690-16699
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 16700-16709
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 16710-16719
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 16720-16729
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16730-16739
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 16740-16749
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 16750-16759
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 16760-16769
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 16770-16779
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 16780-16789
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 16790-16799
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16800-16809
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16810-16819
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 16820-16829
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16830-16839
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 16840-16849
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 16850-16859
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16860-16869
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 16870-16879
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 16880-16889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16890-16899
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 16900-16909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 16910-16919
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 16920-16929
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16930-16939
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 16940-16949
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 16950-16959
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 16960-16969
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 16970-16979
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 16980-16989
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 16990-16999
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17000-17009
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17010-17019
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 17020-17029
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 17030-17039
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 17040-17049
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 17050-17059
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17060-17069
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 17070-17079
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17080-17089
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 17090-17099
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 17100-17109
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 17110-17119
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 17120-17129
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 17130-17139
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 17140-17149
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 17150-17159
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 17160-17169
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17170-17179
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 17180-17189
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17190-17199
		3, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 17200-17209
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 17210-17219
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17220-17229
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 17230-17239
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17240-17249
		7, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 17250-17259
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 17260-17269
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 17270-17279
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17280-17289
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 17290-17299
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17300-17309
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 17310-17319
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 17320-17329
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 17330-17339
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17340-17349
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 17350-17359
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17360-17369
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 17370-17379
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 17380-17389
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 17390-17399
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17400-17409
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 17410-17419
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17420-17429
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17430-17439
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 17440-17449
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17450-17459
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 17460-17469
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 17470-17479
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 17480-17489
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 17490-17499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 17500-17509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 17510-17519
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 17520-17529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 17530-17539
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17540-17549
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 17550-17559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 17560-17569
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 17570-17579
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17580-17589
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 17590-17599
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 17600-17609
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17610-17619
		3, 2, 1, 4, 3, 2, 1, 30, 29, 28, // 17620-17629
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 17630-17639
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17640-17649
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 17650-17659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 17660-17669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17670-17679
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 17680-17689
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17690-17699
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 17700-17709
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 17710-17719
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 17720-17729
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 17730-17739
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 17740-17749
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17750-17759
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 17760-17769
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17770-17779
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 17780-17789
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17790-17799
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 17800-17809
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17810-17819
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 17820-17829
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 17830-17839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17840-17849
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17850-17859
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 17860-17869
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17870-17879
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17880-17889
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 17890-17899
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 17900-17909
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17910-17919
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 17920-17929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 17930-17939
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 17940-17949
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 17950-17959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 17960-17969
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 17970-17979
		1, 6, 5, 4, 3, 2, 1, 2, 1, 24, // 17980-17989
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 17990-17999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18000-18009
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 18010-18019
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 18020-18029
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18030-18039
		1, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 18040-18049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 18050-18059
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 18060-18069
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 18070-18079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 18080-18089
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 18090-18099
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 18100-18109
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 18110-18119
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 18120-18129
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 18130-18139
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 18140-18149
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 18150-18159
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 18160-18169
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18170-18179
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18180-18189
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 18190-18199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18200-18209
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 18210-18219
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 18220-18229
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 18230-18239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18240-18249
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 18250-18259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 18260-18269
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 18270-18279
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 18280-18289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18290-18299
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 18300-18309
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 18310-18319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 18320-18329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18330-18339
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18340-18349
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 18350-18359
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 18360-18369
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 18370-18379
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 18380-18389
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 18390-18399
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18400-18409
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 18410-18419
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 18420-18429
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 18430-18439
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 18440-18449
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 18450-18459
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 18460-18469
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18470-18479
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18480-18489
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 18490-18499
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 18500-18509
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 18510-18519
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 18520-18529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 18530-18539
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18540-18549
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 18550-18559
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 18560-18569
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18570-18579
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 18580-18589
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 18590-18599
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 18600-18609
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 18610-18619
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 18620-18629
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 18630-18639
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 18640-18649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18650-18659
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18660-18669
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 18670-18679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18680-18689
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18690-18699
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18700-18709
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 18710-18719
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18720-18729
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18730-18739
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 18740-18749
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 18750-18759
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18760-18769
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 18770-18779
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 18780-18789
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 18790-18799
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 18800-18809
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 18810-18819
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 18820-18829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 18830-18839
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 18840-18849
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 18850-18859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 18860-18869
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 18870-18879
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 18880-18889
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 18890-18899
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18900-18909
		1, 2, 1, 4, 3, 2, 1, 2, 1, 28, // 18910-18919
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 18920-18929
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 18930-18939
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 18940-18949
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 18950-18959
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 18960-18969
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 18970-18979
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 18980-18989
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 18990-18999
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 19000-19009
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 19010-19019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19020-19029
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 19030-19039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19040-19049
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 19050-19059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 19060-19069
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 19070-19079
		1, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 19080-19089
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 19090-19099
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 19100-19109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19110-19119
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 19120-19129
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 19130-19139
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 19140-19149
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 19150-19159
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 19160-19169
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19170-19179
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 19180-19189
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 19190-19199
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 19200-19209
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 19210-19219
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19220-19229
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 19230-19239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 19240-19249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 19250-19259
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 19260-19269
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 19270-19279
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 19280-19289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19290-19299
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 19300-19309
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 19310-19319
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 19320-19329
		3, 2, 1, 40, 39, 38, 37, 36, 35, 34, // 19330-19339
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 19340-19349
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 19350-19359
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 19360-19369
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 19370-19379
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 19380-19389
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 19390-19399
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 19400-19409
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 19410-19419
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 19420-19429
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 19430-19439
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 19440-19449
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 19450-19459
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 19460-19469
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 19470-19479
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 19480-19489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19490-19499
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 19500-19509
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 19510-19519
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19520-19529
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19530-19539
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 19540-19549
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 19550-19559
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19560-19569
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 19570-19579
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 19580-19589
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 19590-19599
		3, 2, 1, 6, 5, 4, 3, 2, 1, 52, // 19600-19609
		51, 50, 49, 48, 47, 46, 45, 44, 43, 42, // 19610-19619
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 19620-19629
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 19630-19639
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 19640-19649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19650-19659
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 19660-19669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19670-19679
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 19680-19689
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 19690-19699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 19700-19709
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 19710-19719
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 19720-19729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 19730-19739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19740-19749
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 19750-19759
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 19760-19769
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 19770-19779
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 19780-19789
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 19790-19799
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 19800-19809
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 19810-19819
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 19820-19829
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19830-19839
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 19840-19849
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 19850-19859
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 19860-19869
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 19870-19879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 19880-19889
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 19890-19899
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 19900-19909
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 19910-19919
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 19920-19929
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 19930-19939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 19940-19949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19950-19959
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 19960-19969
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 19970-19979
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 19980-19989
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 19990-19999
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20000-20009
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20010-20019
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 20020-20029
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 20030-20039
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 20040-20049
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20050-20059
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 20060-20069
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 20070-20079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 20080-20089
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20090-20099
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 20100-20109
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 20110-20119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 20120-20129
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20130-20139
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 20140-20149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20150-20159
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20160-20169
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 20170-20179
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 20180-20189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20190-20199
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 20200-20209
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 20210-20219
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20220-20229
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 20230-20239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 20240-20249
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20250-20259
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 20260-20269
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 20270-20279
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 20280-20289
		7, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 20290-20299
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 20300-20309
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20310-20319
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 20320-20329
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 20330-20339
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 20340-20349
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 20350-20359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 20360-20369
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 20370-20379
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 20380-20389
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 20390-20399
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 20400-20409
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 20410-20419
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20420-20429
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20430-20439
		1, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 20440-20449
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 20450-20459
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 20460-20469
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 20470-20479
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 20480-20489
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 20490-20499
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 20500-20509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20510-20519
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20520-20529
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 20530-20539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 20540-20549
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20550-20559
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 20560-20569
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 20570-20579
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20580-20589
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 20590-20599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20600-20609
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 20610-20619
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 20620-20629
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 20630-20639
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 20640-20649
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20650-20659
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 20660-20669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20670-20679
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20680-20689
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 20690-20699
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 20700-20709
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 20710-20719
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20720-20729
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20730-20739
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 20740-20749
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 20750-20759
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20760-20769
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 20770-20779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 20780-20789
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 20790-20799
		7, 6, 5, 4, 3, 2, 1, 2, 1, 40, // 20800-20809
		39, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 20810-20819
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 20820-20829
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 20830-20839
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 20840-20849
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 20850-20859
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 20860-20869
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 20870-20879
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 20880-20889
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 20890-20899
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 20900-20909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20910-20919
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 20920-20929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 20930-20939
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 20940-20949
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 20950-20959
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 20960-20969
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20970-20979
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 20980-20989
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 20990-20999
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21000-21009
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 21010-21019
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 21020-21029
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 21030-21039
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 21040-21049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 21050-21059
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 21060-21069
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 21070-21079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 21080-21089
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21090-21099
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 21100-21109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21110-21119
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 21120-21129
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 21130-21139
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 21140-21149
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 21150-21159
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 21160-21169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 21170-21179
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 21180-21189
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 21190-21199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21200-21209
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21210-21219
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 21220-21229
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 21230-21239
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 21240-21249
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 21250-21259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 21260-21269
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 21270-21279
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 21280-21289
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 21290-21299
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 21300-21309
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 21310-21319
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 21320-21329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21330-21339
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 21340-21349
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 21350-21359
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 21360-21369
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 21370-21379
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 21380-21389
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 21390-21399
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 21400-21409
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 21410-21419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 21420-21429
		3, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 21430-21439
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 21440-21449
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 21450-21459
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 21460-21469
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21470-21479
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 21480-21489
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 21490-21499
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 21500-21509
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 21510-21519
		1, 2, 1, 6, 5, 4, 3, 2, 1, 28, // 21520-21529
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 21530-21539
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 21540-21549
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 21550-21559
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 21560-21569
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 21570-21579
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 21580-21589
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 21590-21599
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21600-21609
		1, 2, 1, 4, 3, 2, 1, 30, 29, 28, // 21610-21619
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 21620-21629
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 21630-21639
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 21640-21649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21650-21659
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 21660-21669
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 21670-21679
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 21680-21689
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21690-21699
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 21700-21709
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 21710-21719
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 21720-21729
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 21730-21739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21740-21749
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 21750-21759
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 21760-21769
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 21770-21779
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 21780-21789
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 21790-21799
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 21800-21809
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 21810-21819
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 21820-21829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 21830-21839
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21840-21849
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 21850-21859
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 21860-21869
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21870-21879
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 21880-21889
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 21890-21899
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21900-21909
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 21910-21919
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 21920-21929
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 21930-21939
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 21940-21949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21950-21959
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 21960-21969
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 21970-21979
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 21980-21989
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 21990-21999
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 22000-22009
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 22010-22019
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 22020-22029
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 22030-22039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22040-22049
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22050-22059
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 22060-22069
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 22070-22079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22080-22089
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 22090-22099
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 22100-22109
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22110-22119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 22120-22129
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 22130-22139
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 22140-22149
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 22150-22159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22160-22169
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 22170-22179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 22180-22189
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 22190-22199
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 22200-22209
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 22210-22219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 22220-22229
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 22230-22239
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 22240-22249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 22250-22259
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22260-22269
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 22270-22279
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 22280-22289
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22290-22299
		3, 2, 1, 4, 3, 2, 1, 36, 35, 34, // 22300-22309
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 22310-22319
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 22320-22329
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22330-22339
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 22340-22349
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 22350-22359
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 22360-22369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22370-22379
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22380-22389
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 22390-22399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 22400-22409
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 22410-22419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22420-22429
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 22430-22439
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 22440-22449
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 22450-22459
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 22460-22469
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22470-22479
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 22480-22489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22490-22499
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22500-22509
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 22510-22519
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22520-22529
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22530-22539
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 22540-22549
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 22550-22559
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 22560-22569
		1, 2, 1, 40, 39, 38, 37, 36, 35, 34, // 22570-22579
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 22580-22589
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 22590-22599
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22600-22609
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 22610-22619
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 22620-22629
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 22630-22639
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 22640-22649
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 22650-22659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 22660-22669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 22670-22679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22680-22689
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 22690-22699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 22700-22709
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 22710-22719
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 22720-22729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 22730-22739
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22740-22749
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 22750-22759
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 22760-22769
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 22770-22779
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 22780-22789
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 22790-22799
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 22800-22809
		1, 6, 5, 4, 3, 2, 1, 36, 35, 34, // 22810-22819
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 22820-22829
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 22830-22839
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22840-22849
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 22850-22859
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22860-22869
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 22870-22879
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 22880-22889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22890-22899
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 22900-22909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22910-22919
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 22920-22929
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 22930-22939
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 22940-22949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 22950-22959
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 22960-22969
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 22970-22979
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 22980-22989
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 22990-22999
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 23000-23009
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 23010-23019
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 23020-23029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 23030-23039
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23040-23049
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 23050-23059
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 23060-23069
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23070-23079
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 23080-23089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 23090-23099
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23100-23109
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 23110-23119
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23120-23129
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23130-23139
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 23140-23149
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 23150-23159
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 23160-23169
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 23170-23179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 23180-23189
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 23190-23199
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 23200-23209
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23210-23219
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 23220-23229
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 23230-23239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23240-23249
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 23250-23259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 23260-23269
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 23270-23279
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23280-23289
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 23290-23299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23300-23309
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23310-23319
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 23320-23329
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 23330-23339
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23340-23349
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 23350-23359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 23360-23369
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 23370-23379
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 23380-23389
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 23390-23399
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23400-23409
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 23410-23419
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23420-23429
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23430-23439
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 23440-23449
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 23450-23459
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23460-23469
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 23470-23479
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23480-23489
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 23490-23499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 23500-23509
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 23510-23519
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23520-23529
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 23530-23539
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 23540-23549
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 23550-23559
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 23560-23569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23570-23579
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23580-23589
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 23590-23599
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 23600-23609
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23610-23619
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 23620-23629
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 23630-23639
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 23640-23649
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23650-23659
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 23660-23669
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 23670-23679
		7, 6, 5, 4, 3, 2, 1, 2, 1, 30, // 23680-23689
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 23690-23699
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 23700-23709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 23710-23719
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 23720-23729
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23730-23739
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 23740-23749
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 23750-23759
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 23760-23769
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 23770-23779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 23780-23789
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23790-23799
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23800-23809
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 23810-23819
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 23820-23829
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 23830-23839
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23840-23849
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 23850-23859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 23860-23869
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 23870-23879
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 23880-23889
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 23890-23899
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 23900-23909
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 23910-23919
		9, 8, 7, 6, 5, 4, 3, 2, 1, 28, // 23920-23929
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 23930-23939
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 23940-23949
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 23950-23959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 23960-23969
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 23970-23979
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 23980-23989
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 23990-23999
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 24000-24009
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 24010-24019
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 24020-24029
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24030-24039
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 24040-24049
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24050-24059
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24060-24069
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 24070-24079
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 24080-24089
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 24090-24099
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 24100-24109
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 24110-24119
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24120-24129
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 24130-24139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24140-24149
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 24150-24159
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 24160-24169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 24170-24179
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 24180-24189
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 24190-24199
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 24200-24209
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24210-24219
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 24220-24229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 24230-24239
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 24240-24249
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 24250-24259
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 24260-24269
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24270-24279
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 24280-24289
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 24290-24299
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 24300-24309
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 24310-24319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 24320-24329
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 24330-24339
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 24340-24349
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 24350-24359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24360-24369
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 24370-24379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24380-24389
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 24390-24399
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 24400-24409
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 24410-24419
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 24420-24429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 24430-24439
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 24440-24449
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 24450-24459
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 24460-24469
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 24470-24479
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 24480-24489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 24490-24499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 24500-24509
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 24510-24519
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 24520-24529
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 24530-24539
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 24540-24549
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 24550-24559
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24560-24569
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 24570-24579
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24580-24589
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 24590-24599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24600-24609
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24610-24619
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 24620-24629
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 24630-24639
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 24640-24649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 24650-24659
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24660-24669
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 24670-24679
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 24680-24689
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 24690-24699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 24700-24709
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 24710-24719
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24720-24729
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 24730-24739
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 24740-24749
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24750-24759
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 24760-24769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24770-24779
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24780-24789
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 24790-24799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 24800-24809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24810-24819
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 24820-24829
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 24830-24839
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 24840-24849
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 24850-24859
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 24860-24869
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 24870-24879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 24880-24889
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 24890-24899
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 24900-24909
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 24910-24919
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 24920-24929
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 24930-24939
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 24940-24949
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 24950-24959
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 24960-24969
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 24970-24979
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 24980-24989
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 24990-24999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25000-25009
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 25010-25019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25020-25029
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 25030-25039
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 25040-25049
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 25050-25059
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25060-25069
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 25070-25079
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 25080-25089
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 25090-25099
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25100-25109
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 25110-25119
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 25120-25129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 25130-25139
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 25140-25149
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 25150-25159
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 25160-25169
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25170-25179
		3, 2, 1, 6, 5, 4, 3, 2, 1, 30, // 25180-25189
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 25190-25199
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 25200-25209
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 25210-25219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 25220-25229
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 25230-25239
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 25240-25249
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 25250-25259
		1, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 25260-25269
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 25270-25279
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 25280-25289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25290-25299
		1, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 25300-25309
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25310-25319
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 25320-25329
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 25330-25339
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 25340-25349
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 25350-25359
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 25360-25369
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 25370-25379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25380-25389
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 25390-25399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 25400-25409
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25410-25419
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 25420-25429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 25430-25439
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 25440-25449
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 25450-25459
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 25460-25469
		1, 52, 51, 50, 49, 48, 47, 46, 45, 44, // 25470-25479
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 25480-25489
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 25490-25499
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 25500-25509
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25510-25519
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 25520-25529
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 25530-25539
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 25540-25549
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25550-25559
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 25560-25569
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 25570-25579
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 25580-25589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25590-25599
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 25600-25609
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25610-25619
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25620-25629
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 25630-25639
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 25640-25649
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 25650-25659
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 25660-25669
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 25670-25679
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25680-25689
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 25690-25699
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 25700-25709
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 25710-25719
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25720-25729
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 25730-25739
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 25740-25749
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 25750-25759
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 25760-25769
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 25770-25779
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25780-25789
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 25790-25799
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 25800-25809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 25810-25819
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 25820-25829
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25830-25839
		1, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 25840-25849
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 25850-25859
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 25860-25869
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 25870-25879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 25880-25889
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 25890-25899
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 25900-25909
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 25910-25919
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25920-25929
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 25930-25939
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 25940-25949
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 25950-25959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 25960-25969
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 25970-25979
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 25980-25989
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 25990-25999
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 26000-26009
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 26010-26019
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 26020-26029
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26030-26039
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26040-26049
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 26050-26059
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 26060-26069
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26070-26079
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 26080-26089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 26090-26099
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 26100-26109
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 26110-26119
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 26120-26129
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26130-26139
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26140-26149
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 26150-26159
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26160-26169
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 26170-26179
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 26180-26189
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26190-26199
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 26200-26209
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 26210-26219
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 26220-26229
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 26230-26239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 26240-26249
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26250-26259
		1, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 26260-26269
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 26270-26279
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26280-26289
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 26290-26299
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 26300-26309
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 26310-26319
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 26320-26329
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 26330-26339
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 26340-26349
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 26350-26359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26360-26369
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 26370-26379
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 26380-26389
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 26390-26399
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 26400-26409
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 26410-26419
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 26420-26429
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 26430-26439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 26440-26449
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 26450-26459
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 26460-26469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 26470-26479
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 26480-26489
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 26490-26499
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26500-26509
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 26510-26519
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 26520-26529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 26530-26539
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 26540-26549
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 26550-26559
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26560-26569
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 26570-26579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26580-26589
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 26590-26599
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 26600-26609
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 26610-26619
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 26620-26629
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 26630-26639
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 26640-26649
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 26650-26659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 26660-26669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26670-26679
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 26680-26689
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 26690-26699
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26700-26709
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 26710-26719
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 26720-26729
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 26730-26739
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 26740-26749
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 26750-26759
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 26760-26769
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 26770-26779
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 26780-26789
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26790-26799
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26800-26809
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 26810-26819
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 26820-26829
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 26830-26839
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 26840-26849
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26850-26859
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 26860-26869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 26870-26879
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26880-26889
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 26890-26899
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 26900-26909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26910-26919
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 26920-26929
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 26930-26939
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 26940-26949
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 26950-26959
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 26960-26969
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 26970-26979
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 26980-26989
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 26990-26999
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27000-27009
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 27010-27019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27020-27029
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27030-27039
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 27040-27049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 27050-27059
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 27060-27069
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 27070-27079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27080-27089
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27090-27099
		3, 2, 1, 4, 3, 2, 1, 2, 1, 18, // 27100-27109
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 27110-27119
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 27120-27129
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27130-27139
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 27140-27149
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 27150-27159
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 27160-27169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 27170-27179
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27180-27189
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 27190-27199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27200-27209
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 27210-27219
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 27220-27229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 27230-27239
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27240-27249
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 27250-27259
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27260-27269
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 27270-27279
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 27280-27289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 27290-27299
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 27300-27309
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 27310-27319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 27320-27329
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 27330-27339
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 27340-27349
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27350-27359
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 27360-27369
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 27370-27379
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 27380-27389
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 27390-27399
		7, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 27400-27409
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 27410-27419
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 27420-27429
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 27430-27439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 27440-27449
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 27450-27459
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 27460-27469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 27470-27479
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 27480-27489
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 27490-27499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 27500-27509
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 27510-27519
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 27520-27529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 27530-27539
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27540-27549
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 27550-27559
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 27560-27569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27570-27579
		1, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 27580-27589
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 27590-27599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27600-27609
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 27610-27619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27620-27629
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 27630-27639
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 27640-27649
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 27650-27659
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27660-27669
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 27670-27679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 27680-27689
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 27690-27699
		1, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 27700-27709
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 27710-27719
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27720-27729
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 27730-27739
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 27740-27749
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27750-27759
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 27760-27769
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 27770-27779
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27780-27789
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 27790-27799
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 27800-27809
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 27810-27819
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 27820-27829
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 27830-27839
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 27840-27849
		1, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 27850-27859
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 27860-27869
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27870-27879
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 27880-27889
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 27890-27899
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 27900-27909
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 27910-27919
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 27920-27929
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 27930-27939
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 27940-27949
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 27950-27959
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 27960-27969
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 27970-27979
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 27980-27989
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 27990-27999
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 28000-28009
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 28010-28019
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 28020-28029
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 28030-28039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28040-28049
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 28050-28059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 28060-28069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28070-28079
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 28080-28089
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 28090-28099
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 28100-28109
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 28110-28119
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 28120-28129
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 28130-28139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28140-28149
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 28150-28159
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 28160-28169
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28170-28179
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 28180-28189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28190-28199
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28200-28209
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 28210-28219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 48, // 28220-28229
		47, 46, 45, 44, 43, 42, 41, 40, 39, 38, // 28230-28239
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 28240-28249
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 28250-28259
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 28260-28269
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 28270-28279
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 28280-28289
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 28290-28299
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 28300-28309
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 28310-28319
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 28320-28329
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 28330-28339
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 28340-28349
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 28350-28359
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 28360-28369
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 28370-28379
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 28380-28389
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 28390-28399
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 28400-28409
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 28410-28419
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 28420-28429
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 28430-28439
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 28440-28449
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 28450-28459
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 28460-28469
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 28470-28479
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 28480-28489
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 28490-28499
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 28500-28509
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 28510-28519
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 28520-28529
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 28530-28539
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 28540-28549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 28550-28559
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28560-28569
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 28570-28579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28580-28589
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 28590-28599
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 28600-28609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 28610-28619
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 28620-28629
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 28630-28639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 28640-28649
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 28650-28659
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 28660-28669
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 28670-28679
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 28680-28689
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 28690-28699
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 28700-28709
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 28710-28719
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 28720-28729
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 28730-28739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28740-28749
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 28750-28759
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28760-28769
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 28770-28779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 28780-28789
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 28790-28799
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 28800-28809
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 28810-28819
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 28820-28829
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 28830-28839
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 28840-28849
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 28850-28859
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 28860-28869
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 28870-28879
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 28880-28889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28890-28899
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 28900-28909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28910-28919
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 28920-28929
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 28930-28939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 28940-28949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 28950-28959
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 28960-28969
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 28970-28979
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 28980-28989
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 28990-28999
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 29000-29009
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 29010-29019
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 29020-29029
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 29030-29039
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 29040-29049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 29050-29059
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 29060-29069
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 29070-29079
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 29080-29089
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29090-29099
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 29100-29109
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29110-29119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 29120-29129
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 29130-29139
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 29140-29149
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 29150-29159
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 29160-29169
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 29170-29179
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29180-29189
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29190-29199
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 29200-29209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29210-29219
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29220-29229
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29230-29239
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 29240-29249
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 29250-29259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 29260-29269
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 29270-29279
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 29280-29289
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 29290-29299
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 29300-29309
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 29310-29319
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 29320-29329
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 29330-29339
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 29340-29349
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29350-29359
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 29360-29369
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29370-29379
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 29380-29389
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 29390-29399
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29400-29409
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29410-29419
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 29420-29429
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 29430-29439
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 29440-29449
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 29450-29459
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29460-29469
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 29470-29479
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 29480-29489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29490-29499
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 29500-29509
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 29510-29519
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 29520-29529
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 29530-29539
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 29540-29549
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 29550-29559
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 29560-29569
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 29570-29579
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 29580-29589
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 29590-29599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29600-29609
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 29610-29619
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 29620-29629
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 29630-29639
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 29640-29649
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29650-29659
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 29660-29669
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29670-29679
		3, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 29680-29689
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 29690-29699
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 29700-29709
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 29710-29719
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 29720-29729
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29730-29739
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29740-29749
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 29750-29759
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 29760-29769
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 29770-29779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 29780-29789
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29790-29799
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 29800-29809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 29810-29819
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29820-29829
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 29830-29839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 29840-29849
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29850-29859
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 29860-29869
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 29870-29879
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 29880-29889
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 29890-29899
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 29900-29909
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 29910-29919
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 29920-29929
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 29930-29939
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 29940-29949
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 29950-29959
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 29960-29969
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 29970-29979
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 29980-29989
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 29990-29999
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30000-30009
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 30010-30019
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 30020-30029
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 30030-30039
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 30040-30049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 30050-30059
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30060-30069
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 30070-30079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 30080-30089
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 30090-30099
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 30100-30109
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 30110-30119
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30120-30129
		3, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 30130-30139
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 30140-30149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30150-30159
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 30160-30169
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30170-30179
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 30180-30189
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 30190-30199
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 30200-30209
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30210-30219
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 30220-30229
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30230-30239
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30240-30249
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 30250-30259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 30260-30269
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 30270-30279
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30280-30289
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 30290-30299
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 30300-30309
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 30310-30319
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 30320-30329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30330-30339
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 30340-30349
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 30350-30359
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 30360-30369
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 30370-30379
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 30380-30389
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30390-30399
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 30400-30409
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 30410-30419
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 30420-30429
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 30430-30439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 30440-30449
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 30450-30459
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 30460-30469
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 30470-30479
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30480-30489
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 30490-30499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 30500-30509
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 30510-30519
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 30520-30529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 30530-30539
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30540-30549
		3, 2, 1, 4, 3, 2, 1, 2, 1, 18, // 30550-30559
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 30560-30569
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 30570-30579
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30580-30589
		3, 2, 1, 38, 37, 36, 35, 34, 33, 32, // 30590-30599
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 30600-30609
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 30610-30619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30620-30629
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 30630-30639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 30640-30649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30650-30659
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30660-30669
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 30670-30679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 30680-30689
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 30690-30699
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 30700-30709
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 30710-30719
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 30720-30729
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 30730-30739
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 30740-30749
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 30750-30759
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 30760-30769
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 30770-30779
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 30780-30789
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30790-30799
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 30800-30809
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 30810-30819
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 30820-30829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 30830-30839
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30840-30849
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 30850-30859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 30860-30869
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30870-30879
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 30880-30889
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 30890-30899
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30900-30909
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 30910-30919
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30920-30929
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 30930-30939
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 30940-30949
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 30950-30959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 30960-30969
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 30970-30979
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 30980-30989
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 30990-30999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 31000-31009
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 31010-31019
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 31020-31029
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 31030-31039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31040-31049
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 31050-31059
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 31060-31069
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 31070-31079
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31080-31089
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 31090-31099
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 31100-31109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31110-31119
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 31120-31129
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 31130-31139
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 31140-31149
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 31150-31159
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31160-31169
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 31170-31179
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 31180-31189
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 31190-31199
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 31200-31209
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 31210-31219
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 31220-31229
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 31230-31239
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 31240-31249
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 31250-31259
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 31260-31269
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 31270-31279
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 31280-31289
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31290-31299
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 31300-31309
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 31310-31319
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 31320-31329
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 31330-31339
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31340-31349
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 31350-31359
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 31360-31369
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 31370-31379
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 31380-31389
		1, 2, 1, 4, 3, 2, 1, 72, 71, 70, // 31390-31399
		69, 68, 67, 66, 65, 64, 63, 62, 61, 60, // 31400-31409
		59, 58, 57, 56, 55, 54, 53, 52, 51, 50, // 31410-31419
		49, 48, 47, 46, 45, 44, 43, 42, 41, 40, // 31420-31429
		39, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 31430-31439
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 31440-31449
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 31450-31459
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 31460-31469
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 31470-31479
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 31480-31489
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 31490-31499
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31500-31509
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 31510-31519
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31520-31529
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31530-31539
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 31540-31549
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31550-31559
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 31560-31569
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 31570-31579
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 31580-31589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31590-31599
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 31600-31609
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31610-31619
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 31620-31629
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 31630-31639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 31640-31649
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 31650-31659
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 31660-31669
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31670-31679
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 31680-31689
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 31690-31699
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 31700-31709
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31710-31719
		1, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 31720-31729
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31730-31739
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31740-31749
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 31750-31759
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 31760-31769
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 31770-31779
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 31780-31789
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 31790-31799
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31800-31809
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 31810-31819
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 31820-31829
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31830-31839
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 31840-31849
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 31850-31859
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 31860-31869
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 31870-31879
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 31880-31889
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31890-31899
		7, 6, 5, 4, 3, 2, 1, 50, 49, 48, // 31900-31909
		47, 46, 45, 44, 43, 42, 41, 40, 39, 38, // 31910-31919
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 31920-31929
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 31930-31939
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 31940-31949
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 31950-31959
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 31960-31969
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 31970-31979
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 31980-31989
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 31990-31999
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 32000-32009
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 32010-32019
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 32020-32029
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 32030-32039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32040-32049
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 32050-32059
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 32060-32069
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 32070-32079
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 32080-32089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 32090-32099
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 32100-32109
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 32110-32119
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 32120-32129
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32130-32139
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 32140-32149
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 32150-32159
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32160-32169
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 32170-32179
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 32180-32189
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32190-32199
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 32200-32209
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 32210-32219
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32220-32229
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 32230-32239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32240-32249
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 32250-32259
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 32260-32269
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 32270-32279
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 32280-32289
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 32290-32299
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 32300-32309
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32310-32319
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 32320-32329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32330-32339
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32340-32349
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 32350-32359
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 32360-32369
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 32370-32379
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 32380-32389
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32390-32399
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32400-32409
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 32410-32419
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 32420-32429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32430-32439
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 32440-32449
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 32450-32459
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 32460-32469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 32470-32479
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32480-32489
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 32490-32499
		3, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 32500-32509
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 32510-32519
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32520-32529
		1, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 32530-32539
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 32540-32549
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32550-32559
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 32560-32569
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 32570-32579
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 32580-32589
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32590-32599
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 32600-32609
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32610-32619
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32620-32629
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 32630-32639
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 32640-32649
		3, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 32650-32659
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 32660-32669
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 32670-32679
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 32680-32689
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 32690-32699
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 32700-32709
		3, 2, 1, 4, 3, 2, 1, 2, 1, 30, // 32710-32719
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 32720-32729
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 32730-32739
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 32740-32749
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 32750-32759
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32760-32769
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 32770-32779
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 32780-32789
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 32790-32799
		1, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 32800-32809
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 32810-32819
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 32820-32829
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 32830-32839
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 32840-32849
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 32850-32859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 32860-32869
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 32870-32879
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 32880-32889
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 32890-32899
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 32900-32909
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 32910-32919
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32920-32929
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 32930-32939
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 32940-32949
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 32950-32959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 32960-32969
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 32970-32979
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 32980-32989
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 32990-32999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33000-33009
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 33010-33019
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 33020-33029
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 33030-33039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 33040-33049
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 33050-33059
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33060-33069
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 33070-33079
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 33080-33089
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 33090-33099
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 33100-33109
		3, 2, 1, 6, 5, 4, 3, 2, 1, 30, // 33110-33119
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 33120-33129
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 33130-33139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 33140-33149
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33150-33159
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 33160-33169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 33170-33179
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33180-33189
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 33190-33199
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 33200-33209
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33210-33219
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 33220-33229
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 33230-33239
		7, 6, 5, 4, 3, 2, 1, 40, 39, 38, // 33240-33249
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 33250-33259
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 33260-33269
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 33270-33279
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 33280-33289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33290-33299
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33300-33309
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 33310-33319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 33320-33329
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33330-33339
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 33340-33349
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 33350-33359
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 33360-33369
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 33370-33379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33380-33389
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33390-33399
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 33400-33409
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 33410-33419
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 33420-33429
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 33430-33439
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 33440-33449
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 33450-33459
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 33460-33469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 33470-33479
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 33480-33489
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 33490-33499
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 33500-33509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33510-33519
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 33520-33529
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 33530-33539
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 33540-33549
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33550-33559
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 33560-33569
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 33570-33579
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 33580-33589
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 33590-33599
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33600-33609
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 33610-33619
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 33620-33629
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 33630-33639
		1, 6, 5, 4, 3, 2, 1, 32, 31, 30, // 33640-33649
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 33650-33659
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 33660-33669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 33670-33679
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 33680-33689
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33690-33699
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 33700-33709
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 33710-33719
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 33720-33729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 33730-33739
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 33740-33749
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 33750-33759
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 33760-33769
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 33770-33779
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33780-33789
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 33790-33799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 33800-33809
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 33810-33819
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 33820-33829
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 33830-33839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33840-33849
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 33850-33859
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 33860-33869
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 33870-33879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 33880-33889
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 33890-33899
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33900-33909
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 33910-33919
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 33920-33929
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 33930-33939
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 33940-33949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 33950-33959
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 33960-33969
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 33970-33979
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 33980-33989
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 33990-33999
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 34000-34009
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 34010-34019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34020-34029
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 34030-34039
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 34040-34049
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 34050-34059
		1, 62, 61, 60, 59, 58, 57, 56, 55, 54, // 34060-34069
		53, 52, 51, 50, 49, 48, 47, 46, 45, 44, // 34070-34079
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 34080-34089
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 34090-34099
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 34100-34109
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34110-34119
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 34120-34129
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34130-34139
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 34140-34149
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 34150-34159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34160-34169
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34170-34179
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 34180-34189
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 34190-34199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34200-34209
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 34210-34219
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34220-34229
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 34230-34239
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34240-34249
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 34250-34259
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 34260-34269
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 34270-34279
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 34280-34289
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 34290-34299
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 34300-34309
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 34310-34319
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 34320-34329
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 34330-34339
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34340-34349
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34350-34359
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 34360-34369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34370-34379
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 34380-34389
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34390-34399
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 34400-34409
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34410-34419
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 34420-34429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 34430-34439
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 34440-34449
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 34450-34459
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 34460-34469
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34470-34479
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 34480-34489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 34490-34499
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34500-34509
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 34510-34519
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 34520-34529
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 34530-34539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 34, // 34540-34549
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 34550-34559
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 34560-34569
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34570-34579
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 34580-34589
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34590-34599
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 34600-34609
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 34610-34619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34620-34629
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 34630-34639
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 34640-34649
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 34650-34659
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 34660-34669
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 34670-34679
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 34680-34689
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 34690-34699
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 34700-34709
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34710-34719
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 34720-34729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 34730-34739
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 34740-34749
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 34750-34759
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 34760-34769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34770-34779
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 34780-34789
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 34790-34799
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 34800-34809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 34810-34819
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 34820-34829
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34830-34839
		1, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 34840-34849
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 34850-34859
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34860-34869
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 34870-34879
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 34880-34889
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 34890-34899
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 34900-34909
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 34910-34919
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 34920-34929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 34930-34939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 34940-34949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34950-34959
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 34960-34969
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 34970-34979
		1, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 34980-34989
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 34990-34999
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 35000-35009
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 35010-35019
		3, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 35020-35029
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35030-35039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35040-35049
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 35050-35059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 35060-35069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35070-35079
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 35080-35089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 35090-35099
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 35100-35109
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 35110-35119
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 35120-35129
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35130-35139
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 35140-35149
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 35150-35159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35160-35169
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 35170-35179
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35180-35189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35190-35199
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35200-35209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35210-35219
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 35220-35229
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35230-35239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35240-35249
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 35250-35259
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 35260-35269
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 35270-35279
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35280-35289
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35290-35299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35300-35309
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 35310-35319
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 35320-35329
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 35330-35339
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 35340-35349
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 35350-35359
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 35360-35369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35370-35379
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 35380-35389
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 35390-35399
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 35400-35409
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 35410-35419
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 35420-35429
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 35430-35439
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 35440-35449
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35450-35459
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 35460-35469
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35470-35479
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35480-35489
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 35490-35499
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 35500-35509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35510-35519
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 35520-35529
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 35530-35539
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 35540-35549
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 35550-35559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 35560-35569
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 35570-35579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35580-35589
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 35590-35599
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 35600-35609
		7, 6, 5, 4, 3, 2, 1, 54, 53, 52, // 35610-35619
		51, 50, 49, 48, 47, 46, 45, 44, 43, 42, // 35620-35629
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 35630-35639
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 35640-35649
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35650-35659
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35660-35669
		1, 6, 5, 4, 3, 2, 1, 52, 51, 50, // 35670-35679
		49, 48, 47, 46, 45, 44, 43, 42, 41, 40, // 35680-35689
		39, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 35690-35699
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 35700-35709
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 35710-35719
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 35720-35729
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 35730-35739
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 35740-35749
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 35750-35759
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35760-35769
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 35770-35779
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 35780-35789
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 35790-35799
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 35800-35809
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 35810-35819
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35820-35829
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 35830-35839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35840-35849
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 35850-35859
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 35860-35869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 35870-35879
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 35880-35889
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 35890-35899
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35900-35909
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 35910-35919
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 35920-35929
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 35930-35939
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 35940-35949
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 35950-35959
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 35960-35969
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 35970-35979
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 35980-35989
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 35990-35999
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 36000-36009
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 36010-36019
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 36020-36029
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 36030-36039
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 36040-36049
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36050-36059
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 36060-36069
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 36070-36079
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 36080-36089
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 36090-36099
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 36100-36109
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 36110-36119
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36120-36129
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 36130-36139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36140-36149
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36150-36159
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 36160-36169
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 36170-36179
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 36180-36189
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 36190-36199
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 36200-36209
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 36210-36219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 36220-36229
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36230-36239
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36240-36249
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36250-36259
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 36260-36269
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 36270-36279
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36280-36289
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 36290-36299
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 36300-36309
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 36310-36319
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 36320-36329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36330-36339
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 36340-36349
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 36350-36359
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36360-36369
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 36370-36379
		3, 2, 1, 6, 5, 4, 3, 2, 1, 44, // 36380-36389
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 36390-36399
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 36400-36409
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 36410-36419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36420-36429
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 36430-36439
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36440-36449
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 36450-36459
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 36460-36469
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 36470-36479
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36480-36489
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 36490-36499
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 36500-36509
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36510-36519
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 36520-36529
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36530-36539
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36540-36549
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 36550-36559
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 36560-36569
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36570-36579
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 36580-36589
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 36590-36599
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 36600-36609
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 36610-36619
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 36620-36629
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 36630-36639
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 36640-36649
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 36650-36659
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36660-36669
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 36670-36679
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 36680-36689
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 36690-36699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 36700-36709
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 36710-36719
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 36720-36729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 36730-36739
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 36740-36749
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36750-36759
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 36760-36769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 36770-36779
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 36780-36789
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 36790-36799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 36800-36809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36810-36819
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36820-36829
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 36830-36839
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 36840-36849
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 36850-36859
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 36860-36869
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 36870-36879
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 36880-36889
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 36890-36899
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36900-36909
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 36910-36919
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 36920-36929
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36930-36939
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 36940-36949
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 36950-36959
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 36960-36969
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 36970-36979
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 36980-36989
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 36990-36999
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 37000-37009
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 37010-37019
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 37020-37029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 37030-37039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 37040-37049
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 37050-37059
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 37060-37069
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37070-37079
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 37080-37089
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 37090-37099
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37100-37109
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 37110-37119
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 37120-37129
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 37130-37139
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 37140-37149
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 37150-37159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37160-37169
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37170-37179
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 37180-37189
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 37190-37199
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37200-37209
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 37210-37219
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 37220-37229
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 37230-37239
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 37240-37249
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 37250-37259
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 37260-37269
		3, 2, 1, 4, 3, 2, 1, 30, 29, 28, // 37270-37279
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 37280-37289
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37290-37299
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 37300-37309
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 37310-37319
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37320-37329
		7, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 37330-37339
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37340-37349
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 37350-37359
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 37360-37369
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 37370-37379
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37380-37389
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 37390-37399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 37400-37409
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 37410-37419
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 37420-37429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37430-37439
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 37440-37449
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 37450-37459
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 37460-37469
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 37470-37479
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 37480-37489
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 37490-37499
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 37500-37509
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 37510-37519
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 37520-37529
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 37530-37539
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 37540-37549
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37550-37559
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 37560-37569
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 37570-37579
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 37580-37589
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37590-37599
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 37600-37609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 37610-37619
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 37620-37629
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 37630-37639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 37640-37649
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 37650-37659
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 37660-37669
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 37670-37679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37680-37689
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 37690-37699
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37700-37709
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 37710-37719
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 37720-37729
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37730-37739
		7, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 37740-37749
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 37750-37759
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 37760-37769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37770-37779
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 37780-37789
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 37790-37799
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37800-37809
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 37810-37819
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37820-37829
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37830-37839
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 37840-37849
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 37850-37859
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37860-37869
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 37870-37879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 37880-37889
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 37890-37899
		7, 6, 5, 4, 3, 2, 1, 44, 43, 42, // 37900-37909
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 37910-37919
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 37920-37929
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 37930-37939
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 37940-37949
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 37950-37959
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 37960-37969
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 37970-37979
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 37980-37989
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 37990-37999
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38000-38009
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 38010-38019
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 38020-38029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 38030-38039
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 38040-38049
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 38050-38059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 38060-38069
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38070-38079
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 38080-38089
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 38090-38099
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38100-38109
		3, 2, 1, 6, 5, 4, 3, 2, 1, 30, // 38110-38119
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 38120-38129
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 38130-38139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 38140-38149
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 38150-38159
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 38160-38169
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 38170-38179
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 38180-38189
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 38190-38199
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 38200-38209
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 38210-38219
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38220-38229
		1, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 38230-38239
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 38240-38249
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38250-38259
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38260-38269
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 38270-38279
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 38280-38289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 38290-38299
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 38300-38309
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 38310-38319
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 38320-38329
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 38330-38339
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38340-38349
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 38350-38359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38360-38369
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 38370-38379
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38380-38389
		3, 2, 1, 38, 37, 36, 35, 34, 33, 32, // 38390-38399
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 38400-38409
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 38410-38419
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38420-38429
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 38430-38439
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 38440-38449
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 38450-38459
		1, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 38460-38469
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 38470-38479
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 38480-38489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38490-38499
		1, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 38500-38509
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 38510-38519
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 38520-38529
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38530-38539
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 38540-38549
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 38550-38559
		1, 6, 5, 4, 3, 2, 1, 2, 1, 24, // 38560-38569
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 38570-38579
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38580-38589
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 38590-38599
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 38600-38609
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 38610-38619
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 38620-38629
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 38630-38639
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38640-38649
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 38650-38659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 38660-38669
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 38670-38679
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38680-38689
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 38690-38699
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 38700-38709
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 38710-38719
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 38720-38729
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 38730-38739
		7, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 38740-38749
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 38750-38759
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 38760-38769
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38770-38779
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 38780-38789
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38790-38799
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 38800-38809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38810-38819
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38820-38829
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 38830-38839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38840-38849
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38850-38859
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 38860-38869
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 38870-38879
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38880-38889
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38890-38899
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 38900-38909
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 38910-38919
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 38920-38929
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 38930-38939
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38940-38949
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 38950-38959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 38960-38969
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 38970-38979
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 38980-38989
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 38990-38999
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 39000-39009
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 39010-39019
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 39020-39029
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39030-39039
		1, 2, 1, 4, 3, 2, 1, 32, 31, 30, // 39040-39049
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 39050-39059
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 39060-39069
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 39070-39079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 39080-39089
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 39090-39099
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 39100-39109
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 39110-39119
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 39120-39129
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 39130-39139
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 39140-39149
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 39150-39159
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 39160-39169
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39170-39179
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39180-39189
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 39190-39199
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 39200-39209
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 39210-39219
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 39220-39229
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 39230-39239
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39240-39249
		1, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 39250-39259
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 39260-39269
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 39270-39279
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 39280-39289
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 39290-39299
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 39300-39309
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 39310-39319
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 39320-39329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39330-39339
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 39340-39349
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 39350-39359
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 39360-39369
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 39370-39379
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 39380-39389
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 39390-39399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 39400-39409
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 39410-39419
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 39420-39429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 39430-39439
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 39440-39449
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39450-39459
		1, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 39460-39469
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 39470-39479
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 39480-39489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 39490-39499
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 39500-39509
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39510-39519
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 39520-39529
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39530-39539
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39540-39549
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 39550-39559
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 39560-39569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39570-39579
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 39580-39589
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 39590-39599
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 39600-39609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 39610-39619
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 39620-39629
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 39630-39639
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 39640-39649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 39650-39659
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 39660-39669
		1, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 39670-39679
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 39680-39689
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 39690-39699
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 39700-39709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 39710-39719
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 39720-39729
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 39730-39739
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 39740-39749
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39750-39759
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 39760-39769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 39770-39779
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39780-39789
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 39790-39799
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 39800-39809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39810-39819
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 39820-39829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 39830-39839
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 39840-39849
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 39850-39859
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 39860-39869
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 39870-39879
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 39880-39889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39890-39899
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 39900-39909
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 39910-39919
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 39920-39929
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 39930-39939
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 39940-39949
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 39950-39959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 39960-39969
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 39970-39979
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 39980-39989
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 39990-39999
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 40000-40009
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 40010-40019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40020-40029
		1, 6, 5, 4, 3, 2, 1, 2, 1, 24, // 40030-40039
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 40040-40049
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40050-40059
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 40060-40069
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 40070-40079
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 40080-40089
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 40090-40099
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40100-40109
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40110-40119
		3, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 40120-40129
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 40130-40139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40140-40149
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 40150-40159
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 40160-40169
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 40170-40179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 40180-40189
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 40190-40199
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40200-40209
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 40210-40219
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40220-40229
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 40230-40239
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40240-40249
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 40250-40259
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 40260-40269
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 40270-40279
		3, 2, 1, 6, 5, 4, 3, 2, 1, 54, // 40280-40289
		53, 52, 51, 50, 49, 48, 47, 46, 45, 44, // 40290-40299
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 40300-40309
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 40310-40319
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 40320-40329
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40330-40339
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 40340-40349
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 40350-40359
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 40360-40369
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 40370-40379
		7, 6, 5, 4, 3, 2, 1, 36, 35, 34, // 40380-40389
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 40390-40399
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 40400-40409
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40410-40419
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 40420-40429
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 40430-40439
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 40440-40449
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 40450-40459
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40460-40469
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40470-40479
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 40480-40489
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 40490-40499
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 40500-40509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 40510-40519
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 40520-40529
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40530-40539
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 40540-40549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 40550-40559
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 40560-40569
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 40570-40579
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 40580-40589
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 40590-40599
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 40600-40609
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 40610-40619
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 40620-40629
		7, 6, 5, 4, 3, 2, 1, 2, 1, 54, // 40630-40639
		53, 52, 51, 50, 49, 48, 47, 46, 45, 44, // 40640-40649
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 40650-40659
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 40660-40669
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 40670-40679
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40680-40689
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 40690-40699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 40700-40709
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 40710-40719
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 40720-40729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 40730-40739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40740-40749
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 40750-40759
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 40760-40769
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 40770-40779
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 40780-40789
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40790-40799
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40800-40809
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 40810-40819
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 40820-40829
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40830-40839
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 40840-40849
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 40850-40859
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 40860-40869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 40870-40879
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 40880-40889
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 40890-40899
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 40900-40909
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 40910-40919
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 40920-40929
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 40930-40939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 40940-40949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 40950-40959
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40960-40969
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 40970-40979
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 40980-40989
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 40990-40999
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41000-41009
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 41010-41019
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 41020-41029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 41030-41039
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 41040-41049
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 41050-41059
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 41060-41069
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 41070-41079
		1, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 41080-41089
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 41090-41099
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 41100-41109
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 41110-41119
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41120-41129
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41130-41139
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 41140-41149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41150-41159
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 41160-41169
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 41170-41179
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 41180-41189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41190-41199
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 41200-41209
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 41210-41219
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 41220-41229
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 41230-41239
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 41240-41249
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 41250-41259
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 41260-41269
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41270-41279
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 41280-41289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 34, // 41290-41299
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 41300-41309
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 41310-41319
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 41320-41329
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 41330-41339
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41340-41349
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 41350-41359
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 41360-41369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41370-41379
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 41380-41389
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 41390-41399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41400-41409
		1, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 41410-41419
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 41420-41429
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 41430-41439
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 41440-41449
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 41450-41459
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 41460-41469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 41470-41479
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41480-41489
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 41490-41499
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 41500-41509
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 41510-41519
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 41520-41529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 41530-41539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 30, // 41540-41549
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 41550-41559
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 41560-41569
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 41570-41579
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 41580-41589
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 41590-41599
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 41600-41609
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 41610-41619
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 41620-41629
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41630-41639
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 41640-41649
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 41650-41659
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 41660-41669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41670-41679
		1, 6, 5, 4, 3, 2, 1, 32, 31, 30, // 41680-41689
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 41690-41699
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 41700-41709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 41710-41719
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 41720-41729
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 41730-41739
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 41740-41749
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 41750-41759
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41760-41769
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 41770-41779
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 41780-41789
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41790-41799
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 41800-41809
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 41810-41819
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 41820-41829
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 41830-41839
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 41840-41849
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 41850-41859
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 41860-41869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 41870-41879
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 41880-41889
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 41890-41899
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 41900-41909
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 41910-41919
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 41920-41929
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41930-41939
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 41940-41949
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 41950-41959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 41960-41969
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 41970-41979
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 41980-41989
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 41990-41999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42000-42009
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 42010-42019
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 42020-42029
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42030-42039
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 42040-42049
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42050-42059
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42060-42069
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 42070-42079
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 42080-42089
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42090-42099
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 42100-42109
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 42110-42119
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42120-42129
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 42130-42139
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 42140-42149
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 42150-42159
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 42160-42169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 42170-42179
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 42180-42189
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 42190-42199
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 42200-42209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42210-42219
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 42220-42229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 42230-42239
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 42240-42249
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 42250-42259
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 42260-42269
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42270-42279
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 42280-42289
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 42290-42299
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 42300-42309
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42310-42319
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 42320-42329
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 42330-42339
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 42340-42349
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 42350-42359
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42360-42369
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 42370-42379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42380-42389
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 42390-42399
		3, 2, 1, 4, 3, 2, 1, 2, 1, 24, // 42400-42409
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 42410-42419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42420-42429
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 42430-42439
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 42440-42449
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 42450-42459
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 42460-42469
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 42470-42479
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 42480-42489
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 42490-42499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 42500-42509
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 42510-42519
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42520-42529
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 42530-42539
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 42540-42549
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 42550-42559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 42560-42569
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 42570-42579
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 42580-42589
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 42590-42599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42600-42609
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 42610-42619
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 42620-42629
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42630-42639
		1, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 42640-42649
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 42650-42659
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 42660-42669
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 42670-42679
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 42680-42689
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 42690-42699
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 42700-42709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 42710-42719
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 42720-42729
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 42730-42739
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 42740-42749
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 42750-42759
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 42760-42769
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 42770-42779
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 42780-42789
		3, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 42790-42799
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 42800-42809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 42810-42819
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 42820-42829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 42830-42839
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42840-42849
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 42850-42859
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 42860-42869
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 42870-42879
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 42880-42889
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 42890-42899
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 42900-42909
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42910-42919
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 42920-42929
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 42930-42939
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 42940-42949
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 42950-42959
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 42960-42969
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 42970-42979
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 42980-42989
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 42990-42999
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 43000-43009
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 43010-43019
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 43020-43029
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 43030-43039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 43040-43049
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43050-43059
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 43060-43069
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 43070-43079
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43080-43089
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 43090-43099
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 43100-43109
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 43110-43119
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43120-43129
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 43130-43139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43140-43149
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 43150-43159
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 43160-43169
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 43170-43179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 43180-43189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43190-43199
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 43200-43209
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43210-43219
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 43220-43229
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 43230-43239
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 43240-43249
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43250-43259
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43260-43269
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43270-43279
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 43280-43289
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 43290-43299
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43300-43309
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 43310-43319
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43320-43329
		1, 60, 59, 58, 57, 56, 55, 54, 53, 52, // 43330-43339
		51, 50, 49, 48, 47, 46, 45, 44, 43, 42, // 43340-43349
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 43350-43359
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 43360-43369
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 43370-43379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43380-43389
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 43390-43399
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 43400-43409
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 43410-43419
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 43420-43429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43430-43439
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43440-43449
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 43450-43459
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 43460-43469
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43470-43479
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 43480-43489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 43490-43499
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 43500-43509
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 43510-43519
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 43520-43529
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43530-43539
		1, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 43540-43549
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 43550-43559
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43560-43569
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 43570-43579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43580-43589
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 43590-43599
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 43600-43609
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 43610-43619
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 43620-43629
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 43630-43639
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 43640-43649
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43650-43659
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 43660-43669
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 43670-43679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43680-43689
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 43690-43699
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43700-43709
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 43710-43719
		1, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 43720-43729
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 43730-43739
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43740-43749
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 43750-43759
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 43760-43769
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 43770-43779
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 43780-43789
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 43790-43799
		1, 52, 51, 50, 49, 48, 47, 46, 45, 44, // 43800-43809
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 43810-43819
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 43820-43829
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 43830-43839
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43840-43849
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 43850-43859
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 43860-43869
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 43870-43879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 43880-43889
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 43890-43899
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43900-43909
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 43910-43919
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 43920-43929
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 43930-43939
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 43940-43949
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 43950-43959
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 43960-43969
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 43970-43979
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 43980-43989
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 43990-43999
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 44000-44009
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 44010-44019
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 44020-44029
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44030-44039
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44040-44049
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 44050-44059
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44060-44069
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 44070-44079
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 44080-44089
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44090-44099
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44100-44109
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 44110-44119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 44120-44129
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 44130-44139
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 44140-44149
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 44150-44159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44160-44169
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 44170-44179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 44180-44189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44190-44199
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 44200-44209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44210-44219
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 44220-44229
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 44230-44239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 44240-44249
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 44250-44259
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 44260-44269
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 44270-44279
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44280-44289
		3, 2, 1, 58, 57, 56, 55, 54, 53, 52, // 44290-44299
		51, 50, 49, 48, 47, 46, 45, 44, 43, 42, // 44300-44309
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 44310-44319
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 44320-44329
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 44330-44339
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44340-44349
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 44350-44359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44360-44369
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44370-44379
		1, 2, 1, 6, 5, 4, 3, 2, 1, 28, // 44380-44389
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 44390-44399
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 44400-44409
		7, 6, 5, 4, 3, 2, 1, 32, 31, 30, // 44410-44419
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 44420-44429
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 44430-44439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 44440-44449
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 44450-44459
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 44460-44469
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44470-44479
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 44480-44489
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 44490-44499
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 44500-44509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 44510-44519
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44520-44529
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 44530-44539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 44540-44549
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44550-44559
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 44560-44569
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 44570-44579
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 44580-44589
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 44590-44599
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 44600-44609
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 44610-44619
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 44620-44629
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 44630-44639
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 44640-44649
		1, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 44650-44659
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 44660-44669
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44670-44679
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 44680-44689
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 44690-44699
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44700-44709
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 44710-44719
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 44720-44729
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44730-44739
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44740-44749
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 44750-44759
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 44760-44769
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 44770-44779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 44780-44789
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 44790-44799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 44800-44809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 44810-44819
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 44820-44829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 44830-44839
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 44840-44849
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 44850-44859
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 44860-44869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 44870-44879
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 44880-44889
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 44890-44899
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 44900-44909
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 44910-44919
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 44920-44929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 44930-44939
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44940-44949
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 44950-44959
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 44960-44969
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 44970-44979
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 44980-44989
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 44990-44999
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 45000-45009
		3, 2, 1, 40, 39, 38, 37, 36, 35, 34, // 45010-45019
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 45020-45029
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 45030-45039
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45040-45049
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 45050-45059
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 45060-45069
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 45070-45079
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 45080-45089
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 45090-45099
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 45100-45109
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 45110-45119
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 45120-45129
		1, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 45130-45139
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 45140-45149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45150-45159
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 45160-45169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 45170-45179
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45180-45189
		1, 6, 5, 4, 3, 2, 1, 36, 35, 34, // 45190-45199
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 45200-45209
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 45210-45219
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45220-45229
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 45230-45239
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 45240-45249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 45250-45259
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 45260-45269
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45270-45279
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 45280-45289
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 45290-45299
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 45300-45309
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 45310-45319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 45320-45329
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 45330-45339
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 45340-45349
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45350-45359
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 45360-45369
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 45370-45379
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 45380-45389
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45390-45399
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 45400-45409
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 45410-45419
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 45420-45429
		3, 2, 1, 6, 5, 4, 3, 2, 1, 42, // 45430-45439
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 45440-45449
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 45450-45459
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 45460-45469
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45470-45479
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45480-45489
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 45490-45499
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 45500-45509
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45510-45519
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 45520-45529
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 45530-45539
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45540-45549
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 45550-45559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 45560-45569
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 45570-45579
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 45580-45589
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 45590-45599
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45600-45609
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 45610-45619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45620-45629
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45630-45639
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 45640-45649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 45650-45659
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 45660-45669
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 45670-45679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45680-45689
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 45690-45699
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 45700-45709
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 45710-45719
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 45720-45729
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 45730-45739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45740-45749
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 45750-45759
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 45760-45769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 38, // 45770-45779
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 45780-45789
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 45790-45799
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 45800-45809
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 45810-45819
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 45820-45829
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 45830-45839
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45840-45849
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 45850-45859
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 45860-45869
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 45870-45879
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 45880-45889
		3, 2, 1, 50, 49, 48, 47, 46, 45, 44, // 45890-45899
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 45900-45909
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 45910-45919
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 45920-45929
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 45930-45939
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 45940-45949
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 45950-45959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 45960-45969
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 45970-45979
		9, 8, 7, 6, 5, 4, 3, 2, 1, 32, // 45980-45989
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 45990-45999
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 46000-46009
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46010-46019
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 46020-46029
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 46030-46039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 46040-46049
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46050-46059
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46060-46069
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 46070-46079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46080-46089
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 46090-46099
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 46100-46109
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 46110-46119
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46120-46129
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 46130-46139
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 46140-46149
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 46150-46159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46160-46169
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46170-46179
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 46180-46189
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 46190-46199
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 46200-46209
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 46210-46219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 46220-46229
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 46230-46239
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 46240-46249
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46250-46259
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46260-46269
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 46270-46279
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 46280-46289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46290-46299
		1, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 46300-46309
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 46310-46319
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 46320-46329
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 46330-46339
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 46340-46349
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 46350-46359
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 46360-46369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46370-46379
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 46380-46389
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 46390-46399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46400-46409
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 46410-46419
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 46420-46429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 46430-46439
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 46440-46449
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 46450-46459
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46460-46469
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 46470-46479
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 46480-46489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 46490-46499
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 46500-46509
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46510-46519
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 46520-46529
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 46530-46539
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 46540-46549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 46550-46559
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 46560-46569
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 46570-46579
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 46580-46589
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46590-46599
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 46600-46609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 46610-46619
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46620-46629
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 46630-46639
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 46640-46649
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46650-46659
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 46660-46669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 46670-46679
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 46680-46689
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46690-46699
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 46700-46709
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46710-46719
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 46720-46729
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 46730-46739
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 46740-46749
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 46750-46759
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 46760-46769
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 46770-46779
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 46780-46789
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 46790-46799
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 46800-46809
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 46810-46819
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 46820-46829
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 46830-46839
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46840-46849
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 46850-46859
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 46860-46869
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 46870-46879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 46880-46889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 46890-46899
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 46900-46909
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 46910-46919
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46920-46929
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 46930-46939
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 46940-46949
		7, 6, 5, 4, 3, 2, 1, 36, 35, 34, // 46950-46959
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 46960-46969
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 46970-46979
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 46980-46989
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 46990-46999
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47000-47009
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 47010-47019
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 47020-47029
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47030-47039
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47040-47049
		1, 6, 5, 4, 3, 2, 1, 2, 1, 28, // 47050-47059
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 47060-47069
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47070-47079
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 47080-47089
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 47090-47099
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47100-47109
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 47110-47119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 47120-47129
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 47130-47139
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 47140-47149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47150-47159
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 47160-47169
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 47170-47179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 47180-47189
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47190-47199
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 47200-47209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47210-47219
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47220-47229
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 47230-47239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47240-47249
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 47250-47259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 47260-47269
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 47270-47279
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 47280-47289
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 47290-47299
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 47300-47309
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 47310-47319
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 47320-47329
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 47330-47339
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47340-47349
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 47350-47359
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 47360-47369
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47370-47379
		1, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 47380-47389
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47390-47399
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 47400-47409
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 47410-47419
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47420-47429
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47430-47439
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 47440-47449
		9, 8, 7, 6, 5, 4, 3, 2, 1, 32, // 47450-47459
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 47460-47469
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 47470-47479
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47480-47489
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 47490-47499
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 47500-47509
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 47510-47519
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 47520-47529
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 47530-47539
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 47540-47549
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 47550-47559
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 47560-47569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47570-47579
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47580-47589
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 47590-47599
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 47600-47609
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 47610-47619
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 47620-47629
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 47630-47639
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 47640-47649
		3, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 47650-47659
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 47660-47669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47670-47679
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 47680-47689
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 47690-47699
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47700-47709
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 47710-47719
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47720-47729
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 47730-47739
		1, 2, 1, 34, 33, 32, 31, 30, 29, 28, // 47740-47749
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 47750-47759
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47760-47769
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 47770-47779
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47780-47789
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 47790-47799
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 47800-47809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 47810-47819
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 47820-47829
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 47830-47839
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 47840-47849
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 47850-47859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 47860-47869
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 47870-47879
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 47880-47889
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 47890-47899
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 47900-47909
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 47910-47919
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 47920-47929
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 47930-47939
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 47940-47949
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 47950-47959
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 47960-47969
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 47970-47979
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 47980-47989
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 47990-47999
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48000-48009
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 48010-48019
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 48020-48029
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 48030-48039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 48040-48049
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 48050-48059
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48060-48069
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 48070-48079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48080-48089
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 48090-48099
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 48100-48109
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 48110-48119
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48120-48129
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 48130-48139
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48140-48149
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 48150-48159
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 48160-48169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 48170-48179
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 48180-48189
		3, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 48190-48199
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 48200-48209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48210-48219
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 48220-48229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 48230-48239
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 48240-48249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 48250-48259
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48260-48269
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48270-48279
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 48280-48289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 48290-48299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48300-48309
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 48310-48319
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48320-48329
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 48330-48339
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48340-48349
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 48350-48359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48360-48369
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48370-48379
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 48380-48389
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 48390-48399
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 48400-48409
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 48410-48419
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48420-48429
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 48430-48439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 48440-48449
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48450-48459
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 48460-48469
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 48470-48479
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 48480-48489
		1, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 48490-48499
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 48500-48509
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48510-48519
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 48520-48529
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 48530-48539
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 48540-48549
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48550-48559
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 48560-48569
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 48570-48579
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 48580-48589
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 48590-48599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48600-48609
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 48610-48619
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 48620-48629
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48630-48639
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 48640-48649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48650-48659
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48660-48669
		3, 2, 1, 4, 3, 2, 1, 2, 1, 52, // 48670-48679
		51, 50, 49, 48, 47, 46, 45, 44, 43, 42, // 48680-48689
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 48690-48699
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 48700-48709
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 48710-48719
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48720-48729
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 48730-48739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 48740-48749
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 48750-48759
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 48760-48769
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 48770-48779
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 48780-48789
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 48790-48799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 48800-48809
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 48810-48819
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 48820-48829
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48830-48839
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 48840-48849
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 48850-48859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 48860-48869
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48870-48879
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 48880-48889
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48890-48899
		7, 6, 5, 4, 3, 2, 1, 40, 39, 38, // 48900-48909
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 48910-48919
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 48920-48929
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 48930-48939
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 48940-48949
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 48950-48959
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48960-48969
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 48970-48979
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 48980-48989
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 48990-48999
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 49000-49009
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 49010-49019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49020-49029
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 49030-49039
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 49040-49049
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 49050-49059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 49060-49069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49070-49079
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 49080-49089
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49090-49099
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 49100-49109
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 49110-49119
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 49120-49129
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 49130-49139
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 49140-49149
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 49150-49159
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 49160-49169
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 49170-49179
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49180-49189
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 49190-49199
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 49200-49209
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49210-49219
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 49220-49229
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 49230-49239
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49240-49249
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 49250-49259
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 49260-49269
		7, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 49270-49279
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 49280-49289
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 49290-49299
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 49300-49309
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 49310-49319
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49320-49329
		1, 2, 1, 6, 5, 4, 3, 2, 1, 24, // 49330-49339
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 49340-49349
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49350-49359
		3, 2, 1, 4, 3, 2, 1, 2, 1, 22, // 49360-49369
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 49370-49379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49380-49389
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 49390-49399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 49400-49409
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 49410-49419
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 49420-49429
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 49430-49439
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49440-49449
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 49450-49459
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 49460-49469
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 49470-49479
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 49480-49489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 49490-49499
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 49500-49509
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49510-49519
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 49520-49529
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 49530-49539
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 49540-49549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 38, // 49550-49559
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 49560-49569
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 49570-49579
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 49580-49589
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 49590-49599
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 49600-49609
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 49610-49619
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 49620-49629
		3, 2, 1, 6, 5, 4, 3, 2, 1, 24, // 49630-49639
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 49640-49649
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49650-49659
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 49660-49669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49670-49679
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 49680-49689
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 49690-49699
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49700-49709
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 49710-49719
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 49720-49729
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 49730-49739
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 49740-49749
		7, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 49750-49759
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 49760-49769
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49770-49779
		3, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 49780-49789
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49790-49799
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 49800-49809
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49810-49819
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 49820-49829
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 49830-49839
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 49840-49849
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 49850-49859
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49860-49869
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 49870-49879
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49880-49889
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 49890-49899
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 49900-49909
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 49910-49919
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 49920-49929
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 49930-49939
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 49940-49949
		7, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 49950-49959
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 49960-49969
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 49970-49979
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 49980-49989
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 49990-49999
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50000-50009
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50010-50019
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 50020-50029
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 50030-50039
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 50040-50049
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 50050-50059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 50060-50069
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 50070-50079
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 50080-50089
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 50090-50099
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50100-50109
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 50110-50119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 50120-50129
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 50130-50139
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 50140-50149
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 50150-50159
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 50160-50169
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 50170-50179
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 50180-50189
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 50190-50199
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 50200-50209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50210-50219
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 50220-50229
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 50230-50239
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50240-50249
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50250-50259
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 50260-50269
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 50270-50279
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 50280-50289
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50290-50299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50300-50309
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50310-50319
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 50320-50329
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 50330-50339
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 50340-50349
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 50350-50359
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 50360-50369
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 50370-50379
		3, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 50380-50389
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50390-50399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50400-50409
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 50410-50419
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 50420-50429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50430-50439
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 50440-50449
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 50450-50459
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 50460-50469
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 50470-50479
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 50480-50489
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 50490-50499
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 50500-50509
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 50510-50519
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 50520-50529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 50530-50539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 50540-50549
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 50550-50559
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50560-50569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50570-50579
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 50580-50589
		1, 2, 1, 6, 5, 4, 3, 2, 1, 28, // 50590-50599
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 50600-50609
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 50610-50619
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 50620-50629
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 50630-50639
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 50640-50649
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50650-50659
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50660-50669
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 50670-50679
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 50680-50689
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 50690-50699
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 50700-50709
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 50710-50719
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 50720-50729
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50730-50739
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 50740-50749
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 50750-50759
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 50760-50769
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 50770-50779
		9, 8, 7, 6, 5, 4, 3, 2, 1, 32, // 50780-50789
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 50790-50799
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50800-50809
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50810-50819
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 50820-50829
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 50830-50839
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 50840-50849
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 50850-50859
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 50860-50869
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 50870-50879
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50880-50889
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 50890-50899
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 50900-50909
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 50910-50919
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 50920-50929
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 50930-50939
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 50940-50949
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 50950-50959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 50960-50969
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 50970-50979
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 50980-50989
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 50990-50999
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 51000-51009
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 51010-51019
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51020-51029
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51030-51039
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 51040-51049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 51050-51059
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51060-51069
		1, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 51070-51079
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 51080-51089
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 51090-51099
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 51100-51109
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 51110-51119
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51120-51129
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 51130-51139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51140-51149
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 51150-51159
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 51160-51169
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 51170-51179
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51180-51189
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 51190-51199
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 51200-51209
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 51210-51219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 51220-51229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 51230-51239
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 51240-51249
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 51250-51259
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 51260-51269
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51270-51279
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 51280-51289
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 51290-51299
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 51300-51309
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 51310-51319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 51320-51329
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51330-51339
		1, 2, 1, 4, 3, 2, 1, 2, 1, 12, // 51340-51349
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51350-51359
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 51360-51369
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51370-51379
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 51380-51389
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 51390-51399
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 51400-51409
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 51410-51419
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 51420-51429
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 51430-51439
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 51440-51449
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51450-51459
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51460-51469
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 51470-51479
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 51480-51489
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51490-51499
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 51500-51509
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 51510-51519
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 51520-51529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 51530-51539
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51540-51549
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51550-51559
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 51560-51569
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 51570-51579
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51580-51589
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 51590-51599
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 51600-51609
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 51610-51619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51620-51629
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 51630-51639
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 51640-51649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 51650-51659
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51660-51669
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 51670-51679
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 51680-51689
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 51690-51699
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51700-51709
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 51710-51719
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 51720-51729
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 51730-51739
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 51740-51749
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 51750-51759
		7, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 51760-51769
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 51770-51779
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 51780-51789
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 51790-51799
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 51800-51809
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 51810-51819
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 51820-51829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 51830-51839
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51840-51849
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 51850-51859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 51860-51869
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 51870-51879
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 51880-51889
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 51890-51899
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 51900-51909
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 51910-51919
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 51920-51929
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51930-51939
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 51940-51949
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 51950-51959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51960-51969
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 51970-51979
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 51980-51989
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 51990-51999
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 52000-52009
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52010-52019
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 52020-52029
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 52030-52039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52040-52049
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 52050-52059
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 52060-52069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52070-52079
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 52080-52089
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 52090-52099
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 52100-52109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52110-52119
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 52120-52129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 52130-52139
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 52140-52149
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 52150-52159
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 52160-52169
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 52170-52179
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 52180-52189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52190-52199
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 52200-52209
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 52210-52219
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 52220-52229
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 52230-52239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 52240-52249
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 52250-52259
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 52260-52269
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 52270-52279
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 52280-52289
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52290-52299
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 52300-52309
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 52310-52319
		1, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 52320-52329
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 52330-52339
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 52340-52349
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52350-52359
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 52360-52369
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 52370-52379
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 52380-52389
		1, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 52390-52399
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 52400-52409
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 52410-52419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 52420-52429
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 52430-52439
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 52440-52449
		3, 2, 1, 4, 3, 2, 1, 32, 31, 30, // 52450-52459
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 52460-52469
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 52470-52479
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 52480-52489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52490-52499
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52500-52509
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 52510-52519
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 52520-52529
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52530-52539
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 52540-52549
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 52550-52559
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 52560-52569
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 52570-52579
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 52580-52589
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 52590-52599
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 52600-52609
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 52610-52619
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 52620-52629
		1, 8, 7, 6, 5, 4, 3, 2, 1, 28, // 52630-52639
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 52640-52649
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 52650-52659
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 52660-52669
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 52670-52679
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52680-52689
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 52690-52699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 52700-52709
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52710-52719
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 52720-52729
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 52730-52739
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 52740-52749
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 52750-52759
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 52760-52769
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 52770-52779
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 52780-52789
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 52790-52799
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 52800-52809
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 52810-52819
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 52820-52829
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 52830-52839
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 52840-52849
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 52850-52859
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 52860-52869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 52870-52879
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 52880-52889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52890-52899
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 52900-52909
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 52910-52919
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 52920-52929
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 52930-52939
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 52940-52949
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 52950-52959
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 52960-52969
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 52970-52979
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 52980-52989
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 52990-52999
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 53000-53009
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 53010-53019
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 53020-53029
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53030-53039
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 53040-53049
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 53050-53059
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 53060-53069
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 53070-53079
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 53080-53089
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 53090-53099
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53100-53109
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 53110-53119
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 53120-53129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53130-53139
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 53140-53149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53150-53159
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53160-53169
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 53170-53179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 53180-53189
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 53190-53199
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 53200-53209
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 53210-53219
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53220-53229
		1, 2, 1, 6, 5, 4, 3, 2, 1, 28, // 53230-53239
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 53240-53249
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53250-53259
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 53260-53269
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 53270-53279
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 53280-53289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 53290-53299
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 53300-53309
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53310-53319
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 53320-53329
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 53330-53339
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53340-53349
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 53350-53359
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53360-53369
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 53370-53379
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 53380-53389
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53390-53399
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 53400-53409
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 53410-53419
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53420-53429
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 53430-53439
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53440-53449
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 53450-53459
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 53460-53469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 53470-53479
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 53480-53489
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53490-53499
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 53500-53509
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53510-53519
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 53520-53529
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 53530-53539
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 53540-53549
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 53550-53559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 53560-53569
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 53570-53579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53580-53589
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 53590-53599
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 53600-53609
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 53610-53619
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 53620-53629
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 53630-53639
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53640-53649
		3, 2, 1, 4, 3, 2, 1, 24, 23, 22, // 53650-53659
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 53660-53669
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53670-53679
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53680-53689
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 53690-53699
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53700-53709
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 53710-53719
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53720-53729
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 53730-53739
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 53740-53749
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 53750-53759
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53760-53769
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 53770-53779
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 53780-53789
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 53790-53799
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 53800-53809
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 53810-53819
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53820-53829
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 53830-53839
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 53840-53849
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 53850-53859
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 53860-53869
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53870-53879
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 53880-53889
		1, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 53890-53899
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53900-53909
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 53910-53919
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 53920-53929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 53930-53939
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 53940-53949
		1, 8, 7, 6, 5, 4, 3, 2, 1, 28, // 53950-53959
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 53960-53969
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 53970-53979
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 53980-53989
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 53990-53999
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54000-54009
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 54010-54019
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54020-54029
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 54030-54039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 54040-54049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 54050-54059
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 54060-54069
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 54070-54079
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 54080-54089
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54090-54099
		1, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 54100-54109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54110-54119
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 54120-54129
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 54130-54139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54140-54149
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 54150-54159
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 54160-54169
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54170-54179
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 54180-54189
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 54190-54199
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54200-54209
		7, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 54210-54219
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 54220-54229
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 54230-54239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54240-54249
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 54250-54259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 54260-54269
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 54270-54279
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 54280-54289
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 54290-54299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54300-54309
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 54310-54319
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 54320-54329
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54330-54339
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 54340-54349
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54350-54359
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 54360-54369
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 54370-54379
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 54380-54389
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54390-54399
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 54400-54409
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 54410-54419
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54420-54429
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 54430-54439
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 54440-54449
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 54450-54459
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 54460-54469
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 54470-54479
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 54480-54489
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 54490-54499
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 54500-54509
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 54510-54519
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 54520-54529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 54530-54539
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 54540-54549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 54550-54559
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 54560-54569
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 54570-54579
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 54580-54589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54590-54599
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54600-54609
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 54610-54619
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 54620-54629
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54630-54639
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 54640-54649
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54650-54659
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 54660-54669
		3, 2, 1, 6, 5, 4, 3, 2, 1, 30, // 54670-54679
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 54680-54689
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 54690-54699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 54700-54709
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 54710-54719
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 54720-54729
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 54730-54739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54740-54749
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54750-54759
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 54760-54769
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 54770-54779
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 54780-54789
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 54790-54799
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 54800-54809
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 54810-54819
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 54820-54829
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 54830-54839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54840-54849
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 54850-54859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 54860-54869
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 54870-54879
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 54880-54889
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 54890-54899
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 54900-54909
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 54910-54919
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 54920-54929
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54930-54939
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 54940-54949
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 54950-54959
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 54960-54969
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 54970-54979
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 54980-54989
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 54990-54999
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 55000-55009
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55010-55019
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 55020-55029
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 55030-55039
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 55040-55049
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 55050-55059
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55060-55069
		3, 2, 1, 6, 5, 4, 3, 2, 1, 24, // 55070-55079
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 55080-55089
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55090-55099
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 55100-55109
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 55110-55119
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 55120-55129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 55130-55139
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 55140-55149
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55150-55159
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 55160-55169
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 55170-55179
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 55180-55189
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55190-55199
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 55200-55209
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 55210-55219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 55220-55229
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55230-55239
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 55240-55249
		9, 8, 7, 6, 5, 4, 3, 2, 1, 32, // 55250-55259
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 55260-55269
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 55270-55279
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55280-55289
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 55290-55299
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55300-55309
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 55310-55319
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55320-55329
		1, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 55330-55339
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 55340-55349
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 55350-55359
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55360-55369
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 55370-55379
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 55380-55389
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 55390-55399
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55400-55409
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 55410-55419
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 55420-55429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 55430-55439
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 55440-55449
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 55450-55459
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 55460-55469
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 55470-55479
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 55480-55489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55490-55499
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55500-55509
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 55510-55519
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 55520-55529
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55530-55539
		1, 6, 5, 4, 3, 2, 1, 32, 31, 30, // 55540-55549
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 55550-55559
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 55560-55569
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 55570-55579
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 55580-55589
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55590-55599
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 55600-55609
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 55610-55619
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55620-55629
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 55630-55639
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 55640-55649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55650-55659
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 55660-55669
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 55670-55679
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55680-55689
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 55690-55699
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55700-55709
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 55710-55719
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55720-55729
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 55730-55739
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 55740-55749
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 55750-55759
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 55760-55769
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 55770-55779
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 55780-55789
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 55790-55799
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 55800-55809
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 55810-55819
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 55820-55829
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 55830-55839
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 55840-55849
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 55850-55859
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55860-55869
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 55870-55879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 55880-55889
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 55890-55899
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 55900-55909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 55910-55919
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 55920-55929
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 55930-55939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 55940-55949
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 55950-55959
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 55960-55969
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 55970-55979
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 55980-55989
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 55990-55999
		3, 2, 1, 6, 5, 4, 3, 2, 1, 30, // 56000-56009
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 56010-56019
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 56020-56029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 56030-56039
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 56040-56049
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 56050-56059
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 56060-56069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56070-56079
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 56080-56089
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 56090-56099
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 56100-56109
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 56110-56119
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 56120-56129
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 56130-56139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 56140-56149
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 56150-56159
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 56160-56169
		1, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 56170-56179
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 56180-56189
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 56190-56199
		7, 6, 5, 4, 3, 2, 1, 2, 1, 28, // 56200-56209
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 56210-56219
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 56220-56229
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 56230-56239
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 56240-56249
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 56250-56259
		3, 2, 1, 4, 3, 2, 1, 2, 1, 30, // 56260-56269
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 56270-56279
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 56280-56289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 56290-56299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56300-56309
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 56310-56319
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 56320-56329
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 56330-56339
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 56340-56349
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 56350-56359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 56360-56369
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 56370-56379
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 56380-56389
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 56390-56399
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 56400-56409
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 56410-56419
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56420-56429
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 56430-56439
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 56440-56449
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 56450-56459
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 56460-56469
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 56470-56479
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 56480-56489
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56490-56499
		1, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 56500-56509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 56510-56519
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 56520-56529
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 56530-56539
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 56540-56549
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 56550-56559
		9, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 56560-56569
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 56570-56579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56580-56589
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 56590-56599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56600-56609
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 56610-56619
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 56620-56629
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 56630-56639
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 56640-56649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 56650-56659
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 56660-56669
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56670-56679
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 56680-56689
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56690-56699
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56700-56709
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 56710-56719
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56720-56729
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 56730-56739
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 56740-56749
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 56750-56759
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 56760-56769
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 56770-56779
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 56780-56789
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 56790-56799
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 56800-56809
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 56810-56819
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 56820-56829
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 56830-56839
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 56840-56849
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 56850-56859
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 56860-56869
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 56870-56879
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56880-56889
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 56890-56899
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 56900-56909
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56910-56919
		1, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 56920-56929
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56930-56939
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 56940-56949
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 56950-56959
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 56960-56969
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 56970-56979
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 56980-56989
		3, 2, 1, 6, 5, 4, 3, 2, 1, 38, // 56990-56999
		37, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 57000-57009
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 57010-57019
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57020-57029
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 57030-57039
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 57040-57049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 57050-57059
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 57060-57069
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 57070-57079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 57080-57089
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 57090-57099
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 57100-57109
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 57110-57119
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57120-57129
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 57130-57139
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 57140-57149
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 57150-57159
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 57160-57169
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 57170-57179
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57180-57189
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 57190-57199
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 57200-57209
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57210-57219
		1, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 57220-57229
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57230-57239
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57240-57249
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 57250-57259
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 57260-57269
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 57270-57279
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 57280-57289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57290-57299
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 57300-57309
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 57310-57319
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 57320-57329
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57330-57339
		7, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 57340-57349
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57350-57359
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 57360-57369
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 57370-57379
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 57380-57389
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 57390-57399
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 57400-57409
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 57410-57419
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 57420-57429
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 57430-57439
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57440-57449
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 57450-57459
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 57460-57469
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57470-57479
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 57480-57489
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 57490-57499
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 57500-57509
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57510-57519
		7, 6, 5, 4, 3, 2, 1, 2, 1, 28, // 57520-57529
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 57530-57539
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57540-57549
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 57550-57559
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57560-57569
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57570-57579
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 57580-57589
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 57590-57599
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 57600-57609
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 57610-57619
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57620-57629
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 57630-57639
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 57640-57649
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 57650-57659
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 57660-57669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 57670-57679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 57680-57689
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 57690-57699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 57700-57709
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 57710-57719
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 57720-57729
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 57730-57739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57740-57749
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 57750-57759
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 57760-57769
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 57770-57779
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 57780-57789
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 57790-57799
		3, 2, 1, 6, 5, 4, 3, 2, 1, 20, // 57800-57809
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 57810-57819
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 57820-57829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 57830-57839
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 57840-57849
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 57850-57859
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 57860-57869
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57870-57879
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 57880-57889
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 57890-57899
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 57900-57909
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 57910-57919
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 57920-57929
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 57930-57939
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 57940-57949
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 57950-57959
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 57960-57969
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 57970-57979
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 57980-57989
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 57990-57999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 58000-58009
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 58010-58019
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 58020-58029
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 58030-58039
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 58040-58049
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 58050-58059
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58060-58069
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 58070-58079
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 58080-58089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 58090-58099
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 58100-58109
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 58110-58119
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 58120-58129
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58130-58139
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 58140-58149
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 58150-58159
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 58160-58169
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 58170-58179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 58180-58189
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 58190-58199
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 58200-58209
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 58210-58219
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 58220-58229
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58230-58239
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 58240-58249
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 58250-58259
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58260-58269
		1, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 58270-58279
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 58280-58289
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 58290-58299
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 58300-58309
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 58310-58319
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58320-58329
		7, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 58330-58339
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 58340-58349
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 58350-58359
		3, 2, 1, 4, 3, 2, 1, 2, 1, 10, // 58360-58369
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 58370-58379
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58380-58389
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 58390-58399
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 58400-58409
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 58410-58419
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 58420-58429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 58430-58439
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58440-58449
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 58450-58459
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58460-58469
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 58470-58479
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 58480-58489
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 58490-58499
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58500-58509
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 58510-58519
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58520-58529
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58530-58539
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 58540-58549
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58550-58559
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58560-58569
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 58570-58579
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 58580-58589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58590-58599
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 58600-58609
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 58610-58619
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58620-58629
		1, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 58630-58639
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58640-58649
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 58650-58659
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 58660-58669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 58670-58679
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58680-58689
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 58690-58699
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58700-58709
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58710-58719
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58720-58729
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 58730-58739
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58740-58749
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58750-58759
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 58760-58769
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58770-58779
		7, 6, 5, 4, 3, 2, 1, 2, 1, 42, // 58780-58789
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 58790-58799
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 58800-58809
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 58810-58819
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58820-58829
		1, 58, 57, 56, 55, 54, 53, 52, 51, 50, // 58830-58839
		49, 48, 47, 46, 45, 44, 43, 42, 41, 40, // 58840-58849
		39, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 58850-58859
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 58860-58869
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 58870-58879
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 58880-58889
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 58890-58899
		1, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 58900-58909
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 58910-58919
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 58920-58929
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 58930-58939
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 58940-58949
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 58950-58959
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 58960-58969
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 58970-58979
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 58980-58989
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 58990-58999
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 59000-59009
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59010-59019
		1, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 59020-59029
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 59030-59039
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59040-59049
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 59050-59059
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 59060-59069
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 59070-59079
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 59080-59089
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 59090-59099
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 59100-59109
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 59110-59119
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 59120-59129
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59130-59139
		1, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 59140-59149
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 59150-59159
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 59160-59169
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59170-59179
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 59180-59189
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 59190-59199
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 59200-59209
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 59210-59219
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59220-59229
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 59230-59239
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 59240-59249
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59250-59259
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 59260-59269
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 59270-59279
		1, 52, 51, 50, 49, 48, 47, 46, 45, 44, // 59280-59289
		43, 42, 41, 40, 39, 38, 37, 36, 35, 34, // 59290-59299
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 59300-59309
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 59310-59319
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59320-59329
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 59330-59339
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59340-59349
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 59350-59359
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 59360-59369
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 59370-59379
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 59380-59389
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 59390-59399
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 59400-59409
		7, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 59410-59419
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 59420-59429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59430-59439
		1, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 59440-59449
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 59450-59459
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 59460-59469
		1, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 59470-59479
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 59480-59489
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 59490-59499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 59500-59509
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 59510-59519
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 59520-59529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 59530-59539
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 59540-59549
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 59550-59559
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 59560-59569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59570-59579
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 59580-59589
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 59590-59599
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59600-59609
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 59610-59619
		1, 6, 5, 4, 3, 2, 1, 2, 1, 22, // 59620-59629
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 59630-59639
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59640-59649
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 59650-59659
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 59660-59669
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 59670-59679
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59680-59689
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 59690-59699
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 59700-59709
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59710-59719
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 59720-59729
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59730-59739
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 59740-59749
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 59750-59759
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59760-59769
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 59770-59779
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59780-59789
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 59790-59799
		9, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 59800-59809
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 59810-59819
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59820-59829
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 59830-59839
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 59840-59849
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 59850-59859
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 59860-59869
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 59870-59879
		7, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 59880-59889
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 59890-59899
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 59900-59909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59910-59919
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 59920-59929
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 59930-59939
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59940-59949
		1, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 59950-59959
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59960-59969
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 59970-59979
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 59980-59989
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 59990-59999
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60000-60009
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 60010-60019
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 60020-60029
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 60030-60039
		1, 36, 35, 34, 33, 32, 31, 30, 29, 28, // 60040-60049
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 60050-60059
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 60060-60069
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 60070-60079
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 60080-60089
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60090-60099
		1, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 60100-60109
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 60110-60119
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 60120-60129
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 60130-60139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 60140-60149
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60150-60159
		1, 6, 5, 4, 3, 2, 1, 2, 1, 40, // 60160-60169
		39, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 60170-60179
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 60180-60189
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 60190-60199
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 60200-60209
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 60210-60219
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 60220-60229
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 60230-60239
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60240-60249
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 60250-60259
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60260-60269
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 60270-60279
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 60280-60289
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 60290-60299
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 60300-60309
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 60310-60319
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60320-60329
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 60330-60339
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 60340-60349
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 60350-60359
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60360-60369
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 60370-60379
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 60380-60389
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 60390-60399
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60400-60409
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 60410-60419
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 60420-60429
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60430-60439
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 60440-60449
		7, 6, 5, 4, 3, 2, 1, 36, 35, 34, // 60450-60459
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 60460-60469
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 60470-60479
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60480-60489
		3, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 60490-60499
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 60500-60509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60510-60519
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 60520-60529
		9, 8, 7, 6, 5, 4, 3, 2, 1, 50, // 60530-60539
		49, 48, 47, 46, 45, 44, 43, 42, 41, 40, // 60540-60549
		39, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 60550-60559
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 60560-60569
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 60570-60579
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 60580-60589
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60590-60599
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 60600-60609
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 60610-60619
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 60620-60629
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 60630-60639
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 60640-60649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 60650-60659
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 60660-60669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 60670-60679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 60680-60689
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60690-60699
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 60700-60709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 60710-60719
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 60720-60729
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 60730-60739
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 60740-60749
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 60750-60759
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 60760-60769
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 60770-60779
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60780-60789
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 60790-60799
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60800-60809
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60810-60819
		1, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 60820-60829
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 60830-60839
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 60840-60849
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 60850-60859
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 60860-60869
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 60870-60879
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 60880-60889
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 60890-60899
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 60900-60909
		3, 2, 1, 4, 3, 2, 1, 2, 1, 4, // 60910-60919
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 60920-60929
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 60930-60939
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 60940-60949
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 60950-60959
		1, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 60960-60969
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 60970-60979
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 60980-60989
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 60990-60999
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 61000-61009
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 61010-61019
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 61020-61029
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61030-61039
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 61040-61049
		1, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 61050-61059
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 61060-61069
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 61070-61079
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61080-61089
		1, 8, 7, 6, 5, 4, 3, 2, 1, 22, // 61090-61099
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 61100-61109
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61110-61119
		1, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 61120-61129
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61130-61139
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61140-61149
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 61150-61159
		9, 8, 7, 6, 5, 4, 3, 2, 1, 42, // 61160-61169
		41, 40, 39, 38, 37, 36, 35, 34, 33, 32, // 61170-61179
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 61180-61189
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 61190-61199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61200-61209
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61210-61219
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 61220-61229
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 61230-61239
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61240-61249
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 61250-61259
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 61260-61269
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61270-61279
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 61280-61289
		1, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 61290-61299
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 61300-61309
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 61310-61319
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61320-61329
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 61330-61339
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 61340-61349
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 61350-61359
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 61360-61369
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 61370-61379
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 61380-61389
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61390-61399
		3, 2, 1, 6, 5, 4, 3, 2, 1, 8, // 61400-61409
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 61410-61419
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 61420-61429
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61430-61439
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 61440-61449
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61450-61459
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 61460-61469
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61470-61479
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 61480-61489
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 61490-61499
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 61500-61509
		1, 8, 7, 6, 5, 4, 3, 2, 1, 24, // 61510-61519
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 61520-61529
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61530-61539
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 61540-61549
		3, 2, 1, 6, 5, 4, 3, 2, 1, 2, // 61550-61559
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 61560-61569
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61570-61579
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 61580-61589
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61590-61599
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 61600-61609
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 61610-61619
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 61620-61629
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 61630-61639
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 61640-61649
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 61650-61659
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 61660-61669
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 61670-61679
		1, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 61680-61689
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61690-61699
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 61700-61709
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 61710-61719
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 61720-61729
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 61730-61739
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61740-61749
		1, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 61750-61759
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 61760-61769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61770-61779
		1, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 61780-61789
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 61790-61799
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61800-61809
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 61810-61819
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 61820-61829
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 61830-61839
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 61840-61849
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61850-61859
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61860-61869
		1, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 61870-61879
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 61880-61889
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 61890-61899
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 61900-61909
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 61910-61919
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 61920-61929
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 61930-61939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 61940-61949
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 61950-61959
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 61960-61969
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 61970-61979
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 61980-61989
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 61990-61999
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 62000-62009
		1, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 62010-62019
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 62020-62029
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 62030-62039
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 62040-62049
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 62050-62059
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62060-62069
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62070-62079
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 62080-62089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 62090-62099
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 62100-62109
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 62110-62119
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 62120-62129
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 62130-62139
		1, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 62140-62149
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 62150-62159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62160-62169
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 62170-62179
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 62180-62189
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62190-62199
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 62200-62209
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 62210-62219
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62220-62229
		3, 2, 1, 40, 39, 38, 37, 36, 35, 34, // 62230-62239
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 62240-62249
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 62250-62259
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62260-62269
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 62270-62279
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 62280-62289
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 62290-62299
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 62300-62309
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62310-62319
		3, 2, 1, 4, 3, 2, 1, 20, 19, 18, // 62320-62329
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 62330-62339
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 62340-62349
		1, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 62350-62359
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 62360-62369
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62370-62379
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 62380-62389
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62390-62399
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 62400-62409
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 62410-62419
		3, 2, 1, 36, 35, 34, 33, 32, 31, 30, // 62420-62429
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 62430-62439
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 62440-62449
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 62450-62459
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 62460-62469
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 62470-62479
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 62480-62489
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 62490-62499
		1, 6, 5, 4, 3, 2, 1, 26, 25, 24, // 62500-62509
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 62510-62519
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62520-62529
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 62530-62539
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 62540-62549
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62550-62559
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 62560-62569
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62570-62579
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62580-62589
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 62590-62599
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 62600-62609
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 62610-62619
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 62620-62629
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 62630-62639
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62640-62649
		3, 2, 1, 6, 5, 4, 3, 2, 1, 24, // 62650-62659
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 62660-62669
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62670-62679
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 62680-62689
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62690-62699
		1, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 62700-62709
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62710-62719
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 62720-62729
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62730-62739
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 62740-62749
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 62750-62759
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 62760-62769
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 62770-62779
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62780-62789
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62790-62799
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 62800-62809
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 62810-62819
		7, 6, 5, 4, 3, 2, 1, 24, 23, 22, // 62820-62829
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 62830-62839
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62840-62849
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62850-62859
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 62860-62869
		3, 2, 1, 24, 23, 22, 21, 20, 19, 18, // 62870-62879
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 62880-62889
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 62890-62899
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 62900-62909
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62910-62919
		1, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 62920-62929
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 62930-62939
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 62940-62949
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 62950-62959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 62960-62969
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 62970-62979
		1, 2, 1, 4, 3, 2, 1, 2, 1, 40, // 62980-62989
		39, 38, 37, 36, 35, 34, 33, 32, 31, 30, // 62990-62999
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 63000-63009
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63010-63019
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 63020-63029
		1, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 63030-63039
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63040-63049
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 63050-63059
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63060-63069
		3, 2, 1, 6, 5, 4, 3, 2, 1, 18, // 63070-63079
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 63080-63089
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63090-63099
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 63100-63109
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 63110-63119
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 63120-63129
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63130-63139
		9, 8, 7, 6, 5, 4, 3, 2, 1, 30, // 63140-63149
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 63150-63159
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63160-63169
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 63170-63179
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 63180-63189
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 63190-63199
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 63200-63209
		1, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 63210-63219
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 63220-63229
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 63230-63239
		1, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 63240-63249
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 63250-63259
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 63260-63269
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 63270-63279
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63280-63289
		9, 8, 7, 6, 5, 4, 3, 2, 1, 12, // 63290-63299
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 63300-63309
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 63310-63319
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 63320-63329
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 63330-63339
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63340-63349
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 63350-63359
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 63360-63369
		7, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 63370-63379
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 63380-63389
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 63390-63399
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 63400-63409
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 63410-63419
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63420-63429
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 63430-63439
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 63440-63449
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 63450-63459
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 63460-63469
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 63470-63479
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63480-63489
		3, 2, 1, 6, 5, 4, 3, 2, 1, 22, // 63490-63499
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 63500-63509
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 63510-63519
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63520-63529
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 63530-63539
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63540-63549
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 63550-63559
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 63560-63569
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 63570-63579
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 63580-63589
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 63590-63599
		1, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 63600-63609
		1, 6, 5, 4, 3, 2, 1, 12, 11, 10, // 63610-63619
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 63620-63629
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 63630-63639
		7, 6, 5, 4, 3, 2, 1, 2, 1, 10, // 63640-63649
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 63650-63659
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 63660-63669
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63670-63679
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 63680-63689
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63690-63699
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 63700-63709
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 63710-63719
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 63720-63729
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63730-63739
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 63740-63749
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 63750-63759
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 63760-63769
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 63770-63779
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 63780-63789
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 63790-63799
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 63800-63809
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 63810-63819
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 63820-63829
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 63830-63839
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 63840-63849
		3, 2, 1, 4, 3, 2, 1, 6, 5, 4, // 63850-63859
		3, 2, 1, 38, 37, 36, 35, 34, 33, 32, // 63860-63869
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 63870-63879
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 63880-63889
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 63890-63899
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 63900-63909
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 63910-63919
		9, 8, 7, 6, 5, 4, 3, 2, 1, 20, // 63920-63929
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 63930-63939
		9, 8, 7, 6, 5, 4, 3, 2, 1, 28, // 63940-63949
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 63950-63959
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 63960-63969
		7, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 63970-63979
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 63980-63989
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 63990-63999
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 64000-64009
		3, 2, 1, 6, 5, 4, 3, 2, 1, 14, // 64010-64019
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64020-64029
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 64030-64039
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 64040-64049
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64050-64059
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 64060-64069
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64070-64079
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64080-64089
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 64090-64099
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 64100-64109
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64110-64119
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 64120-64129
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 64130-64139
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64140-64149
		1, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 64150-64159
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64160-64169
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 64170-64179
		7, 6, 5, 4, 3, 2, 1, 2, 1, 28, // 64180-64189
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 64190-64199
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 64200-64209
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 64210-64219
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 64220-64229
		1, 6, 5, 4, 3, 2, 1, 34, 33, 32, // 64230-64239
		31, 30, 29, 28, 27, 26, 25, 24, 23, 22, // 64240-64249
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 64250-64259
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64260-64269
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 64270-64279
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 64280-64289
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64290-64299
		1, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 64300-64309
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 64310-64319
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 64320-64329
		3, 2, 1, 40, 39, 38, 37, 36, 35, 34, // 64330-64339
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 64340-64349
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 64350-64359
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64360-64369
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 64370-64379
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 64380-64389
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 64390-64399
		3, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 64400-64409
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 64410-64419
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64420-64429
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 64430-64439
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64440-64449
		1, 2, 1, 30, 29, 28, 27, 26, 25, 24, // 64450-64459
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 64460-64469
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64470-64479
		3, 2, 1, 6, 5, 4, 3, 2, 1, 10, // 64480-64489
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 64490-64499
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64500-64509
		3, 2, 1, 40, 39, 38, 37, 36, 35, 34, // 64510-64519
		33, 32, 31, 30, 29, 28, 27, 26, 25, 24, // 64520-64529
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 64530-64539
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64540-64549
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 64550-64559
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 64560-64569
		7, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 64570-64579
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64580-64589
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64590-64599
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 64600-64609
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 64610-64619
		1, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 64620-64629
		3, 2, 1, 28, 27, 26, 25, 24, 23, 22, // 64630-64639
		21, 20, 19, 18, 17, 16, 15, 14, 13, 12, // 64640-64649
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64650-64659
		1, 2, 1, 4, 3, 2, 1, 12, 11, 10, // 64660-64669
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 64670-64679
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64680-64689
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 64690-64699
		9, 8, 7, 6, 5, 4, 3, 2, 1, 8, // 64700-64709
		7, 6, 5, 4, 3, 2, 1, 30, 29, 28, // 64710-64719
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 64720-64729
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 64730-64739
		7, 6, 5, 4, 3, 2, 1, 16, 15, 14, // 64740-64749
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 64750-64759
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 64760-64769
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64770-64779
		1, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 64780-64789
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 64790-64799
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64800-64809
		1, 6, 5, 4, 3, 2, 1, 32, 31, 30, // 64810-64819
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 64820-64829
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 64830-64839
		9, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 64840-64849
		3, 2, 1, 18, 17, 16, 15, 14, 13, 12, // 64850-64859
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64860-64869
		1, 6, 5, 4, 3, 2, 1, 2, 1, 12, // 64870-64879
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64880-64889
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64890-64899
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 64900-64909
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 64910-64919
		1, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 64920-64929
		7, 6, 5, 4, 3, 2, 1, 14, 13, 12, // 64930-64939
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 64940-64949
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 64950-64959
		9, 8, 7, 6, 5, 4, 3, 2, 1, 28, // 64960-64969
		27, 26, 25, 24, 23, 22, 21, 20, 19, 18, // 64970-64979
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 64980-64989
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 64990-64999
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 65000-65009
		1, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 65010-65019
		7, 6, 5, 4, 3, 2, 1, 2, 1, 4, // 65020-65029
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 65030-65039
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 65040-65049
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 65050-65059
		3, 2, 1, 8, 7, 6, 5, 4, 3, 2, // 65060-65069
		1, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 65070-65079
		9, 8, 7, 6, 5, 4, 3, 2, 1, 10, // 65080-65089
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 65090-65099
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 65100-65109
		1, 8, 7, 6, 5, 4, 3, 2, 1, 4, // 65110-65119
		3, 2, 1, 6, 5, 4, 3, 2, 1, 12, // 65120-65129
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 65130-65139
		1, 6, 5, 4, 3, 2, 1, 20, 19, 18, // 65140-65149
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 65150-65159
		7, 6, 5, 4, 3, 2, 1, 4, 3, 2, // 65160-65169
		1, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 65170-65179
		3, 2, 1, 20, 19, 18, 17, 16, 15, 14, // 65180-65189
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 65190-65199
		3, 2, 1, 10, 9, 8, 7, 6, 5, 4, // 65200-65209
		3, 2, 1, 26, 25, 24, 23, 22, 21, 20, // 65210-65219
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 65220-65229
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 65230-65239
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 65240-65249
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 65250-65259
		7, 6, 5, 4, 3, 2, 1, 2, 1, 18, // 65260-65269
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 65270-65279
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 65280-65289
		3, 2, 1, 16, 15, 14, 13, 12, 11, 10, // 65290-65299
		9, 8, 7, 6, 5, 4, 3, 2, 1, 14, // 65300-65309
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 65310-65319
		3, 2, 1, 4, 3, 2, 1, 26, 25, 24, // 65320-65329
		23, 22, 21, 20, 19, 18, 17, 16, 15, 14, // 65330-65339
		13, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 65340-65349
		3, 2, 1, 4, 3, 2, 1, 14, 13, 12, // 65350-65359
		11, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 65360-65369
		1, 10, 9, 8, 7, 6, 5, 4, 3, 2, // 65370-65379
		1, 12, 11, 10, 9, 8, 7, 6, 5, 4, // 65380-65389
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 65390-65399
		7, 6, 5, 4, 3, 2, 1, 6, 5, 4, // 65400-65409
		3, 2, 1, 6, 5, 4, 3, 2, 1, 4, // 65410-65419
		3, 2, 1, 14, 13, 12, 11, 10, 9, 8, // 65420-65429
		7, 6, 5, 4, 3, 2, 1, 10, 9, 8, // 65430-65439
		7, 6, 5, 4, 3, 2, 1, 2, 1, 30, // 65440-65449
		29, 28, 27, 26, 25, 24, 23, 22, 21, 20, // 65450-65459
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 65460-65469
		9, 8, 7, 6, 5, 4, 3, 2, 1, 18, // 65470-65479
		17, 16, 15, 14, 13, 12, 11, 10, 9, 8, // 65480-65489
		7, 6, 5, 4, 3, 2, 1, 22, 21, 20, // 65490-65499
		19, 18, 17, 16, 15, 14, 13, 12, 11, 10, // 65500-65509
		9, 8, 7, 6, 5, 4, 3, 2, 1, 2, // 65510-65519
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 65520-65529
		0, 0, 0, 0, 0, 0,
	}

	lohi [256]struct{ lo, hi int }
)

func init() {
	for i, v := range liars {
		blk := v >> 24
		x := &lohi[blk]
		if x.lo == 0 || i < x.lo {
			x.lo = i
		}
		if i > x.hi {
			x.hi = i
		}
	}
}
