/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.SessionManager;
import com.sshtools.common.ui.SessionProvider;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationInternalFrame;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;

public class SessionProviderInternalFrame
extends SshToolsApplicationInternalFrame
implements SessionManager {
    private SshToolsApplicationSessionPanel panel;
    private SessionProvider provider;
    private SshToolsConnectionProfile profile;
    private SshClient ssh;
    private boolean disconnectOnClose = false;

    public SessionProviderInternalFrame(SshToolsConnectionProfile profile, SshClient ssh, SessionProvider provider) throws IOException, SshToolsApplicationException {
        try {
            this.provider = provider;
            this.ssh = ssh;
            this.profile = profile;
            this.setTitle(String.valueOf(provider.getName()) + " - " + ssh.getConnectionProperties().getHost());
            this.getContentPane().setLayout(new BorderLayout());
            this.panel = (SshToolsApplicationSessionPanel)provider.getProviderClass().newInstance();
            this.getContentPane().add((Component)this.panel, "Center");
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new SshToolsApplicationException("Failed to create instance of " + provider.getProviderClass().getName());
    }

    public boolean initFrame(SshToolsApplication app) throws IOException, SshToolsApplicationException {
        this.panel.init(app);
        this.init(app, this.panel);
        this.pack();
        return this.panel.openSession(this, this.profile);
    }

    public SshToolsApplicationSessionPanel getSessionPanel() {
        return this.panel;
    }

    public boolean canExit() {
        return this.panel.canClose();
    }

    public void exit() {
        this.panel.close();
        this.dispose();
    }

    public SessionChannelClient openSession() throws IOException {
        return this.ssh.openSessionChannel();
    }

    public int getRemoteEOL() {
        return this.ssh.getRemoteEOL();
    }

    public void applyProfileChanges(SshToolsConnectionProfile profile) {
    }

    public SftpClient openSftpClient() throws IOException {
        return this.ssh.openSftpClient();
    }

    public boolean openChannel(Channel channel) throws IOException {
        return this.ssh.openChannel(channel);
    }

    public boolean isConnected() {
        return this.ssh.isConnected();
    }

    public void setDisconnectOnClose(boolean disconnectOnClose) {
        this.disconnectOnClose = disconnectOnClose;
    }

    public boolean requestDisconnect() {
        return this.disconnectOnClose;
    }

    public ForwardingClient getForwardingClient() {
        return this.ssh.getForwardingClient();
    }

    public byte[] sendGlobalRequest(String requestname, boolean wantreply, byte[] requestdata) throws IOException {
        return this.ssh.sendGlobalRequest(requestname, wantreply, requestdata);
    }

    public void addEventHandler(SshEventAdapter eventHandler) {
        this.ssh.addEventHandler(eventHandler);
    }

    public String getServerId() {
        return this.ssh.getServerId();
    }

    public void allowChannelOpen(String channelType, ChannelFactory cf) throws IOException {
        this.ssh.allowChannelOpen(channelType, cf);
    }

    public SshToolsConnectionProfile getProfile() {
        return this.profile;
    }
}

