// Copyright 2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-pluginrpc-go. DO NOT EDIT.
//
// Source: pluginrpc/example/v1/example.proto

package examplev1pluginrpc

import (
	context "context"
	fmt "fmt"
	pluginrpc "pluginrpc.com/pluginrpc"
	v1 "pluginrpc.com/pluginrpc/internal/example/gen/pluginrpc/example/v1"
)

// This is a compile-time assertion to ensure that this generated file and the pluginrpc package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of pluginrpc newer than the one compiled into your binary. You can fix
// the problem by either regenerating this code with an older version of pluginrpc or updating the
// pluginrpc version compiled into your binary.
const _ = pluginrpc.IsAtLeastVersion0_1_0

const (
	// EchoServiceEchoRequestPath is the path of the EchoService's EchoRequest RPC.
	EchoServiceEchoRequestPath = "/pluginrpc.example.v1.EchoService/EchoRequest"
	// EchoServiceEchoErrorPath is the path of the EchoService's EchoError RPC.
	EchoServiceEchoErrorPath = "/pluginrpc.example.v1.EchoService/EchoError"
	// EchoServiceEchoListPath is the path of the EchoService's EchoList RPC.
	EchoServiceEchoListPath = "/pluginrpc.example.v1.EchoService/EchoList"
)

// EchoServiceSpecBuilder builds a Spec for the pluginrpc.example.v1.EchoService service.
type EchoServiceSpecBuilder struct {
	EchoRequest []pluginrpc.ProcedureOption
	EchoError   []pluginrpc.ProcedureOption
	EchoList    []pluginrpc.ProcedureOption
}

// Build builds a Spec for the pluginrpc.example.v1.EchoService service.
func (s EchoServiceSpecBuilder) Build() (pluginrpc.Spec, error) {
	procedures := make([]pluginrpc.Procedure, 0, 3)
	procedure, err := pluginrpc.NewProcedure(EchoServiceEchoRequestPath, s.EchoRequest...)
	if err != nil {
		return nil, err
	}
	procedures = append(procedures, procedure)
	procedure, err = pluginrpc.NewProcedure(EchoServiceEchoErrorPath, s.EchoError...)
	if err != nil {
		return nil, err
	}
	procedures = append(procedures, procedure)
	procedure, err = pluginrpc.NewProcedure(EchoServiceEchoListPath, s.EchoList...)
	if err != nil {
		return nil, err
	}
	procedures = append(procedures, procedure)
	return pluginrpc.NewSpec(procedures...)
}

// EchoServiceClient is a client for the pluginrpc.example.v1.EchoService service.
type EchoServiceClient interface {
	// Echo the request back.
	EchoRequest(context.Context, *v1.EchoRequestRequest, ...pluginrpc.CallOption) (*v1.EchoRequestResponse, error)
	// Echo the error specified back as an error.
	EchoError(context.Context, *v1.EchoErrorRequest, ...pluginrpc.CallOption) (*v1.EchoErrorResponse, error)
	// Echo a static list ["foo", "bar"] back given an empty request.
	EchoList(context.Context, *v1.EchoListRequest, ...pluginrpc.CallOption) (*v1.EchoListResponse, error)
}

// NewEchoServiceClient constructs a client for the pluginrpc.example.v1.EchoService service.
func NewEchoServiceClient(client pluginrpc.Client) (EchoServiceClient, error) {
	return &echoServiceClient{
		client: client,
	}, nil
}

// EchoServiceHandler is an implementation of the pluginrpc.example.v1.EchoService service.
type EchoServiceHandler interface {
	// Echo the request back.
	EchoRequest(context.Context, *v1.EchoRequestRequest) (*v1.EchoRequestResponse, error)
	// Echo the error specified back as an error.
	EchoError(context.Context, *v1.EchoErrorRequest) (*v1.EchoErrorResponse, error)
	// Echo a static list ["foo", "bar"] back given an empty request.
	EchoList(context.Context, *v1.EchoListRequest) (*v1.EchoListResponse, error)
}

// EchoServiceServer serves the pluginrpc.example.v1.EchoService service.
type EchoServiceServer interface {
	// Echo the request back.
	EchoRequest(context.Context, pluginrpc.HandleEnv, ...pluginrpc.HandleOption) error
	// Echo the error specified back as an error.
	EchoError(context.Context, pluginrpc.HandleEnv, ...pluginrpc.HandleOption) error
	// Echo a static list ["foo", "bar"] back given an empty request.
	EchoList(context.Context, pluginrpc.HandleEnv, ...pluginrpc.HandleOption) error
}

// NewEchoServiceServer constructs a server for the pluginrpc.example.v1.EchoService service.
func NewEchoServiceServer(handler pluginrpc.Handler, echoServiceHandler EchoServiceHandler) EchoServiceServer {
	return &echoServiceServer{
		handler:            handler,
		echoServiceHandler: echoServiceHandler,
	}
}

// RegisterEchoServiceServer registers the server for the pluginrpc.example.v1.EchoService service.
func RegisterEchoServiceServer(serverRegistrar pluginrpc.ServerRegistrar, echoServiceServer EchoServiceServer) {
	serverRegistrar.Register(EchoServiceEchoRequestPath, echoServiceServer.EchoRequest)
	serverRegistrar.Register(EchoServiceEchoErrorPath, echoServiceServer.EchoError)
	serverRegistrar.Register(EchoServiceEchoListPath, echoServiceServer.EchoList)
}

// *** PRIVATE ***

// echoServiceClient implements EchoServiceClient.
type echoServiceClient struct {
	client pluginrpc.Client
}

// EchoRequest calls pluginrpc.example.v1.EchoService.EchoRequest.
func (c *echoServiceClient) EchoRequest(ctx context.Context, req *v1.EchoRequestRequest, opts ...pluginrpc.CallOption) (*v1.EchoRequestResponse, error) {
	res := &v1.EchoRequestResponse{}
	if err := c.client.Call(ctx, EchoServiceEchoRequestPath, req, res, opts...); err != nil {
		return nil, err
	}
	return res, nil
}

// EchoError calls pluginrpc.example.v1.EchoService.EchoError.
func (c *echoServiceClient) EchoError(ctx context.Context, req *v1.EchoErrorRequest, opts ...pluginrpc.CallOption) (*v1.EchoErrorResponse, error) {
	res := &v1.EchoErrorResponse{}
	if err := c.client.Call(ctx, EchoServiceEchoErrorPath, req, res, opts...); err != nil {
		return nil, err
	}
	return res, nil
}

// EchoList calls pluginrpc.example.v1.EchoService.EchoList.
func (c *echoServiceClient) EchoList(ctx context.Context, req *v1.EchoListRequest, opts ...pluginrpc.CallOption) (*v1.EchoListResponse, error) {
	res := &v1.EchoListResponse{}
	if err := c.client.Call(ctx, EchoServiceEchoListPath, req, res, opts...); err != nil {
		return nil, err
	}
	return res, nil
}

// echoServiceServer implements EchoServiceServer.
type echoServiceServer struct {
	handler            pluginrpc.Handler
	echoServiceHandler EchoServiceHandler
}

// EchoRequest calls pluginrpc.example.v1.EchoService.EchoRequest.
func (c *echoServiceServer) EchoRequest(ctx context.Context, handleEnv pluginrpc.HandleEnv, options ...pluginrpc.HandleOption) error {
	return c.handler.Handle(
		ctx,
		handleEnv,
		&v1.EchoRequestRequest{},
		func(ctx context.Context, anyReq any) (any, error) {
			req, ok := anyReq.(*v1.EchoRequestRequest)
			if !ok {
				return nil, fmt.Errorf("could not cast %T to a *v1.EchoRequestRequest", anyReq)
			}
			return c.echoServiceHandler.EchoRequest(ctx, req)
		},
		options...,
	)
}

// EchoError calls pluginrpc.example.v1.EchoService.EchoError.
func (c *echoServiceServer) EchoError(ctx context.Context, handleEnv pluginrpc.HandleEnv, options ...pluginrpc.HandleOption) error {
	return c.handler.Handle(
		ctx,
		handleEnv,
		&v1.EchoErrorRequest{},
		func(ctx context.Context, anyReq any) (any, error) {
			req, ok := anyReq.(*v1.EchoErrorRequest)
			if !ok {
				return nil, fmt.Errorf("could not cast %T to a *v1.EchoErrorRequest", anyReq)
			}
			return c.echoServiceHandler.EchoError(ctx, req)
		},
		options...,
	)
}

// EchoList calls pluginrpc.example.v1.EchoService.EchoList.
func (c *echoServiceServer) EchoList(ctx context.Context, handleEnv pluginrpc.HandleEnv, options ...pluginrpc.HandleOption) error {
	return c.handler.Handle(
		ctx,
		handleEnv,
		&v1.EchoListRequest{},
		func(ctx context.Context, anyReq any) (any, error) {
			req, ok := anyReq.(*v1.EchoListRequest)
			if !ok {
				return nil, fmt.Errorf("could not cast %T to a *v1.EchoListRequest", anyReq)
			}
			return c.echoServiceHandler.EchoList(ctx, req)
		},
		options...,
	)
}
