/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.RTextFileChooserView;

class MouseListener
extends MouseAdapter {
    private RTextFileChooser chooser;

    public MouseListener(RTextFileChooser chooser) {
        this.chooser = chooser;
    }

    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (!(source instanceof RTextFileChooserView)) {
            return;
        }
        RTextFileChooserView view = (RTextFileChooserView)source;
        if (view.getDisplayedFileCount() > 0) {
            int clickCount;
            boolean wasButton1 = (e.getModifiers() & 0x10) == 16;
            int n = clickCount = e.getClickCount() % 2 == 0 ? 2 : 1;
            if (wasButton1 && clickCount == 2) {
                if (this.chooser.getFileSelectionMode() == 0) {
                    this.chooser.actionPerformed(new ActionEvent(view, 1001, "AcceptButtonPressed"));
                } else {
                    File file = view.getFileAtPoint(e.getPoint());
                    if (file == null) {
                        view.clearSelection();
                        return;
                    }
                    if (file.isDirectory()) {
                        this.chooser.setCurrentDirectory(file);
                        return;
                    }
                    this.chooser.actionPerformed(new ActionEvent(view, 1001, "AcceptButtonPressed"));
                }
            } else if (wasButton1 && clickCount == 1) {
                File file = view.getFileAtPoint(e.getPoint());
                if (file == null) {
                    view.clearSelection();
                    this.chooser.setEncoding(RTextFileChooser.getDefaultEncoding());
                    return;
                }
                this.chooser.updateSelectedEncoding();
            } else if (e.isPopupTrigger()) {
                Point p = e.getPoint();
                this.chooser.displayPopupMenu((JComponent)((Object)view), p.x, p.y);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        if (!(source instanceof RTextFileChooserView)) {
            return;
        }
        if (e.isPopupTrigger()) {
            Point p = e.getPoint();
            this.chooser.displayPopupMenu((JComponent)source, p.x, p.y);
        }
    }

    public void mouseReleased(MouseEvent e) {
        Object source = e.getSource();
        if (!(source instanceof RTextFileChooserView)) {
            return;
        }
        if (e.isPopupTrigger()) {
            Point p = e.getPoint();
            this.chooser.displayPopupMenu((JComponent)source, p.x, p.y);
        }
    }
}

