/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JInternalFrame;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.mainframe.IHasJDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.mainframe.WidgetUtils;
import net.sourceforge.squirrel_sql.fw.gui.CascadeInternalFramePositioner;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CascadeInternalFramesAction
extends BaseAction
implements IHasJDesktopPane {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CascadeInternalFramesAction.class);
    private IDesktopContainer _desktop;
    private IApplication _app;

    public CascadeInternalFramesAction(IApplication app) {
        this._app = app;
    }

    @Override
    public void setDesktopContainer(IDesktopContainer value) {
        this._desktop = value;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this._desktop != null && this._app.getDesktopStyle().isInternalFrameStyle()) {
            Dimension cs = null;
            CascadeInternalFramePositioner pos = new CascadeInternalFramePositioner();
            IWidget[] widgets = WidgetUtils.getOpenNonToolWindows(this._desktop.getAllWidgets());
            for (int i = widgets.length - 1; i >= 0; --i) {
                JInternalFrame child = widgets[i].getInternalFrame();
                if (cs == null && child.getParent() != null) {
                    cs = child.getParent().getSize();
                    cs.setSize((int)((double)cs.width * 0.8), (int)((double)cs.height * 0.8));
                }
                if (cs == null) continue;
                child.setSize(cs);
                pos.positionInternalFrame(child);
            }
        }
    }
}

