/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IToolkitBeepHelper;

public class BaseKeyTextHandler
extends KeyAdapter {
    boolean firstBlankText = true;

    protected void handleNotNullableField(String text, char c, KeyEvent e, IRestorableTextComponent _textComponent) {
        if (text.length() == 0) {
            if (this.firstBlankText) {
                this.firstBlankText = false;
                return;
            }
            this.firstBlankText = true;
            if (c == '\b' || c == '\u007f') {
                _textComponent.restoreText();
                e.consume();
            }
        }
    }

    protected void checkSignCharacter(KeyEvent keyEvent, JTextComponent textComponent, ColumnDisplayDefinition colDef, IToolkitBeepHelper beepHelper) {
        char c = keyEvent.getKeyChar();
        String text = textComponent.getText();
        if (this.isSignCharacter(c)) {
            int caretPosition;
            boolean ok = true;
            if (!colDef.isSigned()) {
                ok = false;
            } else if (!text.equals("<null>") && text.length() != 0 && ((caretPosition = textComponent.getCaretPosition()) != 0 || this.isSignCharacter(text.charAt(0)))) {
                ok = false;
            }
            if (!ok) {
                beepHelper.beep(textComponent);
                keyEvent.consume();
            }
        }
    }

    protected boolean isSignCharacter(char c) {
        return c == '-';
    }
}

