//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  TAGCONST.H   - include file containing the constants for Object-Based 
//                 Messaging tags
//
//  Compiler: VC
//  Version: 1.00
//  Revisions:
//

//----------
// DATA
//----------
// Data Object Descriptors
#define DOD_MASK           0x000F   // Data Object Descriptor Mask
#define DOD_Unknown        0x0000   // Unknown format 
#define DOD_ByteArray      0x0001   // Byte array of hex digits
#define DOD_Integer        0x0002   // decimal numeric value, leading zero supressed
#define DOD_String         0x0003   // printable ASCII string
#define DOD_DSROM          0x0004   // Dallas Serial ROM number uncompressed
#define DOD_DSROM_Comp     0x0005   // Dallas Serial ROM number compressed (nocrc)
#define DOD_DotDec         0x0006   // Dotted-decimal notation (as in IP addresses) NBO
#define DOD_ColHex         0x0007   // Colon delimited Hex (as in eithernet address) NBO
#define DOD_TimeDate       0x0008   // Time / Date
#define DOD_Boolean        0x0009   // flags
#define DOD_Password       0x000A   // password (not displayed or masked by * characters
#define DOD_NBO_Int        0x000B   // NBO decimal integer
 
// Data Object Modifiers
#define DOM_MASK           0x0070   // Data Object Mondifier mask
#define DOM_Unclassified   0x0000   // Unclassified modifier
#define DOM_Person         0x0010   // Noun Person
#define DOM_Place          0x0020   // Noun Place
#define DOM_Thing          0x0030   // Noun thing
#define DOM_Action         0x0040   // Verb action event
#define DOM_Status         0x0050   // Verb status (state of being)
#define DOM_Adjective      0x0060   // Adjective modifier
#define DOM_Undefined      0x0070   // Undefined

// Group Object Descriptors
#define GOD_MASK           0x80FF   // Mask to see if it is Group
#define GOD_SYS            0x0080   // System Control, administration
#define GOD_TMEX           0x0081   // Dallas Semiconductor Inc. TMEX
#define GOD_TRACK          0x0082   // Asset/People/Document Tracking
#define GOD_ACCESS         0x8082   // Access Control, Security
#define GOD_DATA           0x0083   // General Data Collection
#define GOD_SERIAL         0x0085   // Serial-to-One-Wire Bridge Applications
#define GOD_DYNDATA1       0x00FC   // Dynamic Data Objects 0x00FC - 0x00FD
#define GOD_DYNDATA2       0x00FD   // Dynamic Data Objects 0x00FC - 0x00FD
#define GOD_EXPER          0x00FE   // Experimental 0x00FC - 0x00FD
#define GOD_OBJECT         0x00C2   // Object Based

#define GROUP              0x0080   // Mask to see if it is Group
#define G_MASK             0xFF00   // Mask to see group

// Access methods
#define AM_ORDER_ROM_SWITCH_LIST    0
#define AM_TEMPERATURE_1820         1
#define AM_TEMPERATURE_18B20        2
#define AM_COUNT_VELOCITY_2423      3
#define AM_COUNT_TOTAL_2423         4
#define AM_SWITCH_2406              5
#define AM_LEVEL_2406               6
#define AM_ACTIVITY_2406            7
#define AM_SWITCH_2409              8
#define AM_LEVEL_2409               9
#define AM_ACTIVITY_2409            10
#define AM_VOLTAGE_2450             11

// output level contants
#define LV_ALWAYS                   2
#define LV_OPTIONAL                 1
#define LV_VERBOSE                  0


