/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Hashtable;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.latex.style.StyleMap;
import writer2latex.office.FontDeclaration;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class CharStyleConverter
extends StyleConverter {
    private Hashtable fontDecls = new Hashtable();
    private boolean bUseColor;
    private boolean bIgnoreHardFontsize;
    private boolean bIgnoreFontsize;
    private boolean bIgnoreFont;
    private boolean bIgnoreAll;
    private boolean bUseUlem;
    private boolean bNeedUlem = false;
    private boolean bNeedSubscript = false;

    public CharStyleConverter(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        super(wsc, config, palette);
        this.bUseColor = config.useColor();
        this.bUseUlem = config.useUlem();
        this.bIgnoreAll = config.formatting() == 0;
        this.bIgnoreFont = config.formatting() <= 1;
        this.bIgnoreFontsize = config.formatting() <= 2;
        this.bIgnoreHardFontsize = config.formatting() <= 3;
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bUseColor) {
            pack.append("\\usepackage{color}").nl();
        }
        if (this.bNeedUlem) {
            pack.append("\\usepackage[normalem]{ulem}").nl();
        }
        if (this.bNeedSubscript) {
            decl.append("\\newcommand\\textsubscript[1]{\\ensuremath{{}_{\\text{#1}}}}").nl();
        }
        if (!this.styleNames.isEmpty()) {
            decl.append("% Text styles").nl().append(this.declarations);
        }
    }

    public void applyTextStyle(String sName, BeforeAfter ba, Context context) {
        if (sName == null || this.bIgnoreAll) {
            return;
        }
        if (this.styleMap.contains(sName)) {
            ba.add(this.styleMap.getBefore(sName), this.styleMap.getAfter(sName));
            context.updateFormattingFromStyle(this.wsc.getTextStyle(sName));
            StyleMap sm = this.config.getTextStyleMap();
            context.setVerbatim(sm.contains(sName) && sm.getVerbatim(sName));
            return;
        }
        StyleMap sm = this.config.getTextStyleMap();
        if (sm.contains(sName)) {
            this.styleMap.put(sName, sm.getBefore(sName), sm.getAfter(sName));
            this.applyTextStyle(sName, ba, context);
            return;
        }
        StyleWithProperties style = this.wsc.getTextStyle(sName);
        if (style == null) {
            this.styleMap.put(sName, "", "");
            this.applyTextStyle(sName, ba, context);
            return;
        }
        if (style.isAutomatic()) {
            this.palette.getI18n().applyLanguage(style, false, true, ba);
            this.applyFont(style, false, true, ba, context);
            this.applyFontEffects(style, true, ba);
            context.updateFormattingFromStyle(this.wsc.getTextStyle(sName));
            return;
        }
        BeforeAfter baText = new BeforeAfter();
        this.palette.getI18n().applyLanguage(style, false, true, baText);
        this.applyFont(style, false, true, baText, new Context());
        this.applyFontEffects(style, true, baText);
        String sTeXName = this.styleNames.getExportName(sName);
        this.styleMap.put(sName, "\\textstyle" + sTeXName + "{", "}");
        this.declarations.append("\\newcommand\\textstyle").append(sTeXName).append("[1]{").append(baText.getBefore()).append("#1").append(baText.getAfter()).append("}").nl();
        this.applyTextStyle(sName, ba, context);
    }

    public String getFontName(String sStyleName) {
        StyleWithProperties style = this.wsc.getTextStyle(sStyleName);
        if (style == null) {
            return null;
        }
        String sName = style.getProperty("style:font-name");
        if (sName == null) {
            return null;
        }
        FontDeclaration fd = this.wsc.getFontDeclaration(sName);
        if (fd == null) {
            return null;
        }
        return fd.getProperty("fo:font-family");
    }

    public void applyHardCharFormatting(StyleWithProperties style, BeforeAfter ba) {
        this.palette.getI18n().applyLanguage(style, true, false, ba);
        this.applyFont(style, true, false, ba, new Context());
        if (!ba.isEmpty()) {
            ba.add(" ", "");
        }
    }

    public void applyFont(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null) {
            return;
        }
        this.applyNfssSize(style, bDecl, bInherit, ba, context);
        this.applyNfssFamily(style, bDecl, bInherit, ba, context);
        this.applyNfssSeries(style, bDecl, bInherit, ba, context);
        this.applyNfssShape(style, bDecl, bInherit, ba, context);
        this.applyColor(style, bDecl, bInherit, ba, context);
    }

    public void applyNormalFont(BeforeAfter ba) {
        if (this.bUseColor) {
            ba.add("\\normalfont\\normalsize\\normalcolor", "");
        } else {
            ba.add("\\normalfont\\normalsize", "");
        }
    }

    public void applyDefaultFont(StyleWithProperties style, LaTeXDocumentPortion ldp) {
        if (style == null) {
            return;
        }
        String s = this.convertFontDeclaration(style.getProperty("style:font-name"));
        if (s != null) {
            ldp.append("\\renewcommand\\familydefault{\\").append(s).append("default}").nl();
        }
        if ((s = CharStyleConverter.nfssSeries(style.getProperty("fo:font-weight"))) != null) {
            ldp.append("\\renewcommand\\seriesdefault{\\").append(s).append("default}").nl();
        }
        if ((s = CharStyleConverter.nfssShape(style.getProperty("fo:font-variant"), style.getProperty("fo:font-style"))) != null) {
            ldp.append("\\renewcommand\\shapedefault{\\").append(s).append("default}").nl();
        }
        if (this.bUseColor && (s = CharStyleConverter.color(style.getProperty("fo:color"))) != null) {
            ldp.append("\\renewcommand\\normalcolor{\\color").append(s).append("}").nl();
        }
    }

    public void applyFontEffects(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null) {
            return;
        }
        this.applyTextPosition(style, bInherit, ba);
        this.applyUnderline(style, bInherit, ba);
        this.applyCrossout(style, bInherit, ba);
        this.applyChangeCase(style, bInherit, ba);
    }

    public void applyColor(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null || !this.bUseColor || this.bIgnoreAll) {
            return;
        }
        String sColor = CharStyleConverter.color(style.getProperty("fo:color", bInherit));
        if (sColor == null) {
            return;
        }
        if (sColor.equals(CharStyleConverter.color(context.getFontColor()))) {
            return;
        }
        if (bDecl) {
            ba.add("\\color" + sColor, "");
        } else {
            ba.add("\\textcolor" + sColor + "{", "}");
        }
    }

    public void applyThisColor(String sColor, boolean bDecl, BeforeAfter ba) {
        if (sColor == null || !this.bUseColor || this.bIgnoreAll) {
            return;
        }
        String s = CharStyleConverter.color(sColor);
        if (s == null) {
            return;
        }
        if (bDecl) {
            ba.add("\\color" + s, "");
        } else {
            ba.add("\\textcolor" + s + "{", "}");
        }
    }

    private void applyNfssFamily(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null || this.bIgnoreFont) {
            return;
        }
        String sFontName = style.getProperty("style:font-name", bInherit);
        if (sFontName != null) {
            String sFamily = this.convertFontDeclaration(sFontName);
            if (sFamily == null) {
                return;
            }
            if (sFamily.equals(this.convertFontDeclaration(context.getFontName()))) {
                return;
            }
            if (bDecl) {
                ba.add("\\" + sFamily + "family", "");
            } else {
                ba.add("\\text" + sFamily + "{", "}");
            }
        }
    }

    private void applyNfssSeries(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String sSeries = CharStyleConverter.nfssSeries(style.getProperty("fo:font-weight", bInherit));
        if (sSeries == null) {
            return;
        }
        if (sSeries.equals(CharStyleConverter.nfssSeries(context.getFontWeight()))) {
            return;
        }
        if (bDecl) {
            ba.add("\\" + sSeries + "series", "");
        } else {
            ba.add("\\text" + sSeries + "{", "}");
        }
    }

    private void applyNfssShape(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String sShape = CharStyleConverter.nfssShape(style.getProperty("fo:font-variant", bInherit), style.getProperty("fo:font-style", bInherit));
        if (sShape == null) {
            return;
        }
        if (sShape.equals(CharStyleConverter.nfssShape(context.getFontVariant(), context.getFontStyle()))) {
            return;
        }
        if (bDecl) {
            ba.add("\\" + sShape + "shape", "");
        } else {
            ba.add("\\text" + sShape + "{", "}");
        }
    }

    private void applyNfssSize(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (style == null || this.bIgnoreFontsize || this.bIgnoreHardFontsize && style.isAutomatic()) {
            return;
        }
        if (style.getProperty("fo:font-size", bInherit) == null) {
            return;
        }
        String sSize = CharStyleConverter.nfssSize(style.getAbsoluteProperty("fo:font-size"));
        if (sSize == null) {
            return;
        }
        if (sSize.equals(CharStyleConverter.nfssSize(context.getFontSize()))) {
            return;
        }
        if (bDecl) {
            ba.add(sSize, "");
        } else {
            ba.add("{" + sSize + " ", "}");
        }
    }

    private void applyTextPosition(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String s = this.textPosition(style.getProperty("style:text-position", bInherit));
        if (s != null) {
            ba.add(s + "{", "}");
        }
    }

    private void applyUnderline(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null || !this.bUseUlem) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String s = CharStyleConverter.underline(style.getProperty("style:text-underline", bInherit));
        if (s != null) {
            this.bNeedUlem = true;
            ba.add(s + "{", "}");
        }
    }

    private void applyCrossout(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null || !this.bUseUlem) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String s = CharStyleConverter.crossout(style.getProperty("style:text-crossing-out", bInherit));
        if (s != null) {
            this.bNeedUlem = true;
            ba.add(s + "{", "}");
        }
    }

    private void applyChangeCase(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        if (style == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String s = CharStyleConverter.changeCase(style.getProperty("fo:text-transform"));
        if (s != null) {
            ba.add(s + "{", "}");
        }
    }

    private String convertFontDeclaration(String sName) {
        FontDeclaration fd = this.wsc.getFontDeclaration(sName);
        if (fd == null) {
            return null;
        }
        if (!this.fontDecls.containsKey(sName)) {
            String sFontFamily = fd.getProperty("fo:font-family");
            String sFontPitch = fd.getProperty("style:font-pitch");
            String sFontFamilyGeneric = fd.getProperty("style:font-family-generic");
            this.fontDecls.put(sName, CharStyleConverter.nfssFamily(sFontFamily, sFontFamilyGeneric, sFontPitch));
        }
        return (String)this.fontDecls.get(sName);
    }

    private static final String nfssFamily(String sFontFamily, String sFontFamilyGeneric, String sFontPitch) {
        if ("fixed".equals(sFontPitch)) {
            return "tt";
        }
        if ("modern".equals(sFontFamilyGeneric)) {
            return "tt";
        }
        if ("swiss".equals(sFontFamilyGeneric)) {
            return "sf";
        }
        return "rm";
    }

    private static final String nfssSeries(String sFontWeight) {
        if (sFontWeight == null) {
            return null;
        }
        if ("bold".equals(sFontWeight)) {
            return "bf";
        }
        return "md";
    }

    private static final String nfssShape(String sFontVariant, String sFontStyle) {
        if (sFontVariant == null && sFontStyle == null) {
            return null;
        }
        if ("small-caps".equals(sFontVariant)) {
            return "sc";
        }
        if ("italic".equals(sFontStyle)) {
            return "it";
        }
        if ("oblique".equals(sFontStyle)) {
            return "sl";
        }
        return "up";
    }

    private static final String nfssSize(String sFontSize) {
        if (sFontSize == null) {
            return null;
        }
        return "\\fontsize{" + sFontSize + "}{" + Misc.multiply("120%", sFontSize) + "}\\selectfont";
    }

    private static final String color(String sColor) {
        float sBlue;
        float sGreen;
        if ("#000000".equalsIgnoreCase(sColor)) {
            return "{black}";
        }
        if ("#ff0000".equalsIgnoreCase(sColor)) {
            return "{red}";
        }
        if ("#00ff00".equalsIgnoreCase(sColor)) {
            return "{green}";
        }
        if ("#0000ff".equalsIgnoreCase(sColor)) {
            return "{blue}";
        }
        if ("#ffff00".equalsIgnoreCase(sColor)) {
            return "{yellow}";
        }
        if ("#ff00ff".equalsIgnoreCase(sColor)) {
            return "{magenta}";
        }
        if ("#00ffff".equalsIgnoreCase(sColor)) {
            return "{cyan}";
        }
        if (sColor == null || sColor.length() != 7) {
            return null;
        }
        float sRed = (float)Misc.getIntegerFromHex(sColor.substring(1, 3), 0) / 255.0f;
        if ((double)(sRed + (sGreen = (float)Misc.getIntegerFromHex(sColor.substring(3, 5), 0) / 255.0f) + (sBlue = (float)Misc.getIntegerFromHex(sColor.substring(5, 7), 0) / 255.0f)) > 2.7) {
            return "{black}";
        }
        return "[rgb]{" + sRed + "," + sGreen + "," + sBlue + "}";
    }

    private final String textPosition(String sTextPosition) {
        if (sTextPosition == null) {
            return null;
        }
        if (sTextPosition.startsWith("super")) {
            return "\\textsuperscript";
        }
        if (sTextPosition.startsWith("sub") || sTextPosition.startsWith("-")) {
            this.bNeedSubscript = true;
            return "\\textsubscript";
        }
        if (sTextPosition.startsWith("0%")) {
            return null;
        }
        return "\\textsuperscript";
    }

    private static final String underline(String sUnderline) {
        if (sUnderline == null) {
            return null;
        }
        if (sUnderline.equals("none")) {
            return null;
        }
        if (sUnderline.indexOf("wave") >= 0) {
            return "\\uwave";
        }
        return "\\uline";
    }

    private static final String crossout(String sCrossout) {
        if (sCrossout == null) {
            return null;
        }
        if (sCrossout.equals("X")) {
            return "\\xout";
        }
        if (sCrossout.equals("slash")) {
            return "\\xout";
        }
        return "\\sout";
    }

    private static final String changeCase(String sTextTransform) {
        if ("lowercase".equals(sTextTransform)) {
            return "\\MakeLowercase";
        }
        if ("uppercase".equals(sTextTransform)) {
            return "\\MakeUppercase";
        }
        return null;
    }
}

