/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.math.field;

import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldException;
import iaik.security.ecc.math.field.FieldFactory;
import iaik.security.ecc.parameter.ECCParameters;
import iaik.security.ecc.util.Utils;
import java.math.BigInteger;
import java.util.Hashtable;

public abstract class PrimeFieldFactory
implements FieldFactory {
    static /* synthetic */ Class class$iaik$security$ecc$math$field$SimplePrimeFieldFactory;
    static /* synthetic */ Class class$iaik$security$ecc$math$field$FastPrimeFieldFactory;
    protected BigInteger modulus_ = null;
    protected static final BigInteger p521_;
    protected static final BigInteger p384_;
    protected static final BigInteger p256_;
    protected static final BigInteger p224_;
    protected static final BigInteger p192_;
    private static Hashtable factoryInstances_;
    private static Class defaultFactory_;

    static {
        factoryInstances_ = new Hashtable();
        defaultFactory_ = Utils.isSpeedUpEnabled() ? (class$iaik$security$ecc$math$field$FastPrimeFieldFactory == null ? (class$iaik$security$ecc$math$field$FastPrimeFieldFactory = PrimeFieldFactory.class$("iaik.security.ecc.math.field.FastPrimeFieldFactory")) : class$iaik$security$ecc$math$field$FastPrimeFieldFactory) : (class$iaik$security$ecc$math$field$SimplePrimeFieldFactory == null ? (class$iaik$security$ecc$math$field$SimplePrimeFieldFactory = PrimeFieldFactory.class$("iaik.security.ecc.math.field.SimplePrimeFieldFactory")) : class$iaik$security$ecc$math$field$SimplePrimeFieldFactory);
        p192_ = ECCParameters.PRIME_P[0];
        p224_ = ECCParameters.PRIME_P[3];
        p256_ = ECCParameters.PRIME_P[7];
        p384_ = ECCParameters.PRIME_P[8];
        p521_ = ECCParameters.PRIME_P[9];
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void setModulus(BigInteger bigInteger) {
        this.modulus_ = bigInteger;
    }

    public abstract Field getField();

    public static synchronized void setDefaultFactory(Class clazz, BigInteger bigInteger) throws FieldException {
        if (bigInteger == null) {
            defaultFactory_ = clazz;
        } else {
            try {
                if (clazz == null) {
                    factoryInstances_.remove(bigInteger);
                } else {
                    PrimeFieldFactory primeFieldFactory = (PrimeFieldFactory)clazz.newInstance();
                    factoryInstances_.put(bigInteger, primeFieldFactory);
                }
            }
            catch (Exception exception) {
                throw new FieldException("PrimeFieldFactory.1");
            }
        }
    }

    public static synchronized FieldFactory getInstance(BigInteger bigInteger) throws FieldException {
        PrimeFieldFactory primeFieldFactory;
        if (bigInteger == null) {
            throw new FieldException("modulus undefined");
        }
        try {
            if (factoryInstances_.containsKey(bigInteger)) {
                primeFieldFactory = (PrimeFieldFactory)factoryInstances_.get(bigInteger);
                primeFieldFactory.setModulus(bigInteger);
            } else {
                Class clazz = defaultFactory_;
                primeFieldFactory = (PrimeFieldFactory)clazz.newInstance();
                primeFieldFactory.setModulus(bigInteger);
                factoryInstances_.put(bigInteger, primeFieldFactory);
            }
        }
        catch (Exception exception) {
            throw new FieldException("PrimeFieldFactory.1");
        }
        return primeFieldFactory;
    }
}

