/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.util;

import iaik.security.ecc.math.ecgroup.Coordinate;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.field.Constants;
import java.math.BigInteger;

public class Transforms {
    public static BigInteger xToBigInteger(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return Constants.BIG_ZERO;
        }
        Coordinate coordinate = eCPoint.getCoordinates();
        coordinate = coordinate.toAffine();
        return coordinate.getX().toBigInt();
    }

    public static byte[] i2osp(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        int n3 = 0;
        if (byArray[0] == 0) {
            --n2;
            ++n3;
        }
        if (n2 < n) {
            n2 = n;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, n2 - byArray.length + n3, byArray.length - n3);
        int n4 = 0;
        while (n4 < n2 - byArray.length + n3) {
            byArray2[n4] = 0;
            ++n4;
        }
        return byArray2;
    }
}

