/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public final class BaseDir {
    private static BaseDir instance;

    public static synchronized BaseDir getInstance() {
        if (instance == null) {
            instance = new BaseDir();
        }
        return instance;
    }

    public String getUserDataDir() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getenv("XDG_DATA_HOME");
            }
        });
        if (string == null) {
            string = AccessController.doPrivileged(new GetPropertyAction("user.home")) + File.separatorChar + ".local" + File.separatorChar + "share";
        }
        if (!this.checkDir(string)) {
            string = null;
        }
        return string;
    }

    public String getUserConfigDir() {
        return System.getProperty("user.home") + File.separatorChar + ".config";
    }

    public String getSystemDataDir() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getenv("XDG_DATA_HOME");
            }
        });
        if (string == null) {
            string = File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "share" + File.pathSeparatorChar + File.separatorChar + "usr" + File.separatorChar + "share";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        String string2 = null;
        while (string2 == null && listIterator.hasPrevious()) {
            String string3 = (String)listIterator.previous();
            if (!this.checkDir(string3)) continue;
            string2 = string3;
        }
        return string2;
    }

    public String[] getSystemDataDirs() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getenv("XDG_DATA_HOME");
            }
        });
        if (string == null) {
            string = File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "share" + File.pathSeparatorChar + File.separatorChar + "usr" + File.separatorChar + "share";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean checkDir(String string) {
        File file = new File(string);
        return file.isDirectory() && file.canRead() && file.canWrite();
    }
}

