/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;

final class AlpnExtension {
    static final HandshakeProducer chNetworkProducer = new CHAlpnProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHAlpnConsumer();
    static final HandshakeAbsence chOnLoadAbsence = new CHAlpnAbsence();
    static final HandshakeProducer shNetworkProducer = new SHAlpnProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHAlpnConsumer();
    static final HandshakeAbsence shOnLoadAbsence = new SHAlpnAbsence();
    static final HandshakeProducer eeNetworkProducer = new SHAlpnProducer();
    static final SSLExtension.ExtensionConsumer eeOnLoadConsumer = new SHAlpnConsumer();
    static final HandshakeAbsence eeOnLoadAbsence = new SHAlpnAbsence();
    static final SSLStringizer alpnStringizer = new AlpnStringizer();

    AlpnExtension() {
    }

    private static final class SHAlpnAbsence
    implements HandshakeAbsence {
        private SHAlpnAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.applicationProtocol = "";
            clientHandshakeContext.conContext.applicationProtocol = "";
        }
    }

    private static final class SHAlpnConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHAlpnConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            AlpnSpec alpnSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            AlpnSpec alpnSpec2 = (AlpnSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_ALPN);
            if (alpnSpec2 == null || alpnSpec2.applicationProtocols == null || alpnSpec2.applicationProtocols.isEmpty()) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected " + SSLExtension.CH_ALPN.name + " extension");
            }
            try {
                alpnSpec = new AlpnSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            if (alpnSpec.applicationProtocols.size() != 1) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid " + SSLExtension.CH_ALPN.name + " extension: Only one application protocol name is allowed in ServerHello message");
            }
            if (!alpnSpec2.applicationProtocols.containsAll(alpnSpec.applicationProtocols)) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid " + SSLExtension.CH_ALPN.name + " extension: Only client specified application protocol is allowed in ServerHello message");
            }
            clientHandshakeContext.conContext.applicationProtocol = clientHandshakeContext.applicationProtocol = alpnSpec.applicationProtocols.get(0);
            clientHandshakeContext.handshakeExtensions.remove(SSLExtension.CH_ALPN);
        }
    }

    private static final class SHAlpnProducer
    implements HandshakeProducer {
        private SHAlpnProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            AlpnSpec alpnSpec = (AlpnSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_ALPN);
            if (alpnSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.SH_ALPN.name, new Object[0]);
                }
                serverHandshakeContext.applicationProtocol = "";
                serverHandshakeContext.conContext.applicationProtocol = "";
                return null;
            }
            List<String> list = alpnSpec.applicationProtocols;
            if (serverHandshakeContext.conContext.transport instanceof SSLEngine) {
                if (serverHandshakeContext.sslConfig.engineAPSelector != null) {
                    object = (SSLEngine)((Object)serverHandshakeContext.conContext.transport);
                    serverHandshakeContext.applicationProtocol = serverHandshakeContext.sslConfig.engineAPSelector.apply((SSLEngine)object, list);
                    if (serverHandshakeContext.applicationProtocol == null || !serverHandshakeContext.applicationProtocol.isEmpty() && !list.contains(serverHandshakeContext.applicationProtocol)) {
                        serverHandshakeContext.conContext.fatal(Alert.NO_APPLICATION_PROTOCOL, "No matching application layer protocol values");
                    }
                }
            } else if (serverHandshakeContext.sslConfig.socketAPSelector != null) {
                object = (SSLSocket)((Object)serverHandshakeContext.conContext.transport);
                serverHandshakeContext.applicationProtocol = serverHandshakeContext.sslConfig.socketAPSelector.apply((SSLSocket)object, list);
                if (serverHandshakeContext.applicationProtocol == null || !serverHandshakeContext.applicationProtocol.isEmpty() && !list.contains(serverHandshakeContext.applicationProtocol)) {
                    serverHandshakeContext.conContext.fatal(Alert.NO_APPLICATION_PROTOCOL, "No matching application layer protocol values");
                }
            }
            if (serverHandshakeContext.applicationProtocol == null || serverHandshakeContext.applicationProtocol.isEmpty()) {
                serverHandshakeContext.applicationProtocol = "";
                serverHandshakeContext.conContext.applicationProtocol = "";
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Ignore, no negotiated application layer protocol", new Object[0]);
                }
                return null;
            }
            int n = serverHandshakeContext.applicationProtocol.length() + 1;
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            Record.putBytes8(byteBuffer, serverHandshakeContext.applicationProtocol.getBytes(StandardCharsets.UTF_8));
            serverHandshakeContext.conContext.applicationProtocol = serverHandshakeContext.applicationProtocol;
            serverHandshakeContext.handshakeExtensions.remove(SSLExtension.CH_ALPN);
            return byArray;
        }
    }

    private static final class CHAlpnAbsence
    implements HandshakeAbsence {
        private CHAlpnAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.applicationProtocol = "";
            serverHandshakeContext.conContext.applicationProtocol = "";
        }
    }

    private static final class CHAlpnConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHAlpnConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            AlpnSpec alpnSpec;
            boolean bl;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_ALPN)) {
                serverHandshakeContext.applicationProtocol = "";
                serverHandshakeContext.conContext.applicationProtocol = "";
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.info("Ignore server unavailable extension: " + SSLExtension.CH_ALPN.name, new Object[0]);
                }
                return;
            }
            boolean bl2 = serverHandshakeContext.conContext.transport instanceof SSLEngine ? serverHandshakeContext.sslConfig.engineAPSelector == null : serverHandshakeContext.sslConfig.socketAPSelector == null;
            boolean bl3 = bl = serverHandshakeContext.sslConfig.applicationProtocols == null || serverHandshakeContext.sslConfig.applicationProtocols.length == 0;
            if (bl2 && bl) {
                serverHandshakeContext.applicationProtocol = "";
                serverHandshakeContext.conContext.applicationProtocol = "";
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore server unenabled extension: " + SSLExtension.CH_ALPN.name, new Object[0]);
                }
                return;
            }
            try {
                alpnSpec = new AlpnSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            if (bl2) {
                List<String> list = alpnSpec.applicationProtocols;
                boolean bl4 = false;
                for (String string : serverHandshakeContext.sslConfig.applicationProtocols) {
                    if (!list.contains(string)) continue;
                    serverHandshakeContext.applicationProtocol = string;
                    serverHandshakeContext.conContext.applicationProtocol = string;
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    serverHandshakeContext.conContext.fatal(Alert.NO_APPLICATION_PROTOCOL, "No matching application layer protocol values");
                }
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_ALPN, alpnSpec);
        }
    }

    private static final class CHAlpnProducer
    implements HandshakeProducer {
        static final int MAX_AP_LENGTH = 255;
        static final int MAX_AP_LIST_LENGTH = 65535;

        private CHAlpnProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_ALPN)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.info("Ignore client unavailable extension: " + SSLExtension.CH_ALPN.name, new Object[0]);
                }
                clientHandshakeContext.applicationProtocol = "";
                clientHandshakeContext.conContext.applicationProtocol = "";
                return null;
            }
            Object[] objectArray = clientHandshakeContext.sslConfig.applicationProtocols;
            if (objectArray == null || objectArray.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.info("No available application protocols", new Object[0]);
                }
                return null;
            }
            int n = 0;
            for (String string : objectArray) {
                int n2 = string.getBytes(StandardCharsets.UTF_8).length;
                if (n2 == 0) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.severe("Application protocol name cannot be empty", new Object[0]);
                    }
                    clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Application protocol name cannot be empty");
                }
                if (n2 <= 255) {
                    n += n2 + 1;
                } else {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.severe("Application protocol name (" + string + ") exceeds the size limit (" + 255 + " bytes)", new Object[0]);
                    }
                    clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Application protocol name (" + string + ") exceeds the size limit (" + 255 + " bytes)");
                }
                if (n <= 65535) continue;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.severe("The configured application protocols (" + Arrays.toString(objectArray) + ") exceed the size limit (" + 65535 + " bytes)", new Object[0]);
                }
                clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "The configured application protocols (" + Arrays.toString(objectArray) + ") exceed the size limit (" + 65535 + " bytes)");
            }
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (String string : objectArray) {
                Record.putBytes8(byteBuffer, string.getBytes(StandardCharsets.UTF_8));
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_ALPN, new AlpnSpec(clientHandshakeContext.sslConfig.applicationProtocols));
            return byArray;
        }
    }

    private static final class AlpnStringizer
    implements SSLStringizer {
        private AlpnStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new AlpnSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class AlpnSpec
    implements SSLExtension.SSLExtensionSpec {
        final List<String> applicationProtocols;

        private AlpnSpec(String[] stringArray) {
            this.applicationProtocols = Collections.unmodifiableList(Arrays.asList(stringArray));
        }

        private AlpnSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid application_layer_protocol_negotiation: insufficient data (length=" + byteBuffer.remaining() + ")");
            }
            int n = Record.getInt16(byteBuffer);
            if (n < 2 || n != byteBuffer.remaining()) {
                throw new SSLProtocolException("Invalid application_layer_protocol_negotiation: incorrect list length (length=" + n + ")");
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            while (byteBuffer.hasRemaining()) {
                byte[] byArray = Record.getBytes8(byteBuffer);
                if (byArray.length == 0) {
                    throw new SSLProtocolException("Invalid application_layer_protocol_negotiation extension: empty application protocol name");
                }
                String string = new String(byArray, StandardCharsets.UTF_8);
                linkedList.add(string);
            }
            this.applicationProtocols = Collections.unmodifiableList(linkedList);
        }

        public String toString() {
            return this.applicationProtocols.toString();
        }
    }
}

