/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLRecord;

final class SSLSocketInputRecord
extends InputRecord
implements SSLRecord {
    private InputStream is = null;
    private OutputStream os = null;
    private final byte[] header = new byte[5];
    private int headerOff = 0;
    private ByteBuffer recordBody = ByteBuffer.allocate(1024);
    private boolean formatVerified = false;
    private ByteBuffer handshakeBuffer = null;

    SSLSocketInputRecord(HandshakeHash handshakeHash) {
        super(handshakeHash, SSLCipher.SSLReadCipher.nullTlsReadCipher());
    }

    @Override
    int bytesInCompletePacket() throws IOException {
        try {
            this.readHeader();
        }
        catch (EOFException eOFException) {
            return -1;
        }
        byte by = this.header[0];
        int n = 0;
        if (this.formatVerified || by == ContentType.HANDSHAKE.id || by == ContentType.ALERT.id) {
            if (!ProtocolVersion.isNegotiable(this.header[1], this.header[2], false)) {
                throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(this.header[1], this.header[2]) + " , plaintext connection?");
            }
            this.formatVerified = true;
            n = ((this.header[3] & 0xFF) << 8) + (this.header[4] & 0xFF) + 5;
        } else {
            boolean bl;
            boolean bl2 = bl = (by & 0x80) != 0;
            if (bl && (this.header[2] == 1 || this.header[2] == 4)) {
                if (!ProtocolVersion.isNegotiable(this.header[3], this.header[4], false)) {
                    throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(this.header[3], this.header[4]) + " , plaintext connection?");
                }
                n = ((by & 0x7F) << 8) + (this.header[1] & 0xFF) + 2;
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return n;
    }

    @Override
    Plaintext[] decode(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException, BadPaddingException {
        if (this.isClosed) {
            return null;
        }
        this.readHeader();
        Plaintext[] plaintextArray = null;
        boolean bl = true;
        try {
            if (!this.formatVerified) {
                this.formatVerified = true;
                if (this.header[0] != ContentType.HANDSHAKE.id && this.header[0] != ContentType.ALERT.id) {
                    plaintextArray = this.handleUnknownRecord();
                }
            }
            if (plaintextArray == null) {
                plaintextArray = this.decodeInputRecord();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            bl = false;
            throw interruptedIOException;
        }
        finally {
            if (bl) {
                this.headerOff = 0;
                this.recordBody.clear();
            }
        }
        return plaintextArray;
    }

    @Override
    void setReceiverStream(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    void setDeliverStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    private Plaintext[] decodeInputRecord() throws IOException, BadPaddingException {
        ByteBuffer byteBuffer;
        Object object;
        byte by = this.header[0];
        byte by2 = this.header[1];
        byte by3 = this.header[2];
        int n = ((this.header[3] & 0xFF) << 8) + (this.header[4] & 0xFF);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("READ: " + ProtocolVersion.nameOf(by2, by3) + " " + ContentType.nameOf(by) + ", length = " + n, new Object[0]);
        }
        if (n < 0 || n > 33088) {
            throw new SSLProtocolException("Bad input record size, TLSCiphertext.length = " + n);
        }
        if (this.recordBody.position() == 0) {
            if (this.recordBody.capacity() < n) {
                this.recordBody = ByteBuffer.allocate(n);
            }
            this.recordBody.limit(n);
        } else {
            n = this.recordBody.remaining();
        }
        this.readFully(n);
        this.recordBody.flip();
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("READ: " + ProtocolVersion.nameOf(by2, by3) + " " + ContentType.nameOf(by) + ", length = " + this.recordBody.remaining(), new Object[0]);
        }
        try {
            object = this.readCipher.decrypt(by, this.recordBody, null);
            byteBuffer = ((Plaintext)object).fragment;
            by = ((Plaintext)object).contentType;
        }
        catch (BadPaddingException badPaddingException) {
            throw badPaddingException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLProtocolException)new SSLProtocolException("Unexpected exception").initCause(generalSecurityException);
        }
        if (by != ContentType.HANDSHAKE.id && this.handshakeBuffer != null && this.handshakeBuffer.hasRemaining()) {
            throw new SSLProtocolException("Expecting a handshake fragment, but received " + ContentType.nameOf(by));
        }
        if (by == ContentType.HANDSHAKE.id) {
            Object object2;
            object = byteBuffer;
            if (this.handshakeBuffer != null && this.handshakeBuffer.remaining() != 0) {
                object2 = ByteBuffer.wrap(new byte[this.handshakeBuffer.remaining() + byteBuffer.remaining()]);
                ((ByteBuffer)object2).put(this.handshakeBuffer);
                ((ByteBuffer)object2).put(byteBuffer);
                object = (ByteBuffer)((ByteBuffer)object2).rewind();
                this.handshakeBuffer = null;
            }
            object2 = new ArrayList(5);
            while (((Buffer)object).hasRemaining()) {
                int n2 = ((Buffer)object).remaining();
                if (n2 < 4) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[n2]);
                    this.handshakeBuffer.put((ByteBuffer)object);
                    this.handshakeBuffer.rewind();
                    break;
                }
                ((ByteBuffer)object).mark();
                byte by4 = ((ByteBuffer)object).get();
                if (!SSLHandshake.isKnown(by4)) {
                    throw new SSLProtocolException("Unknown handshake type size, Handshake.msg_type = " + (by4 & 0xFF));
                }
                int n3 = Record.getInt24((ByteBuffer)object);
                ((ByteBuffer)object).reset();
                int n4 = 4 + n3;
                if (n2 < n4) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[n2]);
                    this.handshakeBuffer.put((ByteBuffer)object);
                    this.handshakeBuffer.rewind();
                    break;
                }
                if (n2 == n4) {
                    if (this.handshakeHash.isHashable(by4)) {
                        this.handshakeHash.receive((ByteBuffer)object);
                    }
                    ((ArrayList)object2).add(new Plaintext(by, by2, by3, -1, -1L, (ByteBuffer)object));
                    break;
                }
                int n5 = ((Buffer)object).position();
                int n6 = ((Buffer)object).limit();
                int n7 = n5 + n4;
                ((ByteBuffer)object).limit(n7);
                if (this.handshakeHash.isHashable(by4)) {
                    this.handshakeHash.receive((ByteBuffer)object);
                }
                ((ArrayList)object2).add(new Plaintext(by, by2, by3, -1, -1L, ((ByteBuffer)object).slice()));
                ((ByteBuffer)object).position(n7);
                ((ByteBuffer)object).limit(n6);
            }
            return ((ArrayList)object2).toArray(new Plaintext[0]);
        }
        return new Plaintext[]{new Plaintext(by, by2, by3, -1, -1L, byteBuffer)};
    }

    private Plaintext[] handleUnknownRecord() throws IOException, BadPaddingException {
        byte by = this.header[0];
        byte by2 = this.header[2];
        if ((by & 0x80) != 0 && by2 == 1) {
            if (this.helloVersion != ProtocolVersion.SSL20Hello) {
                throw new SSLHandshakeException("SSLv2Hello is not enabled");
            }
            byte by3 = this.header[3];
            byte by4 = this.header[4];
            if (by3 == ProtocolVersion.SSL20Hello.major && by4 == ProtocolVersion.SSL20Hello.minor) {
                this.os.write(SSLRecord.v2NoCipher);
                if (SSLLogger.isOn) {
                    if (SSLLogger.isOn("record")) {
                        SSLLogger.fine("Requested to negotiate unsupported SSLv2!", new Object[0]);
                    }
                    if (SSLLogger.isOn("packet")) {
                        SSLLogger.fine("Raw write", new Object[]{SSLRecord.v2NoCipher});
                    }
                }
                throw new SSLException("Unsupported SSL v2.0 ClientHello");
            }
            int n = (this.header[0] & 0x7F) << 8 | this.header[1] & 0xFF;
            if (this.recordBody.position() == 0) {
                if (this.recordBody.capacity() < 5 + n) {
                    this.recordBody = ByteBuffer.allocate(5 + n);
                }
                this.recordBody.limit(5 + n);
                this.recordBody.put(this.header, 0, 5);
            } else {
                n = this.recordBody.remaining();
            }
            this.readFully(n -= 3);
            this.recordBody.flip();
            this.recordBody.position(2);
            this.handshakeHash.receive(this.recordBody);
            this.recordBody.position(0);
            ByteBuffer byteBuffer = SSLSocketInputRecord.convertToClientHello(this.recordBody);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("[Converted] ClientHello", byteBuffer);
            }
            return new Plaintext[]{new Plaintext(ContentType.HANDSHAKE.id, by3, by4, -1, -1L, byteBuffer)};
        }
        if ((by & 0x80) != 0 && by2 == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        throw new SSLException("Unsupported or unrecognized SSL message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFully(int n) throws IOException {
        int n2;
        int n3 = n + this.recordBody.position();
        try {
            for (n2 = this.recordBody.position(); n2 < n3; n2 += SSLSocketInputRecord.read(this.is, this.recordBody.array(), n2, n3 - n2)) {
            }
        }
        finally {
            this.recordBody.position(n2);
        }
        return n;
    }

    private int readHeader() throws IOException {
        while (this.headerOff < 5) {
            this.headerOff += SSLSocketInputRecord.read(this.is, this.header, this.headerOff, 5 - this.headerOff);
        }
        return 5;
    }

    private static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = inputStream.read(byArray, n, n2);
        if (n3 < 0) {
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw read: EOF", new Object[0]);
            }
            throw new EOFException("SSL peer shut down incorrectly");
        }
        if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n3);
            SSLLogger.fine("Raw read", byteBuffer);
        }
        return n3;
    }

    void deplete(boolean bl) throws IOException {
        int n = this.is.available();
        if (bl && n == 0) {
            this.is.read();
        }
        while ((n = this.is.available()) != 0) {
            this.is.skip(n);
        }
    }
}

