/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.ByteArrayCipherEngine;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.DigestInfo;
import iaik.cms.InputStreamCipherEngine;
import iaik.cms.InputStreamCompressEngine;
import iaik.cms.InputStreamHashEngine;
import iaik.cms.InputStreamMacEngine;
import iaik.cms.OutputStreamCompressEngine;
import iaik.cms.OutputStreamHashEngine;
import iaik.cms.OutputStreamMacEngine;
import iaik.cms.Utils;
import iaik.cms.h;
import iaik.cms.i;
import iaik.cms.j;
import iaik.cms.l;
import iaik.cms.o;
import iaik.cms.r;
import iaik.cms.u;
import iaik.cms.w;
import iaik.utils.CryptoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurityProvider {
    protected SecureRandom random_;
    protected String providerName_;
    private static SecurityProvider a;
    private static final boolean b = true;
    public static final String ALG_CIPHER_RSA_DECRYPT = "RSA/ECB/PKCS1Padding/Decrypt";
    public static final String ALG_CIPHER_RSA_ENCRYPT = "RSA/ECB/PKCS1Padding/Encrypt";
    public static final String ALG_CIPHER_RSA_VERIFY = "RSA/ECB/PKCS1Padding/Verify";
    public static final String ALG_CIPHER_RSA_SIGN = "RSA/ECB/PKCS1Padding/Sign";
    public static final String ALG_CIPHER_RSA = "RSA/ECB/PKCS1Padding";
    public static final String ALG_KEYEX_SSDH = "SSDH";
    public static final String ALG_KEYEX_ESDH = "ESDH";
    public static final String ALG_KEYEX_DH = "DH";
    public static final String ALG_SIGNATURE_RAWRSAPSS = "RawRSASSA-PSS";
    public static final String ALG_SIGNATURE_RAWECDSA_PLAIN = "RawECDSAPlain";
    public static final String ALG_SIGNATURE_RAWECDSA = "RawECDSA";
    public static final String ALG_SIGNATURE_RAWDSA = "RawDSA";
    public static final String ALG_SIGNATURE_SHADSA = "SHA1withDSA";
    public static final String ALG_HMAC_SHA = "HmacSHA1";
    public static final String ALG_HMAC_MD5 = "HmacMD5";
    public static final String ALG_DIGEST_SHA = "SHA";
    public static final String ALG_DIGEST_MD5 = "MD5";
    public static final String IMPLEMENTATION_NAME_PWRI_KEK = "PWRI-KEK";
    public static final String IMPLEMENTATION_NAME_PBKDF2 = "PBKDF2";
    public static final String IMPLEMENTATION_NAME_RSA_OAEP = "RSAES-OAEP";
    public static final String IMPLEMENTATION_NAME_RSA = "RSA";
    public static final String IMPLEMENTATION_NAME_RSA_PSS = "RSASSA-PSS";
    public static final String IMPLEMENTATION_NAME_ECDSA_PLAIN = "ECDSAPlain";
    public static final String IMPLEMENTATION_NAME_ECDSA = "ECDSA";
    public static final String IMPLEMENTATION_NAME_DSA = "SHA-1/DSA";
    public static final int DECOMPRESS = 1;
    public static final int COMPRESS = 0;
    public static final int CIPHER_UNWRAP = 4;
    public static final int CIPHER_WRAP = 3;
    public static final int CIPHER_DECRYPT = 2;
    public static final int CIPHER_ENCRYPT = 1;
    public static final int CIPHER_NONE = 0;
    public static final int SIGNATURE_VERIFY = 2;
    public static final int SIGNATURE_SIGN = 1;
    public static final int SIGNATURE_NONE = 0;
    private static boolean c;

    public byte[] wrapKey(SecretKey secretKey, AlgorithmID algorithmID, Key key, AlgorithmParameters algorithmParameters) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher cipher = this.getCipher(algorithmID, 3, key, algorithmParameters);
        byte[] byArray = cipher.wrap(secretKey);
        return byArray;
    }

    public boolean verifySignatureFromSignedAttributes(AlgorithmID algorithmID, AlgorithmID algorithmID2, PublicKey publicKey, byte[] byArray, byte[] byArray2) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        String string = algorithmID.getImplementationName();
        if (string == IMPLEMENTATION_NAME_RSA || string.endsWith("/RSA")) {
            byte[] byArray3 = this.getHash(algorithmID2, byArray);
            return this.verifySignatureFromHash(algorithmID, algorithmID2, publicKey, byArray3, byArray2);
        }
        Signature signature = this.getSignature(algorithmID, 2, (Key)publicKey);
        try {
            AlgorithmParameterSpec algorithmParameterSpec = this.getAlgorithmParameterSpec(algorithmID);
            if (algorithmParameterSpec != null) {
                signature.setParameter("", algorithmParameterSpec);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new NoSuchAlgorithmException("Error getting parameters from algorithm ID: " + invalidParameterSpecException.toString());
        }
        signature.update(byArray);
        return signature.verify(byArray2);
    }

    public boolean verifySignatureFromHash(AlgorithmID algorithmID, AlgorithmID algorithmID2, PublicKey publicKey, byte[] byArray, byte[] byArray2) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        boolean bl = false;
        String string = algorithmID.getImplementationName();
        if (string == IMPLEMENTATION_NAME_RSA || string.endsWith("/RSA")) {
            byte[] byArray3;
            Object object;
            try {
                object = this.getCipher(ALG_CIPHER_RSA_VERIFY, 2, (Key)publicKey, (AlgorithmParameters)null);
                byArray3 = ((Cipher)object).doFinal(byArray2);
            }
            catch (Exception exception) {
                throw new SignatureException("Cannot verify RSA signature: " + exception.toString());
            }
            if (algorithmID2.getParameter() == null) {
                algorithmID2.encodeAbsentParametersAsNull(false);
            }
            object = new DigestInfo(algorithmID2, byArray).toByteArray();
            bl = CryptoUtils.equalsBlock((byte[])object, (byte[])byArray3);
        } else if (string.equals(IMPLEMENTATION_NAME_RSA_PSS)) {
            Signature signature = this.getSignature(ALG_SIGNATURE_RAWRSAPSS, 2, (Key)publicKey);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = this.getAlgorithmParameterSpec(algorithmID);
                if (algorithmParameterSpec != null) {
                    signature.setParameter("", algorithmParameterSpec);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new NoSuchAlgorithmException("Error getting PSS parameters from algorithm ID: " + invalidParameterSpecException.toString());
            }
            signature.update(byArray);
            bl = signature.verify(byArray2);
        } else if (string.equals(IMPLEMENTATION_NAME_DSA) || string.equals("SHA/DSA") || string.equals("DSA")) {
            Signature signature = this.getSignature(ALG_SIGNATURE_RAWDSA, 2, (Key)publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        } else if (string.indexOf(IMPLEMENTATION_NAME_ECDSA) != -1) {
            Signature signature = string.indexOf(IMPLEMENTATION_NAME_ECDSA_PLAIN) == -1 ? this.getSignature(ALG_SIGNATURE_RAWECDSA, 2, (Key)publicKey) : this.getSignature(ALG_SIGNATURE_RAWECDSA_PLAIN, 2, (Key)publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        } else {
            throw new NoSuchAlgorithmException("Algorithm " + algorithmID.getAlgorithm().getName() + " not supported!");
        }
        return bl;
    }

    public SecretKey unwrapKey(byte[] byArray, AlgorithmID algorithmID, Key key, AlgorithmParameters algorithmParameters, String string) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher cipher = this.getCipher(algorithmID, 4, key, algorithmParameters);
        return (SecretKey)cipher.unwrap(byArray, string, 3);
    }

    public static void setSecurityProvider(SecurityProvider securityProvider) {
        a = securityProvider;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.random_ = secureRandom;
    }

    public Signature getSignature(String string, int n2, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = null;
        if (this.providerName_ != null) {
            try {
                signature = Signature.getInstance(string, this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (signature == null) {
            signature = Signature.getInstance(string);
        }
        if (n2 == 1) {
            signature.initSign((PrivateKey)key);
        } else if (n2 == 2) {
            signature.initVerify((PublicKey)key);
        }
        return signature;
    }

    public Signature getSignature(AlgorithmID algorithmID, int n2, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = null;
        if (this.providerName_ != null) {
            try {
                signature = algorithmID.getSignatureInstance(this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (signature == null) {
            signature = algorithmID.getSignatureInstance();
        }
        if (n2 == 1) {
            signature.initSign((PrivateKey)key);
        } else if (n2 == 2) {
            signature.initVerify((PublicKey)key);
        }
        return signature;
    }

    public static SecurityProvider getSecurityProvider() {
        if (a == null) {
            try {
                Class<?> clazz = Class.forName("iaik.cms.IaikProvider");
                a = (SecurityProvider)clazz.newInstance();
            }
            catch (Throwable throwable) {}
            if (a == null) {
                a = new SecurityProvider();
            }
        }
        return a;
    }

    public SecureRandom getSecureRandom() {
        SecureRandom secureRandom = this.random_;
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        return secureRandom;
    }

    public SecretKeyFactory getSecretKeyFactory(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (this.providerName_ != null) {
            try {
                return algorithmID.getSecretKeyFactoryInstance(this.providerName_);
            }
            catch (Exception exception) {
            }
        }
        return algorithmID.getSecretKeyFactoryInstance();
    }

    public String getProviderName() {
        return this.providerName_;
    }

    public Key getPBEKey(char[] cArray, AlgorithmID algorithmID) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = this.getSecretKeyFactory(algorithmID);
        return secretKeyFactory.generateSecret(pBEKeySpec);
    }

    public OutputStreamMacEngine getOutputStreamMacEngine(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec, OutputStream outputStream) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Mac key must not be null!");
        }
        Mac mac = this.getMac(algorithmID, key, algorithmParameterSpec);
        return new u(outputStream, mac);
    }

    public OutputStreamHashEngine getOutputStreamHashEngine(AlgorithmID algorithmID, OutputStream outputStream) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = this.getMessageDigest(algorithmID);
        return new h(outputStream, messageDigest);
    }

    public OutputStreamCompressEngine getOutputStreamCompressEngine(AlgorithmID algorithmID, OutputStream outputStream, int n2) throws NoSuchAlgorithmException {
        if (algorithmID.equals((Object)CMSAlgorithmID.zlib_compress)) {
            return new w(outputStream, n2);
        }
        throw new NoSuchAlgorithmException("Algorithm " + algorithmID.getAlgorithm().getName() + " not available!");
    }

    public PublicKey getOriginatorPublicKey(ASN1Object aSN1Object) throws CMSException {
        AlgorithmID algorithmID = null;
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(DerCoder.encode((ASN1Object)aSN1Object));
            algorithmID = new AlgorithmID(aSN1Object.getComponentAt(0));
            KeyFactory keyFactory = this.getKeyFactory(algorithmID);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (CodingException codingException) {
            throw new CMSException("No KeyFactory for " + algorithmID.getAlgorithm().getName());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No KeyFactory for " + algorithmID.getAlgorithm().getName());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("Invalid key encoding: " + invalidKeySpecException.getMessage());
        }
    }

    public AlgorithmID[] getMicAlgs(String string) {
        Object[] objectArray;
        Vector<AlgorithmID> vector = new Vector<AlgorithmID>();
        if (string != null) {
            objectArray = new StringTokenizer(string, ",");
            while (objectArray.hasMoreTokens()) {
                AlgorithmID algorithmID = SecurityProvider.a(objectArray.nextToken().trim());
                if (algorithmID == null) continue;
                vector.addElement(algorithmID);
            }
        }
        objectArray = new AlgorithmID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static AlgorithmID a(String string) {
        AlgorithmID algorithmID = null;
        if (string != null) {
            if (string.equalsIgnoreCase(ALG_DIGEST_SHA) || string.equalsIgnoreCase("SHA-1") || string.equalsIgnoreCase("SHA1") || string.equalsIgnoreCase("RSA-SHA1")) {
                algorithmID = (AlgorithmID)AlgorithmID.sha1.clone();
            } else if (string.equalsIgnoreCase(ALG_DIGEST_MD5) || string.equalsIgnoreCase("RSA-MD5")) {
                algorithmID = (AlgorithmID)AlgorithmID.md5.clone();
            } else {
                algorithmID = AlgorithmID.getAlgorithmID((String)string.toUpperCase(Locale.US));
                if (algorithmID != null) {
                    algorithmID = (AlgorithmID)algorithmID.clone();
                }
            }
        }
        return algorithmID;
    }

    public MessageDigest getMessageDigest(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (this.providerName_ != null) {
            try {
                return algorithmID.getMessageDigestInstance(this.providerName_);
            }
            catch (Exception exception) {
            }
        }
        return algorithmID.getMessageDigestInstance();
    }

    public Mac getMac(String string, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = null;
        if (this.providerName_ != null) {
            try {
                mac = Mac.getInstance(string, this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (mac == null) {
            mac = Mac.getInstance(string);
        }
        if (key != null) {
            if (algorithmParameterSpec == null) {
                mac.init(key);
            } else {
                mac.init(key, algorithmParameterSpec);
            }
        }
        return mac;
    }

    public Mac getMac(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = null;
        if (this.providerName_ != null) {
            try {
                mac = algorithmID.getMacInstance(this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (mac == null) {
            mac = algorithmID.getMacInstance();
        }
        if (key != null) {
            if (algorithmParameterSpec == null) {
                mac.init(key);
            } else {
                mac.init(key, algorithmParameterSpec);
            }
        }
        return mac;
    }

    public KeyPairGenerator getKeyPairGenerator(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (this.providerName_ != null) {
            try {
                return algorithmID.getKeyPairGeneratorInstance(this.providerName_);
            }
            catch (Exception exception) {
            }
        }
        return algorithmID.getKeyPairGeneratorInstance();
    }

    public KeyGenerator getKeyGenerator(AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyGenerator keyGenerator = null;
        if (this.providerName_ != null) {
            try {
                keyGenerator = algorithmID.getKeyGeneratorInstance(this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (keyGenerator == null) {
            keyGenerator = algorithmID.getKeyGeneratorInstance();
        }
        keyGenerator.init(algorithmParameterSpec, this.getSecureRandom());
        return keyGenerator;
    }

    public KeyGenerator getKeyGenerator(AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = null;
        if (this.providerName_ != null) {
            try {
                keyGenerator = algorithmID.getKeyGeneratorInstance(this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (keyGenerator == null) {
            keyGenerator = algorithmID.getKeyGeneratorInstance();
        }
        if (n2 == -1) {
            if (algorithmID.equals((Object)AlgorithmID.aes256_CBC)) {
                n2 = 256;
            } else if (algorithmID.equals((Object)AlgorithmID.aes192_CBC)) {
                n2 = 192;
            } else if (algorithmID.equals((Object)AlgorithmID.aes128_CBC)) {
                n2 = 128;
            }
        }
        if (n2 == -1) {
            keyGenerator.init(this.getSecureRandom());
        } else {
            keyGenerator.init(n2, this.getSecureRandom());
        }
        return keyGenerator;
    }

    public KeyFactory getKeyFactory(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (this.providerName_ != null) {
            try {
                return algorithmID.getKeyFactoryInstance(this.providerName_);
            }
            catch (Exception exception) {
            }
        }
        return algorithmID.getKeyFactoryInstance();
    }

    public KeyAgreement getKeyAgreement(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        KeyAgreement keyAgreement = null;
        if (this.providerName_ != null) {
            try {
                keyAgreement = algorithmID.getKeyAgreementInstance(this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (keyAgreement == null) {
            keyAgreement = algorithmID.getKeyAgreementInstance();
        }
        keyAgreement.init(key, algorithmParameterSpec, this.getSecureRandom());
        return keyAgreement;
    }

    public InputStreamMacEngine getInputStreamMacEngine(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec, InputStream inputStream) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Mac key must not be null!");
        }
        Mac mac = this.getMac(algorithmID, key, algorithmParameterSpec);
        return new o(inputStream, mac);
    }

    public InputStreamHashEngine getInputStreamHashEngine(AlgorithmID algorithmID, InputStream inputStream) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = this.getMessageDigest(algorithmID);
        return new i(inputStream, messageDigest);
    }

    public InputStreamCompressEngine getInputStreamCompressEngine(AlgorithmID algorithmID, InputStream inputStream, int n2, int n3) throws NoSuchAlgorithmException {
        if (algorithmID.equals((Object)CMSAlgorithmID.zlib_compress)) {
            return new r(inputStream, n2, n3);
        }
        throw new NoSuchAlgorithmException("Algorithm " + algorithmID.getAlgorithm().getName() + " not available!");
    }

    public InputStreamCipherEngine getInputStreamCipherEngine(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters;
        j j2 = new j();
        j2.initCipher(algorithmID, n2, key, algorithmParameterSpec);
        if ((n2 == 1 || n2 == 3) && algorithmID.getParameter() == null && (algorithmParameters = j2.getParameters()) != null) {
            algorithmID.setAlgorithmParameters(algorithmParameters);
        }
        return j2;
    }

    public InputStreamCipherEngine getInputStreamCipherEngine(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters2;
        j j2 = new j();
        j2.initCipher(algorithmID, n2, key, algorithmParameters);
        if ((n2 == 1 || n2 == 3) && algorithmID.getParameter() == null && (algorithmParameters2 = j2.getParameters()) != null) {
            algorithmID.setAlgorithmParameters(algorithmParameters2);
        }
        return j2;
    }

    public byte[] getHash(AlgorithmID algorithmID, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = this.getMessageDigest(algorithmID);
        return messageDigest.digest(byArray);
    }

    public Cipher getCipher(String string, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        if (string.startsWith(ALG_CIPHER_RSA)) {
            string = ALG_CIPHER_RSA;
        }
        Cipher cipher = null;
        if (this.providerName_ != null) {
            try {
                cipher = Cipher.getInstance(string, this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(string);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new NoSuchAlgorithmException(noSuchPaddingException.toString());
            }
        }
        if (n2 != 0) {
            int n3 = SecurityProvider.convertCipherMode(n2);
            if (algorithmParameterSpec == null) {
                cipher.init(n3, key, this.getSecureRandom());
            } else {
                cipher.init(n3, key, algorithmParameterSpec, this.getSecureRandom());
            }
        }
        return cipher;
    }

    public Cipher getCipher(String string, int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        if (string.startsWith(ALG_CIPHER_RSA)) {
            string = ALG_CIPHER_RSA;
        }
        Cipher cipher = null;
        if (this.providerName_ != null) {
            try {
                cipher = Cipher.getInstance(string, this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(string);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new NoSuchAlgorithmException(noSuchPaddingException.toString());
            }
        }
        if (n2 != 0) {
            int n3 = SecurityProvider.convertCipherMode(n2);
            if (algorithmParameters == null) {
                cipher.init(n3, key, this.getSecureRandom());
            } else {
                cipher.init(n3, key, algorithmParameters, this.getSecureRandom());
            }
        }
        return cipher;
    }

    public Cipher getCipher(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        int n3 = SecurityProvider.convertCipherMode(n2);
        Cipher cipher = null;
        if (this.providerName_ != null) {
            try {
                cipher = algorithmID.getCipherInstance(this.providerName_);
            }
            catch (Exception exception) {}
        }
        if (cipher == null) {
            cipher = algorithmID.getCipherInstance();
        }
        if (n2 != 0) {
            Object object;
            if (algorithmParameterSpec == null) {
                try {
                    algorithmParameterSpec = this.getAlgorithmParameterSpec(algorithmID);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new InvalidAlgorithmParameterException("Error getting parameters from AlgorithmID: " + invalidParameterSpecException.getMessage());
                }
            }
            if ((n2 == 2 || n2 == 4) && algorithmParameterSpec == null && (object = algorithmID.getParameter()) != null) {
                if (object.isA(ASN.OCTET_STRING)) {
                    algorithmParameterSpec = new IvParameterSpec((byte[])object.getValue());
                } else if (!object.isA(ASN.NULL)) {
                    throw new InvalidAlgorithmParameterException("Cannot initialize cipher with unknown parameters from AlgorithmID!");
                }
            }
            cipher.init(n3, key, algorithmParameterSpec, this.getSecureRandom());
            if (n2 == 1 || n2 == 3) {
                byte[] byArray;
                object = cipher.getParameters();
                if (object != null) {
                    algorithmID.setAlgorithmParameters((AlgorithmParameters)object);
                } else if (algorithmID.getParameter() == null && (byArray = cipher.getIV()) != null) {
                    algorithmID.setParameter((ASN1Object)new OCTET_STRING(byArray));
                }
            }
        }
        return cipher;
    }

    public Cipher getCipher(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher cipher = null;
        if (algorithmParameters == null) {
            algorithmParameters = this.getAlgorithmParameters(algorithmID);
        }
        if (algorithmParameters == null) {
            cipher = this.getCipher(algorithmID, n2, key, (AlgorithmParameterSpec)null);
        } else {
            if (this.providerName_ != null) {
                try {
                    cipher = algorithmID.getCipherInstance(this.providerName_);
                }
                catch (Exception exception) {}
            }
            if (cipher == null) {
                cipher = algorithmID.getCipherInstance();
            }
            if (n2 != 0) {
                int n3 = SecurityProvider.convertCipherMode(n2);
                cipher.init(n3, key, algorithmParameters, this.getSecureRandom());
                if (n2 == 1 || n2 == 3) {
                    AlgorithmParameters algorithmParameters2 = cipher.getParameters();
                    if (algorithmParameters2 != null) {
                        algorithmID.setAlgorithmParameters(algorithmParameters2);
                    } else if (algorithmID.getParameter() == null) {
                        if (algorithmParameters != null) {
                            algorithmID.setAlgorithmParameters(algorithmParameters);
                        } else {
                            byte[] byArray = cipher.getIV();
                            if (byArray != null) {
                                algorithmID.setParameter((ASN1Object)new OCTET_STRING(byArray));
                            }
                        }
                    }
                }
            }
        }
        return cipher;
    }

    public ByteArrayCipherEngine getByteArrayCipherEngine(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters;
        l l2 = new l();
        l2.initCipher(algorithmID, n2, key, algorithmParameterSpec);
        if ((n2 == 1 || n2 == 3) && algorithmID.getParameter() == null && (algorithmParameters = l2.getParameters()) != null) {
            algorithmID.setAlgorithmParameters(algorithmParameters);
        }
        return l2;
    }

    public ByteArrayCipherEngine getByteArrayCipherEngine(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters2;
        l l2 = new l();
        l2.initCipher(algorithmID, n2, key, algorithmParameters);
        if ((n2 == 1 || n2 == 3) && algorithmID.getParameter() == null && (algorithmParameters2 = l2.getParameters()) != null) {
            algorithmID.setAlgorithmParameters(algorithmParameters2);
        }
        return l2;
    }

    public AlgorithmParameters getAlgorithmParameters(String string) throws NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters;
        block2: {
            algorithmParameters = null;
            if (this.providerName_ == null) break block2;
            try {
                algorithmParameters = AlgorithmParameters.getInstance(string, this.providerName_);
            }
            catch (Exception exception) {
                algorithmParameters = AlgorithmParameters.getInstance(string);
            }
        }
        return algorithmParameters;
    }

    public AlgorithmParameters getAlgorithmParameters(AlgorithmID algorithmID, String string) throws NoSuchAlgorithmException {
        return algorithmID.getAlgorithmParameters(string, this.providerName_);
    }

    public AlgorithmParameters getAlgorithmParameters(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (this.providerName_ != null) {
            try {
                return algorithmID.getAlgorithmParameters(null, this.providerName_);
            }
            catch (Exception exception) {
            }
        }
        return algorithmID.getAlgorithmParameters();
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(AlgorithmID algorithmID) throws InvalidParameterSpecException {
        return null;
    }

    public ASN1Object getASN1OriginatorPublicKey(PublicKey publicKey) throws CMSException {
        try {
            return DerCoder.decode((byte[])publicKey.getEncoded());
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
    }

    public KeyPair generateKeyAgreementKeyPair(AlgorithmID algorithmID, PublicKey publicKey) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Cannot provider independently init key agreement key pair generator with parameters from public key!");
    }

    public SecretKey generateKey(AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyGenerator keyGenerator = this.getKeyGenerator(algorithmID, algorithmParameterSpec);
        return keyGenerator.generateKey();
    }

    public SecretKey generateKey(AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = this.getKeyGenerator(algorithmID, n2);
        return keyGenerator.generateKey();
    }

    public byte[] encryptKey(SecretKey secretKey, AlgorithmID algorithmID, PublicKey publicKey) throws BadPaddingException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher cipher = null;
        String string = algorithmID.getImplementationName();
        try {
            cipher = string == IMPLEMENTATION_NAME_RSA ? this.getCipher(ALG_CIPHER_RSA_ENCRYPT, 1, (Key)publicKey, (AlgorithmParameters)null) : this.getCipher(algorithmID, 1, (Key)publicKey, (AlgorithmParameters)null);
            return cipher.doFinal(secretKey.getEncoded());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Invalid parameters: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Illegal block size: " + illegalBlockSizeException.getMessage());
        }
    }

    public Key deriveKey(char[] cArray, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (algorithmID == null) {
            throw new NullPointerException("Cannot derive key with null key derivation function!");
        }
        KeyGenerator keyGenerator = this.getKeyGenerator(algorithmID, algorithmParameterSpec);
        return keyGenerator.generateKey();
    }

    public SecretKey decryptKey(byte[] byArray, AlgorithmID algorithmID, PrivateKey privateKey, String string) throws BadPaddingException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2 = null;
        Cipher cipher = null;
        String string2 = algorithmID.getImplementationName();
        try {
            cipher = string2 == IMPLEMENTATION_NAME_RSA ? this.getCipher(ALG_CIPHER_RSA_DECRYPT, 2, (Key)privateKey, (AlgorithmParameters)null) : this.getCipher(algorithmID, 2, (Key)privateKey, (AlgorithmParameters)null);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Invalid parameters: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Illegal block size: " + illegalBlockSizeException.getMessage());
        }
        return new SecretKeySpec(byArray2, string);
    }

    public SecretKey decryptKey(byte[] byArray, AlgorithmID algorithmID, PrivateKey privateKey) throws BadPaddingException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException {
        return this.decryptKey(byArray, algorithmID, privateKey, "RAW");
    }

    public SecretKey createSharedKeyEncryptionKey(AlgorithmID algorithmID, PrivateKey privateKey, PublicKey publicKey, AlgorithmID algorithmID2, int n2, byte[] byArray, String string) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        if (algorithmID.equals((Object)AlgorithmID.esdhKeyAgreement)) {
            throw new NoSuchAlgorithmException("Cannot provider independently init ESDH key agreement ESDHKEKParameterSpec! You may use the IaikProvider");
        }
        throw new NoSuchAlgorithmException("Key Agreement method " + algorithmID.getAlgorithm().getName() + " not supported!");
    }

    public static int convertCipherMode(int n2) {
        switch (n2) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    public byte[] compress(AlgorithmID algorithmID, byte[] byArray, int n2) throws IOException, NoSuchAlgorithmException {
        byte[] byArray2 = null;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputStreamCompressEngine inputStreamCompressEngine = this.getInputStreamCompressEngine(algorithmID, byteArrayInputStream, n2, 1024);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Utils.copyStream(inputStreamCompressEngine.getInputStream(), byteArrayOutputStream, null);
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        return byArray2;
    }

    public void checkDomainParameters(PrivateKey privateKey, PublicKey publicKey) throws InvalidParameterException {
        String string = privateKey.getAlgorithm();
        if (string.equalsIgnoreCase(ALG_KEYEX_DH)) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
            DHParameterSpec dHParameterSpec2 = dHPublicKey.getParams();
            if (dHParameterSpec != null && dHParameterSpec2 != null && !dHParameterSpec.getP().equals(dHParameterSpec2.getP()) && !dHParameterSpec.getG().equals(dHParameterSpec2.getG())) {
                throw new InvalidParameterException("Different domain parameters for DH!");
            }
        } else {
            try {
                ASN1Object aSN1Object;
                AlgorithmID algorithmID;
                ASN1Object aSN1Object2;
                ASN1Object aSN1Object3 = DerCoder.decode((byte[])privateKey.getEncoded());
                AlgorithmID algorithmID2 = new AlgorithmID(aSN1Object3.getComponentAt(1));
                ASN1Object aSN1Object4 = algorithmID2.getParameter();
                if (aSN1Object4 != null && (aSN1Object2 = (algorithmID = new AlgorithmID((aSN1Object = DerCoder.decode((byte[])publicKey.getEncoded())).getComponentAt(0))).getParameter()) != null && !CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)aSN1Object4), (byte[])DerCoder.encode((ASN1Object)aSN1Object2))) {
                    throw new InvalidParameterException("Different domain parameters for " + privateKey.getAlgorithm());
                }
            }
            catch (Exception exception) {
                throw new InvalidParameterException("Different domain parameters for " + privateKey.getAlgorithm());
            }
        }
    }

    public byte[] calculateSignatureFromSignedAttributes(AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey, byte[] byArray) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        Signature signature;
        block8: {
            String string = algorithmID.getImplementationName();
            if (string == IMPLEMENTATION_NAME_RSA || string.endsWith("/RSA")) {
                byte[] byArray2 = this.getHash(algorithmID2, byArray);
                return this.calculateSignatureFromHash(algorithmID, algorithmID2, privateKey, byArray2);
            }
            signature = this.getSignature(algorithmID, 1, (Key)privateKey);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            try {
                algorithmParameterSpec = this.getAlgorithmParameterSpec(algorithmID);
                if (algorithmParameterSpec != null) {
                    signature.setParameter("", algorithmParameterSpec);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new NoSuchAlgorithmException("Error getting parameters from algorithm ID: " + invalidParameterSpecException.toString());
            }
            if (algorithmParameterSpec == null) {
                try {
                    Object object = signature.getParameter("");
                    if (object != null && object instanceof AlgorithmParameters) {
                        algorithmID.setAlgorithmParameters((AlgorithmParameters)object);
                    }
                }
                catch (Exception exception) {
                    if (!c) break block8;
                    System.out.println("Error getting and setting signature algorithm parameters: ");
                    exception.printStackTrace();
                }
            }
        }
        signature.update(byArray);
        return signature.sign();
    }

    public byte[] calculateSignatureFromHash(AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey, byte[] byArray) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2 = null;
        String string = algorithmID.getImplementationName();
        if (string == IMPLEMENTATION_NAME_RSA || string.endsWith("/RSA")) {
            DigestInfo digestInfo = new DigestInfo(algorithmID2, byArray);
            byte[] byArray3 = digestInfo.toByteArray();
            try {
                Cipher cipher = this.getCipher(ALG_CIPHER_RSA_SIGN, 1, (Key)privateKey, (AlgorithmParameters)null);
                byArray2 = cipher.doFinal(byArray3);
            }
            catch (Exception exception) {
                throw new SignatureException("Cannot calculate RSA siganture: " + exception.toString());
            }
        }
        if (string.equals(IMPLEMENTATION_NAME_RSA_PSS)) {
            Signature signature;
            block16: {
                signature = this.getSignature(ALG_SIGNATURE_RAWRSAPSS, 1, (Key)privateKey);
                AlgorithmParameterSpec algorithmParameterSpec = null;
                try {
                    algorithmParameterSpec = this.getAlgorithmParameterSpec(algorithmID);
                    if (algorithmParameterSpec != null) {
                        signature.setParameter("", algorithmParameterSpec);
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new NoSuchAlgorithmException("Error getting PSS parameters from algorithm ID: " + invalidParameterSpecException.toString());
                }
                if (algorithmParameterSpec == null) {
                    try {
                        Object object = signature.getParameter("");
                        if (object != null && object instanceof AlgorithmParameters) {
                            algorithmID.setAlgorithmParameters((AlgorithmParameters)object);
                        }
                    }
                    catch (Exception exception) {
                        if (!c) break block16;
                        System.out.println("Error getting and setting PSS algorithm parameters: ");
                        exception.printStackTrace();
                    }
                }
            }
            signature.update(byArray);
            byArray2 = signature.sign();
        } else if (string.equals(IMPLEMENTATION_NAME_DSA) || string.equals("SHA/DSA") || string.equals("DSA")) {
            Signature signature = this.getSignature(ALG_SIGNATURE_RAWDSA, 1, (Key)privateKey);
            signature.update(byArray);
            byArray2 = signature.sign();
        } else if (string.indexOf(IMPLEMENTATION_NAME_ECDSA) != -1) {
            Signature signature = string.indexOf(IMPLEMENTATION_NAME_ECDSA_PLAIN) == -1 ? this.getSignature(ALG_SIGNATURE_RAWECDSA, 1, (Key)privateKey) : this.getSignature(ALG_SIGNATURE_RAWECDSA_PLAIN, 1, (Key)privateKey);
            signature.update(byArray);
            byArray2 = signature.sign();
        } else {
            throw new NoSuchAlgorithmException("Algorithm " + algorithmID.getAlgorithm().getName() + " not supported!");
        }
        return byArray2;
    }

    public byte[] calculateMac(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec, byte[] byArray) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("Mac key must not be null!");
        }
        if (byArray == null) {
            throw new NullPointerException("Cannot calculate MAC from null data!");
        }
        Mac mac = this.getMac(algorithmID, key, algorithmParameterSpec);
        return mac.doFinal(byArray);
    }

    public SecurityProvider(String string) {
        this.providerName_ = string;
    }

    public SecurityProvider() {
        this(null);
    }

    static {
        c = DebugCMS.getDebugMode() && c;
    }
}

