/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPssPublicKey;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAPssPrivateKey
extends RSAPrivateKey {
    static /* synthetic */ Class b;
    private RSAPssParameterSpec a;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean validateParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        return RSAPssPublicKey.a(this.a, algorithmParameterSpec);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.a != null) {
            stringBuffer.append("parameters:\n" + this.a);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n2 = super.hashCode();
        if (this.a != null) {
            n2 ^= this.a.hashCode();
        }
        return n2;
    }

    public PublicKey getPublicKey() {
        try {
            return new RSAPssPublicKey(this.getModulus(), this.getPublicExponent(), this.a);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException.toString());
        }
    }

    public AlgorithmParameterSpec getParams() {
        return this.a;
    }

    public String getAlgorithm() {
        return "RSASSA-PSS";
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAPssPrivateKey && (bl = super.equals(object))) {
            RSAPssPrivateKey rSAPssPrivateKey = (RSAPssPrivateKey)object;
            bl = this.a != null && rSAPssPrivateKey.a != null ? this.a.equals(rSAPssPrivateKey.a) : this.a == null && rSAPssPrivateKey.a == null;
        }
        return bl;
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        super.decode(byArray);
        if (!this.private_key_algorithm.equals(AlgorithmID.rsassaPss)) {
            throw new InvalidKeyException("Invalid algorithm id (" + this.private_key_algorithm.getAlgorithm().getID() + ") Not an PSS key!");
        }
        ASN1Object aSN1Object = this.private_key_algorithm.getParameter();
        if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
            try {
                AlgorithmParameters algorithmParameters = this.private_key_algorithm.getAlgorithmParameters("RSASSA-PSS", "IAIK");
                this.a = (RSAPssParameterSpec)algorithmParameters.getParameterSpec(b != null ? b : (b = RSAPssPrivateKey.a("iaik.pkcs.pkcs1.RSAPssParameterSpec")));
                return;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Error parsing PSS parameters: " + exception.toString());
            }
        }
    }

    private void b() throws InvalidParameterSpecException {
        super.a(false);
        this.private_key_algorithm = (AlgorithmID)AlgorithmID.rsassaPss.clone();
        if (this.a != null) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("RSASSA-PSS", "IAIK");
                algorithmParameters.init(this.a);
                this.private_key_algorithm.setAlgorithmParameters(algorithmParameters);
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException("Invalid PSS parameters: " + exception.toString());
            }
        }
        this.createPrivateKeyInfo();
    }

    public RSAPssPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public RSAPssPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a(bigInteger, bigInteger2);
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof RSAPssParameterSpec)) {
                throw new InvalidParameterSpecException("Parameters must be RSAPssParameterSpec!");
            }
            this.a = (RSAPssParameterSpec)algorithmParameterSpec;
        }
        this.b();
    }

    public RSAPssPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        this.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof RSAPssParameterSpec)) {
                throw new InvalidParameterSpecException("Parameters must be RSAPssParameterSpec!");
            }
            this.a = (RSAPssParameterSpec)algorithmParameterSpec;
        }
        this.b();
    }

    public RSAPssPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        try {
            this.b();
            return;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return;
        }
    }

    public RSAPssPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a(bigInteger, bigInteger2);
        try {
            this.b();
            return;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return;
        }
    }

    public RSAPssPrivateKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public RSAPssPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    RSAPssPrivateKey() {
    }
}

