/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.ui.preferences.util;

import it.sogei.rcp.ui.preferences.Activator;
import it.sogei.rcp.ui.preferences.Messages;
import it.sogei.rcp.ui.preferences.entities.PreferenceBean;
import it.sogei.rcp.ui.preferences.entities.priv.EclipsePreferencePageTO;
import it.sogei.rcp.ui.preferences.entities.priv.PreferenceNodeRCP;
import it.sogei.rcp.ui.preferences.entities.priv.PreferencePageTO;
import it.sogei.rcp.ui.preferences.pages.priv.PreferencePageRCP;
import it.sogei.rcp.ui.preferences.util.PreferencesUtilRCP;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceManagerUtil {
    private PreferenceDialog pd;

    public void buildPreferencesTree(String selectedPage) {
        if (selectedPage == null) {
            selectedPage = PreferencesUtilRCP.getPreferenceValue(new PreferenceBean("it.sogei.rcp.ui.preferences", "it.sogei.rcp.ui.preferences.dialogPreference", "it.sogei.rcp.ui.preferences.lastSelectedPage"));
        }
        Activator.getDefault().preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Activator.preferenceMap.put(event.getProperty(), event.getNewValue().toString());
            }
        });
        Activator.getDefault().preferenceStoreInstance.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Activator.preferenceMap.put(event.getProperty(), event.getNewValue().toString());
            }
        });
        PreferenceManager pmdefault = PlatformUI.getWorkbench().getPreferenceManager();
        if (Activator.getDefault().preferenceManager != null) {
            Activator.getDefault().preferenceManager.removeAll();
        }
        this.fillNodesTree(Activator.preferencePageList, null);
        this.fillNodesTree(Activator.preferencePageContributionsList, null);
        int i = 0;
        while (i < pmdefault.getRootSubNodes().length) {
            if (pmdefault.getRootSubNodes()[i].getId().startsWith("it.sogei")) {
                Activator.getDefault().preferenceManager.addToRoot(pmdefault.getRootSubNodes()[i]);
            }
            ++i;
        }
        this.addEclipsePages(pmdefault);
        Activator.getDefault().preferenceManager = this.orderPreferenceManager(Activator.getDefault().preferenceManager);
    }

    public void createPreferenceDialog(String selectedPage, Shell shell) {
        this.pd = new PreferenceDialog(shell, Activator.getDefault().preferenceManager);
        this.pd.setSelectedNode(selectedPage);
        this.pd.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent arg0) {
                try {
                    String newPage = ((PreferencePageRCP)((Object)arg0.getSelectedPage())).getPageId();
                    PreferencesUtilRCP.setPreferenceValue(new PreferenceBean("it.sogei.rcp.ui.preferences", "it.sogei.rcp.ui.preferences.dialogPreference", "it.sogei.rcp.ui.preferences.lastSelectedPage"), newPage);
                }
                catch (ClassCastException classCastException) {}
            }
        });
        this.pd.setPreferenceStore((IPreferenceStore)Activator.getDefault().preferenceStore);
        this.pd.create();
        this.pd.getShell().setText(Messages.Preferences_Windows_Title);
        this.pd.open();
    }

    private void fillNodesTree(ArrayList<PreferencePageTO> list, PreferenceNodeRCP parent) {
        int i = 0;
        while (i < list.size()) {
            PreferencePageTO prefPage = list.get(i);
            PreferencePageRCP page = new PreferencePageRCP(prefPage, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            PreferenceNodeRCP node = new PreferenceNodeRCP(prefPage.id, (IPreferencePage)page);
            if (prefPage.children != null) {
                this.fillNodesTree(prefPage.children, node);
            }
            if (prefPage.preferences.isVisible()) {
                if (parent != null) {
                    parent.add((IPreferenceNode)node);
                } else if (prefPage.parentId != null && !prefPage.parentId.equals("")) {
                    Activator.getDefault().preferenceManager.addTo("/" + prefPage.parentId, (IPreferenceNode)node);
                } else {
                    Activator.getDefault().preferenceManager.addToRoot((IPreferenceNode)node);
                }
            }
            ++i;
        }
    }

    private PreferenceManager orderPreferenceManager(PreferenceManager pm) {
        PreferenceManager orderedPm = new PreferenceManager('/');
        Object[] nodes = pm.getRootSubNodes();
        Arrays.sort(nodes);
        int i = 0;
        while (i < nodes.length) {
            orderedPm.addToRoot((IPreferenceNode)nodes[i]);
            ++i;
        }
        return orderedPm;
    }

    private IPreferenceNode removeSubnodes(IPreferenceNode node) {
        IPreferenceNode tempNode = node;
        int child = tempNode.getSubNodes().length;
        int i = child - 1;
        while (i >= 0) {
            tempNode.remove(tempNode.getSubNodes()[i]);
            --i;
        }
        return tempNode;
    }

    private void addEclipsePages(PreferenceManager pm) {
        int i = 0;
        while (i < Activator.eclipsePreferencePageList.size()) {
            EclipsePreferencePageTO eclipsePage = Activator.eclipsePreferencePageList.get(i);
            IPreferenceNode node = pm.find(eclipsePage.path);
            if (node != null) {
                if (eclipsePage.removeSubnodes) {
                    node = this.removeSubnodes(node);
                }
                if (eclipsePage.parentpath != null) {
                    Activator.getDefault().preferenceManager.addTo(eclipsePage.parentpath, node);
                } else {
                    Activator.getDefault().preferenceManager.addToRoot(node);
                }
            }
            ++i;
        }
    }
}

