/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.core.handlers;

import it.sogei.rcp.core.Activator;
import it.sogei.rcp.core.entity.ConfigurationItems;
import it.sogei.rcp.core.exception.ConfigException;
import it.sogei.rcp.core.xml.bean.Desktop;
import it.sogei.rcp.interfaces.IFilePath;
import it.sogei.rcp.util.RCPException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Point;

public class ConfigurationHandler {
    private IFilePath filePath;
    private JAXBContext jaxbContext = null;
    private Unmarshaller unmarshaller = null;
    private Desktop desktopXml;
    ConfigurationHandler ch = null;
    private static final String schemaFilename = "xsd/Desktop.xsd";

    public ConfigurationHandler(IFilePath filePath) throws RCPException {
        this.filePath = filePath;
    }

    public int init() throws RCPException {
        int ret = -1;
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"it.sogei.rcp.core.xml.bean");
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
            URL schemaFilePath = Activator.getDefault().getBundle().getResource(schemaFilename);
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFilePath);
            this.unmarshaller.setSchema(schema);
            InputStream istrm = Platform.getBundle((String)Activator.APPICATION_SYMBOLIC_NAME).getResource(this.filePath.getRelativeFilePath()).openStream();
            this.desktopXml = (Desktop)this.unmarshaller.unmarshal(istrm);
            ConfigurationItems.setPluginId(this.desktopXml.getPluginId());
            ConfigurationItems.setInitialPerspectiveId(this.desktopXml.getInitialPerspectiveId());
            ConfigurationItems.setAppName(this.desktopXml.getAppName());
            ConfigurationItems.setInitialSize(new Point(this.desktopXml.getWindowWidth(), this.desktopXml.getWindowHeight()));
            ConfigurationItems.setWindowTitle(this.desktopXml.getWindowTitle());
            ConfigurationItems.setShowCoolbar(this.desktopXml.isCoolbar());
            ConfigurationItems.setShowStatusline(this.desktopXml.isStatusbar());
            ConfigurationItems.setShowToolbar(this.desktopXml.isToolbar());
            ConfigurationItems.setShowProgressIndicator(this.desktopXml.isProgressIndicator());
            ConfigurationItems.setShowPerspectivebar(this.desktopXml.isPerspectivebar());
            ConfigurationItems.setTabStyle(this.desktopXml.getTabStyle());
            ConfigurationItems.setPasswordRequired(this.desktopXml.isPasswordRequired());
            ConfigurationItems.setMultiUser(this.desktopXml.isMultiUser());
            ConfigurationItems.setSilentUpdate(this.desktopXml.isSilentUpdate());
            ConfigurationItems.setFullScreen(this.desktopXml.isFullScreen);
        }
        catch (UnmarshalException e) {
            throw new ConfigException("Errore nella validazione del file di configrazione", (Exception)((Object)e));
        }
        catch (JAXBException e) {
            throw new ConfigException("Errore nel caricamento del file di configurazione", (Exception)((Object)e));
        }
        catch (IOException ex) {
            throw new RCPException("Errore nella lettura del file di configurazione " + this.filePath.getRelativeFilePath(), (Exception)ex);
        }
        catch (Exception ex) {
            throw new RCPException("Errore nel reperimento dei dati per la configurazione dell'applicazione", ex);
        }
        return ret;
    }
}

