/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.utils.language.handlers;

import it.sogei.rcp.utils.language.properties.Messages;
import it.sogei.utilities.log4j.LogUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SwitchLanguageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String locale = event.getParameter("it.sogei.rcp.utils.language.locale");
        LogUtil.log((Object)((Object)this), (int)1, (String)("locale param:" + locale));
        if (MessageDialog.open((int)5, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SwitchLanguageHandler_Restart, (String)Messages.SwitchLanguageHandler_ConfirmRestartQuestion, (int)0)) {
            this.changeLocale(locale);
            PlatformUI.getWorkbench().restart();
        }
        return null;
    }

    private void changeLocale(String locale) {
        String configArea = System.getProperty("user.dir");
        String product = Platform.getProduct().getName();
        if (configArea == null) {
            LogUtil.log((Object)((Object)this), (int)1, (String)"configArea null");
            return;
        }
        try {
            String fileNameIni = String.valueOf(configArea) + '/' + product + ".ini";
            LogUtil.log((Object)((Object)this), (int)1, (String)("fileName:" + fileNameIni));
            File file = new File(fileNameIni);
            String fileNameBak = String.valueOf(fileNameIni) + ".bak";
            file.renameTo(new File(fileNameBak));
            BufferedReader in = new BufferedReader(new FileReader(fileNameBak));
            BufferedWriter out = new BufferedWriter(new FileWriter(fileNameIni));
            try {
                boolean isNl = false;
                boolean isNlWiritten = false;
                String line = in.readLine();
                while (line != null) {
                    if (!isNl) {
                        out.write(line);
                    } else {
                        LogUtil.log((Object)((Object)this), (int)1, (String)("write locale:" + locale));
                        out.write(locale);
                        isNl = false;
                        isNlWiritten = true;
                    }
                    out.newLine();
                    if (line.equals("-nl")) {
                        isNl = true;
                    }
                    line = in.readLine();
                }
                if (!isNlWiritten) {
                    out.write("-nl");
                    out.newLine();
                    out.write(locale);
                    out.newLine();
                }
                out.flush();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

