/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.telematico.application.views;

import it.sogei.rcp.workspace.exception.WorkspaceException;
import it.sogei.rcp.workspace.util.WorkspaceManager;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportWorkspaceDialog
extends TitleAreaDialog {
    private Text text;
    private final Shell parent;
    private Button chiudi;
    private Button btnImporta;

    public ImportWorkspaceDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setShellStyle(80);
        this.parent = parentShell;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setTitle("Importa area di lavoro");
        this.setMessage("Tramite questa funzionalita' e' possibile importare l'intero contenuto di un'area di lavoro esistente nell'area di lavoro specificata all'interno dell'applicazione.");
        control.setToolTipText("");
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite top = (Composite)super.createDialogArea(composite);
        top.setLayout((Layout)new GridLayout(2, false));
        new Label(top, 0);
        Label lblSelezionaIlWorkspace = new Label(top, 0);
        lblSelezionaIlWorkspace.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSelezionaIlWorkspace.setText("Seleziona il percorso dell'area di lavoro da importare.\nPer effettuare l'operazione di importazione premere il bottone 'Avvia importazione', altrimenti premere il bottone 'Chiudi'");
        new Label(top, 0);
        this.text = new Text(top, 2056);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnNewButton = new Button(top, 0);
        btnNewButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(ImportWorkspaceDialog.this.parent);
                String dirWsImport = dirDialog.open();
                File metadataDir = new File(String.valueOf(dirWsImport) + File.separator + ".metadata");
                metadataDir.exists();
                ImportWorkspaceDialog.this.text.setText(dirWsImport);
                ImportWorkspaceDialog.this.btnImporta.setEnabled(true);
            }
        });
        btnNewButton.setText("Area di lavoro da importare");
        Label lblEventualiFileEsistenti = new Label(top, 0);
        lblEventualiFileEsistenti.setText("Attenzione: eventuali file esistenti verranno sovrascritti");
        this.btnImporta = new Button(top, 0);
        this.btnImporta.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnImporta.setEnabled(false);
        this.btnImporta.setText("Avvia importazione");
        this.btnImporta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceManager wsManager = new WorkspaceManager();
                try {
                    IStatus esitoImporta = wsManager.importaWorkspaceJob(ImportWorkspaceDialog.this.text.getText());
                    if (esitoImporta.getSeverity() == 0) {
                        MessageDialog.openInformation((Shell)ImportWorkspaceDialog.this.parent, (String)"Importa area di lavoro", (String)"Copia dell'area di lavoro eseguita con successo. L'applicazione verra' riavviata.");
                        PlatformUI.getWorkbench().restart();
                    } else {
                        MessageDialog.openError((Shell)ImportWorkspaceDialog.this.parent, (String)"Importa area di lavoro", (String)"Si e' verificato un errore nella copia dell'area di lavoro");
                    }
                }
                catch (WorkspaceException workspaceException) {
                    MessageDialog.openError((Shell)ImportWorkspaceDialog.this.parent, (String)"Importa area di lavoro", (String)"Si e' verificato un errore nella copia dell'area di lavoro");
                }
            }
        });
        return top;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected Composite getTitleArea() {
        return super.getTitleArea();
    }

    protected Label getTitleImageLabel() {
        return super.getTitleImageLabel();
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
    }

    public void setTitle(String newTitle) {
        super.setTitle(newTitle);
    }

    public void setTitleAreaColor(RGB color) {
        super.setTitleAreaColor(color);
    }

    public void setTitleImage(Image newTitleImage) {
        super.setTitleImage(newTitleImage);
    }

    public String getMessage() {
        return super.getMessage();
    }

    public String getErrorMessage() {
        return super.getErrorMessage();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.chiudi = this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }
}

