/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.Environment;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JCPConfig;
import com.sun.deploy.config.JCPStoreConfig;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.PluginClientConfig;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.panel.AdvancedPanel;
import com.sun.deploy.panel.AdvancedProperties;
import com.sun.deploy.panel.GeneralPanel;
import com.sun.deploy.panel.JavaPanel;
import com.sun.deploy.panel.SecurityPanel;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.panel.UpdatePanelFactory;
import com.sun.deploy.panel.UpdatePanelImpl;
import com.sun.deploy.registration.InstallCommands;
import com.sun.deploy.registration.InstallHints;
import com.sun.deploy.registration.RegisterDeploy;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.FileTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AboutDialog;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeployUIManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ControlPanel
extends JFrame
implements DeploySIListener,
PropertyChangeListener {
    private static final int DIALOG_NONE = 0;
    private static final int DIALOG_JPI_SETTINGS = 1;
    private static final int DIALOG_BROWSER_SETTINGS = 2;
    private static final int DIALOG_IE_ERROR = 3;
    private static final int DIALOG_MOZ_ERROR = 4;
    protected static final int FIXED_WIDTH = 520;
    private boolean _applyButtonAction = false;
    private static final String JCP_ID = "JavaControlPanel";
    private static JTabbedPane tabbedPane;
    private static GeneralPanel generalPanel;
    private SecurityPanel securityPanel;
    private JavaPanel javaPanel;
    private final UpdatePanelImpl updatePanelImpl;
    private AdvancedPanel advancedPanel;
    private final SingleInstanceImpl _sil = new SingleInstanceImpl();
    private JPanel decisionPanel;
    private JButton okButton;
    private static JButton applyButton;
    private JButton cancelButton;

    public ControlPanel() {
        this._sil.addSingleInstanceListener(this, JCP_ID);
        Config.setInstance(new JCPConfig(this));
        ControlPanel.initTrace();
        this.updatePanelImpl = UpdatePanelFactory.getInstance();
        this.initComponents();
        this._applyButtonAction = false;
        this.apply();
        this._applyButtonAction = true;
    }

    private void initComponents() {
        tabbedPane = new JTabbedPane();
        this.securityPanel = new SecurityPanel();
        this.javaPanel = new JavaPanel();
        generalPanel = new GeneralPanel();
        SecurityProperties.addJavaEnableListener(generalPanel);
        Platform.get().initBrowserSettings();
        Config.get().getJavaPlugin();
        Config.get().useRoamingProfile();
        this.advancedPanel = new AdvancedPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
        };
        this.setTitle(this.getMessage("control.panel.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ControlPanel.this.exitForm();
            }
        });
        tabbedPane.setName(this.getMessage("control.panel.general"));
        tabbedPane.addTab(this.getMessage("control.panel.general"), generalPanel);
        JPanel jPanel = this.updatePanelImpl.getPanel();
        if (jPanel != null) {
            tabbedPane.addTab(this.getMessage("control.panel.update"), jPanel);
        }
        tabbedPane.addTab(this.getMessage("control.panel.java"), this.javaPanel);
        tabbedPane.addTab(this.getMessage("control.panel.security"), this.securityPanel);
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.decisionPanel = new JPanel();
        this.decisionPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(this.getMessage("common.ok_btn"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.okButton.setToolTipText(this.getMessage("cpl.ok_btn.tooltip"));
        this.decisionPanel.add(this.okButton);
        this.cancelButton = new JButton(this.getMessage("common.cancel_btn"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        this.cancelButton.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        this.cancelButton.setToolTipText(this.getMessage("cpl.cancel_btn.tooltip"));
        this.decisionPanel.add(this.cancelButton);
        applyButton = this.makeButton("common.apply_btn");
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.applyBtnActionPerformed(actionEvent);
            }
        });
        applyButton.setToolTipText(this.getMessage("cpl.apply_btn.tooltip"));
        this.decisionPanel.add(applyButton);
        JButton[] jButtonArray = new JButton[]{this.okButton, this.cancelButton, applyButton};
        DialogTemplate.resizeButtons(jButtonArray);
        this.getContentPane().add((Component)this.decisionPanel, "South");
        this.getContentPane().invalidate();
        this.getRootPane().setDefaultButton(this.okButton);
        tabbedPane.addTab(this.getMessage("control.panel.advanced"), this.advancedPanel);
        applyButton.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ControlPanel.this.resetBounds();
            }
        });
        if (OSType.isMac()) {
            ControlPanel.setOpacityOfAllComponents(generalPanel);
            if (this.updatePanelImpl.getPanel() != null) {
                ControlPanel.setOpacityOfAllComponents(this.updatePanelImpl.getPanel());
            }
            ControlPanel.setOpacityOfAllComponents(this.javaPanel);
            ControlPanel.setOpacityOfAllComponents(this.securityPanel);
            ControlPanel.setOpacityOfAllComponents(this.advancedPanel);
        }
        tabbedPane.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("font")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ControlPanel.this.resetBounds();
                }
            });
        }
    }

    public void resetBounds() {
        this.pack();
        UIFactory.placeWindow(this);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.apply();
        this.exitForm();
    }

    private void applyBtnActionPerformed(ActionEvent actionEvent) {
        this.apply();
        ControlPanel.enableApplyButton(false);
    }

    private void apply() {
        this.updatePanelImpl.saveSettings();
        SecurityProperties.saveLevelProperites();
        SecurityProperties.JavaEnableManager javaEnableManager = SecurityProperties.prepareToSaveJavaEnabled();
        javaEnableManager.saveIfEnabling();
        boolean bl = javaEnableManager.isJavaEnableChanging() || !this._applyButtonAction;
        AdvancedProperties.NewPluginEnableManager newPluginEnableManager = AdvancedProperties.prepareToSaveNewPluginEnabled();
        newPluginEnableManager.saveIfChanging(bl);
        boolean bl2 = newPluginEnableManager.isDialogShown();
        int n = Platform.get().applyBrowserSettings();
        if (!javaEnableManager.isJavaEnableChanging()) {
            switch (n) {
                case 1: {
                    String string = ResourceManager.getString("common.ok_btn");
                    String string2 = ResourceManager.getString("common.cancel_btn");
                    ToolkitStore.getUI().showMessageDialog(null, null, 3, null, ResourceManager.getMessage("browser.settings.alert.text"), null, null, string, string2, null);
                    break;
                }
                case 2: {
                    if (this._applyButtonAction && !bl2) {
                        ToolkitStore.getUI().showMessageDialog(null, null, 1, ResourceManager.getMessage("browser.settings.success.caption"), ResourceManager.getMessage("browser.settings.success.masthead"), ResourceManager.getMessage("browser.settings.success.text"), null, null, null, null);
                        break;
                    }
                }
                case 3: {
                    if (!this._applyButtonAction) break;
                    String string = ResourceManager.getString("common.ok_btn");
                    String string3 = ResourceManager.getString("common.detail.button");
                    ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getMessage("browser.settings.fail.caption"), ResourceManager.getMessage("browser.settings.fail.masthead"), ResourceManager.getMessage("browser.settings.fail.ie.text"), null, string, string3, null);
                    break;
                }
                case 4: {
                    if (!this._applyButtonAction) break;
                    String string = ResourceManager.getString("common.ok_btn");
                    String string4 = ResourceManager.getString("common.detail.button");
                    ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getMessage("browser.settings.fail.caption"), ResourceManager.getMessage("browser.settings.fail.masthead"), ResourceManager.getMessage("browser.settings.fail.moz.text"), null, string, string4, null);
                    break;
                }
            }
        }
        javaEnableManager.saveIfDisabling();
        boolean bl3 = AdvancedProperties.saveRoamingProfileSettings();
        if (bl3) {
            Config.setInstance(new JCPConfig(this));
        }
        this.advancedPanel.reset();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.exitForm();
    }

    private void exitForm() {
        this._sil.removeSingleInstanceListener(this);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(final String[] stringArray) {
        InstallCommands installCommands;
        Object object;
        int n;
        int n2;
        boolean bl;
        boolean bl2 = Config.getOSName().indexOf("Windows") != -1;
        boolean bl3 = bl = Config.getOSName().indexOf("OS X") != -1;
        if (bl2) {
            ServiceManager.setService(33024);
        } else if (bl) {
            ServiceManager.setService(40960);
        } else {
            ServiceManager.setService(36864);
        }
        if (stringArray.length == 2 && stringArray[0].equals("-setSecurityLevel")) {
            try {
                n2 = Integer.parseInt(stringArray[1]);
                if (n2 > 0 && n2 <= 2) {
                    n = 2 - n2;
                    object = new InstallHints(1);
                    ((InstallHints)object).setCustomSecurityLevel(n);
                    RegisterDeploy.register((InstallHints)object);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignoredException(numberFormatException);
            }
            finally {
                System.exit(0);
            }
        }
        if (stringArray.length == 1 && stringArray[0].equals("-getSecurityLevel")) {
            Config.setInstance(new ClientConfig());
            n2 = SecuritySettings.getSecurityLevelInt();
            System.exit(n2);
        }
        if (stringArray.length == 1 && stringArray[0].equals("-getUserWebJavaStatus")) {
            Config.setInstance(new ClientConfig());
            n2 = -1;
            InstallHints installHints = new InstallHints(2);
            installHints.enableUserWebJavaStatusQuery();
            object = RegisterDeploy.register(installHints);
            n2 = ((InstallCommands)object).getUserWebJavaStatus();
            System.exit(n2);
        }
        if (stringArray.length == 2 && stringArray[0].equals("-getUserPreviousDecisionsExist")) {
            n2 = -1;
            try {
                n = Integer.parseInt(stringArray[1]);
                object = new InstallHints(2);
                ((InstallHints)object).enableUserPreviousDecisionsExistQuery(n);
                installCommands = RegisterDeploy.register((InstallHints)object);
                n2 = installCommands.getUserPreviousDecisionsExist();
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignoredException(numberFormatException);
            }
            finally {
                System.exit(n2);
            }
        }
        if (stringArray.length == 2 && stringArray[0].equals("-clearUserPreviousDecisions")) {
            n2 = -1;
            try {
                int n3 = Integer.parseInt(stringArray[1]);
                object = new InstallHints(2);
                ((InstallHints)object).clearUserPreviousDecisionsQuery(n3);
                installCommands = RegisterDeploy.register((InstallHints)object);
                n2 = installCommands.getClearUserPreviousDecisionsResult();
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignoredException(numberFormatException);
            }
            finally {
                System.exit(n2);
            }
        }
        if (stringArray.length == 1 && stringArray[0].equals("-resetUserPreviousDecisionsDate")) {
            n2 = -1;
            InstallHints installHints = new InstallHints(2);
            installHints.resetUserPrevousDecisionsDate();
            object = RegisterDeploy.register(installHints);
            if (((InstallCommands)object).getInstallStatus() != 1) {
                n2 = 1;
            }
            System.exit(n2);
        }
        if ((stringArray.length == 2 || stringArray.length == 3) && stringArray[0].equals("-systemConfig")) {
            String string = stringArray[1];
            try {
                String string2 = stringArray.length == 3 ? stringArray[2] : null;
                SecuritySettings.setSystemDeploymentProperty(string, string2);
            }
            finally {
                System.exit(0);
            }
        }
        if ((stringArray.length == 2 || stringArray.length == 3) && stringArray[0].equals("-userConfig")) {
            String string = stringArray[1];
            try {
                String string3 = stringArray.length == 3 ? stringArray[2] : null;
                object = new PluginClientConfig();
                Config.setInstance((Config)object);
                Config.setStringProperty(string, string3);
                ((ClientConfig)object).storeConfig();
            }
            finally {
                System.exit(0);
            }
        }
        if (stringArray.length == 1 && stringArray[0].equals("-store")) {
            Config.setInstance(new JCPStoreConfig());
            ControlPanel.initTrace();
            Platform.get().setJavaPluginSettings(Config.getBooleanProperty("deployment.jpi.mode.new"));
            Platform.get().applyBrowserSettings();
            System.exit(0);
        }
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + (i > 0 ? " " : "") + stringArray[i];
        }
        if (SingleInstanceManager.isServerRunning(JCP_ID) && SingleInstanceManager.connectToServer(string)) {
            System.exit(0);
        }
        final ControlPanel controlPanel = new ControlPanel();
        if (stringArray.length == 2 && stringArray[0].equals("-tab")) {
            if (stringArray[1].equals("about")) {
                ControlPanel.showAbout(controlPanel);
                System.exit(0);
            }
            int n4 = ControlPanel.getTabIndex(stringArray[1]);
            tabbedPane.setSelectedIndex(n4);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                controlPanel.setVisible(true);
                controlPanel.setResizable(false);
                if (stringArray.length == 1 && stringArray[0].equals("-viewer") && generalPanel.cacheViewBtn.isEnabled()) {
                    generalPanel.viewBtnAction();
                }
            }
        });
    }

    public void newActivation(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].startsWith("-tab")) {
            String string = stringArray[0].substring(4).trim();
            if (string.equals("about")) {
                ControlPanel.showAbout(this);
            } else {
                tabbedPane.setSelectedIndex(ControlPanel.getTabIndex(string));
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ControlPanel.this.setExtendedState(ControlPanel.this.getExtendedState() & 0xFFFFFFFE);
                ControlPanel.this.toFront();
            }
        });
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    public static void showPanel(JPanel jPanel) {
        tabbedPane.setSelectedComponent(jPanel);
    }

    public static void showPanel(String string) {
        int n = ControlPanel.getTabIndex(string);
        if (n >= 0) {
            tabbedPane.setSelectedIndex(n);
        }
    }

    private static int getTabIndex(String string) {
        boolean bl;
        int n = 0;
        String string2 = string.trim();
        UpdatePanelImpl updatePanelImpl = UpdatePanelFactory.getInstance();
        boolean bl2 = bl = updatePanelImpl.getPanel() != null;
        if (string2.equals("general")) {
            n = 0;
        } else if (string2.equals("update")) {
            if (bl) {
                n = 1;
            }
        } else if (string2.equals("java")) {
            n = bl ? 2 : 1;
        } else if (string2.equals("security")) {
            n = bl ? 3 : 2;
        } else if (string2.equals("advanced")) {
            n = bl ? 4 : 3;
        }
        return n;
    }

    private static void initTrace() {
        if (Config.getBooleanProperty("deployment.trace")) {
            File file = new File(Config.getStringProperty("deployment.user.logdir"));
            if (file.exists() && file.isDirectory()) {
                String string = Config.getStringProperty("deployment.user.logfile");
                boolean bl = Config.getBooleanProperty("deployment.user.logfile.append");
                FileTraceListener fileTraceListener = new FileTraceListener(new File(file, string), bl);
                Trace.addTraceListener(fileTraceListener);
            }
            Trace.redirectStdioStderr();
            Trace.setEnabled(TraceLevel.BASIC, true);
            Trace.setEnabled(TraceLevel.TEMP, true);
            Trace.initDone();
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getMnemonic(string));
        return jButton;
    }

    public static void propertyHasChanged() {
        ControlPanel.enableApplyButton(true);
    }

    public static void propertyChanged(boolean bl) {
        ControlPanel.enableApplyButton(bl);
    }

    static void setOpacityOfAllComponents(JComponent jComponent) {
        Component[] componentArray;
        if (jComponent == null || jComponent instanceof JScrollPane) {
            return;
        }
        jComponent.setOpaque(false);
        for (Component component : componentArray = jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ControlPanel.setOpacityOfAllComponents((JComponent)component);
        }
    }

    private static void enableApplyButton(boolean bl) {
        if (applyButton != null) {
            applyButton.setEnabled(bl);
        }
        if (generalPanel != null) {
            generalPanel.enableViewButton(!bl);
        }
    }

    private static void checkPreferredSizes(Component component) {
        Dimension dimension = component.getPreferredSize();
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                ControlPanel.checkPreferredSizes(component2);
            }
        }
    }

    private static void showAbout(ControlPanel controlPanel) {
        new AboutDialog(controlPanel, true).setVisible(true);
    }

    static {
        Environment.setEnvironmentType(2);
        DeployUIManager.setLookAndFeel();
    }
}

