/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2002;

public class DataSogei {
    int fieldGiorno = 0;
    int fieldAnno = 0;
    int fieldMese = 0;
    boolean fieldOk = false;
    int fieldGiuliano = 0;
    boolean fieldBisestile = false;
    int[] gMesi = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    int[] gMesiGiuliani = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    int fieldRc = 0;
    String fieldDescrizione = "";
    private long fieldGiulianoAnno = 0L;
    public int MAX_ANNO = 2005;
    public int MIN_ANNO = 1870;

    public DataSogei(String data) {
        try {
            this.controllo(data);
        }
        catch (Exception exception) {
            this.setOk(false);
            this.setRc(this.getRc() + 16);
            this.setDescrizione(String.valueOf(this.getDescrizione()) + "Errore eccezionale ");
        }
    }

    public DataSogei(String data, int minAnno, int maxAnno) {
        try {
            this.MIN_ANNO = minAnno;
            this.MAX_ANNO = maxAnno;
            this.controllo(data);
        }
        catch (Exception exception) {
            this.setOk(false);
            this.setRc(this.getRc() + 16);
            this.setDescrizione(String.valueOf(this.getDescrizione()) + "Errore eccezionale ");
        }
    }

    private void controllo(String data) {
        this.setOk(true);
        if (data.trim().length() != 6 && data.trim().length() != 8) {
            this.setOk(false);
            this.setRc(this.getRc() + 1);
            this.setDescrizione(String.valueOf(this.getDescrizione()) + "Formato errato ");
        } else {
            if (data.length() == 6) {
                this.setAnno(Integer.parseInt(data.substring(4, data.length())) + 1900);
            } else {
                this.setAnno(Integer.parseInt(data.substring(4, data.length())));
            }
            if (this.getAnno() < this.MIN_ANNO) {
                this.setOk(false);
                this.setRc(this.getRc() + 2);
                this.setDescrizione(String.valueOf(this.getDescrizione()) + "Anno antecedente al 1870 ");
            }
            if (this.getAnno() > this.MAX_ANNO) {
                this.setOk(false);
                this.setRc(this.getRc() + 2);
                this.setDescrizione(String.valueOf(this.getDescrizione()) + "Anno errato ");
            }
            this.setMese(Integer.parseInt(data.substring(2, 4)));
            this.setGiorno(Integer.parseInt(data.substring(0, 2)));
            if (this.getMese() > 12 || this.getMese() < 1) {
                this.setOk(false);
                this.setRc(this.getRc() + 4);
                this.setDescrizione(String.valueOf(this.getDescrizione()) + "Mese errato ");
            } else {
                this.setBisestile(false);
                if (this.getAnno() % 4 == 0) {
                    if (this.getAnno() % 100 == 0) {
                        if (this.getAnno() % 400 == 0) {
                            this.setBisestile(true);
                            this.gMesi[1] = this.gMesi[1] + 1;
                        }
                    } else {
                        this.setBisestile(true);
                        this.gMesi[1] = this.gMesi[1] + 1;
                    }
                }
                if (this.getGiorno() > this.gMesi[this.getMese() - 1] || this.getGiorno() < 1) {
                    this.setOk(false);
                    this.setRc(this.getRc() + 8);
                    this.setDescrizione(String.valueOf(this.getDescrizione()) + "Giorno errato ");
                }
                this.setGiuliano(this.gMesiGiuliani[this.getMese() - 1] + this.getGiorno());
                if (this.getMese() > 2 && this.getBisestile()) {
                    this.setGiuliano(this.getGiuliano() + 1);
                }
                int anniDif = this.fieldAnno - 1941;
                this.fieldGiulianoAnno = (long)((double)anniDif * 365.25) + (long)this.fieldGiuliano;
            }
        }
    }

    public int getAnno() {
        return this.fieldAnno;
    }

    public boolean getBisestile() {
        return this.fieldBisestile;
    }

    public String getDescrizione() {
        if (this.fieldDescrizione == null) {
            try {
                this.fieldDescrizione = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating descrizioneproperty.");
            }
        }
        return this.fieldDescrizione;
    }

    public int getGiorno() {
        return this.fieldGiorno;
    }

    public int getGiuliano() {
        return this.fieldGiuliano;
    }

    public long getGiulianoAnno() {
        return this.fieldGiulianoAnno;
    }

    public int getMese() {
        return this.fieldMese;
    }

    public boolean getOk() {
        return this.fieldOk;
    }

    public int getRc() {
        return this.fieldRc;
    }

    public void setAnno(int anno) {
        this.fieldAnno = anno;
    }

    public void setBisestile(boolean bisestile) {
        this.fieldBisestile = bisestile;
    }

    public void setDescrizione(String descrizione) {
        this.fieldDescrizione = descrizione;
    }

    public void setGiorno(int giorno) {
        this.fieldGiorno = giorno;
    }

    public void setGiuliano(int giuliano) {
        this.fieldGiuliano = giuliano;
    }

    public void setMese(int mese) {
        this.fieldMese = mese;
    }

    public void setOk(boolean ok) {
        this.fieldOk = ok;
    }

    public void setRc(int rc) {
        this.fieldRc = rc;
    }
}

